﻿(function () {
    angular.module("WizdomMobileModule").run(["settingsApi",
        function (settingsApi) {

            // Used to alternate the main navigation in app shell with custom links from backend.
            settingsApi.getSettings('navigation').then(function (response) {
                var tabs = response.tabs;
                if (tabs) {
                    var order = "";
                    var enabled = "";
                    for (let i = 0; i < tabs.length; i++) {
                        order = order + (tabs[i].order ? tabs[i].order : i);
                        enabled = enabled + (tabs[i].disabled ? '0' : '1');
                        if (tabs[i].altUrl) {
                            try {
                                window.invokeCSharpAction(tabs[i].appShellUrlMethod + ':' + tabs[i].altUrl);
                            } catch {
                                console.log(tabs[i].appShellUrlMethod + ':' + tabs[i].altUrl);
                            }

                        } else if (tabs[i].defaultName.toLowerCase() === 'menu' && !tabs[i].altUrl) {

                            if (typeof window.invokeCSharpAction === 'function') {
                                settingsApi.getSettings('AppMenuBuilder').then(function (response) {
                                    var firstTopLevelItem = response[0];
                                    window.invokeCSharpAction('setmenuurl:' + '#!/menu/' + encodeURI(firstTopLevelItem.item));
                                });
                            } else {
                                console.log(tabs[i].appShellUrlMethod + ':' + tabs[i].altUrl);
                            }
                        }
                    }
                    if (typeof window.invokeCSharpAction === 'function') {
                        window.invokeCSharpAction('setbottomsortorder:' + order);
                        window.invokeCSharpAction('setenabledbottombuttons:' + enabled);
                    } else {
                        console.log('setbottomsortorder:' + order);
                        console.log('setenabledbottombuttons:' + enabled);
                    }
                }
            });
        }
    ]);
})();