﻿(function () {

    angular.module("WizdomMobileModule").controller("newsNotificationController", newsNotificationController);
    newsNotificationController.$inject = ["$scope", "$timeout", "$modal", "$http", "wcmStarterHttpApi", "settingsApi", "contextInfo"];
    function newsNotificationController($scope, $timeout, $modal, $http, httpApi, settingsApi, contextInfo) {
        var vm = this;

        // Properties
        vm.newsNotificationSettings;
        vm.sharePointModel = null;
        vm.saving = false;
        

        // Load settings
        settingsApi.getSettings('NewsNotificationSettings').then(function (response) {
            vm.newsNotificationSettings = response;
        });

        // Public methods
        vm.createWebHook = createWebHook;
        vm.deleteWebHook = deleteWebHook;
        vm.saveSettings = saveSettings;

        // Private methods
        function initialize() {
            // Load web lists
            getCurrentListsFromWeb();

        }
        initialize();

        function getCurrentListsFromWeb() {
            httpApi.get(contextInfo.appUrl + '/api/newsnotification/getcurrentlistsfromweb').then(function (response) {
                vm.sharePointModel = response;
            });
        }

        function createWebHook() {
            httpApi.post(contextInfo.appUrl + '/api/newsnotification/createwebhook/' + vm.selectedSharePointList).then(function (response) {
                // do something
                console.log(response);
            }).catch(function (e) {
                console.log(e);
            });
        }

        function deleteWebHook(id, listId) {
            if (confirm("Are you sure you want to delete this web hook?")) {
                httpApi.delete(contextInfo.appUrl + '/api/newsnotification/deletewebhook/' + id + '/' + listId).then(function (response) {
                    // do something
                    console.log(response);
                }).catch(function (e) {
                    console.log(e);
                });
            }
        }

        function saveSettings(componentName, settings) {
            vm.saving = true;
            settingsApi.saveSettings(componentName, settings).then(function () {
                // Timeouts for UX actually see the saving messaged
                $timeout(function () {
                    vm.saving = false;
                }, 1000);
            }, function () {
                // handle errors?
            });
        }

    }
})();