﻿(function () {
    angular.module("WizdomMobileModule").controller("ModulAdminController", ModulAdminController);

    ModulAdminController.$inject = ["$scope", "administrationApi", "guidGenerator", "wcmStarterSettingsApi", "$timeout", "log"];

    function ModulAdminController($scope, adminApi, guidGenerator, wcmStarterSettingsApi, $timeout, log) {
        $scope.progress = 0;
        $scope.working = false;
        $scope.done = false;
        $scope.statusMsg = '';

        //wcmStarterSettingsApi.getSettings().then(function (stg) {
        //    $scope.spHostUrl = stg.spHostUrl;
        //    log("Settings are loaded!")
        //});

        $scope.install = function () {
            $scope.progress = 0;
            $scope.working = true;
            $scope.done = false;
            var processId = guidGenerator.newGuid(),
                 pinfo = { percent: 0, totalSteps: 0, currentStep: 0, message: '', errorMessage: '' };
            getStatus(processId, pinfo);

            adminApi.install(processId).then(function () {
                log("Calling install operation!");
                $timeout(function () {
                    $scope.working = false;
                    $scope.done = true;
                    log("Done calling install operation!");
                }, 500);
            }, function (error) {
                $scope.working = false;
                $scope.statusMsg = "Error";
                log("Error when calling install operation!");
            });
        }

        $scope.installWizdom = function () {
            $scope.progress = 0;
            $scope.working = true;
            $scope.done = false;
            var processId = guidGenerator.newGuid(),pinfo = { percent: 0, totalSteps: 0, currentStep: 0, message: '', errorMessage: '' };
            getStatus(processId, pinfo);

            adminApi.installWizdom(processId, $scope.wizdomProjectName).then(function () {
                log("Calling install Wizdom operation!");
                $timeout(function () {
                    $scope.working = false;
                    $scope.done = true;
                    log("Done calling install Wizdom operation!");
                }, 1000);
            }, function (error) {
                $scope.working = false;
                $scope.statusMsg = "Error";
                log("Error when calling install Wizdom operation!");
            });
        }

        $scope.createWizdomProject = function () {
            $scope.progress = 0;
            $scope.working = true;
            $scope.done = false;
            var processId = guidGenerator.newGuid(),
                pinfo = { percent: 0, totalSteps: 0, currentStep: 0, message: '', errorMessage: '' };
            getProjectStatus(processId, pinfo);

            var wizdomProject = {
                siteName: $scope.wizdomProjectName,
                siteTypeId: 4,
                metadata: [
                    {
                        definitionName: "StartDate",
                        value: new Date()
                    }
                ]};

            adminApi.createWizdomProject(processId, wizdomProject).then(function () {
                log("Calling Create Wizdom project operation!");
                $timeout(function () {
                    $scope.working = false;
                    $scope.done = true;
                    log("Done calling Create Wizdom project operation!");
                }, 500);
            }, function (error) {
                $scope.working = false;
                $scope.statusMsg = "Error";
                log("Error when calling Create Wizdom project operation!");
            });
        }

        $scope.createSpSite = function () {
            $scope.progress = 0;
            $scope.working = true;
            $scope.done = false;
            var processId = guidGenerator.newGuid(), pinfo = { percent: 0, totalSteps: 0, currentStep: 0, message: '', errorMessage: '' };
            getProjectStatus(processId, pinfo);

            adminApi.createSpSite(processId, $scope.wizdomProjectName).then(function () {
                log("Calling createSpSite operation!");
                $timeout(function () {
                    $scope.working = false;
                    $scope.done = true;
                    log("Done calling createSpSite operation!");
                }, 500);
            }, function (error) {
                $scope.working = false;
                $scope.statusMsg = "Error";
                log("Error when calling createSpSite operation!");
            });
        }

        $scope.resetcache = function () {
            adminApi.resetcache().then(function (data) {
                log("reset cache:" + data);
            });
        }

        $scope.testWebHook = function () {
            log("Call webhook!")
            adminApi.testWebHook().then(function (data) {
                log("Webhook called!")
            },
            function (error) {
                log(error);
            }
            );

        }

        $scope.callLogOperation = function () {
            $scope.progress = 0;
            $scope.working = true;
            $scope.done = false;
            var processId = guidGenerator.newGuid(),
                 pinfo = { percent: 0, totalSteps: 0, currentStep: 0, message: '', errorMessage: '' };
            getStatus(processId, pinfo);

            adminApi.callLogOperation(processId).then(function (data) {
                log("Calling log operation!");
                $timeout(function () {
                    $scope.working = false;
                    $scope.done = true;
                    log("Done calling log operation!");
                }, 500);
            }, function (error) {
                $scope.working = false;
                $scope.statusMsg = "Error";
                log("Error when calling log operation!");
            });
        }

        var getStatus = function (processId, pinfo) {
           
            $scope.progress = pinfo.percent * 1;
            $scope.statusMsg = pinfo.message;
            if ($scope.working) {
                if (pinfo.errorMessage.length > 0) {
                    $scope.statusMsg = 'Error:' + pinfo.errorMessage;
                } else if (pinfo.percent * 1 < 100) {
                    // process update
                    $timeout(function () {
                        adminApi.getApplyStatus(processId)
                            .then(function (pinfo) {
                                getStatus(processId, pinfo);
                            });
                    }, 500);
                }
            }
        };

        var getProjectStatus = function (processId, pinfo) {

            $scope.progress = pinfo.percent * 1;
            $scope.statusMsg = pinfo.message;
            if ($scope.working) {
                if (pinfo.errorMessage.length > 0) {
                    $scope.statusMsg = 'Error:' + pinfo.errorMessage;
                } else if (pinfo.percent * 1 < 100) {
                    // process update
                    $timeout(function () {
                        adminApi.getProjectStatus(processId)
                            .then(function (percent) {
                                pinfo.percent = percent;
                                getProjectStatus(processId, pinfo);
                            });
                    }, 500);
                }
            }
        };

    }

})();