﻿(function () {

    angular.module("WizdomMobileModule").controller("customPageAdminController", customPageAdminController);
    customPageAdminController.$inject = ["$scope", "$window", "$modal", "$timeout", "settingsApi"];
    function customPageAdminController($scope, $window, $modal, $timeout, settingsApi) {

        var vm = this;

        // Properties
        vm.rowLimit = 10;
        vm.newPageobj = {};
        vm.showEditMode = false;

        // Load settings
        settingsApi.getSettings('customPages').then(function (response) {
            vm.customPagesSettings = response;
            vm.customPagesSettings.customPages = vm.customPagesSettings.customPages || [];
        });

        // Public methods
        vm.addPage = addPage;
        vm.editPage = editPage;
        vm.deletePage = deletePage;

        function addPage() {
            $modal.open({
                templateUrl: 'WizdomMobileModule/App_Admin/Administration/Modules/CustomPages/Templates/CustomPagesAddTemplate.html',
                controller: 'customPageAddController as customPageAddCtrl',
                windowClass: 'bootstrap-wrapper',
                resolve: {
                    editPageObjMaster: function () { return null; }
                }
            }).result.then(function (data) {
                vm.customPagesSettings.customPages.push(data);
                vm.saveSettings();
            });
        };

        function editPage(page) {
            $modal.open({
                templateUrl: 'WizdomMobileModule/App_Admin/Administration/Modules/CustomPages/Templates/CustomPagesEditTemplate.html',
                controller: 'customPageEditController as customPageEditCtrl',
                windowClass: 'bootstrap-wrapper',
                resolve: {
                    editPageObjMaster: function () { return page; }
                }
            }).result.then(function (data) {
                var index = vm.customPagesSettings.customPages.indexOf(data.editPageObjMaster);
                angular.copy(data.editPageObj, vm.customPagesSettings.customPages[index]);
                vm.saveSettings();
            });
        };

        function deletePage(page) {
            var confirm = $window.confirm("Are you absolutely sure you want to delete?");

            if (confirm) {
                var index = vm.customPagesSettings.customPages.indexOf(page);
                vm.customPagesSettings.customPages.splice(index, 1);
                vm.saveSettings();
            }
        };

        vm.saveSettings = function (componentName, settings) {
            vm.saving = true;
            settingsApi.saveSettings(componentName, settings).then(function () {
                // Timeouts for UX actually see the saving messaged
                $timeout(function () {
                    vm.saving = false;
                }, 1000);
            }, function () {
                // handle errors?
            });
        }
    }

})();