﻿(function () {
    
    angular.module("WizdomMobileModule").controller("cacheAdminController", cacheAdminController);

    cacheAdminController.$inject = ["$scope", "wcmStarterHttpApi", "wcmStarterSettingsApi"];
    function cacheAdminController($scope, httpApi, wcmStarterSettingsApi) {
        var sUrl = "/api/administration";
        $scope.dataReady = false;

        //wcmStarterSettingsApi.getSettings().then(function (data) {
        //    $scope.stg = data;
        //});

        $scope.saveSettings = function () {
            $scope.saving = true;
            //wcmStarterSettingsApi.saveSettings($scope.stg).then(function () {
            //    $scope.resetcache();
            //    $scope.saving = false;
            //});
        }

        $scope.deleteSearchTerm = function (index) {
            $scope.stg.knowWhoWarmUpSearchTerms.splice(index, 1);
        }
        $scope.addSearchTerm = function () {
            $scope.addingNewSearchTerm = true;
        }
        $scope.saveSearchTerm = function () {
            var st = angular.copy($scope.newSearchTerm);
            if (st) {
                $scope.newSearchTerm = '';
                $scope.stg.knowWhoWarmUpSearchTerms.push(st);
                $scope.newFieldError = false;
                $scope.addingNewSearchTerm = false;
            } else {
                $scope.newFieldError = true;
            }
        }


        $scope.install = function () {
            initWokringVars();
            httpApi.post(sUrl + "/install").then(function () {
            });
        }

        $scope.resetcache = function () {
            initWokringVars();
            httpApi.get(sUrl + "/resetcache").then(function (data) {
                //console.log(data);
            });
        }

        $scope.deleteCacheItem = function (key) {
            httpApi.get(sUrl + "/deletecacheitem/?key=" + encodeURIComponent(key)).then(function (deleted) {
                if (deleted) {
                    $scope.getCacheInfo();
                }
            });
        }
        $scope.logCachedObject = function (key) {
            if (window.console && window.console.log) {
                httpApi.get(sUrl + "/getcacheitem/?key=" + encodeURIComponent(key)).then(function (data) {
                    console.log(key, data);
                });
            }
        }

        $scope.getCacheSize = function () {
            initWokringVars();
            $scope.loadingCacheData = true;
            httpApi.get(sUrl + "/getcachesize").then(function (data) {
                $scope.loadingCacheData = false;
                $scope.dataReady = true;
                $scope.cacheSize = data;
                $scope.cacheInfo.data = [];
            });
        }

        $scope.cacheInfo = { data: [], sortReverse: false, sortColumnName: 'key', sortType: function (item) { return item['key']; }, itemsPrPage: 20, currentPage: 1 };
        $scope.getCacheInfo = function () {
            initWokringVars();
            $scope.loadingCacheData = true;
            httpApi.get(sUrl + "/getcacheinfo").then(function (data) {
                $scope.loadingCacheData = false;
                $scope.dataReady = true;
                $scope.cacheInfo.data = data;
                var len = data.length;
                $scope.cacheSize = 0;
                for (var i = 0; i < len; i++) {
                    $scope.cacheSize += $scope.cacheInfo.data[i].value;
                }
            });
        }
        $scope.setSort = function (obj, propName) {
            obj.sortReverse = !obj.sortReverse;
            obj.sortColumnName = propName;
            obj.sortType = function (item) {
                return item[propName];
            }
        }



        function initWokringVars() {
            $scope.dataReady = false;
            $scope.loadingCacheData = false;
        }

    }
    
})();