(function () {
    angular.module('WizdomMobileModule').controller('welcomeController', ['$scope', '$window', '$http', 'settingsApi',
        function ($scope, $window, $http, settingsApi) {
            
            $scope.visible = true;
            $scope.currentUserObj = {};
            $scope.currentUserObj.ready = false;
            var storageKey = "welcomeSession";

            settingsApi.getSettings('Welcome').then(function (response) {
                $scope.settings = response;

                // check if settings available
                if (Object.keys($scope.settings).length !== 0 && $scope.settings.constructor === Object) {
                    if ($scope.settings.selectedType.toLowerCase() === 'custom banner') {
                        $scope.settings.imageStyle = $scope.settings.imageStyle || {};
                        retrieveCustomBannerProperties();
                        $scope.visible = true;
                    } else if ($scope.settings.selectedType.toLowerCase() === 'personal banner') {
                        var welcomeSession = $window.sessionStorage.getItem(storageKey);
                        if (welcomeSession === null) {
                            retrieveUserProfileProperties();
                            $scope.visible = true;
                        } else {
                            $scope.visible = false;
                        }
                    } else {
                        $scope.visible = false;
                    }
                }
                else {
                    $scope.visible = false;
                }
                
            });
    
            function retrieveUserProfileProperties() {
                return $http({
                    method: 'GET',
                    url: $window._spPageContextInfo.webAbsoluteUrl + '/_api/SP.UserProfiles.PeopleManager/GetMyProperties',
                    headers: {
                        'Accept': 'application/json;odata=verbose'
                    }
                }).then(function (response) {
                    $scope.currentUserObj = response.data.d.UserProfileProperties.results.reduce(function (map, obj) {
                        map[obj.Key] = obj.Value;
                        return map;
                    }, {});
                    $scope.currentUserObj.ready = true;
    
                    $window.sessionStorage.setItem(storageKey, false);
                });
            }

            function retrieveCustomBannerProperties() {
                return $http({
                    method: 'GET',
                    url: $window._spPageContextInfo.webAbsoluteUrl + ''
                });
            }
        }]
    );
})();