﻿(function () {
    angular.module("WizdomMobileModule").factory("pushRegistrationsService", pushRegistrationsService);

    pushRegistrationsService.$inject = ["wcmStarterHttpApi", "$window", "$q", "settingsApi"];

    function pushRegistrationsService(httpApi, $window, $q, settingsApi) {
        var wizdomCall = "wizdom://";
        var service = {
            baseUrl: wizdomCall + "api/wizdom/push",
            updateAllRegistrations: function () {
                return httpApi.post(this.baseUrl + "/UpdateAllRegistrations");
            },
            registerDevice: function (platform, deviceToken) {
                var deferred = $q.defer();
                settingsApi.getSettings('NewsNoticeboard').then(function (response) {
                    if (typeof response !== 'undefined' && response.channelSetId) {
                        deferred.resolve(response);
                    }
                    else {
                        deferred.reject("Error loading settings.");
                    }
                });

                return deferred.promise.then(function (response) {
                    if (platform === 'apple') deviceToken = deviceToken.replace('>', '').replace('<', '').replace(/ /g, '');
                    return httpApi.post("wizdom://api/wizdom/push/RegisterDevice/" + platform + "/" + response.channelSetId, deviceToken);
                });
            },
            unregisterDevice: function (deviceToken) {
                return deferred.promise.then(function (response) {
                    deviceToken = deviceToken.replace('>', '').replace('<', '').replace(/ /g, '');
                    return httpApi.post("wizdom://api/wizdom/push/unregisterDevice", deviceToken);
                });
            },
            getUserPushEvents: function (channelsetId) {
                return httpApi.get(this.baseUrl + "/UserPushEvents/" + channelsetId);
            },

            // int PrincipalID 
            // int ChannelSetID 
            // int ChannelID 
            // int EventType 
            // bool Enabled 

            //[
            //    {
            //     "PrincipalID" : 0, // ignored on server ANY VAL
            //     "ChannelSetID": 1,
            //     "ChannelID"   : 1,
            //     "EventType"   : 0, // 0: item edited, 4: comment created
            //     "Enabled"     : true
            //   }
            //]

            setUserPushEvents: function (channelsetId, events) {
                return httpApi.post(this.baseUrl + "/UserPushEvents/" + channelsetId, events);
            },
            getGlobalPushEventDefaults: function () {
                return httpApi.get(this.baseUrl + "/GlobalPushEventDefaults");
            },
            setGlobalPushEventDefaults: function (defaults) {
                return httpApi.post(this.baseUrl + "/GlobalPushEventDefaults", defaults);
            },
            //users global defualts... fallback
            getUserPushEventDefaults: function () {
                return httpApi.get(this.baseUrl + "/UserPushEventDefaults");
            },
            setUserPushEventDefaults: function (defaults) {
                return httpApi.post(this.baseUrl + "/UserPushEventDefaults", defaults);
            },
            // array af key og value item created..
            getPushEventTypes: function () {
                return httpApi.get(this.baseUrl + "/PushEventTypes");
            }
        };

        $window.pushService = service;
        return service;
    }
   
})();