﻿(function () {
    angular.module("WizdomMobileModule").filter("customTranslate", customTranslate);
    customTranslate.$inject = ["webApiProxy", "contextInfo"];
    function customTranslate(webApiProxy, contextInfo) {
        return function (translationId, interpolateParams, interpolation) {
            var arguments = angular.isArray(interpolateParams) ? interpolateParams :
                angular.isObject(interpolateParams) ? interpolateParams :
                    angular.isDefined(interpolateParams) ? [interpolateParams] : [];

            var rtnVal = (webApiProxy[contextInfo.language] == null || !webApiProxy[contextInfo.language][translationId]) ? translationId : webApiProxy[contextInfo.language][translationId];
            _.forEach(arguments, function (value, index) {
                var regEx = new RegExp('[{]' + index + '[}]', 'g');
                rtnVal = rtnVal.replace(regEx, value || "");
            });
            return rtnVal;
        }
    }
})();
