﻿(function () {
    angular.module('WizdomMobileModule').directive('socialPanel', socialDirective);

    socialDirective.$inject = ['$http', 'wcmStarterHttpApi', 'contextInfo'];
    function socialDirective($http, wcmStarterHttpApi, contextInfo) {
        return {
            scope: {
                item: '='
            },
            link: function (scope, element, attributes) {
                element.bind('click', function (e) {
                    wcmStarterHttpApi.put(contextInfo.appUrl + '/api/wizdom/noticeboard/1/items/' + scope.item.id + '/actions/setlike', !scope.item.isLiked).then(function (data) {
                        scope.item.isLiked = data.primaryResult.likedByCurrentUser;
                        if(scope.item.isLiked) {
                            scope.item.likes.push({
                                targetID: data.primaryResult.id,
                                principal: data.principals.results[0]
                            })
                        }
                     });
                });
            }
        };
    }
})();