﻿// App.js
(function () {
    // Add Module to Wizdom Angular App
    angular.module("WizdomMobileModule", ['ngAnimate', 'ui.bootstrap', 'angularUtils.directives.dirPagination', 'ui.router', 'mentio']);

    angular.module("WizdomMobileModule").run(["$rootScope", "$state", "$stateParams", "$injector", "$transitions", "$timeout", "$window", "settingsApi",
        function ($rootScope, $state, $stateParams, $injector, $transitions, $timeout, $window, settingsApi) {

            /* Since its very common to access $state in your templates, you need to bind $state to $rootScope 
             * https://github.com/angular-ui/ui-router/wiki/quick-reference#note-about-using-state-within-a-template
             * */
            $rootScope.$state = $state;
            $rootScope.$stateParams = $stateParams;

            // Overwrite meta tags to prevent issues on iOS 10
            var head = document.head;

            var elm = window.document.createElement("META");
            elm.name = "viewport";
            elm.content = 'initial-scale=1, viewport-fit=cover';
            head.appendChild(elm);

            // Used for swipe and transition functions
            var availableStates = ['home', 'news.type', 'noticeboard', 'people'];
            $rootScope.swipeLeft = function () {
                if ($state.current.name === availableStates[0]) {
                    $state.go(availableStates[1], { 'type': 'latest' });
                } else if ($state.params.type === "latest") {
                    $state.go(availableStates[1], { 'type': 'trending' });
                } else if ($state.params.type === "trending") {
                    $state.go(availableStates[2]);
                } else if ($state.current.name === availableStates[2]) {
                    $state.go(availableStates[3]);
                }

            };
            $rootScope.swipeRight = function () {
                if ($state.params.type === "latest") {
                    $state.go(availableStates[0]);
                } else if ($state.params.type === "trending") {
                    $state.go(availableStates[1], { 'type': 'latest' });
                } else if ($state.current.name === availableStates[2]) {
                    $state.go(availableStates[1], { 'type': 'trending' });
                } else if ($state.current.name === availableStates[3]) {
                    $state.go(availableStates[2]);
                }
            };
            $rootScope.historyBack = function () {
                $window.history.back();
            };

            // Transition hooks
            // onBefore, onStart, onExit, onRetain, onEnter, onFinish, onSuccess, and onError
            $transitions.onBefore({}, function (transition) {
                console.log("OnBefore Transition from " + transition.from().name + " to " + transition.to().name);
            });

            $transitions.onEnter({}, function (transition) {
                console.log("OnEnter Transition from " + transition.from().name + " to " + transition.to().name);

                // Always scroll to top
                document.body.scrollTop = document.documentElement.scrollTop = 0;
            });

            $transitions.onSuccess({}, function (transition) {
                console.log("Successful Transition from " + transition.from().name + " to " + transition.to().name);

                // Used to alternate the title in the reserved area of the app shell top, by backend.
                settingsApi.getSettings('navigation').then(function (response) {
                    var titles = response.tabs;
                    var currentState = $state.current.name.split('.')[0].toLowerCase();
                    var toState = transition.to().name.split('.')[0].toLowerCase();

                    function setAltOrFallback(obj) {
                        if (!obj.alt) {
                            var fallbackVal = obj.default;
                        } else fallbackVal = obj.alt;

                        return fallbackVal;
                    }

                    function uppercaseFirstLetter(string) {
                        return string.charAt(0).toUpperCase() + string.slice(1);
                    }

                    if (window.invokeCSharpAction) {
                        var found = false;
                        for (key in titles) {
                            if (currentState === titles[key].defaultName.toLowerCase()) {
                                window.invokeCSharpAction('setTitle:' + setAltOrFallback({ alt: titles[key].altName, default: titles[key].defaultName }));
                                found = true;
                            }
                        }
                        if (!found) window.invokeCSharpAction('setTitle:' + uppercaseFirstLetter(currentState));
                    }
                });
                // Add backbutton on content pages, articles, user detail pages only on iOS devices
                var iOS = !!navigator.platform && /iPad|iPhone|iPod/.test(navigator.platform);
                if (iOS && (transition.to().name === 'home.contentpageviewer' || transition.to().name === 'menu.contentpageviewer' || transition.to().name === 'home.article' || transition.to().name === 'news.type.article' || transition.to().name === 'noticeboard.article' || transition.to().name === 'people.detail' || transition.to().name === 'custompages')) {
                    if (window.invokeCSharpAction) {
                        window.invokeCSharpAction('enableBackBtn');
                    }
                }
                else if (iOS) {
                    if (window.invokeCSharpAction) {
                        window.invokeCSharpAction('disableBackBtn');
                    }
                }

                // SlidePanelView
                var slideViews = ['articles', 'contentpageviewer'];

                function checkSlides(arr, val) {
                    return arr.some(function (arrVal) {
                        return val === arrVal;
                    });
                }
                var slideTo = checkSlides(slideViews, transition.to().name);
                var slideFrom = checkSlides(slideViews, transition.from().name);

                if (slideTo && !slideFrom) {
                    angular.element('#slidePanelView').addClass('slide-view');
                }
            });
        }
    ]);

    if (window["SP"]) {
        window["SP"].SOD.executeOrDelayUntilEventNotified(function () {
            if (console && console.log) { console.log("WizdomMobileModule loaded"); }
            angular.module("Wizdom365").requires.push("WizdomMobileModule");
        }, "Wizdom365Loaded");
    }

    angular.module("WizdomMobileModule").factory("wcmStarterModuleConfiguration", wcmStarterModuleConfiguration);
    function wcmStarterModuleConfiguration() {
        var service = {};

        // Get custom module app url from current script path
        service.appUrl = GetCurrentScriptHost();
        return service;
    };

    function GetCurrentScriptHost() {
        var scriptPath = '';
        try {
            //Throw an error to generate a stack trace
            throw new Error();
        }
        catch (e) {
            if (angular.isDefined(e.sourceURL)) {
                scriptPath = e.sourceURL.match(/http[s]?:\/\/.+\//)[0].replace(/\/dist\//i, "");
            } else {
                //Split the stack trace into each line
                var stackLines = e.stack.split('\n');
                var callerIndex = 0;
                //Now walk though each line until we find a path reference
                for (var i in stackLines) {
                    if (!stackLines[i].match(/http[s]?:\/\//)) continue;
                    callerIndex = Number(i);
                    break;
                }
                scriptPath = stackLines[callerIndex].match(/http[s]?:\/\/.+\//)[0].replace("/dist/", "").replace("/Dist/", "");
            }
        }
        return scriptPath;
    };
})();