// AdminApp.js
(function () {
    // Add Module to Wizdom Angular App
    angular.module("WizdomMobileModule", ['ui.bootstrap', 'ui.router', 'angularUtils.directives.dirPagination', 'ui-iconpicker', 'ui.sortable']);

    if (window["SP"]) {
        window["SP"].SOD.executeOrDelayUntilEventNotified(function () {
            if (console && console.log) { console.log("WizdomMobileModule loaded"); }
            angular.module("Wizdom365").requires.push("WizdomMobileModule");
        }, "Wizdom365Loaded");
    }

    angular.module("WizdomMobileModule").factory("wcmStarterModuleConfiguration", wcmStarterModuleConfiguration);
    function wcmStarterModuleConfiguration() {
        var service = {};

        // Get custom module app url from current script path
        service.appUrl = GetCurrentScriptHost();
        return service;
    };

    function GetCurrentScriptHost() {
        var scriptPath = '';
        try {
            //Throw an error to generate a stack trace
            throw new Error();
        }
        catch (e) {
            if (angular.isDefined(e.sourceURL)) {
                scriptPath = e.sourceURL.match(/http[s]?:\/\/.+\//)[0].replace(/\/dist\//i, "");
            } else {
                //Split the stack trace into each line
                var stackLines = e.stack.split('\n');
                var callerIndex = 0;
                //Now walk though each line until we find a path reference
                for (var i in stackLines) {
                    if (!stackLines[i].match(/http[s]?:\/\//)) continue;
                    callerIndex = Number(i);
                    break;
                }
                scriptPath = stackLines[callerIndex].match(/http[s]?:\/\/.+\//)[0].replace("/dist/", "").replace("/Dist/", "");
            }
        }
        return scriptPath;
    };


})();
(function () {

    var fabricIcon = [
        {
            "iconName": "",
            "iconClass": ""
        },
        {
            "iconName": "12PointStar",
            "iconClass": "ms-Icon ms-Icon--12PointStar"
        },
        {
            "iconName": "6PointStar",
            "iconClass": "ms-Icon ms-Icon--6PointStar"
        },
        {
            "iconName": "AADLogo",
            "iconClass": "ms-Icon ms-Icon--AADLogo"
        },
        {
            "iconName": "Accept",
            "iconClass": "ms-Icon ms-Icon--Accept"
        },
        {
            "iconName": "AccessLogo",
            "iconClass": "ms-Icon ms-Icon--AccessLogo"
        },
        {
            "iconName": "AccessLogoFill",
            "iconClass": "ms-Icon ms-Icon--AccessLogoFill"
        },
        {
            "iconName": "AccountManagement",
            "iconClass": "ms-Icon ms-Icon--AccountManagement"
        },
        {
            "iconName": "Accounts",
            "iconClass": "ms-Icon ms-Icon--Accounts"
        },
        {
            "iconName": "ActivateOrders",
            "iconClass": "ms-Icon ms-Icon--ActivateOrders"
        },
        {
            "iconName": "ActivityFeed",
            "iconClass": "ms-Icon ms-Icon--ActivityFeed"
        },
        {
            "iconName": "Add",
            "iconClass": "ms-Icon ms-Icon--Add"
        },
        {
            "iconName": "AddBookmark",
            "iconClass": "ms-Icon ms-Icon--AddBookmark"
        },
        {
            "iconName": "AddEvent",
            "iconClass": "ms-Icon ms-Icon--AddEvent"
        },
        {
            "iconName": "AddFavorite",
            "iconClass": "ms-Icon ms-Icon--AddFavorite"
        },
        {
            "iconName": "AddFavoriteFill",
            "iconClass": "ms-Icon ms-Icon--AddFavoriteFill"
        },
        {
            "iconName": "AddFriend",
            "iconClass": "ms-Icon ms-Icon--AddFriend"
        },
        {
            "iconName": "AddGroup",
            "iconClass": "ms-Icon ms-Icon--AddGroup"
        },
        {
            "iconName": "AddNotes",
            "iconClass": "ms-Icon ms-Icon--AddNotes"
        },
        {
            "iconName": "AddOnlineMeeting",
            "iconClass": "ms-Icon ms-Icon--AddOnlineMeeting"
        },
        {
            "iconName": "AddPhone",
            "iconClass": "ms-Icon ms-Icon--AddPhone"
        },
        {
            "iconName": "AddTo",
            "iconClass": "ms-Icon ms-Icon--AddTo"
        },
        {
            "iconName": "Admin",
            "iconClass": "ms-Icon ms-Icon--Admin"
        },
        {
            "iconName": "AdminALogo32",
            "iconClass": "ms-Icon ms-Icon--AdminALogo32"
        },
        {
            "iconName": "AdminALogoFill32",
            "iconClass": "ms-Icon ms-Icon--AdminALogoFill32"
        },
        {
            "iconName": "AdminALogoInverse32",
            "iconClass": "ms-Icon ms-Icon--AdminALogoInverse32"
        },
        {
            "iconName": "AdminCLogoInverse32",
            "iconClass": "ms-Icon ms-Icon--AdminCLogoInverse32"
        },
        {
            "iconName": "AdminDLogoInverse32",
            "iconClass": "ms-Icon ms-Icon--AdminDLogoInverse32"
        },
        {
            "iconName": "AdminELogoInverse32",
            "iconClass": "ms-Icon ms-Icon--AdminELogoInverse32"
        },
        {
            "iconName": "AdminLLogoInverse32",
            "iconClass": "ms-Icon ms-Icon--AdminLLogoInverse32"
        },
        {
            "iconName": "AdminMLogoInverse32",
            "iconClass": "ms-Icon ms-Icon--AdminMLogoInverse32"
        },
        {
            "iconName": "AdminOLogoInverse32",
            "iconClass": "ms-Icon ms-Icon--AdminOLogoInverse32"
        },
        {
            "iconName": "AdminPLogoInverse32",
            "iconClass": "ms-Icon ms-Icon--AdminPLogoInverse32"
        },
        {
            "iconName": "AdminSLogoInverse32",
            "iconClass": "ms-Icon ms-Icon--AdminSLogoInverse32"
        },
        {
            "iconName": "AdminYLogoInverse32",
            "iconClass": "ms-Icon ms-Icon--AdminYLogoInverse32"
        },
        {
            "iconName": "Airplane",
            "iconClass": "ms-Icon ms-Icon--Airplane"
        },
        {
            "iconName": "AirplaneSolid",
            "iconClass": "ms-Icon ms-Icon--AirplaneSolid"
        },
        {
            "iconName": "AirTickets",
            "iconClass": "ms-Icon ms-Icon--AirTickets"
        },
        {
            "iconName": "AlarmClock",
            "iconClass": "ms-Icon ms-Icon--AlarmClock"
        },
        {
            "iconName": "Album",
            "iconClass": "ms-Icon ms-Icon--Album"
        },
        {
            "iconName": "AlbumRemove",
            "iconClass": "ms-Icon ms-Icon--AlbumRemove"
        },
        {
            "iconName": "AlertSolid",
            "iconClass": "ms-Icon ms-Icon--AlertSolid"
        },
        {
            "iconName": "AlignCenter",
            "iconClass": "ms-Icon ms-Icon--AlignCenter"
        },
        {
            "iconName": "AlignHorizontalCenter",
            "iconClass": "ms-Icon ms-Icon--AlignHorizontalCenter"
        },
        {
            "iconName": "AlignHorizontalLeft",
            "iconClass": "ms-Icon ms-Icon--AlignHorizontalLeft"
        },
        {
            "iconName": "AlignHorizontalRight",
            "iconClass": "ms-Icon ms-Icon--AlignHorizontalRight"
        },
        {
            "iconName": "AlignJustify",
            "iconClass": "ms-Icon ms-Icon--AlignJustify"
        },
        {
            "iconName": "AlignLeft",
            "iconClass": "ms-Icon ms-Icon--AlignLeft"
        },
        {
            "iconName": "AlignRight",
            "iconClass": "ms-Icon ms-Icon--AlignRight"
        },
        {
            "iconName": "AlignVerticalBottom",
            "iconClass": "ms-Icon ms-Icon--AlignVerticalBottom"
        },
        {
            "iconName": "AlignVerticalCenter",
            "iconClass": "ms-Icon ms-Icon--AlignVerticalCenter"
        },
        {
            "iconName": "AlignVerticalTop",
            "iconClass": "ms-Icon ms-Icon--AlignVerticalTop"
        },
        // {
        //     "iconName": "AllApps",
        //     "iconClass": "ms-Icon ms-Icon--AllApps"
        // },
        // {
        //     "iconName": "AllAppsMirrored",
        //     "iconClass": "ms-Icon ms-Icon--AllAppsMirrored"
        // },
        {
            "iconName": "AnalyticsLogo",
            "iconClass": "ms-Icon ms-Icon--AnalyticsLogo"
        },
        {
            "iconName": "AnalyticsQuery",
            "iconClass": "ms-Icon ms-Icon--AnalyticsQuery"
        },
        {
            "iconName": "AnalyticsReport",
            "iconClass": "ms-Icon ms-Icon--AnalyticsReport"
        },
        {
            "iconName": "AnalyticsView",
            "iconClass": "ms-Icon ms-Icon--AnalyticsView"
        },
        {
            "iconName": "AnchorLock",
            "iconClass": "ms-Icon ms-Icon--AnchorLock"
        },
        {
            "iconName": "Annotation",
            "iconClass": "ms-Icon ms-Icon--Annotation"
        },
        {
            "iconName": "AppIconDefault",
            "iconClass": "ms-Icon ms-Icon--AppIconDefault"
        },
        {
            "iconName": "Archive",
            "iconClass": "ms-Icon ms-Icon--Archive"
        },
        {
            "iconName": "AreaChart",
            "iconClass": "ms-Icon ms-Icon--AreaChart"
        },
        {
            "iconName": "ArrangeBringForward",
            "iconClass": "ms-Icon ms-Icon--ArrangeBringForward"
        },
        {
            "iconName": "ArrangeBringToFront",
            "iconClass": "ms-Icon ms-Icon--ArrangeBringToFront"
        },
        {
            "iconName": "ArrangeByFrom",
            "iconClass": "ms-Icon ms-Icon--ArrangeByFrom"
        },
        {
            "iconName": "ArrangeSendBackward",
            "iconClass": "ms-Icon ms-Icon--ArrangeSendBackward"
        },
        {
            "iconName": "ArrangeSendToBack",
            "iconClass": "ms-Icon ms-Icon--ArrangeSendToBack"
        },
        {
            "iconName": "Arrivals",
            "iconClass": "ms-Icon ms-Icon--Arrivals"
        },
        // {
        //     "iconName": "ArrowDownRight8",
        //     "iconClass": "ms-Icon ms-Icon--ArrowDownRight8"
        // },
        // {
        //     "iconName": "ArrowDownRightMirrored8",
        //     "iconClass": "ms-Icon ms-Icon--ArrowDownRightMirrored8"
        // },
        {
            "iconName": "ArrowTallDownLeft",
            "iconClass": "ms-Icon ms-Icon--ArrowTallDownLeft"
        },
        {
            "iconName": "ArrowTallDownRight",
            "iconClass": "ms-Icon ms-Icon--ArrowTallDownRight"
        },
        {
            "iconName": "ArrowTallUpLeft",
            "iconClass": "ms-Icon ms-Icon--ArrowTallUpLeft"
        },
        {
            "iconName": "ArrowTallUpRight",
            "iconClass": "ms-Icon ms-Icon--ArrowTallUpRight"
        },
        {
            "iconName": "ArrowUpRight",
            "iconClass": "ms-Icon ms-Icon--ArrowUpRight"
        },
        // {
        //     "iconName": "ArrowUpRight8",
        //     "iconClass": "ms-Icon ms-Icon--ArrowUpRight8"
        // },
        // {
        //     "iconName": "ArrowUpRightMirrored8",
        //     "iconClass": "ms-Icon ms-Icon--ArrowUpRightMirrored8"
        // },
        {
            "iconName": "Articles",
            "iconClass": "ms-Icon ms-Icon--Articles"
        },
        {
            "iconName": "Ascending",
            "iconClass": "ms-Icon ms-Icon--Ascending"
        },
        {
            "iconName": "AspectRatio",
            "iconClass": "ms-Icon ms-Icon--AspectRatio"
        },
        {
            "iconName": "AssessmentGroup",
            "iconClass": "ms-Icon ms-Icon--AssessmentGroup"
        },
        {
            "iconName": "AssessmentGroupTemplate",
            "iconClass": "ms-Icon ms-Icon--AssessmentGroupTemplate"
        },
        {
            "iconName": "AssetLibrary",
            "iconClass": "ms-Icon ms-Icon--AssetLibrary"
        },
        {
            "iconName": "Assign",
            "iconClass": "ms-Icon ms-Icon--Assign"
        },
        {
            "iconName": "Asterisk",
            "iconClass": "ms-Icon ms-Icon--Asterisk"
        },
        {
            "iconName": "AsteriskSolid",
            "iconClass": "ms-Icon ms-Icon--AsteriskSolid"
        },
        {
            "iconName": "ATPLogo",
            "iconClass": "ms-Icon ms-Icon--ATPLogo"
        },
        {
            "iconName": "Attach",
            "iconClass": "ms-Icon ms-Icon--Attach"
        },
        {
            "iconName": "AustralianRules",
            "iconClass": "ms-Icon ms-Icon--AustralianRules"
        },
        {
            "iconName": "AutoEnhanceOff",
            "iconClass": "ms-Icon ms-Icon--AutoEnhanceOff"
        },
        {
            "iconName": "AutoEnhanceOn",
            "iconClass": "ms-Icon ms-Icon--AutoEnhanceOn"
        },
        {
            "iconName": "AutoFillTemplate",
            "iconClass": "ms-Icon ms-Icon--AutoFillTemplate"
        },
        {
            "iconName": "AutoHeight",
            "iconClass": "ms-Icon ms-Icon--AutoHeight"
        },
        {
            "iconName": "AutoRacing",
            "iconClass": "ms-Icon ms-Icon--AutoRacing"
        },
        {
            "iconName": "AwayStatus",
            "iconClass": "ms-Icon ms-Icon--AwayStatus"
        },
        {
            "iconName": "AzureAPIManagement",
            "iconClass": "ms-Icon ms-Icon--AzureAPIManagement"
        },
        {
            "iconName": "AzureKeyVault",
            "iconClass": "ms-Icon ms-Icon--AzureKeyVault"
        },
        {
            "iconName": "AzureLogo",
            "iconClass": "ms-Icon ms-Icon--AzureLogo"
        },
        {
            "iconName": "AzureServiceEndpoint",
            "iconClass": "ms-Icon ms-Icon--AzureServiceEndpoint"
        },
        {
            "iconName": "Back",
            "iconClass": "ms-Icon ms-Icon--Back"
        },
        {
            "iconName": "BackgroundColor",
            "iconClass": "ms-Icon ms-Icon--BackgroundColor"
        },
        {
            "iconName": "Backlog",
            "iconClass": "ms-Icon ms-Icon--Backlog"
        },
        {
            "iconName": "BacklogBoard",
            "iconClass": "ms-Icon ms-Icon--BacklogBoard"
        },
        {
            "iconName": "BackToWindow",
            "iconClass": "ms-Icon ms-Icon--BackToWindow"
        },
        {
            "iconName": "Badge",
            "iconClass": "ms-Icon ms-Icon--Badge"
        },
        {
            "iconName": "Balloons",
            "iconClass": "ms-Icon ms-Icon--Balloons"
        },
        {
            "iconName": "BankSolid",
            "iconClass": "ms-Icon ms-Icon--BankSolid"
        },
        {
            "iconName": "BarChart4",
            "iconClass": "ms-Icon ms-Icon--BarChart4"
        },
        {
            "iconName": "BarChartHorizontal",
            "iconClass": "ms-Icon ms-Icon--BarChartHorizontal"
        },
        {
            "iconName": "BarChartVertical",
            "iconClass": "ms-Icon ms-Icon--BarChartVertical"
        },
        {
            "iconName": "Baseball",
            "iconClass": "ms-Icon ms-Icon--Baseball"
        },
        {
            "iconName": "BeerMug",
            "iconClass": "ms-Icon ms-Icon--BeerMug"
        },
        {
            "iconName": "BIDashboard",
            "iconClass": "ms-Icon ms-Icon--BIDashboard"
        },
        {
            "iconName": "BidiLtr",
            "iconClass": "ms-Icon ms-Icon--BidiLtr"
        },
        {
            "iconName": "BidiRtl",
            "iconClass": "ms-Icon ms-Icon--BidiRtl"
        },
        {
            "iconName": "BingLogo",
            "iconClass": "ms-Icon ms-Icon--BingLogo"
        },
        {
            "iconName": "BirthdayCake",
            "iconClass": "ms-Icon ms-Icon--BirthdayCake"
        },
        {
            "iconName": "BlockContact",
            "iconClass": "ms-Icon ms-Icon--BlockContact"
        },
        {
            "iconName": "Blocked",
            "iconClass": "ms-Icon ms-Icon--Blocked"
        },
        {
            "iconName": "Blocked12",
            "iconClass": "ms-Icon ms-Icon--Blocked12"
        },
        {
            "iconName": "Blocked2",
            "iconClass": "ms-Icon ms-Icon--Blocked2"
        },
        {
            "iconName": "BlockedSite",
            "iconClass": "ms-Icon ms-Icon--BlockedSite"
        },
        {
            "iconName": "BlockedSolid",
            "iconClass": "ms-Icon ms-Icon--BlockedSolid"
        },
        {
            "iconName": "BlowingSnow",
            "iconClass": "ms-Icon ms-Icon--BlowingSnow"
        },
        {
            "iconName": "Blur",
            "iconClass": "ms-Icon ms-Icon--Blur"
        },
        {
            "iconName": "Boards",
            "iconClass": "ms-Icon ms-Icon--Boards"
        },
        {
            "iconName": "Bold",
            "iconClass": "ms-Icon ms-Icon--Bold"
        },
        {
            "iconName": "BookingsLogo",
            "iconClass": "ms-Icon ms-Icon--BookingsLogo"
        },
        // {
        //     "iconName": "Bookmarks",
        //     "iconClass": "ms-Icon ms-Icon--Bookmarks"
        // },
        // {
        //     "iconName": "BookmarksMirrored",
        //     "iconClass": "ms-Icon ms-Icon--BookmarksMirrored"
        // },
        {
            "iconName": "BorderDash",
            "iconClass": "ms-Icon ms-Icon--BorderDash"
        },
        {
            "iconName": "BorderDot",
            "iconClass": "ms-Icon ms-Icon--BorderDot"
        },
        {
            "iconName": "BoxAdditionSolid",
            "iconClass": "ms-Icon ms-Icon--BoxAdditionSolid"
        },
        {
            "iconName": "BoxCheckmarkSolid",
            "iconClass": "ms-Icon ms-Icon--BoxCheckmarkSolid"
        },
        {
            "iconName": "BoxMultiplySolid",
            "iconClass": "ms-Icon ms-Icon--BoxMultiplySolid"
        },
        {
            "iconName": "BoxPlaySolid",
            "iconClass": "ms-Icon ms-Icon--BoxPlaySolid"
        },
        {
            "iconName": "BoxSubtractSolid",
            "iconClass": "ms-Icon ms-Icon--BoxSubtractSolid"
        },
        {
            "iconName": "BranchCommit",
            "iconClass": "ms-Icon ms-Icon--BranchCommit"
        },
        {
            "iconName": "BranchCompare",
            "iconClass": "ms-Icon ms-Icon--BranchCompare"
        },
        {
            "iconName": "BranchFork",
            "iconClass": "ms-Icon ms-Icon--BranchFork"
        },
        {
            "iconName": "BranchFork2",
            "iconClass": "ms-Icon ms-Icon--BranchFork2"
        },
        {
            "iconName": "BranchLocked",
            "iconClass": "ms-Icon ms-Icon--BranchLocked"
        },
        {
            "iconName": "BranchMerge",
            "iconClass": "ms-Icon ms-Icon--BranchMerge"
        },
        {
            "iconName": "BranchPullRequest",
            "iconClass": "ms-Icon ms-Icon--BranchPullRequest"
        },
        {
            "iconName": "BranchSearch",
            "iconClass": "ms-Icon ms-Icon--BranchSearch"
        },
        {
            "iconName": "BranchShelveset",
            "iconClass": "ms-Icon ms-Icon--BranchShelveset"
        },
        {
            "iconName": "Breadcrumb",
            "iconClass": "ms-Icon ms-Icon--Breadcrumb"
        },
        {
            "iconName": "Breakfast",
            "iconClass": "ms-Icon ms-Icon--Breakfast"
        },
        {
            "iconName": "Brightness",
            "iconClass": "ms-Icon ms-Icon--Brightness"
        },
        {
            "iconName": "Broom",
            "iconClass": "ms-Icon ms-Icon--Broom"
        },
        {
            "iconName": "BrowserScreenShot",
            "iconClass": "ms-Icon ms-Icon--BrowserScreenShot"
        },
        {
            "iconName": "BrowserTab",
            "iconClass": "ms-Icon ms-Icon--BrowserTab"
        },
        {
            "iconName": "BrowserTabScreenshot",
            "iconClass": "ms-Icon ms-Icon--BrowserTabScreenshot"
        },
        {
            "iconName": "Brunch",
            "iconClass": "ms-Icon ms-Icon--Brunch"
        },
        {
            "iconName": "BucketColor",
            "iconClass": "ms-Icon ms-Icon--BucketColor"
        },
        {
            "iconName": "BucketColorFill",
            "iconClass": "ms-Icon ms-Icon--BucketColorFill"
        },
        {
            "iconName": "BufferTimeAfter",
            "iconClass": "ms-Icon ms-Icon--BufferTimeAfter"
        },
        {
            "iconName": "BufferTimeBefore",
            "iconClass": "ms-Icon ms-Icon--BufferTimeBefore"
        },
        {
            "iconName": "BufferTimeBoth",
            "iconClass": "ms-Icon ms-Icon--BufferTimeBoth"
        },
        {
            "iconName": "Bug",
            "iconClass": "ms-Icon ms-Icon--Bug"
        },
        {
            "iconName": "BugSolid",
            "iconClass": "ms-Icon ms-Icon--BugSolid"
        },
        {
            "iconName": "Build",
            "iconClass": "ms-Icon ms-Icon--Build"
        },
        {
            "iconName": "BuildIssue",
            "iconClass": "ms-Icon ms-Icon--BuildIssue"
        },
        {
            "iconName": "BuildQueue",
            "iconClass": "ms-Icon ms-Icon--BuildQueue"
        },
        {
            "iconName": "BuildQueueNew",
            "iconClass": "ms-Icon ms-Icon--BuildQueueNew"
        },
        {
            "iconName": "BulkUpload",
            "iconClass": "ms-Icon ms-Icon--BulkUpload"
        },
        // {
        //     "iconName": "BulletedList",
        //     "iconClass": "ms-Icon ms-Icon--BulletedList"
        // },
        // {
        //     "iconName": "BulletedList2",
        //     "iconClass": "ms-Icon ms-Icon--BulletedList2"
        // },
        // {
        //     "iconName": "BulletedList2Mirrored",
        //     "iconClass": "ms-Icon ms-Icon--BulletedList2Mirrored"
        // },
        // {
        //     "iconName": "BulletedListMirrored",
        //     "iconClass": "ms-Icon ms-Icon--BulletedListMirrored"
        // },
        {
            "iconName": "Bullseye",
            "iconClass": "ms-Icon ms-Icon--Bullseye"
        },
        {
            "iconName": "Bus",
            "iconClass": "ms-Icon ms-Icon--Bus"
        },
        {
            "iconName": "BusinessCenterLogo",
            "iconClass": "ms-Icon ms-Icon--BusinessCenterLogo"
        },
        {
            "iconName": "BusinessHoursSign",
            "iconClass": "ms-Icon ms-Icon--BusinessHoursSign"
        },
        {
            "iconName": "BusSolid",
            "iconClass": "ms-Icon ms-Icon--BusSolid"
        },
        {
            "iconName": "Cafe",
            "iconClass": "ms-Icon ms-Icon--Cafe"
        },
        {
            "iconName": "Cake",
            "iconClass": "ms-Icon ms-Icon--Cake"
        },
        {
            "iconName": "Calculator",
            "iconClass": "ms-Icon ms-Icon--Calculator"
        },
        {
            "iconName": "CalculatorAddition",
            "iconClass": "ms-Icon ms-Icon--CalculatorAddition"
        },
        {
            "iconName": "CalculatorEqualTo",
            "iconClass": "ms-Icon ms-Icon--CalculatorEqualTo"
        },
        {
            "iconName": "CalculatorMultiply",
            "iconClass": "ms-Icon ms-Icon--CalculatorMultiply"
        },
        {
            "iconName": "CalculatorNotEqualTo",
            "iconClass": "ms-Icon ms-Icon--CalculatorNotEqualTo"
        },
        {
            "iconName": "CalculatorSubtract",
            "iconClass": "ms-Icon ms-Icon--CalculatorSubtract"
        },
        // {
        //     "iconName": "Calendar",
        //     "iconClass": "ms-Icon ms-Icon--Calendar"
        // },
        {
            "iconName": "CalendarAgenda",
            "iconClass": "ms-Icon ms-Icon--CalendarAgenda"
        },
        {
            "iconName": "CalendarDay",
            "iconClass": "ms-Icon ms-Icon--CalendarDay"
        },
        {
            "iconName": "CalendarMirrored",
            "iconClass": "ms-Icon ms-Icon--CalendarMirrored"
        },
        {
            "iconName": "CalendarReply",
            "iconClass": "ms-Icon ms-Icon--CalendarReply"
        },
        // {
        //     "iconName": "CalendarSettings",
        //     "iconClass": "ms-Icon ms-Icon--CalendarSettings"
        // },
        // {
        //     "iconName": "CalendarSettingsMirrored",
        //     "iconClass": "ms-Icon ms-Icon--CalendarSettingsMirrored"
        // },
        {
            "iconName": "CalendarWeek",
            "iconClass": "ms-Icon ms-Icon--CalendarWeek"
        },
        {
            "iconName": "CalendarWorkWeek",
            "iconClass": "ms-Icon ms-Icon--CalendarWorkWeek"
        },
        {
            "iconName": "CaloriesAdd",
            "iconClass": "ms-Icon ms-Icon--CaloriesAdd"
        },
        {
            "iconName": "Camera",
            "iconClass": "ms-Icon ms-Icon--Camera"
        },
        {
            "iconName": "Cancel",
            "iconClass": "ms-Icon ms-Icon--Cancel"
        },
        {
            "iconName": "CannedChat",
            "iconClass": "ms-Icon ms-Icon--CannedChat"
        },
        {
            "iconName": "Car",
            "iconClass": "ms-Icon ms-Icon--Car"
        },
        {
            "iconName": "CaretBottomLeftCenter8",
            "iconClass": "ms-Icon ms-Icon--CaretBottomLeftCenter8"
        },
        {
            "iconName": "CaretBottomLeftSolid8",
            "iconClass": "ms-Icon ms-Icon--CaretBottomLeftSolid8"
        },
        {
            "iconName": "CaretBottomRightCenter8",
            "iconClass": "ms-Icon ms-Icon--CaretBottomRightCenter8"
        },
        {
            "iconName": "CaretBottomRightSolid8",
            "iconClass": "ms-Icon ms-Icon--CaretBottomRightSolid8"
        },
        {
            "iconName": "CaretDown8",
            "iconClass": "ms-Icon ms-Icon--CaretDown8"
        },
        {
            "iconName": "CaretDownSolid8",
            "iconClass": "ms-Icon ms-Icon--CaretDownSolid8"
        },
        // {
        //     "iconName": "CaretHollow",
        //     "iconClass": "ms-Icon ms-Icon--CaretHollow"
        // },
        // {
        //     "iconName": "CaretHollowMirrored",
        //     "iconClass": "ms-Icon ms-Icon--CaretHollowMirrored"
        // },
        {
            "iconName": "CaretLeft8",
            "iconClass": "ms-Icon ms-Icon--CaretLeft8"
        },
        {
            "iconName": "CaretLeftSolid8",
            "iconClass": "ms-Icon ms-Icon--CaretLeftSolid8"
        },
        {
            "iconName": "CaretRight",
            "iconClass": "ms-Icon ms-Icon--CaretRight"
        },
        {
            "iconName": "CaretRight8",
            "iconClass": "ms-Icon ms-Icon--CaretRight8"
        },
        {
            "iconName": "CaretRightSolid8",
            "iconClass": "ms-Icon ms-Icon--CaretRightSolid8"
        },
        // {
        //     "iconName": "CaretSolid",
        //     "iconClass": "ms-Icon ms-Icon--CaretSolid"
        // },
        {
            "iconName": "CaretSolid16",
            "iconClass": "ms-Icon ms-Icon--CaretSolid16"
        },
        {
            "iconName": "CaretSolidDown",
            "iconClass": "ms-Icon ms-Icon--CaretSolidDown"
        },
        {
            "iconName": "CaretSolidLeft",
            "iconClass": "ms-Icon ms-Icon--CaretSolidLeft"
        },
        // {
        //     "iconName": "CaretSolidMirrored",
        //     "iconClass": "ms-Icon ms-Icon--CaretSolidMirrored"
        // },
        {
            "iconName": "CaretSolidRight",
            "iconClass": "ms-Icon ms-Icon--CaretSolidRight"
        },
        {
            "iconName": "CaretSolidUp",
            "iconClass": "ms-Icon ms-Icon--CaretSolidUp"
        },
        {
            "iconName": "CaretTopLeftCenter8",
            "iconClass": "ms-Icon ms-Icon--CaretTopLeftCenter8"
        },
        {
            "iconName": "CaretTopLeftSolid8",
            "iconClass": "ms-Icon ms-Icon--CaretTopLeftSolid8"
        },
        {
            "iconName": "CaretTopRightCenter8",
            "iconClass": "ms-Icon ms-Icon--CaretTopRightCenter8"
        },
        {
            "iconName": "CaretTopRightSolid8",
            "iconClass": "ms-Icon ms-Icon--CaretTopRightSolid8"
        },
        {
            "iconName": "CaretUp8",
            "iconClass": "ms-Icon ms-Icon--CaretUp8"
        },
        {
            "iconName": "CaretUpSolid8",
            "iconClass": "ms-Icon ms-Icon--CaretUpSolid8"
        },
        {
            "iconName": "Cat",
            "iconClass": "ms-Icon ms-Icon--Cat"
        },
        {
            "iconName": "CellPhone",
            "iconClass": "ms-Icon ms-Icon--CellPhone"
        },
        {
            "iconName": "Certificate",
            "iconClass": "ms-Icon ms-Icon--Certificate"
        },
        {
            "iconName": "CertifiedDatabase",
            "iconClass": "ms-Icon ms-Icon--CertifiedDatabase"
        },
        {
            "iconName": "Chart",
            "iconClass": "ms-Icon ms-Icon--Chart"
        },
        {
            "iconName": "ChartSeries",
            "iconClass": "ms-Icon ms-Icon--ChartSeries"
        },
        {
            "iconName": "ChartXAngle",
            "iconClass": "ms-Icon ms-Icon--ChartXAngle"
        },
        {
            "iconName": "ChartYAngle",
            "iconClass": "ms-Icon ms-Icon--ChartYAngle"
        },
        {
            "iconName": "Chat",
            "iconClass": "ms-Icon ms-Icon--Chat"
        },
        {
            "iconName": "ChatInviteFriend",
            "iconClass": "ms-Icon ms-Icon--ChatInviteFriend"
        },
        {
            "iconName": "ChatSolid",
            "iconClass": "ms-Icon ms-Icon--ChatSolid"
        },
        {
            "iconName": "Checkbox",
            "iconClass": "ms-Icon ms-Icon--Checkbox"
        },
        {
            "iconName": "CheckboxComposite",
            "iconClass": "ms-Icon ms-Icon--CheckboxComposite"
        },
        {
            "iconName": "CheckboxCompositeReversed",
            "iconClass": "ms-Icon ms-Icon--CheckboxCompositeReversed"
        },
        {
            "iconName": "CheckboxIndeterminate",
            "iconClass": "ms-Icon ms-Icon--CheckboxIndeterminate"
        },
        {
            "iconName": "CheckedOutByOther12",
            "iconClass": "ms-Icon ms-Icon--CheckedOutByOther12"
        },
        {
            "iconName": "CheckedOutByYou12",
            "iconClass": "ms-Icon ms-Icon--CheckedOutByYou12"
        },
        {
            "iconName": "CheckList",
            "iconClass": "ms-Icon ms-Icon--CheckList"
        },
        {
            "iconName": "CheckMark",
            "iconClass": "ms-Icon ms-Icon--CheckMark"
        },
        {
            "iconName": "ChevronDown",
            "iconClass": "ms-Icon ms-Icon--ChevronDown"
        },
        {
            "iconName": "ChevronDownEnd6",
            "iconClass": "ms-Icon ms-Icon--ChevronDownEnd6"
        },
        {
            "iconName": "ChevronDownMed",
            "iconClass": "ms-Icon ms-Icon--ChevronDownMed"
        },
        {
            "iconName": "ChevronDownSmall",
            "iconClass": "ms-Icon ms-Icon--ChevronDownSmall"
        },
        {
            "iconName": "ChevronFold10",
            "iconClass": "ms-Icon ms-Icon--ChevronFold10"
        },
        {
            "iconName": "ChevronLeft",
            "iconClass": "ms-Icon ms-Icon--ChevronLeft"
        },
        {
            "iconName": "ChevronLeftEnd6",
            "iconClass": "ms-Icon ms-Icon--ChevronLeftEnd6"
        },
        {
            "iconName": "ChevronLeftMed",
            "iconClass": "ms-Icon ms-Icon--ChevronLeftMed"
        },
        {
            "iconName": "ChevronLeftSmall",
            "iconClass": "ms-Icon ms-Icon--ChevronLeftSmall"
        },
        {
            "iconName": "ChevronRight",
            "iconClass": "ms-Icon ms-Icon--ChevronRight"
        },
        {
            "iconName": "ChevronRightEnd6",
            "iconClass": "ms-Icon ms-Icon--ChevronRightEnd6"
        },
        {
            "iconName": "ChevronRightMed",
            "iconClass": "ms-Icon ms-Icon--ChevronRightMed"
        },
        {
            "iconName": "ChevronRightSmall",
            "iconClass": "ms-Icon ms-Icon--ChevronRightSmall"
        },
        {
            "iconName": "ChevronUnfold10",
            "iconClass": "ms-Icon ms-Icon--ChevronUnfold10"
        },
        {
            "iconName": "ChevronUp",
            "iconClass": "ms-Icon ms-Icon--ChevronUp"
        },
        {
            "iconName": "ChevronUpEnd6",
            "iconClass": "ms-Icon ms-Icon--ChevronUpEnd6"
        },
        {
            "iconName": "ChevronUpMed",
            "iconClass": "ms-Icon ms-Icon--ChevronUpMed"
        },
        {
            "iconName": "ChevronUpSmall",
            "iconClass": "ms-Icon ms-Icon--ChevronUpSmall"
        },
        {
            "iconName": "Chopsticks",
            "iconClass": "ms-Icon ms-Icon--Chopsticks"
        },
        // {
        //     "iconName": "ChromeBack",
        //     "iconClass": "ms-Icon ms-Icon--ChromeBack"
        // },
        // {
        //     "iconName": "ChromeBackMirrored",
        //     "iconClass": "ms-Icon ms-Icon--ChromeBackMirrored"
        // },
        {
            "iconName": "ChromeClose",
            "iconClass": "ms-Icon ms-Icon--ChromeClose"
        },
        {
            "iconName": "ChromeMinimize",
            "iconClass": "ms-Icon ms-Icon--ChromeMinimize"
        },
        {
            "iconName": "CircleAddition",
            "iconClass": "ms-Icon ms-Icon--CircleAddition"
        },
        {
            "iconName": "CircleAdditionSolid",
            "iconClass": "ms-Icon ms-Icon--CircleAdditionSolid"
        },
        {
            "iconName": "CircleFill",
            "iconClass": "ms-Icon ms-Icon--CircleFill"
        },
        {
            "iconName": "CircleHalfFull",
            "iconClass": "ms-Icon ms-Icon--CircleHalfFull"
        },
        {
            "iconName": "CirclePause",
            "iconClass": "ms-Icon ms-Icon--CirclePause"
        },
        {
            "iconName": "CirclePauseSolid",
            "iconClass": "ms-Icon ms-Icon--CirclePauseSolid"
        },
        {
            "iconName": "CirclePlus",
            "iconClass": "ms-Icon ms-Icon--CirclePlus"
        },
        {
            "iconName": "CircleRing",
            "iconClass": "ms-Icon ms-Icon--CircleRing"
        },
        {
            "iconName": "CircleShapeSolid",
            "iconClass": "ms-Icon ms-Icon--CircleShapeSolid"
        },
        {
            "iconName": "CircleStop",
            "iconClass": "ms-Icon ms-Icon--CircleStop"
        },
        {
            "iconName": "CircleStopSolid",
            "iconClass": "ms-Icon ms-Icon--CircleStopSolid"
        },
        {
            "iconName": "CityNext",
            "iconClass": "ms-Icon ms-Icon--CityNext"
        },
        {
            "iconName": "ClassNotebookLogo16",
            "iconClass": "ms-Icon ms-Icon--ClassNotebookLogo16"
        },
        {
            "iconName": "ClassNotebookLogo32",
            "iconClass": "ms-Icon ms-Icon--ClassNotebookLogo32"
        },
        {
            "iconName": "ClassNotebookLogoFill16",
            "iconClass": "ms-Icon ms-Icon--ClassNotebookLogoFill16"
        },
        {
            "iconName": "ClassNotebookLogoFill32",
            "iconClass": "ms-Icon ms-Icon--ClassNotebookLogoFill32"
        },
        {
            "iconName": "ClassNotebookLogoInverse",
            "iconClass": "ms-Icon ms-Icon--ClassNotebookLogoInverse"
        },
        {
            "iconName": "ClassNotebookLogoInverse16",
            "iconClass": "ms-Icon ms-Icon--ClassNotebookLogoInverse16"
        },
        {
            "iconName": "ClassNotebookLogoInverse32",
            "iconClass": "ms-Icon ms-Icon--ClassNotebookLogoInverse32"
        },
        {
            "iconName": "ClassroomLogo",
            "iconClass": "ms-Icon ms-Icon--ClassroomLogo"
        },
        {
            "iconName": "Clear",
            "iconClass": "ms-Icon ms-Icon--Clear"
        },
        {
            "iconName": "ClearFilter",
            "iconClass": "ms-Icon ms-Icon--ClearFilter"
        },
        {
            "iconName": "ClearFormatting",
            "iconClass": "ms-Icon ms-Icon--ClearFormatting"
        },
        {
            "iconName": "ClearNight",
            "iconClass": "ms-Icon ms-Icon--ClearNight"
        },
        {
            "iconName": "ClipboardSolid",
            "iconClass": "ms-Icon ms-Icon--ClipboardSolid"
        },
        {
            "iconName": "Clock",
            "iconClass": "ms-Icon ms-Icon--Clock"
        },
        {
            "iconName": "CloneToDesktop",
            "iconClass": "ms-Icon ms-Icon--CloneToDesktop"
        },
        {
            "iconName": "ClosedCaption",
            "iconClass": "ms-Icon ms-Icon--ClosedCaption"
        },
        // {
        //     "iconName": "ClosePane",
        //     "iconClass": "ms-Icon ms-Icon--ClosePane"
        // },
        // {
        //     "iconName": "ClosePaneMirrored",
        //     "iconClass": "ms-Icon ms-Icon--ClosePaneMirrored"
        // },
        {
            "iconName": "Cloud",
            "iconClass": "ms-Icon ms-Icon--Cloud"
        },
        {
            "iconName": "CloudAdd",
            "iconClass": "ms-Icon ms-Icon--CloudAdd"
        },
        {
            "iconName": "CloudDownload",
            "iconClass": "ms-Icon ms-Icon--CloudDownload"
        },
        {
            "iconName": "CloudUpload",
            "iconClass": "ms-Icon ms-Icon--CloudUpload"
        },
        {
            "iconName": "CloudWeather",
            "iconClass": "ms-Icon ms-Icon--CloudWeather"
        },
        {
            "iconName": "Cloudy",
            "iconClass": "ms-Icon ms-Icon--Cloudy"
        },
        {
            "iconName": "Cocktails",
            "iconClass": "ms-Icon ms-Icon--Cocktails"
        },
        {
            "iconName": "Code",
            "iconClass": "ms-Icon ms-Icon--Code"
        },
        {
            "iconName": "CodeEdit",
            "iconClass": "ms-Icon ms-Icon--CodeEdit"
        },
        {
            "iconName": "Coffee",
            "iconClass": "ms-Icon ms-Icon--Coffee"
        },
        {
            "iconName": "CoffeeScript",
            "iconClass": "ms-Icon ms-Icon--CoffeeScript"
        },
        {
            "iconName": "CollapseContent",
            "iconClass": "ms-Icon ms-Icon--CollapseContent"
        },
        {
            "iconName": "CollapseContentSingle",
            "iconClass": "ms-Icon ms-Icon--CollapseContentSingle"
        },
        {
            "iconName": "CollapseMenu",
            "iconClass": "ms-Icon ms-Icon--CollapseMenu"
        },
        {
            "iconName": "CollegeFootball",
            "iconClass": "ms-Icon ms-Icon--CollegeFootball"
        },
        {
            "iconName": "CollegeHoops",
            "iconClass": "ms-Icon ms-Icon--CollegeHoops"
        },
        {
            "iconName": "Color",
            "iconClass": "ms-Icon ms-Icon--Color"
        },
        {
            "iconName": "ColorSolid",
            "iconClass": "ms-Icon ms-Icon--ColorSolid"
        },
        {
            "iconName": "ColumnLeftTwoThirds",
            "iconClass": "ms-Icon ms-Icon--ColumnLeftTwoThirds"
        },
        {
            "iconName": "ColumnLeftTwoThirdsEdit",
            "iconClass": "ms-Icon ms-Icon--ColumnLeftTwoThirdsEdit"
        },
        {
            "iconName": "ColumnOptions",
            "iconClass": "ms-Icon ms-Icon--ColumnOptions"
        },
        {
            "iconName": "ColumnRightTwoThirds",
            "iconClass": "ms-Icon ms-Icon--ColumnRightTwoThirds"
        },
        {
            "iconName": "ColumnRightTwoThirdsEdit",
            "iconClass": "ms-Icon ms-Icon--ColumnRightTwoThirdsEdit"
        },
        {
            "iconName": "Combine",
            "iconClass": "ms-Icon ms-Icon--Combine"
        },
        {
            "iconName": "Combobox",
            "iconClass": "ms-Icon ms-Icon--Combobox"
        },
        {
            "iconName": "CommandPrompt",
            "iconClass": "ms-Icon ms-Icon--CommandPrompt"
        },
        {
            "iconName": "Comment",
            "iconClass": "ms-Icon ms-Icon--Comment"
        },
        {
            "iconName": "CommentAdd",
            "iconClass": "ms-Icon ms-Icon--CommentAdd"
        },
        {
            "iconName": "CommentNext",
            "iconClass": "ms-Icon ms-Icon--CommentNext"
        },
        {
            "iconName": "CommentPrevious",
            "iconClass": "ms-Icon ms-Icon--CommentPrevious"
        },
        {
            "iconName": "CommentUrgent",
            "iconClass": "ms-Icon ms-Icon--CommentUrgent"
        },
        {
            "iconName": "Commitments",
            "iconClass": "ms-Icon ms-Icon--Commitments"
        },
        {
            "iconName": "Communications",
            "iconClass": "ms-Icon ms-Icon--Communications"
        },
        // {
        //     "iconName": "CompanyDirectory",
        //     "iconClass": "ms-Icon ms-Icon--CompanyDirectory"
        // },
        // {
        //     "iconName": "CompanyDirectoryMirrored",
        //     "iconClass": "ms-Icon ms-Icon--CompanyDirectoryMirrored"
        // },
        {
            "iconName": "CompassNW",
            "iconClass": "ms-Icon ms-Icon--CompassNW"
        },
        {
            "iconName": "Completed",
            "iconClass": "ms-Icon ms-Icon--Completed"
        },
        {
            "iconName": "CompletedSolid",
            "iconClass": "ms-Icon ms-Icon--CompletedSolid"
        },
        {
            "iconName": "ConfigurationSolid",
            "iconClass": "ms-Icon ms-Icon--ConfigurationSolid"
        },
        {
            "iconName": "ConnectContacts",
            "iconClass": "ms-Icon ms-Icon--ConnectContacts"
        },
        {
            "iconName": "ConstructionCone",
            "iconClass": "ms-Icon ms-Icon--ConstructionCone"
        },
        {
            "iconName": "ConstructionConeSolid",
            "iconClass": "ms-Icon ms-Icon--ConstructionConeSolid"
        },
        {
            "iconName": "Contact",
            "iconClass": "ms-Icon ms-Icon--Contact"
        },
        {
            "iconName": "ContactCard",
            "iconClass": "ms-Icon ms-Icon--ContactCard"
        },
        // {
        //     "iconName": "ContactCardSettings",
        //     "iconClass": "ms-Icon ms-Icon--ContactCardSettings"
        // },
        // {
        //     "iconName": "ContactCardSettingsMirrored",
        //     "iconClass": "ms-Icon ms-Icon--ContactCardSettingsMirrored"
        // },
        {
            "iconName": "ContactInfo",
            "iconClass": "ms-Icon ms-Icon--ContactInfo"
        },
        {
            "iconName": "ContactLink",
            "iconClass": "ms-Icon ms-Icon--ContactLink"
        },
        {
            "iconName": "ContextMenu",
            "iconClass": "ms-Icon ms-Icon--ContextMenu"
        },
        {
            "iconName": "Contrast",
            "iconClass": "ms-Icon ms-Icon--Contrast"
        },
        {
            "iconName": "Copy",
            "iconClass": "ms-Icon ms-Icon--Copy"
        },
        {
            "iconName": "Cotton",
            "iconClass": "ms-Icon ms-Icon--Cotton"
        },
        {
            "iconName": "CPlusPlus",
            "iconClass": "ms-Icon ms-Icon--CPlusPlus"
        },
        {
            "iconName": "CPlusPlusLanguage",
            "iconClass": "ms-Icon ms-Icon--CPlusPlusLanguage"
        },
        {
            "iconName": "CreateMailRule",
            "iconClass": "ms-Icon ms-Icon--CreateMailRule"
        },
        {
            "iconName": "Cricket",
            "iconClass": "ms-Icon ms-Icon--Cricket"
        },
        {
            "iconName": "CRMReport",
            "iconClass": "ms-Icon ms-Icon--CRMReport"
        },
        {
            "iconName": "Crop",
            "iconClass": "ms-Icon ms-Icon--Crop"
        },
        {
            "iconName": "Crown",
            "iconClass": "ms-Icon ms-Icon--Crown"
        },
        {
            "iconName": "CrownSolid",
            "iconClass": "ms-Icon ms-Icon--CrownSolid"
        },
        {
            "iconName": "CSharp",
            "iconClass": "ms-Icon ms-Icon--CSharp"
        },
        {
            "iconName": "CSharpLanguage",
            "iconClass": "ms-Icon ms-Icon--CSharpLanguage"
        },
        {
            "iconName": "CSS",
            "iconClass": "ms-Icon ms-Icon--CSS"
        },
        // {
        //     "iconName": "CustomList",
        //     "iconClass": "ms-Icon ms-Icon--CustomList"
        // },
        // {
        //     "iconName": "CustomListMirrored",
        //     "iconClass": "ms-Icon ms-Icon--CustomListMirrored"
        // },
        {
            "iconName": "Cut",
            "iconClass": "ms-Icon ms-Icon--Cut"
        },
        {
            "iconName": "Cycling",
            "iconClass": "ms-Icon ms-Icon--Cycling"
        },
        {
            "iconName": "DashboardAdd",
            "iconClass": "ms-Icon ms-Icon--DashboardAdd"
        },
        {
            "iconName": "Database",
            "iconClass": "ms-Icon ms-Icon--Database"
        },
        {
            "iconName": "DataConnectionLibrary",
            "iconClass": "ms-Icon ms-Icon--DataConnectionLibrary"
        },
        // {
        //     "iconName": "DateTime",
        //     "iconClass": "ms-Icon ms-Icon--DateTime"
        // },
        {
            "iconName": "DateTime2",
            "iconClass": "ms-Icon ms-Icon--DateTime2"
        },
        // {
        //     "iconName": "DateTimeMirrored",
        //     "iconClass": "ms-Icon ms-Icon--DateTimeMirrored"
        // },
        {
            "iconName": "DeactivateOrders",
            "iconClass": "ms-Icon ms-Icon--DeactivateOrders"
        },
        {
            "iconName": "DecisionSolid",
            "iconClass": "ms-Icon ms-Icon--DecisionSolid"
        },
        {
            "iconName": "DeclineCall",
            "iconClass": "ms-Icon ms-Icon--DeclineCall"
        },
        {
            "iconName": "DecreaseIndentLegacy",
            "iconClass": "ms-Icon ms-Icon--DecreaseIndentLegacy"
        },
        {
            "iconName": "DefaultRatio",
            "iconClass": "ms-Icon ms-Icon--DefaultRatio"
        },
        {
            "iconName": "DefectSolid",
            "iconClass": "ms-Icon ms-Icon--DefectSolid"
        },
        {
            "iconName": "Delete",
            "iconClass": "ms-Icon ms-Icon--Delete"
        },
        {
            "iconName": "DeleteColumns",
            "iconClass": "ms-Icon ms-Icon--DeleteColumns"
        },
        // {
        //     "iconName": "DeleteRows",
        //     "iconClass": "ms-Icon ms-Icon--DeleteRows"
        // },
        // {
        //     "iconName": "DeleteRowsMirrored",
        //     "iconClass": "ms-Icon ms-Icon--DeleteRowsMirrored"
        // },
        {
            "iconName": "DeleteTable",
            "iconClass": "ms-Icon ms-Icon--DeleteTable"
        },
        {
            "iconName": "DeliveryTruck",
            "iconClass": "ms-Icon ms-Icon--DeliveryTruck"
        },
        {
            "iconName": "DelveAnalytics",
            "iconClass": "ms-Icon ms-Icon--DelveAnalytics"
        },
        {
            "iconName": "DelveAnalyticsLogo",
            "iconClass": "ms-Icon ms-Icon--DelveAnalyticsLogo"
        },
        {
            "iconName": "DelveLogo",
            "iconClass": "ms-Icon ms-Icon--DelveLogo"
        },
        {
            "iconName": "DelveLogoFill",
            "iconClass": "ms-Icon ms-Icon--DelveLogoFill"
        },
        {
            "iconName": "DelveLogoInverse",
            "iconClass": "ms-Icon ms-Icon--DelveLogoInverse"
        },
        {
            "iconName": "Deploy",
            "iconClass": "ms-Icon ms-Icon--Deploy"
        },
        {
            "iconName": "Descending",
            "iconClass": "ms-Icon ms-Icon--Descending"
        },
        {
            "iconName": "Design",
            "iconClass": "ms-Icon ms-Icon--Design"
        },
        {
            "iconName": "DesktopScreenshot",
            "iconClass": "ms-Icon ms-Icon--DesktopScreenshot"
        },
        {
            "iconName": "DeveloperTools",
            "iconClass": "ms-Icon ms-Icon--DeveloperTools"
        },
        {
            "iconName": "Devices3",
            "iconClass": "ms-Icon ms-Icon--Devices3"
        },
        {
            "iconName": "Devices4",
            "iconClass": "ms-Icon ms-Icon--Devices4"
        },
        {
            "iconName": "Diagnostic",
            "iconClass": "ms-Icon ms-Icon--Diagnostic"
        },
        {
            "iconName": "Dialpad",
            "iconClass": "ms-Icon ms-Icon--Dialpad"
        },
        {
            "iconName": "DiamondSolid",
            "iconClass": "ms-Icon ms-Icon--DiamondSolid"
        },
        {
            "iconName": "Dictionary",
            "iconClass": "ms-Icon ms-Icon--Dictionary"
        },
        {
            "iconName": "DictionaryRemove",
            "iconClass": "ms-Icon ms-Icon--DictionaryRemove"
        },
        {
            "iconName": "DietPlanNotebook",
            "iconClass": "ms-Icon ms-Icon--DietPlanNotebook"
        },
        {
            "iconName": "DiffInline",
            "iconClass": "ms-Icon ms-Icon--DiffInline"
        },
        {
            "iconName": "DiffSideBySide",
            "iconClass": "ms-Icon ms-Icon--DiffSideBySide"
        },
        {
            "iconName": "DisableUpdates",
            "iconClass": "ms-Icon ms-Icon--DisableUpdates"
        },
        {
            "iconName": "Dislike",
            "iconClass": "ms-Icon ms-Icon--Dislike"
        },
        {
            "iconName": "DislikeSolid",
            "iconClass": "ms-Icon ms-Icon--DislikeSolid"
        },
        // {
        //     "iconName": "DockLeft",
        //     "iconClass": "ms-Icon ms-Icon--DockLeft"
        // },
        // {
        //     "iconName": "DockLeftMirrored",
        //     "iconClass": "ms-Icon ms-Icon--DockLeftMirrored"
        // },
        {
            "iconName": "DockRight",
            "iconClass": "ms-Icon ms-Icon--DockRight"
        },
        {
            "iconName": "DocLibrary",
            "iconClass": "ms-Icon ms-Icon--DocLibrary"
        },
        {
            "iconName": "DocsLogoInverse",
            "iconClass": "ms-Icon ms-Icon--DocsLogoInverse"
        },
        {
            "iconName": "Document",
            "iconClass": "ms-Icon ms-Icon--Document"
        },
        {
            "iconName": "DocumentApproval",
            "iconClass": "ms-Icon ms-Icon--DocumentApproval"
        },
        {
            "iconName": "Documentation",
            "iconClass": "ms-Icon ms-Icon--Documentation"
        },
        {
            "iconName": "DocumentManagement",
            "iconClass": "ms-Icon ms-Icon--DocumentManagement"
        },
        {
            "iconName": "DocumentReply",
            "iconClass": "ms-Icon ms-Icon--DocumentReply"
        },
        {
            "iconName": "DocumentSearch",
            "iconClass": "ms-Icon ms-Icon--DocumentSearch"
        },
        {
            "iconName": "DocumentSet",
            "iconClass": "ms-Icon ms-Icon--DocumentSet"
        },
        {
            "iconName": "DOM",
            "iconClass": "ms-Icon ms-Icon--DOM"
        },
        {
            "iconName": "DonutChart",
            "iconClass": "ms-Icon ms-Icon--DonutChart"
        },
        {
            "iconName": "Door",
            "iconClass": "ms-Icon ms-Icon--Door"
        },
        {
            "iconName": "DoubleBookmark",
            "iconClass": "ms-Icon ms-Icon--DoubleBookmark"
        },
        {
            "iconName": "DoubleChevronDown",
            "iconClass": "ms-Icon ms-Icon--DoubleChevronDown"
        },
        {
            "iconName": "DoubleChevronDown12",
            "iconClass": "ms-Icon ms-Icon--DoubleChevronDown12"
        },
        {
            "iconName": "DoubleChevronDown8",
            "iconClass": "ms-Icon ms-Icon--DoubleChevronDown8"
        },
        {
            "iconName": "DoubleChevronLeft",
            "iconClass": "ms-Icon ms-Icon--DoubleChevronLeft"
        },
        {
            "iconName": "DoubleChevronLeft12",
            "iconClass": "ms-Icon ms-Icon--DoubleChevronLeft12"
        },
        {
            "iconName": "DoubleChevronLeft8",
            "iconClass": "ms-Icon ms-Icon--DoubleChevronLeft8"
        },
        // {
        //     "iconName": "DoubleChevronLeftMed",
        //     "iconClass": "ms-Icon ms-Icon--DoubleChevronLeftMed"
        // },
        // {
        //     "iconName": "DoubleChevronLeftMedMirrored",
        //     "iconClass": "ms-Icon ms-Icon--DoubleChevronLeftMedMirrored"
        // },
        {
            "iconName": "DoubleChevronRight",
            "iconClass": "ms-Icon ms-Icon--DoubleChevronRight"
        },
        {
            "iconName": "DoubleChevronRight12",
            "iconClass": "ms-Icon ms-Icon--DoubleChevronRight12"
        },
        {
            "iconName": "DoubleChevronRight8",
            "iconClass": "ms-Icon ms-Icon--DoubleChevronRight8"
        },
        {
            "iconName": "DoubleChevronUp",
            "iconClass": "ms-Icon ms-Icon--DoubleChevronUp"
        },
        {
            "iconName": "DoubleChevronUp12",
            "iconClass": "ms-Icon ms-Icon--DoubleChevronUp12"
        },
        {
            "iconName": "DoubleChevronUp8",
            "iconClass": "ms-Icon ms-Icon--DoubleChevronUp8"
        },
        {
            "iconName": "DoubleColumn",
            "iconClass": "ms-Icon ms-Icon--DoubleColumn"
        },
        {
            "iconName": "DoubleColumnEdit",
            "iconClass": "ms-Icon ms-Icon--DoubleColumnEdit"
        },
        {
            "iconName": "Down",
            "iconClass": "ms-Icon ms-Icon--Down"
        },
        {
            "iconName": "Download",
            "iconClass": "ms-Icon ms-Icon--Download"
        },
        {
            "iconName": "DownloadDocument",
            "iconClass": "ms-Icon ms-Icon--DownloadDocument"
        },
        {
            "iconName": "DragObject",
            "iconClass": "ms-Icon ms-Icon--DragObject"
        },
        {
            "iconName": "DrillDown",
            "iconClass": "ms-Icon ms-Icon--DrillDown"
        },
        {
            "iconName": "DrillDownSolid",
            "iconClass": "ms-Icon ms-Icon--DrillDownSolid"
        },
        {
            "iconName": "DrillExpand",
            "iconClass": "ms-Icon ms-Icon--DrillExpand"
        },
        {
            "iconName": "DrillShow",
            "iconClass": "ms-Icon ms-Icon--DrillShow"
        },
        {
            "iconName": "DrillThrough",
            "iconClass": "ms-Icon ms-Icon--DrillThrough"
        },
        {
            "iconName": "DRM",
            "iconClass": "ms-Icon ms-Icon--DRM"
        },
        {
            "iconName": "Drop",
            "iconClass": "ms-Icon ms-Icon--Drop"
        },
        {
            "iconName": "Dropdown",
            "iconClass": "ms-Icon ms-Icon--Dropdown"
        },
        {
            "iconName": "DropShapeSolid",
            "iconClass": "ms-Icon ms-Icon--DropShapeSolid"
        },
        {
            "iconName": "Duststorm",
            "iconClass": "ms-Icon ms-Icon--Duststorm"
        },
        {
            "iconName": "Dynamics365Logo",
            "iconClass": "ms-Icon ms-Icon--Dynamics365Logo"
        },
        {
            "iconName": "DynamicSMBLogo",
            "iconClass": "ms-Icon ms-Icon--DynamicSMBLogo"
        },
        {
            "iconName": "EatDrink",
            "iconClass": "ms-Icon ms-Icon--EatDrink"
        },
        {
            "iconName": "EdgeLogo",
            "iconClass": "ms-Icon ms-Icon--EdgeLogo"
        },
        // {
        //     "iconName": "Edit",
        //     "iconClass": "ms-Icon ms-Icon--Edit"
        // },
        {
            "iconName": "EditContact",
            "iconClass": "ms-Icon ms-Icon--EditContact"
        },
        {
            "iconName": "EditMail",
            "iconClass": "ms-Icon ms-Icon--EditMail"
        },
        // {
        //     "iconName": "EditMirrored",
        //     "iconClass": "ms-Icon ms-Icon--EditMirrored"
        // },
        {
            "iconName": "EditNote",
            "iconClass": "ms-Icon ms-Icon--EditNote"
        },
        {
            "iconName": "EditPhoto",
            "iconClass": "ms-Icon ms-Icon--EditPhoto"
        },
        // {
        //     "iconName": "EditSolid12",
        //     "iconClass": "ms-Icon ms-Icon--EditSolid12"
        // },
        // {
        //     "iconName": "EditSolidMirrored12",
        //     "iconClass": "ms-Icon ms-Icon--EditSolidMirrored12"
        // },
        {
            "iconName": "EditStyle",
            "iconClass": "ms-Icon ms-Icon--EditStyle"
        },
        {
            "iconName": "Education",
            "iconClass": "ms-Icon ms-Icon--Education"
        },
        {
            "iconName": "Ellipse",
            "iconClass": "ms-Icon ms-Icon--Ellipse"
        },
        {
            "iconName": "Embed",
            "iconClass": "ms-Icon ms-Icon--Embed"
        },
        {
            "iconName": "EMI",
            "iconClass": "ms-Icon ms-Icon--EMI"
        },
        {
            "iconName": "Emoji",
            "iconClass": "ms-Icon ms-Icon--Emoji"
        },
        {
            "iconName": "Emoji2",
            "iconClass": "ms-Icon ms-Icon--Emoji2"
        },
        {
            "iconName": "EmojiDisappointed",
            "iconClass": "ms-Icon ms-Icon--EmojiDisappointed"
        },
        {
            "iconName": "EmojiNeutral",
            "iconClass": "ms-Icon ms-Icon--EmojiNeutral"
        },
        {
            "iconName": "EmojiTabSymbols",
            "iconClass": "ms-Icon ms-Icon--EmojiTabSymbols"
        },
        {
            "iconName": "EmptyRecycleBin",
            "iconClass": "ms-Icon ms-Icon--EmptyRecycleBin"
        },
        {
            "iconName": "Encryption",
            "iconClass": "ms-Icon ms-Icon--Encryption"
        },
        {
            "iconName": "EngineeringGroup",
            "iconClass": "ms-Icon ms-Icon--EngineeringGroup"
        },
        {
            "iconName": "EntryDecline",
            "iconClass": "ms-Icon ms-Icon--EntryDecline"
        },
        {
            "iconName": "EntryView",
            "iconClass": "ms-Icon ms-Icon--EntryView"
        },
        {
            "iconName": "Equalizer",
            "iconClass": "ms-Icon ms-Icon--Equalizer"
        },
        {
            "iconName": "EraseTool",
            "iconClass": "ms-Icon ms-Icon--EraseTool"
        },
        {
            "iconName": "Error",
            "iconClass": "ms-Icon ms-Icon--Error"
        },
        {
            "iconName": "ErrorBadge",
            "iconClass": "ms-Icon ms-Icon--ErrorBadge"
        },
        {
            "iconName": "Event",
            "iconClass": "ms-Icon ms-Icon--Event"
        },
        {
            "iconName": "EventAccepted",
            "iconClass": "ms-Icon ms-Icon--EventAccepted"
        },
        {
            "iconName": "EventDate",
            "iconClass": "ms-Icon ms-Icon--EventDate"
        },
        {
            "iconName": "EventDeclined",
            "iconClass": "ms-Icon ms-Icon--EventDeclined"
        },
        {
            "iconName": "EventInfo",
            "iconClass": "ms-Icon ms-Icon--EventInfo"
        },
        // {
        //     "iconName": "EventTentative",
        //     "iconClass": "ms-Icon ms-Icon--EventTentative"
        // },
        // {
        //     "iconName": "EventTentativeMirrored",
        //     "iconClass": "ms-Icon ms-Icon--EventTentativeMirrored"
        // },
        {
            "iconName": "ExcelDocument",
            "iconClass": "ms-Icon ms-Icon--ExcelDocument"
        },
        {
            "iconName": "ExcelLogo",
            "iconClass": "ms-Icon ms-Icon--ExcelLogo"
        },
        {
            "iconName": "ExcelLogo16",
            "iconClass": "ms-Icon ms-Icon--ExcelLogo16"
        },
        {
            "iconName": "ExcelLogoFill",
            "iconClass": "ms-Icon ms-Icon--ExcelLogoFill"
        },
        {
            "iconName": "ExcelLogoFill16",
            "iconClass": "ms-Icon ms-Icon--ExcelLogoFill16"
        },
        {
            "iconName": "ExcelLogoInverse",
            "iconClass": "ms-Icon ms-Icon--ExcelLogoInverse"
        },
        {
            "iconName": "ExcelLogoInverse16",
            "iconClass": "ms-Icon ms-Icon--ExcelLogoInverse16"
        },
        {
            "iconName": "ExchangeLogo",
            "iconClass": "ms-Icon ms-Icon--ExchangeLogo"
        },
        {
            "iconName": "ExchangeLogoFill",
            "iconClass": "ms-Icon ms-Icon--ExchangeLogoFill"
        },
        {
            "iconName": "ExchangeLogoInverse",
            "iconClass": "ms-Icon ms-Icon--ExchangeLogoInverse"
        },
        {
            "iconName": "ExerciseTracker",
            "iconClass": "ms-Icon ms-Icon--ExerciseTracker"
        },
        {
            "iconName": "ExpandMenu",
            "iconClass": "ms-Icon ms-Icon--ExpandMenu"
        },
        {
            "iconName": "ExploreContent",
            "iconClass": "ms-Icon ms-Icon--ExploreContent"
        },
        {
            "iconName": "ExploreContentSingle",
            "iconClass": "ms-Icon ms-Icon--ExploreContentSingle"
        },
        {
            "iconName": "ExploreData",
            "iconClass": "ms-Icon ms-Icon--ExploreData"
        },
        // {
        //     "iconName": "Export",
        //     "iconClass": "ms-Icon ms-Icon--Export"
        // },
        // {
        //     "iconName": "ExportMirrored",
        //     "iconClass": "ms-Icon ms-Icon--ExportMirrored"
        // },
        {
            "iconName": "ExternalBuild",
            "iconClass": "ms-Icon ms-Icon--ExternalBuild"
        },
        {
            "iconName": "ExternalGit",
            "iconClass": "ms-Icon ms-Icon--ExternalGit"
        },
        {
            "iconName": "ExternalTFVC",
            "iconClass": "ms-Icon ms-Icon--ExternalTFVC"
        },
        {
            "iconName": "ExternalXAML",
            "iconClass": "ms-Icon ms-Icon--ExternalXAML"
        },
        {
            "iconName": "F12DevTools",
            "iconClass": "ms-Icon ms-Icon--F12DevTools"
        },
        {
            "iconName": "FabricAssetLibrary",
            "iconClass": "ms-Icon ms-Icon--FabricAssetLibrary"
        },
        {
            "iconName": "FabricDataConnectionLibrary",
            "iconClass": "ms-Icon ms-Icon--FabricDataConnectionLibrary"
        },
        {
            "iconName": "FabricDocLibrary",
            "iconClass": "ms-Icon ms-Icon--FabricDocLibrary"
        },
        {
            "iconName": "FabricFolder",
            "iconClass": "ms-Icon ms-Icon--FabricFolder"
        },
        {
            "iconName": "FabricFolderFill",
            "iconClass": "ms-Icon ms-Icon--FabricFolderFill"
        },
        {
            "iconName": "FabricFolderSearch",
            "iconClass": "ms-Icon ms-Icon--FabricFolderSearch"
        },
        // {
        //     "iconName": "FabricFormLibrary",
        //     "iconClass": "ms-Icon ms-Icon--FabricFormLibrary"
        // },
        // {
        //     "iconName": "FabricFormLibraryMirrored",
        //     "iconClass": "ms-Icon ms-Icon--FabricFormLibraryMirrored"
        // },
        {
            "iconName": "FabricMovetoFolder",
            "iconClass": "ms-Icon ms-Icon--FabricMovetoFolder"
        },
        {
            "iconName": "FabricNewFolder",
            "iconClass": "ms-Icon ms-Icon--FabricNewFolder"
        },
        {
            "iconName": "FabricOpenFolderHorizontal",
            "iconClass": "ms-Icon ms-Icon--FabricOpenFolderHorizontal"
        },
        {
            "iconName": "FabricPictureLibrary",
            "iconClass": "ms-Icon ms-Icon--FabricPictureLibrary"
        },
        {
            "iconName": "FabricPublicFolder",
            "iconClass": "ms-Icon ms-Icon--FabricPublicFolder"
        },
        // {
        //     "iconName": "FabricReportLibrary",
        //     "iconClass": "ms-Icon ms-Icon--FabricReportLibrary"
        // },
        // {
        //     "iconName": "FabricReportLibraryMirrored",
        //     "iconClass": "ms-Icon ms-Icon--FabricReportLibraryMirrored"
        // },
        {
            "iconName": "FabricSyncFolder",
            "iconClass": "ms-Icon ms-Icon--FabricSyncFolder"
        },
        {
            "iconName": "FabricUnsyncFolder",
            "iconClass": "ms-Icon ms-Icon--FabricUnsyncFolder"
        },
        {
            "iconName": "Family",
            "iconClass": "ms-Icon ms-Icon--Family"
        },
        {
            "iconName": "FangBody",
            "iconClass": "ms-Icon ms-Icon--FangBody"
        },
        {
            "iconName": "FastForward",
            "iconClass": "ms-Icon ms-Icon--FastForward"
        },
        {
            "iconName": "FastMode",
            "iconClass": "ms-Icon ms-Icon--FastMode"
        },
        {
            "iconName": "Favicon",
            "iconClass": "ms-Icon ms-Icon--Favicon"
        },
        {
            "iconName": "FavoriteList",
            "iconClass": "ms-Icon ms-Icon--FavoriteList"
        },
        {
            "iconName": "FavoriteStar",
            "iconClass": "ms-Icon ms-Icon--FavoriteStar"
        },
        {
            "iconName": "FavoriteStarFill",
            "iconClass": "ms-Icon ms-Icon--FavoriteStarFill"
        },
        {
            "iconName": "Fax",
            "iconClass": "ms-Icon ms-Icon--Fax"
        },
        {
            "iconName": "Feedback",
            "iconClass": "ms-Icon ms-Icon--Feedback"
        },
        // {
        //     "iconName": "FeedbackRequestMirroredSolid",
        //     "iconClass": "ms-Icon ms-Icon--FeedbackRequestMirroredSolid"
        // },
        // {
        //     "iconName": "FeedbackRequestSolid",
        //     "iconClass": "ms-Icon ms-Icon--FeedbackRequestSolid"
        // },
        {
            "iconName": "FeedbackResponseSolid",
            "iconClass": "ms-Icon ms-Icon--FeedbackResponseSolid"
        },
        {
            "iconName": "Ferry",
            "iconClass": "ms-Icon ms-Icon--Ferry"
        },
        {
            "iconName": "FerrySolid",
            "iconClass": "ms-Icon ms-Icon--FerrySolid"
        },
        {
            "iconName": "FieldChanged",
            "iconClass": "ms-Icon ms-Icon--FieldChanged"
        },
        {
            "iconName": "FieldEmpty",
            "iconClass": "ms-Icon ms-Icon--FieldEmpty"
        },
        {
            "iconName": "FieldFilled",
            "iconClass": "ms-Icon ms-Icon--FieldFilled"
        },
        {
            "iconName": "FieldNotChanged",
            "iconClass": "ms-Icon ms-Icon--FieldNotChanged"
        },
        {
            "iconName": "FieldReadOnly",
            "iconClass": "ms-Icon ms-Icon--FieldReadOnly"
        },
        {
            "iconName": "FieldRequired",
            "iconClass": "ms-Icon ms-Icon--FieldRequired"
        },
        {
            "iconName": "FileASPX",
            "iconClass": "ms-Icon ms-Icon--FileASPX"
        },
        {
            "iconName": "FileBug",
            "iconClass": "ms-Icon ms-Icon--FileBug"
        },
        {
            "iconName": "FileCode",
            "iconClass": "ms-Icon ms-Icon--FileCode"
        },
        {
            "iconName": "FileComment",
            "iconClass": "ms-Icon ms-Icon--FileComment"
        },
        {
            "iconName": "FileCSS",
            "iconClass": "ms-Icon ms-Icon--FileCSS"
        },
        {
            "iconName": "FileHTML",
            "iconClass": "ms-Icon ms-Icon--FileHTML"
        },
        {
            "iconName": "FileImage",
            "iconClass": "ms-Icon ms-Icon--FileImage"
        },
        {
            "iconName": "FileJAVA",
            "iconClass": "ms-Icon ms-Icon--FileJAVA"
        },
        {
            "iconName": "FileLess",
            "iconClass": "ms-Icon ms-Icon--FileLess"
        },
        {
            "iconName": "FilePDB",
            "iconClass": "ms-Icon ms-Icon--FilePDB"
        },
        {
            "iconName": "FileSass",
            "iconClass": "ms-Icon ms-Icon--FileSass"
        },
        {
            "iconName": "FileSQL",
            "iconClass": "ms-Icon ms-Icon--FileSQL"
        },
        {
            "iconName": "FileSymlink",
            "iconClass": "ms-Icon ms-Icon--FileSymlink"
        },
        {
            "iconName": "FileTemplate",
            "iconClass": "ms-Icon ms-Icon--FileTemplate"
        },
        {
            "iconName": "FileTypeSolution",
            "iconClass": "ms-Icon ms-Icon--FileTypeSolution"
        },
        {
            "iconName": "FileYML",
            "iconClass": "ms-Icon ms-Icon--FileYML"
        },
        {
            "iconName": "Filter",
            "iconClass": "ms-Icon ms-Icon--Filter"
        },
        {
            "iconName": "Filters",
            "iconClass": "ms-Icon ms-Icon--Filters"
        },
        {
            "iconName": "FilterSolid",
            "iconClass": "ms-Icon ms-Icon--FilterSolid"
        },
        {
            "iconName": "FiltersSolid",
            "iconClass": "ms-Icon ms-Icon--FiltersSolid"
        },
        {
            "iconName": "Financial",
            "iconClass": "ms-Icon ms-Icon--Financial"
        },
        // {
        //     "iconName": "FinancialMirroredSolid",
        //     "iconClass": "ms-Icon ms-Icon--FinancialMirroredSolid"
        // },
        // {
        //     "iconName": "FinancialSolid",
        //     "iconClass": "ms-Icon ms-Icon--FinancialSolid"
        // },
        {
            "iconName": "Fingerprint",
            "iconClass": "ms-Icon ms-Icon--Fingerprint"
        },
        {
            "iconName": "FiveTileGrid",
            "iconClass": "ms-Icon ms-Icon--FiveTileGrid"
        },
        {
            "iconName": "Flag",
            "iconClass": "ms-Icon ms-Icon--Flag"
        },
        {
            "iconName": "FlameSolid",
            "iconClass": "ms-Icon ms-Icon--FlameSolid"
        },
        {
            "iconName": "FlickDown",
            "iconClass": "ms-Icon ms-Icon--FlickDown"
        },
        {
            "iconName": "FlickLeft",
            "iconClass": "ms-Icon ms-Icon--FlickLeft"
        },
        {
            "iconName": "FlickRight",
            "iconClass": "ms-Icon ms-Icon--FlickRight"
        },
        {
            "iconName": "FlickUp",
            "iconClass": "ms-Icon ms-Icon--FlickUp"
        },
        {
            "iconName": "Flow",
            "iconClass": "ms-Icon ms-Icon--Flow"
        },
        {
            "iconName": "FocalPoint",
            "iconClass": "ms-Icon ms-Icon--FocalPoint"
        },
        {
            "iconName": "Fog",
            "iconClass": "ms-Icon ms-Icon--Fog"
        },
        {
            "iconName": "Folder",
            "iconClass": "ms-Icon ms-Icon--Folder"
        },
        {
            "iconName": "FolderFill",
            "iconClass": "ms-Icon ms-Icon--FolderFill"
        },
        {
            "iconName": "FolderHorizontal",
            "iconClass": "ms-Icon ms-Icon--FolderHorizontal"
        },
        // {
        //     "iconName": "FolderList",
        //     "iconClass": "ms-Icon ms-Icon--FolderList"
        // },
        // {
        //     "iconName": "FolderListMirrored",
        //     "iconClass": "ms-Icon ms-Icon--FolderListMirrored"
        // },
        {
            "iconName": "FolderOpen",
            "iconClass": "ms-Icon ms-Icon--FolderOpen"
        },
        {
            "iconName": "FolderQuery",
            "iconClass": "ms-Icon ms-Icon--FolderQuery"
        },
        {
            "iconName": "FolderSearch",
            "iconClass": "ms-Icon ms-Icon--FolderSearch"
        },
        {
            "iconName": "FollowUser",
            "iconClass": "ms-Icon ms-Icon--FollowUser"
        },
        {
            "iconName": "Font",
            "iconClass": "ms-Icon ms-Icon--Font"
        },
        {
            "iconName": "FontColor",
            "iconClass": "ms-Icon ms-Icon--FontColor"
        },
        {
            "iconName": "FontColorA",
            "iconClass": "ms-Icon ms-Icon--FontColorA"
        },
        {
            "iconName": "FontColorSwatch",
            "iconClass": "ms-Icon ms-Icon--FontColorSwatch"
        },
        {
            "iconName": "FontDecrease",
            "iconClass": "ms-Icon ms-Icon--FontDecrease"
        },
        {
            "iconName": "FontIncrease",
            "iconClass": "ms-Icon ms-Icon--FontIncrease"
        },
        {
            "iconName": "FontSize",
            "iconClass": "ms-Icon ms-Icon--FontSize"
        },
        // {
        //     "iconName": "FormLibrary",
        //     "iconClass": "ms-Icon ms-Icon--FormLibrary"
        // },
        // {
        //     "iconName": "FormLibraryMirrored",
        //     "iconClass": "ms-Icon ms-Icon--FormLibraryMirrored"
        // },
        {
            "iconName": "Forward",
            "iconClass": "ms-Icon ms-Icon--Forward"
        },
        {
            "iconName": "ForwardEvent",
            "iconClass": "ms-Icon ms-Icon--ForwardEvent"
        },
        {
            "iconName": "Freezing",
            "iconClass": "ms-Icon ms-Icon--Freezing"
        },
        {
            "iconName": "Frigid",
            "iconClass": "ms-Icon ms-Icon--Frigid"
        },
        {
            "iconName": "FSharp",
            "iconClass": "ms-Icon ms-Icon--FSharp"
        },
        {
            "iconName": "FSharpLanguage",
            "iconClass": "ms-Icon ms-Icon--FSharpLanguage"
        },
        {
            "iconName": "FullCircleMask",
            "iconClass": "ms-Icon ms-Icon--FullCircleMask"
        },
        {
            "iconName": "FullHistory",
            "iconClass": "ms-Icon ms-Icon--FullHistory"
        },
        {
            "iconName": "FullScreen",
            "iconClass": "ms-Icon ms-Icon--FullScreen"
        },
        {
            "iconName": "FullWidth",
            "iconClass": "ms-Icon ms-Icon--FullWidth"
        },
        {
            "iconName": "FullWidthEdit",
            "iconClass": "ms-Icon ms-Icon--FullWidthEdit"
        },
        {
            "iconName": "FunctionalManagerDashboard",
            "iconClass": "ms-Icon ms-Icon--FunctionalManagerDashboard"
        },
        // {
        //     "iconName": "GallatinLogo",
        //     "iconClass": "ms-Icon ms-Icon--GallatinLogo"
        // },
        {
            "iconName": "Generate",
            "iconClass": "ms-Icon ms-Icon--Generate"
        },
        {
            "iconName": "GenericScan",
            "iconClass": "ms-Icon ms-Icon--GenericScan"
        },
        {
            "iconName": "Giftbox",
            "iconClass": "ms-Icon ms-Icon--Giftbox"
        },
        {
            "iconName": "GiftboxOpen",
            "iconClass": "ms-Icon ms-Icon--GiftboxOpen"
        },
        {
            "iconName": "GiftBoxSolid",
            "iconClass": "ms-Icon ms-Icon--GiftBoxSolid"
        },
        {
            "iconName": "GiftCard",
            "iconClass": "ms-Icon ms-Icon--GiftCard"
        },
        {
            "iconName": "GitFork",
            "iconClass": "ms-Icon ms-Icon--GitFork"
        },
        {
            "iconName": "GitGraph",
            "iconClass": "ms-Icon ms-Icon--GitGraph"
        },
        {
            "iconName": "Glasses",
            "iconClass": "ms-Icon ms-Icon--Glasses"
        },
        {
            "iconName": "Glimmer",
            "iconClass": "ms-Icon ms-Icon--Glimmer"
        },
        {
            "iconName": "GlobalNavButton",
            "iconClass": "ms-Icon ms-Icon--GlobalNavButton"
        },
        {
            "iconName": "Globe",
            "iconClass": "ms-Icon ms-Icon--Globe"
        },
        {
            "iconName": "Globe2",
            "iconClass": "ms-Icon ms-Icon--Globe2"
        },
        {
            "iconName": "GlobeFavorite",
            "iconClass": "ms-Icon ms-Icon--GlobeFavorite"
        },
        {
            "iconName": "Golf",
            "iconClass": "ms-Icon ms-Icon--Golf"
        },
        {
            "iconName": "GotoToday",
            "iconClass": "ms-Icon ms-Icon--GotoToday"
        },
        {
            "iconName": "GridViewLarge",
            "iconClass": "ms-Icon ms-Icon--GridViewLarge"
        },
        {
            "iconName": "GridViewMedium",
            "iconClass": "ms-Icon ms-Icon--GridViewMedium"
        },
        {
            "iconName": "GridViewSmall",
            "iconClass": "ms-Icon ms-Icon--GridViewSmall"
        },
        {
            "iconName": "GripperBarHorizontal",
            "iconClass": "ms-Icon ms-Icon--GripperBarHorizontal"
        },
        {
            "iconName": "GripperBarVertical",
            "iconClass": "ms-Icon ms-Icon--GripperBarVertical"
        },
        {
            "iconName": "GripperTool",
            "iconClass": "ms-Icon ms-Icon--GripperTool"
        },
        {
            "iconName": "Group",
            "iconClass": "ms-Icon ms-Icon--Group"
        },
        {
            "iconName": "GroupedAscending",
            "iconClass": "ms-Icon ms-Icon--GroupedAscending"
        },
        {
            "iconName": "GroupedDescending",
            "iconClass": "ms-Icon ms-Icon--GroupedDescending"
        },
        {
            "iconName": "GroupedList",
            "iconClass": "ms-Icon ms-Icon--GroupedList"
        },
        {
            "iconName": "GroupObject",
            "iconClass": "ms-Icon ms-Icon--GroupObject"
        },
        {
            "iconName": "GUID",
            "iconClass": "ms-Icon ms-Icon--GUID"
        },
        {
            "iconName": "Guitar",
            "iconClass": "ms-Icon ms-Icon--Guitar"
        },
        {
            "iconName": "HailDay",
            "iconClass": "ms-Icon ms-Icon--HailDay"
        },
        {
            "iconName": "HailNight",
            "iconClass": "ms-Icon ms-Icon--HailNight"
        },
        {
            "iconName": "HalfAlpha",
            "iconClass": "ms-Icon ms-Icon--HalfAlpha"
        },
        {
            "iconName": "HalfCircle",
            "iconClass": "ms-Icon ms-Icon--HalfCircle"
        },
        {
            "iconName": "HandsFree",
            "iconClass": "ms-Icon ms-Icon--HandsFree"
        },
        {
            "iconName": "Handwriting",
            "iconClass": "ms-Icon ms-Icon--Handwriting"
        },
        {
            "iconName": "HardDrive",
            "iconClass": "ms-Icon ms-Icon--HardDrive"
        },
        {
            "iconName": "HardDriveGroup",
            "iconClass": "ms-Icon ms-Icon--HardDriveGroup"
        },
        {
            "iconName": "HardDriveLock",
            "iconClass": "ms-Icon ms-Icon--HardDriveLock"
        },
        {
            "iconName": "HardDriveUnlock",
            "iconClass": "ms-Icon ms-Icon--HardDriveUnlock"
        },
        {
            "iconName": "Header1",
            "iconClass": "ms-Icon ms-Icon--Header1"
        },
        {
            "iconName": "Header2",
            "iconClass": "ms-Icon ms-Icon--Header2"
        },
        {
            "iconName": "Header3",
            "iconClass": "ms-Icon ms-Icon--Header3"
        },
        {
            "iconName": "Header4",
            "iconClass": "ms-Icon ms-Icon--Header4"
        },
        {
            "iconName": "Headset",
            "iconClass": "ms-Icon ms-Icon--Headset"
        },
        {
            "iconName": "HeadsetSolid",
            "iconClass": "ms-Icon ms-Icon--HeadsetSolid"
        },
        {
            "iconName": "Health",
            "iconClass": "ms-Icon ms-Icon--Health"
        },
        {
            "iconName": "HealthSolid",
            "iconClass": "ms-Icon ms-Icon--HealthSolid"
        },
        {
            "iconName": "Heart",
            "iconClass": "ms-Icon ms-Icon--Heart"
        },
        {
            "iconName": "HeartBroken",
            "iconClass": "ms-Icon ms-Icon--HeartBroken"
        },
        {
            "iconName": "HeartFill",
            "iconClass": "ms-Icon ms-Icon--HeartFill"
        },
        // {
        //     "iconName": "Help",
        //     "iconClass": "ms-Icon ms-Icon--Help"
        // },
        // {
        //     "iconName": "HelpMirrored",
        //     "iconClass": "ms-Icon ms-Icon--HelpMirrored"
        // },
        {
            "iconName": "Hexagon",
            "iconClass": "ms-Icon ms-Icon--Hexagon"
        },
        {
            "iconName": "Hide",
            "iconClass": "ms-Icon ms-Icon--Hide"
        },
        {
            "iconName": "Hide2",
            "iconClass": "ms-Icon ms-Icon--Hide2"
        },
        {
            "iconName": "Highlight",
            "iconClass": "ms-Icon ms-Icon--Highlight"
        },
        {
            "iconName": "HighlightMappedShapes",
            "iconClass": "ms-Icon ms-Icon--HighlightMappedShapes"
        },
        {
            "iconName": "HintText",
            "iconClass": "ms-Icon ms-Icon--HintText"
        },
        {
            "iconName": "History",
            "iconClass": "ms-Icon ms-Icon--History"
        },
        {
            "iconName": "Home",
            "iconClass": "ms-Icon ms-Icon--Home"
        },
        {
            "iconName": "HomeSolid",
            "iconClass": "ms-Icon ms-Icon--HomeSolid"
        },
        {
            "iconName": "HorizontalDistributeCenter",
            "iconClass": "ms-Icon ms-Icon--HorizontalDistributeCenter"
        },
        {
            "iconName": "Hospital",
            "iconClass": "ms-Icon ms-Icon--Hospital"
        },
        {
            "iconName": "Hotel",
            "iconClass": "ms-Icon ms-Icon--Hotel"
        },
        {
            "iconName": "HourGlass",
            "iconClass": "ms-Icon ms-Icon--HourGlass"
        },
        {
            "iconName": "IconSetsFlag",
            "iconClass": "ms-Icon ms-Icon--IconSetsFlag"
        },
        {
            "iconName": "IDBadge",
            "iconClass": "ms-Icon ms-Icon--IDBadge"
        },
        {
            "iconName": "ImageCrosshair",
            "iconClass": "ms-Icon ms-Icon--ImageCrosshair"
        },
        {
            "iconName": "ImageDiff",
            "iconClass": "ms-Icon ms-Icon--ImageDiff"
        },
        {
            "iconName": "ImagePixel",
            "iconClass": "ms-Icon ms-Icon--ImagePixel"
        },
        {
            "iconName": "ImageSearch",
            "iconClass": "ms-Icon ms-Icon--ImageSearch"
        },
        // {
        //     "iconName": "Import",
        //     "iconClass": "ms-Icon ms-Icon--Import"
        // },
        {
            "iconName": "Important",
            "iconClass": "ms-Icon ms-Icon--Important"
        },
        // {
        //     "iconName": "ImportMirrored",
        //     "iconClass": "ms-Icon ms-Icon--ImportMirrored"
        // },
        {
            "iconName": "Inbox",
            "iconClass": "ms-Icon ms-Icon--Inbox"
        },
        {
            "iconName": "InboxCheck",
            "iconClass": "ms-Icon ms-Icon--InboxCheck"
        },
        {
            "iconName": "IncidentTriangle",
            "iconClass": "ms-Icon ms-Icon--IncidentTriangle"
        },
        {
            "iconName": "IncreaseIndentLegacy",
            "iconClass": "ms-Icon ms-Icon--IncreaseIndentLegacy"
        },
        {
            "iconName": "Info",
            "iconClass": "ms-Icon ms-Icon--Info"
        },
        {
            "iconName": "Info2",
            "iconClass": "ms-Icon ms-Icon--Info2"
        },
        {
            "iconName": "InfoSolid",
            "iconClass": "ms-Icon ms-Icon--InfoSolid"
        },
        {
            "iconName": "InsertColumnsLeft",
            "iconClass": "ms-Icon ms-Icon--InsertColumnsLeft"
        },
        {
            "iconName": "InsertColumnsRight",
            "iconClass": "ms-Icon ms-Icon--InsertColumnsRight"
        },
        {
            "iconName": "InsertRowsAbove",
            "iconClass": "ms-Icon ms-Icon--InsertRowsAbove"
        },
        {
            "iconName": "InsertRowsBelow",
            "iconClass": "ms-Icon ms-Icon--InsertRowsBelow"
        },
        {
            "iconName": "InsertSignatureLine",
            "iconClass": "ms-Icon ms-Icon--InsertSignatureLine"
        },
        {
            "iconName": "InsertTextBox",
            "iconClass": "ms-Icon ms-Icon--InsertTextBox"
        },
        {
            "iconName": "InstallToDrive",
            "iconClass": "ms-Icon ms-Icon--InstallToDrive"
        },
        {
            "iconName": "InternetSharing",
            "iconClass": "ms-Icon ms-Icon--InternetSharing"
        },
        // {
        //     "iconName": "IRMForward",
        //     "iconClass": "ms-Icon ms-Icon--IRMForward"
        // },
        {
            "iconName": "IRMForwardMirrored",
            "iconClass": "ms-Icon ms-Icon--IRMForwardMirrored"
        },
        // {
        //     "iconName": "IRMReply",
        //     "iconClass": "ms-Icon ms-Icon--IRMReply"
        // },
        // {
        //     "iconName": "IRMReplyMirrored",
        //     "iconClass": "ms-Icon ms-Icon--IRMReplyMirrored"
        // },
        {
            "iconName": "IssueSolid",
            "iconClass": "ms-Icon ms-Icon--IssueSolid"
        },
        // {
        //     "iconName": "IssueTracking",
        //     "iconClass": "ms-Icon ms-Icon--IssueTracking"
        // },
        // {
        //     "iconName": "IssueTrackingMirrored",
        //     "iconClass": "ms-Icon ms-Icon--IssueTrackingMirrored"
        // },
        {
            "iconName": "Italic",
            "iconClass": "ms-Icon ms-Icon--Italic"
        },
        {
            "iconName": "JavaScriptLanguage",
            "iconClass": "ms-Icon ms-Icon--JavaScriptLanguage"
        },
        {
            "iconName": "JoinOnlineMeeting",
            "iconClass": "ms-Icon ms-Icon--JoinOnlineMeeting"
        },
        {
            "iconName": "JS",
            "iconClass": "ms-Icon ms-Icon--JS"
        },
        {
            "iconName": "KaizalaLogo",
            "iconClass": "ms-Icon ms-Icon--KaizalaLogo"
        },
        {
            "iconName": "Label",
            "iconClass": "ms-Icon ms-Icon--Label"
        },
        {
            "iconName": "LadybugSolid",
            "iconClass": "ms-Icon ms-Icon--LadybugSolid"
        },
        {
            "iconName": "Lamp",
            "iconClass": "ms-Icon ms-Icon--Lamp"
        },
        {
            "iconName": "LandscapeOrientation",
            "iconClass": "ms-Icon ms-Icon--LandscapeOrientation"
        },
        {
            "iconName": "LaptopSecure",
            "iconClass": "ms-Icon ms-Icon--LaptopSecure"
        },
        {
            "iconName": "LaptopSelected",
            "iconClass": "ms-Icon ms-Icon--LaptopSelected"
        },
        {
            "iconName": "LargeGrid",
            "iconClass": "ms-Icon ms-Icon--LargeGrid"
        },
        {
            "iconName": "Leave",
            "iconClass": "ms-Icon ms-Icon--Leave"
        },
        {
            "iconName": "Library",
            "iconClass": "ms-Icon ms-Icon--Library"
        },
        {
            "iconName": "Lifesaver",
            "iconClass": "ms-Icon ms-Icon--Lifesaver"
        },
        {
            "iconName": "LifesaverLock",
            "iconClass": "ms-Icon ms-Icon--LifesaverLock"
        },
        {
            "iconName": "Light",
            "iconClass": "ms-Icon ms-Icon--Light"
        },
        {
            "iconName": "Lightbulb",
            "iconClass": "ms-Icon ms-Icon--Lightbulb"
        },
        {
            "iconName": "LightningBolt",
            "iconClass": "ms-Icon ms-Icon--LightningBolt"
        },
        {
            "iconName": "LightWeight",
            "iconClass": "ms-Icon ms-Icon--LightWeight"
        },
        {
            "iconName": "Like",
            "iconClass": "ms-Icon ms-Icon--Like"
        },
        {
            "iconName": "LikeSolid",
            "iconClass": "ms-Icon ms-Icon--LikeSolid"
        },
        {
            "iconName": "Line",
            "iconClass": "ms-Icon ms-Icon--Line"
        },
        {
            "iconName": "LineChart",
            "iconClass": "ms-Icon ms-Icon--LineChart"
        },
        {
            "iconName": "LineSpacing",
            "iconClass": "ms-Icon ms-Icon--LineSpacing"
        },
        {
            "iconName": "LineStyle",
            "iconClass": "ms-Icon ms-Icon--LineStyle"
        },
        {
            "iconName": "LineThickness",
            "iconClass": "ms-Icon ms-Icon--LineThickness"
        },
        {
            "iconName": "Link",
            "iconClass": "ms-Icon ms-Icon--Link"
        },
        {
            "iconName": "LinkedInLogo",
            "iconClass": "ms-Icon ms-Icon--LinkedInLogo"
        },
        // {
        //     "iconName": "List",
        //     "iconClass": "ms-Icon ms-Icon--List"
        // },
        // {
        //     "iconName": "ListMirrored",
        //     "iconClass": "ms-Icon ms-Icon--ListMirrored"
        // },
        {
            "iconName": "LocaleLanguage",
            "iconClass": "ms-Icon ms-Icon--LocaleLanguage"
        },
        {
            "iconName": "Location",
            "iconClass": "ms-Icon ms-Icon--Location"
        },
        {
            "iconName": "LocationCircle",
            "iconClass": "ms-Icon ms-Icon--LocationCircle"
        },
        {
            "iconName": "LocationDot",
            "iconClass": "ms-Icon ms-Icon--LocationDot"
        },
        {
            "iconName": "LocationFill",
            "iconClass": "ms-Icon ms-Icon--LocationFill"
        },
        {
            "iconName": "LocationOutline",
            "iconClass": "ms-Icon ms-Icon--LocationOutline"
        },
        {
            "iconName": "Lock",
            "iconClass": "ms-Icon ms-Icon--Lock"
        },
        {
            "iconName": "LockSolid",
            "iconClass": "ms-Icon ms-Icon--LockSolid"
        },
        {
            "iconName": "LogRemove",
            "iconClass": "ms-Icon ms-Icon--LogRemove"
        },
        {
            "iconName": "LookupEntities",
            "iconClass": "ms-Icon ms-Icon--LookupEntities"
        },
        {
            "iconName": "LowerBrightness",
            "iconClass": "ms-Icon ms-Icon--LowerBrightness"
        },
        {
            "iconName": "LyncLogo",
            "iconClass": "ms-Icon ms-Icon--LyncLogo"
        },
        {
            "iconName": "Mail",
            "iconClass": "ms-Icon ms-Icon--Mail"
        },
        {
            "iconName": "MailAlert",
            "iconClass": "ms-Icon ms-Icon--MailAlert"
        },
        {
            "iconName": "MailCheck",
            "iconClass": "ms-Icon ms-Icon--MailCheck"
        },
        {
            "iconName": "MailFill",
            "iconClass": "ms-Icon ms-Icon--MailFill"
        },
        // {
        //     "iconName": "MailForward",
        //     "iconClass": "ms-Icon ms-Icon--MailForward"
        // },
        // {
        //     "iconName": "MailForwardMirrored",
        //     "iconClass": "ms-Icon ms-Icon--MailForwardMirrored"
        // },
        {
            "iconName": "MailLowImportance",
            "iconClass": "ms-Icon ms-Icon--MailLowImportance"
        },
        {
            "iconName": "MailPause",
            "iconClass": "ms-Icon ms-Icon--MailPause"
        },
        {
            "iconName": "MailReminder",
            "iconClass": "ms-Icon ms-Icon--MailReminder"
        },
        {
            "iconName": "MailRepeat",
            "iconClass": "ms-Icon ms-Icon--MailRepeat"
        },
        // {
        //     "iconName": "MailReply",
        //     "iconClass": "ms-Icon ms-Icon--MailReply"
        // },
        // {
        //     "iconName": "MailReplyAll",
        //     "iconClass": "ms-Icon ms-Icon--MailReplyAll"
        // },
        // {
        //     "iconName": "MailReplyAllMirrored",
        //     "iconClass": "ms-Icon ms-Icon--MailReplyAllMirrored"
        // },
        // {
        //     "iconName": "MailReplyMirrored",
        //     "iconClass": "ms-Icon ms-Icon--MailReplyMirrored"
        // },
        {
            "iconName": "MailSolid",
            "iconClass": "ms-Icon ms-Icon--MailSolid"
        },
        // {
        //     "iconName": "MailTentative",
        //     "iconClass": "ms-Icon ms-Icon--MailTentative"
        // },
        // {
        //     "iconName": "MailTentativeMirrored",
        //     "iconClass": "ms-Icon ms-Icon--MailTentativeMirrored"
        // },
        {
            "iconName": "MailUndelivered",
            "iconClass": "ms-Icon ms-Icon--MailUndelivered"
        },
        {
            "iconName": "ManagerSelfService",
            "iconClass": "ms-Icon ms-Icon--ManagerSelfService"
        },
        {
            "iconName": "MapDirections",
            "iconClass": "ms-Icon ms-Icon--MapDirections"
        },
        {
            "iconName": "MapPin",
            "iconClass": "ms-Icon ms-Icon--MapPin"
        },
        {
            "iconName": "MapPinSolid",
            "iconClass": "ms-Icon ms-Icon--MapPinSolid"
        },
        {
            "iconName": "MarkDownLanguage",
            "iconClass": "ms-Icon ms-Icon--MarkDownLanguage"
        },
        {
            "iconName": "Market",
            "iconClass": "ms-Icon ms-Icon--Market"
        },
        {
            "iconName": "MarketDown",
            "iconClass": "ms-Icon ms-Icon--MarketDown"
        },
        {
            "iconName": "MasterDatabase",
            "iconClass": "ms-Icon ms-Icon--MasterDatabase"
        },
        {
            "iconName": "MaximumValue",
            "iconClass": "ms-Icon ms-Icon--MaximumValue"
        },
        {
            "iconName": "Medal",
            "iconClass": "ms-Icon ms-Icon--Medal"
        },
        {
            "iconName": "MediaAdd",
            "iconClass": "ms-Icon ms-Icon--MediaAdd"
        },
        {
            "iconName": "Medical",
            "iconClass": "ms-Icon ms-Icon--Medical"
        },
        {
            "iconName": "Megaphone",
            "iconClass": "ms-Icon ms-Icon--Megaphone"
        },
        {
            "iconName": "MegaphoneSolid",
            "iconClass": "ms-Icon ms-Icon--MegaphoneSolid"
        },
        {
            "iconName": "Memo",
            "iconClass": "ms-Icon ms-Icon--Memo"
        },
        {
            "iconName": "Merge",
            "iconClass": "ms-Icon ms-Icon--Merge"
        },
        {
            "iconName": "MergeDuplicate",
            "iconClass": "ms-Icon ms-Icon--MergeDuplicate"
        },
        {
            "iconName": "Message",
            "iconClass": "ms-Icon ms-Icon--Message"
        },
        {
            "iconName": "MessageFill",
            "iconClass": "ms-Icon ms-Icon--MessageFill"
        },
        {
            "iconName": "MicOff",
            "iconClass": "ms-Icon ms-Icon--MicOff"
        },
        {
            "iconName": "Microphone",
            "iconClass": "ms-Icon ms-Icon--Microphone"
        },
        {
            "iconName": "MicrosoftFlowLogo",
            "iconClass": "ms-Icon ms-Icon--MicrosoftFlowLogo"
        },
        {
            "iconName": "MicrosoftStaffhubLogo",
            "iconClass": "ms-Icon ms-Icon--MicrosoftStaffhubLogo"
        },
        {
            "iconName": "MiniContract",
            "iconClass": "ms-Icon ms-Icon--MiniContract"
        },
        {
            "iconName": "MiniExpand",
            "iconClass": "ms-Icon ms-Icon--MiniExpand"
        },
        {
            "iconName": "MiniLink",
            "iconClass": "ms-Icon ms-Icon--MiniLink"
        },
        {
            "iconName": "MinimumValue",
            "iconClass": "ms-Icon ms-Icon--MinimumValue"
        },
        {
            "iconName": "MobileReport",
            "iconClass": "ms-Icon ms-Icon--MobileReport"
        },
        {
            "iconName": "MobileSelected",
            "iconClass": "ms-Icon ms-Icon--MobileSelected"
        },
        {
            "iconName": "Money",
            "iconClass": "ms-Icon ms-Icon--Money"
        },
        {
            "iconName": "More",
            "iconClass": "ms-Icon ms-Icon--More"
        },
        {
            "iconName": "MoreSports",
            "iconClass": "ms-Icon ms-Icon--MoreSports"
        },
        {
            "iconName": "MoreVertical",
            "iconClass": "ms-Icon ms-Icon--MoreVertical"
        },
        {
            "iconName": "Move",
            "iconClass": "ms-Icon ms-Icon--Move"
        },
        {
            "iconName": "Movers",
            "iconClass": "ms-Icon ms-Icon--Movers"
        },
        {
            "iconName": "MoveToFolder",
            "iconClass": "ms-Icon ms-Icon--MoveToFolder"
        },
        {
            "iconName": "MSNLogo",
            "iconClass": "ms-Icon ms-Icon--MSNLogo"
        },
        {
            "iconName": "MSNVideos",
            "iconClass": "ms-Icon ms-Icon--MSNVideos"
        },
        {
            "iconName": "MSNVideosSolid",
            "iconClass": "ms-Icon ms-Icon--MSNVideosSolid"
        },
        {
            "iconName": "MTMLogo",
            "iconClass": "ms-Icon ms-Icon--MTMLogo"
        },
        // {
        //     "iconName": "MultiSelect",
        //     "iconClass": "ms-Icon ms-Icon--MultiSelect"
        // },
        // {
        //     "iconName": "MultiSelectMirrored",
        //     "iconClass": "ms-Icon ms-Icon--MultiSelectMirrored"
        // },
        {
            "iconName": "MusicInCollection",
            "iconClass": "ms-Icon ms-Icon--MusicInCollection"
        },
        {
            "iconName": "MusicInCollectionFill",
            "iconClass": "ms-Icon ms-Icon--MusicInCollectionFill"
        },
        {
            "iconName": "MusicNote",
            "iconClass": "ms-Icon ms-Icon--MusicNote"
        },
        {
            "iconName": "MyMoviesTV",
            "iconClass": "ms-Icon ms-Icon--MyMoviesTV"
        },
        {
            "iconName": "Nav2DMapView",
            "iconClass": "ms-Icon ms-Icon--Nav2DMapView"
        },
        // {
        //     "iconName": "NavigateBack",
        //     "iconClass": "ms-Icon ms-Icon--NavigateBack"
        // },
        // {
        //     "iconName": "NavigateBackMirrored",
        //     "iconClass": "ms-Icon ms-Icon--NavigateBackMirrored"
        // },
        {
            "iconName": "NavigateExternalInline",
            "iconClass": "ms-Icon ms-Icon--NavigateExternalInline"
        },
        // {
        //     "iconName": "NavigateForward",
        //     "iconClass": "ms-Icon ms-Icon--NavigateForward"
        // },
        // {
        //     "iconName": "NavigateForwardMirrored",
        //     "iconClass": "ms-Icon ms-Icon--NavigateForwardMirrored"
        // },
        {
            "iconName": "NavigationFlipper",
            "iconClass": "ms-Icon ms-Icon--NavigationFlipper"
        },
        {
            "iconName": "NetworkTower",
            "iconClass": "ms-Icon ms-Icon--NetworkTower"
        },
        {
            "iconName": "NewAnalyticsQuery",
            "iconClass": "ms-Icon ms-Icon--NewAnalyticsQuery"
        },
        {
            "iconName": "NewFolder",
            "iconClass": "ms-Icon ms-Icon--NewFolder"
        },
        {
            "iconName": "News",
            "iconClass": "ms-Icon ms-Icon--News"
        },
        {
            "iconName": "NewsSearch",
            "iconClass": "ms-Icon ms-Icon--NewsSearch"
        },
        {
            "iconName": "NewTeamProject",
            "iconClass": "ms-Icon ms-Icon--NewTeamProject"
        },
        {
            "iconName": "Next",
            "iconClass": "ms-Icon ms-Icon--Next"
        },
        {
            "iconName": "NonprofitLogo32",
            "iconClass": "ms-Icon ms-Icon--NonprofitLogo32"
        },
        {
            "iconName": "NormalWeight",
            "iconClass": "ms-Icon ms-Icon--NormalWeight"
        },
        {
            "iconName": "NoteForward",
            "iconClass": "ms-Icon ms-Icon--NoteForward"
        },
        {
            "iconName": "NotePinned",
            "iconClass": "ms-Icon ms-Icon--NotePinned"
        },
        {
            "iconName": "NoteReply",
            "iconClass": "ms-Icon ms-Icon--NoteReply"
        },
        {
            "iconName": "NotExecuted",
            "iconClass": "ms-Icon ms-Icon--NotExecuted"
        },
        {
            "iconName": "NotImpactedSolid",
            "iconClass": "ms-Icon ms-Icon--NotImpactedSolid"
        },
        {
            "iconName": "NugetLogo",
            "iconClass": "ms-Icon ms-Icon--NugetLogo"
        },
        {
            "iconName": "NumberedList",
            "iconClass": "ms-Icon ms-Icon--NumberedList"
        },
        {
            "iconName": "NumberField",
            "iconClass": "ms-Icon ms-Icon--NumberField"
        },
        {
            "iconName": "NumberSequence",
            "iconClass": "ms-Icon ms-Icon--NumberSequence"
        },
        {
            "iconName": "Octagon",
            "iconClass": "ms-Icon ms-Icon--Octagon"
        },
        {
            "iconName": "OEM",
            "iconClass": "ms-Icon ms-Icon--OEM"
        },
        {
            "iconName": "OfficeAddinsLogo",
            "iconClass": "ms-Icon ms-Icon--OfficeAddinsLogo"
        },
        {
            "iconName": "OfficeAssistantLogo",
            "iconClass": "ms-Icon ms-Icon--OfficeAssistantLogo"
        },
        {
            "iconName": "OfficeFormsLogo",
            "iconClass": "ms-Icon ms-Icon--OfficeFormsLogo"
        },
        {
            "iconName": "OfficeFormsLogo16",
            "iconClass": "ms-Icon ms-Icon--OfficeFormsLogo16"
        },
        {
            "iconName": "OfficeFormsLogo24",
            "iconClass": "ms-Icon ms-Icon--OfficeFormsLogo24"
        },
        {
            "iconName": "OfficeFormsLogoFill",
            "iconClass": "ms-Icon ms-Icon--OfficeFormsLogoFill"
        },
        {
            "iconName": "OfficeFormsLogoFill16",
            "iconClass": "ms-Icon ms-Icon--OfficeFormsLogoFill16"
        },
        {
            "iconName": "OfficeFormsLogoFill24",
            "iconClass": "ms-Icon ms-Icon--OfficeFormsLogoFill24"
        },
        {
            "iconName": "OfficeFormsLogoInverse",
            "iconClass": "ms-Icon ms-Icon--OfficeFormsLogoInverse"
        },
        {
            "iconName": "OfficeFormsLogoInverse16",
            "iconClass": "ms-Icon ms-Icon--OfficeFormsLogoInverse16"
        },
        {
            "iconName": "OfficeFormsLogoInverse24",
            "iconClass": "ms-Icon ms-Icon--OfficeFormsLogoInverse24"
        },
        {
            "iconName": "OfficeLogo",
            "iconClass": "ms-Icon ms-Icon--OfficeLogo"
        },
        {
            "iconName": "OfficeStoreLogo",
            "iconClass": "ms-Icon ms-Icon--OfficeStoreLogo"
        },
        {
            "iconName": "OfficeVideoLogo",
            "iconClass": "ms-Icon ms-Icon--OfficeVideoLogo"
        },
        {
            "iconName": "OfficeVideoLogoFill",
            "iconClass": "ms-Icon ms-Icon--OfficeVideoLogoFill"
        },
        {
            "iconName": "OfficeVideoLogoInverse",
            "iconClass": "ms-Icon ms-Icon--OfficeVideoLogoInverse"
        },
        {
            "iconName": "OfflineOneDriveParachute",
            "iconClass": "ms-Icon ms-Icon--OfflineOneDriveParachute"
        },
        {
            "iconName": "OfflineOneDriveParachuteDisabled",
            "iconClass": "ms-Icon ms-Icon--OfflineOneDriveParachuteDisabled"
        },
        {
            "iconName": "OfflineStorageSolid",
            "iconClass": "ms-Icon ms-Icon--OfflineStorageSolid"
        },
        {
            "iconName": "OneDrive",
            "iconClass": "ms-Icon ms-Icon--OneDrive"
        },
        {
            "iconName": "OneDriveAdd",
            "iconClass": "ms-Icon ms-Icon--OneDriveAdd"
        },
        {
            "iconName": "OneDriveFolder16",
            "iconClass": "ms-Icon ms-Icon--OneDriveFolder16"
        },
        {
            "iconName": "OneNoteEduLogoInverse",
            "iconClass": "ms-Icon ms-Icon--OneNoteEduLogoInverse"
        },
        {
            "iconName": "OneNoteLogo",
            "iconClass": "ms-Icon ms-Icon--OneNoteLogo"
        },
        {
            "iconName": "OneNoteLogo16",
            "iconClass": "ms-Icon ms-Icon--OneNoteLogo16"
        },
        {
            "iconName": "OneNoteLogoFill",
            "iconClass": "ms-Icon ms-Icon--OneNoteLogoFill"
        },
        {
            "iconName": "OneNoteLogoFill16",
            "iconClass": "ms-Icon ms-Icon--OneNoteLogoFill16"
        },
        {
            "iconName": "OneNoteLogoInverse",
            "iconClass": "ms-Icon ms-Icon--OneNoteLogoInverse"
        },
        {
            "iconName": "OneNoteLogoInverse16",
            "iconClass": "ms-Icon ms-Icon--OneNoteLogoInverse16"
        },
        {
            "iconName": "OpenFile",
            "iconClass": "ms-Icon ms-Icon--OpenFile"
        },
        {
            "iconName": "OpenFolderHorizontal",
            "iconClass": "ms-Icon ms-Icon--OpenFolderHorizontal"
        },
        {
            "iconName": "OpenInNewWindow",
            "iconClass": "ms-Icon ms-Icon--OpenInNewWindow"
        },
        // {
        //     "iconName": "OpenPane",
        //     "iconClass": "ms-Icon ms-Icon--OpenPane"
        // },
        // {
        //     "iconName": "OpenPaneMirrored",
        //     "iconClass": "ms-Icon ms-Icon--OpenPaneMirrored"
        // },
        {
            "iconName": "OpenSource",
            "iconClass": "ms-Icon ms-Icon--OpenSource"
        },
        {
            "iconName": "Org",
            "iconClass": "ms-Icon ms-Icon--Org"
        },
        {
            "iconName": "Orientation",
            "iconClass": "ms-Icon ms-Icon--Orientation"
        },
        {
            "iconName": "OutlookLogo",
            "iconClass": "ms-Icon ms-Icon--OutlookLogo"
        },
        {
            "iconName": "OutlookLogo16",
            "iconClass": "ms-Icon ms-Icon--OutlookLogo16"
        },
        {
            "iconName": "OutlookLogoFill",
            "iconClass": "ms-Icon ms-Icon--OutlookLogoFill"
        },
        {
            "iconName": "OutlookLogoFill16",
            "iconClass": "ms-Icon ms-Icon--OutlookLogoFill16"
        },
        {
            "iconName": "OutlookLogoInverse",
            "iconClass": "ms-Icon ms-Icon--OutlookLogoInverse"
        },
        {
            "iconName": "OutlookLogoInverse16",
            "iconClass": "ms-Icon ms-Icon--OutlookLogoInverse16"
        },
        {
            "iconName": "OutOfOffice",
            "iconClass": "ms-Icon ms-Icon--OutOfOffice"
        },
        {
            "iconName": "Package",
            "iconClass": "ms-Icon ms-Icon--Package"
        },
        {
            "iconName": "Packages",
            "iconClass": "ms-Icon ms-Icon--Packages"
        },
        {
            "iconName": "Padding",
            "iconClass": "ms-Icon ms-Icon--Padding"
        },
        {
            "iconName": "PaddingBottom",
            "iconClass": "ms-Icon ms-Icon--PaddingBottom"
        },
        {
            "iconName": "PaddingLeft",
            "iconClass": "ms-Icon ms-Icon--PaddingLeft"
        },
        {
            "iconName": "PaddingRight",
            "iconClass": "ms-Icon ms-Icon--PaddingRight"
        },
        {
            "iconName": "PaddingTop",
            "iconClass": "ms-Icon ms-Icon--PaddingTop"
        },
        {
            "iconName": "Page",
            "iconClass": "ms-Icon ms-Icon--Page"
        },
        {
            "iconName": "PageAdd",
            "iconClass": "ms-Icon ms-Icon--PageAdd"
        },
        {
            "iconName": "PageCheckedin",
            "iconClass": "ms-Icon ms-Icon--PageCheckedin"
        },
        {
            "iconName": "PageCheckedOut",
            "iconClass": "ms-Icon ms-Icon--PageCheckedOut"
        },
        {
            "iconName": "PageEdit",
            "iconClass": "ms-Icon ms-Icon--PageEdit"
        },
        {
            "iconName": "PageLeft",
            "iconClass": "ms-Icon ms-Icon--PageLeft"
        },
        // {
        //     "iconName": "PageListMirroredSolid",
        //     "iconClass": "ms-Icon ms-Icon--PageListMirroredSolid"
        // },
        // {
        //     "iconName": "PageListSolid",
        //     "iconClass": "ms-Icon ms-Icon--PageListSolid"
        // },
        {
            "iconName": "PageLock",
            "iconClass": "ms-Icon ms-Icon--PageLock"
        },
        {
            "iconName": "PageRemove",
            "iconClass": "ms-Icon ms-Icon--PageRemove"
        },
        {
            "iconName": "PageRight",
            "iconClass": "ms-Icon ms-Icon--PageRight"
        },
        {
            "iconName": "PageSolid",
            "iconClass": "ms-Icon ms-Icon--PageSolid"
        },
        {
            "iconName": "PanoIndicator",
            "iconClass": "ms-Icon ms-Icon--PanoIndicator"
        },
        {
            "iconName": "Parachute",
            "iconClass": "ms-Icon ms-Icon--Parachute"
        },
        {
            "iconName": "ParachuteSolid",
            "iconClass": "ms-Icon ms-Icon--ParachuteSolid"
        },
        {
            "iconName": "Parameter",
            "iconClass": "ms-Icon ms-Icon--Parameter"
        },
        // {
        //     "iconName": "ParkingLocation",
        //     "iconClass": "ms-Icon ms-Icon--ParkingLocation"
        // },
        // {
        //     "iconName": "ParkingLocationMirrored",
        //     "iconClass": "ms-Icon ms-Icon--ParkingLocationMirrored"
        // },
        // {
        //     "iconName": "ParkingMirroredSolid",
        //     "iconClass": "ms-Icon ms-Icon--ParkingMirroredSolid"
        // },
        // {
        //     "iconName": "ParkingSolid",
        //     "iconClass": "ms-Icon ms-Icon--ParkingSolid"
        // },
        {
            "iconName": "PartlyCloudyDay",
            "iconClass": "ms-Icon ms-Icon--PartlyCloudyDay"
        },
        {
            "iconName": "PartlyCloudyNight",
            "iconClass": "ms-Icon ms-Icon--PartlyCloudyNight"
        },
        {
            "iconName": "PartyLeader",
            "iconClass": "ms-Icon ms-Icon--PartyLeader"
        },
        {
            "iconName": "Paste",
            "iconClass": "ms-Icon ms-Icon--Paste"
        },
        {
            "iconName": "PasteAsCode",
            "iconClass": "ms-Icon ms-Icon--PasteAsCode"
        },
        {
            "iconName": "PasteAsText",
            "iconClass": "ms-Icon ms-Icon--PasteAsText"
        },
        {
            "iconName": "Pause",
            "iconClass": "ms-Icon ms-Icon--Pause"
        },
        {
            "iconName": "PaymentCard",
            "iconClass": "ms-Icon ms-Icon--PaymentCard"
        },
        {
            "iconName": "PC1",
            "iconClass": "ms-Icon ms-Icon--PC1"
        },
        {
            "iconName": "PDF",
            "iconClass": "ms-Icon ms-Icon--PDF"
        },
        {
            "iconName": "PencilReply",
            "iconClass": "ms-Icon ms-Icon--PencilReply"
        },
        {
            "iconName": "Pentagon",
            "iconClass": "ms-Icon ms-Icon--Pentagon"
        },
        {
            "iconName": "People",
            "iconClass": "ms-Icon ms-Icon--People"
        },
        {
            "iconName": "PeopleAdd",
            "iconClass": "ms-Icon ms-Icon--PeopleAdd"
        },
        {
            "iconName": "PeopleAlert",
            "iconClass": "ms-Icon ms-Icon--PeopleAlert"
        },
        {
            "iconName": "PeopleBlock",
            "iconClass": "ms-Icon ms-Icon--PeopleBlock"
        },
        {
            "iconName": "PeoplePause",
            "iconClass": "ms-Icon ms-Icon--PeoplePause"
        },
        {
            "iconName": "PeopleRepeat",
            "iconClass": "ms-Icon ms-Icon--PeopleRepeat"
        },
        {
            "iconName": "Permissions",
            "iconClass": "ms-Icon ms-Icon--Permissions"
        },
        {
            "iconName": "PermissionsSolid",
            "iconClass": "ms-Icon ms-Icon--PermissionsSolid"
        },
        {
            "iconName": "Personalize",
            "iconClass": "ms-Icon ms-Icon--Personalize"
        },
        {
            "iconName": "Phishing",
            "iconClass": "ms-Icon ms-Icon--Phishing"
        },
        {
            "iconName": "Phone",
            "iconClass": "ms-Icon ms-Icon--Phone"
        },
        {
            "iconName": "Photo2",
            "iconClass": "ms-Icon ms-Icon--Photo2"
        },
        {
            "iconName": "Photo2Add",
            "iconClass": "ms-Icon ms-Icon--Photo2Add"
        },
        {
            "iconName": "Photo2Remove",
            "iconClass": "ms-Icon ms-Icon--Photo2Remove"
        },
        {
            "iconName": "PhotoCollection",
            "iconClass": "ms-Icon ms-Icon--PhotoCollection"
        },
        {
            "iconName": "Picture",
            "iconClass": "ms-Icon ms-Icon--Picture"
        },
        {
            "iconName": "PictureCenter",
            "iconClass": "ms-Icon ms-Icon--PictureCenter"
        },
        {
            "iconName": "PictureFill",
            "iconClass": "ms-Icon ms-Icon--PictureFill"
        },
        {
            "iconName": "PictureLibrary",
            "iconClass": "ms-Icon ms-Icon--PictureLibrary"
        },
        {
            "iconName": "PicturePosition",
            "iconClass": "ms-Icon ms-Icon--PicturePosition"
        },
        {
            "iconName": "PictureStretch",
            "iconClass": "ms-Icon ms-Icon--PictureStretch"
        },
        {
            "iconName": "PictureTile",
            "iconClass": "ms-Icon ms-Icon--PictureTile"
        },
        {
            "iconName": "PieDouble",
            "iconClass": "ms-Icon ms-Icon--PieDouble"
        },
        {
            "iconName": "PieSingle",
            "iconClass": "ms-Icon ms-Icon--PieSingle"
        },
        {
            "iconName": "PieSingleSolid",
            "iconClass": "ms-Icon ms-Icon--PieSingleSolid"
        },
        {
            "iconName": "Pill",
            "iconClass": "ms-Icon ms-Icon--Pill"
        },
        {
            "iconName": "Pin",
            "iconClass": "ms-Icon ms-Icon--Pin"
        },
        {
            "iconName": "Pinned",
            "iconClass": "ms-Icon ms-Icon--Pinned"
        },
        {
            "iconName": "PinnedFill",
            "iconClass": "ms-Icon ms-Icon--PinnedFill"
        },
        {
            "iconName": "PivotChart",
            "iconClass": "ms-Icon ms-Icon--PivotChart"
        },
        {
            "iconName": "PlannerLogo",
            "iconClass": "ms-Icon ms-Icon--PlannerLogo"
        },
        {
            "iconName": "PlanView",
            "iconClass": "ms-Icon ms-Icon--PlanView"
        },
        {
            "iconName": "Play",
            "iconClass": "ms-Icon ms-Icon--Play"
        },
        {
            "iconName": "PlayerSettings",
            "iconClass": "ms-Icon ms-Icon--PlayerSettings"
        },
        {
            "iconName": "PlayResume",
            "iconClass": "ms-Icon ms-Icon--PlayResume"
        },
        {
            "iconName": "Plug",
            "iconClass": "ms-Icon ms-Icon--Plug"
        },
        {
            "iconName": "PlugConnected",
            "iconClass": "ms-Icon ms-Icon--PlugConnected"
        },
        {
            "iconName": "PlugDisconnected",
            "iconClass": "ms-Icon ms-Icon--PlugDisconnected"
        },
        {
            "iconName": "PlugSolid",
            "iconClass": "ms-Icon ms-Icon--PlugSolid"
        },
        {
            "iconName": "POI",
            "iconClass": "ms-Icon ms-Icon--POI"
        },
        {
            "iconName": "POISolid",
            "iconClass": "ms-Icon ms-Icon--POISolid"
        },
        {
            "iconName": "PostUpdate",
            "iconClass": "ms-Icon ms-Icon--PostUpdate"
        },
        {
            "iconName": "PowerApps",
            "iconClass": "ms-Icon ms-Icon--PowerApps"
        },
        {
            "iconName": "PowerApps2Logo",
            "iconClass": "ms-Icon ms-Icon--PowerApps2Logo"
        },
        {
            "iconName": "PowerAppsLogo",
            "iconClass": "ms-Icon ms-Icon--PowerAppsLogo"
        },
        {
            "iconName": "PowerBILogo",
            "iconClass": "ms-Icon ms-Icon--PowerBILogo"
        },
        {
            "iconName": "PowerButton",
            "iconClass": "ms-Icon ms-Icon--PowerButton"
        },
        {
            "iconName": "PowerPointDocument",
            "iconClass": "ms-Icon ms-Icon--PowerPointDocument"
        },
        {
            "iconName": "PowerPointLogo",
            "iconClass": "ms-Icon ms-Icon--PowerPointLogo"
        },
        {
            "iconName": "PowerPointLogo16",
            "iconClass": "ms-Icon ms-Icon--PowerPointLogo16"
        },
        {
            "iconName": "PowerPointLogoFill",
            "iconClass": "ms-Icon ms-Icon--PowerPointLogoFill"
        },
        {
            "iconName": "PowerPointLogoFill16",
            "iconClass": "ms-Icon ms-Icon--PowerPointLogoFill16"
        },
        {
            "iconName": "PowerPointLogoInverse",
            "iconClass": "ms-Icon ms-Icon--PowerPointLogoInverse"
        },
        {
            "iconName": "PowerPointLogoInverse16",
            "iconClass": "ms-Icon ms-Icon--PowerPointLogoInverse16"
        },
        {
            "iconName": "Precipitation",
            "iconClass": "ms-Icon ms-Icon--Precipitation"
        },
        {
            "iconName": "PresenceChickletVideo",
            "iconClass": "ms-Icon ms-Icon--PresenceChickletVideo"
        },
        {
            "iconName": "Preview",
            "iconClass": "ms-Icon ms-Icon--Preview"
        },
        {
            "iconName": "PreviewLink",
            "iconClass": "ms-Icon ms-Icon--PreviewLink"
        },
        {
            "iconName": "Previous",
            "iconClass": "ms-Icon ms-Icon--Previous"
        },
        {
            "iconName": "PrimaryCalendar",
            "iconClass": "ms-Icon ms-Icon--PrimaryCalendar"
        },
        {
            "iconName": "Print",
            "iconClass": "ms-Icon ms-Icon--Print"
        },
        {
            "iconName": "PrintfaxPrinterFile",
            "iconClass": "ms-Icon ms-Icon--PrintfaxPrinterFile"
        },
        {
            "iconName": "Processing",
            "iconClass": "ms-Icon ms-Icon--Processing"
        },
        {
            "iconName": "ProcessMetaTask",
            "iconClass": "ms-Icon ms-Icon--ProcessMetaTask"
        },
        {
            "iconName": "Product",
            "iconClass": "ms-Icon ms-Icon--Product"
        },
        {
            "iconName": "ProfileSearch",
            "iconClass": "ms-Icon ms-Icon--ProfileSearch"
        },
        {
            "iconName": "ProFootball",
            "iconClass": "ms-Icon ms-Icon--ProFootball"
        },
        {
            "iconName": "ProgressLoopInner",
            "iconClass": "ms-Icon ms-Icon--ProgressLoopInner"
        },
        {
            "iconName": "ProgressLoopOuter",
            "iconClass": "ms-Icon ms-Icon--ProgressLoopOuter"
        },
        {
            "iconName": "ProgressRingDots",
            "iconClass": "ms-Icon ms-Icon--ProgressRingDots"
        },
        {
            "iconName": "ProHockey",
            "iconClass": "ms-Icon ms-Icon--ProHockey"
        },
        {
            "iconName": "ProjectCollection",
            "iconClass": "ms-Icon ms-Icon--ProjectCollection"
        },
        {
            "iconName": "ProjectLogo16",
            "iconClass": "ms-Icon ms-Icon--ProjectLogo16"
        },
        {
            "iconName": "ProjectLogo32",
            "iconClass": "ms-Icon ms-Icon--ProjectLogo32"
        },
        {
            "iconName": "ProjectLogoFill16",
            "iconClass": "ms-Icon ms-Icon--ProjectLogoFill16"
        },
        {
            "iconName": "ProjectLogoFill32",
            "iconClass": "ms-Icon ms-Icon--ProjectLogoFill32"
        },
        {
            "iconName": "ProjectLogoInverse",
            "iconClass": "ms-Icon ms-Icon--ProjectLogoInverse"
        },
        {
            "iconName": "ProtectedDocument",
            "iconClass": "ms-Icon ms-Icon--ProtectedDocument"
        },
        {
            "iconName": "ProtectionCenterLogo32",
            "iconClass": "ms-Icon ms-Icon--ProtectionCenterLogo32"
        },
        {
            "iconName": "ProtectRestrict",
            "iconClass": "ms-Icon ms-Icon--ProtectRestrict"
        },
        {
            "iconName": "PublicCalendar",
            "iconClass": "ms-Icon ms-Icon--PublicCalendar"
        },
        // {
        //     "iconName": "PublicContactCard",
        //     "iconClass": "ms-Icon ms-Icon--PublicContactCard"
        // },
        // {
        //     "iconName": "PublicContactCardMirrored",
        //     "iconClass": "ms-Icon ms-Icon--PublicContactCardMirrored"
        // },
        {
            "iconName": "PublicEmail",
            "iconClass": "ms-Icon ms-Icon--PublicEmail"
        },
        {
            "iconName": "PublicFolder",
            "iconClass": "ms-Icon ms-Icon--PublicFolder"
        },
        {
            "iconName": "PublishCourse",
            "iconClass": "ms-Icon ms-Icon--PublishCourse"
        },
        {
            "iconName": "PublisherLogo",
            "iconClass": "ms-Icon ms-Icon--PublisherLogo"
        },
        {
            "iconName": "PublisherLogo16",
            "iconClass": "ms-Icon ms-Icon--PublisherLogo16"
        },
        {
            "iconName": "PublisherLogoFill",
            "iconClass": "ms-Icon ms-Icon--PublisherLogoFill"
        },
        {
            "iconName": "PublisherLogoFill16",
            "iconClass": "ms-Icon ms-Icon--PublisherLogoFill16"
        },
        {
            "iconName": "PublisherLogoInverse16",
            "iconClass": "ms-Icon ms-Icon--PublisherLogoInverse16"
        },
        {
            "iconName": "Puzzle",
            "iconClass": "ms-Icon ms-Icon--Puzzle"
        },
        {
            "iconName": "PY",
            "iconClass": "ms-Icon ms-Icon--PY"
        },
        {
            "iconName": "PythonLanguage",
            "iconClass": "ms-Icon ms-Icon--PythonLanguage"
        },
        {
            "iconName": "QuarterCircle",
            "iconClass": "ms-Icon ms-Icon--QuarterCircle"
        },
        {
            "iconName": "QueryList",
            "iconClass": "ms-Icon ms-Icon--QueryList"
        },
        // {
        //     "iconName": "Questionnaire",
        //     "iconClass": "ms-Icon ms-Icon--Questionnaire"
        // },
        // {
        //     "iconName": "QuestionnaireMirrored",
        //     "iconClass": "ms-Icon ms-Icon--QuestionnaireMirrored"
        // },
        {
            "iconName": "QuickNote",
            "iconClass": "ms-Icon ms-Icon--QuickNote"
        },
        {
            "iconName": "QuickNoteSolid",
            "iconClass": "ms-Icon ms-Icon--QuickNoteSolid"
        },
        {
            "iconName": "R",
            "iconClass": "ms-Icon ms-Icon--R"
        },
        {
            "iconName": "RadioBtnOff",
            "iconClass": "ms-Icon ms-Icon--RadioBtnOff"
        },
        {
            "iconName": "RadioBtnOn",
            "iconClass": "ms-Icon ms-Icon--RadioBtnOn"
        },
        {
            "iconName": "RadioBullet",
            "iconClass": "ms-Icon ms-Icon--RadioBullet"
        },
        {
            "iconName": "Rain",
            "iconClass": "ms-Icon ms-Icon--Rain"
        },
        {
            "iconName": "RainShowersDay",
            "iconClass": "ms-Icon ms-Icon--RainShowersDay"
        },
        {
            "iconName": "RainShowersNight",
            "iconClass": "ms-Icon ms-Icon--RainShowersNight"
        },
        {
            "iconName": "RainSnow",
            "iconClass": "ms-Icon ms-Icon--RainSnow"
        },
        {
            "iconName": "RawSource",
            "iconClass": "ms-Icon ms-Icon--RawSource"
        },
        {
            "iconName": "Read",
            "iconClass": "ms-Icon ms-Icon--Read"
        },
        {
            "iconName": "ReadingMode",
            "iconClass": "ms-Icon ms-Icon--ReadingMode"
        },
        {
            "iconName": "ReadingModeSolid",
            "iconClass": "ms-Icon ms-Icon--ReadingModeSolid"
        },
        {
            "iconName": "ReadOutLoud",
            "iconClass": "ms-Icon ms-Icon--ReadOutLoud"
        },
        {
            "iconName": "ReceiptCheck",
            "iconClass": "ms-Icon ms-Icon--ReceiptCheck"
        },
        {
            "iconName": "ReceiptForward",
            "iconClass": "ms-Icon ms-Icon--ReceiptForward"
        },
        {
            "iconName": "ReceiptReply",
            "iconClass": "ms-Icon ms-Icon--ReceiptReply"
        },
        // {
        //     "iconName": "ReceiptTentative",
        //     "iconClass": "ms-Icon ms-Icon--ReceiptTentative"
        // },
        // {
        //     "iconName": "ReceiptTentativeMirrored",
        //     "iconClass": "ms-Icon ms-Icon--ReceiptTentativeMirrored"
        // },
        {
            "iconName": "ReceiptUndelivered",
            "iconClass": "ms-Icon ms-Icon--ReceiptUndelivered"
        },
        {
            "iconName": "Recent",
            "iconClass": "ms-Icon ms-Icon--Recent"
        },
        {
            "iconName": "Record2",
            "iconClass": "ms-Icon ms-Icon--Record2"
        },
        {
            "iconName": "RectangleShapeSolid",
            "iconClass": "ms-Icon ms-Icon--RectangleShapeSolid"
        },
        {
            "iconName": "RectangularClipping",
            "iconClass": "ms-Icon ms-Icon--RectangularClipping"
        },
        {
            "iconName": "RecurringEvent",
            "iconClass": "ms-Icon ms-Icon--RecurringEvent"
        },
        {
            "iconName": "RecurringTask",
            "iconClass": "ms-Icon ms-Icon--RecurringTask"
        },
        {
            "iconName": "RecycleBin",
            "iconClass": "ms-Icon ms-Icon--RecycleBin"
        },
        {
            "iconName": "Redeploy",
            "iconClass": "ms-Icon ms-Icon--Redeploy"
        },
        {
            "iconName": "RedEye",
            "iconClass": "ms-Icon ms-Icon--RedEye"
        },
        {
            "iconName": "Redo",
            "iconClass": "ms-Icon ms-Icon--Redo"
        },
        {
            "iconName": "Refresh",
            "iconClass": "ms-Icon ms-Icon--Refresh"
        },
        {
            "iconName": "ReminderGroup",
            "iconClass": "ms-Icon ms-Icon--ReminderGroup"
        },
        {
            "iconName": "ReminderPerson",
            "iconClass": "ms-Icon ms-Icon--ReminderPerson"
        },
        {
            "iconName": "Remote",
            "iconClass": "ms-Icon ms-Icon--Remote"
        },
        {
            "iconName": "Remove",
            "iconClass": "ms-Icon ms-Icon--Remove"
        },
        {
            "iconName": "RemoveEvent",
            "iconClass": "ms-Icon ms-Icon--RemoveEvent"
        },
        {
            "iconName": "RemoveFilter",
            "iconClass": "ms-Icon ms-Icon--RemoveFilter"
        },
        {
            "iconName": "RemoveLink",
            "iconClass": "ms-Icon ms-Icon--RemoveLink"
        },
        {
            "iconName": "RemoveOccurrence",
            "iconClass": "ms-Icon ms-Icon--RemoveOccurrence"
        },
        {
            "iconName": "Rename",
            "iconClass": "ms-Icon ms-Icon--Rename"
        },
        {
            "iconName": "RenewalCurrent",
            "iconClass": "ms-Icon ms-Icon--RenewalCurrent"
        },
        {
            "iconName": "RenewalFuture",
            "iconClass": "ms-Icon ms-Icon--RenewalFuture"
        },
        {
            "iconName": "ReopenPages",
            "iconClass": "ms-Icon ms-Icon--ReopenPages"
        },
        {
            "iconName": "Repair",
            "iconClass": "ms-Icon ms-Icon--Repair"
        },
        // {
        //     "iconName": "Reply",
        //     "iconClass": "ms-Icon ms-Icon--Reply"
        // },
        // {
        //     "iconName": "ReplyAll",
        //     "iconClass": "ms-Icon ms-Icon--ReplyAll"
        // },
        {
            "iconName": "ReplyAllAlt",
            "iconClass": "ms-Icon ms-Icon--ReplyAllAlt"
        },
        // {
        //     "iconName": "ReplyAllMirrored",
        //     "iconClass": "ms-Icon ms-Icon--ReplyAllMirrored"
        // },
        {
            "iconName": "ReplyAlt",
            "iconClass": "ms-Icon ms-Icon--ReplyAlt"
        },
        // {
        //     "iconName": "ReplyMirrored",
        //     "iconClass": "ms-Icon ms-Icon--ReplyMirrored"
        // },
        {
            "iconName": "Repo",
            "iconClass": "ms-Icon ms-Icon--Repo"
        },
        {
            "iconName": "ReportAdd",
            "iconClass": "ms-Icon ms-Icon--ReportAdd"
        },
        {
            "iconName": "ReportHacked",
            "iconClass": "ms-Icon ms-Icon--ReportHacked"
        },
        // {
        //     "iconName": "ReportLibrary",
        //     "iconClass": "ms-Icon ms-Icon--ReportLibrary"
        // },
        // {
        //     "iconName": "ReportLibraryMirrored",
        //     "iconClass": "ms-Icon ms-Icon--ReportLibraryMirrored"
        // },
        {
            "iconName": "RepoSolid",
            "iconClass": "ms-Icon ms-Icon--RepoSolid"
        },
        {
            "iconName": "ReturnToSession",
            "iconClass": "ms-Icon ms-Icon--ReturnToSession"
        },
        // {
        //     "iconName": "ReviewRequestMirroredSolid",
        //     "iconClass": "ms-Icon ms-Icon--ReviewRequestMirroredSolid"
        // },
        // {
        //     "iconName": "ReviewRequestSolid",
        //     "iconClass": "ms-Icon ms-Icon--ReviewRequestSolid"
        // },
        {
            "iconName": "ReviewResponseSolid",
            "iconClass": "ms-Icon ms-Icon--ReviewResponseSolid"
        },
        {
            "iconName": "ReviewSolid",
            "iconClass": "ms-Icon ms-Icon--ReviewSolid"
        },
        {
            "iconName": "RevToggleKey",
            "iconClass": "ms-Icon ms-Icon--RevToggleKey"
        },
        {
            "iconName": "Rewind",
            "iconClass": "ms-Icon ms-Icon--Rewind"
        },
        {
            "iconName": "Ribbon",
            "iconClass": "ms-Icon ms-Icon--Ribbon"
        },
        {
            "iconName": "RibbonSolid",
            "iconClass": "ms-Icon ms-Icon--RibbonSolid"
        },
        {
            "iconName": "RightDoubleQuote",
            "iconClass": "ms-Icon ms-Icon--RightDoubleQuote"
        },
        {
            "iconName": "RightTriangle",
            "iconClass": "ms-Icon ms-Icon--RightTriangle"
        },
        {
            "iconName": "Ringer",
            "iconClass": "ms-Icon ms-Icon--Ringer"
        },
        {
            "iconName": "RingerOff",
            "iconClass": "ms-Icon ms-Icon--RingerOff"
        },
        {
            "iconName": "RingerRemove",
            "iconClass": "ms-Icon ms-Icon--RingerRemove"
        },
        {
            "iconName": "Robot",
            "iconClass": "ms-Icon ms-Icon--Robot"
        },
        {
            "iconName": "Rocket",
            "iconClass": "ms-Icon ms-Icon--Rocket"
        },
        {
            "iconName": "Room",
            "iconClass": "ms-Icon ms-Icon--Room"
        },
        {
            "iconName": "Rotate",
            "iconClass": "ms-Icon ms-Icon--Rotate"
        },
        {
            "iconName": "RowsChild",
            "iconClass": "ms-Icon ms-Icon--RowsChild"
        },
        {
            "iconName": "RowsGroup",
            "iconClass": "ms-Icon ms-Icon--RowsGroup"
        },
        {
            "iconName": "Rugby",
            "iconClass": "ms-Icon ms-Icon--Rugby"
        },
        {
            "iconName": "Running",
            "iconClass": "ms-Icon ms-Icon--Running"
        },
        {
            "iconName": "Sad",
            "iconClass": "ms-Icon ms-Icon--Sad"
        },
        {
            "iconName": "SadSolid",
            "iconClass": "ms-Icon ms-Icon--SadSolid"
        },
        {
            "iconName": "Save",
            "iconClass": "ms-Icon ms-Icon--Save"
        },
        {
            "iconName": "SaveAll",
            "iconClass": "ms-Icon ms-Icon--SaveAll"
        },
        {
            "iconName": "SaveAndClose",
            "iconClass": "ms-Icon ms-Icon--SaveAndClose"
        },
        {
            "iconName": "SaveAs",
            "iconClass": "ms-Icon ms-Icon--SaveAs"
        },
        {
            "iconName": "Savings",
            "iconClass": "ms-Icon ms-Icon--Savings"
        },
        {
            "iconName": "ScaleUp",
            "iconClass": "ms-Icon ms-Icon--ScaleUp"
        },
        {
            "iconName": "ScheduleEventAction",
            "iconClass": "ms-Icon ms-Icon--ScheduleEventAction"
        },
        {
            "iconName": "ScopeTemplate",
            "iconClass": "ms-Icon ms-Icon--ScopeTemplate"
        },
        {
            "iconName": "Script",
            "iconClass": "ms-Icon ms-Icon--Script"
        },
        {
            "iconName": "ScrollUpDown",
            "iconClass": "ms-Icon ms-Icon--ScrollUpDown"
        },
        {
            "iconName": "Search",
            "iconClass": "ms-Icon ms-Icon--Search"
        },
        {
            "iconName": "SearchAndApps",
            "iconClass": "ms-Icon ms-Icon--SearchAndApps"
        },
        {
            "iconName": "SearchBookmark",
            "iconClass": "ms-Icon ms-Icon--SearchBookmark"
        },
        {
            "iconName": "SearchCalendar",
            "iconClass": "ms-Icon ms-Icon--SearchCalendar"
        },
        // {
        //     "iconName": "SearchIssue",
        //     "iconClass": "ms-Icon ms-Icon--SearchIssue"
        // },
        // {
        //     "iconName": "SearchIssueMirrored",
        //     "iconClass": "ms-Icon ms-Icon--SearchIssueMirrored"
        // },
        {
            "iconName": "Section",
            "iconClass": "ms-Icon ms-Icon--Section"
        },
        {
            "iconName": "Sections",
            "iconClass": "ms-Icon ms-Icon--Sections"
        },
        {
            "iconName": "SecurityGroup",
            "iconClass": "ms-Icon ms-Icon--SecurityGroup"
        },
        {
            "iconName": "SelectAll",
            "iconClass": "ms-Icon ms-Icon--SelectAll"
        },
        {
            "iconName": "Sell",
            "iconClass": "ms-Icon ms-Icon--Sell"
        },
        {
            "iconName": "SemiboldWeight",
            "iconClass": "ms-Icon ms-Icon--SemiboldWeight"
        },
        // {
        //     "iconName": "Send",
        //     "iconClass": "ms-Icon ms-Icon--Send"
        // },
        // {
        //     "iconName": "SendMirrored",
        //     "iconClass": "ms-Icon ms-Icon--SendMirrored"
        // },
        {
            "iconName": "Separator",
            "iconClass": "ms-Icon ms-Icon--Separator"
        },
        {
            "iconName": "Server",
            "iconClass": "ms-Icon ms-Icon--Server"
        },
        {
            "iconName": "ServerEnviroment",
            "iconClass": "ms-Icon ms-Icon--ServerEnviroment"
        },
        {
            "iconName": "ServerProcesses",
            "iconClass": "ms-Icon ms-Icon--ServerProcesses"
        },
        {
            "iconName": "SetAction",
            "iconClass": "ms-Icon ms-Icon--SetAction"
        },
        {
            "iconName": "Settings",
            "iconClass": "ms-Icon ms-Icon--Settings"
        },
        {
            "iconName": "Share",
            "iconClass": "ms-Icon ms-Icon--Share"
        },
        {
            "iconName": "ShareiOS",
            "iconClass": "ms-Icon ms-Icon--ShareiOS"
        },
        {
            "iconName": "SharepointLogo",
            "iconClass": "ms-Icon ms-Icon--SharepointLogo"
        },
        {
            "iconName": "SharepointLogoFill",
            "iconClass": "ms-Icon ms-Icon--SharepointLogoFill"
        },
        {
            "iconName": "SharepointLogoInverse",
            "iconClass": "ms-Icon ms-Icon--SharepointLogoInverse"
        },
        {
            "iconName": "Shield",
            "iconClass": "ms-Icon ms-Icon--Shield"
        },
        {
            "iconName": "ShieldSolid",
            "iconClass": "ms-Icon ms-Icon--ShieldSolid"
        },
        {
            "iconName": "Shop",
            "iconClass": "ms-Icon ms-Icon--Shop"
        },
        {
            "iconName": "ShoppingCart",
            "iconClass": "ms-Icon ms-Icon--ShoppingCart"
        },
        {
            "iconName": "ShoppingCartSolid",
            "iconClass": "ms-Icon ms-Icon--ShoppingCartSolid"
        },
        {
            "iconName": "ShopServer",
            "iconClass": "ms-Icon ms-Icon--ShopServer"
        },
        // {
        //     "iconName": "ShowResults",
        //     "iconClass": "ms-Icon ms-Icon--ShowResults"
        // },
        // {
        //     "iconName": "ShowResultsMirrored",
        //     "iconClass": "ms-Icon ms-Icon--ShowResultsMirrored"
        // },
        // {
        //     "iconName": "SidePanel",
        //     "iconClass": "ms-Icon ms-Icon--SidePanel"
        // },
        // {
        //     "iconName": "SidePanelMirrored",
        //     "iconClass": "ms-Icon ms-Icon--SidePanelMirrored"
        // },
        {
            "iconName": "SignOut",
            "iconClass": "ms-Icon ms-Icon--SignOut"
        },
        {
            "iconName": "SingleBookmark",
            "iconClass": "ms-Icon ms-Icon--SingleBookmark"
        },
        {
            "iconName": "SingleBookmarkSolid",
            "iconClass": "ms-Icon ms-Icon--SingleBookmarkSolid"
        },
        {
            "iconName": "SingleColumn",
            "iconClass": "ms-Icon ms-Icon--SingleColumn"
        },
        {
            "iconName": "SingleColumnEdit",
            "iconClass": "ms-Icon ms-Icon--SingleColumnEdit"
        },
        {
            "iconName": "SIPMove",
            "iconClass": "ms-Icon ms-Icon--SIPMove"
        },
        {
            "iconName": "SiteScan",
            "iconClass": "ms-Icon ms-Icon--SiteScan"
        },
        {
            "iconName": "SizeLegacy",
            "iconClass": "ms-Icon ms-Icon--SizeLegacy"
        },
        {
            "iconName": "SkiResorts",
            "iconClass": "ms-Icon ms-Icon--SkiResorts"
        },
        {
            "iconName": "SkypeCheck",
            "iconClass": "ms-Icon ms-Icon--SkypeCheck"
        },
        {
            "iconName": "SkypeCircleCheck",
            "iconClass": "ms-Icon ms-Icon--SkypeCircleCheck"
        },
        {
            "iconName": "SkypeCircleClock",
            "iconClass": "ms-Icon ms-Icon--SkypeCircleClock"
        },
        {
            "iconName": "SkypeCircleMinus",
            "iconClass": "ms-Icon ms-Icon--SkypeCircleMinus"
        },
        {
            "iconName": "SkypeClock",
            "iconClass": "ms-Icon ms-Icon--SkypeClock"
        },
        {
            "iconName": "SkypeForBusinessLogo",
            "iconClass": "ms-Icon ms-Icon--SkypeForBusinessLogo"
        },
        {
            "iconName": "SkypeForBusinessLogo16",
            "iconClass": "ms-Icon ms-Icon--SkypeForBusinessLogo16"
        },
        {
            "iconName": "SkypeForBusinessLogoFill",
            "iconClass": "ms-Icon ms-Icon--SkypeForBusinessLogoFill"
        },
        {
            "iconName": "SkypeForBusinessLogoFill16",
            "iconClass": "ms-Icon ms-Icon--SkypeForBusinessLogoFill16"
        },
        {
            "iconName": "SkypeLogo",
            "iconClass": "ms-Icon ms-Icon--SkypeLogo"
        },
        {
            "iconName": "SkypeLogo16",
            "iconClass": "ms-Icon ms-Icon--SkypeLogo16"
        },
        {
            "iconName": "SkypeMessage",
            "iconClass": "ms-Icon ms-Icon--SkypeMessage"
        },
        {
            "iconName": "SkypeMinus",
            "iconClass": "ms-Icon ms-Icon--SkypeMinus"
        },
        {
            "iconName": "Slider",
            "iconClass": "ms-Icon ms-Icon--Slider"
        },
        {
            "iconName": "SliderHandleSize",
            "iconClass": "ms-Icon ms-Icon--SliderHandleSize"
        },
        {
            "iconName": "SliderThumb",
            "iconClass": "ms-Icon ms-Icon--SliderThumb"
        },
        {
            "iconName": "Snooze",
            "iconClass": "ms-Icon ms-Icon--Snooze"
        },
        {
            "iconName": "Snow",
            "iconClass": "ms-Icon ms-Icon--Snow"
        },
        {
            "iconName": "Snowflake",
            "iconClass": "ms-Icon ms-Icon--Snowflake"
        },
        {
            "iconName": "SnowShowerDay",
            "iconClass": "ms-Icon ms-Icon--SnowShowerDay"
        },
        {
            "iconName": "SnowShowerNight",
            "iconClass": "ms-Icon ms-Icon--SnowShowerNight"
        },
        {
            "iconName": "Soccer",
            "iconClass": "ms-Icon ms-Icon--Soccer"
        },
        {
            "iconName": "SocialListeningLogo",
            "iconClass": "ms-Icon ms-Icon--SocialListeningLogo"
        },
        {
            "iconName": "Sort",
            "iconClass": "ms-Icon ms-Icon--Sort"
        },
        {
            "iconName": "SortDown",
            "iconClass": "ms-Icon ms-Icon--SortDown"
        },
        {
            "iconName": "SortLines",
            "iconClass": "ms-Icon ms-Icon--SortLines"
        },
        {
            "iconName": "SortUp",
            "iconClass": "ms-Icon ms-Icon--SortUp"
        },
        {
            "iconName": "Source",
            "iconClass": "ms-Icon ms-Icon--Source"
        },
        {
            "iconName": "Spacer",
            "iconClass": "ms-Icon ms-Icon--Spacer"
        },
        {
            "iconName": "Speakers",
            "iconClass": "ms-Icon ms-Icon--Speakers"
        },
        {
            "iconName": "SpeedHigh",
            "iconClass": "ms-Icon ms-Icon--SpeedHigh"
        },
        {
            "iconName": "Split",
            "iconClass": "ms-Icon ms-Icon--Split"
        },
        {
            "iconName": "SplitObject",
            "iconClass": "ms-Icon ms-Icon--SplitObject"
        },
        {
            "iconName": "Sprint",
            "iconClass": "ms-Icon ms-Icon--Sprint"
        },
        {
            "iconName": "Squalls",
            "iconClass": "ms-Icon ms-Icon--Squalls"
        },
        {
            "iconName": "SquareShapeSolid",
            "iconClass": "ms-Icon ms-Icon--SquareShapeSolid"
        },
        {
            "iconName": "Stack",
            "iconClass": "ms-Icon ms-Icon--Stack"
        },
        {
            "iconName": "StackedBarChart",
            "iconClass": "ms-Icon ms-Icon--StackedBarChart"
        },
        {
            "iconName": "StackedLineChart",
            "iconClass": "ms-Icon ms-Icon--StackedLineChart"
        },
        {
            "iconName": "StackIndicator",
            "iconClass": "ms-Icon ms-Icon--StackIndicator"
        },
        {
            "iconName": "StaffNotebookLogo16",
            "iconClass": "ms-Icon ms-Icon--StaffNotebookLogo16"
        },
        {
            "iconName": "StaffNotebookLogo32",
            "iconClass": "ms-Icon ms-Icon--StaffNotebookLogo32"
        },
        {
            "iconName": "StaffNotebookLogoFill16",
            "iconClass": "ms-Icon ms-Icon--StaffNotebookLogoFill16"
        },
        {
            "iconName": "StaffNotebookLogoFill32",
            "iconClass": "ms-Icon ms-Icon--StaffNotebookLogoFill32"
        },
        {
            "iconName": "StaffNotebookLogoInverted16",
            "iconClass": "ms-Icon ms-Icon--StaffNotebookLogoInverted16"
        },
        {
            "iconName": "StaffNotebookLogoInverted32",
            "iconClass": "ms-Icon ms-Icon--StaffNotebookLogoInverted32"
        },
        {
            "iconName": "Starburst",
            "iconClass": "ms-Icon ms-Icon--Starburst"
        },
        {
            "iconName": "StarburstSolid",
            "iconClass": "ms-Icon ms-Icon--StarburstSolid"
        },
        {
            "iconName": "StatusCircleBlock2",
            "iconClass": "ms-Icon ms-Icon--StatusCircleBlock2"
        },
        {
            "iconName": "StatusCircleCheckmark",
            "iconClass": "ms-Icon ms-Icon--StatusCircleCheckmark"
        },
        {
            "iconName": "StatusCircleErrorX",
            "iconClass": "ms-Icon ms-Icon--StatusCircleErrorX"
        },
        {
            "iconName": "StatusCircleExclamation",
            "iconClass": "ms-Icon ms-Icon--StatusCircleExclamation"
        },
        {
            "iconName": "StatusCircleInfo",
            "iconClass": "ms-Icon ms-Icon--StatusCircleInfo"
        },
        {
            "iconName": "StatusCircleInner",
            "iconClass": "ms-Icon ms-Icon--StatusCircleInner"
        },
        {
            "iconName": "StatusCircleOuter",
            "iconClass": "ms-Icon ms-Icon--StatusCircleOuter"
        },
        {
            "iconName": "StatusCircleQuestionMark",
            "iconClass": "ms-Icon ms-Icon--StatusCircleQuestionMark"
        },
        {
            "iconName": "StatusCircleRing",
            "iconClass": "ms-Icon ms-Icon--StatusCircleRing"
        },
        {
            "iconName": "StatusErrorFull",
            "iconClass": "ms-Icon ms-Icon--StatusErrorFull"
        },
        {
            "iconName": "StatusTriangle",
            "iconClass": "ms-Icon ms-Icon--StatusTriangle"
        },
        {
            "iconName": "StatusTriangleExclamation",
            "iconClass": "ms-Icon ms-Icon--StatusTriangleExclamation"
        },
        {
            "iconName": "StatusTriangleInner",
            "iconClass": "ms-Icon ms-Icon--StatusTriangleInner"
        },
        {
            "iconName": "StatusTriangleOuter",
            "iconClass": "ms-Icon ms-Icon--StatusTriangleOuter"
        },
        {
            "iconName": "Step",
            "iconClass": "ms-Icon ms-Icon--Step"
        },
        {
            "iconName": "StepInsert",
            "iconClass": "ms-Icon ms-Icon--StepInsert"
        },
        {
            "iconName": "StepShared",
            "iconClass": "ms-Icon ms-Icon--StepShared"
        },
        {
            "iconName": "StepSharedAdd",
            "iconClass": "ms-Icon ms-Icon--StepSharedAdd"
        },
        {
            "iconName": "StepSharedInsert",
            "iconClass": "ms-Icon ms-Icon--StepSharedInsert"
        },
        {
            "iconName": "StockDown",
            "iconClass": "ms-Icon ms-Icon--StockDown"
        },
        {
            "iconName": "StockUp",
            "iconClass": "ms-Icon ms-Icon--StockUp"
        },
        {
            "iconName": "Stop",
            "iconClass": "ms-Icon ms-Icon--Stop"
        },
        {
            "iconName": "StopSolid",
            "iconClass": "ms-Icon ms-Icon--StopSolid"
        },
        {
            "iconName": "Stopwatch",
            "iconClass": "ms-Icon ms-Icon--Stopwatch"
        },
        {
            "iconName": "StoreLogo16",
            "iconClass": "ms-Icon ms-Icon--StoreLogo16"
        },
        {
            "iconName": "StoreLogoMed20",
            "iconClass": "ms-Icon ms-Icon--StoreLogoMed20"
        },
        {
            "iconName": "Storyboard",
            "iconClass": "ms-Icon ms-Icon--Storyboard"
        },
        {
            "iconName": "Streaming",
            "iconClass": "ms-Icon ms-Icon--Streaming"
        },
        {
            "iconName": "StreamingOff",
            "iconClass": "ms-Icon ms-Icon--StreamingOff"
        },
        {
            "iconName": "StreamLogo",
            "iconClass": "ms-Icon ms-Icon--StreamLogo"
        },
        {
            "iconName": "Strikethrough",
            "iconClass": "ms-Icon ms-Icon--Strikethrough"
        },
        {
            "iconName": "Subscribe",
            "iconClass": "ms-Icon ms-Icon--Subscribe"
        },
        {
            "iconName": "Subscript",
            "iconClass": "ms-Icon ms-Icon--Subscript"
        },
        {
            "iconName": "SubstitutionsIn",
            "iconClass": "ms-Icon ms-Icon--SubstitutionsIn"
        },
        {
            "iconName": "Suitcase",
            "iconClass": "ms-Icon ms-Icon--Suitcase"
        },
        {
            "iconName": "SunAdd",
            "iconClass": "ms-Icon ms-Icon--SunAdd"
        },
        {
            "iconName": "Sunny",
            "iconClass": "ms-Icon ms-Icon--Sunny"
        },
        {
            "iconName": "SunQuestionMark",
            "iconClass": "ms-Icon ms-Icon--SunQuestionMark"
        },
        {
            "iconName": "Superscript",
            "iconClass": "ms-Icon ms-Icon--Superscript"
        },
        {
            "iconName": "SurveyQuestions",
            "iconClass": "ms-Icon ms-Icon--SurveyQuestions"
        },
        {
            "iconName": "SwayLogo16",
            "iconClass": "ms-Icon ms-Icon--SwayLogo16"
        },
        {
            "iconName": "SwayLogo32",
            "iconClass": "ms-Icon ms-Icon--SwayLogo32"
        },
        {
            "iconName": "SwayLogoFill16",
            "iconClass": "ms-Icon ms-Icon--SwayLogoFill16"
        },
        {
            "iconName": "SwayLogoFill32",
            "iconClass": "ms-Icon ms-Icon--SwayLogoFill32"
        },
        {
            "iconName": "SwayLogoInverse",
            "iconClass": "ms-Icon ms-Icon--SwayLogoInverse"
        },
        {
            "iconName": "Switch",
            "iconClass": "ms-Icon ms-Icon--Switch"
        },
        {
            "iconName": "SwitcherStartEnd",
            "iconClass": "ms-Icon ms-Icon--SwitcherStartEnd"
        },
        {
            "iconName": "Sync",
            "iconClass": "ms-Icon ms-Icon--Sync"
        },
        {
            "iconName": "SyncFolder",
            "iconClass": "ms-Icon ms-Icon--SyncFolder"
        },
        {
            "iconName": "SyncOccurence",
            "iconClass": "ms-Icon ms-Icon--SyncOccurence"
        },
        {
            "iconName": "SyncToPC",
            "iconClass": "ms-Icon ms-Icon--SyncToPC"
        },
        {
            "iconName": "System",
            "iconClass": "ms-Icon ms-Icon--System"
        },
        {
            "iconName": "Tab",
            "iconClass": "ms-Icon ms-Icon--Tab"
        },
        {
            "iconName": "Table",
            "iconClass": "ms-Icon ms-Icon--Table"
        },
        {
            "iconName": "Tablet",
            "iconClass": "ms-Icon ms-Icon--Tablet"
        },
        {
            "iconName": "TabletMode",
            "iconClass": "ms-Icon ms-Icon--TabletMode"
        },
        {
            "iconName": "TabletSelected",
            "iconClass": "ms-Icon ms-Icon--TabletSelected"
        },
        {
            "iconName": "Tag",
            "iconClass": "ms-Icon ms-Icon--Tag"
        },
        {
            "iconName": "Taskboard",
            "iconClass": "ms-Icon ms-Icon--Taskboard"
        },
        // {
        //     "iconName": "TaskGroup",
        //     "iconClass": "ms-Icon ms-Icon--TaskGroup"
        // },
        // {
        //     "iconName": "TaskGroupMirrored",
        //     "iconClass": "ms-Icon ms-Icon--TaskGroupMirrored"
        // },
        {
            "iconName": "TaskLogo",
            "iconClass": "ms-Icon ms-Icon--TaskLogo"
        },
        // {
        //     "iconName": "TaskManager",
        //     "iconClass": "ms-Icon ms-Icon--TaskManager"
        // },
        // {
        //     "iconName": "TaskManagerMirrored",
        //     "iconClass": "ms-Icon ms-Icon--TaskManagerMirrored"
        // },
        {
            "iconName": "TaskSolid",
            "iconClass": "ms-Icon ms-Icon--TaskSolid"
        },
        {
            "iconName": "Taxi",
            "iconClass": "ms-Icon ms-Icon--Taxi"
        },
        {
            "iconName": "TeamFavorite",
            "iconClass": "ms-Icon ms-Icon--TeamFavorite"
        },
        {
            "iconName": "TeamsLogo",
            "iconClass": "ms-Icon ms-Icon--TeamsLogo"
        },
        {
            "iconName": "TeamsLogoFill",
            "iconClass": "ms-Icon ms-Icon--TeamsLogoFill"
        },
        {
            "iconName": "TeamsLogoInverse",
            "iconClass": "ms-Icon ms-Icon--TeamsLogoInverse"
        },
        {
            "iconName": "Teamwork",
            "iconClass": "ms-Icon ms-Icon--Teamwork"
        },
        {
            "iconName": "Teeth",
            "iconClass": "ms-Icon ms-Icon--Teeth"
        },
        {
            "iconName": "TemporaryUser",
            "iconClass": "ms-Icon ms-Icon--TemporaryUser"
        },
        {
            "iconName": "Tennis",
            "iconClass": "ms-Icon ms-Icon--Tennis"
        },
        {
            "iconName": "TestAutoSolid",
            "iconClass": "ms-Icon ms-Icon--TestAutoSolid"
        },
        {
            "iconName": "TestBeaker",
            "iconClass": "ms-Icon ms-Icon--TestBeaker"
        },
        {
            "iconName": "TestBeakerSolid",
            "iconClass": "ms-Icon ms-Icon--TestBeakerSolid"
        },
        {
            "iconName": "TestCase",
            "iconClass": "ms-Icon ms-Icon--TestCase"
        },
        {
            "iconName": "TestExploreSolid",
            "iconClass": "ms-Icon ms-Icon--TestExploreSolid"
        },
        {
            "iconName": "TestImpactSolid",
            "iconClass": "ms-Icon ms-Icon--TestImpactSolid"
        },
        {
            "iconName": "TestParameter",
            "iconClass": "ms-Icon ms-Icon--TestParameter"
        },
        {
            "iconName": "TestPlan",
            "iconClass": "ms-Icon ms-Icon--TestPlan"
        },
        {
            "iconName": "TestStep",
            "iconClass": "ms-Icon ms-Icon--TestStep"
        },
        {
            "iconName": "TestSuite",
            "iconClass": "ms-Icon ms-Icon--TestSuite"
        },
        {
            "iconName": "TestUserSolid",
            "iconClass": "ms-Icon ms-Icon--TestUserSolid"
        },
        {
            "iconName": "TextBox",
            "iconClass": "ms-Icon ms-Icon--TextBox"
        },
        {
            "iconName": "TextCallout",
            "iconClass": "ms-Icon ms-Icon--TextCallout"
        },
        {
            "iconName": "TextDocument",
            "iconClass": "ms-Icon ms-Icon--TextDocument"
        },
        {
            "iconName": "TextDocumentShared",
            "iconClass": "ms-Icon ms-Icon--TextDocumentShared"
        },
        {
            "iconName": "TextField",
            "iconClass": "ms-Icon ms-Icon--TextField"
        },
        {
            "iconName": "TextOverflow",
            "iconClass": "ms-Icon ms-Icon--TextOverflow"
        },
        {
            "iconName": "TFVCLogo",
            "iconClass": "ms-Icon ms-Icon--TFVCLogo"
        },
        {
            "iconName": "ThisPC",
            "iconClass": "ms-Icon ms-Icon--ThisPC"
        },
        {
            "iconName": "ThreeQuarterCircle",
            "iconClass": "ms-Icon ms-Icon--ThreeQuarterCircle"
        },
        // {
        //     "iconName": "ThumbnailView",
        //     "iconClass": "ms-Icon ms-Icon--ThumbnailView"
        // },
        // {
        //     "iconName": "ThumbnailViewMirrored",
        //     "iconClass": "ms-Icon ms-Icon--ThumbnailViewMirrored"
        // },
        {
            "iconName": "Thunderstorms",
            "iconClass": "ms-Icon ms-Icon--Thunderstorms"
        },
        {
            "iconName": "Ticket",
            "iconClass": "ms-Icon ms-Icon--Ticket"
        },
        {
            "iconName": "Tiles",
            "iconClass": "ms-Icon ms-Icon--Tiles"
        },
        {
            "iconName": "Tiles2",
            "iconClass": "ms-Icon ms-Icon--Tiles2"
        },
        {
            "iconName": "TimeEntry",
            "iconClass": "ms-Icon ms-Icon--TimeEntry"
        },
        {
            "iconName": "Timeline",
            "iconClass": "ms-Icon ms-Icon--Timeline"
        },
        {
            "iconName": "TimelineDelivery",
            "iconClass": "ms-Icon ms-Icon--TimelineDelivery"
        },
        {
            "iconName": "TimelineMatrixView",
            "iconClass": "ms-Icon ms-Icon--TimelineMatrixView"
        },
        {
            "iconName": "TimelineProgress",
            "iconClass": "ms-Icon ms-Icon--TimelineProgress"
        },
        {
            "iconName": "Timer",
            "iconClass": "ms-Icon ms-Icon--Timer"
        },
        {
            "iconName": "TimeSheet",
            "iconClass": "ms-Icon ms-Icon--TimeSheet"
        },
        {
            "iconName": "ToDoLogoBottom",
            "iconClass": "ms-Icon ms-Icon--ToDoLogoBottom"
        },
        {
            "iconName": "ToDoLogoInverse",
            "iconClass": "ms-Icon ms-Icon--ToDoLogoInverse"
        },
        {
            "iconName": "ToDoLogoTop",
            "iconClass": "ms-Icon ms-Icon--ToDoLogoTop"
        },
        {
            "iconName": "ToggleBorder",
            "iconClass": "ms-Icon ms-Icon--ToggleBorder"
        },
        {
            "iconName": "ToggleFilled",
            "iconClass": "ms-Icon ms-Icon--ToggleFilled"
        },
        {
            "iconName": "ToggleOff",
            "iconClass": "ms-Icon ms-Icon--ToggleOff"
        },
        {
            "iconName": "ToggleThumb",
            "iconClass": "ms-Icon ms-Icon--ToggleThumb"
        },
        {
            "iconName": "Toll",
            "iconClass": "ms-Icon ms-Icon--Toll"
        },
        {
            "iconName": "Touch",
            "iconClass": "ms-Icon ms-Icon--Touch"
        },
        {
            "iconName": "TouchPointer",
            "iconClass": "ms-Icon ms-Icon--TouchPointer"
        },
        // {
        //     "iconName": "Trackers",
        //     "iconClass": "ms-Icon ms-Icon--Trackers"
        // },
        // {
        //     "iconName": "TrackersMirrored",
        //     "iconClass": "ms-Icon ms-Icon--TrackersMirrored"
        // },
        {
            "iconName": "Train",
            "iconClass": "ms-Icon ms-Icon--Train"
        },
        {
            "iconName": "TrainSolid",
            "iconClass": "ms-Icon ms-Icon--TrainSolid"
        },
        {
            "iconName": "TransferCall",
            "iconClass": "ms-Icon ms-Icon--TransferCall"
        },
        {
            "iconName": "Transition",
            "iconClass": "ms-Icon ms-Icon--Transition"
        },
        {
            "iconName": "TransitionEffect",
            "iconClass": "ms-Icon ms-Icon--TransitionEffect"
        },
        {
            "iconName": "TransitionPop",
            "iconClass": "ms-Icon ms-Icon--TransitionPop"
        },
        {
            "iconName": "TransitionPush",
            "iconClass": "ms-Icon ms-Icon--TransitionPush"
        },
        {
            "iconName": "Trending12",
            "iconClass": "ms-Icon ms-Icon--Trending12"
        },
        {
            "iconName": "TriangleDown12",
            "iconClass": "ms-Icon ms-Icon--TriangleDown12"
        },
        {
            "iconName": "TriangleLeft12",
            "iconClass": "ms-Icon ms-Icon--TriangleLeft12"
        },
        {
            "iconName": "TriangleRight12",
            "iconClass": "ms-Icon ms-Icon--TriangleRight12"
        },
        {
            "iconName": "TriangleShapeSolid",
            "iconClass": "ms-Icon ms-Icon--TriangleShapeSolid"
        },
        {
            "iconName": "TriangleSolid",
            "iconClass": "ms-Icon ms-Icon--TriangleSolid"
        },
        {
            "iconName": "TriangleSolidDown12",
            "iconClass": "ms-Icon ms-Icon--TriangleSolidDown12"
        },
        {
            "iconName": "TriangleSolidLeft12",
            "iconClass": "ms-Icon ms-Icon--TriangleSolidLeft12"
        },
        {
            "iconName": "TriangleSolidRight12",
            "iconClass": "ms-Icon ms-Icon--TriangleSolidRight12"
        },
        {
            "iconName": "TriangleSolidUp12",
            "iconClass": "ms-Icon ms-Icon--TriangleSolidUp12"
        },
        {
            "iconName": "TriangleUp12",
            "iconClass": "ms-Icon ms-Icon--TriangleUp12"
        },
        {
            "iconName": "TriggerApproval",
            "iconClass": "ms-Icon ms-Icon--TriggerApproval"
        },
        {
            "iconName": "TriggerAuto",
            "iconClass": "ms-Icon ms-Icon--TriggerAuto"
        },
        {
            "iconName": "TriggerUser",
            "iconClass": "ms-Icon ms-Icon--TriggerUser"
        },
        {
            "iconName": "TripleColumn",
            "iconClass": "ms-Icon ms-Icon--TripleColumn"
        },
        {
            "iconName": "TripleColumnEdit",
            "iconClass": "ms-Icon ms-Icon--TripleColumnEdit"
        },
        {
            "iconName": "Trophy",
            "iconClass": "ms-Icon ms-Icon--Trophy"
        },
        {
            "iconName": "Trophy2",
            "iconClass": "ms-Icon ms-Icon--Trophy2"
        },
        {
            "iconName": "Trophy2Solid",
            "iconClass": "ms-Icon ms-Icon--Trophy2Solid"
        },
        {
            "iconName": "TurnRight",
            "iconClass": "ms-Icon ms-Icon--TurnRight"
        },
        {
            "iconName": "TVMonitor",
            "iconClass": "ms-Icon ms-Icon--TVMonitor"
        },
        {
            "iconName": "TVMonitorSelected",
            "iconClass": "ms-Icon ms-Icon--TVMonitorSelected"
        },
        {
            "iconName": "TypeScriptLanguage",
            "iconClass": "ms-Icon ms-Icon--TypeScriptLanguage"
        },
        {
            "iconName": "Umbrella",
            "iconClass": "ms-Icon ms-Icon--Umbrella"
        },
        {
            "iconName": "Underline",
            "iconClass": "ms-Icon ms-Icon--Underline"
        },
        {
            "iconName": "Undo",
            "iconClass": "ms-Icon ms-Icon--Undo"
        },
        // {
        //     "iconName": "Uneditable",
        //     "iconClass": "ms-Icon ms-Icon--Uneditable"
        // },
        // {
        //     "iconName": "UneditableMirrored",
        //     "iconClass": "ms-Icon ms-Icon--UneditableMirrored"
        // },
        // {
        //     "iconName": "UneditableSolid12",
        //     "iconClass": "ms-Icon ms-Icon--UneditableSolid12"
        // },
        // {
        //     "iconName": "UneditableSolidMirrored12",
        //     "iconClass": "ms-Icon ms-Icon--UneditableSolidMirrored12"
        // },
        {
            "iconName": "Unfavorite",
            "iconClass": "ms-Icon ms-Icon--Unfavorite"
        },
        {
            "iconName": "UngroupObject",
            "iconClass": "ms-Icon ms-Icon--UngroupObject"
        },
        // {
        //     "iconName": "Unknown",
        //     "iconClass": "ms-Icon ms-Icon--Unknown"
        // },
        {
            "iconName": "UnknownCall",
            "iconClass": "ms-Icon ms-Icon--UnknownCall"
        },
        // {
        //     "iconName": "UnknownMirrored",
        //     "iconClass": "ms-Icon ms-Icon--UnknownMirrored"
        // },
        // {
        //     "iconName": "UnknownMirroredSolid",
        //     "iconClass": "ms-Icon ms-Icon--UnknownMirroredSolid"
        // },
        // {
        //     "iconName": "UnknownSolid",
        //     "iconClass": "ms-Icon ms-Icon--UnknownSolid"
        // },
        {
            "iconName": "Unlock",
            "iconClass": "ms-Icon ms-Icon--Unlock"
        },
        {
            "iconName": "UnlockSolid",
            "iconClass": "ms-Icon ms-Icon--UnlockSolid"
        },
        {
            "iconName": "Unpin",
            "iconClass": "ms-Icon ms-Icon--Unpin"
        },
        {
            "iconName": "Unsubscribe",
            "iconClass": "ms-Icon ms-Icon--Unsubscribe"
        },
        {
            "iconName": "UnsyncFolder",
            "iconClass": "ms-Icon ms-Icon--UnsyncFolder"
        },
        {
            "iconName": "UnsyncOccurence",
            "iconClass": "ms-Icon ms-Icon--UnsyncOccurence"
        },
        {
            "iconName": "Up",
            "iconClass": "ms-Icon ms-Icon--Up"
        },
        {
            "iconName": "Upload",
            "iconClass": "ms-Icon ms-Icon--Upload"
        },
        {
            "iconName": "UserEvent",
            "iconClass": "ms-Icon ms-Icon--UserEvent"
        },
        {
            "iconName": "UserFollowed",
            "iconClass": "ms-Icon ms-Icon--UserFollowed"
        },
        {
            "iconName": "UserPause",
            "iconClass": "ms-Icon ms-Icon--UserPause"
        },
        {
            "iconName": "UserRemove",
            "iconClass": "ms-Icon ms-Icon--UserRemove"
        },
        {
            "iconName": "UserSync",
            "iconClass": "ms-Icon ms-Icon--UserSync"
        },
        {
            "iconName": "Vacation",
            "iconClass": "ms-Icon ms-Icon--Vacation"
        },
        {
            "iconName": "Variable",
            "iconClass": "ms-Icon ms-Icon--Variable"
        },
        {
            "iconName": "VariableGroup",
            "iconClass": "ms-Icon ms-Icon--VariableGroup"
        },
        {
            "iconName": "VB",
            "iconClass": "ms-Icon ms-Icon--VB"
        },
        {
            "iconName": "VennDiagram",
            "iconClass": "ms-Icon ms-Icon--VennDiagram"
        },
        {
            "iconName": "VersionControlPush",
            "iconClass": "ms-Icon ms-Icon--VersionControlPush"
        },
        {
            "iconName": "VerticalDistributeCenter",
            "iconClass": "ms-Icon ms-Icon--VerticalDistributeCenter"
        },
        {
            "iconName": "Video",
            "iconClass": "ms-Icon ms-Icon--Video"
        },
        {
            "iconName": "VideoOff",
            "iconClass": "ms-Icon ms-Icon--VideoOff"
        },
        {
            "iconName": "VideoSearch",
            "iconClass": "ms-Icon ms-Icon--VideoSearch"
        },
        {
            "iconName": "VideoSolid",
            "iconClass": "ms-Icon ms-Icon--VideoSolid"
        },
        {
            "iconName": "View",
            "iconClass": "ms-Icon ms-Icon--View"
        },
        {
            "iconName": "ViewAll",
            "iconClass": "ms-Icon ms-Icon--ViewAll"
        },
        {
            "iconName": "ViewAll2",
            "iconClass": "ms-Icon ms-Icon--ViewAll2"
        },
        {
            "iconName": "ViewDashboard",
            "iconClass": "ms-Icon ms-Icon--ViewDashboard"
        },
        {
            "iconName": "ViewList",
            "iconClass": "ms-Icon ms-Icon--ViewList"
        },
        {
            "iconName": "ViewListGroup",
            "iconClass": "ms-Icon ms-Icon--ViewListGroup"
        },
        {
            "iconName": "ViewListTree",
            "iconClass": "ms-Icon ms-Icon--ViewListTree"
        },
        {
            "iconName": "VisioDiagram",
            "iconClass": "ms-Icon ms-Icon--VisioDiagram"
        },
        {
            "iconName": "VisioDocument",
            "iconClass": "ms-Icon ms-Icon--VisioDocument"
        },
        {
            "iconName": "VisioLogo",
            "iconClass": "ms-Icon ms-Icon--VisioLogo"
        },
        {
            "iconName": "VisioLogo16",
            "iconClass": "ms-Icon ms-Icon--VisioLogo16"
        },
        {
            "iconName": "VisioLogoFill",
            "iconClass": "ms-Icon ms-Icon--VisioLogoFill"
        },
        {
            "iconName": "VisioLogoFill16",
            "iconClass": "ms-Icon ms-Icon--VisioLogoFill16"
        },
        {
            "iconName": "VisioLogoInverse",
            "iconClass": "ms-Icon ms-Icon--VisioLogoInverse"
        },
        {
            "iconName": "VisioLogoInverse16",
            "iconClass": "ms-Icon ms-Icon--VisioLogoInverse16"
        },
        {
            "iconName": "VisualBasicLanguage",
            "iconClass": "ms-Icon ms-Icon--VisualBasicLanguage"
        },
        {
            "iconName": "VisualsFolder",
            "iconClass": "ms-Icon ms-Icon--VisualsFolder"
        },
        {
            "iconName": "VisualsStore",
            "iconClass": "ms-Icon ms-Icon--VisualsStore"
        },
        {
            "iconName": "VisualStudioIDELogo32",
            "iconClass": "ms-Icon ms-Icon--VisualStudioIDELogo32"
        },
        {
            "iconName": "VisualStudioLogo",
            "iconClass": "ms-Icon ms-Icon--VisualStudioLogo"
        },
        {
            "iconName": "VoicemailForward",
            "iconClass": "ms-Icon ms-Icon--VoicemailForward"
        },
        {
            "iconName": "VoicemailIRM",
            "iconClass": "ms-Icon ms-Icon--VoicemailIRM"
        },
        {
            "iconName": "VoicemailReply",
            "iconClass": "ms-Icon ms-Icon--VoicemailReply"
        },
        {
            "iconName": "Volume0",
            "iconClass": "ms-Icon ms-Icon--Volume0"
        },
        {
            "iconName": "Volume1",
            "iconClass": "ms-Icon ms-Icon--Volume1"
        },
        {
            "iconName": "Volume2",
            "iconClass": "ms-Icon ms-Icon--Volume2"
        },
        {
            "iconName": "Volume3",
            "iconClass": "ms-Icon ms-Icon--Volume3"
        },
        {
            "iconName": "VolumeDisabled",
            "iconClass": "ms-Icon ms-Icon--VolumeDisabled"
        },
        {
            "iconName": "VSTSAltLogo1",
            "iconClass": "ms-Icon ms-Icon--VSTSAltLogo1"
        },
        {
            "iconName": "VSTSAltLogo2",
            "iconClass": "ms-Icon ms-Icon--VSTSAltLogo2"
        },
        {
            "iconName": "VSTSLogo",
            "iconClass": "ms-Icon ms-Icon--VSTSLogo"
        },
        {
            "iconName": "Waffle",
            "iconClass": "ms-Icon ms-Icon--Waffle"
        },
        {
            "iconName": "WaffleOffice365",
            "iconClass": "ms-Icon ms-Icon--WaffleOffice365"
        },
        //{
        //    "iconName": "WaitlistConfirm",
        //    "iconClass": "ms-Icon ms-Icon--WaitlistConfirm"
        //},
        //{
        //    "iconName": "WaitlistConfirmMirrored",
        //    "iconClass": "ms-Icon ms-Icon--WaitlistConfirmMirrored"
        //},
        {
            "iconName": "Warning",
            "iconClass": "ms-Icon ms-Icon--Warning"
        },
        {
            "iconName": "Warning12",
            "iconClass": "ms-Icon ms-Icon--Warning12"
        },
        {
            "iconName": "WebPublish",
            "iconClass": "ms-Icon ms-Icon--WebPublish"
        },
        {
            "iconName": "Website",
            "iconClass": "ms-Icon ms-Icon--Website"
        },
        {
            "iconName": "Weights",
            "iconClass": "ms-Icon ms-Icon--Weights"
        },
        {
            "iconName": "WhiteBoardApp16",
            "iconClass": "ms-Icon ms-Icon--WhiteBoardApp16"
        },
        {
            "iconName": "WhiteBoardApp32",
            "iconClass": "ms-Icon ms-Icon--WhiteBoardApp32"
        },
        {
            "iconName": "WifiEthernet",
            "iconClass": "ms-Icon ms-Icon--WifiEthernet"
        },
        {
            "iconName": "WindDirection",
            "iconClass": "ms-Icon ms-Icon--WindDirection"
        },
        {
            "iconName": "WindowEdit",
            "iconClass": "ms-Icon ms-Icon--WindowEdit"
        },
        {
            "iconName": "WindowsLogo",
            "iconClass": "ms-Icon ms-Icon--WindowsLogo"
        },
        {
            "iconName": "Wines",
            "iconClass": "ms-Icon ms-Icon--Wines"
        },
        {
            "iconName": "WipePhone",
            "iconClass": "ms-Icon ms-Icon--WipePhone"
        },
        {
            "iconName": "WordDocument",
            "iconClass": "ms-Icon ms-Icon--WordDocument"
        },
        {
            "iconName": "WordLogo",
            "iconClass": "ms-Icon ms-Icon--WordLogo"
        },
        {
            "iconName": "WordLogo16",
            "iconClass": "ms-Icon ms-Icon--WordLogo16"
        },
        {
            "iconName": "WordLogoFill",
            "iconClass": "ms-Icon ms-Icon--WordLogoFill"
        },
        {
            "iconName": "WordLogoFill16",
            "iconClass": "ms-Icon ms-Icon--WordLogoFill16"
        },
        {
            "iconName": "WordLogoInverse",
            "iconClass": "ms-Icon ms-Icon--WordLogoInverse"
        },
        {
            "iconName": "WordLogoInverse16",
            "iconClass": "ms-Icon ms-Icon--WordLogoInverse16"
        },
        {
            "iconName": "Work",
            "iconClass": "ms-Icon ms-Icon--Work"
        },
        {
            "iconName": "WorkFlow",
            "iconClass": "ms-Icon ms-Icon--WorkFlow"
        },
        {
            "iconName": "WorkforceManagement",
            "iconClass": "ms-Icon ms-Icon--WorkforceManagement"
        },
        {
            "iconName": "WorkItem",
            "iconClass": "ms-Icon ms-Icon--WorkItem"
        },
        {
            "iconName": "WorkItemBar",
            "iconClass": "ms-Icon ms-Icon--WorkItemBar"
        },
        {
            "iconName": "WorkItemBarSolid",
            "iconClass": "ms-Icon ms-Icon--WorkItemBarSolid"
        },
        {
            "iconName": "WorkItemBug",
            "iconClass": "ms-Icon ms-Icon--WorkItemBug"
        },
        {
            "iconName": "World",
            "iconClass": "ms-Icon ms-Icon--World"
        },
        {
            "iconName": "WorldClock",
            "iconClass": "ms-Icon ms-Icon--WorldClock"
        },
        {
            "iconName": "YammerLogo",
            "iconClass": "ms-Icon ms-Icon--YammerLogo"
        },
        {
            "iconName": "ZipFolder",
            "iconClass": "ms-Icon ms-Icon--ZipFolder"
        },
        {
            "iconName": "Zoom",
            "iconClass": "ms-Icon ms-Icon--Zoom"
        },
        {
            "iconName": "ZoomIn",
            "iconClass": "ms-Icon ms-Icon--ZoomIn"
        },
        {
            "iconName": "ZoomOut",
            "iconClass": "ms-Icon ms-Icon--ZoomOut"
        }
    ]

    angular.module("WizdomMobileModule").constant("fabricIcon", fabricIcon);
})();
(function () {

    var defaultNavigation = [
        {
            appShellUrlMethod: 'sethomeurl',
            appShellTitleMethod: 'settitle',
            defaultName: 'Home',
            altName: null,
            defaultUrl: '#!/',
            altUrl: null,
            icon: 'Home'
        },
        {
            appShellUrlMethod: 'setnewsurl',
            appShellTitleMethod: 'settitle',
            defaultName: 'News',
            altName: null,
            defaultUrl: '#!/news',
            altUrl: null,
            icon: 'Articles'
        },
        {
            appShellUrlMethod: 'setnoticeboardurl',
            appShellTitleMethod: 'settitle',
            defaultName: 'Noticeboard',
            altName: null,
            defaultUrl: '#!/noticeboard',
            altUrl: null,
            icon: 'ActivityFeed'
        },
        {
            appShellUrlMethod: 'setpeopleurl',
            appShellTitleMethod: 'settitle',
            defaultName: 'People',
            altName: null,
            defaultUrl: '#!/people',
            altUrl: null,
            icon: 'Contact'
        },
        {
            appShellUrlMethod: 'setmenuurl',
            appShellTitleMethod: 'settitle',
            defaultName: 'Menu',
            altName: null,
            defaultUrl: '#!/menu',
            altUrl: null,
            icon: 'CollapseMenu'
        }
    ];

    angular.module("WizdomMobileModule").constant("defaultNavigation", defaultNavigation);
})();
(function () {
    angular.module("WizdomMobileModule").directive("iconPicker", iconPicker);

    function iconPicker() {

        return {
            scope: {
                'icon': '='
            },
            templateUrl: "WizdomMobileModule/App_Admin/Templates/iconPicker.html",
            controller: iconPickerController
        };
    }

    iconPickerController.$inject = ["$scope", "fabricIcon"];

    function iconPickerController($scope, fabricIcon) {

        $scope.selectIcon = function (selection) {
            $scope.icon = selection.iconClass;
        };

        $scope.icons = fabricIcon;
    }
})();
(function () {
    angular.module("WizdomMobileModule").directive("wcmStarterPrincipalpicker", wcmStarterPrincipalpicker);

    function wcmStarterPrincipalpicker() {

        return {
            scope: {
                principals: '=',
                useUserImg: '@?',
                mode: '@?', //users,groups,all
                placeholder: '@?',
                addFn: '&?',
                removeFn: '&?',
                allowmultiple: '@?',
                alloweveryone: '@?'
            },
            templateUrl: "WizdomMobileModule/App/Templates/PrincipalPicker.html",
            controller: wcmStarterPrincipalpickerController
        };
    }

    wcmStarterPrincipalpickerController.$inject = ["$scope", "principalsApi", "$timeout"];

    function wcmStarterPrincipalpickerController($scope, principalsApi, $timeout) {

        function initialize() {
            if ($scope.mode == null || $scope.mode == "")
                $scope.mode = "all";

            if ($scope.useUserImg == null)
                $scope.useUserImg = true;

            if ($scope.allowmultiple == null || $scope.allowmultiple == "")
                $scope.allowmultiple = true;
            else
                $scope.allowmultiple = JSON.parse($scope.allowmultiple);            

            if ($scope.principals == null)
                $scope.principals = [];

            if ($scope.placeholder == null) {
                var translateString = "Select ";
                if ($scope.mode == "all") {
                    if ($scope.allowmultiple)
                        translateString += "users or groups";
                    else
                        translateString += "user or group";
                }
                else {
                    if ($scope.mode == "users")
                        translateString += "user";
                    if ($scope.mode == "groups")
                        translateString += "group";
                    if ($scope.allowmultiple)
                        translateString += "s";
                }
                //$scope.placeholder = $filter("translate")(translateString);
                $scope.placeholder = translateString;
            }
        }

        $scope.searchForPrincipal = function (searchTerm) {
            if (!searchTerm || searchTerm.length < 2)
                return [];
            
            if ($scope.mode == "all")
                return principalsApi.principals.searchUsersAndGroups(searchTerm)
                    .then(function (results) {
                        appendEveryone(searchTerm, results);
                        return limitResult(results, 5);
                    });
            if ($scope.mode == "users")
                return principalsApi.principals.searchUsers(searchTerm)
                    .then(function (results) {
                        appendEveryone(searchTerm, results);
                        return limitResult(results, 5);
                    });
            if ($scope.mode == "groups")
                return principalsApi.principals.searchGroups(searchTerm)
                    .then(function (results) {
                        appendEveryone(searchTerm, results);
                        return limitResult(results, 5);
                    });

            function appendEveryone(searchTerm, results) {
                if ($scope.alloweveryone) {
                    //displayName: $filter('translate')("Everybody"),
                    var everyone = {
                        id: "WizdomEverybody",
                        displayName: "Everybody",
                        loginName: "Everybody"
                    };
                    if (everyone.displayName.toLowerCase().indexOf(searchTerm.toLowerCase()) > -1 ||
                        everyone.loginName.toLowerCase().indexOf(searchTerm.toLowerCase()) > -1)
                        results.push(everyone);
                }                
            }

            function limitResult(results, limit) {
                $scope.showingMax = false;
                if (results.length > limit) {
                    results.slice(0, limit);
                    $scope.showingMax = true;
                    results[0].resultSetLimitedTo = limit; 
                }
                return results;
            }
        };

        $scope.addPrincipal = function (principal) {            
            if (!$scope.allowmultiple) {
                if ($scope.removeFn != null) {
                    var principals = angular.copy($scope.principals), len = principals.length;
                    for (var i = 0; i < len; i++) {
                        $scope.removePrincipal(principals[i]);
                    }
                }
            }

            if (collectionContains($scope.principals, principal))
                return;
            
            principalsApi.principals.ensure(principal)
                .then(function (result) {                    
                    $scope.principals.push(principal);
                    $scope.principals.sort(function (a, b) {
                        if (a.displayName < b.displayName) return -1;
                        else return 1;
                    });

                    $scope.asyncSelected = '';
                    if ($scope.addFn != null)
                        $scope.addFn({ principal: principal });                    
                });                     
        }
        


        $scope.removePrincipal = function (principal) {
            if (!collectionContains($scope.principals, principal))
                return;
            var newCollection = [];
            var len = $scope.principals.length;
            for (var i = 0; i < len; i++) {
                var user = $scope.principals[i];
                if (user.id != principal.id && user.groupId != principal.groupId) {
                    newCollection.push(user);
                }
            }
            $scope.principals = newCollection;

            if ($scope.removeFn != null)
                $scope.removeFn({ principal: principal });
        }

        function collectionContains(collection, principal) {
            var len = collection.length;
            for (var i = 0; i < len; i++) {
                existingPrincipal = collection[i];
                if (existingPrincipal.id == principal.id ||
                    (existingPrincipal.loginName && existingPrincipal.loginName == principal.loginName) ||
                    (principal.groupId && existingPrincipal.groupId == principal.groupId)) {
                    return true;
                }
            }
            return false;
            }

        $timeout(initialize, 100);
        }
    })();
(function () {
    angular.module("WizdomMobileModule").directive("wizdom365Spinner", wizdom365Spinner);

    function wizdom365Spinner() {
        return {
            templateUrl: "WizdomMobileModule/App_Admin/Templates/Spinner.html",
            scope: {
                loading: '=',
            }
        };
    };
})();
(function () {
    
    angular.module("WizdomMobileModule").controller("administrationController", administrationController);

    administrationController.$inject = ["$scope", "administrationApi", "wcmStarterSettingsApi", "log"];

    function administrationController($scope, administrationApi, wcmStarterSettingsApi, log) {
        var vm = this;

        vm.menuItemClick = menuItemClick;

        vm.selectedPage = '';
        vm.menuReady = false;

        administrationApi.pagesTree().then(function (data) {
            vm.tree = data;
            if (data && data.length > 0) {
                vm.selectedPage = data[0].Path;
            }
            vm.menuReady = true;
        });

        //wcmStarterSettingsApi.getSettings().then(function (stg) {
        //    log("settings loaded!");
        //});

        vm.resetcache = function () {
            administrationApi.pagesTree().then(function (data) {
                vm.tree = data;
            });

        }

        function menuItemClick(node, $event) {
            $event.stopPropagation();
            $event.preventDefault();
            if (node.IsDir) {
                node.expanded = !node.expanded;
                return;
            }
            vm.selectedPage = node.Path;
        }
    }
    
})();
(function () {
    
    angular.module("WizdomMobileModule").controller("cacheAdminController", cacheAdminController);

    cacheAdminController.$inject = ["$scope", "wcmStarterHttpApi", "wcmStarterSettingsApi"];
    function cacheAdminController($scope, httpApi, wcmStarterSettingsApi) {
        var sUrl = "/api/administration";
        $scope.dataReady = false;

        //wcmStarterSettingsApi.getSettings().then(function (data) {
        //    $scope.stg = data;
        //});

        $scope.saveSettings = function () {
            $scope.saving = true;
            //wcmStarterSettingsApi.saveSettings($scope.stg).then(function () {
            //    $scope.resetcache();
            //    $scope.saving = false;
            //});
        }

        $scope.deleteSearchTerm = function (index) {
            $scope.stg.knowWhoWarmUpSearchTerms.splice(index, 1);
        }
        $scope.addSearchTerm = function () {
            $scope.addingNewSearchTerm = true;
        }
        $scope.saveSearchTerm = function () {
            var st = angular.copy($scope.newSearchTerm);
            if (st) {
                $scope.newSearchTerm = '';
                $scope.stg.knowWhoWarmUpSearchTerms.push(st);
                $scope.newFieldError = false;
                $scope.addingNewSearchTerm = false;
            } else {
                $scope.newFieldError = true;
            }
        }


        $scope.install = function () {
            initWokringVars();
            httpApi.post(sUrl + "/install").then(function () {
            });
        }

        $scope.resetcache = function () {
            initWokringVars();
            httpApi.get(sUrl + "/resetcache").then(function (data) {
                //console.log(data);
            });
        }

        $scope.deleteCacheItem = function (key) {
            httpApi.get(sUrl + "/deletecacheitem/?key=" + encodeURIComponent(key)).then(function (deleted) {
                if (deleted) {
                    $scope.getCacheInfo();
                }
            });
        }
        $scope.logCachedObject = function (key) {
            if (window.console && window.console.log) {
                httpApi.get(sUrl + "/getcacheitem/?key=" + encodeURIComponent(key)).then(function (data) {
                    console.log(key, data);
                });
            }
        }

        $scope.getCacheSize = function () {
            initWokringVars();
            $scope.loadingCacheData = true;
            httpApi.get(sUrl + "/getcachesize").then(function (data) {
                $scope.loadingCacheData = false;
                $scope.dataReady = true;
                $scope.cacheSize = data;
                $scope.cacheInfo.data = [];
            });
        }

        $scope.cacheInfo = { data: [], sortReverse: false, sortColumnName: 'key', sortType: function (item) { return item['key']; }, itemsPrPage: 20, currentPage: 1 };
        $scope.getCacheInfo = function () {
            initWokringVars();
            $scope.loadingCacheData = true;
            httpApi.get(sUrl + "/getcacheinfo").then(function (data) {
                $scope.loadingCacheData = false;
                $scope.dataReady = true;
                $scope.cacheInfo.data = data;
                var len = data.length;
                $scope.cacheSize = 0;
                for (var i = 0; i < len; i++) {
                    $scope.cacheSize += $scope.cacheInfo.data[i].value;
                }
            });
        }
        $scope.setSort = function (obj, propName) {
            obj.sortReverse = !obj.sortReverse;
            obj.sortColumnName = propName;
            obj.sortType = function (item) {
                return item[propName];
            }
        }



        function initWokringVars() {
            $scope.dataReady = false;
            $scope.loadingCacheData = false;
        }

    }
    
})();
(function () {

    angular.module("WizdomMobileModule").controller("contentPagesAdminController", contentPagesAdminController);
    contentPagesAdminController.$inject = ["$scope", "settingsApi"];
    function contentPagesAdminController($scope, settingsApi) {
        var vm = this;

        //
        vm.fields = [];

        // Load settings
        settingsApi.getSettings('ContentPages').then(function (response) {
            vm.ContentPagesSettings = response;
        });

        // Public methods
        vm.saveSettings = saveSettings;

        // Private methods        

        vm.addField = function () {
            vm.fields.push({})
        }

        function saveSettings(componentName, settings) {
            vm.saving = true;
            settingsApi.saveSettings(componentName, settings).then(function () {
                // Timeouts for UX actually see the saving messaged
                $timeout(function () {
                    vm.saving = false;
                }, 1000);
            }, function () {
                // handle errors?
            });
        }
    }

})();
(function () {

    angular.module("WizdomMobileModule").controller("customPageAdminController", customPageAdminController);
    customPageAdminController.$inject = ["$scope", "$window", "$modal", "$timeout", "settingsApi"];
    function customPageAdminController($scope, $window, $modal, $timeout, settingsApi) {

        var vm = this;

        // Properties
        vm.rowLimit = 10;
        vm.newPageobj = {};
        vm.showEditMode = false;

        // Load settings
        settingsApi.getSettings('customPages').then(function (response) {
            vm.customPagesSettings = response;
            vm.customPagesSettings.customPages = vm.customPagesSettings.customPages || [];
        });

        // Public methods
        vm.addPage = addPage;
        vm.editPage = editPage;
        vm.deletePage = deletePage;

        function addPage() {
            $modal.open({
                templateUrl: 'WizdomMobileModule/App_Admin/Administration/Modules/CustomPages/Templates/CustomPagesAddTemplate.html',
                controller: 'customPageAddController as customPageAddCtrl',
                windowClass: 'bootstrap-wrapper',
                resolve: {
                    editPageObjMaster: function () { return null; }
                }
            }).result.then(function (data) {
                vm.customPagesSettings.customPages.push(data);
                vm.saveSettings();
            });
        };

        function editPage(page) {
            $modal.open({
                templateUrl: 'WizdomMobileModule/App_Admin/Administration/Modules/CustomPages/Templates/CustomPagesEditTemplate.html',
                controller: 'customPageEditController as customPageEditCtrl',
                windowClass: 'bootstrap-wrapper',
                resolve: {
                    editPageObjMaster: function () { return page; }
                }
            }).result.then(function (data) {
                var index = vm.customPagesSettings.customPages.indexOf(data.editPageObjMaster);
                angular.copy(data.editPageObj, vm.customPagesSettings.customPages[index]);
                vm.saveSettings();
            });
        };

        function deletePage(page) {
            var confirm = $window.confirm("Are you absolutely sure you want to delete?");

            if (confirm) {
                var index = vm.customPagesSettings.customPages.indexOf(page);
                vm.customPagesSettings.customPages.splice(index, 1);
                vm.saveSettings();
            }
        };

        vm.saveSettings = function (componentName, settings) {
            vm.saving = true;
            settingsApi.saveSettings(componentName, settings).then(function () {
                // Timeouts for UX actually see the saving messaged
                $timeout(function () {
                    vm.saving = false;
                }, 1000);
            }, function () {
                // handle errors?
            });
        }
    }

})();
(function () {

    angular.module("WizdomMobileModule").controller("HomeAdminController", HomeAdminController);
    HomeAdminController.$inject = ["$scope", "$timeout", "settingsApi"];
    function HomeAdminController($scope, $timeout, settingsApi) {
        var vm = this;

        settingsApi.getSettings('NewsLatest').then(function (response) {
            vm.latestNewsSettings = response;
        });

        vm.saveSettings = function(componentName, settings) {
            vm.saving = true;
            settingsApi.saveSettings(componentName, settings).then(function () {
                // Timeouts for UX actually see the saving messaged
                $timeout(function () {
                    vm.saving = false;
                }, 1000);
            }, function () {
                // handle errors?
            });
        }
    }

})();
(function () {

    angular.module("WizdomMobileModule").controller("LogController", LogController);

    
    LogController.$inject = ["$scope", "administrationApi", "log"];

    function LogController($scope, administrationApi, log) {
        $scope.logEntries = [];
        $scope.loading = true;
        $scope.sortColumn = 'timestamp';
        $scope.sortReverse = false;
        $scope.status = "";
        $scope.millisec = "";
        $scope.module = "";
        $scope.message = "";

        var yellowThreshold = 500;
        var redThreshold = 2000;

        $scope.filterLog = filterLog;
        $scope.getBackground = getBackground;

        $scope.clearLog = function () {
            log("Clean Log!");
            administrationApi.clearLog().then(function (data) {
                log("Log cleaned!");
                init();
            });
        }

        init();

        function filterLog(item) {
            return ($scope.status == "" || item.level == $scope.status) && // status
                ($scope.millisec == "" || ($scope.millisec < 0 && item.timeTaken < 0 - $scope.millisec) || ($scope.millisec > 0 && item.timeTaken > $scope.millisec)) && // millisec
                ($scope.module == "" || (item.module != null && item.module.indexOf($scope.module) >= 0)) && //module
                ($scope.message == "" || item.text.indexOf($scope.message) >= 0) // message
        }

        function getBackground(timeTaken) {
            if (timeTaken >= yellowThreshold) {
                var red = timeTaken >= yellowThreshold ? 255 : timeTaken / yellowThreshold * 255;
                var green = timeTaken <= yellowThreshold ? 255 : timeTaken > redThreshold ? 0 : (redThreshold - timeTaken) / 1500 * 255;
                var blue = 0;
                return "'background-color:rgb(" + Math.round(red) + "," + Math.round(green) + "," + Math.round(blue) + ")'";
            }
            return "";
        }

        function init() {
            log("Get logs!");
            administrationApi.getLogs().then(function (data) {
                log("Logs retrivied!");
                $scope.logEntries = data;
                $scope.loading = false;
            }
            );
        }
    }

})();
(function () {
    angular.module("WizdomMobileModule").controller("ModulAdminController", ModulAdminController);

    ModulAdminController.$inject = ["$scope", "administrationApi", "guidGenerator", "wcmStarterSettingsApi", "$timeout", "log"];

    function ModulAdminController($scope, adminApi, guidGenerator, wcmStarterSettingsApi, $timeout, log) {
        $scope.progress = 0;
        $scope.working = false;
        $scope.done = false;
        $scope.statusMsg = '';

        //wcmStarterSettingsApi.getSettings().then(function (stg) {
        //    $scope.spHostUrl = stg.spHostUrl;
        //    log("Settings are loaded!")
        //});

        $scope.install = function () {
            $scope.progress = 0;
            $scope.working = true;
            $scope.done = false;
            var processId = guidGenerator.newGuid(),
                 pinfo = { percent: 0, totalSteps: 0, currentStep: 0, message: '', errorMessage: '' };
            getStatus(processId, pinfo);

            adminApi.install(processId).then(function () {
                log("Calling install operation!");
                $timeout(function () {
                    $scope.working = false;
                    $scope.done = true;
                    log("Done calling install operation!");
                }, 500);
            }, function (error) {
                $scope.working = false;
                $scope.statusMsg = "Error";
                log("Error when calling install operation!");
            });
        }

        $scope.installWizdom = function () {
            $scope.progress = 0;
            $scope.working = true;
            $scope.done = false;
            var processId = guidGenerator.newGuid(),pinfo = { percent: 0, totalSteps: 0, currentStep: 0, message: '', errorMessage: '' };
            getStatus(processId, pinfo);

            adminApi.installWizdom(processId, $scope.wizdomProjectName).then(function () {
                log("Calling install Wizdom operation!");
                $timeout(function () {
                    $scope.working = false;
                    $scope.done = true;
                    log("Done calling install Wizdom operation!");
                }, 1000);
            }, function (error) {
                $scope.working = false;
                $scope.statusMsg = "Error";
                log("Error when calling install Wizdom operation!");
            });
        }

        $scope.createWizdomProject = function () {
            $scope.progress = 0;
            $scope.working = true;
            $scope.done = false;
            var processId = guidGenerator.newGuid(),
                pinfo = { percent: 0, totalSteps: 0, currentStep: 0, message: '', errorMessage: '' };
            getProjectStatus(processId, pinfo);

            var wizdomProject = {
                siteName: $scope.wizdomProjectName,
                siteTypeId: 4,
                metadata: [
                    {
                        definitionName: "StartDate",
                        value: new Date()
                    }
                ]};

            adminApi.createWizdomProject(processId, wizdomProject).then(function () {
                log("Calling Create Wizdom project operation!");
                $timeout(function () {
                    $scope.working = false;
                    $scope.done = true;
                    log("Done calling Create Wizdom project operation!");
                }, 500);
            }, function (error) {
                $scope.working = false;
                $scope.statusMsg = "Error";
                log("Error when calling Create Wizdom project operation!");
            });
        }

        $scope.createSpSite = function () {
            $scope.progress = 0;
            $scope.working = true;
            $scope.done = false;
            var processId = guidGenerator.newGuid(), pinfo = { percent: 0, totalSteps: 0, currentStep: 0, message: '', errorMessage: '' };
            getProjectStatus(processId, pinfo);

            adminApi.createSpSite(processId, $scope.wizdomProjectName).then(function () {
                log("Calling createSpSite operation!");
                $timeout(function () {
                    $scope.working = false;
                    $scope.done = true;
                    log("Done calling createSpSite operation!");
                }, 500);
            }, function (error) {
                $scope.working = false;
                $scope.statusMsg = "Error";
                log("Error when calling createSpSite operation!");
            });
        }

        $scope.resetcache = function () {
            adminApi.resetcache().then(function (data) {
                log("reset cache:" + data);
            });
        }

        $scope.testWebHook = function () {
            log("Call webhook!")
            adminApi.testWebHook().then(function (data) {
                log("Webhook called!")
            },
            function (error) {
                log(error);
            }
            );

        }

        $scope.callLogOperation = function () {
            $scope.progress = 0;
            $scope.working = true;
            $scope.done = false;
            var processId = guidGenerator.newGuid(),
                 pinfo = { percent: 0, totalSteps: 0, currentStep: 0, message: '', errorMessage: '' };
            getStatus(processId, pinfo);

            adminApi.callLogOperation(processId).then(function (data) {
                log("Calling log operation!");
                $timeout(function () {
                    $scope.working = false;
                    $scope.done = true;
                    log("Done calling log operation!");
                }, 500);
            }, function (error) {
                $scope.working = false;
                $scope.statusMsg = "Error";
                log("Error when calling log operation!");
            });
        }

        var getStatus = function (processId, pinfo) {
           
            $scope.progress = pinfo.percent * 1;
            $scope.statusMsg = pinfo.message;
            if ($scope.working) {
                if (pinfo.errorMessage.length > 0) {
                    $scope.statusMsg = 'Error:' + pinfo.errorMessage;
                } else if (pinfo.percent * 1 < 100) {
                    // process update
                    $timeout(function () {
                        adminApi.getApplyStatus(processId)
                            .then(function (pinfo) {
                                getStatus(processId, pinfo);
                            });
                    }, 500);
                }
            }
        };

        var getProjectStatus = function (processId, pinfo) {

            $scope.progress = pinfo.percent * 1;
            $scope.statusMsg = pinfo.message;
            if ($scope.working) {
                if (pinfo.errorMessage.length > 0) {
                    $scope.statusMsg = 'Error:' + pinfo.errorMessage;
                } else if (pinfo.percent * 1 < 100) {
                    // process update
                    $timeout(function () {
                        adminApi.getProjectStatus(processId)
                            .then(function (percent) {
                                pinfo.percent = percent;
                                getProjectStatus(processId, pinfo);
                            });
                    }, 500);
                }
            }
        };

    }

})();
(function () {

    angular.module("WizdomMobileModule").controller("newsController", newsController);
    newsController.$inject = ["$scope", "$timeout", "$modal", "$http", "wcmStarterHttpApi", "settingsApi", "contextInfo"];
    function newsController($scope, $timeout, $modal, $http, httpApi, settingsApi, contextInfo) {
        var vm = this;

        // Properties
        vm.corporateNewsSettings;
        vm.latestNewsSettings;
        vm.trendingNewsSettings;
        vm.userProfileProperties = [];
        vm.newManagedPropertyTitle = '';
        vm.saving = false;

        // Load settings
        settingsApi.getSettings('CorporateNews').then(function (response) {
            vm.corporateNewsSettings = response;
            vm.corporateNewsSettings.ascending = response.ascending || false;
            vm.corporateNewsSettings.cachingType = response.cachingType || 0;
            vm.corporateNewsSettings.departmentFilter = response.departmentFilter || [];
            vm.corporateNewsSettings.departmentFilterDynamic = response.departmentFilterDynamic || '';
            vm.corporateNewsSettings.departmentFilterUseDynamic = response.departmentFilterUseDynamic || false;
            vm.corporateNewsSettings.includeClassicNews = response.includeClassicNews || false;
            vm.corporateNewsSettings.includeModernNews = response.includeModernNews || false;
            vm.corporateNewsSettings.languageFilter = response.languageFilter || [];
            vm.corporateNewsSettings.languageFilterDynamic = response.languageFilterDynamic || '';
            vm.corporateNewsSettings.languageFilterUseDynamic = response.languageFilterUseDynamic || false;
            vm.corporateNewsSettings.locationFilter = response.locationFilter || [];
            vm.corporateNewsSettings.locationFilterDynamic = response.locationFilterDynamic || '';
            vm.corporateNewsSettings.locationFilterUseDynamic = response.locationFilterUseDynamic || false;
            vm.corporateNewsSettings.numberOfNews = response.numberOfNews || 5;
            vm.corporateNewsSettings.orderBy = response.orderBy || 'LastModifiedTime';
            vm.corporateNewsSettings.path = response.path || '';
            vm.corporateNewsSettings.pathModern = response.pathModern || '';
            vm.corporateNewsSettings.queryMode = response.queryMode || 1;
            vm.corporateNewsSettings.resultSource = response.resultSource || '8413cd39-2156-4e00-b54d-11efd9abdb89';
            vm.corporateNewsSettings.selectProperties = ['UniqueId', 'ListID', 'ListItemId', 'Title', 'Path', 'W365EnableSocialOWSBOOL', 'W365NewsSummaryOWSHTML', 'PublishingPageContentOWSHTML', 'PublishingRollupImageOWSIMGE', 'PublishingImage', 'LastModifiedTime', 'owstaxIdW365RelatedTopic', 'VideoUrl', 'ContentTypeId', 'SPWebUrl', 'SPSiteUrl', 'W365TopNewsOWSBOOL', 'ViewsRecent', 'ViewsRecentUniqueUsers', 'ViewsLifetime', 'ViewsLifeTimeUniqueUsers', 'PromotedState', 'BannerImageUrlOWSURLH', 'PictureThumbnailURL', 'CanvasContent1OWSHTML', 'Description'];
            vm.corporateNewsSettings.typeNews = response.typeNews || 2;
        });

        settingsApi.getSettings('NewsLatest').then(function (response) {
            vm.latestNewsSettings = response;
        });

        settingsApi.getSettings('NewsTrending').then(function (response) {
            vm.trendingNewsSettings = response;
        });

        // Public methods
        vm.saveSettings = saveSettings;

        // Private methods
        function initialize() {
            // Load userprofile properties
            httpApi.get('/api/userprofile/getpropertykeys').then(function (response) {
                for (var i = 0; i < response.length; i++) {
                    vm.userProfileProperties.push({
                        title: response[i],
                        selected: false
                    });
                }
            });
        }
        initialize();

        function saveSettings(componentName, settings) {
            vm.saving = true;
            settingsApi.saveSettings(componentName, settings).then(function () {
                // Timeouts for UX actually see the saving messaged
                $timeout(function () {
                    vm.saving = false;
                }, 1000);
            }, function () {
                // handle errors?
            });
        }
        
    }
})();
(function () {

    angular.module("WizdomMobileModule").controller("newsNotificationController", newsNotificationController);
    newsNotificationController.$inject = ["$scope", "$timeout", "$modal", "$http", "wcmStarterHttpApi", "settingsApi", "contextInfo"];
    function newsNotificationController($scope, $timeout, $modal, $http, httpApi, settingsApi, contextInfo) {
        var vm = this;

        // Properties
        vm.newsNotificationSettings;
        vm.sharePointModel = null;
        vm.saving = false;
        

        // Load settings
        settingsApi.getSettings('NewsNotificationSettings').then(function (response) {
            vm.newsNotificationSettings = response;
        });

        // Public methods
        vm.createWebHook = createWebHook;
        vm.deleteWebHook = deleteWebHook;
        vm.saveSettings = saveSettings;

        // Private methods
        function initialize() {
            // Load web lists
            getCurrentListsFromWeb();

        }
        initialize();

        function getCurrentListsFromWeb() {
            httpApi.get(contextInfo.appUrl + '/api/newsnotification/getcurrentlistsfromweb').then(function (response) {
                vm.sharePointModel = response;
            });
        }

        function createWebHook() {
            httpApi.post(contextInfo.appUrl + '/api/newsnotification/createwebhook/' + vm.selectedSharePointList).then(function (response) {
                // do something
                console.log(response);
            }).catch(function (e) {
                console.log(e);
            });
        }

        function deleteWebHook(id, listId) {
            if (confirm("Are you sure you want to delete this web hook?")) {
                httpApi.delete(contextInfo.appUrl + '/api/newsnotification/deletewebhook/' + id + '/' + listId).then(function (response) {
                    // do something
                    console.log(response);
                }).catch(function (e) {
                    console.log(e);
                });
            }
        }

        function saveSettings(componentName, settings) {
            vm.saving = true;
            settingsApi.saveSettings(componentName, settings).then(function () {
                // Timeouts for UX actually see the saving messaged
                $timeout(function () {
                    vm.saving = false;
                }, 1000);
            }, function () {
                // handle errors?
            });
        }

    }
})();
(function () {

    angular.module("WizdomMobileModule").controller("noticeboardController", noticeboardController);
    noticeboardController.$inject = ["$scope", "$timeout", "settingsApi", "noticeboardService"];
    function noticeboardController($scope, $timeout, settingsApi, noticeboardService) {
        var vm = this;

        // Properties
        vm.noticeboardSettings;
        vm.channelSets = [];
        vm.saving = false;

        // Load settings
        settingsApi.getSettings('NewsNoticeboard').then(function (response) {
            vm.noticeboardSettings = response;
        });

        // Load available noticeboard channelsets
        noticeboardService.getChannelSets().then(function (response) {
            vm.channelSets = response;
        });

        // Public methods
        vm.saveSettings = saveSettings;
        vm.saveViewConfiguration = saveViewConfiguration;

        // Private methods
        function saveSettings(componentName, settings) {
            vm.saving = true;
            settingsApi.saveSettings(componentName, settings).then(function () {
                // Timeouts for UX actually see the saving messaged
                $timeout(function () {
                    vm.saving = false;
                }, 1000);
            }, function () {
                // handle errors?
            });
        }

        function saveViewConfiguration() {
            var data = {
                "id": "e9cfafe2-e5d3-475f-8ff2-4fb34b2155b4",
                "channelSetId": vm.noticeboardSettings.channelSetId,
                "deviceId": 1,
                "deviceIdentifier": "Webpart",
                "sharedChannelSet": true,
                "extendedProperties": {
                    "itemsPerPage": vm.noticeboardSettings.itemsPerPage,
                    "maxNumberOfPages": 1, //vm.noticeboardSettings.maxNumberOfPages,
                    "defaultSelection": "All",
                    "hideToolbar": false,
                    "archiveUrl": null,
                    "overviewTemplate": "Noticeboard/Templates/ViewTemplates/Webpart/Overview/WizdomMobileModule_Overview_Default.html",
                    "showItemTemplate": "Noticeboard/Templates/ViewTemplates/Webpart/ShowItem/WizdomMobileModule_Show_Default.html",
                    "createEditNewsTemplate": "Noticeboard/Templates/ViewTemplates/Webpart/NewEditForm/WizdomMobileModule_CreateAndEdit.html",
                    "createEditVideoTemplate": "Noticeboard/Templates/ViewTemplates/Webpart/NewEditForm/WizdomMobileModule_CreateAndEdit.html"
                },
                "editAllowedForCurrentUser": false
            }
            noticeboardService.getViewById('e9cfafe2-e5d3-475f-8ff2-4fb34b2155b4').then(function (response) {
                if (response.views.count > 0) {
                    // update existing view
                    noticeboardService.putViewById('e9cfafe2-e5d3-475f-8ff2-4fb34b2155b4', data);
                }
                else {
                    // create new view
                    noticeboardService.postViewById('e9cfafe2-e5d3-475f-8ff2-4fb34b2155b4', data);
                }
            });

        }
    }

})();
(function () {

    angular.module("WizdomMobileModule").controller("PeopleAdminController", PeopleAdminController);
    PeopleAdminController.$inject = ["$scope", "$window", "$timeout", "settingsApi"];
    function PeopleAdminController($scope, $window, $timeout, settingsApi) {
        var vm = this;

        // Properties
        vm.peopleSettings;
        vm.newManagedPropertyTitle;
        
        vm.saving = false;

        // Load settings
        settingsApi.getSettings('People').then(function (response) {
            vm.peopleSettings = response;
            vm.peopleSettings.managedProperties = response.managedProperties || [];
            vm.peopleSettings.enableSuggestedPeople = response.enableSuggestedPeople || false;
            vm.peopleSettings.resultSourceId = response.resultSourceId || null;
        });

        // Public methods
        vm.saveSettings = saveSettings;
        vm.addManagedProperty = addManagedProperty;
        vm.deleteManagedProperty = deleteManagedProperty;

        // Private methods
        function saveSettings(componentName, settings) {
            vm.saving = true;
            settingsApi.saveSettings(componentName, settings).then(function () {
                // Timeouts for UX actually see the saving messaged
                $timeout(function () {
                    vm.saving = false;
                }, 1000);
            }, function () {
                // handle errors?
            });
        }

        function addManagedProperty(title) {
            if (vm.peopleSettings.managedProperties.indexOf(title) == -1) {
                vm.peopleSettings.managedProperties.push(title);
                vm.newManagedPropertyTitle = '';
                saveSettings('People', vm.peopleSettings);
            }
        }

        function deleteManagedProperty(title) {
            var confirm = $window.confirm("Are you absolutely sure you want to delete?");
            if (confirm) {
                var index = vm.peopleSettings.managedProperties.indexOf(title);
                vm.peopleSettings.managedProperties.splice(index, 1);
                vm.saveSettings('People', vm.peopleSettings);
            }
        }
    }

})();
(function () {

    angular.module("WizdomMobileModule").controller("settingsController", settingsController);

    settingsController.$inject = ["$scope", "wcmStarterSettingsApi", "wcmStarterHttpApi", "administrationApi", "$timeout"];

    function settingsController($scope, wcmStarterSettingsApi, httpApi, administrationApi, $timeout) {
        var emptyWfSite = { title: '', url: '', admins: [] };
        var emptyCmSite = { instanceName: '', instanceId: 0, signupRoleName: 'W365CM_Participants', defaultPageUrl: '/Sider/course_details.aspx?course='};
        $scope.newCmSite = angular.copy(emptyCmSite);
        $scope.saving = false;
        $scope.addingNewSite = false;
        $scope.selectedInstance = null;
        $scope.appInstances = {};

        var stg = { helpdeskMail: '', addGetHelpLinkToTopPanel:false };
        $scope.stg = stg;
        function init() {
            administrationApi.getCourseManagementInstances().then(function (instances) {
                $scope.appInstances = instances;
            });
            //wcmStarterSettingsApi.getSettings().then(function (stg) {
            //    $scope.stg = stg;
            //    if (!$scope.stg.sitesWithIntegration) {
            //        $scope.stg.sitesWithIntegration = [];
            //        $scope.stg.sitesWithIntegration.push(angular.copy(emptyCmSite));
            //    }
            //});
        }

        $timeout(init, 0);
        
        $scope.saveConfig = function () {
            $scope.saving = true;
            wcmStarterSettingsApi.saveSettings($scope.stg).then(
                function () {
                    $scope.saving = false;
                }
          )
        };

        $scope.addPrincipal = function (principal) {
        }
        $scope.removePrincipal = function (principal) {
        }

        $scope.deleteSite = function (index) {
            $scope.stg.sitesWithIntegration.splice(index, 1);
        }

        $scope.addNewSite = function () {
            $scope.addingNewSite = true;
        }
        $scope.cancel = function () {
            resetNewCmSiteSites();
        }
        $scope.saveNewSite = function () {
            if (!$scope.stg.sitesWithIntegration) { $scope.stg.sitesWithIntegration = []; }
            $scope.instanceChanged();
            if ($scope.newCmSite.instanceId > 0) {
                $scope.stg.sitesWithIntegration.push($scope.newCmSite);
            }
            resetNewCmSiteSites();
        }

        $scope.instanceChanged = function () {
            var instance = $scope.selectedInstance;
            if (instance != null) {
                $scope.newCmSite.instanceName = instance.name;
                $scope.newCmSite.instanceId = instance.id;
            }
        }

        function resetNewCmSiteSites() {
            $scope.selectedInstance = null;
            $scope.addingNewSite = false;
            $scope.newCmSite = emptyCmSite;
        }



    }
})();
(function () {

    angular.module("WizdomMobileModule").controller("themeAdminController", themeAdminController);
    themeAdminController.$inject = ["$scope", "$timeout", "settingsApi", "colorShadeService"];
    function themeAdminController($scope, $timeout, settingsApi, colorShadeService) {
        var vm = this;

        var defaultThemes = [
            {
                name: 'Grey',
                primaryColor: '#515151',
                primaryFontColor: '#ffffff',
                secondaryColor: '#a4a4a4',
                secondaryFontColor: '#ffffff'
            },
            {
                name: 'Blue',
                primaryColor: '#003748',
                primaryFontColor: '#ffffff',
                secondaryColor: '#205683',
                secondaryFontColor: '#ffffff'
            },
            {
                name: 'Green',
                primaryColor: '#5a782d',
                primaryFontColor: '#ffffff',
                secondaryColor: '#88b04b',
                secondaryFontColor: '#ffffff'
            },
            {
                name: 'Red',
                primaryColor: '#ac1310',
                primaryFontColor: '#ffffff',
                secondaryColor: '#f44142',
                secondaryFontColor: '#ffffff'
            }

        ];
        var defaultFonts = [
            {
                name: 'Segoe',
                fontFamily: 'Segoe UI, Arial'
            },
            {
                name: 'Arial',
                fontFamily: 'Arial, Sans'
            }
        ];

        vm.defaultThemes = defaultThemes;
        vm.defaultFonts = defaultFonts;
        vm.colorShadeService = colorShadeService;

        vm.status = {
            isFirstOpen: true
        };


        //function setProperties(theme) {
        //    //primary
        //    document.documentElement.style.setProperty('--PrimaryColor', theme.primaryColor);
        //    document.documentElement.style.setProperty('--PrimaryShade', vm.colorShadeService.shadeColor(theme.primaryColor, 0.2));
        //    document.documentElement.style.setProperty('--PrimaryFontColor', theme.primaryFontColor);

        //    //secondary
        //    document.documentElement.style.setProperty('--SecondaryColor', theme.secondaryColor);
        //    document.documentElement.style.setProperty('--SecondaryShade', vm.colorShadeService.shadeColor(theme.secondaryColor, 0.2));
        //    document.documentElement.style.setProperty('--SecondaryFontColor', theme.secondaryFontColor);
        //}

        // private methods

        function getSettings() {
            settingsApi.getSettings('Theme').then(function (response) {
                vm.themeSettings = response;
                
                vm.themeSettings.themes = vm.themeSettings.themes || [];
                vm.themeSettings.fonts = vm.themeSettings.fonts || [];

                var respTheme = vm.selectedTheme || response.selectedTheme;
                var respFont = vm.selectedFont || response.selectedFont;

                var selTheme = {};
                var selFont = {};

                if (respTheme) {
                    selTheme = vm.defaultThemes.filter(function (ele) { return ele.name == respTheme.name })[0] ||
                        vm.themeSettings.themes.filter(function (ele) { return ele.name == respTheme.name })[0];
                }
                if (respFont) {
                    selFont = vm.defaultFonts.filter(function (ele) { return ele.name == respFont.name })[0] ||
                        vm.themeSettings.fonts.filter(function (ele) { return ele.name == respFont.name })[0];
                }

                vm.selectedTheme = selTheme || {};
                vm.selectedFont = selFont || {};
            });
        }

        function init() {
            getSettings();
        }
        init();

        // public methods

        vm.addSetting = function (type, obj) {
            if (!vm.themeSettings[type].filter(function (ele) { return ele.name === obj.name }).length) {
                vm.themeSettings[type].push(angular.copy(obj));
            }
        };

        vm.removeTheme = function (type, index) {
            // find a way to test for both theme and font selected
            if (vm.themeSettings[type][index] != vm.themeSettings.selectedTheme) {
                vm.themeSettings[type].splice(index, 1);
            } else {
                alert('Not possible to remove ' + vm.themeSettings[type].themes[index].name + ' because its the one in use')
            }
        };

        vm.saveSettings = function (componentName, settings) {
            vm.saving = true;
            settings.selectedTheme = vm.selectedTheme;
            settings.selectedFont = vm.selectedFont;

            settingsApi.saveSettings(componentName, settings).then(function () {
                // Timeouts for UX actually see the saving messaged
                $timeout(function () {
                    vm.saving = false;
                }, 1000);
            }, function () {
                // handle errors?
            });
        };
    }

})();
(function () {
    angular.module("WizdomMobileModule").controller("translationsAdminController", translationsAdminController);
    translationsAdminController.$inject = ["$scope","wcmStarterHttpApi" ,"webApiProxy", "contextInfo"];
    function translationsAdminController($scope, httpApi ,webApiProxy, contextInfo) {
        var vm = this;

        //public methods
        vm.getTranslation = getTranslation;
        vm.postTranslationFile = postTranslationFile;
        vm.defaultTranslations = [];
        vm.loading = false;
        vm.dataReady = false;
        vm.translationsObj = {};

        vm.availableTranslations = [];

        function getTranslation(languageCode) {
            httpApi.get(contextInfo.appUrl + '/api/translations/' + languageCode).then(function (response) {
                vm.translationsObj = response;
                vm.dataReady = true;
            });
        }

        function postTranslationFile(languageCode) {
            vm.loading = true;
            getTranslation(languageCode);
            webApiProxy.translations.uploadTranslationFile(languageCode, JSON.stringify(vm.translationsObj)).then(function () {
                vm.loading = false;
            });
        }

        function getTranslations() {
            httpApi.get(contextInfo.appUrl + '/api/translations/translationsfiles').then(function (response) {
                vm.availableTranslations = response;
            });
        }

        function init() {
            getTranslations();
        }
        init();
    }

})();
(function () {
    angular.module("WizdomMobileModule").filter('startFrom', function () {
        return function (input, start) {
            start = +start; //parse to int
            return input.slice(start);
        }
    });
})();
(function () {
    angular.module("WizdomMobileModule").filter("thumbnailImage",

        function thumbnailImage() {

            return function (url) {
                var newUrl = url;
                var keywords = url.lastIndexOf('?width=' | '?height=' | '?RendtionID=');
                if (keywords) {
                    newUrl = handleUrl(url);
                }
                return newUrl;
            }

            function handleUrl(url) {
                var seperator = '?'

                url = url.split(seperator)[0];

                if (url.indexOf('PublishingImages')) {
                    url = url + '?RenditionID=2'.toLowerCase();
                }

                return url;
            }
        });
})();

(function () {
    angular.module("WizdomMobileModule").filter("translate", translate);
    translate.$inject = ["translations"];
    function translate(translations) {
        var Wizdom = window["Wizdom"];
        var language = Wizdom && Wizdom.getCurrentLanguage ? Wizdom.getCurrentLanguage() : 'da-dk';

        return function (translationId, interpolateParams, interpolation) {
            var arguments = angular.isArray(interpolateParams) ? interpolateParams :
                angular.isObject(interpolateParams) ? interpolateParams :
                    angular.isDefined(interpolateParams) ? [interpolateParams] : [];
            var rtnVal = (translations[language] == null || !translations[language][translationId]) ? translationId : translations[language][translationId];
            angular.forEach(arguments, function (value, index) {
                rtnVal = rtnVal.replace('{ ' + index + '}', value || '');
            });
            return rtnVal;
        }
    }
})();

(function () {
    angular.module("WizdomMobileModule").factory("administrationApi", administrationApi);

    administrationApi.$inject = ["$q", "wcmStarterHttpApi"];

    function administrationApi($q, httpApi) {
        var baseUrl = '/api/administration/';

        function getPagesTree() {
            return httpApi.get(baseUrl + 'gettree');
        }
        var service = {
            pagesTree: getPagesTree,
            install: function (processId) {
                return httpApi.post(baseUrl + 'install/' + processId);
            },
            createWizdomProject: function (processId, wizdomProject) {
                return httpApi.post('/api/wizdomproject/create/' + processId, wizdomProject);
            },
            createSpSite: function (processId, siteId) {
                return httpApi.post('/api/wizdomproject/spsite/' + siteId + '/' + processId + '/');
            },
            getProjectStatus: function (processId) {
                return httpApi.get('/api/wizdomproject/status/' + processId);
            },
            installWizdom: function (processId, url) {
                return httpApi.post('/api/wizdomproject/installwizdom/' + processId + '?url=' + encodeURIComponent(url));
            },
            resetcache: function () {
                return httpApi.get(baseUrl + 'resetcache');
            },
            initCache: function (sourceUrl, destinationUrl, contentTypeIdentifier) {
                return httpApi.get(baseUrl + 'initcache/?sourceUrl=' + encodeURIComponent(sourceUrl) + '&destinationUrl=' + encodeURIComponent(destinationUrl) + '&contentTypeIdentifier=' + encodeURIComponent(contentTypeIdentifier));
            },
            callLogOperation: function (processId) {
                return httpApi.get(baseUrl + 'logoperation/' + processId);
            },
            getApplyError: function (processId) {
                return httpApi.get(baseUrl + 'error/' + processId);
            },
            getApplyStatus: function (processId) {
                return httpApi.get(baseUrl + 'status/' + processId);
            },
            testWebHook: function () {
                return httpApi.post('/api/webhook/wizdomsitecreated');
            },
            getLogs: function (wizdomModule) {
                if (!wizdomModule) { wizdomModule = "";}
                return httpApi.get("/api/wcmStarterlog?module=" + wizdomModule);
            },
            clearLog: function (wizdomModule) {
                if (!wizdomModule) { wizdomModule = ""; }
                return httpApi.delete("/api/wcmStarterlog?module=" + wizdomModule);
            },
            getCourseManagementInstances: function () {
                return httpApi.get("/api/wizdomproject/coursemanagementinstances");
            },
            getSettings: function () {
                return httpApi.get(baseUrl + 'GetSettings');
            },
            saveSettings: function (settings) {
                return httpApi.post(baseUrl + 'SaveSettings', settings);
            }
        };
        
        return service;
    }
})();
(function () {
    angular.module("WizdomMobileModule").factory("clientStorageService", clientStorageService);

    clientStorageService.$inject = ["$window", "$document"];

    function clientStorageService($window, $document) {
        return { session: getObj(window.sessionStorage, 'session'), local: getObj(window.localStorage, 'local') };
    };

    function getObj(storage, sType) {
        return {
            storageType: sType,
            setItem: function (key, value, expiresAt) {
                setItem(storage, key, value, expiresAt);
            },
            removeItem: function (key) {
                removeItem(storage, key);
            },
            getItem: function (key) {
                var k = getKey(key);
                return getItem(storage, k);
            },
            clear: function (pattern) {
                return clear(storage, pattern);
            },
            isExpired: function (key) {
                return isExpired(storage, key);
            },
            getExpireTime: function (key) {
                return getExpireTime(storage, key);
            },
            expiresIn: function (key) {
                return expiresIn(storage, key);
            },
            testExpires: function (key) {
                return testExpires(storage, key);
            },
            hasStorage: function (pattern) {
                return hasStorage(storage, pattern);
            },
            expiresInToMinutes: function (expiresIn) {
                return (expiresIn / 60000);
            },
            addMinutesToNow: function (minutes) {
                return new Date(new Date().getTime() + (minutes * 60000));
            }
        };

    }

    // helper functions
    function getExpireTime(storage, cacheKey) {
        var rval = 0;
        var k = getKey(cacheKey) + '_At';
        var expiresAt = storage.getItem(k);
        if (expiresAt != null) {
            rval = expiresAt;
        }
        return rval;
    }
    function expiresIn(storage, cacheKey) {
        var expireTime = getExpireTime(storage, cacheKey)
        return expiresInDiff(expireTime);
    }
    function expiresInDiff(expireTime) {
        if (expireTime == 0) { return expireTime; }
        var now = new Date().getTime();
        return expireTime - now;
    }
    function isExpired(storage, cacheKey) {
        return (expiresIn(storage, cacheKey) < 0);
    }
    function setItem(storage, key, value, expiresAt) {
        if (angular.isUndefined(value)) { value = null; }
        if (angular.isUndefined(expiresAt)) { expiresAt = 0; }
        var k = getKey(key);
        storage.setItem(k, value);
        if (expiresAt > 0) {
            storage.setItem(k + '_At', expiresAt);
        }
    }
    function getItem(storage, key) {
        var k = getKey(key);
        if (isExpired(storage, key)) {
            removeItem(storage, key);
            return null;
        }
        return storage.getItem(k);
    }
    function clear(storage, pattern) {
        if (angular.isUndefined(pattern)) {
            pattern = '';
        }
        var prefix = getKey(pattern), rval = 0;
        for (var obj in storage) {
            if (storage.hasOwnProperty(obj) && (obj.indexOf(prefix) == 0)) {
                storage.removeItem(obj);
                rval++;
            }
        }
        return rval;
    }
    function hasStorage(storage, pattern) {
        if (angular.isUndefined(pattern)) {
            pattern = '';
        }
        var prefix = getKey(pattern), rval = false;
        for (var obj in storage) {
            if (storage.hasOwnProperty(obj) && (obj.indexOf(prefix) == 0)) {
                rval = true;
                break;
            }
        }
        return rval;
    }
    function removeItem(storage, key) {
        var k = getKey(key);
        storage.removeItem(k);
        storage.removeItem(k + '_At');
    }
    function getKey(key) {
        if (key.indexOf("wiz_") < 0) {
            return "wiz_" + key;
        }
        return key;
    }

    //test functions
    function testExpires(storage, key) {
        var now = new Date().getTime(),
            expiresAt = getExpireTime(storage, key);

        window.console && window.console.log('expiresAt:' + expiresAt + ' now:' + now + ' key:' + key);
        var brdInterval = setInterval(function () {
            var diff = expiresInDiff(expiresAt);
            var diff_as_date = new Date(diff);
            window.console && window.console.log('diff:' + diff + ' h:' + diff_as_date.getHours() + ' m:' + diff_as_date.getMinutes() + ' s:' + diff_as_date.getSeconds());
            if (diff < 0) {
                clearInterval(brdInterval);
            }
        }, 1000);
    }
    /*
        Date.prototype.addMinutes = function (minutes) {
            var copiedDate = new Date(this.getTime());
            return new Date(copiedDate.getTime() + minutes * 60000);
        }
    */
})();
(function () {
    angular.module("WizdomMobileModule").factory("colorShadeService", colorShadeService);
    colorShadeService.$inject = [];
    function colorShadeService() {


        // https://stackoverflow.com/questions/5560248/programmatically-lighten-or-darken-a-hex-color-or-rgb-and-blend-colors
        // Documentation for algoritm used in service.
        function shadeColor(color, percent) {
            if (typeof color != "undefined" || color != null) {
            if (color.startsWith('#')) {
                var f = parseInt(color.slice(1), 16), t = percent < 0 ? 0 : 255, p = percent < 0 ? percent * -1 : percent, R = f >> 16, G = f >> 8 & 0x00FF, B = f & 0x0000FF;
                return "#" + (0x1000000 + (Math.round((t - R) * p) + R) * 0x10000 + (Math.round((t - G) * p) + G) * 0x100 + (Math.round((t - B) * p) + B)).toString(16).slice(1);

            } else if (color.startsWith('rgb')) {
                var f = color.split(","), t = percent < 0 ? 0 : 255, p = percent < 0 ? percent * -1 : percent, R = parseInt(f[0].slice(4)), G = parseInt(f[1]), B = parseInt(f[2]);
                return "rgb(" + (Math.round((t - R) * p) + R) + "," + (Math.round((t - G) * p) + G) + "," + (Math.round((t - B) * p) + B) + ")";

            } else {
                return color;
                }
            }
       
        }

        var service = {
            shadeColor: shadeColor
        };
        return service;
    }
})();
(function () {
    angular.module("WizdomMobileModule").factory("contextInfo", contextInfo);

    contextInfo.$inject = ["mobile"];
    function contextInfo(mobile) {
        var listContext = [];

        if (window["ctx"]) {
            var i = window["ctx"].ctxId;

            while (window["ctx" + i]) {
                listContext.push({ title: window["ctx" + i].ListTitle, dirUrl: window["ctx" + i].listUrlDir });
                i++;
            }

            if (listContext.length == 1) {
                listContext = listContext[0];
            }
        }

        var qsParam = getQueryParameters();
        var lang = (window["_spPageContextInfo"] ? window["_spPageContextInfo"].currentUICultureName :
            qsParam.SPLanguage ? decodeURIComponent(qsParam.SPLanguage) : "en-us").toLowerCase();  // defaults to en-us 

        return {
            pageIsInEditMode: window["PageState"] ? window["PageState"].ViewModeIsEdit == "1" : false,
            userId: window["_spPageContextInfo"] ? window["_spPageContextInfo"].userId : null,
            userLoginName: window["_spPageContextInfo"] ? window["_spPageContextInfo"].userLoginName : null,
            currentPage: window["_spPageContextInfo"] ? window["_spPageContextInfo"].serverRequestPath : null,
            pageListId: window["_spPageContextInfo"] ? window["_spPageContextInfo"].pageListId : null,
            pageItemId: window["_spPageContextInfo"] ? window["_spPageContextInfo"].pageItemId : null,
            listContext: window["ctx"] ? listContext : null,
            webServerRelativeUrl: window["_spPageContextInfo"] ? window["_spPageContextInfo"].webServerRelativeUrl : null,
            siteServerRelativeUrl: window["_spPageContextInfo"] ? window["_spPageContextInfo"].siteServerRelativeUrl : null,
            siteAbsoluteUrl: window["_spPageContextInfo"] ? window["_spPageContextInfo"].siteAbsoluteUrl : null,
            spHostUrl: window["_spPageContextInfo"] ? window["_spPageContextInfo"].siteAbsoluteUrl : window["decodeURIComponent"](qsParam.SPHostUrl),
            spWebUrl: window["_spPageContextInfo"] ? window["_spPageContextInfo"].webAbsoluteUrl : qsParam.SPWebUrl,
            appUrl: (window["Wizdom365AppUrl"]) ? window["Wizdom365AppUrl"] : window.location.protocol + '//' + window.location.host,
            clientId: window["Wizdom365ClientID"],
            language: lang, // defaults to en-us    
            locale: qsParam.SPLocale ? decodeURIComponent(qsParam.SPLocale) : lang,  //default to language  
            productNumber: window["_spPageContextInfo"] ? window["_spPageContextInfo"].siteClientTag.split("$")[2] : qsParam.SPProductNumber,
            requestPath: window["_spPageContextInfo"] ? window["_spPageContextInfo"].serverRequestPath : null,
            isSettingsPage: location.href ? ((location.href.indexOf("_layouts/15/") > -1) && (location.href.indexOf("#") < location.href.lastIndexOf("_layouts/15/"))) : false, //Check if "layouts/15" is in url and also check if "#" is before ".aspx" (to support minimal download strategy)
            isDialogPage: location.href ? (location.href.indexOf("IsDlg=1") > -1) : false,
            isMobile: mobile.detectmob() && mobile.getCookie("WizdomMobile") !== "false" ? true : false,
            friendUrlTermId: window["_spFriendlyUrlPageContextInfo"] ? window["_spFriendlyUrlPageContextInfo"].termId : null,
            friendUrlTermSetId: window["_spFriendlyUrlPageContextInfo"] ? window["_spFriendlyUrlPageContextInfo"].termSetId : null,
            friendUrlTermStoreId: window["_spFriendlyUrlPageContextInfo"] ? window["_spFriendlyUrlPageContextInfo"].termStoreId : null,
            pageFileVersionForDisplay: window["g_PageFileVersionForDisplay"] ? window["g_PageFileVersionForDisplay"] : null,
            friendlyUrlPageconextInfo: window["_spFriendlyUrlPageContextInfo"] ? window["_spFriendlyUrlPageContextInfo"] : null,
            pageColumns: window["wizdomPageColumns"],
            wizdomEnvironmentIsOnPrem: window["WizdomEnvironmentIsOnPrem"]
        };
    };

    function getQueryParameter(name) {
        return decodeURIComponent((new RegExp('[?|&]' + name + '=' + '([^&;]+?)(&|#|;|$)').exec(location.search) || [, ""])[1].replace(/\+/g, '%20')) || null
    };

    function getQueryParameters() {
        return {
            SPHostUrl: getQueryParameter('SPHostUrl'),
            SPWebUrl: getQueryParameter('SPAppWebUrl'),
            SPLanguage: getQueryParameter('SPLanguage'),
            SPProductNumber: getQueryParameter('SPProductNumber'),
            SPLocale: getQueryParameter('SPLocale')
        };
    }
})();
(function () {
    angular.module("WizdomMobileModule").factory("guidGenerator", guidGenerator);

    function guidGenerator() {
        var service = {
            newGuid: newGuid
        };

        return service;

        function newGuid() {
            return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
                var r = Math.random() * 16 | 0, v = c == 'x' ? r : (r & 0x3 | 0x8);
                return v.toString(16);
            });
        }
    }
})();
//// Api Service to post through Wizdom
(function () {
    angular.module("WizdomMobileModule").factory("wcmStarterHttpApi", httpApi);

    httpApi.$inject = ["$q", "contextInfo", "wcmStarterModuleConfiguration"];

    function httpApi($q, contextInfo, moduleConfiguration) {
        var appUrl = moduleConfiguration.appUrl;
        var service = this;
        service.get = getFn;
        service.post = function (url, data) { return makeRequest("POST", url, data); };
        service.put = putFn;
        service.delete = deleteFn;
        service.getCached = getFnAppCached;
        service.resetCache = function (url) {
            promises[url] = null;
        }

        var promises = [];
        function getFn(url) {
            return makeRequest("GET", url, null);
        }
        function getFnAppCached(url) {
            if (promises[url] == null) {
                promises[url] = getFn(url);
            }
            return promises[url];
        }
        function putFn(url, data) {
            return makeRequest("PUT", url, data);
        }
        function deleteFn(url) {
            return makeRequest("DELETE", url, null);
        }

        var requestQueue = [];
        var requestIndex = 0;
        function makeRequest(method, url, data) {
            var deferred = $q.defer(), pos = url.indexOf('://'), wizPrefix = 'wizdom://', wizPos = url.indexOf(wizPrefix);
            if (wizPos == 0) {
                url = url.replace(wizPrefix, '/');
            } else if (pos < 0) {
                url = appUrl + url;
            }
            var queryStart = url.indexOf("?") > 0 ? "&" : "?", urlParts = [];
            urlParts.push(url);
            urlParts.push(queryStart);
            if (url.indexOf("SPHostUrl=") < 0) {
                urlParts.push("SPHostUrl=" + window["encodeURIComponent"](contextInfo.spWebUrl || contextInfo.spHostUrl));
            }
            if (url.indexOf("SPLocale=") < 0) {
                urlParts.push("&SPLocale=" + window["encodeURIComponent"](contextInfo.locale));
            }
            url = urlParts.join("");

            requestQueue[requestIndex] = deferred;
            window.parent.postMessage(JSON.stringify({
                command: "ExternalRequest",
                method: method,
                url: url,
                data: data,
                context: appUrl+requestIndex++
            }), "*");
            return deferred.promise;
        }
        function postMessageHandler(e) {
            try {
                var message = JSON.parse(e.data);
                if (!message.command)
                    return;
                if (message.command === "ExternalRequestSuccess" && ("" + message.context).indexOf(appUrl) >= 0) {
                    requestQueue[message.context.replace(appUrl, "")].resolve(message.result);
                }
                if (message.command === "ExternalRequestError" && ("" + message.context).indexOf(appUrl) >= 0) {
                    requestQueue[message.context.replace(appUrl, "")].reject(message.result);
                }
            }
            catch (e) {
                if (("" + message.context).indexOf(appUrl) >= 0)
                    requestQueue[message.context.replace(appUrl, "")].reject(message.result)
            }
        }
        
        function init() {
            console.log("init");
            if (typeof window.addEventListener != 'undefined')
                window.addEventListener('message', postMessageHandler, false);
            else if (typeof window["attachEvent"] != 'undefined')
                window["attachEvent"]('onmessage', postMessageHandler);
        }
        init();
        return service;
    }
})();
(function () {
    angular.module("WizdomMobileModule").factory("log", log);

    log.$inject = ["contextInfo"];
    function log(contextInfo) {
        var showLog = contextInfo.appUrl.toLowerCase().indexOf("localhost") > 0;
        return function (text, param) {
            try {
                if (showLog && console && console.log) {
                    if (param) {
                        window.console && window.console.log(text, param);
                    } else {
                        window.console && window.console.log(text);
                    }
                }
            }
            catch (e) { }
        };
    };
})();
(function () {
    angular.module("WizdomMobileModule").factory("mobile", mobile);
    function mobile() {
        return {
            detectmob: function () {
                if (navigator.userAgent.match(/Android/i)
                    || navigator.userAgent.match(/webOS/i)
                    || navigator.userAgent.match(/iPhone/i)
                    || navigator.userAgent.match(/iPad/i)
                    || navigator.userAgent.match(/iPod/i)
                    || navigator.userAgent.match(/BlackBerry/i)
                    || navigator.userAgent.match(/Windows Phone/i)
                ) {
                    return true;
                }
                else {
                    return false;
                }
            },

            setCookie: function (cname, cvalue, exdays) {
                var d = new Date();
                d.setTime(d.getTime() + (exdays * 24 * 60 * 60 * 1000));
                var expires = "expires=" + d;
                document.cookie = cname + "=" + cvalue + "; " + expires + ";" + "path=/";
            }
        };
    }
})();
 (function () {
    angular.module('WizdomMobileModule').factory('newsService', newsService);
     newsService.$inject = ['$window', '$http', '$timeout', 'contextInfo', 'wcmStarterHttpApi'];

     function newsService($window, $http, $timeout, contextInfo, httpApi) {

        var baseUrl = contextInfo.spHostUrl;

        // Get latest corporate news
         function getLatest(rowLimit, startRow) {
             var query = 'ContentTypeId:0x010100C568DB52D9D0A14D9B2FDCC96666E9F2007948130EC3DB064584E219954237AF3900E1A7B5EB4F6D4536ABA24236F66055A100170370F5340444D1B84CA664EC7FB117*'; // Wizdom Newspage ContentType
             var properties = 'UniqueId,ListID,ListItemId,Title,Path,W365NewsSummaryOWSHTML,PublishingPageContentOWSHTML,PublishingRollupImageOWSIMGE,PublishingImage,LastModifiedTime,owstaxIdW365RelatedTopic,VideoUrl,ContentTypeId,SPWebUrl,SPSiteUrl,W365TopNewsOWSBOOL';
             var trimDuplicates = 'false';
             var sortList = 'LastModifiedTime:descending';
             return httpApi.get('/api/news/getlatestnews?webUrl=' + encodeURIComponent(baseUrl)).then(function (response) {
                 // Mapping each table rows and foreach cell add variabel to object
                 return response;
             });
         }

        // Get trending news based on viewsrecent
        function getTrending(rowLimit, startRow) {
            var query = 'ContentTypeId:0x010100C568DB52D9D0A14D9B2FDCC96666E9F2007948130EC3DB064584E219954237AF3900E1A7B5EB4F6D4536ABA24236F66055A100170370F5340444D1B84CA664EC7FB117*'; 
            var properties = 'UniqueId,ListID,ListItemId,Title,Path,W365NewsSummaryOWSHTML,PublishingPageContentOWSHTML,PublishingRollupImageOWSIMGE,PublishingImage,LastModifiedTime,owstaxIdW365RelatedTopic,VideoUrl,ContentTypeId,SPWebUrl,SPSiteUrl,W365TopNewsOWSBOOL,ViewsRecent,ViewsRecentUniqueUsers,ViewsLifetime,ViewsLifeTimeUniqueUsers';
            var trimDuplicates = 'false';
            var sortList = 'ViewsRecent:descending';
            return $http({
                method: 'GET',
                url: baseUrl + '/_api/search/query?Querytext=%27' + encodeURIComponent(query) + '*%27&selectproperties=%27' + properties + '%27&trimduplicates=%27' + trimDuplicates + '%27&rowlimit=%27' + rowLimit + '%27&startrow=%27' + startRow + '%27&sortlist=%27' + sortList + '%27',
                cache: true
            }).then(function (response) {
                // Mapping each table rows and foreach cell add variabel to object
                return response.data.PrimaryQueryResult.RelevantResults.Table.Rows.map(obj => { obj.Cells.forEach(p => obj[p.Key] = p.Value); delete obj.Cells; return obj });
            });
        }

        var service = {
            getLatest: getLatest,
            getTrending: getTrending
        };

        return service;
    }
})();
(function () {
    angular.module('WizdomMobileModule').factory('noticeboardService', noticeboardService);
    noticeboardService.$inject = ['$window', 'wcmStarterHttpApi', 'contextInfo'];

    function noticeboardService($window, httpApi, contextInfo) {

        var baseUrl = new URL($window.document.referrer).origin; // Necessary to get WizdomAppUrl from document refererrer, since admin settings lives inside iframe

        // CHANNEL SETS
        // Get
        function getChannelSets() {
            return httpApi.get(baseUrl + '/api/wizdom/noticeboard/1.0/channelsets').then(function (response) {
                return response.channelSets.results;
            });
        }

        function getChannelsetChannels(channelsetId) {
            return httpApi.get(baseUrl + '/api/wizdom/noticeboard/1.0/channelsets/' + channelsetId + '/channels').then(function (response) {
                return response.channels.results;
            });
        }

        // VIEWS

        function getViewById(viewId) {
            return httpApi.get(baseUrl + '/api/wizdom/noticeboard/1.0/views/' + viewId);
        }

        function postViewById(viewId, data) {
            return httpApi.post(baseUrl + '/api/wizdom/noticeboard/1.0/views/', data);
        }

        function putViewById(viewId, data) {
            return httpApi.put(baseUrl + '/api/wizdom/noticeboard/1.0/views/' + viewId, data);
        }

        var service = {
            getChannelSets: getChannelSets,
            getChannelsetChannels: getChannelsetChannels,
            getViewById: getViewById,
            postViewById: postViewById,
            putViewById: putViewById
        };

        return service;
    }
})();
(function () {
    angular.module("WizdomMobileModule").factory("notificationService", notificationService);

    
    notificationService.$inject = ["$timeout"];

    function notificationService($timeout) {
        var service = {
            showErrorMessage: showErrorMessage,
            showWarningMessage: showWarningMessage,
            showSuccessMessage: showSuccessMessage,
            showConfirmationDialog: showConfirmationDialog
        };

        return service;

        function showErrorMessage(text, autoClose, canClose) {
            if (angular.isUndefined(autoClose)){autoClose = true;}
            if (angular.isUndefined(canClose)){canClose = true;}
                
            var n = noty({
                text: text,
                layout: 'topCenter',
                type: 'error',
                animation: {
                    open: 'animated flipInX', // Animate.css class names
                    close: 'animated flipOutX' // Animate.css class names
                },
                closeWith: canClose ? ["click"] : []
            });

            if (autoClose)
                $timeout(function(){
                    $.noty.close(n.options.id);
                }, 6000);
        }


        function showWarningMessage(text, autoClose, canClose) {
            if (angular.isUndefined(autoClose)){autoClose = true;}
            if (angular.isUndefined(canClose)){canClose = true;}

                var n = noty({
                    text: text,
                    layout: 'topCenter',
                    type: 'warning',
                    animation: {
                        open: 'animated flipInX', // Animate.css class names
                        close: 'animated flipOutX' // Animate.css class names
                    },
                    closeWith: canClose ? ["click"] : []
                });

                if (autoClose)
                    $timeout(function() {
                        $.noty.close(n.options.id);
                    }, 6000);
            }

                function showSuccessMessage(text, autoClose, canClose) {
                    if (angular.isUndefined(autoClose)) { autoClose = true; }
                    if (angular.isUndefined(canClose)) { canClose = true; }

                    var n = noty({
                        text: text,
                        layout: 'topCenter',
                        type: 'success',
                        animation: {
                            open: 'animated flipInX', // Animate.css class names
                            close: 'animated flipOutX' // Animate.css class names
                        },
                        closeWith: canClose ? ["click"] : []
                    });

                    if (autoClose)
                        $timeout(function(){
                            $.noty.close(n.options.id);
                        }, 6000);
                }

                    function showConfirmationDialog(config) {
                        /// <summary>Shows swcmse dialog with type defined</summary>
                        /// <param name="config.text" type="String">
                        ///     Text that is shown within the dialog
                        /// </param>
                        /// <param name="config.modal" type="Bool">
                        ///     Specefies whether is current dialog a modal
                        /// </param>
                        /// <param name="config.type" type="String">
                        ///     Can be of type: alert, information, error, warning, notification, success
                        /// </param>
                        /// <param name="config.layout" type="String">
                        ///     Indicates where to  show dialog
                        ///     Can be of type: top, topCenter, topLeft, topRight,
                        ///     center, centerRight, centerLeft,
                        ///     bottom, bottomCenter, bottomRight, bottomLeft
                        /// </param>
                        /// <param name="config.successCalback" type="Object">
                        ///     Success callback
                        /// </param>
                        /// <param name="config.cancelCalback" type="Object">
                        ///     Error callback
                        /// </param>
                        var okBtnTxt = (config.okButtonText) ? config.okButtonText : "Ok",
                            cancelBtnTxt = (config.cancelButtonText) ? config.cancelButtonText : "Cancel";
                        var n = noty({
                            text: config.text,
                            type: config.type,
                            dismissQueue: true,
                            layout: config.layout,
                            theme: 'defaultTheme',
                            modal: config.modal || true,
                            buttons: [
                                {
                                    addClass: 'btn btn-primary',
                                    text: okBtnTxt,
                                    onClick: function($noty) {
                                        $noty.close();

                                        if (config.successCalback) {
                                            config.successCalback();
                                        }
                                    }
                                },
                                {
                                    addClass: 'btn btn-danger',
                                    text: cancelBtnTxt,
                                    onClick: function($noty) {
                                        $noty.close();

                                        if (config.cancelCalback) {
                                            config.cancelCalback();
                                        }
                                    }
                                }
                            ]
                        });
                    }
                }
})();
(function () {
    angular.module("WizdomMobileModule").factory("principalsApi", principalsApi);

    principalsApi.$inject = ["wcmStarterHttpApi"];

    function principalsApi(webApi) {
        var wizdomCall = "wizdom://";
        var service = {
            principals: {
                baseUrl: wizdomCall + "api/wizdom/365/principals",
                ensure: function (principal) {
                    return httpApi.post(this.baseUrl + "/ensure", principal);
                },
                searchForPrincipal: function (searchTerm) {
                    return httpApi.get(this.baseUrl + "/searchUsers('" + searchTerm + "')");
                },
                ensure: function (principal) {
                    return httpApi.post(this.baseUrl + "/ensure", principal);
                },
                searchGroups: function (searchTerm) {
                    return httpApi.get(this.baseUrl + "/searchGroups('" + searchTerm + "')");
                },
                searchUsers: function (searchTerm) {
                    return httpApi.get(this.baseUrl + "/searchUsers('" + searchTerm + "')");
                },
                searchUsersAndGroups: function (searchTerm) {
                    return httpApi.get(this.baseUrl + "/searchUsersAndGroups('" + searchTerm + "')");
                },
                current: function () {
                    return httpApi.get(this.baseUrl + "/me");
                }
            },

        };

        return service;
    }
   
})();
(function () {
    angular.module("WizdomMobileModule").factory("pushRegistrationsService", pushRegistrationsService);

    pushRegistrationsService.$inject = ["wcmStarterHttpApi", "$window", "$q", "settingsApi"];

    function pushRegistrationsService(httpApi, $window, $q, settingsApi) {
        var wizdomCall = "wizdom://";
        var service = {
            baseUrl: wizdomCall + "api/wizdom/push",
            updateAllRegistrations: function () {
                return httpApi.post(this.baseUrl + "/UpdateAllRegistrations");
            },
            registerDevice: function (platform, deviceToken) {
                var deferred = $q.defer();
                settingsApi.getSettings('NewsNoticeboard').then(function (response) {
                    if (typeof response !== 'undefined' && response.channelSetId) {
                        deferred.resolve(response);
                    }
                    else {
                        deferred.reject("Error loading settings.");
                    }
                });

                return deferred.promise.then(function (response) {
                    if (platform === 'apple') deviceToken = deviceToken.replace('>', '').replace('<', '').replace(/ /g, '');
                    return httpApi.post("wizdom://api/wizdom/push/RegisterDevice/" + platform + "/" + response.channelSetId, deviceToken);
                });
            },
            unregisterDevice: function (deviceToken) {
                return deferred.promise.then(function (response) {
                    deviceToken = deviceToken.replace('>', '').replace('<', '').replace(/ /g, '');
                    return httpApi.post("wizdom://api/wizdom/push/unregisterDevice", deviceToken);
                });
            },
            getUserPushEvents: function (channelsetId) {
                return httpApi.get(this.baseUrl + "/UserPushEvents/" + channelsetId);
            },

            // int PrincipalID 
            // int ChannelSetID 
            // int ChannelID 
            // int EventType 
            // bool Enabled 

            //[
            //    {
            //     "PrincipalID" : 0, // ignored on server ANY VAL
            //     "ChannelSetID": 1,
            //     "ChannelID"   : 1,
            //     "EventType"   : 0, // 0: item edited, 4: comment created
            //     "Enabled"     : true
            //   }
            //]

            setUserPushEvents: function (channelsetId, events) {
                return httpApi.post(this.baseUrl + "/UserPushEvents/" + channelsetId, events);
            },
            getGlobalPushEventDefaults: function () {
                return httpApi.get(this.baseUrl + "/GlobalPushEventDefaults");
            },
            setGlobalPushEventDefaults: function (defaults) {
                return httpApi.post(this.baseUrl + "/GlobalPushEventDefaults", defaults);
            },
            //users global defualts... fallback
            getUserPushEventDefaults: function () {
                return httpApi.get(this.baseUrl + "/UserPushEventDefaults");
            },
            setUserPushEventDefaults: function (defaults) {
                return httpApi.post(this.baseUrl + "/UserPushEventDefaults", defaults);
            },
            // array af key og value item created..
            getPushEventTypes: function () {
                return httpApi.get(this.baseUrl + "/PushEventTypes");
            }
        };

        $window.pushService = service;
        return service;
    }

})();
(function () {
    angular.module("WizdomMobileModule")
        .factory("sessionStorageService", sessionStorageService);

    sessionStorageService.$inject = ["$window", "$document"];
    function sessionStorageService($window, $document) {
        return {
            setItem: function (key, value) {
                if (angular.isUndefined(value))
                    value = null;
                window.sessionStorage.setItem(getKey(key), value);
            },
            removeItem: function (key) {
                window.sessionStorage.removeItem(getKey(key));
            },
            getItem: function (key) {
                return window.sessionStorage.getItem(getKey(key));
            }
        };
    };

    // helper functions
    function getKey(key) {
        if (key.indexOf("wiz") < 0)
            return "wiz" + key;
        return key;
    };
})();

(function () {
    angular.module("WizdomMobileModule").factory("settingsApi", settingsApi);
    settingsApi.$inject = ["$q", "wcmStarterHttpApi"];
    var settings = {};
    function settingsApi($q, httpApi) {

        var baseUrl = '/api/settings/';
        function getModuleSettings(module) {
            return settings[module] ? $q.when(settings[module]) : httpApi.get(baseUrl + module).then(function (data) {
                settings[module] = data;
                return data;
            });
        }
        function saveModuleSettings(module, moduleSettings) {
            if (settings[module]) {
                settings[module] = moduleSettings; /* Update cached settings */
            }
            return httpApi.post(baseUrl + module, moduleSettings);
        }
        var service = {
            getSettings: getModuleSettings,
            saveSettings: saveModuleSettings
        };
        return service;
    }
})();
(function () {
    angular.module('WizdomMobileModule').value('translations', {
        "da-dk": {
            "Are you sure you want to delete this application?": "Er du sikker på at du vil slette denne applikation?"
        }
    });
})();
(function () {
    angular.module('WizdomMobileModule').factory('userProfile', userProfileService);
    userProfileService.$inject = ['$window', '$http', '$timeout', 'contextInfo', 'wcmStarterHttpApi'];

    function userProfileService($window, $http, $timeout, contextInfo, httpApi) {

        var baseUrl = contextInfo.spHostUrl;

        // Get current user profile properties
        function getMyProperties() {
            httpApi.get('/api/userprofile/getmyproperties').then(function (response) {
                return response;
            });
        }

        // Get trending news based on viewsrecent
        function getTrending(rowLimit, startRow) {
            var query = 'ContentTypeId:0x010100C568DB52D9D0A14D9B2FDCC96666E9F2007948130EC3DB064584E219954237AF3900E1A7B5EB4F6D4536ABA24236F66055A100170370F5340444D1B84CA664EC7FB117*';
            var properties = 'UniqueId,ListID,ListItemId,Title,Path,W365NewsSummaryOWSHTML,PublishingPageContentOWSHTML,PublishingRollupImageOWSIMGE,PublishingImage,LastModifiedTime,owstaxIdW365RelatedTopic,VideoUrl,ContentTypeId,SPWebUrl,SPSiteUrl,W365TopNewsOWSBOOL,ViewsRecent,ViewsRecentUniqueUsers,ViewsLifetime,ViewsLifeTimeUniqueUsers';
            var trimDuplicates = 'false';
            var sortList = 'ViewsRecent:descending';
            return $http({
                method: 'GET',
                url: baseUrl + '/_api/search/query?Querytext=%27' + encodeURIComponent(query) + '*%27&selectproperties=%27' + properties + '%27&trimduplicates=%27' + trimDuplicates + '%27&rowlimit=%27' + rowLimit + '%27&startrow=%27' + startRow + '%27&sortlist=%27' + sortList + '%27',
                cache: true
            }).then(function (response) {
                // Mapping each table rows and foreach cell add variabel to object
                return response.data.PrimaryQueryResult.RelevantResults.Table.Rows.map(obj => { obj.Cells.forEach(p => obj[p.Key] = p.Value); delete obj.Cells; return obj });
            });
        }

        var service = {
            getLatest: getLatest,
            getTrending: getTrending
        };

        return service;
    }
})();
(function () {
    angular.module("WizdomMobileModule").factory("wcmStarterSettingsApi", wcmStarterSettingsApi);

    wcmStarterSettingsApi.$inject = ["$q", "wcmStarterHttpApi", "clientStorageService", "$timeout"];

    var stgs = {}, module = 'WizdomMobileModule';

    function wcmStarterSettingsApi($q, wcmStarterHttpApi, storageService, $timeout) {
        var storage = storageService.local, cacheKey = 'wcmsModuleSgts', expiresInMinutes = 7200; //5 days for caching
        var baseUrl = '/api/wcmStartersettings/';


        function getAppSettings() {
            // If value is cached return it, if not fetch it and cache it when it gets here before handing it over
            return stgs[module] ? $q.when(stgs[module]) : wcmStarterHttpApi.getCached(baseUrl + module).then(function (data) {
                stgs[module] = data;
                return stgs[module];
            });

        }

        function getModuleSettings(getCached) {
            var deferred = $q.defer(), getFromServer = false;
            if (angular.isUndefined(getCached)) { getCached = false; }
            if (getCached) {
                var cachedValue = storage.getItem(cacheKey);
                var stgs = JSON.parse(cachedValue);
                if (stgs) {
                    getLastModifiedTime().then(function (datetime) {
                        var lastCacheReset = new Date(datetime);
                        if ((lastCacheReset.getTime() + (expiresInMinutes * 60000)) > (parseInt(storage.getExpireTime(cacheKey)))) {
                            storage.setItem(cacheKey, null); /*cache as it been reset on the server*/
                        }
                    });
                    $timeout(function () { deferred.resolve(stgs); }, 0);
                } else {
                    getFromServer = true;
                }
            } else {
                getFromServer = true;
            }
            if (getFromServer) {
                getAppSettings().then(function (stg) {
                    if (getCached) {
                        var expiresAt = storage.addMinutesToNow(expiresInMinutes).getTime();
                        storage.setItem(cacheKey, JSON.stringify(stg.moduleSettings), expiresAt);
                    }
                    deferred.resolve(stg.moduleSettings);
                }, function () {
                    var errMsg = "Error. Could not get CCCustomModule settings";
                    deferred.reject(errMsg);
                });
            }
            return deferred.promise;
        }

        function getFromCacheFn() {
            var cachedValue = storage.getItem(cacheKey);
            if (cachedValue) {
                return JSON.parse(cachedValue);
            }
            return null;
        }
        function saveModuleSettings(settings) {
            if (stgs[module]) {
                stgs[module].ModuleSettings = settings; /* Update cached settings */
            }
            wcmStarterHttpApi.resetCache(baseUrl + module);
            return wcmStarterHttpApi.post(baseUrl + module, settings);
        }

        function getLastResetTime() {
            return wcmStarterHttpApi.getCached(baseUrl + module + '/lastreset/');
        }
        function getLastModifiedTime() {
            return wcmStarterHttpApi.getCached(baseUrl + module + '/lastmodified/');
        }

        function initCache() {
            return wcmStarterHttpApi.getCached(baseUrl + module + '/initcache/');
        }

        function getCurrentUser() {
            return wcmStarterHttpApi.getCached(baseUrl + module + '/currentuser/');
        }

        var service = {
            getSettings: getModuleSettings,
            saveSettings: saveModuleSettings,
            getAppSettings: getAppSettings,
            initCache: initCache,
            getCurrentUser: getCurrentUser,
            getFromCache: getFromCacheFn,
        };

        return service;
    }
})();
(function () {

    angular.module("WizdomMobileModule").factory("webApiProxy", webApiProxy);

    webApiProxy.$inject = ["$q", "wcmStarterHttpApi", "contextInfo"];

    function webApiProxy($q, httpApi, contextInfo) {
        var service = {
            cache: {
                baseUrl: "wizdom://api/wizdom/365/cache/",
                getCache: function () {
                    return httpApi.get(this.baseUrl);
                },
                clearCache: function () {
                    return httpApi.get(this.baseUrl + "clear").then((timestamp) => window["Wizdom365Config"]["@timestamp"] = timestamp);
                },
                clearModuleCache: function (module) {
                    return httpApi.get(this.baseUrl + "clear/" + module);
                },
                clearBrowserCache: function () {
                    return httpApi.get(this.baseUrl + "clearBrowserCache");
                }
            },
            sitecollections: {
                baseUrl: "wizdom://api/wizdom/365/sitecollections",
                getSitecollections: function () {
                    return httpApi.get(this.baseUrl);
                },
                getSingleSitecollection: function () {
                    return httpApi.get(this.baseUrl);
                }
            },
            searchPerson: {
                baseUrl: "wizdom://api/wizdom/searchPerson/search",
                search: function (searchTerm, index, numberOfUsers, selectProperties, resultSource, pageIndex, orderProperties) {
                    var url = this.baseUrl + "?queryText=" + encodeURIComponent(searchTerm) + "&index=" + index;
                    //var url = this.baseUrl + "?queryText=" + searchTerm + "&index=" + index;
                    if (numberOfUsers) {
                        url += "&numberOfUsersPerPage=" + numberOfUsers;
                    }
                    if (selectProperties) {
                        angular.forEach(selectProperties, function (property) {
                            url += "&selectProperties=" + property;
                        });
                    }
                    if (orderProperties) {
                        angular.forEach(orderProperties, function (property) {
                            url += "&orderProperties=" + property.property + "|" + property.orderDirection;
                        });
                    }
                    if (resultSource) {
                        url += "&resultSource=" + resultSource;
                    }
                    if (pageIndex) {
                        url += "&pageindex=" + pageIndex;
                    }
                    return httpApi.get(url);
                }
            },
            terms: {
                baseUrl: "wizdom://api/wizdom/365/terms",
                batchGroup: "terms",
                getAllTermsById: function (termId) {
                    return httpApi.get(this.baseUrl + "?termId=" + termId);
                },
                getAllTermsWithIDsById: function (termId) {
                    return httpApi.get(this.baseUrl + "/withids?termId=" + termId);
                },
                getAllTermsWithIDsByFieldName: function (fieldName) {
                    return httpApi.get(this.baseUrl + "/withFieldName?fieldName=" + fieldName);
                },
                getAllTermsWithChildrenById: function (termId) {
                    return httpApi.get(this.baseUrl + "/nested?termId=" + termId);
                },
                getAllTermsWithChildrenByFieldName: function (fieldName) {
                    return httpApi.get(this.baseUrl + "/nested?fieldName=" + fieldName);
                },
                getAllTermSets: function (sourceurl) {
                    return httpApi.get(this.baseUrl + "/AllTermSets" + (angular.isDefined(sourceurl) ? "?sourceurl=" + sourceurl : ""));
                },
                getAllTermsWithPagingById: function (termId, pageSize, pageNo) {
                    return httpApi.get(this.baseUrl + "/withpaging?termId=" + termId + "&pageSize=" + pageSize + "&pageNo=" + pageNo);
                },
                searchTerms: function (termId, searchText) {
                    return httpApi.get(this.baseUrl + "/search?termId=" + termId + "&searchText=" + searchText);
                },
                getTermsCount: function (termId) {
                    return httpApi.get(this.baseUrl + "/count?termId=" + termId);
                }
            },
            principals: {
                baseUrl: "wizdom://api/wizdom/365/principals",
                ensure: function (principal) {
                    return httpApi.post(this.baseUrl + "/ensure", principal);
                },
                searchGroups: function (searchTerm, includeWizdomGroups) {
                    includeWizdomGroups = includeWizdomGroups || false;
                    return httpApi.get(this.baseUrl + "/searchGroups?searchTerm=" + encodeURIComponent(searchTerm) + "&includeWizdomGroups=" + includeWizdomGroups);
                },
                searchUsers: function (searchTerm) {
                    return httpApi.get(this.baseUrl + "/searchUsers('" + searchTerm + "')/"); // Traling '/' added to allow "." in searchTerm parameter
                },
                searchUsersAndGroups: function (searchTerm, includeWizdomGroups) {
                    includeWizdomGroups = includeWizdomGroups || false;
                    return httpApi.get(this.baseUrl + "/searchUsersAndGroups('" + searchTerm + "'," + includeWizdomGroups + ")/"); // Traling '/' added to allow "." in searchTerm parameter
                },
                current: function () {
                    return httpApi.get(this.baseUrl + "/me");
                },
                currentUserGroups: function () {
                    return httpApi.get(this.baseUrl + "/me/groups");
                },
                forgetUser: function (userToForget) {
                    return httpApi.post(this.baseUrl + "/forgetUser", userToForget);
                },
                forgetUsers: function (usersToForget) {
                    return httpApi.post(this.baseUrl + "/forgetUsers", usersToForget);
                }
            },
            social: {
                baseUrl: "wizdom://api/wizdom/365/social/",
                addMentio: function (mentioList) {
                    return httpApi.post(this.baseUrl + "mentio", mentioList);
                },
                getFullComments: function (ids) {
                    return httpApi.get(this.baseUrl + "comments/" + ids);
                },
                deleteComment: function (id) {
                    return httpApi.delete(this.baseUrl + "comments/" + id);
                },
                likeItem: function (likeDto) {
                    return httpApi.post(this.baseUrl + "like", likeDto);
                },
                saveComment: function (comment) {
                    return httpApi.post(this.baseUrl + "comments", comment);
                },
                getSocialOverview: function (id, type) {
                    return httpApi.get(this.baseUrl + "overview/" + id + "/" + type);
                },
                getCommentsTree: function (itemId, targetId, targetType, targetLastCommentId, allowedlevel) {
                    return httpApi.get(this.baseUrl + "commentstree?itemId=" + itemId + "&targetId=" + targetId + "&type=" + targetType + "&lastId=" + targetLastCommentId + "&allowedlevel=" + allowedlevel);
                }
            },
            translations: {
                baseUrl: "wizdom://api/wizdom/365/translations",
                get: function () {
                    return httpApi.get(this.baseUrl);
                },
                setTranslationValue: function (languageCode, key, value) {
                    var translation = {
                        key: key,
                        value: value
                    };
                    return httpApi.put(this.baseUrl + "/" + languageCode, translation);
                },
                uploadTranslationFile: function (languageCode, file) {
                    return httpApi.post(this.baseUrl + "/" + languageCode + "/file", file);
                },
                getTranslation: function (key) {
                    return httpApi.get(this.baseUrl + "/translate/" + key);
                },
                getMyLocale: function () {
                    return httpApi.get(this.baseUrl + "/getmylocale");
                }
            }
        };

        return service;
    }
})();
/*
 * angular-ui-bootstrap
 * http://angular-ui.github.io/bootstrap/

 * Version: 0.12.0 - 2014-11-16
 * License: MIT
 */
angular.module("ui.bootstrap", ["ui.bootstrap.tpls", "ui.bootstrap.transition", "ui.bootstrap.collapse", "ui.bootstrap.accordion", "ui.bootstrap.alert", "ui.bootstrap.bindHtml", "ui.bootstrap.buttons", "ui.bootstrap.carousel", "ui.bootstrap.dateparser", "ui.bootstrap.position", "ui.bootstrap.datepicker", "ui.bootstrap.dropdown", "ui.bootstrap.modal", "ui.bootstrap.pagination", "ui.bootstrap.tooltip", "ui.bootstrap.popover", "ui.bootstrap.progressbar", "ui.bootstrap.rating", "ui.bootstrap.tabs", "ui.bootstrap.timepicker", "ui.bootstrap.typeahead"]);
angular.module("ui.bootstrap.tpls", ["template/accordion/accordion-group.html", "template/accordion/accordion.html", "template/alert/alert.html", "template/carousel/carousel.html", "template/carousel/slide.html", "template/datepicker/datepicker.html", "template/datepicker/day.html", "template/datepicker/month.html", "template/datepicker/popup.html", "template/datepicker/year.html", "template/modal/backdrop.html", "template/modal/window.html", "template/pagination/pager.html", "template/pagination/pagination.html", "template/tooltip/tooltip-html-unsafe-popup.html", "template/tooltip/tooltip-popup.html", "template/popover/popover.html", "template/progressbar/bar.html", "template/progressbar/progress.html", "template/progressbar/progressbar.html", "template/rating/rating.html", "template/tabs/tab.html", "template/tabs/tabset.html", "template/timepicker/timepicker.html", "template/typeahead/typeahead-match.html", "template/typeahead/typeahead-popup.html"]);
angular.module('ui.bootstrap.transition', [])

/**
 * $transition service provides a consistent interface to trigger CSS 3 transitions and to be informed when they complete.
 * @param  {DOMElement} element  The DOMElement that will be animated.
 * @param  {string|object|function} trigger  The thing that will cause the transition to start:
 *   - As a string, it represents the css class to be added to the element.
 *   - As an object, it represents a hash of style attributes to be applied to the element.
 *   - As a function, it represents a function to be called that will cause the transition to occur.
 * @return {Promise}  A promise that is resolved when the transition finishes.
 */
.factory('$transition', ['$q', '$timeout', '$rootScope', function ($q, $timeout, $rootScope) {

    var $transition = function (element, trigger, options) {
        options = options || {};
        var deferred = $q.defer();
        var endEventName = $transition[options.animation ? 'animationEndEventName' : 'transitionEndEventName'];

        var transitionEndHandler = function (event) {
            $rootScope.$apply(function () {
                element.unbind(endEventName, transitionEndHandler);
                deferred.resolve(element);
            });
        };

        if (endEventName) {
            element.bind(endEventName, transitionEndHandler);
        }

        // Wrap in a timeout to allow the browser time to update the DOM before the transition is to occur
        $timeout(function () {
            if (angular.isString(trigger)) {
                element.addClass(trigger);
            } else if (angular.isFunction(trigger)) {
                trigger(element);
            } else if (angular.isObject(trigger)) {
                element.css(trigger);
            }
            //If browser does not support transitions, instantly resolve
            if (!endEventName) {
                deferred.resolve(element);
            }
        });

        // Add our custom cancel function to the promise that is returned
        // We can call this if we are about to run a new transition, which we know will prevent this transition from ending,
        // i.e. it will therefore never raise a transitionEnd event for that transition
        deferred.promise.cancel = function () {
            if (endEventName) {
                element.unbind(endEventName, transitionEndHandler);
            }
            deferred.reject('Transition cancelled');
        };

        return deferred.promise;
    };

    // Work out the name of the transitionEnd event
    var transElement = document.createElement('trans');
    var transitionEndEventNames = {
        'WebkitTransition': 'webkitTransitionEnd',
        'MozTransition': 'transitionend',
        'OTransition': 'oTransitionEnd',
        'transition': 'transitionend'
    };
    var animationEndEventNames = {
        'WebkitTransition': 'webkitAnimationEnd',
        'MozTransition': 'animationend',
        'OTransition': 'oAnimationEnd',
        'transition': 'animationend'
    };
    function findEndEventName(endEventNames) {
        for (var name in endEventNames) {
            if (transElement.style[name] !== undefined) {
                return endEventNames[name];
            }
        }
    }
    $transition.transitionEndEventName = findEndEventName(transitionEndEventNames);
    $transition.animationEndEventName = findEndEventName(animationEndEventNames);
    return $transition;
}]);

angular.module('ui.bootstrap.collapse', ['ui.bootstrap.transition'])

  .directive('collapse', ['$transition', function ($transition) {

      return {
          link: function (scope, element, attrs) {

              var initialAnimSkip = true;
              var currentTransition;

              function doTransition(change) {
                  var newTransition = $transition(element, change);
                  if (currentTransition) {
                      currentTransition.cancel();
                  }
                  currentTransition = newTransition;
                  newTransition.then(newTransitionDone, newTransitionDone);
                  return newTransition;

                  function newTransitionDone() {
                      // Make sure it's this transition, otherwise, leave it alone.
                      if (currentTransition === newTransition) {
                          currentTransition = undefined;
                      }
                  }
              }

              function expand() {
                  if (initialAnimSkip) {
                      initialAnimSkip = false;
                      expandDone();
                  } else {
                      element.removeClass('collapse').addClass('collapsing');
                      doTransition({ height: element[0].scrollHeight + 'px' }).then(expandDone);
                  }
              }

              function expandDone() {
                  element.removeClass('collapsing');
                  element.addClass('collapse in');
                  element.css({ height: 'auto' });
              }

              function collapse() {
                  if (initialAnimSkip) {
                      initialAnimSkip = false;
                      collapseDone();
                      element.css({ height: 0 });
                  } else {
                      // CSS transitions don't work with height: auto, so we have to manually change the height to a specific value
                      element.css({ height: element[0].scrollHeight + 'px' });
                      //trigger reflow so a browser realizes that height was updated from auto to a specific value
                      var x = element[0].offsetWidth;

                      element.removeClass('collapse in').addClass('collapsing');

                      doTransition({ height: 0 }).then(collapseDone);
                  }
              }

              function collapseDone() {
                  element.removeClass('collapsing');
                  element.addClass('collapse');
              }

              scope.$watch(attrs.collapse, function (shouldCollapse) {
                  if (shouldCollapse) {
                      collapse();
                  } else {
                      expand();
                  }
              });
          }
      };
  }]);

angular.module('ui.bootstrap.accordion', ['ui.bootstrap.collapse'])

.constant('accordionConfig', {
    closeOthers: true
})

.controller('AccordionController', ['$scope', '$attrs', 'accordionConfig', function ($scope, $attrs, accordionConfig) {

    // This array keeps track of the accordion groups
    this.groups = [];

    // Ensure that all the groups in this accordion are closed, unless close-others explicitly says not to
    this.closeOthers = function (openGroup) {
        var closeOthers = angular.isDefined($attrs.closeOthers) ? $scope.$eval($attrs.closeOthers) : accordionConfig.closeOthers;
        if (closeOthers) {
            angular.forEach(this.groups, function (group) {
                if (group !== openGroup) {
                    group.isOpen = false;
                }
            });
        }
    };

    // This is called from the accordion-group directive to add itself to the accordion
    this.addGroup = function (groupScope) {
        var that = this;
        this.groups.push(groupScope);

        groupScope.$on('$destroy', function (event) {
            that.removeGroup(groupScope);
        });
    };

    // This is called from the accordion-group directive when to remove itself
    this.removeGroup = function (group) {
        var index = this.groups.indexOf(group);
        if (index !== -1) {
            this.groups.splice(index, 1);
        }
    };

}])

// The accordion directive simply sets up the directive controller
// and adds an accordion CSS class to itself element.
.directive('accordion', function () {
    return {
        restrict: 'EA',
        controller: 'AccordionController',
        transclude: true,
        replace: false,
        templateUrl: 'template/accordion/accordion.html'
    };
})

// The accordion-group directive indicates a block of html that will expand and collapse in an accordion
.directive('accordionGroup', function () {
    return {
        require: '^accordion',         // We need this directive to be inside an accordion
        restrict: 'EA',
        transclude: true,              // It transcludes the contents of the directive into the template
        replace: true,                // The element containing the directive will be replaced with the template
        templateUrl: 'template/accordion/accordion-group.html',
        scope: {
            heading: '@',               // Interpolate the heading attribute onto this scope
            isOpen: '=?',
            isDisabled: '=?'
        },
        controller: function () {
            this.setHeading = function (element) {
                this.heading = element;
            };
        },
        link: function (scope, element, attrs, accordionCtrl) {
            accordionCtrl.addGroup(scope);

            scope.$watch('isOpen', function (value) {
                if (value) {
                    accordionCtrl.closeOthers(scope);
                }
            });

            scope.toggleOpen = function () {
                if (!scope.isDisabled) {
                    scope.isOpen = !scope.isOpen;
                }
            };
        }
    };
})

// Use accordion-heading below an accordion-group to provide a heading containing HTML
// <accordion-group>
//   <accordion-heading>Heading containing HTML - <img src="..."></accordion-heading>
// </accordion-group>
.directive('accordionHeading', function () {
    return {
        restrict: 'EA',
        transclude: true,   // Grab the contents to be used as the heading
        template: '',       // In effect remove this element!
        replace: true,
        require: '^accordionGroup',
        link: function (scope, element, attr, accordionGroupCtrl, transclude) {
            // Pass the heading to the accordion-group controller
            // so that it can be transcluded into the right place in the template
            // [The second parameter to transclude causes the elements to be cloned so that they work in ng-repeat]
            accordionGroupCtrl.setHeading(transclude(scope, function () { }));
        }
    };
})

// Use in the accordion-group template to indicate where you want the heading to be transcluded
// You must provide the property on the accordion-group controller that will hold the transcluded element
// <div class="accordion-group">
//   <div class="accordion-heading" ><a ... accordion-transclude="heading">...</a></div>
//   ...
// </div>
.directive('accordionTransclude', function () {
    return {
        require: '^accordionGroup',
        link: function (scope, element, attr, controller) {
            scope.$watch(function () { return controller[attr.accordionTransclude]; }, function (heading) {
                if (heading) {
                    element.html('');
                    element.append(heading);
                }
            });
        }
    };
});

angular.module('ui.bootstrap.alert', [])

.controller('AlertController', ['$scope', '$attrs', function ($scope, $attrs) {
    $scope.closeable = 'close' in $attrs;
    this.close = $scope.close;
}])

.directive('alert', function () {
    return {
        restrict: 'EA',
        controller: 'AlertController',
        templateUrl: 'template/alert/alert.html',
        transclude: true,
        replace: true,
        scope: {
            type: '@',
            close: '&'
        }
    };
})

.directive('dismissOnTimeout', ['$timeout', function ($timeout) {
    return {
        require: 'alert',
        link: function (scope, element, attrs, alertCtrl) {
            $timeout(function () {
                alertCtrl.close();
            }, parseInt(attrs.dismissOnTimeout, 10));
        }
    };
}]);

angular.module('ui.bootstrap.bindHtml', [])

  .directive('bindHtmlUnsafe', function () {
      return function (scope, element, attr) {
          element.addClass('ng-binding').data('$binding', attr.bindHtmlUnsafe);
          scope.$watch(attr.bindHtmlUnsafe, function bindHtmlUnsafeWatchAction(value) {
              element.html(value || '');
          });
      };
  });
angular.module('ui.bootstrap.buttons', [])

.constant('buttonConfig', {
    activeClass: 'active',
    toggleEvent: 'click'
})

.controller('ButtonsController', ['buttonConfig', function (buttonConfig) {
    this.activeClass = buttonConfig.activeClass || 'active';
    this.toggleEvent = buttonConfig.toggleEvent || 'click';
}])

.directive('btnRadio', function () {
    return {
        require: ['btnRadio', 'ngModel'],
        controller: 'ButtonsController',
        link: function (scope, element, attrs, ctrls) {
            var buttonsCtrl = ctrls[0], ngModelCtrl = ctrls[1];

            //model -> UI
            ngModelCtrl.$render = function () {
                element.toggleClass(buttonsCtrl.activeClass, angular.equals(ngModelCtrl.$modelValue, scope.$eval(attrs.btnRadio)));
            };

            //ui->model
            element.bind(buttonsCtrl.toggleEvent, function () {
                var isActive = element.hasClass(buttonsCtrl.activeClass);

                if (!isActive || angular.isDefined(attrs.uncheckable)) {
                    scope.$apply(function () {
                        ngModelCtrl.$setViewValue(isActive ? null : scope.$eval(attrs.btnRadio));
                        ngModelCtrl.$render();
                    });
                }
            });
        }
    };
})

.directive('btnCheckbox', function () {
    return {
        require: ['btnCheckbox', 'ngModel'],
        controller: 'ButtonsController',
        link: function (scope, element, attrs, ctrls) {
            var buttonsCtrl = ctrls[0], ngModelCtrl = ctrls[1];

            function getTrueValue() {
                return getCheckboxValue(attrs.btnCheckboxTrue, true);
            }

            function getFalseValue() {
                return getCheckboxValue(attrs.btnCheckboxFalse, false);
            }

            function getCheckboxValue(attributeValue, defaultValue) {
                var val = scope.$eval(attributeValue);
                return angular.isDefined(val) ? val : defaultValue;
            }

            //model -> UI
            ngModelCtrl.$render = function () {
                element.toggleClass(buttonsCtrl.activeClass, angular.equals(ngModelCtrl.$modelValue, getTrueValue()));
            };

            //ui->model
            element.bind(buttonsCtrl.toggleEvent, function () {
                scope.$apply(function () {
                    ngModelCtrl.$setViewValue(element.hasClass(buttonsCtrl.activeClass) ? getFalseValue() : getTrueValue());
                    ngModelCtrl.$render();
                });
            });
        }
    };
});

/**
* @ngdoc overview
* @name ui.bootstrap.carousel
*
* @description
* AngularJS version of an image carousel.
*
*/
angular.module('ui.bootstrap.carousel', ['ui.bootstrap.transition'])
.controller('CarouselController', ['$scope', '$timeout', '$interval', '$transition', function ($scope, $timeout, $interval, $transition) {
    var self = this,
      slides = self.slides = $scope.slides = [],
      currentIndex = -1,
      currentInterval, isPlaying;
    self.currentSlide = null;

    var destroyed = false;
    /* direction: "prev" or "next" */
    self.select = $scope.select = function (nextSlide, direction) {
        var nextIndex = slides.indexOf(nextSlide);
        //Decide direction if it's not given
        if (direction === undefined) {
            direction = nextIndex > currentIndex ? 'next' : 'prev';
        }
        if (nextSlide && nextSlide !== self.currentSlide) {
            if ($scope.$currentTransition) {
                $scope.$currentTransition.cancel();
                //Timeout so ng-class in template has time to fix classes for finished slide
                $timeout(goNext);
            } else {
                goNext();
            }
        }
        function goNext() {
            // Scope has been destroyed, stop here.
            if (destroyed) { return; }
            //If we have a slide to transition from and we have a transition type and we're allowed, go
            if (self.currentSlide && angular.isString(direction) && !$scope.noTransition && nextSlide.$element) {
                //We shouldn't do class manip in here, but it's the same weird thing bootstrap does. need to fix sometime
                nextSlide.$element.addClass(direction);
                var reflow = nextSlide.$element[0].offsetWidth; //force reflow

                //Set all other slides to stop doing their stuff for the new transition
                angular.forEach(slides, function (slide) {
                    angular.extend(slide, { direction: '', entering: false, leaving: false, active: false });
                });
                angular.extend(nextSlide, { direction: direction, active: true, entering: true });
                angular.extend(self.currentSlide || {}, { direction: direction, leaving: true });

                $scope.$currentTransition = $transition(nextSlide.$element, {});
                //We have to create new pointers inside a closure since next & current will change
                (function (next, current) {
                    $scope.$currentTransition.then(
                      function () { transitionDone(next, current); },
                      function () { transitionDone(next, current); }
                    );
                }(nextSlide, self.currentSlide));
            } else {
                transitionDone(nextSlide, self.currentSlide);
            }
            self.currentSlide = nextSlide;
            currentIndex = nextIndex;
            //every time you change slides, reset the timer
            restartTimer();
        }
        function transitionDone(next, current) {
            angular.extend(next, { direction: '', active: true, leaving: false, entering: false });
            angular.extend(current || {}, { direction: '', active: false, leaving: false, entering: false });
            $scope.$currentTransition = null;
        }
    };
    $scope.$on('$destroy', function () {
        destroyed = true;
    });

    /* Allow outside people to call indexOf on slides array */
    self.indexOfSlide = function (slide) {
        return slides.indexOf(slide);
    };

    $scope.next = function () {
        var newIndex = (currentIndex + 1) % slides.length;

        //Prevent this user-triggered transition from occurring if there is already one in progress
        if (!$scope.$currentTransition) {
            return self.select(slides[newIndex], 'next');
        }
    };

    $scope.prev = function () {
        var newIndex = currentIndex - 1 < 0 ? slides.length - 1 : currentIndex - 1;

        //Prevent this user-triggered transition from occurring if there is already one in progress
        if (!$scope.$currentTransition) {
            return self.select(slides[newIndex], 'prev');
        }
    };

    $scope.isActive = function (slide) {
        return self.currentSlide === slide;
    };

    $scope.$watch('interval', restartTimer);
    $scope.$on('$destroy', resetTimer);

    function restartTimer() {
        resetTimer();
        var interval = +$scope.interval;
        if (!isNaN(interval) && interval > 0) {
            currentInterval = $interval(timerFn, interval);
        }
    }

    function resetTimer() {
        if (currentInterval) {
            $interval.cancel(currentInterval);
            currentInterval = null;
        }
    }

    function timerFn() {
        var interval = +$scope.interval;
        if (isPlaying && !isNaN(interval) && interval > 0) {
            $scope.next();
        } else {
            $scope.pause();
        }
    }

    $scope.play = function () {
        if (!isPlaying) {
            isPlaying = true;
            restartTimer();
        }
    };
    $scope.pause = function () {
        if (!$scope.noPause) {
            isPlaying = false;
            resetTimer();
        }
    };

    self.addSlide = function (slide, element) {
        slide.$element = element;
        slides.push(slide);
        //if this is the first slide or the slide is set to active, select it
        if (slides.length === 1 || slide.active) {
            self.select(slides[slides.length - 1]);
            if (slides.length == 1) {
                $scope.play();
            }
        } else {
            slide.active = false;
        }
    };

    self.removeSlide = function (slide) {
        //get the index of the slide inside the carousel
        var index = slides.indexOf(slide);
        slides.splice(index, 1);
        if (slides.length > 0 && slide.active) {
            if (index >= slides.length) {
                self.select(slides[index - 1]);
            } else {
                self.select(slides[index]);
            }
        } else if (currentIndex > index) {
            currentIndex--;
        }
    };

}])

/**
 * @ngdoc directive
 * @name ui.bootstrap.carousel.directive:carousel
 * @restrict EA
 *
 * @description
 * Carousel is the outer container for a set of image 'slides' to showcase.
 *
 * @param {number=} interval The time, in milliseconds, that it will take the carousel to go to the next slide.
 * @param {boolean=} noTransition Whether to disable transitions on the carousel.
 * @param {boolean=} noPause Whether to disable pausing on the carousel (by default, the carousel interval pauses on hover).
 *
 * @example
<example module="ui.bootstrap">
  <file name="index.html">
    <carousel>
      <slide>
        <img src="http://placekitten.com/150/150" style="margin:auto;">
        <div class="carousel-caption">
          <p>Beautiful!</p>
        </div>
      </slide>
      <slide>
        <img src="http://placekitten.com/100/150" style="margin:auto;">
        <div class="carousel-caption">
          <p>D'aww!</p>
        </div>
      </slide>
    </carousel>
  </file>
  <file name="demo.css">
    .carousel-indicators {
      top: auto;
      bottom: 15px;
    }
  </file>
</example>
 */
.directive('carousel', [function () {
    return {
        restrict: 'EA',
        transclude: true,
        replace: true,
        controller: 'CarouselController',
        require: 'carousel',
        templateUrl: 'template/carousel/carousel.html',
        scope: {
            interval: '=',
            noTransition: '=',
            noPause: '='
        }
    };
}])

/**
 * @ngdoc directive
 * @name ui.bootstrap.carousel.directive:slide
 * @restrict EA
 *
 * @description
 * Creates a slide inside a {@link ui.bootstrap.carousel.directive:carousel carousel}.  Must be placed as a child of a carousel element.
 *
 * @param {boolean=} active Model binding, whether or not this slide is currently active.
 *
 * @example
<example module="ui.bootstrap">
  <file name="index.html">
<div ng-controller="CarouselDemoCtrl">
  <carousel>
    <slide ng-repeat="slide in slides" active="slide.active">
      <img ng-src="{{slide.image}}" style="margin:auto;">
      <div class="carousel-caption">
        <h4>Slide {{$index}}</h4>
        <p>{{slide.text}}</p>
      </div>
    </slide>
  </carousel>
  Interval, in milliseconds: <input type="number" ng-model="myInterval">
  <br />Enter a negative number to stop the interval.
</div>
  </file>
  <file name="script.js">
function CarouselDemoCtrl($scope) {
  $scope.myInterval = 5000;
}
  </file>
  <file name="demo.css">
    .carousel-indicators {
      top: auto;
      bottom: 15px;
    }
  </file>
</example>
*/

.directive('slide', function () {
    return {
        require: '^carousel',
        restrict: 'EA',
        transclude: true,
        replace: true,
        templateUrl: 'template/carousel/slide.html',
        scope: {
            active: '=?'
        },
        link: function (scope, element, attrs, carouselCtrl) {
            carouselCtrl.addSlide(scope, element);
            //when the scope is destroyed then remove the slide from the current slides array
            scope.$on('$destroy', function () {
                carouselCtrl.removeSlide(scope);
            });

            scope.$watch('active', function (active) {
                if (active) {
                    carouselCtrl.select(scope);
                }
            });
        }
    };
});

angular.module('ui.bootstrap.dateparser', [])

.service('dateParser', ['$locale', 'orderByFilter', function ($locale, orderByFilter) {

    this.parsers = {};

    var formatCodeToRegex = {
        'yyyy': {
            regex: '\\d{4}',
            apply: function (value) { this.year = +value; }
        },
        'yy': {
            regex: '\\d{2}',
            apply: function (value) { this.year = +value + 2000; }
        },
        'y': {
            regex: '\\d{1,4}',
            apply: function (value) { this.year = +value; }
        },
        'MMMM': {
            regex: $locale.DATETIME_FORMATS.MONTH.join('|'),
            apply: function (value) { this.month = $locale.DATETIME_FORMATS.MONTH.indexOf(value); }
        },
        'MMM': {
            regex: $locale.DATETIME_FORMATS.SHORTMONTH.join('|'),
            apply: function (value) { this.month = $locale.DATETIME_FORMATS.SHORTMONTH.indexOf(value); }
        },
        'MM': {
            regex: '0[1-9]|1[0-2]',
            apply: function (value) { this.month = value - 1; }
        },
        'M': {
            regex: '[1-9]|1[0-2]',
            apply: function (value) { this.month = value - 1; }
        },
        'dd': {
            regex: '[0-2][0-9]{1}|3[0-1]{1}',
            apply: function (value) { this.date = +value; }
        },
        'd': {
            regex: '[1-2]?[0-9]{1}|3[0-1]{1}',
            apply: function (value) { this.date = +value; }
        },
        'EEEE': {
            regex: $locale.DATETIME_FORMATS.DAY.join('|')
        },
        'EEE': {
            regex: $locale.DATETIME_FORMATS.SHORTDAY.join('|')
        }
    };

    function createParser(format) {
        var map = [], regex = format.split('');

        angular.forEach(formatCodeToRegex, function (data, code) {
            var index = format.indexOf(code);

            if (index > -1) {
                format = format.split('');

                regex[index] = '(' + data.regex + ')';
                format[index] = '$'; // Custom symbol to define consumed part of format
                for (var i = index + 1, n = index + code.length; i < n; i++) {
                    regex[i] = '';
                    format[i] = '$';
                }
                format = format.join('');

                map.push({ index: index, apply: data.apply });
            }
        });

        return {
            regex: new RegExp('^' + regex.join('') + '$'),
            map: orderByFilter(map, 'index')
        };
    }

    this.parse = function (input, format) {
        if (!angular.isString(input) || !format) {
            return input;
        }

        format = $locale.DATETIME_FORMATS[format] || format;

        if (!this.parsers[format]) {
            this.parsers[format] = createParser(format);
        }

        var parser = this.parsers[format],
            regex = parser.regex,
            map = parser.map,
            results = input.match(regex);

        if (results && results.length) {
            var fields = { year: 1900, month: 0, date: 1, hours: 0 }, dt;

            for (var i = 1, n = results.length; i < n; i++) {
                var mapper = map[i - 1];
                if (mapper.apply) {
                    mapper.apply.call(fields, results[i]);
                }
            }

            if (isValid(fields.year, fields.month, fields.date)) {
                dt = new Date(fields.year, fields.month, fields.date, fields.hours);
            }

            return dt;
        }
    };

    // Check if date is valid for specific month (and year for February).
    // Month: 0 = Jan, 1 = Feb, etc
    function isValid(year, month, date) {
        if (month === 1 && date > 28) {
            return date === 29 && ((year % 4 === 0 && year % 100 !== 0) || year % 400 === 0);
        }

        if (month === 3 || month === 5 || month === 8 || month === 10) {
            return date < 31;
        }

        return true;
    }
}]);

angular.module('ui.bootstrap.position', [])

/**
 * A set of utility methods that can be use to retrieve position of DOM elements.
 * It is meant to be used where we need to absolute-position DOM elements in
 * relation to other, existing elements (this is the case for tooltips, popovers,
 * typeahead suggestions etc.).
 */
  .factory('$position', ['$document', '$window', function ($document, $window) {

      function getStyle(el, cssprop) {
          if (el.currentStyle) { //IE
              return el.currentStyle[cssprop];
          } else if ($window.getComputedStyle) {
              return $window.getComputedStyle(el)[cssprop];
          }
          // finally try and get inline style
          return el.style[cssprop];
      }

      /**
       * Checks if a given element is statically positioned
       * @param element - raw DOM element
       */
      function isStaticPositioned(element) {
          return (getStyle(element, 'position') || 'static') === 'static';
      }

      /**
       * returns the closest, non-statically positioned parentOffset of a given element
       * @param element
       */
      var parentOffsetEl = function (element) {
          var docDomEl = $document[0];
          var offsetParent = element.offsetParent || docDomEl;
          while (offsetParent && offsetParent !== docDomEl && isStaticPositioned(offsetParent)) {
              offsetParent = offsetParent.offsetParent;
          }
          return offsetParent || docDomEl;
      };

      return {
          /**
           * Provides read-only equivalent of jQuery's position function:
           * http://api.jquery.com/position/
           */
          position: function (element) {
              var elBCR = this.offset(element);
              var offsetParentBCR = { top: 0, left: 0 };
              var offsetParentEl = parentOffsetEl(element[0]);
              if (offsetParentEl != $document[0]) {
                  offsetParentBCR = this.offset(angular.element(offsetParentEl));
                  offsetParentBCR.top += offsetParentEl.clientTop - offsetParentEl.scrollTop;
                  offsetParentBCR.left += offsetParentEl.clientLeft - offsetParentEl.scrollLeft;
              }

              var boundingClientRect = element[0].getBoundingClientRect();
              return {
                  width: boundingClientRect.width || element.prop('offsetWidth'),
                  height: boundingClientRect.height || element.prop('offsetHeight'),
                  top: elBCR.top - offsetParentBCR.top,
                  left: elBCR.left - offsetParentBCR.left
              };
          },

          /**
           * Provides read-only equivalent of jQuery's offset function:
           * http://api.jquery.com/offset/
           */
          offset: function (element) {
              var boundingClientRect = element[0].getBoundingClientRect();
              return {
                  width: boundingClientRect.width || element.prop('offsetWidth'),
                  height: boundingClientRect.height || element.prop('offsetHeight'),
                  top: boundingClientRect.top + ($window.pageYOffset || $document[0].documentElement.scrollTop),
                  left: boundingClientRect.left + ($window.pageXOffset || $document[0].documentElement.scrollLeft)
              };
          },

          /**
           * Provides coordinates for the targetEl in relation to hostEl
           */
          positionElements: function (hostEl, targetEl, positionStr, appendToBody) {

              var positionStrParts = positionStr.split('-');
              var pos0 = positionStrParts[0], pos1 = positionStrParts[1] || 'center';

              var hostElPos,
                targetElWidth,
                targetElHeight,
                targetElPos;

              hostElPos = appendToBody ? this.offset(hostEl) : this.position(hostEl);

              targetElWidth = targetEl.prop('offsetWidth');
              targetElHeight = targetEl.prop('offsetHeight');

              var shiftWidth = {
                  center: function () {
                      return hostElPos.left + hostElPos.width / 2 - targetElWidth / 2;
                  },
                  left: function () {
                      return hostElPos.left;
                  },
                  right: function () {
                      return hostElPos.left + hostElPos.width;
                  }
              };

              var shiftHeight = {
                  center: function () {
                      return hostElPos.top + hostElPos.height / 2 - targetElHeight / 2;
                  },
                  top: function () {
                      return hostElPos.top;
                  },
                  bottom: function () {
                      return hostElPos.top + hostElPos.height;
                  }
              };

              switch (pos0) {
                  case 'right':
                      targetElPos = {
                          top: shiftHeight[pos1](),
                          left: shiftWidth[pos0]()
                      };
                      break;
                  case 'left':
                      targetElPos = {
                          top: shiftHeight[pos1](),
                          left: hostElPos.left - targetElWidth
                      };
                      break;
                  case 'bottom':
                      targetElPos = {
                          top: shiftHeight[pos0](),
                          left: shiftWidth[pos1]()
                      };
                      break;
                  default:
                      targetElPos = {
                          top: hostElPos.top - targetElHeight,
                          left: shiftWidth[pos1]()
                      };
                      break;
              }

              return targetElPos;
          }
      };
  }]);

angular.module('ui.bootstrap.datepicker', ['ui.bootstrap.dateparser', 'ui.bootstrap.position'])

.constant('datepickerConfig', {
    formatDay: 'dd',
    formatMonth: 'MMMM',
    formatYear: 'yyyy',
    formatDayHeader: 'EEE',
    formatDayTitle: 'MMMM yyyy',
    formatMonthTitle: 'yyyy',
    datepickerMode: 'day',
    minMode: 'day',
    maxMode: 'year',
    showWeeks: true,
    startingDay: 0,
    yearRange: 20,
    minDate: null,
    maxDate: null
})

.controller('DatepickerController', ['$scope', '$attrs', '$parse', '$interpolate', '$timeout', '$log', 'dateFilter', 'datepickerConfig', function ($scope, $attrs, $parse, $interpolate, $timeout, $log, dateFilter, datepickerConfig) {
    var self = this,
        ngModelCtrl = { $setViewValue: angular.noop }; // nullModelCtrl;

    // Modes chain
    this.modes = ['day', 'month', 'year'];

    // Configuration attributes
    angular.forEach(['formatDay', 'formatMonth', 'formatYear', 'formatDayHeader', 'formatDayTitle', 'formatMonthTitle',
                     'minMode', 'maxMode', 'showWeeks', 'startingDay', 'yearRange'], function (key, index) {
                         self[key] = angular.isDefined($attrs[key]) ? (index < 8 ? $interpolate($attrs[key])($scope.$parent) : $scope.$parent.$eval($attrs[key])) : datepickerConfig[key];
                     });

    // Watchable date attributes
    angular.forEach(['minDate', 'maxDate'], function (key) {
        if ($attrs[key]) {
            $scope.$parent.$watch($parse($attrs[key]), function (value) {
                self[key] = value ? new Date(value) : null;
                self.refreshView();
            });
        } else {
            self[key] = datepickerConfig[key] ? new Date(datepickerConfig[key]) : null;
        }
    });

    $scope.datepickerMode = $scope.datepickerMode || datepickerConfig.datepickerMode;
    $scope.uniqueId = 'datepicker-' + $scope.$id + '-' + Math.floor(Math.random() * 10000);
    this.activeDate = angular.isDefined($attrs.initDate) ? $scope.$parent.$eval($attrs.initDate) : new Date();

    $scope.isActive = function (dateObject) {
        if (self.compare(dateObject.date, self.activeDate) === 0) {
            $scope.activeDateId = dateObject.uid;
            return true;
        }
        return false;
    };

    this.init = function (ngModelCtrl_) {
        ngModelCtrl = ngModelCtrl_;

        ngModelCtrl.$render = function () {
            self.render();
        };
    };

    this.render = function () {
        if (ngModelCtrl.$modelValue) {
            var date = new Date(ngModelCtrl.$modelValue),
                isValid = !isNaN(date);

            if (isValid) {
                this.activeDate = date;
            } else {
                $log.error('Datepicker directive: "ng-model" value must be a Date object, a number of milliseconds since 01.01.1970 or a string representing an RFC2822 or ISO 8601 date.');
            }
            ngModelCtrl.$setValidity('date', isValid);
        }
        this.refreshView();
    };

    this.refreshView = function () {
        if (this.element) {
            this._refreshView();

            var date = ngModelCtrl.$modelValue ? new Date(ngModelCtrl.$modelValue) : null;
            ngModelCtrl.$setValidity('date-disabled', !date || (this.element && !this.isDisabled(date)));
        }
    };

    this.createDateObject = function (date, format) {
        var model = ngModelCtrl.$modelValue ? new Date(ngModelCtrl.$modelValue) : null;
        return {
            date: date,
            label: dateFilter(date, format),
            selected: model && this.compare(date, model) === 0,
            disabled: this.isDisabled(date),
            current: this.compare(date, new Date()) === 0
        };
    };

    this.isDisabled = function (date) {
        return ((this.minDate && this.compare(date, this.minDate) < 0) || (this.maxDate && this.compare(date, this.maxDate) > 0) || ($attrs.dateDisabled && $scope.dateDisabled({ date: date, mode: $scope.datepickerMode })));
    };

    // Split array into smaller arrays
    this.split = function (arr, size) {
        var arrays = [];
        while (arr.length > 0) {
            arrays.push(arr.splice(0, size));
        }
        return arrays;
    };

    $scope.select = function (date) {
        if ($scope.datepickerMode === self.minMode) {
            var dt = ngModelCtrl.$modelValue ? new Date(ngModelCtrl.$modelValue) : new Date(0, 0, 0, 0, 0, 0, 0);
            dt.setFullYear(date.getFullYear(), date.getMonth(), date.getDate());
            ngModelCtrl.$setViewValue(dt);
            ngModelCtrl.$render();
        } else {
            self.activeDate = date;
            $scope.datepickerMode = self.modes[self.modes.indexOf($scope.datepickerMode) - 1];
        }
    };

    $scope.move = function (direction) {
        var year = self.activeDate.getFullYear() + direction * (self.step.years || 0),
            month = self.activeDate.getMonth() + direction * (self.step.months || 0);
        self.activeDate.setFullYear(year, month, 1);
        self.refreshView();
    };

    $scope.toggleMode = function (direction) {
        direction = direction || 1;

        if (($scope.datepickerMode === self.maxMode && direction === 1) || ($scope.datepickerMode === self.minMode && direction === -1)) {
            return;
        }

        $scope.datepickerMode = self.modes[self.modes.indexOf($scope.datepickerMode) + direction];
    };

    // Key event mapper
    $scope.keys = { 13: 'enter', 32: 'space', 33: 'pageup', 34: 'pagedown', 35: 'end', 36: 'home', 37: 'left', 38: 'up', 39: 'right', 40: 'down' };

    var focusElement = function () {
        $timeout(function () {
            self.element[0].focus();
        }, 0, false);
    };

    // Listen for focus requests from popup directive
    $scope.$on('datepicker.focus', focusElement);

    $scope.keydown = function (evt) {
        var key = $scope.keys[evt.which];

        if (!key || evt.shiftKey || evt.altKey) {
            return;
        }

        evt.preventDefault();
        evt.stopPropagation();

        if (key === 'enter' || key === 'space') {
            if (self.isDisabled(self.activeDate)) {
                return; // do nothing
            }
            $scope.select(self.activeDate);
            focusElement();
        } else if (evt.ctrlKey && (key === 'up' || key === 'down')) {
            $scope.toggleMode(key === 'up' ? 1 : -1);
            focusElement();
        } else {
            self.handleKeyDown(key, evt);
            self.refreshView();
        }
    };
}])

.directive('datepicker', function () {
    return {
        restrict: 'EA',
        replace: true,
        templateUrl: 'template/datepicker/datepicker.html',
        scope: {
            datepickerMode: '=?',
            dateDisabled: '&'
        },
        require: ['datepicker', '?^ngModel'],
        controller: 'DatepickerController',
        link: function (scope, element, attrs, ctrls) {
            var datepickerCtrl = ctrls[0], ngModelCtrl = ctrls[1];

            if (ngModelCtrl) {
                datepickerCtrl.init(ngModelCtrl);
            }
        }
    };
})

.directive('daypicker', ['dateFilter', function (dateFilter) {
    return {
        restrict: 'EA',
        replace: true,
        templateUrl: 'template/datepicker/day.html',
        require: '^datepicker',
        link: function (scope, element, attrs, ctrl) {
            scope.showWeeks = ctrl.showWeeks;

            ctrl.step = { months: 1 };
            ctrl.element = element;

            var DAYS_IN_MONTH = [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
            function getDaysInMonth(year, month) {
                return ((month === 1) && (year % 4 === 0) && ((year % 100 !== 0) || (year % 400 === 0))) ? 29 : DAYS_IN_MONTH[month];
            }

            function getDates(startDate, n) {
                var dates = new Array(n), current = new Date(startDate), i = 0;
                current.setHours(12); // Prevent repeated dates because of timezone bug
                while (i < n) {
                    dates[i++] = new Date(current);
                    current.setDate(current.getDate() + 1);
                }
                return dates;
            }

            ctrl._refreshView = function () {
                var year = ctrl.activeDate.getFullYear(),
                  month = ctrl.activeDate.getMonth(),
                  firstDayOfMonth = new Date(year, month, 1),
                  difference = ctrl.startingDay - firstDayOfMonth.getDay(),
                  numDisplayedFromPreviousMonth = (difference > 0) ? 7 - difference : -difference,
                  firstDate = new Date(firstDayOfMonth);

                if (numDisplayedFromPreviousMonth > 0) {
                    firstDate.setDate(-numDisplayedFromPreviousMonth + 1);
                }

                // 42 is the number of days on a six-month calendar
                var days = getDates(firstDate, 42);
                for (var i = 0; i < 42; i++) {
                    days[i] = angular.extend(ctrl.createDateObject(days[i], ctrl.formatDay), {
                        secondary: days[i].getMonth() !== month,
                        uid: scope.uniqueId + '-' + i
                    });
                }

                scope.labels = new Array(7);
                for (var j = 0; j < 7; j++) {
                    scope.labels[j] = {
                        abbr: dateFilter(days[j].date, ctrl.formatDayHeader),
                        full: dateFilter(days[j].date, 'EEEE')
                    };
                }

                scope.title = dateFilter(ctrl.activeDate, ctrl.formatDayTitle);
                scope.rows = ctrl.split(days, 7);

                if (scope.showWeeks) {
                    scope.weekNumbers = [];
                    var weekNumber = getISO8601WeekNumber(scope.rows[0][0].date),
                        numWeeks = scope.rows.length;
                    while (scope.weekNumbers.push(weekNumber++) < numWeeks) { }
                }
            };

            ctrl.compare = function (date1, date2) {
                return (new Date(date1.getFullYear(), date1.getMonth(), date1.getDate()) - new Date(date2.getFullYear(), date2.getMonth(), date2.getDate()));
            };

            function getISO8601WeekNumber(date) {
                var checkDate = new Date(date);
                checkDate.setDate(checkDate.getDate() + 4 - (checkDate.getDay() || 7)); // Thursday
                var time = checkDate.getTime();
                checkDate.setMonth(0); // Compare with Jan 1
                checkDate.setDate(1);
                return Math.floor(Math.round((time - checkDate) / 86400000) / 7) + 1;
            }

            ctrl.handleKeyDown = function (key, evt) {
                var date = ctrl.activeDate.getDate();

                if (key === 'left') {
                    date = date - 1;   // up
                } else if (key === 'up') {
                    date = date - 7;   // down
                } else if (key === 'right') {
                    date = date + 1;   // down
                } else if (key === 'down') {
                    date = date + 7;
                } else if (key === 'pageup' || key === 'pagedown') {
                    var month = ctrl.activeDate.getMonth() + (key === 'pageup' ? -1 : 1);
                    ctrl.activeDate.setMonth(month, 1);
                    date = Math.min(getDaysInMonth(ctrl.activeDate.getFullYear(), ctrl.activeDate.getMonth()), date);
                } else if (key === 'home') {
                    date = 1;
                } else if (key === 'end') {
                    date = getDaysInMonth(ctrl.activeDate.getFullYear(), ctrl.activeDate.getMonth());
                }
                ctrl.activeDate.setDate(date);
            };

            ctrl.refreshView();
        }
    };
}])

.directive('monthpicker', ['dateFilter', function (dateFilter) {
    return {
        restrict: 'EA',
        replace: true,
        templateUrl: 'template/datepicker/month.html',
        require: '^datepicker',
        link: function (scope, element, attrs, ctrl) {
            ctrl.step = { years: 1 };
            ctrl.element = element;

            ctrl._refreshView = function () {
                var months = new Array(12),
                    year = ctrl.activeDate.getFullYear();

                for (var i = 0; i < 12; i++) {
                    months[i] = angular.extend(ctrl.createDateObject(new Date(year, i, 1), ctrl.formatMonth), {
                        uid: scope.uniqueId + '-' + i
                    });
                }

                scope.title = dateFilter(ctrl.activeDate, ctrl.formatMonthTitle);
                scope.rows = ctrl.split(months, 3);
            };

            ctrl.compare = function (date1, date2) {
                return new Date(date1.getFullYear(), date1.getMonth()) - new Date(date2.getFullYear(), date2.getMonth());
            };

            ctrl.handleKeyDown = function (key, evt) {
                var date = ctrl.activeDate.getMonth();

                if (key === 'left') {
                    date = date - 1;   // up
                } else if (key === 'up') {
                    date = date - 3;   // down
                } else if (key === 'right') {
                    date = date + 1;   // down
                } else if (key === 'down') {
                    date = date + 3;
                } else if (key === 'pageup' || key === 'pagedown') {
                    var year = ctrl.activeDate.getFullYear() + (key === 'pageup' ? -1 : 1);
                    ctrl.activeDate.setFullYear(year);
                } else if (key === 'home') {
                    date = 0;
                } else if (key === 'end') {
                    date = 11;
                }
                ctrl.activeDate.setMonth(date);
            };

            ctrl.refreshView();
        }
    };
}])

.directive('yearpicker', ['dateFilter', function (dateFilter) {
    return {
        restrict: 'EA',
        replace: true,
        templateUrl: 'template/datepicker/year.html',
        require: '^datepicker',
        link: function (scope, element, attrs, ctrl) {
            var range = ctrl.yearRange;

            ctrl.step = { years: range };
            ctrl.element = element;

            function getStartingYear(year) {
                return parseInt((year - 1) / range, 10) * range + 1;
            }

            ctrl._refreshView = function () {
                var years = new Array(range);

                for (var i = 0, start = getStartingYear(ctrl.activeDate.getFullYear()) ; i < range; i++) {
                    years[i] = angular.extend(ctrl.createDateObject(new Date(start + i, 0, 1), ctrl.formatYear), {
                        uid: scope.uniqueId + '-' + i
                    });
                }

                scope.title = [years[0].label, years[range - 1].label].join(' - ');
                scope.rows = ctrl.split(years, 5);
            };

            ctrl.compare = function (date1, date2) {
                return date1.getFullYear() - date2.getFullYear();
            };

            ctrl.handleKeyDown = function (key, evt) {
                var date = ctrl.activeDate.getFullYear();

                if (key === 'left') {
                    date = date - 1;   // up
                } else if (key === 'up') {
                    date = date - 5;   // down
                } else if (key === 'right') {
                    date = date + 1;   // down
                } else if (key === 'down') {
                    date = date + 5;
                } else if (key === 'pageup' || key === 'pagedown') {
                    date += (key === 'pageup' ? -1 : 1) * ctrl.step.years;
                } else if (key === 'home') {
                    date = getStartingYear(ctrl.activeDate.getFullYear());
                } else if (key === 'end') {
                    date = getStartingYear(ctrl.activeDate.getFullYear()) + range - 1;
                }
                ctrl.activeDate.setFullYear(date);
            };

            ctrl.refreshView();
        }
    };
}])

.constant('datepickerPopupConfig', {
    datepickerPopup: 'yyyy-MM-dd',
    currentText: 'Today',
    clearText: 'Clear',
    closeText: 'Done',
    closeOnDateSelection: true,
    appendToBody: false,
    showButtonBar: true
})

.directive('datepickerPopup', ['$compile', '$parse', '$document', '$position', 'dateFilter', 'dateParser', 'datepickerPopupConfig',
function ($compile, $parse, $document, $position, dateFilter, dateParser, datepickerPopupConfig) {
    return {
        restrict: 'EA',
        require: 'ngModel',
        scope: {
            isOpen: '=?',
            currentText: '@',
            clearText: '@',
            closeText: '@',
            dateDisabled: '&'
        },
        link: function (scope, element, attrs, ngModel) {
            var dateFormat,
                closeOnDateSelection = angular.isDefined(attrs.closeOnDateSelection) ? scope.$parent.$eval(attrs.closeOnDateSelection) : datepickerPopupConfig.closeOnDateSelection,
                appendToBody = angular.isDefined(attrs.datepickerAppendToBody) ? scope.$parent.$eval(attrs.datepickerAppendToBody) : datepickerPopupConfig.appendToBody;

            scope.showButtonBar = angular.isDefined(attrs.showButtonBar) ? scope.$parent.$eval(attrs.showButtonBar) : datepickerPopupConfig.showButtonBar;

            scope.getText = function (key) {
                return scope[key + 'Text'] || datepickerPopupConfig[key + 'Text'];
            };

            attrs.$observe('datepickerPopup', function (value) {
                dateFormat = value || datepickerPopupConfig.datepickerPopup;
                ngModel.$render();
            });

            // popup element used to display calendar
            var popupEl = angular.element('<div datepicker-popup-wrap><div datepicker></div></div>');
            popupEl.attr({
                'ng-model': 'date',
                'ng-change': 'dateSelection()'
            });

            function cameltoDash(string) {
                return string.replace(/([A-Z])/g, function ($1) { return '-' + $1.toLowerCase(); });
            }

            // datepicker element
            var datepickerEl = angular.element(popupEl.children()[0]);
            if (attrs.datepickerOptions) {
                angular.forEach(scope.$parent.$eval(attrs.datepickerOptions), function (value, option) {
                    datepickerEl.attr(cameltoDash(option), value);
                });
            }

            scope.watchData = {};
            angular.forEach(['minDate', 'maxDate', 'datepickerMode'], function (key) {
                if (attrs[key]) {
                    var getAttribute = $parse(attrs[key]);
                    scope.$parent.$watch(getAttribute, function (value) {
                        scope.watchData[key] = value;
                    });
                    datepickerEl.attr(cameltoDash(key), 'watchData.' + key);

                    // Propagate changes from datepicker to outside
                    if (key === 'datepickerMode') {
                        var setAttribute = getAttribute.assign;
                        scope.$watch('watchData.' + key, function (value, oldvalue) {
                            if (value !== oldvalue) {
                                setAttribute(scope.$parent, value);
                            }
                        });
                    }
                }
            });
            if (attrs.dateDisabled) {
                datepickerEl.attr('date-disabled', 'dateDisabled({ date: date, mode: mode })');
            }

            function parseDate(viewValue) {
                if (!viewValue) {
                    ngModel.$setValidity('date', true);
                    return null;
                } else if (angular.isDate(viewValue) && !isNaN(viewValue)) {
                    ngModel.$setValidity('date', true);
                    return viewValue;
                } else if (angular.isString(viewValue)) {
                    var date = dateParser.parse(viewValue, dateFormat) || new Date(viewValue);
                    if (isNaN(date)) {
                        ngModel.$setValidity('date', false);
                        return undefined;
                    } else {
                        ngModel.$setValidity('date', true);
                        return date;
                    }
                } else {
                    ngModel.$setValidity('date', false);
                    return undefined;
                }
            }
            ngModel.$parsers.unshift(parseDate);

            // Inner change
            scope.dateSelection = function (dt) {
                if (angular.isDefined(dt)) {
                    scope.date = dt;
                }
                ngModel.$setViewValue(scope.date);
                ngModel.$render();

                if (closeOnDateSelection) {
                    scope.isOpen = false;
                    element[0].focus();
                }
            };

            element.bind('input change keyup', function () {
                scope.$apply(function () {
                    scope.date = ngModel.$modelValue;
                });
            });

            // Outter change
            ngModel.$render = function () {
                var date = ngModel.$viewValue ? dateFilter(ngModel.$viewValue, dateFormat) : '';
                element.val(date);
                scope.date = parseDate(ngModel.$modelValue);
            };

            var documentClickBind = function (event) {
                if (scope.isOpen && event.target !== element[0]) {
                    scope.$apply(function () {
                        scope.isOpen = false;
                    });
                }
            };

            var keydown = function (evt, noApply) {
                scope.keydown(evt);
            };
            element.bind('keydown', keydown);

            scope.keydown = function (evt) {
                if (evt.which === 27) {
                    evt.preventDefault();
                    evt.stopPropagation();
                    scope.close();
                } else if (evt.which === 40 && !scope.isOpen) {
                    scope.isOpen = true;
                }
            };

            scope.$watch('isOpen', function (value) {
                if (value) {
                    scope.$broadcast('datepicker.focus');
                    scope.position = appendToBody ? $position.offset(element) : $position.position(element);
                    scope.position.top = scope.position.top + element.prop('offsetHeight');

                    $document.bind('click', documentClickBind);
                } else {
                    $document.unbind('click', documentClickBind);
                }
            });

            scope.select = function (date) {
                if (date === 'today') {
                    var today = new Date();
                    if (angular.isDate(ngModel.$modelValue)) {
                        date = new Date(ngModel.$modelValue);
                        date.setFullYear(today.getFullYear(), today.getMonth(), today.getDate());
                    } else {
                        date = new Date(today.setHours(0, 0, 0, 0));
                    }
                }
                scope.dateSelection(date);
            };

            scope.close = function () {
                scope.isOpen = false;
                element[0].focus();
            };

            var $popup = $compile(popupEl)(scope);
            // Prevent jQuery cache memory leak (template is now redundant after linking)
            popupEl.remove();

            if (appendToBody) {
                $document.find('body').append($popup);
            } else {
                element.after($popup);
            }

            scope.$on('$destroy', function () {
                $popup.remove();
                element.unbind('keydown', keydown);
                $document.unbind('click', documentClickBind);
            });
        }
    };
}])

.directive('datepickerPopupWrap', function () {
    return {
        restrict: 'EA',
        replace: true,
        transclude: true,
        templateUrl: 'template/datepicker/popup.html',
        link: function (scope, element, attrs) {
            element.bind('click', function (event) {
                event.preventDefault();
                event.stopPropagation();
            });
        }
    };
});

angular.module('ui.bootstrap.dropdown', [])

.constant('dropdownConfig', {
    openClass: 'open'
})

.service('dropdownService', ['$document', function ($document) {
    var openScope = null;

    this.open = function (dropdownScope) {
        if (!openScope) {
            $document.bind('click', closeDropdown);
            $document.bind('keydown', escapeKeyBind);
        }

        if (openScope && openScope !== dropdownScope) {
            openScope.isOpen = false;
        }

        openScope = dropdownScope;
    };

    this.close = function (dropdownScope) {
        if (openScope === dropdownScope) {
            openScope = null;
            $document.unbind('click', closeDropdown);
            $document.unbind('keydown', escapeKeyBind);
        }
    };

    var closeDropdown = function (evt) {
        // This method may still be called during the same mouse event that
        // unbound this event handler. So check openScope before proceeding.
        if (!openScope) { return; }

        var toggleElement = openScope.getToggleElement();
        if (evt && toggleElement && toggleElement[0].contains(evt.target)) {
            return;
        }

        openScope.$apply(function () {
            openScope.isOpen = false;
        });
    };

    var escapeKeyBind = function (evt) {
        if (evt.which === 27) {
            openScope.focusToggleElement();
            closeDropdown();
        }
    };
}])

.controller('DropdownController', ['$scope', '$attrs', '$parse', 'dropdownConfig', 'dropdownService', '$animate', function ($scope, $attrs, $parse, dropdownConfig, dropdownService, $animate) {
    var self = this,
        scope = $scope.$new(), // create a child scope so we are not polluting original one
        openClass = dropdownConfig.openClass,
        getIsOpen,
        setIsOpen = angular.noop,
        toggleInvoker = $attrs.onToggle ? $parse($attrs.onToggle) : angular.noop;

    this.init = function (element) {
        self.$element = element;

        if ($attrs.isOpen) {
            getIsOpen = $parse($attrs.isOpen);
            setIsOpen = getIsOpen.assign;

            $scope.$watch(getIsOpen, function (value) {
                scope.isOpen = !!value;
            });
        }
    };

    this.toggle = function (open) {
        return scope.isOpen = arguments.length ? !!open : !scope.isOpen;
    };

    // Allow other directives to watch status
    this.isOpen = function () {
        return scope.isOpen;
    };

    scope.getToggleElement = function () {
        return self.toggleElement;
    };

    scope.focusToggleElement = function () {
        if (self.toggleElement) {
            self.toggleElement[0].focus();
        }
    };

    scope.$watch('isOpen', function (isOpen, wasOpen) {
        $animate[isOpen ? 'addClass' : 'removeClass'](self.$element, openClass);

        if (isOpen) {
            scope.focusToggleElement();
            dropdownService.open(scope);
        } else {
            dropdownService.close(scope);
        }

        setIsOpen($scope, isOpen);
        if (angular.isDefined(isOpen) && isOpen !== wasOpen) {
            toggleInvoker($scope, { open: !!isOpen });
        }
    });

    $scope.$on('$locationChangeSuccess', function () {
        scope.isOpen = false;
    });

    $scope.$on('$destroy', function () {
        scope.$destroy();
    });
}])

.directive('dropdown', function () {
    return {
        controller: 'DropdownController',
        link: function (scope, element, attrs, dropdownCtrl) {
            dropdownCtrl.init(element);
        }
    };
})

.directive('dropdownToggle', function () {
    return {
        require: '?^dropdown',
        link: function (scope, element, attrs, dropdownCtrl) {
            if (!dropdownCtrl) {
                return;
            }

            dropdownCtrl.toggleElement = element;

            var toggleDropdown = function (event) {
                event.preventDefault();

                if (!element.hasClass('disabled') && !attrs.disabled) {
                    scope.$apply(function () {
                        dropdownCtrl.toggle();
                    });
                }
            };

            element.bind('click', toggleDropdown);

            // WAI-ARIA
            element.attr({ 'aria-haspopup': true, 'aria-expanded': false });
            scope.$watch(dropdownCtrl.isOpen, function (isOpen) {
                element.attr('aria-expanded', !!isOpen);
            });

            scope.$on('$destroy', function () {
                element.unbind('click', toggleDropdown);
            });
        }
    };
});

angular.module('ui.bootstrap.modal', ['ui.bootstrap.transition'])

/**
 * A helper, internal data structure that acts as a map but also allows getting / removing
 * elements in the LIFO order
 */
  .factory('$$stackedMap', function () {
      return {
          createNew: function () {
              var stack = [];

              return {
                  add: function (key, value) {
                      stack.push({
                          key: key,
                          value: value
                      });
                  },
                  get: function (key) {
                      for (var i = 0; i < stack.length; i++) {
                          if (key == stack[i].key) {
                              return stack[i];
                          }
                      }
                  },
                  keys: function () {
                      var keys = [];
                      for (var i = 0; i < stack.length; i++) {
                          keys.push(stack[i].key);
                      }
                      return keys;
                  },
                  top: function () {
                      return stack[stack.length - 1];
                  },
                  remove: function (key) {
                      var idx = -1;
                      for (var i = 0; i < stack.length; i++) {
                          if (key == stack[i].key) {
                              idx = i;
                              break;
                          }
                      }
                      return stack.splice(idx, 1)[0];
                  },
                  removeTop: function () {
                      return stack.splice(stack.length - 1, 1)[0];
                  },
                  length: function () {
                      return stack.length;
                  }
              };
          }
      };
  })

/**
 * A helper directive for the $modal service. It creates a backdrop element.
 */
  .directive('modalBackdrop', ['$timeout', function ($timeout) {
      return {
          restrict: 'EA',
          replace: true,
          templateUrl: 'template/modal/backdrop.html',
          link: function (scope, element, attrs) {
              scope.backdropClass = attrs.backdropClass || '';

              scope.animate = false;

              //trigger CSS transitions
              $timeout(function () {
                  scope.animate = true;
              });
          }
      };
  }])

  .directive('modalWindow', ['$modalStack', '$timeout', function ($modalStack, $timeout) {
      return {
          restrict: 'EA',
          scope: {
              index: '@',
              animate: '='
          },
          replace: true,
          transclude: true,
          templateUrl: function (tElement, tAttrs) {
              return tAttrs.templateUrl || 'template/modal/window.html';
          },
          link: function (scope, element, attrs) {
              element.addClass(attrs.windowClass || '');
              scope.size = attrs.size;

              $timeout(function () {
                  // trigger CSS transitions
                  scope.animate = true;

                  /**
                   * Auto-focusing of a freshly-opened modal element causes any child elements
                   * with the autofocus attribute to lose focus. This is an issue on touch
                   * based devices which will show and then hide the onscreen keyboard.
                   * Attempts to refocus the autofocus element via JavaScript will not reopen
                   * the onscreen keyboard. Fixed by updated the focusing logic to only autofocus
                   * the modal element if the modal does not contain an autofocus element.
                   */
                  if (!element[0].querySelectorAll('[autofocus]').length) {
                      element[0].focus();
                  }
              });

              scope.close = function (evt) {
                  var modal = $modalStack.getTop();
                  if (modal && modal.value.backdrop && modal.value.backdrop != 'static' && (evt.target === evt.currentTarget)) {
                      evt.preventDefault();
                      evt.stopPropagation();
                      $modalStack.dismiss(modal.key, 'backdrop click');
                  }
              };
          }
      };
  }])

  .directive('modalTransclude', function () {
      return {
          link: function ($scope, $element, $attrs, controller, $transclude) {
              $transclude($scope.$parent, function (clone) {
                  $element.empty();
                  $element.append(clone);
              });
          }
      };
  })

  .factory('$modalStack', ['$transition', '$timeout', '$document', '$compile', '$rootScope', '$$stackedMap',
    function ($transition, $timeout, $document, $compile, $rootScope, $$stackedMap) {

        var OPENED_MODAL_CLASS = 'modal-open';

        var backdropDomEl, backdropScope;
        var openedWindows = $$stackedMap.createNew();
        var $modalStack = {};

        function backdropIndex() {
            var topBackdropIndex = -1;
            var opened = openedWindows.keys();
            for (var i = 0; i < opened.length; i++) {
                if (openedWindows.get(opened[i]).value.backdrop) {
                    topBackdropIndex = i;
                }
            }
            return topBackdropIndex;
        }

        $rootScope.$watch(backdropIndex, function (newBackdropIndex) {
            if (backdropScope) {
                backdropScope.index = newBackdropIndex;
            }
        });

        function removeModalWindow(modalInstance) {

            var body = $document.find('body').eq(0);
            var modalWindow = openedWindows.get(modalInstance).value;

            //clean up the stack
            openedWindows.remove(modalInstance);

            //remove window DOM element
            removeAfterAnimate(modalWindow.modalDomEl, modalWindow.modalScope, 300, function () {
                modalWindow.modalScope.$destroy();
                body.toggleClass(OPENED_MODAL_CLASS, openedWindows.length() > 0);
                checkRemoveBackdrop();
            });
        }

        function checkRemoveBackdrop() {
            //remove backdrop if no longer needed
            if (backdropDomEl && backdropIndex() == -1) {
                var backdropScopeRef = backdropScope;
                removeAfterAnimate(backdropDomEl, backdropScope, 150, function () {
                    backdropScopeRef.$destroy();
                    backdropScopeRef = null;
                });
                backdropDomEl = undefined;
                backdropScope = undefined;
            }
        }

        function removeAfterAnimate(domEl, scope, emulateTime, done) {
            // Closing animation
            scope.animate = false;

            var transitionEndEventName = $transition.transitionEndEventName;
            if (transitionEndEventName) {
                // transition out
                var timeout = $timeout(afterAnimating, emulateTime);

                domEl.bind(transitionEndEventName, function () {
                    $timeout.cancel(timeout);
                    afterAnimating();
                    scope.$apply();
                });
            } else {
                // Ensure this call is async
                $timeout(afterAnimating);
            }

            function afterAnimating() {
                if (afterAnimating.done) {
                    return;
                }
                afterAnimating.done = true;

                domEl.remove();
                if (done) {
                    done();
                }
            }
        }

        $document.bind('keydown', function (evt) {
            var modal;

            if (evt.which === 27) {
                modal = openedWindows.top();
                if (modal && modal.value.keyboard) {
                    evt.preventDefault();
                    $rootScope.$apply(function () {
                        $modalStack.dismiss(modal.key, 'escape key press');
                    });
                }
            }
        });

        $modalStack.open = function (modalInstance, modal) {

            openedWindows.add(modalInstance, {
                deferred: modal.deferred,
                modalScope: modal.scope,
                backdrop: modal.backdrop,
                keyboard: modal.keyboard
            });

            var body = $document.find('body').eq(0),
                currBackdropIndex = backdropIndex();

            if (currBackdropIndex >= 0 && !backdropDomEl) {
                backdropScope = $rootScope.$new(true);
                backdropScope.index = currBackdropIndex;
                var angularBackgroundDomEl = angular.element('<div modal-backdrop></div>');
                angularBackgroundDomEl.attr('backdrop-class', modal.backdropClass);
                backdropDomEl = $compile(angularBackgroundDomEl)(backdropScope);
                body.append(backdropDomEl);
            }

            var angularDomEl = angular.element('<div modal-window></div>');
            angularDomEl.attr({
                'template-url': modal.windowTemplateUrl,
                'window-class': modal.windowClass,
                'size': modal.size,
                'index': openedWindows.length() - 1,
                'animate': 'animate'
            }).html(modal.content);

            var modalDomEl = $compile(angularDomEl)(modal.scope);
            openedWindows.top().value.modalDomEl = modalDomEl;
            body.append(modalDomEl);
            body.addClass(OPENED_MODAL_CLASS);
        };

        $modalStack.close = function (modalInstance, result) {
            var modalWindow = openedWindows.get(modalInstance);
            if (modalWindow) {
                modalWindow.value.deferred.resolve(result);
                removeModalWindow(modalInstance);
            }
        };

        $modalStack.dismiss = function (modalInstance, reason) {
            var modalWindow = openedWindows.get(modalInstance);
            if (modalWindow) {
                modalWindow.value.deferred.reject(reason);
                removeModalWindow(modalInstance);
            }
        };

        $modalStack.dismissAll = function (reason) {
            var topModal = this.getTop();
            while (topModal) {
                this.dismiss(topModal.key, reason);
                topModal = this.getTop();
            }
        };

        $modalStack.getTop = function () {
            return openedWindows.top();
        };

        return $modalStack;
    }])

  .provider('$modal', function () {

      var $modalProvider = {
          options: {
              backdrop: true, //can be also false or 'static'
              keyboard: true
          },
          $get: ['$injector', '$rootScope', '$q', '$http', '$templateCache', '$controller', '$modalStack',
            function ($injector, $rootScope, $q, $http, $templateCache, $controller, $modalStack) {

                var $modal = {};

                function getTemplatePromise(options) {
                    return options.template ? $q.when(options.template) :
                      $http.get(angular.isFunction(options.templateUrl) ? (options.templateUrl)() : options.templateUrl,
                        { cache: $templateCache }).then(function (result) {
                            return result.data;
                        });
                }

                function getResolvePromises(resolves) {
                    var promisesArr = [];
                    angular.forEach(resolves, function (value) {
                        if (angular.isFunction(value) || angular.isArray(value)) {
                            promisesArr.push($q.when($injector.invoke(value)));
                        }
                    });
                    return promisesArr;
                }

                $modal.open = function (modalOptions) {

                    var modalResultDeferred = $q.defer();
                    var modalOpenedDeferred = $q.defer();

                    //prepare an instance of a modal to be injected into controllers and returned to a caller
                    var modalInstance = {
                        result: modalResultDeferred.promise,
                        opened: modalOpenedDeferred.promise,
                        close: function (result) {
                            $modalStack.close(modalInstance, result);
                        },
                        dismiss: function (reason) {
                            $modalStack.dismiss(modalInstance, reason);
                        }
                    };

                    //merge and clean up options
                    modalOptions = angular.extend({}, $modalProvider.options, modalOptions);
                    modalOptions.resolve = modalOptions.resolve || {};

                    //verify options
                    if (!modalOptions.template && !modalOptions.templateUrl) {
                        throw new Error('One of template or templateUrl options is required.');
                    }

                    var templateAndResolvePromise =
                      $q.all([getTemplatePromise(modalOptions)].concat(getResolvePromises(modalOptions.resolve)));


                    templateAndResolvePromise.then(function resolveSuccess(tplAndVars) {

                        var modalScope = (modalOptions.scope || $rootScope).$new();
                        modalScope.$close = modalInstance.close;
                        modalScope.$dismiss = modalInstance.dismiss;

                        var ctrlInstance, ctrlLocals = {};
                        var resolveIter = 1;

                        //controllers
                        if (modalOptions.controller) {
                            ctrlLocals.$scope = modalScope;
                            ctrlLocals.$modalInstance = modalInstance;
                            angular.forEach(modalOptions.resolve, function (value, key) {
                                ctrlLocals[key] = tplAndVars[resolveIter++];
                            });

                            ctrlInstance = $controller(modalOptions.controller, ctrlLocals);
                            if (modalOptions.controllerAs) {
                                modalScope[modalOptions.controllerAs] = ctrlInstance;
                            }
                        }

                        $modalStack.open(modalInstance, {
                            scope: modalScope,
                            deferred: modalResultDeferred,
                            content: tplAndVars[0],
                            backdrop: modalOptions.backdrop,
                            keyboard: modalOptions.keyboard,
                            backdropClass: modalOptions.backdropClass,
                            windowClass: modalOptions.windowClass,
                            windowTemplateUrl: modalOptions.windowTemplateUrl,
                            size: modalOptions.size
                        });

                    }, function resolveError(reason) {
                        modalResultDeferred.reject(reason);
                    });

                    templateAndResolvePromise.then(function () {
                        modalOpenedDeferred.resolve(true);
                    }, function () {
                        modalOpenedDeferred.reject(false);
                    });

                    return modalInstance;
                };

                return $modal;
            }]
      };

      return $modalProvider;
  });

angular.module('ui.bootstrap.pagination', [])

.controller('PaginationController', ['$scope', '$attrs', '$parse', function ($scope, $attrs, $parse) {
    var self = this,
        ngModelCtrl = { $setViewValue: angular.noop }, // nullModelCtrl
        setNumPages = $attrs.numPages ? $parse($attrs.numPages).assign : angular.noop;

    this.init = function (ngModelCtrl_, config) {
        ngModelCtrl = ngModelCtrl_;
        this.config = config;

        ngModelCtrl.$render = function () {
            self.render();
        };

        if ($attrs.itemsPerPage) {
            $scope.$parent.$watch($parse($attrs.itemsPerPage), function (value) {
                self.itemsPerPage = parseInt(value, 10);
                $scope.totalPages = self.calculateTotalPages();
            });
        } else {
            this.itemsPerPage = config.itemsPerPage;
        }
    };

    this.calculateTotalPages = function () {
        var totalPages = this.itemsPerPage < 1 ? 1 : Math.ceil($scope.totalItems / this.itemsPerPage);
        return Math.max(totalPages || 0, 1);
    };

    this.render = function () {
        $scope.page = parseInt(ngModelCtrl.$viewValue, 10) || 1;
    };

    $scope.selectPage = function (page) {
        if ($scope.page !== page && page > 0 && page <= $scope.totalPages) {
            ngModelCtrl.$setViewValue(page);
            ngModelCtrl.$render();
        }
    };

    $scope.getText = function (key) {
        return $scope[key + 'Text'] || self.config[key + 'Text'];
    };
    $scope.noPrevious = function () {
        return $scope.page === 1;
    };
    $scope.noNext = function () {
        return $scope.page === $scope.totalPages;
    };

    $scope.$watch('totalItems', function () {
        $scope.totalPages = self.calculateTotalPages();
    });

    $scope.$watch('totalPages', function (value) {
        setNumPages($scope.$parent, value); // Readonly variable

        if ($scope.page > value) {
            $scope.selectPage(value);
        } else {
            ngModelCtrl.$render();
        }
    });
}])

.constant('paginationConfig', {
    itemsPerPage: 10,
    boundaryLinks: false,
    directionLinks: true,
    firstText: 'First',
    previousText: 'Previous',
    nextText: 'Next',
    lastText: 'Last',
    rotate: true
})

.directive('pagination', ['$parse', 'paginationConfig', function ($parse, paginationConfig) {
    return {
        restrict: 'EA',
        scope: {
            totalItems: '=',
            firstText: '@',
            previousText: '@',
            nextText: '@',
            lastText: '@'
        },
        require: ['pagination', '?ngModel'],
        controller: 'PaginationController',
        templateUrl: 'template/pagination/pagination.html',
        replace: true,
        link: function (scope, element, attrs, ctrls) {
            var paginationCtrl = ctrls[0], ngModelCtrl = ctrls[1];

            if (!ngModelCtrl) {
                return; // do nothing if no ng-model
            }

            // Setup configuration parameters
            var maxSize = angular.isDefined(attrs.maxSize) ? scope.$parent.$eval(attrs.maxSize) : paginationConfig.maxSize,
                rotate = angular.isDefined(attrs.rotate) ? scope.$parent.$eval(attrs.rotate) : paginationConfig.rotate;
            scope.boundaryLinks = angular.isDefined(attrs.boundaryLinks) ? scope.$parent.$eval(attrs.boundaryLinks) : paginationConfig.boundaryLinks;
            scope.directionLinks = angular.isDefined(attrs.directionLinks) ? scope.$parent.$eval(attrs.directionLinks) : paginationConfig.directionLinks;

            paginationCtrl.init(ngModelCtrl, paginationConfig);

            if (attrs.maxSize) {
                scope.$parent.$watch($parse(attrs.maxSize), function (value) {
                    maxSize = parseInt(value, 10);
                    paginationCtrl.render();
                });
            }

            // Create page object used in template
            function makePage(number, text, isActive) {
                return {
                    number: number,
                    text: text,
                    active: isActive
                };
            }

            function getPages(currentPage, totalPages) {
                var pages = [];

                // Default page limits
                var startPage = 1, endPage = totalPages;
                var isMaxSized = (angular.isDefined(maxSize) && maxSize < totalPages);

                // recompute if maxSize
                if (isMaxSized) {
                    if (rotate) {
                        // Current page is displayed in the middle of the visible ones
                        startPage = Math.max(currentPage - Math.floor(maxSize / 2), 1);
                        endPage = startPage + maxSize - 1;

                        // Adjust if limit is exceeded
                        if (endPage > totalPages) {
                            endPage = totalPages;
                            startPage = endPage - maxSize + 1;
                        }
                    } else {
                        // Visible pages are paginated with maxSize
                        startPage = ((Math.ceil(currentPage / maxSize) - 1) * maxSize) + 1;

                        // Adjust last page if limit is exceeded
                        endPage = Math.min(startPage + maxSize - 1, totalPages);
                    }
                }

                // Add page number links
                for (var number = startPage; number <= endPage; number++) {
                    var page = makePage(number, number, number === currentPage);
                    pages.push(page);
                }

                // Add links to move between page sets
                if (isMaxSized && !rotate) {
                    if (startPage > 1) {
                        var previousPageSet = makePage(startPage - 1, '...', false);
                        pages.unshift(previousPageSet);
                    }

                    if (endPage < totalPages) {
                        var nextPageSet = makePage(endPage + 1, '...', false);
                        pages.push(nextPageSet);
                    }
                }

                return pages;
            }

            var originalRender = paginationCtrl.render;
            paginationCtrl.render = function () {
                originalRender();
                if (scope.page > 0 && scope.page <= scope.totalPages) {
                    scope.pages = getPages(scope.page, scope.totalPages);
                }
            };
        }
    };
}])

.constant('pagerConfig', {
    itemsPerPage: 10,
    previousText: '« Previous',
    nextText: 'Next »',
    align: true
})

.directive('pager', ['pagerConfig', function (pagerConfig) {
    return {
        restrict: 'EA',
        scope: {
            totalItems: '=',
            previousText: '@',
            nextText: '@'
        },
        require: ['pager', '?ngModel'],
        controller: 'PaginationController',
        templateUrl: 'template/pagination/pager.html',
        replace: true,
        link: function (scope, element, attrs, ctrls) {
            var paginationCtrl = ctrls[0], ngModelCtrl = ctrls[1];

            if (!ngModelCtrl) {
                return; // do nothing if no ng-model
            }

            scope.align = angular.isDefined(attrs.align) ? scope.$parent.$eval(attrs.align) : pagerConfig.align;
            paginationCtrl.init(ngModelCtrl, pagerConfig);
        }
    };
}]);

/**
 * The following features are still outstanding: animation as a
 * function, placement as a function, inside, support for more triggers than
 * just mouse enter/leave, html tooltips, and selector delegation.
 */
angular.module('ui.bootstrap.tooltip', ['ui.bootstrap.position', 'ui.bootstrap.bindHtml'])

/**
 * The $tooltip service creates tooltip- and popover-like directives as well as
 * houses global options for them.
 */
.provider('$tooltip', function () {
    // The default options tooltip and popover.
    var defaultOptions = {
        placement: 'top',
        animation: true,
        popupDelay: 0
    };

    // Default hide triggers for each show trigger
    var triggerMap = {
        'mouseenter': 'mouseleave',
        'click': 'click',
        'focus': 'blur'
    };

    // The options specified to the provider globally.
    var globalOptions = {};

    /**
     * `options({})` allows global configuration of all tooltips in the
     * application.
     *
     *   var app = angular.module( 'App', ['ui.bootstrap.tooltip'], function( $tooltipProvider ) {
     *     // place tooltips left instead of top by default
     *     $tooltipProvider.options( { placement: 'left' } );
     *   });
     */
    this.options = function (value) {
        angular.extend(globalOptions, value);
    };

    /**
     * This allows you to extend the set of trigger mappings available. E.g.:
     *
     *   $tooltipProvider.setTriggers( 'openTrigger': 'closeTrigger' );
     */
    this.setTriggers = function setTriggers(triggers) {
        angular.extend(triggerMap, triggers);
    };

    /**
     * This is a helper function for translating camel-case to snake-case.
     */
    function snake_case(name) {
        var regexp = /[A-Z]/g;
        var separator = '-';
        return name.replace(regexp, function (letter, pos) {
            return (pos ? separator : '') + letter.toLowerCase();
        });
    }

    /**
     * Returns the actual instance of the $tooltip service.
     * TODO support multiple triggers
     */
    this.$get = ['$window', '$compile', '$timeout', '$document', '$position', '$interpolate', function ($window, $compile, $timeout, $document, $position, $interpolate) {
        return function $tooltip(type, prefix, defaultTriggerShow) {
            var options = angular.extend({}, defaultOptions, globalOptions);

            /**
             * Returns an object of show and hide triggers.
             *
             * If a trigger is supplied,
             * it is used to show the tooltip; otherwise, it will use the `trigger`
             * option passed to the `$tooltipProvider.options` method; else it will
             * default to the trigger supplied to this directive factory.
             *
             * The hide trigger is based on the show trigger. If the `trigger` option
             * was passed to the `$tooltipProvider.options` method, it will use the
             * mapped trigger from `triggerMap` or the passed trigger if the map is
             * undefined; otherwise, it uses the `triggerMap` value of the show
             * trigger; else it will just use the show trigger.
             */
            function getTriggers(trigger) {
                var show = trigger || options.trigger || defaultTriggerShow;
                var hide = triggerMap[show] || show;
                return {
                    show: show,
                    hide: hide
                };
            }

            var directiveName = snake_case(type);

            var startSym = $interpolate.startSymbol();
            var endSym = $interpolate.endSymbol();
            var template =
              '<div ' + directiveName + '-popup ' +
                'title="' + startSym + 'title' + endSym + '" ' +
                'content="' + startSym + 'content' + endSym + '" ' +
                'placement="' + startSym + 'placement' + endSym + '" ' +
                'animation="animation" ' +
                'is-open="isOpen"' +
                '>' +
              '</div>';

            return {
                restrict: 'EA',
                compile: function (tElem, tAttrs) {
                    var tooltipLinker = $compile(template);

                    return function link(scope, element, attrs) {
                        var tooltip;
                        var tooltipLinkedScope;
                        var transitionTimeout;
                        var popupTimeout;
                        var appendToBody = angular.isDefined(options.appendToBody) ? options.appendToBody : false;
                        var triggers = getTriggers(undefined);
                        var hasEnableExp = angular.isDefined(attrs[prefix + 'Enable']);
                        var ttScope = scope.$new(true);

                        var positionTooltip = function () {

                            var ttPosition = $position.positionElements(element, tooltip, ttScope.placement, appendToBody);
                            ttPosition.top += 'px';
                            ttPosition.left += 'px';

                            // Now set the calculated positioning.
                            tooltip.css(ttPosition);
                        };

                        // By default, the tooltip is not open.
                        // TODO add ability to start tooltip opened
                        ttScope.isOpen = false;

                        function toggleTooltipBind() {
                            if (!ttScope.isOpen) {
                                showTooltipBind();
                            } else {
                                hideTooltipBind();
                            }
                        }

                        // Show the tooltip with delay if specified, otherwise show it immediately
                        function showTooltipBind() {
                            if (hasEnableExp && !scope.$eval(attrs[prefix + 'Enable'])) {
                                return;
                            }

                            prepareTooltip();

                            if (ttScope.popupDelay) {
                                // Do nothing if the tooltip was already scheduled to pop-up.
                                // This happens if show is triggered multiple times before any hide is triggered.
                                if (!popupTimeout) {
                                    popupTimeout = $timeout(show, ttScope.popupDelay, false);
                                    popupTimeout.then(function (reposition) { reposition(); });
                                }
                            } else {
                                show()();
                            }
                        }

                        function hideTooltipBind() {
                            scope.$apply(function () {
                                hide();
                            });
                        }

                        // Show the tooltip popup element.
                        function show() {

                            popupTimeout = null;

                            // If there is a pending remove transition, we must cancel it, lest the
                            // tooltip be mysteriously removed.
                            if (transitionTimeout) {
                                $timeout.cancel(transitionTimeout);
                                transitionTimeout = null;
                            }

                            // Don't show empty tooltips.
                            if (!ttScope.content) {
                                return angular.noop;
                            }

                            createTooltip();

                            // Set the initial positioning.
                            tooltip.css({ top: 0, left: 0, display: 'block' });

                            // Now we add it to the DOM because need some info about it. But it's not
                            // visible yet anyway.
                            if (appendToBody) {
                                $document.find('body').append(tooltip);
                            } else {
                                element.after(tooltip);
                            }

                            positionTooltip();

                            // And show the tooltip.
                            ttScope.isOpen = true;
                            ttScope.$digest(); // digest required as $apply is not called

                            // Return positioning function as promise callback for correct
                            // positioning after draw.
                            return positionTooltip;
                        }

                        // Hide the tooltip popup element.
                        function hide() {
                            // First things first: we don't show it anymore.
                            ttScope.isOpen = false;

                            //if tooltip is going to be shown after delay, we must cancel this
                            $timeout.cancel(popupTimeout);
                            popupTimeout = null;

                            // And now we remove it from the DOM. However, if we have animation, we
                            // need to wait for it to expire beforehand.
                            // FIXME: this is a placeholder for a port of the transitions library.
                            if (ttScope.animation) {
                                if (!transitionTimeout) {
                                    transitionTimeout = $timeout(removeTooltip, 500);
                                }
                            } else {
                                removeTooltip();
                            }
                        }

                        function createTooltip() {
                            // There can only be one tooltip element per directive shown at once.
                            if (tooltip) {
                                removeTooltip();
                            }
                            tooltipLinkedScope = ttScope.$new();
                            tooltip = tooltipLinker(tooltipLinkedScope, angular.noop);
                        }

                        function removeTooltip() {
                            transitionTimeout = null;
                            if (tooltip) {
                                tooltip.remove();
                                tooltip = null;
                            }
                            if (tooltipLinkedScope) {
                                tooltipLinkedScope.$destroy();
                                tooltipLinkedScope = null;
                            }
                        }

                        function prepareTooltip() {
                            prepPlacement();
                            prepPopupDelay();
                        }

                        /**
                         * Observe the relevant attributes.
                         */
                        attrs.$observe(type, function (val) {
                            ttScope.content = val;

                            if (!val && ttScope.isOpen) {
                                hide();
                            }
                        });

                        attrs.$observe(prefix + 'Title', function (val) {
                            ttScope.title = val;
                        });

                        function prepPlacement() {
                            var val = attrs[prefix + 'Placement'];
                            ttScope.placement = angular.isDefined(val) ? val : options.placement;
                        }

                        function prepPopupDelay() {
                            var val = attrs[prefix + 'PopupDelay'];
                            var delay = parseInt(val, 10);
                            ttScope.popupDelay = !isNaN(delay) ? delay : options.popupDelay;
                        }

                        var unregisterTriggers = function () {
                            element.unbind(triggers.show, showTooltipBind);
                            element.unbind(triggers.hide, hideTooltipBind);
                        };

                        function prepTriggers() {
                            var val = attrs[prefix + 'Trigger'];
                            unregisterTriggers();

                            triggers = getTriggers(val);

                            if (triggers.show === triggers.hide) {
                                element.bind(triggers.show, toggleTooltipBind);
                            } else {
                                element.bind(triggers.show, showTooltipBind);
                                element.bind(triggers.hide, hideTooltipBind);
                            }
                        }
                        prepTriggers();

                        var animation = scope.$eval(attrs[prefix + 'Animation']);
                        ttScope.animation = angular.isDefined(animation) ? !!animation : options.animation;

                        var appendToBodyVal = scope.$eval(attrs[prefix + 'AppendToBody']);
                        appendToBody = angular.isDefined(appendToBodyVal) ? appendToBodyVal : appendToBody;

                        // if a tooltip is attached to <body> we need to remove it on
                        // location change as its parent scope will probably not be destroyed
                        // by the change.
                        if (appendToBody) {
                            scope.$on('$locationChangeSuccess', function closeTooltipOnLocationChangeSuccess() {
                                if (ttScope.isOpen) {
                                    hide();
                                }
                            });
                        }

                        // Make sure tooltip is destroyed and removed.
                        scope.$on('$destroy', function onDestroyTooltip() {
                            $timeout.cancel(transitionTimeout);
                            $timeout.cancel(popupTimeout);
                            unregisterTriggers();
                            removeTooltip();
                            ttScope = null;
                        });
                    };
                }
            };
        };
    }];
})

.directive('tooltipPopup', function () {
    return {
        restrict: 'EA',
        replace: true,
        scope: { content: '@', placement: '@', animation: '&', isOpen: '&' },
        templateUrl: 'template/tooltip/tooltip-popup.html'
    };
})

.directive('tooltip', ['$tooltip', function ($tooltip) {
    return $tooltip('tooltip', 'tooltip', 'mouseenter');
}])

.directive('tooltipHtmlUnsafePopup', function () {
    return {
        restrict: 'EA',
        replace: true,
        scope: { content: '@', placement: '@', animation: '&', isOpen: '&' },
        templateUrl: 'template/tooltip/tooltip-html-unsafe-popup.html'
    };
})

.directive('tooltipHtmlUnsafe', ['$tooltip', function ($tooltip) {
    return $tooltip('tooltipHtmlUnsafe', 'tooltip', 'mouseenter');
}]);

/**
 * The following features are still outstanding: popup delay, animation as a
 * function, placement as a function, inside, support for more triggers than
 * just mouse enter/leave, html popovers, and selector delegatation.
 */
angular.module('ui.bootstrap.popover', ['ui.bootstrap.tooltip'])

.directive('popoverPopup', function () {
    return {
        restrict: 'EA',
        replace: true,
        scope: { title: '@', content: '@', placement: '@', animation: '&', isOpen: '&' },
        templateUrl: 'template/popover/popover.html'
    };
})

.directive('popover', ['$tooltip', function ($tooltip) {
    return $tooltip('popover', 'popover', 'click');
}]);

angular.module('ui.bootstrap.progressbar', [])

.constant('progressConfig', {
    animate: true,
    max: 100
})

.controller('ProgressController', ['$scope', '$attrs', 'progressConfig', function ($scope, $attrs, progressConfig) {
    var self = this,
        animate = angular.isDefined($attrs.animate) ? $scope.$parent.$eval($attrs.animate) : progressConfig.animate;

    this.bars = [];
    $scope.max = angular.isDefined($attrs.max) ? $scope.$parent.$eval($attrs.max) : progressConfig.max;

    this.addBar = function (bar, element) {
        if (!animate) {
            element.css({ 'transition': 'none' });
        }

        this.bars.push(bar);

        bar.$watch('value', function (value) {
            bar.percent = +(100 * value / $scope.max).toFixed(2);
        });

        bar.$on('$destroy', function () {
            element = null;
            self.removeBar(bar);
        });
    };

    this.removeBar = function (bar) {
        this.bars.splice(this.bars.indexOf(bar), 1);
    };
}])

.directive('progress', function () {
    return {
        restrict: 'EA',
        replace: true,
        transclude: true,
        controller: 'ProgressController',
        require: 'progress',
        scope: {},
        templateUrl: 'template/progressbar/progress.html'
    };
})

.directive('bar', function () {
    return {
        restrict: 'EA',
        replace: true,
        transclude: true,
        require: '^progress',
        scope: {
            value: '=',
            type: '@'
        },
        templateUrl: 'template/progressbar/bar.html',
        link: function (scope, element, attrs, progressCtrl) {
            progressCtrl.addBar(scope, element);
        }
    };
})

.directive('progressbar', function () {
    return {
        restrict: 'EA',
        replace: true,
        transclude: true,
        controller: 'ProgressController',
        scope: {
            value: '=',
            type: '@'
        },
        templateUrl: 'template/progressbar/progressbar.html',
        link: function (scope, element, attrs, progressCtrl) {
            progressCtrl.addBar(scope, angular.element(element.children()[0]));
        }
    };
});
angular.module('ui.bootstrap.rating', [])

.constant('ratingConfig', {
    max: 5,
    stateOn: null,
    stateOff: null
})

.controller('RatingController', ['$scope', '$attrs', 'ratingConfig', function ($scope, $attrs, ratingConfig) {
    var ngModelCtrl = { $setViewValue: angular.noop };

    this.init = function (ngModelCtrl_) {
        ngModelCtrl = ngModelCtrl_;
        ngModelCtrl.$render = this.render;

        this.stateOn = angular.isDefined($attrs.stateOn) ? $scope.$parent.$eval($attrs.stateOn) : ratingConfig.stateOn;
        this.stateOff = angular.isDefined($attrs.stateOff) ? $scope.$parent.$eval($attrs.stateOff) : ratingConfig.stateOff;

        var ratingStates = angular.isDefined($attrs.ratingStates) ? $scope.$parent.$eval($attrs.ratingStates) :
                            new Array(angular.isDefined($attrs.max) ? $scope.$parent.$eval($attrs.max) : ratingConfig.max);
        $scope.range = this.buildTemplateObjects(ratingStates);
    };

    this.buildTemplateObjects = function (states) {
        for (var i = 0, n = states.length; i < n; i++) {
            states[i] = angular.extend({ index: i }, { stateOn: this.stateOn, stateOff: this.stateOff }, states[i]);
        }
        return states;
    };

    $scope.rate = function (value) {
        if (!$scope.readonly && value >= 0 && value <= $scope.range.length) {
            ngModelCtrl.$setViewValue(value);
            ngModelCtrl.$render();
        }
    };

    $scope.enter = function (value) {
        if (!$scope.readonly) {
            $scope.value = value;
        }
        $scope.onHover({ value: value });
    };

    $scope.reset = function () {
        $scope.value = ngModelCtrl.$viewValue;
        $scope.onLeave();
    };

    $scope.onKeydown = function (evt) {
        if (/(37|38|39|40)/.test(evt.which)) {
            evt.preventDefault();
            evt.stopPropagation();
            $scope.rate($scope.value + (evt.which === 38 || evt.which === 39 ? 1 : -1));
        }
    };

    this.render = function () {
        $scope.value = ngModelCtrl.$viewValue;
    };
}])

.directive('rating', function () {
    return {
        restrict: 'EA',
        require: ['rating', 'ngModel'],
        scope: {
            readonly: '=?',
            onHover: '&',
            onLeave: '&'
        },
        controller: 'RatingController',
        templateUrl: 'template/rating/rating.html',
        replace: true,
        link: function (scope, element, attrs, ctrls) {
            var ratingCtrl = ctrls[0], ngModelCtrl = ctrls[1];

            if (ngModelCtrl) {
                ratingCtrl.init(ngModelCtrl);
            }
        }
    };
});

/**
 * @ngdoc overview
 * @name ui.bootstrap.tabs
 *
 * @description
 * AngularJS version of the tabs directive.
 */

angular.module('ui.bootstrap.tabs', [])

.controller('TabsetController', ['$scope', function TabsetCtrl($scope) {
    var ctrl = this,
        tabs = ctrl.tabs = $scope.tabs = [];

    ctrl.select = function (selectedTab) {
        angular.forEach(tabs, function (tab) {
            if (tab.active && tab !== selectedTab) {
                tab.active = false;
                tab.onDeselect();
            }
        });
        selectedTab.active = true;
        selectedTab.onSelect();
    };

    ctrl.addTab = function addTab(tab) {
        tabs.push(tab);
        // we can't run the select function on the first tab
        // since that would select it twice
        if (tabs.length === 1) {
            tab.active = true;
        } else if (tab.active) {
            ctrl.select(tab);
        }
    };

    ctrl.removeTab = function removeTab(tab) {
        var index = tabs.indexOf(tab);
        //Select a new tab if the tab to be removed is selected and not destroyed
        if (tab.active && tabs.length > 1 && !destroyed) {
            //If this is the last tab, select the previous tab. else, the next tab.
            var newActiveIndex = index == tabs.length - 1 ? index - 1 : index + 1;
            ctrl.select(tabs[newActiveIndex]);
        }
        tabs.splice(index, 1);
    };

    var destroyed;
    $scope.$on('$destroy', function () {
        destroyed = true;
    });
}])

/**
 * @ngdoc directive
 * @name ui.bootstrap.tabs.directive:tabset
 * @restrict EA
 *
 * @description
 * Tabset is the outer container for the tabs directive
 *
 * @param {boolean=} vertical Whether or not to use vertical styling for the tabs.
 * @param {boolean=} justified Whether or not to use justified styling for the tabs.
 *
 * @example
<example module="ui.bootstrap">
  <file name="index.html">
    <tabset>
      <tab heading="Tab 1"><b>First</b> Content!</tab>
      <tab heading="Tab 2"><i>Second</i> Content!</tab>
    </tabset>
    <hr />
    <tabset vertical="true">
      <tab heading="Vertical Tab 1"><b>First</b> Vertical Content!</tab>
      <tab heading="Vertical Tab 2"><i>Second</i> Vertical Content!</tab>
    </tabset>
    <tabset justified="true">
      <tab heading="Justified Tab 1"><b>First</b> Justified Content!</tab>
      <tab heading="Justified Tab 2"><i>Second</i> Justified Content!</tab>
    </tabset>
  </file>
</example>
 */
.directive('tabset', function () {
    return {
        restrict: 'EA',
        transclude: true,
        replace: true,
        scope: {
            type: '@'
        },
        controller: 'TabsetController',
        templateUrl: 'template/tabs/tabset.html',
        link: function (scope, element, attrs) {
            scope.vertical = angular.isDefined(attrs.vertical) ? scope.$parent.$eval(attrs.vertical) : false;
            scope.justified = angular.isDefined(attrs.justified) ? scope.$parent.$eval(attrs.justified) : false;
        }
    };
})

/**
 * @ngdoc directive
 * @name ui.bootstrap.tabs.directive:tab
 * @restrict EA
 *
 * @param {string=} heading The visible heading, or title, of the tab. Set HTML headings with {@link ui.bootstrap.tabs.directive:tabHeading tabHeading}.
 * @param {string=} select An expression to evaluate when the tab is selected.
 * @param {boolean=} active A binding, telling whether or not this tab is selected.
 * @param {boolean=} disabled A binding, telling whether or not this tab is disabled.
 *
 * @description
 * Creates a tab with a heading and content. Must be placed within a {@link ui.bootstrap.tabs.directive:tabset tabset}.
 *
 * @example
<example module="ui.bootstrap">
  <file name="index.html">
    <div ng-controller="TabsDemoCtrl">
      <button class="btn btn-small" ng-click="items[0].active = true">
        Select item 1, using active binding
      </button>
      <button class="btn btn-small" ng-click="items[1].disabled = !items[1].disabled">
        Enable/disable item 2, using disabled binding
      </button>
      <br />
      <tabset>
        <tab heading="Tab 1">First Tab</tab>
        <tab select="alertMe()">
          <tab-heading><i class="icon-bell"></i> Alert me!</tab-heading>
          Second Tab, with alert callback and html heading!
        </tab>
        <tab ng-repeat="item in items"
          heading="{{item.title}}"
          disabled="item.disabled"
          active="item.active">
          {{item.content}}
        </tab>
      </tabset>
    </div>
  </file>
  <file name="script.js">
    function TabsDemoCtrl($scope) {
      $scope.items = [
        { title:"Dynamic Title 1", content:"Dynamic Item 0" },
        { title:"Dynamic Title 2", content:"Dynamic Item 1", disabled: true }
      ];

      $scope.alertMe = function() {
        setTimeout(function() {
          alert("You've selected the alert tab!");
        });
      };
    };
  </file>
</example>
 */

/**
 * @ngdoc directive
 * @name ui.bootstrap.tabs.directive:tabHeading
 * @restrict EA
 *
 * @description
 * Creates an HTML heading for a {@link ui.bootstrap.tabs.directive:tab tab}. Must be placed as a child of a tab element.
 *
 * @example
<example module="ui.bootstrap">
  <file name="index.html">
    <tabset>
      <tab>
        <tab-heading><b>HTML</b> in my titles?!</tab-heading>
        And some content, too!
      </tab>
      <tab>
        <tab-heading><i class="icon-heart"></i> Icon heading?!?</tab-heading>
        That's right.
      </tab>
    </tabset>
  </file>
</example>
 */
.directive('tab', ['$parse', function ($parse) {
    return {
        require: '^tabset',
        restrict: 'EA',
        replace: true,
        templateUrl: 'template/tabs/tab.html',
        transclude: true,
        scope: {
            active: '=?',
            heading: '@',
            onSelect: '&select', //This callback is called in contentHeadingTransclude
            //once it inserts the tab's content into the dom
            onDeselect: '&deselect'
        },
        controller: function () {
            //Empty controller so other directives can require being 'under' a tab
        },
        compile: function (elm, attrs, transclude) {
            return function postLink(scope, elm, attrs, tabsetCtrl) {
                scope.$watch('active', function (active) {
                    if (active) {
                        tabsetCtrl.select(scope);
                    }
                });

                scope.disabled = false;
                if (attrs.disabled) {
                    scope.$parent.$watch($parse(attrs.disabled), function (value) {
                        scope.disabled = !!value;
                    });
                }

                scope.select = function () {
                    if (!scope.disabled) {
                        scope.active = true;
                    }
                };

                tabsetCtrl.addTab(scope);
                scope.$on('$destroy', function () {
                    tabsetCtrl.removeTab(scope);
                });

                //We need to transclude later, once the content container is ready.
                //when this link happens, we're inside a tab heading.
                scope.$transcludeFn = transclude;
            };
        }
    };
}])

.directive('tabHeadingTransclude', [function () {
    return {
        restrict: 'A',
        require: '^tab',
        link: function (scope, elm, attrs, tabCtrl) {
            scope.$watch('headingElement', function updateHeadingElement(heading) {
                if (heading) {
                    elm.html('');
                    elm.append(heading);
                }
            });
        }
    };
}])

.directive('tabContentTransclude', function () {
    return {
        restrict: 'A',
        require: '^tabset',
        link: function (scope, elm, attrs) {
            var tab = scope.$eval(attrs.tabContentTransclude);

            //Now our tab is ready to be transcluded: both the tab heading area
            //and the tab content area are loaded.  Transclude 'em both.
            tab.$transcludeFn(tab.$parent, function (contents) {
                angular.forEach(contents, function (node) {
                    if (isTabHeading(node)) {
                        //Let tabHeadingTransclude know.
                        tab.headingElement = node;
                    } else {
                        elm.append(node);
                    }
                });
            });
        }
    };
    function isTabHeading(node) {
        return node.tagName && (
          node.hasAttribute('tab-heading') ||
          node.hasAttribute('data-tab-heading') ||
          node.tagName.toLowerCase() === 'tab-heading' ||
          node.tagName.toLowerCase() === 'data-tab-heading'
        );
    }
})

;

angular.module('ui.bootstrap.timepicker', [])

.constant('timepickerConfig', {
    hourStep: 1,
    minuteStep: 1,
    showMeridian: true,
    meridians: null,
    readonlyInput: false,
    mousewheel: true
})

.controller('TimepickerController', ['$scope', '$attrs', '$parse', '$log', '$locale', 'timepickerConfig', function ($scope, $attrs, $parse, $log, $locale, timepickerConfig) {
    var selected = new Date(),
        ngModelCtrl = { $setViewValue: angular.noop }, // nullModelCtrl
        meridians = angular.isDefined($attrs.meridians) ? $scope.$parent.$eval($attrs.meridians) : timepickerConfig.meridians || $locale.DATETIME_FORMATS.AMPMS;

    this.init = function (ngModelCtrl_, inputs) {
        ngModelCtrl = ngModelCtrl_;
        ngModelCtrl.$render = this.render;

        var hoursInputEl = inputs.eq(0),
            minutesInputEl = inputs.eq(1);

        var mousewheel = angular.isDefined($attrs.mousewheel) ? $scope.$parent.$eval($attrs.mousewheel) : timepickerConfig.mousewheel;
        if (mousewheel) {
            this.setupMousewheelEvents(hoursInputEl, minutesInputEl);
        }

        $scope.readonlyInput = angular.isDefined($attrs.readonlyInput) ? $scope.$parent.$eval($attrs.readonlyInput) : timepickerConfig.readonlyInput;
        this.setupInputEvents(hoursInputEl, minutesInputEl);
    };

    var hourStep = timepickerConfig.hourStep;
    if ($attrs.hourStep) {
        $scope.$parent.$watch($parse($attrs.hourStep), function (value) {
            hourStep = parseInt(value, 10);
        });
    }

    var minuteStep = timepickerConfig.minuteStep;
    if ($attrs.minuteStep) {
        $scope.$parent.$watch($parse($attrs.minuteStep), function (value) {
            minuteStep = parseInt(value, 10);
        });
    }

    // 12H / 24H mode
    $scope.showMeridian = timepickerConfig.showMeridian;
    if ($attrs.showMeridian) {
        $scope.$parent.$watch($parse($attrs.showMeridian), function (value) {
            $scope.showMeridian = !!value;

            if (ngModelCtrl.$error.time) {
                // Evaluate from template
                var hours = getHoursFromTemplate(), minutes = getMinutesFromTemplate();
                if (angular.isDefined(hours) && angular.isDefined(minutes)) {
                    selected.setHours(hours);
                    refresh();
                }
            } else {
                updateTemplate();
            }
        });
    }

    // Get $scope.hours in 24H mode if valid
    function getHoursFromTemplate() {
        var hours = parseInt($scope.hours, 10);
        var valid = ($scope.showMeridian) ? (hours > 0 && hours < 13) : (hours >= 0 && hours < 24);
        if (!valid) {
            return undefined;
        }

        if ($scope.showMeridian) {
            if (hours === 12) {
                hours = 0;
            }
            if ($scope.meridian === meridians[1]) {
                hours = hours + 12;
            }
        }
        return hours;
    }

    function getMinutesFromTemplate() {
        var minutes = parseInt($scope.minutes, 10);
        return (minutes >= 0 && minutes < 60) ? minutes : undefined;
    }

    function pad(value) {
        return (angular.isDefined(value) && value.toString().length < 2) ? '0' + value : value;
    }

    // Respond on mousewheel spin
    this.setupMousewheelEvents = function (hoursInputEl, minutesInputEl) {
        var isScrollingUp = function (e) {
            if (e.originalEvent) {
                e = e.originalEvent;
            }
            //pick correct delta variable depending on event
            var delta = (e.wheelDelta) ? e.wheelDelta : -e.deltaY;
            return (e.detail || delta > 0);
        };

        hoursInputEl.bind('mousewheel wheel', function (e) {
            $scope.$apply((isScrollingUp(e)) ? $scope.incrementHours() : $scope.decrementHours());
            e.preventDefault();
        });

        minutesInputEl.bind('mousewheel wheel', function (e) {
            $scope.$apply((isScrollingUp(e)) ? $scope.incrementMinutes() : $scope.decrementMinutes());
            e.preventDefault();
        });

    };

    this.setupInputEvents = function (hoursInputEl, minutesInputEl) {
        if ($scope.readonlyInput) {
            $scope.updateHours = angular.noop;
            $scope.updateMinutes = angular.noop;
            return;
        }

        var invalidate = function (invalidHours, invalidMinutes) {
            ngModelCtrl.$setViewValue(null);
            ngModelCtrl.$setValidity('time', false);
            if (angular.isDefined(invalidHours)) {
                $scope.invalidHours = invalidHours;
            }
            if (angular.isDefined(invalidMinutes)) {
                $scope.invalidMinutes = invalidMinutes;
            }
        };

        $scope.updateHours = function () {
            var hours = getHoursFromTemplate();

            if (angular.isDefined(hours)) {
                selected.setHours(hours);
                refresh('h');
            } else {
                invalidate(true);
            }
        };

        hoursInputEl.bind('blur', function (e) {
            if (!$scope.invalidHours && $scope.hours < 10) {
                $scope.$apply(function () {
                    $scope.hours = pad($scope.hours);
                });
            }
        });

        $scope.updateMinutes = function () {
            var minutes = getMinutesFromTemplate();

            if (angular.isDefined(minutes)) {
                selected.setMinutes(minutes);
                refresh('m');
            } else {
                invalidate(undefined, true);
            }
        };

        minutesInputEl.bind('blur', function (e) {
            if (!$scope.invalidMinutes && $scope.minutes < 10) {
                $scope.$apply(function () {
                    $scope.minutes = pad($scope.minutes);
                });
            }
        });

    };

    this.render = function () {
        var date = ngModelCtrl.$modelValue ? new Date(ngModelCtrl.$modelValue) : null;

        if (isNaN(date)) {
            ngModelCtrl.$setValidity('time', false);
            $log.error('Timepicker directive: "ng-model" value must be a Date object, a number of milliseconds since 01.01.1970 or a string representing an RFC2822 or ISO 8601 date.');
        } else {
            if (date) {
                selected = date;
            }
            makeValid();
            updateTemplate();
        }
    };

    // Call internally when we know that model is valid.
    function refresh(keyboardChange) {
        makeValid();
        ngModelCtrl.$setViewValue(new Date(selected));
        updateTemplate(keyboardChange);
    }

    function makeValid() {
        ngModelCtrl.$setValidity('time', true);
        $scope.invalidHours = false;
        $scope.invalidMinutes = false;
    }

    function updateTemplate(keyboardChange) {
        var hours = selected.getHours(), minutes = selected.getMinutes();

        if ($scope.showMeridian) {
            hours = (hours === 0 || hours === 12) ? 12 : hours % 12; // Convert 24 to 12 hour system
        }

        $scope.hours = keyboardChange === 'h' ? hours : pad(hours);
        $scope.minutes = keyboardChange === 'm' ? minutes : pad(minutes);
        $scope.meridian = selected.getHours() < 12 ? meridians[0] : meridians[1];
    }

    function addMinutes(minutes) {
        var dt = new Date(selected.getTime() + minutes * 60000);
        selected.setHours(dt.getHours(), dt.getMinutes());
        refresh();
    }

    $scope.incrementHours = function () {
        addMinutes(hourStep * 60);
    };
    $scope.decrementHours = function () {
        addMinutes(-hourStep * 60);
    };
    $scope.incrementMinutes = function () {
        addMinutes(minuteStep);
    };
    $scope.decrementMinutes = function () {
        addMinutes(-minuteStep);
    };
    $scope.toggleMeridian = function () {
        addMinutes(12 * 60 * ((selected.getHours() < 12) ? 1 : -1));
    };
}])

.directive('timepicker', function () {
    return {
        restrict: 'EA',
        require: ['timepicker', '?^ngModel'],
        controller: 'TimepickerController',
        replace: true,
        scope: {},
        templateUrl: 'template/timepicker/timepicker.html',
        link: function (scope, element, attrs, ctrls) {
            var timepickerCtrl = ctrls[0], ngModelCtrl = ctrls[1];

            if (ngModelCtrl) {
                timepickerCtrl.init(ngModelCtrl, element.find('input'));
            }
        }
    };
});

angular.module('ui.bootstrap.typeahead', ['ui.bootstrap.position', 'ui.bootstrap.bindHtml'])

/**
 * A helper service that can parse typeahead's syntax (string provided by users)
 * Extracted to a separate service for ease of unit testing
 */
  .factory('typeaheadParser', ['$parse', function ($parse) {

      //                      00000111000000000000022200000000000000003333333333333330000000000044000
      var TYPEAHEAD_REGEXP = /^\s*([\s\S]+?)(?:\s+as\s+([\s\S]+?))?\s+for\s+(?:([\$\w][\$\w\d]*))\s+in\s+([\s\S]+?)$/;

      return {
          parse: function (input) {

              var match = input.match(TYPEAHEAD_REGEXP);
              if (!match) {
                  throw new Error(
                    'Expected typeahead specification in form of "_modelValue_ (as _label_)? for _item_ in _collection_"' +
                      ' but got "' + input + '".');
              }

              return {
                  itemName: match[3],
                  source: $parse(match[4]),
                  viewMapper: $parse(match[2] || match[1]),
                  modelMapper: $parse(match[1])
              };
          }
      };
  }])

  .directive('typeahead', ['$compile', '$parse', '$q', '$timeout', '$document', '$position', 'typeaheadParser',
    function ($compile, $parse, $q, $timeout, $document, $position, typeaheadParser) {

        var HOT_KEYS = [9, 13, 27, 38, 40];

        return {
            require: 'ngModel',
            link: function (originalScope, element, attrs, modelCtrl) {

                //SUPPORTED ATTRIBUTES (OPTIONS)

                //minimal no of characters that needs to be entered before typeahead kicks-in
                var minSearch = originalScope.$eval(attrs.typeaheadMinLength) || 1;

                //minimal wait time after last character typed before typehead kicks-in
                var waitTime = originalScope.$eval(attrs.typeaheadWaitMs) || 0;

                //should it restrict model values to the ones selected from the popup only?
                var isEditable = originalScope.$eval(attrs.typeaheadEditable) !== false;

                //binding to a variable that indicates if matches are being retrieved asynchronously
                var isLoadingSetter = $parse(attrs.typeaheadLoading).assign || angular.noop;

                //a callback executed when a match is selected
                var onSelectCallback = $parse(attrs.typeaheadOnSelect);

                var inputFormatter = attrs.typeaheadInputFormatter ? $parse(attrs.typeaheadInputFormatter) : undefined;

                var appendToBody = attrs.typeaheadAppendToBody ? originalScope.$eval(attrs.typeaheadAppendToBody) : false;

                var focusFirst = originalScope.$eval(attrs.typeaheadFocusFirst) !== false;

                //INTERNAL VARIABLES

                //model setter executed upon match selection
                var $setModelValue = $parse(attrs.ngModel).assign;

                //expressions used by typeahead
                var parserResult = typeaheadParser.parse(attrs.typeahead);

                var hasFocus;

                //create a child scope for the typeahead directive so we are not polluting original scope
                //with typeahead-specific data (matches, query etc.)
                var scope = originalScope.$new();
                originalScope.$on('$destroy', function () {
                    scope.$destroy();
                });

                // WAI-ARIA
                var popupId = 'typeahead-' + scope.$id + '-' + Math.floor(Math.random() * 10000);
                element.attr({
                    'aria-autocomplete': 'list',
                    'aria-expanded': false,
                    'aria-owns': popupId
                });

                //pop-up element used to display matches
                var popUpEl = angular.element('<div typeahead-popup></div>');
                popUpEl.attr({
                    id: popupId,
                    matches: 'matches',
                    active: 'activeIdx',
                    select: 'select(activeIdx)',
                    query: 'query',
                    position: 'position'
                });
                //custom item template
                if (angular.isDefined(attrs.typeaheadTemplateUrl)) {
                    popUpEl.attr('template-url', attrs.typeaheadTemplateUrl);
                }

                var resetMatches = function () {
                    scope.matches = [];
                    scope.activeIdx = -1;
                    element.attr('aria-expanded', false);
                };

                var getMatchId = function (index) {
                    return popupId + '-option-' + index;
                };

                // Indicate that the specified match is the active (pre-selected) item in the list owned by this typeahead.
                // This attribute is added or removed automatically when the `activeIdx` changes.
                scope.$watch('activeIdx', function (index) {
                    if (index < 0) {
                        element.removeAttr('aria-activedescendant');
                    } else {
                        element.attr('aria-activedescendant', getMatchId(index));
                    }
                });

                var getMatchesAsync = function (inputValue) {

                    var locals = { $viewValue: inputValue };
                    isLoadingSetter(originalScope, true);
                    $q.when(parserResult.source(originalScope, locals)).then(function (matches) {

                        //it might happen that several async queries were in progress if a user were typing fast
                        //but we are interested only in responses that correspond to the current view value
                        var onCurrentRequest = (inputValue === modelCtrl.$viewValue);
                        if (onCurrentRequest && hasFocus) {
                            if (matches.length > 0) {

                                scope.activeIdx = focusFirst ? 0 : -1;
                                scope.matches.length = 0;

                                //transform labels
                                for (var i = 0; i < matches.length; i++) {
                                    locals[parserResult.itemName] = matches[i];
                                    scope.matches.push({
                                        id: getMatchId(i),
                                        label: parserResult.viewMapper(scope, locals),
                                        model: matches[i]
                                    });
                                }

                                scope.query = inputValue;
                                //position pop-up with matches - we need to re-calculate its position each time we are opening a window
                                //with matches as a pop-up might be absolute-positioned and position of an input might have changed on a page
                                //due to other elements being rendered
                                scope.position = appendToBody ? $position.offset(element) : $position.position(element);
                                scope.position.top = scope.position.top + element.prop('offsetHeight');

                                element.attr('aria-expanded', true);
                            } else {
                                resetMatches();
                            }
                        }
                        if (onCurrentRequest) {
                            isLoadingSetter(originalScope, false);
                        }
                    }, function () {
                        resetMatches();
                        isLoadingSetter(originalScope, false);
                    });
                };

                resetMatches();

                //we need to propagate user's query so we can higlight matches
                scope.query = undefined;

                //Declare the timeout promise var outside the function scope so that stacked calls can be cancelled later 
                var timeoutPromise;

                var scheduleSearchWithTimeout = function (inputValue) {
                    timeoutPromise = $timeout(function () {
                        getMatchesAsync(inputValue);
                    }, waitTime);
                };

                var cancelPreviousTimeout = function () {
                    if (timeoutPromise) {
                        $timeout.cancel(timeoutPromise);
                    }
                };

                //plug into $parsers pipeline to open a typeahead on view changes initiated from DOM
                //$parsers kick-in on all the changes coming from the view as well as manually triggered by $setViewValue
                modelCtrl.$parsers.unshift(function (inputValue) {

                    hasFocus = true;

                    if (inputValue && inputValue.length >= minSearch) {
                        if (waitTime > 0) {
                            cancelPreviousTimeout();
                            scheduleSearchWithTimeout(inputValue);
                        } else {
                            getMatchesAsync(inputValue);
                        }
                    } else {
                        isLoadingSetter(originalScope, false);
                        cancelPreviousTimeout();
                        resetMatches();
                    }

                    if (isEditable) {
                        return inputValue;
                    } else {
                        if (!inputValue) {
                            // Reset in case user had typed something previously.
                            modelCtrl.$setValidity('editable', true);
                            return inputValue;
                        } else {
                            modelCtrl.$setValidity('editable', false);
                            return undefined;
                        }
                    }
                });

                modelCtrl.$formatters.push(function (modelValue) {

                    var candidateViewValue, emptyViewValue;
                    var locals = {};

                    if (inputFormatter) {

                        locals.$model = modelValue;
                        return inputFormatter(originalScope, locals);

                    } else {

                        //it might happen that we don't have enough info to properly render input value
                        //we need to check for this situation and simply return model value if we can't apply custom formatting
                        locals[parserResult.itemName] = modelValue;
                        candidateViewValue = parserResult.viewMapper(originalScope, locals);
                        locals[parserResult.itemName] = undefined;
                        emptyViewValue = parserResult.viewMapper(originalScope, locals);

                        return candidateViewValue !== emptyViewValue ? candidateViewValue : modelValue;
                    }
                });

                scope.select = function (activeIdx) {
                    //called from within the $digest() cycle
                    var locals = {};
                    var model, item;

                    locals[parserResult.itemName] = item = scope.matches[activeIdx].model;
                    model = parserResult.modelMapper(originalScope, locals);
                    $setModelValue(originalScope, model);
                    modelCtrl.$setValidity('editable', true);

                    onSelectCallback(originalScope, {
                        $item: item,
                        $model: model,
                        $label: parserResult.viewMapper(originalScope, locals)
                    });

                    resetMatches();

                    //return focus to the input element if a match was selected via a mouse click event
                    // use timeout to avoid $rootScope:inprog error
                    $timeout(function () { element[0].focus(); }, 0, false);
                };

                //bind keyboard events: arrows up(38) / down(40), enter(13) and tab(9), esc(27)
                element.bind('keydown', function (evt) {

                    //typeahead is open and an "interesting" key was pressed
                    if (scope.matches.length === 0 || HOT_KEYS.indexOf(evt.which) === -1) {
                        return;
                    }

                    // if there's nothing selected (i.e. focusFirst) and enter is hit, don't do anything
                    if (scope.activeIdx == -1 && (evt.which === 13 || evt.which === 9)) {
                        return;
                    }

                    evt.preventDefault();

                    if (evt.which === 40) {
                        scope.activeIdx = (scope.activeIdx + 1) % scope.matches.length;
                        scope.$digest();

                    } else if (evt.which === 38) {
                        scope.activeIdx = (scope.activeIdx > 0 ? scope.activeIdx : scope.matches.length) - 1;
                        scope.$digest();

                    } else if (evt.which === 13 || evt.which === 9) {
                        scope.$apply(function () {
                            scope.select(scope.activeIdx);
                        });

                    } else if (evt.which === 27) {
                        evt.stopPropagation();

                        resetMatches();
                        scope.$digest();
                    }
                });

                element.bind('blur', function (evt) {
                    hasFocus = false;
                });

                // Keep reference to click handler to unbind it.
                var dismissClickHandler = function (evt) {
                    if (element[0] !== evt.target) {
                        resetMatches();
                        scope.$digest();
                    }
                };

                $document.bind('click', dismissClickHandler);

                originalScope.$on('$destroy', function () {
                    $document.unbind('click', dismissClickHandler);
                    if (appendToBody) {
                        $popup.remove();
                    }
                });

                var $popup = $compile(popUpEl)(scope);
                if (appendToBody) {
                    $document.find('body').append($popup);
                } else {
                    element.after($popup);
                }
            }
        };

    }])

  .directive('typeaheadPopup', function () {
      return {
          restrict: 'EA',
          scope: {
              matches: '=',
              query: '=',
              active: '=',
              position: '=',
              select: '&'
          },
          replace: true,
          templateUrl: 'template/typeahead/typeahead-popup.html',
          link: function (scope, element, attrs) {

              scope.templateUrl = attrs.templateUrl;

              scope.isOpen = function () {
                  return scope.matches.length > 0;
              };

              scope.isActive = function (matchIdx) {
                  return scope.active == matchIdx;
              };

              scope.selectActive = function (matchIdx) {
                  scope.active = matchIdx;
              };

              scope.selectMatch = function (activeIdx) {
                  scope.select({ activeIdx: activeIdx });
              };
          }
      };
  })

  .directive('typeaheadMatch', ['$http', '$templateCache', '$compile', '$parse', function ($http, $templateCache, $compile, $parse) {
      return {
          restrict: 'EA',
          scope: {
              index: '=',
              match: '=',
              query: '='
          },
          link: function (scope, element, attrs) {
              var tplUrl = $parse(attrs.templateUrl)(scope.$parent) || 'template/typeahead/typeahead-match.html';
              $http.get(tplUrl, { cache: $templateCache }).success(function (tplContent) {
                  element.replaceWith($compile(tplContent.trim())(scope));
              });
          }
      };
  }])

  .filter('typeaheadHighlight', function () {

      function escapeRegexp(queryToEscape) {
          return queryToEscape.replace(/([.?*+^$[\]\\(){}|-])/g, '\\$1');
      }

      return function (matchItem, query) {
          return query ? ('' + matchItem).replace(new RegExp(escapeRegexp(query), 'gi'), '<strong>$&</strong>') : matchItem;
      };
  });

angular.module("template/accordion/accordion-group.html", []).run(["$templateCache", function ($templateCache) {
    $templateCache.put("template/accordion/accordion-group.html",
      "<div class=\"panel panel-default\">\n" +
      "  <div class=\"panel-heading\">\n" +
      "    <h4 class=\"panel-title\">\n" +
      "      <a href class=\"accordion-toggle\" ng-click=\"toggleOpen()\" accordion-transclude=\"heading\"><span ng-class=\"{'text-muted': isDisabled}\">{{heading}}</span></a>\n" +
      "    </h4>\n" +
      "  </div>\n" +
      "  <div class=\"panel-collapse\" collapse=\"!isOpen\">\n" +
      "	  <div class=\"panel-body\" ng-transclude></div>\n" +
      "  </div>\n" +
      "</div>\n" +
      "");
}]);

angular.module("template/accordion/accordion.html", []).run(["$templateCache", function ($templateCache) {
    $templateCache.put("template/accordion/accordion.html",
      "<div class=\"panel-group\" ng-transclude></div>");
}]);

angular.module("template/alert/alert.html", []).run(["$templateCache", function ($templateCache) {
    $templateCache.put("template/alert/alert.html",
      "<div class=\"alert\" ng-class=\"['alert-' + (type || 'warning'), closeable ? 'alert-dismissable' : null]\" role=\"alert\">\n" +
      "    <button ng-show=\"closeable\" type=\"button\" class=\"close\" ng-click=\"close()\">\n" +
      "        <span aria-hidden=\"true\">&times;</span>\n" +
      "        <span class=\"sr-only\">Close</span>\n" +
      "    </button>\n" +
      "    <div ng-transclude></div>\n" +
      "</div>\n" +
      "");
}]);

angular.module("template/carousel/carousel.html", []).run(["$templateCache", function ($templateCache) {
    $templateCache.put("template/carousel/carousel.html",
      "<div ng-mouseenter=\"pause()\" ng-mouseleave=\"play()\" class=\"carousel\" ng-swipe-right=\"prev()\" ng-swipe-left=\"next()\">\n" +
      "    <ol class=\"carousel-indicators\" ng-show=\"slides.length > 1\">\n" +
      "        <li ng-repeat=\"slide in slides track by $index\" ng-class=\"{active: isActive(slide)}\" ng-click=\"select(slide)\"></li>\n" +
      "    </ol>\n" +
      "    <div class=\"carousel-inner\" ng-transclude></div>\n" +
      "    <a class=\"left carousel-control\" ng-click=\"prev()\" ng-show=\"slides.length > 1\"><span class=\"glyphicon glyphicon-chevron-left\"></span></a>\n" +
      "    <a class=\"right carousel-control\" ng-click=\"next()\" ng-show=\"slides.length > 1\"><span class=\"glyphicon glyphicon-chevron-right\"></span></a>\n" +
      "</div>\n" +
      "");
}]);

angular.module("template/carousel/slide.html", []).run(["$templateCache", function ($templateCache) {
    $templateCache.put("template/carousel/slide.html",
      "<div ng-class=\"{\n" +
      "    'active': leaving || (active && !entering),\n" +
      "    'prev': (next || active) && direction=='prev',\n" +
      "    'next': (next || active) && direction=='next',\n" +
      "    'right': direction=='prev',\n" +
      "    'left': direction=='next'\n" +
      "  }\" class=\"item text-center\" ng-transclude></div>\n" +
      "");
}]);

angular.module("template/datepicker/datepicker.html", []).run(["$templateCache", function ($templateCache) {
    $templateCache.put("template/datepicker/datepicker.html",
      "<div ng-switch=\"datepickerMode\" role=\"application\" ng-keydown=\"keydown($event)\">\n" +
      "  <daypicker ng-switch-when=\"day\" tabindex=\"0\"></daypicker>\n" +
      "  <monthpicker ng-switch-when=\"month\" tabindex=\"0\"></monthpicker>\n" +
      "  <yearpicker ng-switch-when=\"year\" tabindex=\"0\"></yearpicker>\n" +
      "</div>");
}]);

angular.module("template/datepicker/day.html", []).run(["$templateCache", function ($templateCache) {
    $templateCache.put("template/datepicker/day.html",
      "<table role=\"grid\" aria-labelledby=\"{{uniqueId}}-title\" aria-activedescendant=\"{{activeDateId}}\">\n" +
      "  <thead>\n" +
      "    <tr>\n" +
      "      <th><button type=\"button\" class=\"btn btn-default btn-sm pull-left\" ng-click=\"move(-1)\" tabindex=\"-1\"><i class=\"glyphicon glyphicon-chevron-left\"></i></button></th>\n" +
      "      <th colspan=\"{{5 + showWeeks}}\"><button id=\"{{uniqueId}}-title\" role=\"heading\" aria-live=\"assertive\" aria-atomic=\"true\" type=\"button\" class=\"btn btn-default btn-sm\" ng-click=\"toggleMode()\" tabindex=\"-1\" style=\"width:100%;\"><strong>{{title}}</strong></button></th>\n" +
      "      <th><button type=\"button\" class=\"btn btn-default btn-sm pull-right\" ng-click=\"move(1)\" tabindex=\"-1\"><i class=\"glyphicon glyphicon-chevron-right\"></i></button></th>\n" +
      "    </tr>\n" +
      "    <tr>\n" +
      "      <th ng-show=\"showWeeks\" class=\"text-center\"></th>\n" +
      "      <th ng-repeat=\"label in labels track by $index\" class=\"text-center\"><small aria-label=\"{{label.full}}\">{{label.abbr}}</small></th>\n" +
      "    </tr>\n" +
      "  </thead>\n" +
      "  <tbody>\n" +
      "    <tr ng-repeat=\"row in rows track by $index\">\n" +
      "      <td ng-show=\"showWeeks\" class=\"text-center h6\"><em>{{ weekNumbers[$index] }}</em></td>\n" +
      "      <td ng-repeat=\"dt in row track by dt.date\" class=\"text-center\" role=\"gridcell\" id=\"{{dt.uid}}\" aria-disabled=\"{{!!dt.disabled}}\">\n" +
      "        <button type=\"button\" style=\"width:100%;\" class=\"btn btn-default btn-sm\" ng-class=\"{'btn-info': dt.selected, active: isActive(dt)}\" ng-click=\"select(dt.date)\" ng-disabled=\"dt.disabled\" tabindex=\"-1\"><span ng-class=\"{'text-muted': dt.secondary, 'text-info': dt.current}\">{{dt.label}}</span></button>\n" +
      "      </td>\n" +
      "    </tr>\n" +
      "  </tbody>\n" +
      "</table>\n" +
      "");
}]);

angular.module("template/datepicker/month.html", []).run(["$templateCache", function ($templateCache) {
    $templateCache.put("template/datepicker/month.html",
      "<table role=\"grid\" aria-labelledby=\"{{uniqueId}}-title\" aria-activedescendant=\"{{activeDateId}}\">\n" +
      "  <thead>\n" +
      "    <tr>\n" +
      "      <th><button type=\"button\" class=\"btn btn-default btn-sm pull-left\" ng-click=\"move(-1)\" tabindex=\"-1\"><i class=\"glyphicon glyphicon-chevron-left\"></i></button></th>\n" +
      "      <th><button id=\"{{uniqueId}}-title\" role=\"heading\" aria-live=\"assertive\" aria-atomic=\"true\" type=\"button\" class=\"btn btn-default btn-sm\" ng-click=\"toggleMode()\" tabindex=\"-1\" style=\"width:100%;\"><strong>{{title}}</strong></button></th>\n" +
      "      <th><button type=\"button\" class=\"btn btn-default btn-sm pull-right\" ng-click=\"move(1)\" tabindex=\"-1\"><i class=\"glyphicon glyphicon-chevron-right\"></i></button></th>\n" +
      "    </tr>\n" +
      "  </thead>\n" +
      "  <tbody>\n" +
      "    <tr ng-repeat=\"row in rows track by $index\">\n" +
      "      <td ng-repeat=\"dt in row track by dt.date\" class=\"text-center\" role=\"gridcell\" id=\"{{dt.uid}}\" aria-disabled=\"{{!!dt.disabled}}\">\n" +
      "        <button type=\"button\" style=\"width:100%;\" class=\"btn btn-default\" ng-class=\"{'btn-info': dt.selected, active: isActive(dt)}\" ng-click=\"select(dt.date)\" ng-disabled=\"dt.disabled\" tabindex=\"-1\"><span ng-class=\"{'text-info': dt.current}\">{{dt.label}}</span></button>\n" +
      "      </td>\n" +
      "    </tr>\n" +
      "  </tbody>\n" +
      "</table>\n" +
      "");
}]);

angular.module("template/datepicker/popup.html", []).run(["$templateCache", function ($templateCache) {
    $templateCache.put("template/datepicker/popup.html",
      "<ul class=\"dropdown-menu\" ng-style=\"{display: (isOpen && 'block') || 'none', top: position.top+'px', left: position.left+'px'}\" ng-keydown=\"keydown($event)\">\n" +
      "	<li ng-transclude></li>\n" +
      "	<li ng-if=\"showButtonBar\" style=\"padding:10px 9px 2px\">\n" +
      "		<span class=\"btn-group pull-left\">\n" +
      "			<button type=\"button\" class=\"btn btn-sm btn-info\" ng-click=\"select('today')\">{{ getText('current') }}</button>\n" +
      "			<button type=\"button\" class=\"btn btn-sm btn-danger\" ng-click=\"select(null)\">{{ getText('clear') }}</button>\n" +
      "		</span>\n" +
      "		<button type=\"button\" class=\"btn btn-sm btn-success pull-right\" ng-click=\"close()\">{{ getText('close') }}</button>\n" +
      "	</li>\n" +
      "</ul>\n" +
      "");
}]);

angular.module("template/datepicker/year.html", []).run(["$templateCache", function ($templateCache) {
    $templateCache.put("template/datepicker/year.html",
      "<table role=\"grid\" aria-labelledby=\"{{uniqueId}}-title\" aria-activedescendant=\"{{activeDateId}}\">\n" +
      "  <thead>\n" +
      "    <tr>\n" +
      "      <th><button type=\"button\" class=\"btn btn-default btn-sm pull-left\" ng-click=\"move(-1)\" tabindex=\"-1\"><i class=\"glyphicon glyphicon-chevron-left\"></i></button></th>\n" +
      "      <th colspan=\"3\"><button id=\"{{uniqueId}}-title\" role=\"heading\" aria-live=\"assertive\" aria-atomic=\"true\" type=\"button\" class=\"btn btn-default btn-sm\" ng-click=\"toggleMode()\" tabindex=\"-1\" style=\"width:100%;\"><strong>{{title}}</strong></button></th>\n" +
      "      <th><button type=\"button\" class=\"btn btn-default btn-sm pull-right\" ng-click=\"move(1)\" tabindex=\"-1\"><i class=\"glyphicon glyphicon-chevron-right\"></i></button></th>\n" +
      "    </tr>\n" +
      "  </thead>\n" +
      "  <tbody>\n" +
      "    <tr ng-repeat=\"row in rows track by $index\">\n" +
      "      <td ng-repeat=\"dt in row track by dt.date\" class=\"text-center\" role=\"gridcell\" id=\"{{dt.uid}}\" aria-disabled=\"{{!!dt.disabled}}\">\n" +
      "        <button type=\"button\" style=\"width:100%;\" class=\"btn btn-default\" ng-class=\"{'btn-info': dt.selected, active: isActive(dt)}\" ng-click=\"select(dt.date)\" ng-disabled=\"dt.disabled\" tabindex=\"-1\"><span ng-class=\"{'text-info': dt.current}\">{{dt.label}}</span></button>\n" +
      "      </td>\n" +
      "    </tr>\n" +
      "  </tbody>\n" +
      "</table>\n" +
      "");
}]);

angular.module("template/modal/backdrop.html", []).run(["$templateCache", function ($templateCache) {
    $templateCache.put("template/modal/backdrop.html",
      "<div class=\"modal-backdrop fade {{ backdropClass }}\"\n" +
      "     ng-class=\"{in: animate}\"\n" +
      "     ng-style=\"{'z-index': 1040 + (index && 1 || 0) + index*10}\"\n" +
      "></div>\n" +
      "");
}]);

angular.module("template/modal/window.html", []).run(["$templateCache", function ($templateCache) {
    $templateCache.put("template/modal/window.html",
      "<div tabindex=\"-1\" role=\"dialog\" class=\"modal fade\" ng-class=\"{in: animate}\" ng-style=\"{'z-index': 1050 + index*10, display: 'block'}\" ng-click=\"close($event)\">\n" +
      "    <div class=\"modal-dialog\" ng-class=\"{'modal-sm': size == 'sm', 'modal-lg': size == 'lg'}\"><div class=\"modal-content\" modal-transclude></div></div>\n" +
      "</div>");
}]);

angular.module("template/pagination/pager.html", []).run(["$templateCache", function ($templateCache) {
    $templateCache.put("template/pagination/pager.html",
      "<ul class=\"pager\">\n" +
      "  <li ng-class=\"{disabled: noPrevious(), previous: align}\"><a href ng-click=\"selectPage(page - 1)\">{{getText('previous')}}</a></li>\n" +
      "  <li ng-class=\"{disabled: noNext(), next: align}\"><a href ng-click=\"selectPage(page + 1)\">{{getText('next')}}</a></li>\n" +
      "</ul>");
}]);

angular.module("template/pagination/pagination.html", []).run(["$templateCache", function ($templateCache) {
    $templateCache.put("template/pagination/pagination.html",
      "<ul class=\"pagination\">\n" +
      "  <li ng-if=\"boundaryLinks\" ng-class=\"{disabled: noPrevious()}\"><a href ng-click=\"selectPage(1)\">{{getText('first')}}</a></li>\n" +
      "  <li ng-if=\"directionLinks\" ng-class=\"{disabled: noPrevious()}\"><a href ng-click=\"selectPage(page - 1)\">{{getText('previous')}}</a></li>\n" +
      "  <li ng-repeat=\"page in pages track by $index\" ng-class=\"{active: page.active}\"><a href ng-click=\"selectPage(page.number)\">{{page.text}}</a></li>\n" +
      "  <li ng-if=\"directionLinks\" ng-class=\"{disabled: noNext()}\"><a href ng-click=\"selectPage(page + 1)\">{{getText('next')}}</a></li>\n" +
      "  <li ng-if=\"boundaryLinks\" ng-class=\"{disabled: noNext()}\"><a href ng-click=\"selectPage(totalPages)\">{{getText('last')}}</a></li>\n" +
      "</ul>");
}]);

angular.module("template/tooltip/tooltip-html-unsafe-popup.html", []).run(["$templateCache", function ($templateCache) {
    $templateCache.put("template/tooltip/tooltip-html-unsafe-popup.html",
      "<div class=\"tooltip {{placement}}\" ng-class=\"{ in: isOpen(), fade: animation() }\">\n" +
      "  <div class=\"tooltip-arrow\"></div>\n" +
      "  <div class=\"tooltip-inner\" bind-html-unsafe=\"content\"></div>\n" +
      "</div>\n" +
      "");
}]);

angular.module("template/tooltip/tooltip-popup.html", []).run(["$templateCache", function ($templateCache) {
    $templateCache.put("template/tooltip/tooltip-popup.html",
      "<div class=\"tooltip {{placement}}\" ng-class=\"{ in: isOpen(), fade: animation() }\">\n" +
      "  <div class=\"tooltip-arrow\"></div>\n" +
      "  <div class=\"tooltip-inner\" ng-bind=\"content\"></div>\n" +
      "</div>\n" +
      "");
}]);

angular.module("template/popover/popover.html", []).run(["$templateCache", function ($templateCache) {
    $templateCache.put("template/popover/popover.html",
      "<div class=\"popover {{placement}}\" ng-class=\"{ in: isOpen(), fade: animation() }\">\n" +
      "  <div class=\"arrow\"></div>\n" +
      "\n" +
      "  <div class=\"popover-inner\">\n" +
      "      <h3 class=\"popover-title\" ng-bind=\"title\" ng-show=\"title\"></h3>\n" +
      "      <div class=\"popover-content\" ng-bind=\"content\"></div>\n" +
      "  </div>\n" +
      "</div>\n" +
      "");
}]);

angular.module("template/progressbar/bar.html", []).run(["$templateCache", function ($templateCache) {
    $templateCache.put("template/progressbar/bar.html",
      "<div class=\"progress-bar\" ng-class=\"type && 'progress-bar-' + type\" role=\"progressbar\" aria-valuenow=\"{{value}}\" aria-valuemin=\"0\" aria-valuemax=\"{{max}}\" ng-style=\"{width: percent + '%'}\" aria-valuetext=\"{{percent | number:0}}%\" ng-transclude></div>");
}]);

angular.module("template/progressbar/progress.html", []).run(["$templateCache", function ($templateCache) {
    $templateCache.put("template/progressbar/progress.html",
      "<div class=\"progress\" ng-transclude></div>");
}]);

angular.module("template/progressbar/progressbar.html", []).run(["$templateCache", function ($templateCache) {
    $templateCache.put("template/progressbar/progressbar.html",
      "<div class=\"progress\">\n" +
      "  <div class=\"progress-bar\" ng-class=\"type && 'progress-bar-' + type\" role=\"progressbar\" aria-valuenow=\"{{value}}\" aria-valuemin=\"0\" aria-valuemax=\"{{max}}\" ng-style=\"{width: percent + '%'}\" aria-valuetext=\"{{percent | number:0}}%\" ng-transclude></div>\n" +
      "</div>");
}]);

angular.module("template/rating/rating.html", []).run(["$templateCache", function ($templateCache) {
    $templateCache.put("template/rating/rating.html",
      "<span ng-mouseleave=\"reset()\" ng-keydown=\"onKeydown($event)\" tabindex=\"0\" role=\"slider\" aria-valuemin=\"0\" aria-valuemax=\"{{range.length}}\" aria-valuenow=\"{{value}}\">\n" +
      "    <i ng-repeat=\"r in range track by $index\" ng-mouseenter=\"enter($index + 1)\" ng-click=\"rate($index + 1)\" class=\"glyphicon\" ng-class=\"$index < value && (r.stateOn || 'glyphicon-star') || (r.stateOff || 'glyphicon-star-empty')\">\n" +
      "        <span class=\"sr-only\">({{ $index < value ? '*' : ' ' }})</span>\n" +
      "    </i>\n" +
      "</span>");
}]);

angular.module("template/tabs/tab.html", []).run(["$templateCache", function ($templateCache) {
    $templateCache.put("template/tabs/tab.html",
      "<li ng-class=\"{active: active, disabled: disabled}\">\n" +
      "  <a href ng-click=\"select()\" tab-heading-transclude>{{heading}}</a>\n" +
      "</li>\n" +
      "");
}]);

angular.module("template/tabs/tabset.html", []).run(["$templateCache", function ($templateCache) {
    $templateCache.put("template/tabs/tabset.html",
      "<div>\n" +
      "  <ul class=\"nav nav-{{type || 'tabs'}}\" ng-class=\"{'nav-stacked': vertical, 'nav-justified': justified}\" ng-transclude></ul>\n" +
      "  <div class=\"tab-content\">\n" +
      "    <div class=\"tab-pane\" \n" +
      "         ng-repeat=\"tab in tabs\" \n" +
      "         ng-class=\"{active: tab.active}\"\n" +
      "         tab-content-transclude=\"tab\">\n" +
      "    </div>\n" +
      "  </div>\n" +
      "</div>\n" +
      "");
}]);

angular.module("template/timepicker/timepicker.html", []).run(["$templateCache", function ($templateCache) {
    $templateCache.put("template/timepicker/timepicker.html",
      "<table>\n" +
      "	<tbody>\n" +
      "		<tr class=\"text-center\">\n" +
      "			<td><a ng-click=\"incrementHours()\" class=\"btn btn-link\"><span class=\"glyphicon glyphicon-chevron-up\"></span></a></td>\n" +
      "			<td>&nbsp;</td>\n" +
      "			<td><a ng-click=\"incrementMinutes()\" class=\"btn btn-link\"><span class=\"glyphicon glyphicon-chevron-up\"></span></a></td>\n" +
      "			<td ng-show=\"showMeridian\"></td>\n" +
      "		</tr>\n" +
      "		<tr>\n" +
      "			<td style=\"width:50px;\" class=\"form-group\" ng-class=\"{'has-error': invalidHours}\">\n" +
      "				<input type=\"text\" ng-model=\"hours\" ng-change=\"updateHours()\" class=\"form-control text-center\" ng-mousewheel=\"incrementHours()\" ng-readonly=\"readonlyInput\" maxlength=\"2\">\n" +
      "			</td>\n" +
      "			<td>:</td>\n" +
      "			<td style=\"width:50px;\" class=\"form-group\" ng-class=\"{'has-error': invalidMinutes}\">\n" +
      "				<input type=\"text\" ng-model=\"minutes\" ng-change=\"updateMinutes()\" class=\"form-control text-center\" ng-readonly=\"readonlyInput\" maxlength=\"2\">\n" +
      "			</td>\n" +
      "			<td ng-show=\"showMeridian\"><button type=\"button\" class=\"btn btn-default text-center\" ng-click=\"toggleMeridian()\">{{meridian}}</button></td>\n" +
      "		</tr>\n" +
      "		<tr class=\"text-center\">\n" +
      "			<td><a ng-click=\"decrementHours()\" class=\"btn btn-link\"><span class=\"glyphicon glyphicon-chevron-down\"></span></a></td>\n" +
      "			<td>&nbsp;</td>\n" +
      "			<td><a ng-click=\"decrementMinutes()\" class=\"btn btn-link\"><span class=\"glyphicon glyphicon-chevron-down\"></span></a></td>\n" +
      "			<td ng-show=\"showMeridian\"></td>\n" +
      "		</tr>\n" +
      "	</tbody>\n" +
      "</table>\n" +
      "");
}]);

angular.module("template/typeahead/typeahead-match.html", []).run(["$templateCache", function ($templateCache) {
    $templateCache.put("template/typeahead/typeahead-match.html",
      "<a tabindex=\"-1\" bind-html-unsafe=\"match.label | typeaheadHighlight:query\"></a>");
}]);

angular.module("template/typeahead/typeahead-popup.html", []).run(["$templateCache", function ($templateCache) {
    $templateCache.put("template/typeahead/typeahead-popup.html",
      "<ul class=\"dropdown-menu\" ng-show=\"isOpen()\" ng-style=\"{top: position.top+'px', left: position.left+'px'}\" style=\"display: block;\" role=\"listbox\" aria-hidden=\"{{!isOpen()}}\">\n" +
      "    <li ng-repeat=\"match in matches track by $index\" ng-class=\"{active: isActive($index) }\" ng-mouseenter=\"selectActive($index)\" ng-click=\"selectMatch($index)\" role=\"option\" id=\"{{match.id}}\">\n" +
      "        <div typeahead-match index=\"$index\" match=\"match\" query=\"query\" template-url=\"templateUrl\"></div>\n" +
      "    </li>\n" +
      "</ul>\n" +
      "");
}]);

/*
 ui-iconpicker v0.1.4
 (c) 2014 Justin Lau http://justin-lau.github.io/ui-iconpicker/
 License: MIT
*/
(function () { var e; (e = function (e, o) { return "function" == typeof define && null != define.amd ? define("values/icon-groups-map", ["angular"], o) : o(e.angular) })(this, function (e) { var o; return o = e.module("ui-iconpicker/values/icon-groups-map", []), o.value("iconGroupsMap", { bootstrap: { prefix: "glyphicon glyphicon-", classes: ["asterisk", "plus", "euro", "minus", "cloud", "envelope", "pencil", "glass", "music", "search", "heart", "star", "star-empty", "user", "film", "th-large", "th", "th-list", "ok", "remove", "zoom-in", "zoom-out", "off", "signal", "cog", "trash", "home", "file", "time", "road", "download-alt", "download", "upload", "inbox", "play-circle", "repeat", "refresh", "list-alt", "lock", "flag", "headphones", "volume-off", "volume-down", "volume-up", "qrcode", "barcode", "tag", "tags", "book", "bookmark", "print", "camera", "font", "bold", "italic", "text-height", "text-width", "align-left", "align-center", "align-right", "align-justify", "list", "indent-left", "indent-right", "facetime-video", "picture", "map-marker", "adjust", "tint", "edit", "share", "check", "move", "step-backward", "fast-backward", "backward", "play", "pause", "stop", "forward", "fast-forward", "step-forward", "eject", "chevron-left", "chevron-right", "plus-sign", "minus-sign", "remove-sign", "ok-sign", "question-sign", "info-sign", "screenshot", "remove-circle", "ok-circle", "ban-circle", "arrow-left", "arrow-right", "arrow-up", "arrow-down", "share-alt", "resize-full", "resize-small", "exclamation-sign", "gift", "leaf", "fire", "eye-open", "eye-close", "warning-sign", "plane", "calendar", "random", "comment", "magnet", "chevron-up", "chevron-down", "retweet", "shopping-cart", "folder-close", "folder-open", "resize-vertical", "resize-horizontal", "hdd", "bullhorn", "bell", "certificate", "thumbs-up", "thumbs-down", "hand-right", "hand-left", "hand-up", "hand-down", "circle-arrow-right", "circle-arrow-left", "circle-arrow-up", "circle-arrow-down", "globe", "wrench", "tasks", "filter", "briefcase", "fullscreen", "dashboard", "paperclip", "heart-empty", "link", "phone", "pushpin", "usd", "gbp", "sort", "sort-by-alphabet", "sort-by-alphabet-alt", "sort-by-order", "sort-by-order-alt", "sort-by-attributes", "sort-by-attributes-alt", "unchecked", "expand", "collapse-down", "collapse-up", "log-in", "flash", "log-out", "new-window", "record", "save", "open", "saved", "import", "export", "send", "floppy-disk", "floppy-saved", "floppy-remove", "floppy-save", "floppy-open", "credit-card", "transfer", "cutlery", "header", "compressed", "earphone", "phone-alt", "tower", "stats", "sd-video", "hd-video", "subtitles", "sound-stereo", "sound-dolby", "sound-5-1", "sound-6-1", "sound-7-1", "copyright-mark", "registration-mark", "cloud-download", "cloud-upload", "tree-conifer", "tree-deciduous"] }, "font-awesome": { prefix: "fa fa-lg fa-", classes: ["glass", "music", "search", "envelope-o", "heart", "star", "star-o", "user", "film", "th-large", "th", "th-list", "check", "times", "search-plus", "search-minus", "power-off", "signal", "gear", "cog", "trash-o", "home", "file-o", "clock-o", "road", "download", "arrow-circle-o-down", "arrow-circle-o-up", "inbox", "play-circle-o", "rotate-right", "repeat", "refresh", "list-alt", "lock", "flag", "headphones", "volume-off", "volume-down", "volume-up", "qrcode", "barcode", "tag", "tags", "book", "bookmark", "print", "camera", "font", "bold", "italic", "text-height", "text-width", "align-left", "align-center", "align-right", "align-justify", "list", "dedent", "outdent", "indent", "video-camera", "picture-o", "pencil", "map-marker", "adjust", "tint", "edit", "pencil-square-o", "share-square-o", "check-square-o", "arrows", "step-backward", "fast-backward", "backward", "play", "pause", "stop", "forward", "fast-forward", "step-forward", "eject", "chevron-left", "chevron-right", "plus-circle", "minus-circle", "times-circle", "check-circle", "question-circle", "info-circle", "crosshairs", "times-circle-o", "check-circle-o", "ban", "arrow-left", "arrow-right", "arrow-up", "arrow-down", "mail-forward", "share", "expand", "compress", "plus", "minus", "asterisk", "exclamation-circle", "gift", "leaf", "fire", "eye", "eye-slash", "warning", "exclamation-triangle", "plane", "calendar", "random", "comment", "magnet", "chevron-up", "chevron-down", "retweet", "shopping-cart", "folder", "folder-open", "arrows-v", "arrows-h", "bar-chart-o", "twitter-square", "facebook-square", "camera-retro", "key", "gears", "cogs", "comments", "thumbs-o-up", "thumbs-o-down", "star-half", "heart-o", "sign-out", "linkedin-square", "thumb-tack", "external-link", "sign-in", "trophy", "github-square", "upload", "lemon-o", "phone", "square-o", "bookmark-o", "phone-square", "twitter", "facebook", "github", "unlock", "credit-card", "rss", "hdd-o", "bullhorn", "bell", "certificate", "hand-o-right", "hand-o-left", "hand-o-up", "hand-o-down", "arrow-circle-left", "arrow-circle-right", "arrow-circle-up", "arrow-circle-down", "globe", "wrench", "tasks", "filter", "briefcase", "arrows-alt", "group", "users", "chain", "link", "cloud", "flask", "cut", "scissors", "copy", "files-o", "paperclip", "save", "floppy-o", "square", "bars", "list-ul", "list-ol", "strikethrough", "underline", "table", "magic", "truck", "pinterest", "pinterest-square", "google-plus-square", "google-plus", "money", "caret-down", "caret-up", "caret-left", "caret-right", "columns", "unsorted", "sort", "sort-down", "sort-asc", "sort-up", "sort-desc", "envelope", "linkedin", "rotate-left", "undo", "legal", "gavel", "dashboard", "tachometer", "comment-o", "comments-o", "flash", "bolt", "sitemap", "umbrella", "paste", "clipboard", "lightbulb-o", "exchange", "cloud-download", "cloud-upload", "user-md", "stethoscope", "suitcase", "bell-o", "coffee", "cutlery", "file-text-o", "building-o", "hospital-o", "ambulance", "medkit", "fighter-jet", "beer", "h-square", "plus-square", "angle-double-left", "angle-double-right", "angle-double-up", "angle-double-down", "angle-left", "angle-right", "angle-up", "angle-down", "desktop", "laptop", "tablet", "mobile-phone", "mobile", "circle-o", "quote-left", "quote-right", "spinner", "circle", "mail-reply", "reply", "github-alt", "folder-o", "folder-open-o", "smile-o", "frown-o", "meh-o", "gamepad", "keyboard-o", "flag-o", "flag-checkered", "terminal", "code", "reply-all", "mail-reply-all", "star-half-empty", "star-half-full", "star-half-o", "location-arrow", "crop", "code-fork", "unlink", "chain-broken", "question", "info", "exclamation", "superscript", "subscript", "eraser", "puzzle-piece", "microphone", "microphone-slash", "shield", "calendar-o", "fire-extinguisher", "rocket", "maxcdn", "chevron-circle-left", "chevron-circle-right", "chevron-circle-up", "chevron-circle-down", "html5", "css3", "anchor", "unlock-alt", "bullseye", "ellipsis-h", "ellipsis-v", "rss-square", "play-circle", "ticket", "minus-square", "minus-square-o", "level-up", "level-down", "check-square", "pencil-square", "external-link-square", "share-square", "compass", "toggle-down", "caret-square-o-down", "toggle-up", "caret-square-o-up", "toggle-right", "caret-square-o-right", "euro", "eur", "gbp", "dollar", "usd", "rupee", "inr", "cny", "rmb", "yen", "jpy", "ruble", "rouble", "rub", "won", "krw", "bitcoin", "btc", "file", "file-text", "sort-alpha-asc", "sort-alpha-desc", "sort-amount-asc", "sort-amount-desc", "sort-numeric-asc", "sort-numeric-desc", "thumbs-up", "thumbs-down", "youtube-square", "youtube", "xing", "xing-square", "youtube-play", "dropbox", "stack-overflow", "instagram", "flickr", "adn", "bitbucket", "bitbucket-square", "tumblr", "tumblr-square", "long-arrow-down", "long-arrow-up", "long-arrow-left", "long-arrow-right", "apple", "windows", "android", "linux", "dribbble", "skype", "foursquare", "trello", "female", "male", "gittip", "sun-o", "moon-o", "archive", "bug", "vk", "weibo", "renren", "pagelines", "stack-exchange", "arrow-circle-o-right", "arrow-circle-o-left", "toggle-left", "caret-square-o-left", "dot-circle-o", "wheelchair", "vimeo-square", "turkish-lira", "try", "plus-square-o"] } }) }) }).call(this), function () { var e; (e = function (e, o) { return "function" == typeof define && null != define.amd ? define("services/IconGroupCollection", ["angular", "values/icon-groups-map"], o) : o(e.angular) })(this, function (e) { var o; return o = e.module("ui-iconpicker/services/IconGroupCollection", ["ui-iconpicker/values/icon-groups-map"]), o.factory("IconGroupCollection", ["iconGroupsMap", function (e) { var o; return o = function () { function o(e) { null == e && (e = "bootstrap"), this.iconGroupsMap = {}, this.includeGroups(e) } return o.prototype.filterByGroups = function (e) { var o, r, a, t; if (null == e && (e = "bootstrap"), "all" !== e) { a = e.split(" "), t = this.iconGroupsMap; for (r in t) o = t[r], -1 !== a.indexOf(r) && delete this.iconGroupsMap[r] } return this }, o.prototype.includeGroups = function (o) { var r, a, t; null == o && (o = "bootstrap"), t = o.split(" "); for (a in e) r = e[a], null == this.iconGroupsMap[a] && ("all" === o || -1 !== t.indexOf(a)) && (this.iconGroupsMap[a] = r); return this }, o.prototype.getClassArray = function () { var e, o, r, a, t, n, l, i; e = [], l = this.iconGroupsMap; for (a in l) for (o = l[a], i = o.classes, t = 0, n = i.length; n > t; t++)r = i[t], e.push(o.prefix + r); return e }, o }() }]) }) }.call(this), function () { var e; (e = function (e, o) { return "function" == typeof define && null != define.amd ? define("templates/iconpicker", ["angular", "angular-bootstrap"], o) : o(e.angular) })(this, function (e) { var o; return o = e.module("ui-iconpicker/templates/iconpicker", ["ui.bootstrap"]), o.run(["$templateCache", function (e) { return e.put("templates/iconpicker.html", '<span class="btn-group ui-iconpicker" ng-class="{ disabled: disabled }">\n	<button type="button" data-toggle="dropdown" class="btn btn-default dropdown-toggle"><i class="{{ iconClass }}"></i><span class="caret"></span>\n	</button>\n	<ul class="dropdown-menu" role="menu">\n		<li ng-repeat="class in availableIconClasses">\n			<button class="btn btn-default" type="button" ng-click="$parent.iconClass = class"><span class="{{ class }}"></span></button>\n		</li>\n	</ul>\n	<input name="{{ name }}" type="hidden" value="{{ iconClass }}" ng-if="name" />\n</span>') }]) }) }.call(this), function () { var e; (e = function (e, o) { return "function" == typeof define && null != define.amd ? define("directives/ui-iconpicker", ["angular", "services/IconGroupCollection", "templates/iconpicker"], o) : o(e.angular) })(this, function (e) { var o; return o = e.module("ui-iconpicker/directives/ui-iconpicker", ["ui-iconpicker/services/IconGroupCollection", "ui-iconpicker/templates/iconpicker"]), o.directive("uiIconpicker", ["IconGroupCollection", function (e) { return { replace: !0, restrict: "E", scope: { name: "@", model: "=?ngModel" }, templateUrl: "templates/iconpicker.html", link: function (o, r, a) { var t; return o.availableIconClasses = new e(a.groups).getClassArray(), o.iconClass = null != (t = a.value) ? t : o.availableIconClasses[0], a.ngModel && (o.model = o[a.ngModel], o.$watch("iconClass", function () { return o.model = o.iconClass }), o.$watch("model", function () { return o.iconClass = o.model })), o.$dropdownButton = r.find("button").eq(0), o.disabled = null != a.disabled } } }]) }) }.call(this), function () { var e; (e = function (e, o) { return "function" == typeof define && null != define.amd ? define("ui-iconpicker", ["angular", "directives/ui-iconpicker"], o) : o(e.angular) })(this, function (e) { return e.module("ui-iconpicker", ["ui-iconpicker/directives/ui-iconpicker"]) }) }.call(this);
/**
 * dirPagination - AngularJS module for paginating (almost) anything.
 *
 *
 * Credits
 * =======
 *
 * Daniel Tabuenca: https://groups.google.com/d/msg/angular/an9QpzqIYiM/r8v-3W1X5vcJ
 * for the idea on how to dynamically invoke the ng-repeat directive.
 *
 * I borrowed a couple of lines and a few attribute names from the AngularUI Bootstrap project:
 * https://github.com/angular-ui/bootstrap/blob/master/src/pagination/pagination.js
 *
 * Copyright 2014 Michael Bromley <michael@michaelbromley.co.uk>
 */
(function () {
    /**
     * Config
     */
    var moduleName = 'angularUtils.directives.dirPagination';
    var DEFAULT_ID = '__default';
    /**
     * Module
     */
    var module;
    try {
        module = angular.module(moduleName);
    }
    catch (err) {
        // named module does not exist, so create one
        module = angular.module(moduleName, []);
    }
    module
        .directive('dirPaginate', ['$compile', '$parse', 'paginationService', dirPaginateDirective])
        .directive('dirPaginateNoCompile', noCompileDirective)
        .directive('dirPaginationControls', ['paginationService', 'paginationTemplate', dirPaginationControlsDirective])
        .filter('itemsPerPage', ['paginationService', itemsPerPageFilter])
        .service('paginationService', paginationService)
        .provider('paginationTemplate', paginationTemplateProvider)
        .run(['$templateCache', dirPaginationControlsTemplateInstaller]);
    function dirPaginateDirective($compile, $parse, paginationService) {
        return {
            terminal: true,
            multiElement: true,
            compile: dirPaginationCompileFn
        };
        function dirPaginationCompileFn(tElement, tAttrs) {
            var expression = tAttrs.dirPaginate;
            // regex taken directly from https://github.com/angular/angular.js/blob/master/src/ng/directive/ngRepeat.js#L211
            var match = expression.match(/^\s*([\s\S]+?)\s+in\s+([\s\S]+?)(?:\s+track\s+by\s+([\s\S]+?))?\s*$/);
            var filterPattern = /\|\s*itemsPerPage\s*:[^|\)]*/;
            if (match[2].match(filterPattern) === null) {
                throw 'pagination directive: the \'itemsPerPage\' filter must be set.';
            }
            var itemsPerPageFilterRemoved = match[2].replace(filterPattern, '');
            var collectionGetter = $parse(itemsPerPageFilterRemoved);
            addNoCompileAttributes(tElement);
            // If any value is specified for paginationId, we register the un-evaluated expression at this stage for the benefit of any
            // dir-pagination-controls directives that may be looking for this ID.
            var rawId = tAttrs.paginationId || DEFAULT_ID;
            paginationService.registerInstance(rawId);
            return function dirPaginationLinkFn(scope, element, attrs) {
                // Now that we have access to the `scope` we can interpolate any expression given in the paginationId attribute and
                // potentially register a new ID if it evaluates to a different value than the rawId.
                var paginationId = $parse(attrs.paginationId)(scope) || attrs.paginationId || DEFAULT_ID;
                paginationService.registerInstance(paginationId);
                var repeatExpression = getRepeatExpression(expression, paginationId);
                addNgRepeatToElement(element, attrs, repeatExpression);
                removeTemporaryAttributes(element);
                var compiled = $compile(element);
                var currentPageGetter = makeCurrentPageGetterFn(scope, attrs, paginationId);
                paginationService.setCurrentPageParser(paginationId, currentPageGetter, scope);
                if (typeof attrs.totalItems !== 'undefined') {
                    paginationService.setAsyncModeTrue(paginationId);
                    scope.$watch(function () {
                        return $parse(attrs.totalItems)(scope);
                    }, function (result) {
                        if (0 <= result) {
                            paginationService.setCollectionLength(paginationId, result);
                        }
                    });
                }
                else {
                    scope.$watchCollection(function () {
                        return collectionGetter(scope);
                    }, function (collection) {
                        if (collection) {
                            paginationService.setCollectionLength(paginationId, collection.length);
                        }
                    });
                }
                // Delegate to the link function returned by the new compilation of the ng-repeat
                compiled(scope);
            };
        }
        /**
         * If a pagination id has been specified, we need to check that it is present as the second argument passed to
         * the itemsPerPage filter. If it is not there, we add it and return the modified expression.
         *
         * @param expression
         * @param paginationId
         * @returns {*}
         */
        function getRepeatExpression(expression, paginationId) {
            var repeatExpression, idDefinedInFilter = !!expression.match(/(\|\s*itemsPerPage\s*:[^|]*:[^|]*)/);
            if (paginationId !== DEFAULT_ID && !idDefinedInFilter) {
                repeatExpression = expression.replace(/(\|\s*itemsPerPage\s*:[^|]*)/, "$1 : '" + paginationId + "'");
            }
            else {
                repeatExpression = expression;
            }
            return repeatExpression;
        }
        /**
         * Adds the ng-repeat directive to the element. In the case of multi-element (-start, -end) it adds the
         * appropriate multi-element ng-repeat to the first and last element in the range.
         * @param element
         * @param attrs
         * @param repeatExpression
         */
        function addNgRepeatToElement(element, attrs, repeatExpression) {
            if (element[0].hasAttribute('dir-paginate-start') || element[0].hasAttribute('data-dir-paginate-start')) {
                // using multiElement mode (dir-paginate-start, dir-paginate-end)
                attrs.$set('ngRepeatStart', repeatExpression);
                element.eq(element.length - 1).attr('ng-repeat-end', true);
            }
            else {
                attrs.$set('ngRepeat', repeatExpression);
            }
        }
        /**
         * Adds the dir-paginate-no-compile directive to each element in the tElement range.
         * @param tElement
         */
        function addNoCompileAttributes(tElement) {
            angular.forEach(tElement, function (el) {
                if (el.nodeType === 1) {
                    angular.element(el).attr('dir-paginate-no-compile', '');
                }
            });
        }
        /**
         * Removes the variations on dir-paginate (data-, -start, -end) and the dir-paginate-no-compile directives.
         * @param element
         */
        function removeTemporaryAttributes(element) {
            angular.forEach(element, function (el) {
                if (el.nodeType === 1) {
                    angular.element(el).removeAttr('dir-paginate-no-compile');
                }
            });
            element.eq(0).removeAttr('dir-paginate-start').removeAttr('dir-paginate').removeAttr('data-dir-paginate-start').removeAttr('data-dir-paginate');
            element.eq(element.length - 1).removeAttr('dir-paginate-end').removeAttr('data-dir-paginate-end');
        }
        /**
         * Creates a getter function for the current-page attribute, using the expression provided or a default value if
         * no current-page expression was specified.
         *
         * @param scope
         * @param attrs
         * @param paginationId
         * @returns {*}
         */
        function makeCurrentPageGetterFn(scope, attrs, paginationId) {
            var currentPageGetter;
            if (attrs.currentPage) {
                currentPageGetter = $parse(attrs.currentPage);
            }
            else {
                // if the current-page attribute was not set, we'll make our own
                var defaultCurrentPage = paginationId + '__currentPage';
                scope[defaultCurrentPage] = 1;
                currentPageGetter = $parse(defaultCurrentPage);
            }
            return currentPageGetter;
        }
    }
    /**
     * This is a helper directive that allows correct compilation when in multi-element mode (ie dir-paginate-start, dir-paginate-end).
     * It is dynamically added to all elements in the dir-paginate compile function, and it prevents further compilation of
     * any inner directives. It is then removed in the link function, and all inner directives are then manually compiled.
     */
    function noCompileDirective() {
        return {
            priority: 5000,
            terminal: true
        };
    }
    function dirPaginationControlsTemplateInstaller($templateCache) {
        $templateCache.put('angularUtils.directives.dirPagination.template', '<ul class="pagination" ng-if="1 < pages.length || !autoHide"><li ng-if="boundaryLinks" ng-class="{ disabled : pagination.current == 1 }"><a href="" ng-click="setCurrent(1)">&laquo;</a></li><li ng-if="directionLinks" ng-class="{ disabled : pagination.current == 1 }"><a href="" ng-click="setCurrent(pagination.current - 1)">&lsaquo;</a></li><li ng-repeat="pageNumber in pages track by tracker(pageNumber, $index)" ng-class="{ active : pagination.current == pageNumber, disabled : pageNumber == \'...\' || ( ! autoHide && pages.length === 1 ) }"><a href="" ng-click="setCurrent(pageNumber)">{{ pageNumber }}</a></li><li ng-if="directionLinks" ng-class="{ disabled : pagination.current == pagination.last }"><a href="" ng-click="setCurrent(pagination.current + 1)">&rsaquo;</a></li><li ng-if="boundaryLinks"  ng-class="{ disabled : pagination.current == pagination.last }"><a href="" ng-click="setCurrent(pagination.last)">&raquo;</a></li></ul>');
    }
    function dirPaginationControlsDirective(paginationService, paginationTemplate) {
        var numberRegex = /^\d+$/;
        return {
            restrict: 'AE',
            templateUrl: function (elem, attrs) {
                return attrs.templateUrl || paginationTemplate.getPath();
            },
            scope: {
                maxSize: '=?',
                onPageChange: '&?',
                paginationId: '=?',
                autoHide: '=?'
            },
            link: dirPaginationControlsLinkFn
        };
        function dirPaginationControlsLinkFn(scope, element, attrs) {
            // rawId is the un-interpolated value of the pagination-id attribute. This is only important when the corresponding dir-paginate directive has
            // not yet been linked (e.g. if it is inside an ng-if block), and in that case it prevents this controls directive from assuming that there is
            // no corresponding dir-paginate directive and wrongly throwing an exception.
            var rawId = attrs.paginationId || DEFAULT_ID;
            var paginationId = scope.paginationId || attrs.paginationId || DEFAULT_ID;
            if (!paginationService.isRegistered(paginationId) && !paginationService.isRegistered(rawId)) {
                var idMessage = (paginationId !== DEFAULT_ID) ? ' (id: ' + paginationId + ') ' : ' ';
                console.warn('Pagination directive: the pagination controls' + idMessage + 'cannot be used without the corresponding pagination directive, which was not found at link time.');
            }
            if (!scope.maxSize) {
                scope.maxSize = 9;
            }
            scope.autoHide = scope.autoHide === undefined ? true : scope.autoHide;
            scope.directionLinks = angular.isDefined(attrs.directionLinks) ? scope.$parent.$eval(attrs.directionLinks) : true;
            scope.boundaryLinks = angular.isDefined(attrs.boundaryLinks) ? scope.$parent.$eval(attrs.boundaryLinks) : false;
            var paginationRange = Math.max(scope.maxSize, 5);
            scope.pages = [];
            scope.pagination = {
                last: 1,
                current: 1
            };
            scope.range = {
                lower: 1,
                upper: 1,
                total: 1
            };
            scope.$watch(function () {
                if (paginationService.isRegistered(paginationId)) {
                    return (paginationService.getCollectionLength(paginationId) + 1) * paginationService.getItemsPerPage(paginationId);
                }
            }, function (length) {
                if (0 < length) {
                    generatePagination();
                }
            });
            scope.$watch(function () {
                if (paginationService.isRegistered(paginationId)) {
                    return (paginationService.getItemsPerPage(paginationId));
                }
            }, function (current, previous) {
                if (current != previous && typeof previous !== 'undefined') {
                    goToPage(scope.pagination.current);
                }
            });
            scope.$watch(function () {
                if (paginationService.isRegistered(paginationId)) {
                    return paginationService.getCurrentPage(paginationId);
                }
            }, function (currentPage, previousPage) {
                if (currentPage != previousPage) {
                    goToPage(currentPage);
                }
            });
            scope.setCurrent = function (num) {
                if (paginationService.isRegistered(paginationId) && isValidPageNumber(num)) {
                    num = parseInt(num, 10);
                    paginationService.setCurrentPage(paginationId, num);
                }
            };
            /**
             * Custom "track by" function which allows for duplicate "..." entries on long lists,
             * yet fixes the problem of wrongly-highlighted links which happens when using
             * "track by $index" - see https://github.com/michaelbromley/angularUtils/issues/153
             * @param id
             * @param index
             * @returns {string}
             */
            scope.tracker = function (id, index) {
                return id + '_' + index;
            };
            function goToPage(num) {
                if (paginationService.isRegistered(paginationId) && isValidPageNumber(num)) {
                    scope.pages = generatePagesArray(num, paginationService.getCollectionLength(paginationId), paginationService.getItemsPerPage(paginationId), paginationRange);
                    scope.pagination.current = num;
                    updateRangeValues();
                    // if a callback has been set, then call it with the page number as an argument
                    if (scope.onPageChange) {
                        scope.onPageChange({ newPageNumber: num });
                    }
                }
            }
            function generatePagination() {
                if (paginationService.isRegistered(paginationId)) {
                    var page = parseInt(paginationService.getCurrentPage(paginationId)) || 1;
                    scope.pages = generatePagesArray(page, paginationService.getCollectionLength(paginationId), paginationService.getItemsPerPage(paginationId), paginationRange);
                    scope.pagination.current = page;
                    scope.pagination.last = scope.pages[scope.pages.length - 1];
                    if (scope.pagination.last < scope.pagination.current) {
                        scope.setCurrent(scope.pagination.last);
                    }
                    else {
                        updateRangeValues();
                    }
                }
            }
            /**
             * This function updates the values (lower, upper, total) of the `scope.range` object, which can be used in the pagination
             * template to display the current page range, e.g. "showing 21 - 40 of 144 results";
             */
            function updateRangeValues() {
                if (paginationService.isRegistered(paginationId)) {
                    var currentPage = paginationService.getCurrentPage(paginationId), itemsPerPage = paginationService.getItemsPerPage(paginationId), totalItems = paginationService.getCollectionLength(paginationId);
                    scope.range.lower = (currentPage - 1) * itemsPerPage + 1;
                    scope.range.upper = Math.min(currentPage * itemsPerPage, totalItems);
                    scope.range.total = totalItems;
                }
            }
            function isValidPageNumber(num) {
                return (numberRegex.test(num) && (0 < num && num <= scope.pagination.last));
            }
        }
        /**
         * Generate an array of page numbers (or the '...' string) which is used in an ng-repeat to generate the
         * links used in pagination
         *
         * @param currentPage
         * @param rowsPerPage
         * @param paginationRange
         * @param collectionLength
         * @returns {Array}
         */
        function generatePagesArray(currentPage, collectionLength, rowsPerPage, paginationRange) {
            var pages = [];
            var totalPages = Math.ceil(collectionLength / rowsPerPage);
            var halfWay = Math.ceil(paginationRange / 2);
            var position;
            if (currentPage <= halfWay) {
                position = 'start';
            }
            else if (totalPages - halfWay < currentPage) {
                position = 'end';
            }
            else {
                position = 'middle';
            }
            var ellipsesNeeded = paginationRange < totalPages;
            var i = 1;
            while (i <= totalPages && i <= paginationRange) {
                var pageNumber = calculatePageNumber(i, currentPage, paginationRange, totalPages);
                var openingEllipsesNeeded = (i === 2 && (position === 'middle' || position === 'end'));
                var closingEllipsesNeeded = (i === paginationRange - 1 && (position === 'middle' || position === 'start'));
                if (ellipsesNeeded && (openingEllipsesNeeded || closingEllipsesNeeded)) {
                    pages.push('...');
                }
                else {
                    pages.push(pageNumber);
                }
                i++;
            }
            return pages;
        }
        /**
         * Given the position in the sequence of pagination links [i], figure out what page number corresponds to that position.
         *
         * @param i
         * @param currentPage
         * @param paginationRange
         * @param totalPages
         * @returns {*}
         */
        function calculatePageNumber(i, currentPage, paginationRange, totalPages) {
            var halfWay = Math.ceil(paginationRange / 2);
            if (i === paginationRange) {
                return totalPages;
            }
            else if (i === 1) {
                return i;
            }
            else if (paginationRange < totalPages) {
                if (totalPages - halfWay < currentPage) {
                    return totalPages - paginationRange + i;
                }
                else if (halfWay < currentPage) {
                    return currentPage - halfWay + i;
                }
                else {
                    return i;
                }
            }
            else {
                return i;
            }
        }
    }
    /**
     * This filter slices the collection into pages based on the current page number and number of items per page.
     * @param paginationService
     * @returns {Function}
     */
    function itemsPerPageFilter(paginationService) {
        return function (collection, itemsPerPage, paginationId) {
            if (typeof (paginationId) === 'undefined') {
                paginationId = DEFAULT_ID;
            }
            if (!paginationService.isRegistered(paginationId)) {
                throw 'pagination directive: the itemsPerPage id argument (id: ' + paginationId + ') does not match a registered pagination-id.';
            }
            var end;
            var start;
            if (collection instanceof Array) {
                itemsPerPage = parseInt(itemsPerPage) || 9999999999;
                if (paginationService.isAsyncMode(paginationId)) {
                    start = 0;
                }
                else {
                    start = (paginationService.getCurrentPage(paginationId) - 1) * itemsPerPage;
                }
                end = start + itemsPerPage;
                paginationService.setItemsPerPage(paginationId, itemsPerPage);
                return collection.slice(start, end);
            }
            else {
                return collection;
            }
        };
    }
    /**
     * This service allows the various parts of the module to communicate and stay in sync.
     */
    function paginationService() {
        var instances = {};
        var lastRegisteredInstance;
        this.registerInstance = function (instanceId) {
            if (typeof instances[instanceId] === 'undefined') {
                instances[instanceId] = {
                    asyncMode: false
                };
                lastRegisteredInstance = instanceId;
            }
        };
        this.isRegistered = function (instanceId) {
            return (typeof instances[instanceId] !== 'undefined');
        };
        this.getLastInstanceId = function () {
            return lastRegisteredInstance;
        };
        this.setCurrentPageParser = function (instanceId, val, scope) {
            instances[instanceId].currentPageParser = val;
            instances[instanceId].context = scope;
        };
        this.setCurrentPage = function (instanceId, val) {
            instances[instanceId].currentPageParser.assign(instances[instanceId].context, val);
        };
        this.getCurrentPage = function (instanceId) {
            var parser = instances[instanceId].currentPageParser;
            return parser ? parser(instances[instanceId].context) : 1;
        };
        this.setItemsPerPage = function (instanceId, val) {
            instances[instanceId].itemsPerPage = val;
        };
        this.getItemsPerPage = function (instanceId) {
            return instances[instanceId].itemsPerPage;
        };
        this.setCollectionLength = function (instanceId, val) {
            instances[instanceId].collectionLength = val;
        };
        this.getCollectionLength = function (instanceId) {
            return instances[instanceId].collectionLength;
        };
        this.setAsyncModeTrue = function (instanceId) {
            instances[instanceId].asyncMode = true;
        };
        this.isAsyncMode = function (instanceId) {
            return instances[instanceId].asyncMode;
        };
    }
    /**
     * This provider allows global configuration of the template path used by the dir-pagination-controls directive.
     */
    function paginationTemplateProvider() {
        var templatePath = 'angularUtils.directives.dirPagination.template';
        this.setPath = function (path) {
            templatePath = path;
        };
        this.$get = function () {
            return {
                getPath: function () {
                    return templatePath;
                }
            };
        };
    }
})();
//# sourceMappingURL=dirPagination.js.map
/*
 *	jQuery dotdotdot 1.8.3
 *
 *	Copyright (c) Fred Heusschen
 *	www.frebsite.nl
 *
 *	Plugin website:
 *	dotdotdot.frebsite.nl
 *
 *	Licensed under the MIT license.
 *	http://en.wikipedia.org/wiki/MIT_License
 */

(function ($, undef) {
    if ($.fn.dotdotdot) {
        return;
    }

    $.fn.dotdotdot = function (o) {
        if (this.length == 0) {
            $.fn.dotdotdot.debug('No element found for "' + this.selector + '".');
            return this;
        }
        if (this.length > 1) {
            return this.each(
                function () {
                    $(this).dotdotdot(o);
                }
            );
        }


        var $dot = this;
        var orgContent = $dot.contents();

        if ($dot.data('dotdotdot')) {
            $dot.trigger('destroy.dot');
        }

        $dot.data('dotdotdot-style', $dot.attr('style') || '');
        $dot.css('word-wrap', 'break-word');
        if ($dot.css('white-space') === 'nowrap') {
            $dot.css('white-space', 'normal');
        }

        $dot.bind_events = function () {
            $dot.bind(
                'update.dot',
                function (e, c) {
                    $dot.removeClass("is-truncated");
                    e.preventDefault();
                    e.stopPropagation();

                    switch (typeof opts.height) {
                        case 'number':
                            opts.maxHeight = opts.height;
                            break;

                        case 'function':
                            opts.maxHeight = opts.height.call($dot[0]);
                            break;

                        default:
                            opts.maxHeight = getTrueInnerHeight($dot);
                            break;
                    }

                    opts.maxHeight += opts.tolerance;

                    if (typeof c != 'undefined') {
                        if (typeof c == 'string' || ('nodeType' in c && c.nodeType === 1)) {
                            c = $('<div />').append(c).contents();
                        }
                        if (c instanceof $) {
                            orgContent = c;
                        }
                    }

                    $inr = $dot.wrapInner('<div class="dotdotdot" />').children();
                    $inr.contents()
                        .detach()
                        .end()
                        .append(orgContent.clone(true))
                        .find('br')
                        .replaceWith('  <br />  ')
                        .end()
                        .css({
                            'height': 'auto',
                            'width': 'auto',
                            'border': 'none',
                            'padding': 0,
                            'margin': 0
                        });

                    var after = false,
                        trunc = false;

                    if (conf.afterElement) {
                        after = conf.afterElement.clone(true);
                        after.show();
                        conf.afterElement.detach();
                    }

                    if (test($inr, opts)) {
                        if (opts.wrap == 'children') {
                            trunc = children($inr, opts, after);
                        }
                        else {
                            trunc = ellipsis($inr, $dot, $inr, opts, after);
                        }
                    }
                    $inr.replaceWith($inr.contents());
                    $inr = null;

                    if ($.isFunction(opts.callback)) {
                        opts.callback.call($dot[0], trunc, orgContent);
                    }

                    conf.isTruncated = trunc;
                    return trunc;
                }

            ).bind(
                'isTruncated.dot',
                function (e, fn) {
                    e.preventDefault();
                    e.stopPropagation();

                    if (typeof fn == 'function') {
                        fn.call($dot[0], conf.isTruncated);
                    }
                    return conf.isTruncated;
                }

                ).bind(
                'originalContent.dot',
                function (e, fn) {
                    e.preventDefault();
                    e.stopPropagation();

                    if (typeof fn == 'function') {
                        fn.call($dot[0], orgContent);
                    }
                    return orgContent;
                }

                ).bind(
                'destroy.dot',
                function (e) {
                    e.preventDefault();
                    e.stopPropagation();

                    $dot.unwatch()
                        .unbind_events()
                        .contents()
                        .detach()
                        .end()
                        .append(orgContent)
                        .attr('style', $dot.data('dotdotdot-style') || '')
                        .removeClass('is-truncated')
                        .data('dotdotdot', false);
                }
                );
            return $dot;
        };	//	/bind_events

        $dot.unbind_events = function () {
            $dot.unbind('.dot');
            return $dot;
        };	//	/unbind_events

        $dot.watch = function () {
            $dot.unwatch();
            if (opts.watch == 'window') {
                var $window = $(window),
                    _wWidth = $window.width(),
                    _wHeight = $window.height();

                $window.bind(
                    'resize.dot' + conf.dotId,
                    function () {
                        if (_wWidth != $window.width() || _wHeight != $window.height() || !opts.windowResizeFix) {
                            _wWidth = $window.width();
                            _wHeight = $window.height();

                            if (watchInt) {
                                clearInterval(watchInt);
                            }
                            watchInt = setTimeout(
                                function () {
                                    $dot.trigger('update.dot');
                                }, 100
                            );
                        }
                    }
                );
            }
            else {
                watchOrg = getSizes($dot);
                watchInt = setInterval(
                    function () {
                        if ($dot.is(':visible')) {
                            var watchNew = getSizes($dot);
                            if (watchOrg.width != watchNew.width ||
                                watchOrg.height != watchNew.height) {
                                $dot.trigger('update.dot');
                                watchOrg = watchNew;
                            }
                        }
                    }, 500
                );
            }
            return $dot;
        };
        $dot.unwatch = function () {
            $(window).unbind('resize.dot' + conf.dotId);
            if (watchInt) {
                clearInterval(watchInt);
            }
            return $dot;
        };

        var opts = $.extend(true, {}, $.fn.dotdotdot.defaults, o),
            conf = {},
            watchOrg = {},
            watchInt = null,
            $inr = null;


        if (!(opts.lastCharacter.remove instanceof Array)) {
            opts.lastCharacter.remove = $.fn.dotdotdot.defaultArrays.lastCharacter.remove;
        }
        if (!(opts.lastCharacter.noEllipsis instanceof Array)) {
            opts.lastCharacter.noEllipsis = $.fn.dotdotdot.defaultArrays.lastCharacter.noEllipsis;
        }


        conf.afterElement = getElement(opts.after, $dot);
        conf.isTruncated = false;
        conf.dotId = dotId++;


        $dot.data('dotdotdot', true)
            .bind_events()
            .trigger('update.dot');

        if (opts.watch) {
            $dot.watch();
        }

        return $dot;
    };


    //	public
    $.fn.dotdotdot.defaults = {
        'ellipsis': '... ',
        'wrap': 'word',
        'fallbackToLetter': true,
        'lastCharacter': {},
        'tolerance': 0,
        'callback': null,
        'after': null,
        'height': null,
        'watch': false,
        'windowResizeFix': true
    };
    $.fn.dotdotdot.defaultArrays = {
        'lastCharacter': {
            'remove': [' ', '\u3000', ',', ';', '.', '!', '?'],
            'noEllipsis': []
        }
    };
    $.fn.dotdotdot.debug = function (msg) { };


    //	private
    var dotId = 1;

    function children($elem, o, after) {
        var $elements = $elem.children(),
            isTruncated = false;

        $elem.empty();

        for (var a = 0, l = $elements.length; a < l; a++) {
            var $e = $elements.eq(a);
            $elem.append($e);
            if (after) {
                $elem.append(after);
            }
            if (test($elem, o)) {
                $e.remove();
                isTruncated = true;
                break;
            }
            else {
                if (after) {
                    after.detach();
                }
            }
        }
        return isTruncated;
    }
    function ellipsis($elem, $d, $i, o, after) {
        var isTruncated = false;

        //	Don't put the ellipsis directly inside these elements
        var notx = 'a, table, thead, tbody, tfoot, tr, col, colgroup, object, embed, param, ol, ul, dl, blockquote, select, optgroup, option, textarea, script, style';

        //	Don't remove these elements even if they are after the ellipsis
        var noty = 'script, .dotdotdot-keep';

        $elem
            .contents()
            .detach()
            .each(
            function () {

                var e = this,
                    $e = $(e);

                if (typeof e == 'undefined') {
                    return true;
                }
                else if ($e.is(noty)) {
                    $elem.append($e);
                }
                else if (isTruncated) {
                    return true;
                }
                else {
                    $elem.append($e);
                    if (after && !$e.is(o.after) && !$e.find(o.after).length) {
                        $elem[$elem.is(notx) ? 'after' : 'append'](after);
                    }
                    if (test($i, o)) {
                        if (e.nodeType == 3) // node is TEXT
                        {
                            isTruncated = ellipsisElement($e, $d, $i, o, after);
                        }
                        else {
                            isTruncated = ellipsis($e, $d, $i, o, after);
                        }
                    }

                    if (!isTruncated) {
                        if (after) {
                            after.detach();
                        }
                    }
                }
            }
            );
        $d.addClass("is-truncated");
        return isTruncated;
    }
    function ellipsisElement($e, $d, $i, o, after) {
        var e = $e[0];

        if (!e) {
            return false;
        }

        var txt = getTextContent(e),
            space = (txt.indexOf(' ') !== -1) ? ' ' : '\u3000',
            separator = (o.wrap == 'letter') ? '' : space,
            textArr = txt.split(separator),
            position = -1,
            midPos = -1,
            startPos = 0,
            endPos = textArr.length - 1;


        //	Only one word
        if (o.fallbackToLetter && startPos == 0 && endPos == 0) {
            separator = '';
            textArr = txt.split(separator);
            endPos = textArr.length - 1;
        }

        while (startPos <= endPos && !(startPos == 0 && endPos == 0)) {
            var m = Math.floor((startPos + endPos) / 2);
            if (m == midPos) {
                break;
            }
            midPos = m;

            setTextContent(e, textArr.slice(0, midPos + 1).join(separator) + o.ellipsis);
            $i.children()
                .each(
                function () {
                    $(this).toggle().toggle();
                }
                );

            if (!test($i, o)) {
                position = midPos;
                startPos = midPos;
            }
            else {
                endPos = midPos;

                //	Fallback to letter
                if (o.fallbackToLetter && startPos == 0 && endPos == 0) {
                    separator = '';
                    textArr = textArr[0].split(separator);
                    position = -1;
                    midPos = -1;
                    startPos = 0;
                    endPos = textArr.length - 1;
                }
            }
        }

        if (position != -1 && !(textArr.length == 1 && textArr[0].length == 0)) {
            txt = addEllipsis(textArr.slice(0, position + 1).join(separator), o);
            setTextContent(e, txt);
        }
        else {
            var $w = $e.parent();
            $e.detach();

            var afterLength = (after && after.closest($w).length) ? after.length : 0;

            if ($w.contents().length > afterLength) {
                e = findLastTextNode($w.contents().eq(-1 - afterLength), $d);
            }
            else {
                e = findLastTextNode($w, $d, true);
                if (!afterLength) {
                    $w.detach();
                }
            }
            if (e) {
                txt = addEllipsis(getTextContent(e), o);
                setTextContent(e, txt);
                if (afterLength && after) {
                    var $parent = after.parent();

                    $(e).parent().append(after);

                    if (!$.trim($parent.html())) {
                        $parent.remove();
                    }
                }
            }
        }

        return true;
    }
    function test($i, o) {
        return $i.innerHeight() > o.maxHeight;
    }
    function addEllipsis(txt, o) {
        while ($.inArray(txt.slice(-1), o.lastCharacter.remove) > -1) {
            txt = txt.slice(0, -1);
        }
        if ($.inArray(txt.slice(-1), o.lastCharacter.noEllipsis) < 0) {
            txt += o.ellipsis;
        }
        return txt;
    }
    function getSizes($d) {
        return {
            'width': $d.innerWidth(),
            'height': $d.innerHeight()
        };
    }
    function setTextContent(e, content) {
        if (e.innerText) {
            e.innerText = content;
        }
        else if (e.nodeValue) {
            e.nodeValue = content;
        }
        else if (e.textContent) {
            e.textContent = content;
        }

    }
    function getTextContent(e) {
        if (e.innerText) {
            return e.innerText;
        }
        else if (e.nodeValue) {
            return e.nodeValue;
        }
        else if (e.textContent) {
            return e.textContent;
        }
        else {
            return "";
        }
    }
    function getPrevNode(n) {
        do {
            n = n.previousSibling;
        }
        while (n && n.nodeType !== 1 && n.nodeType !== 3);

        return n;
    }
    function findLastTextNode($el, $top, excludeCurrent) {
        var e = $el && $el[0], p;
        if (e) {
            if (!excludeCurrent) {
                if (e.nodeType === 3) {
                    return e;
                }
                if ($.trim($el.text())) {
                    return findLastTextNode($el.contents().last(), $top);
                }
            }
            p = getPrevNode(e);
            while (!p) {
                $el = $el.parent();
                if ($el.is($top) || !$el.length) {
                    return false;
                }
                p = getPrevNode($el[0]);
            }
            if (p) {
                return findLastTextNode($(p), $top);
            }
        }
        return false;
    }
    function getElement(e, $i) {
        if (!e) {
            return false;
        }
        if (typeof e === 'string') {
            e = $(e, $i);
            return (e.length)
                ? e
                : false;
        }
        return !e.jquery
            ? false
            : e;
    }
    function getTrueInnerHeight($el) {
        var h = $el.innerHeight(),
            a = ['paddingTop', 'paddingBottom'];

        for (var z = 0, l = a.length; z < l; z++) {
            var m = parseInt($el.css(a[z]), 10);
            if (isNaN(m)) {
                m = 0;
            }
            h -= m;
        }
        return h;
    }


    //	override jQuery.html
    var _orgHtml = $.fn.html;
    $.fn.html = function (str) {
        if (str != undef && !$.isFunction(str) && this.data('dotdotdot')) {
            return this.trigger('update', [str]);
        }
        return _orgHtml.apply(this, arguments);
    };


    //	override jQuery.text
    var _orgText = $.fn.text;
    $.fn.text = function (str) {
        if (str != undef && !$.isFunction(str) && this.data('dotdotdot')) {
            str = $('<div />').text(str).html();
            return this.trigger('update', [str]);
        }
        return _orgText.apply(this, arguments);
    };


})(jQuery);

/*

## Automatic parsing for CSS classes
Contributed by [Ramil Valitov](https://github.com/rvalitov)

### The idea
You can add one or several CSS classes to HTML elements to automatically invoke "jQuery.dotdotdot functionality" and some extra features. It allows to use jQuery.dotdotdot only by adding appropriate CSS classes without JS programming.

### Available classes and their description
* dot-ellipsis - automatically invoke jQuery.dotdotdot to this element. This class must be included if you plan to use other classes below.
* dot-resize-update - automatically update if window resize event occurs. It's equivalent to option `watch:'window'`.
* dot-timer-update - automatically update if window resize event occurs. It's equivalent to option `watch:true`.
* dot-load-update - automatically update after the window has beem completely rendered. Can be useful if your content is generated dynamically using using JS and, hence, jQuery.dotdotdot can't correctly detect the height of the element before it's rendered completely.
* dot-height-XXX - available height of content area in pixels, where XXX is a number, e.g. can be `dot-height-35` if you want to set maximum height for 35 pixels. It's equivalent to option `height:'XXX'`.

### Usage examples
*Adding jQuery.dotdotdot to element*
    
	<div class="dot-ellipsis">
	<p>Lorem Ipsum is simply dummy text.</p>
	</div>
	
*Adding jQuery.dotdotdot to element with update on window resize*
    
	<div class="dot-ellipsis dot-resize-update">
	<p>Lorem Ipsum is simply dummy text.</p>
	</div>
	
*Adding jQuery.dotdotdot to element with predefined height of 50px*
    
	<div class="dot-ellipsis dot-height-50">
	<p>Lorem Ipsum is simply dummy text.</p>
	</div>
	
*/

jQuery(document).ready(function ($) {
    //We only invoke jQuery.dotdotdot on elements that have dot-ellipsis class
    $(".dot-ellipsis").each(function () {
        //Checking if update on window resize required
        var watch_window = $(this).hasClass("dot-resize-update");

        //Checking if update on timer required
        var watch_timer = $(this).hasClass("dot-timer-update");

        //Checking if height set
        var height = 0;
        var classList = $(this).attr('class').split(/\s+/);
        $.each(classList, function (index, item) {
            var matchResult = item.match(/^dot-height-(\d+)$/);
            if (matchResult !== null)
                height = Number(matchResult[1]);
        });

        //Invoking jQuery.dotdotdot
        var x = new Object();
        if (watch_timer)
            x.watch = true;
        if (watch_window)
            x.watch = 'window';
        if (height > 0)
            x.height = height;
        $(this).dotdotdot(x);
    });

});

//Updating elements (if any) on window.load event
jQuery(window).on('load', function () {
    jQuery(".dot-ellipsis.dot-load-update").trigger("update.dot");
});

/* commonjs package manager support (eg componentjs) */
if (typeof module !== "undefined" && typeof exports !== "undefined" && module.exports === exports) {
    module.exports = 'treeControl';
}
(function (angular) {
    'use strict';

    function createPath(startScope) {
        return function path() {
            var _path = [];
            var scope = startScope;
            var prevNode;
            while (scope && scope.node !== startScope.synteticRoot) {
                if (prevNode !== scope.node)
                    _path.push(scope.node);
                prevNode = scope.node;
                scope = scope.$parent;
            }
            return _path;
        }
    }

    angular.module('WizdomMobileModule')
        .constant('treeConfig', {
            templateUrl: null
        })
        .directive('treecontrol', ['$compile', function ($compile) {
            /**
             * @param cssClass - the css class
             * @param addClassProperty - should we wrap the class name with class=""
             */
            function classIfDefined(cssClass, addClassProperty) {
                if (cssClass) {
                    if (addClassProperty)
                        return 'class="' + cssClass + '"';
                    else
                        return cssClass;
                }
                else
                    return "";
            }

            function ensureDefault(obj, prop, value) {
                if (!obj.hasOwnProperty(prop))
                    obj[prop] = value;
            }

            return {
                restrict: 'EA',
                require: "treecontrol",
                transclude: true,
                scope: {
                    treeModel: "=",
                    selectedNode: "=?",
                    selectedNodes: "=?",
                    expandedNodes: "=?",
                    onSelection: "&",
                    onNodeToggle: "&",
                    options: "=?",
                    orderBy: "=?",
                    reverseOrder: "@",
                    filterExpression: "=?",
                    filterComparator: "=?"
                },
                controller: ['$scope', '$templateCache', '$interpolate', 'treeConfig', function ($scope, $templateCache, $interpolate, treeConfig) {

                    function defaultIsLeaf(node) {
                        return !node[$scope.options.nodeChildren] || node[$scope.options.nodeChildren].length === 0;
                    }

                    function shallowCopy(src, dst) {
                        if (angular.isArray(src)) {
                            dst = dst || [];

                            for (var i = 0; i < src.length; i++) {
                                dst[i] = src[i];
                            }
                        } else if (angular.isObject(src)) {
                            dst = dst || {};

                            for (var key in src) {
                                if (hasOwnProperty.call(src, key) && !(key.charAt(0) === '$' && key.charAt(1) === '$')) {
                                    dst[key] = src[key];
                                }
                            }
                        }

                        return dst || src;
                    }
                    function defaultEquality(a, b) {
                        if (!a || !b)
                            return false;
                        a = shallowCopy(a);
                        a[$scope.options.nodeChildren] = [];
                        b = shallowCopy(b);
                        b[$scope.options.nodeChildren] = [];
                        return angular.equals(a, b);
                    }

                    function defaultIsSelectable() {
                        return true;
                    }

                    $scope.options = $scope.options || {};
                    ensureDefault($scope.options, "multiSelection", false);
                    ensureDefault($scope.options, "nodeChildren", "children");
                    ensureDefault($scope.options, "dirSelectable", "true");
                    ensureDefault($scope.options, "injectClasses", {});
                    ensureDefault($scope.options.injectClasses, "ul", "");
                    ensureDefault($scope.options.injectClasses, "li", "");
                    ensureDefault($scope.options.injectClasses, "liSelected", "");
                    ensureDefault($scope.options.injectClasses, "iExpanded", "");
                    ensureDefault($scope.options.injectClasses, "iCollapsed", "");
                    ensureDefault($scope.options.injectClasses, "iLeaf", "");
                    ensureDefault($scope.options.injectClasses, "label", "");
                    ensureDefault($scope.options.injectClasses, "labelSelected", "");
                    ensureDefault($scope.options, "equality", defaultEquality);
                    ensureDefault($scope.options, "isLeaf", defaultIsLeaf);
                    ensureDefault($scope.options, "allowDeselect", true);
                    ensureDefault($scope.options, "isSelectable", defaultIsSelectable);

                    $scope.selectedNodes = $scope.selectedNodes || [];
                    $scope.expandedNodes = $scope.expandedNodes || [];
                    $scope.expandedNodesMap = {};
                    for (var i = 0; i < $scope.expandedNodes.length; i++) {
                        $scope.expandedNodesMap["" + i] = $scope.expandedNodes[i];
                    }
                    $scope.parentScopeOfTree = $scope.$parent;


                    function isSelectedNode(node) {
                        if (!$scope.options.multiSelection && ($scope.options.equality(node, $scope.selectedNode)))
                            return true;
                        else if ($scope.options.multiSelection && $scope.selectedNodes) {
                            for (var i = 0; (i < $scope.selectedNodes.length); i++) {
                                if ($scope.options.equality(node, $scope.selectedNodes[i])) {
                                    return true;
                                }
                            }
                            return false;
                        }
                    }

                    $scope.headClass = function (node) {
                        var liSelectionClass = classIfDefined($scope.options.injectClasses.liSelected, false);
                        var injectSelectionClass = "";
                        if (liSelectionClass && isSelectedNode(node))
                            injectSelectionClass = " " + liSelectionClass;
                        if ($scope.options.isLeaf(node))
                            return "tree-leaf" + injectSelectionClass;
                        if ($scope.expandedNodesMap[this.$id])
                            return "tree-expanded" + injectSelectionClass;
                        else
                            return "tree-collapsed" + injectSelectionClass;
                    };

                    $scope.iBranchClass = function () {
                        if ($scope.expandedNodesMap[this.$id])
                            return classIfDefined($scope.options.injectClasses.iExpanded);
                        else
                            return classIfDefined($scope.options.injectClasses.iCollapsed);
                    };

                    $scope.nodeExpanded = function () {
                        return !!$scope.expandedNodesMap[this.$id];
                    };

                    $scope.selectNodeHead = function () {
                        var transcludedScope = this;
                        var expanding = $scope.expandedNodesMap[transcludedScope.$id] === undefined;
                        $scope.expandedNodesMap[transcludedScope.$id] = (expanding ? transcludedScope.node : undefined);
                        if (expanding) {
                            $scope.expandedNodes.push(transcludedScope.node);
                        }
                        else {
                            var index;
                            for (var i = 0; (i < $scope.expandedNodes.length) && !index; i++) {
                                if ($scope.options.equality($scope.expandedNodes[i], transcludedScope.node)) {
                                    index = i;
                                }
                            }
                            if (index !== undefined)
                                $scope.expandedNodes.splice(index, 1);
                        }
                        if ($scope.onNodeToggle) {
                            var parentNode = (transcludedScope.$parent.node === transcludedScope.synteticRoot) ? null : transcludedScope.$parent.node;
                            var path = createPath(transcludedScope);
                            $scope.onNodeToggle({
                                node: transcludedScope.node, $parentNode: parentNode, $path: path,
                                $index: transcludedScope.$index, $first: transcludedScope.$first, $middle: transcludedScope.$middle,
                                $last: transcludedScope.$last, $odd: transcludedScope.$odd, $even: transcludedScope.$even, expanded: expanding
                            });

                        }
                    };

                    $scope.selectNodeLabel = function (selectedNode) {
                        var transcludedScope = this;
                        if (!$scope.options.isLeaf(selectedNode) && (!$scope.options.dirSelectable || !$scope.options.isSelectable(selectedNode))) {
                            // Branch node is not selectable, expand
                            this.selectNodeHead();
                        }
                        else if ($scope.options.isLeaf(selectedNode) && (!$scope.options.isSelectable(selectedNode))) {
                            // Leaf node is not selectable
                            return;
                        }
                        else {
                            var selected = false;
                            if ($scope.options.multiSelection) {
                                var pos = -1;
                                for (var i = 0; i < $scope.selectedNodes.length; i++) {
                                    if ($scope.options.equality(selectedNode, $scope.selectedNodes[i])) {
                                        pos = i;
                                        break;
                                    }
                                }
                                if (pos === -1) {
                                    $scope.selectedNodes.push(selectedNode);
                                    selected = true;
                                } else {
                                    $scope.selectedNodes.splice(pos, 1);
                                }
                            } else {
                                if (!$scope.options.equality(selectedNode, $scope.selectedNode)) {
                                    $scope.selectedNode = selectedNode;
                                    selected = true;
                                }
                                else {
                                    if ($scope.options.allowDeselect) {
                                        $scope.selectedNode = undefined;
                                    } else {
                                        $scope.selectedNode = selectedNode;
                                        selected = true;
                                    }
                                }
                            }
                            if ($scope.onSelection) {
                                var parentNode = (transcludedScope.$parent.node === transcludedScope.synteticRoot) ? null : transcludedScope.$parent.node;
                                var path = createPath(transcludedScope)
                                $scope.onSelection({
                                    node: selectedNode, selected: selected, $parentNode: parentNode, $path: path,
                                    $index: transcludedScope.$index, $first: transcludedScope.$first, $middle: transcludedScope.$middle,
                                    $last: transcludedScope.$last, $odd: transcludedScope.$odd, $even: transcludedScope.$even
                                });
                            }
                        }
                    };

                    $scope.selectedClass = function () {
                        var isThisNodeSelected = isSelectedNode(this.node);
                        var labelSelectionClass = classIfDefined($scope.options.injectClasses.labelSelected, false);
                        var injectSelectionClass = "";
                        if (labelSelectionClass && isThisNodeSelected)
                            injectSelectionClass = " " + labelSelectionClass;

                        return isThisNodeSelected ? "tree-selected" + injectSelectionClass : "";
                    };

                    $scope.unselectableClass = function () {
                        var isThisNodeUnselectable = !$scope.options.isSelectable(this.node);
                        var labelUnselectableClass = classIfDefined($scope.options.injectClasses.labelUnselectable, false);
                        return isThisNodeUnselectable ? "tree-unselectable " + labelUnselectableClass : "";
                    };

                    //tree template
                    $scope.isReverse = function () {
                        return !($scope.reverseOrder === 'false' || $scope.reverseOrder === 'False' || $scope.reverseOrder === '' || $scope.reverseOrder === false);
                    };

                    $scope.orderByFunc = function () {
                        return $scope.orderBy;
                    };
                    //                    return "" + $scope.orderBy;

                    var templateOptions = {
                        orderBy: $scope.orderBy ? " | orderBy:orderByFunc():isReverse()" : '',
                        ulClass: classIfDefined($scope.options.injectClasses.ul, true),
                        nodeChildren: $scope.options.nodeChildren,
                        liClass: classIfDefined($scope.options.injectClasses.li, true),
                        iLeafClass: classIfDefined($scope.options.injectClasses.iLeaf, false),
                        labelClass: classIfDefined($scope.options.injectClasses.label, false)
                    };

                    var template;
                    var templateUrl = $scope.options.templateUrl || treeConfig.templateUrl;

                    if (templateUrl) {
                        template = $templateCache.get(templateUrl);
                    }

                    if (!template) {
                        template =
                            '<ul {{options.ulClass}} >' +
                            '<li ng-repeat="node in node.{{options.nodeChildren}} | filter:filterExpression:filterComparator {{options.orderBy}}" ng-class="headClass(node)" {{options.liClass}}' +
                            'set-node-to-data>' +
                            '<i class="tree-branch-head" ng-class="iBranchClass()" ng-click="selectNodeHead(node)"></i>' +
                            '<i class="tree-leaf-head {{options.iLeafClass}}"></i>' +
                            '<div class="tree-label {{options.labelClass}}" ng-class="[selectedClass(), unselectableClass()]" ng-click="selectNodeLabel(node)" tree-transclude></div>' +
                            '<treeitem ng-if="nodeExpanded()"></treeitem>' +
                            '</li>' +
                            '</ul>';
                    }

                    this.template = $compile($interpolate(template)({ options: templateOptions }));
                }],
                compile: function (element, attrs, childTranscludeFn) {
                    return function (scope, element, attrs, treemodelCntr) {

                        scope.$watch("treeModel", function updateNodeOnRootScope(newValue) {
                            if (angular.isArray(newValue)) {
                                if (angular.isDefined(scope.node) && angular.equals(scope.node[scope.options.nodeChildren], newValue))
                                    return;
                                scope.node = {};
                                scope.synteticRoot = scope.node;
                                scope.node[scope.options.nodeChildren] = newValue;
                            }
                            else {
                                if (angular.equals(scope.node, newValue))
                                    return;
                                scope.node = newValue;
                            }
                        });

                        scope.$watchCollection('expandedNodes', function (newValue, oldValue) {
                            var notFoundIds = 0;
                            var newExpandedNodesMap = {};
                            var $liElements = element.find('li');
                            var existingScopes = [];
                            // find all nodes visible on the tree and the scope $id of the scopes including them
                            angular.forEach($liElements, function (liElement) {
                                var $liElement = angular.element(liElement);
                                var liScope = {
                                    $id: $liElement.data('scope-id'),
                                    node: $liElement.data('node')
                                };
                                existingScopes.push(liScope);
                            });
                            // iterate over the newValue, the new expanded nodes, and for each find it in the existingNodesAndScopes
                            // if found, add the mapping $id -> node into newExpandedNodesMap
                            // if not found, add the mapping num -> node into newExpandedNodesMap
                            angular.forEach(newValue, function (newExNode) {
                                var found = false;
                                for (var i = 0; (i < existingScopes.length) && !found; i++) {
                                    var existingScope = existingScopes[i];
                                    if (scope.options.equality(newExNode, existingScope.node)) {
                                        newExpandedNodesMap[existingScope.$id] = existingScope.node;
                                        found = true;
                                    }
                                }
                                if (!found)
                                    newExpandedNodesMap[notFoundIds++] = newExNode;
                            });
                            scope.expandedNodesMap = newExpandedNodesMap;
                        });

                        //                        scope.$watch('expandedNodesMap', function(newValue) {
                        //
                        //                        });

                        //Rendering template for a root node
                        treemodelCntr.template(scope, function (clone) {
                            element.html('').append(clone);
                        });
                        // save the transclude function from compile (which is not bound to a scope as apposed to the one from link)
                        // we can fix this to work with the link transclude function with angular 1.2.6. as for angular 1.2.0 we need
                        // to keep using the compile function
                        scope.$treeTransclude = childTranscludeFn;
                    };
                }
            };
        }])
        .directive("setNodeToData", ['$parse', function ($parse) {
            return {
                restrict: 'A',
                link: function ($scope, $element, $attrs) {
                    $element.data('node', $scope.node);
                    $element.data('scope-id', $scope.$id);
                }
            };
        }])
        .directive("treeitem", function () {
            return {
                restrict: 'E',
                require: "^treecontrol",
                link: function (scope, element, attrs, treemodelCntr) {
                    // Rendering template for the current node
                    treemodelCntr.template(scope, function (clone) {
                        element.html('').append(clone);
                    });
                }
            };
        })
        .directive("treeTransclude", function () {
            return {
                link: function (scope, element, attrs, controller) {
                    if (!scope.options.isLeaf(scope.node)) {
                        angular.forEach(scope.expandedNodesMap, function (node, id) {
                            if (scope.options.equality(node, scope.node)) {
                                scope.expandedNodesMap[scope.$id] = scope.node;
                                scope.expandedNodesMap[id] = undefined;
                            }
                        });
                    }
                    if (!scope.options.multiSelection && scope.options.equality(scope.node, scope.selectedNode)) {
                        scope.selectedNode = scope.node;
                    } else if (scope.options.multiSelection) {
                        var newSelectedNodes = [];
                        for (var i = 0; (i < scope.selectedNodes.length); i++) {
                            if (scope.options.equality(scope.node, scope.selectedNodes[i])) {
                                newSelectedNodes.push(scope.node);
                            }
                        }
                        scope.selectedNodes = newSelectedNodes;
                    }

                    // create a scope for the transclusion, whos parent is the parent of the tree control
                    scope.transcludeScope = scope.parentScopeOfTree.$new();
                    scope.transcludeScope.node = scope.node;
                    scope.transcludeScope.$path = createPath(scope);
                    scope.transcludeScope.$parentNode = (scope.$parent.node === scope.synteticRoot) ? null : scope.$parent.node;
                    scope.transcludeScope.$index = scope.$index;
                    scope.transcludeScope.$first = scope.$first;
                    scope.transcludeScope.$middle = scope.$middle;
                    scope.transcludeScope.$last = scope.$last;
                    scope.transcludeScope.$odd = scope.$odd;
                    scope.transcludeScope.$even = scope.$even;
                    scope.$on('$destroy', function () {
                        scope.transcludeScope.$destroy();
                    });

                    scope.$treeTransclude(scope.transcludeScope, function (clone) {
                        element.empty();
                        element.append(clone);
                    });
                }
            };
        });
})(angular);
/**
 * State-based routing for AngularJS 1.x
 * NOTICE: This monolithic bundle also bundles the @uirouter/core code.
 *         This causes it to be incompatible with plugins that depend on @uirouter/core.
 *         We recommend switching to the ui-router-core.js and ui-router-angularjs.js bundles instead.
 *         For more information, see https://ui-router.github.io/blog/uirouter-for-angularjs-umd-bundles
 * @version v1.0.7
 * @link https://ui-router.github.io
 * @license MIT License, http://www.opensource.org/licenses/MIT
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports,require("angular")):"function"==typeof define&&define.amd?define(["exports","angular"],e):e(t["@uirouter/angularjs"]={},t.angular)}(this,function(t,e){"use strict";function r(t){function e(r){return r.length>=n?t.apply(null,r):function(){return e(r.concat([].slice.apply(arguments)))}}var r=[].slice.apply(arguments,[1]),n=t.length;return e(r)}function n(){var t=arguments,e=t.length-1;return function(){for(var r=e,n=t[e].apply(this,arguments);r--;)n=t[r].call(this,n);return n}}function i(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];return n.apply(null,[].slice.call(arguments).reverse())}function o(t,e){return function(){for(var r=[],n=0;n<arguments.length;n++)r[n]=arguments[n];return t.apply(null,r)&&e.apply(null,r)}}function a(t,e){return function(){for(var r=[],n=0;n<arguments.length;n++)r[n]=arguments[n];return t.apply(null,r)||e.apply(null,r)}}function u(t,e){return function(r){return r[t].apply(r,e)}}function s(t){return function(e){for(var r=0;r<t.length;r++)if(t[r][0](e))return t[r][1](e)}}function c(t){if(ee(t)&&t.length){var e=t.slice(0,-1),r=t.slice(-1);return!(e.filter(qt(Xt)).length||r.filter(qt(Yt)).length)}return Yt(t)}function f(t){return t}function l(){}function h(t,e,r,n,i){void 0===i&&(i=!1);var o=function(e){return t()[e].bind(r())},a=function(t){return function(){return e[t]=o(t),e[t].apply(null,arguments)}};return(n=n||Object.keys(t())).reduce(function(t,e){return t[e]=i?a(e):o(e),t},e)}function p(t,e){return-1!==t.indexOf(e)}function d(t,e){var r=t.indexOf(e);return r>=0&&t.splice(r,1),t}function v(t,e){return t.push(e),e}function m(t){for(var e=[],r=1;r<arguments.length;r++)e[r-1]=arguments[r];var n=e.concat({}).reverse(),i=he.apply(null,n);return he({},i,g(t||{},Object.keys(i)))}function y(t,e){var r=[];for(var n in t.path){if(t.path[n]!==e.path[n])break;r.push(t.path[n])}return r}function g(t,e){var r={};for(var n in t)-1!==e.indexOf(n)&&(r[n]=t[n]);return r}function w(t,e){return Object.keys(t).filter(qt(ve(e))).reduce(function(e,r){return e[r]=t[r],e},{})}function _(t,e){return b(t,Vt(e))}function $(t,e){var r=ee(t),n=r?[]:{},i=r?function(t){return n.push(t)}:function(t,e){return n[e]=t};return le(t,function(t,r){e(t,r)&&i(t,r)}),n}function S(t,e){var r;return le(t,function(t,n){r||e(t,n)&&(r=t)}),r}function b(t,e){var r=ee(t)?[]:{};return le(t,function(t,n){return r[n]=e(t,n)}),r}function R(t,e){return t.push(e),t}function E(t,e){return void 0===e&&(e="assert failure"),function(r){var n=t(r);if(!n)throw new Error(Yt(e)?e(r):e);return n}}function C(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];if(0===t.length)return[];var r,n=t.reduce(function(t,e){return Math.min(e.length,t)},9007199254740991),i=[];for(r=0;r<n;r++)switch(t.length){case 1:i.push([t[0][r]]);break;case 2:i.push([t[0][r],t[1][r]]);break;case 3:i.push([t[0][r],t[1][r],t[2][r]]);break;case 4:i.push([t[0][r],t[1][r],t[2][r],t[3][r]]);break;default:i.push(t.map(function(t){return t[r]}))}return i}function T(t,e){var r,n;if(ee(e)&&(r=e[0],n=e[1]),!Xt(r))throw new Error("invalid parameters to applyPairs");return t[r]=n,t}function P(t){return t.length&&t[t.length-1]||void 0}function k(t,e){return e&&Object.keys(e).forEach(function(t){return delete e[t]}),e||(e={}),he(e,t)}function O(t){for(var e=1;e<arguments.length;e++){var r=arguments[e];if(r)for(var n=Object.keys(r),i=0;i<n.length;i++)t[n[i]]=r[n[i]]}return t}function x(t,e){if(t===e)return!0;if(null===t||null===e)return!1;if(t!==t&&e!==e)return!0;var r=typeof t;if(r!==typeof e||"object"!==r)return!1;var n=[t,e];if(Dt(ee)(n))return I(t,e);if(Dt(re)(n))return t.getTime()===e.getTime();if(Dt(ne)(n))return t.toString()===e.toString();if(Dt(Yt)(n))return!0;if([Yt,ee,re,ne].map(Ft).reduce(function(t,e){return t||!!e(n)},!1))return!1;var i,o={};for(i in t){if(!x(t[i],e[i]))return!1;o[i]=!0}for(i in e)if(!o[i])return!1;return!0}function I(t,e){return t.length===e.length&&C(t,e).reduce(function(t,e){return t&&x(e[0],e[1])},!0)}function j(t){if(!t)return"ui-view (defunct)";var e=t.creationContext?t.creationContext.name||"(root)":"(none)";return"[ui-view#"+t.id+" "+t.$type+":"+t.fqn+" ("+t.name+"@"+e+")]"}function V(e){return Zt(e)?t.Category[e]:t.Category[t.Category[e]]}function A(t,e){var r=Xt(e)?[e]:e;return!!(Yt(r)?r:function(t){for(var e=r,n=0;n<e.length;n++){var i=new Mt(e[n]);if(i&&i.matches(t.name)||!i&&e[n]===t.name)return!0}return!1})(t)}function H(t,e,r){function n(t,n,o){void 0===o&&(o={});var a=new ze(e,r,n,t,o);return i.push(a),function(){a._deregistered=!0,me(i)(a)}}var i=(t._registeredHooks=t._registeredHooks||{})[r.name]=[];return t[r.name]=n,n}function q(t){return void 0===t&&(t=!1),function(e,r){var n=t?-1:1,i=(e.node.state.path.length-r.node.state.path.length)*n;return 0!==i?i:r.hook.priority-e.hook.priority}}function D(t,e){function r(t){return ee(t)?t:Jt(t)?[t]:[]}function n(t){switch(t.length){case 0:return;case 1:return"auto"===e?t[0]:t;default:return t}}function i(t,e){return function(i){if(ee(i)&&0===i.length)return i;var o=b(r(i),t);return!0===e?0===$(o,function(t){return!t}).length:n(o)}}function o(t){return function(e,n){var i=r(e),o=r(n);if(i.length!==o.length)return!1;for(var a=0;a<i.length;a++)if(!t(i[a],o[a]))return!1;return!0}}var a=this;["encode","decode","equals","$normalize"].forEach(function(e){var r=t[e].bind(t),n="equals"===e?o:i;a[e]=n(r)}),he(this,{dynamic:t.dynamic,name:t.name,pattern:t.pattern,inherit:t.inherit,is:i(t.is.bind(t),!0),$arrayMode:e})}function F(t){function e(){return t.value}return t=Ye(t)&&{value:t}||t,e.__cacheable=!0,he(t,{$$fn:c(t.value)?t.value:e})}function N(e,r,n,i,o){if(e.type&&r&&"string"!==r.name)throw new Error("Param '"+i+"' has two type configurations.");if(e.type&&r&&"string"===r.name&&o.type(e.type))return o.type(e.type);if(r)return r;if(!e.type){var a=n===t.DefType.CONFIG?"any":n===t.DefType.PATH?"path":n===t.DefType.SEARCH?"query":"string";return o.type(a)}return e.type instanceof Qe?e.type:o.type(e.type)}function U(t,e,r){var n=t.squash;if(!e||!1===n)return!1;if(!Jt(n)||null==n)return r;if(!0===n||Xt(n))return n;throw new Error("Invalid squash policy: '"+n+"'. Valid policies: false, true, or arbitrary string")}function L(t,e,r,n){var i,o,a=[{from:"",to:r||e?void 0:""},{from:null,to:r||e?void 0:""}];return i=ee(t.replace)?t.replace:[],Xt(n)&&i.push({from:n,to:void 0}),o=b(i,Vt("from")),$(a,function(t){return-1===o.indexOf(t.from)}).concat(i)}function M(t,e){return e.length<=t?e:e.substr(0,t-3)+"..."}function B(t,e){for(;e.length<t;)e+=" ";return e}function G(t){return t.replace(/^([A-Z])/,function(t){return t.toLowerCase()}).replace(/([A-Z])/g,function(t){return"-"+t.toLowerCase()})}function W(t){var e=z(t),r=e.match(/^(function [^ ]+\([^)]*\))/),n=r?r[1]:e,i=t.name||"";return i&&n.match(/function \(/)?"function "+i+n.substr(9):n}function z(t){var e=ee(t)?t.slice(-1)[0]:t;return e&&e.toString()||"undefined"}function J(t){function e(t){if(te(t)){if(-1!==r.indexOf(t))return"[circular ref]";r.push(t)}return pr(t)}var r=[];return JSON.stringify(t,function(t,r){return e(r)}).replace(/\\"/g,'"')}function Q(t){var e=new RegExp("("+t+")","g");return function(t){return t.split(e).filter(f)}}function K(t,e){return Xt(P(t))&&Xt(e)?t.slice(0,-1).concat(P(t)+e):R(t,e)}function Y(t){return t.name}function Z(t){return t.self.$$state=function(){return t},t.self}function X(t){return t.parent&&t.parent.data&&(t.data=t.self.data=de(t.parent.data,t.data)),t.data}function tt(t){return t.parent?t.parent.path.concat(t):[t]}function et(t){var e=t.parent?he({},t.parent.includes):{};return e[t.name]=!0,e}function rt(t){var e=function(t){var e=ue.$injector;return t.$inject||e&&e.annotate(t,e.strictDi)||"deferred"},r=function(t){return t.provide||t.token},n=s([[Vt("resolveFn"),function(t){return new rr(r(t),t.resolveFn,t.deps,t.policy)}],[Vt("useFactory"),function(t){return new rr(r(t),t.useFactory,t.deps||t.dependencies,t.policy)}],[Vt("useClass"),function(t){return new rr(r(t),function(){return new t.useClass},[],t.policy)}],[Vt("useValue"),function(t){return new rr(r(t),function(){return t.useValue},[],t.policy,t.useValue)}],[Vt("useExisting"),function(t){return new rr(r(t),f,[t.useExisting],t.policy)}]]),o=s([[i(Vt("val"),Xt),function(t){return new rr(t.token,f,[t.val],t.policy)}],[i(Vt("val"),ee),function(t){return new rr(t.token,P(t.val),t.val.slice(0,-1),t.policy)}],[i(Vt("val"),Yt),function(t){return new rr(t.token,t.val,e(t.val),t.policy)}]]),a=s([[Nt(rr),function(t){return t}],[function(t){return!(!t.token||!t.resolveFn)},n],[function(t){return!(!t.provide&&!t.token||!(t.useValue||t.useFactory||t.useExisting||t.useClass))},n],[function(t){return!!(t&&t.val&&(Xt(t.val)||ee(t.val)||Yt(t.val)))},o],[Lt(!0),function(t){throw new Error("Invalid resolve value: "+J(t))}]]),u=t.resolve;return(ee(u)?u:function(t,e){return Object.keys(t||{}).map(function(r){return{token:r,val:t[r],deps:void 0,policy:e[r]}})}(u,t.resolvePolicy||{})).map(a)}function nt(t,e){var r=["",""],n=t.replace(/[\\\[\]\^$*+?.()|{}]/g,"\\$&");if(!e)return n;switch(e.squash){case!1:r=["(",")"+(e.isOptional?"?":"")];break;case!0:n=n.replace(/\/$/,""),r=["(?:/(",")|/)?"];break;default:r=["("+e.squash+"|",")?"]}return n+r[0]+e.type.pattern.source+r[1]}function it(t,e,r,n){return"/"===n?t:e?mr(n)+t:r?n.slice(1)+t:t}function ot(t){if(!(Yt(t)||Xt(t)||Nt(Be)(t)||Be.isDef(t)))throw new Error("'handler' must be a string, function, TargetState, or have a state: 'newtarget' property");return Yt(t)?t:Lt(t)}function at(t){t.addResolvable({token:Xr,deps:[],resolveFn:function(){return t.router},data:t.router},""),t.addResolvable({token:lr,deps:[],resolveFn:function(){return t},data:t},""),t.addResolvable({token:"$transition$",deps:[],resolveFn:function(){return t},data:t},""),t.addResolvable({token:"$stateParams",deps:[],resolveFn:function(){return t.params()},data:t.params()},""),t.entering().forEach(function(e){t.addResolvable({token:"$state$",deps:[],resolveFn:function(){return e},data:e},e)})}function ut(t){return function(e,r){return(0,r.$$state()[t])(e,r)}}function st(t,e){var r=e.$$state().lazyLoad,n=r._promise;if(!n){n=r._promise=ue.$q.when(r(t,e)).then(function(e){return e&&Array.isArray(e.states)&&e.states.forEach(function(e){return t.router.stateRegistry.register(e)}),e}).then(function(t){return delete e.lazyLoad,delete e.$$state().lazyLoad,delete r._promise,t},function(t){return delete r._promise,ue.$q.reject(t)})}return n}function ct(t){var e=t._ignoredReason();if(e){Me.traceTransitionIgnored(t);var r=t.router.globals.transition;return"SameAsCurrent"===e&&r&&r.abort(),He.ignored().toPromise()}}function ft(t){if(!t.valid())throw new Error(t.error())}function lt(t){var e=function(t){return t||""},r=yr(t).map(e),n=r[0],i=r[1],o=gr(n).map(e);return{path:o[0],search:o[1],hash:i,url:t}}function ht(t,e,r,n){return function(i){var o=i.locationService=new r(i),a=i.locationConfig=new n(i,e);return{name:t,service:o,configuration:a,dispose:function(t){t.dispose(o),t.dispose(a)}}}}function pt(){function t(t,e){e=e||{bubbles:!1,cancelable:!1,detail:void 0};var r=document.createEvent("CustomEvent");return r.initCustomEvent(t,e.bubbles,e.cancelable,e.detail),r}t.prototype=Event.prototype;try{return new CustomEvent("foo"),CustomEvent}catch(e){return t}}function dt(t){return ue.$injector=Vn,ue.$q=On,{name:"vanilla.services",$q:On,$injector:Vn,dispose:function(){return null}}}function vt(){var t=null;return function(e,r){return t=t||ue.$injector.get("$templateFactory"),[new ei(e,r,t)]}}function mt(t){if(!t.parent)return{};var e=["controller","controllerProvider","controllerAs","resolveAs"],r=["component","bindings","componentProvider"],n=["templateProvider","templateUrl","template","notify","async"].concat(e),i=r.concat(n);if(Jt(t.views)&&Xn(i,t))throw new Error("State '"+t.name+"' has a 'views' object. It cannot also have \"view properties\" at the state level.  Move the following properties into a view (in the 'views' object):  "+i.filter(function(e){return Jt(t[e])}).join(", "));var o={},a=t.views||{$default:g(t,i)};return le(a,function(e,i){if(i=i||"$default",Xt(e)&&(e={component:e}),e=he({},e),Xn(r,e)&&Xn(n,e))throw new Error("Cannot combine: "+r.join("|")+" with: "+n.join("|")+" in stateview: '"+i+"@"+t.name+"'");e.resolveAs=e.resolveAs||"$resolve",e.$type="ng1",e.$context=t,e.$name=i;var a=Mr.normalizeUIViewTarget(e.$context,e.$name);e.$uiViewName=a.uiViewName,e.$uiViewContextAnchor=a.uiViewContextAnchor,o[i]=e}),o}function yt(t){var e=ue.$injector.get(t+"Directive");if(!e||!e.length)throw new Error("Unable to find component named '"+t+"'");return e.map(ni).reduce(Re,[])}function gt(t){function e(t,e,n,i,o,a){return r._runtimeServices(i,t,n,e),delete di.router,delete di.$get,di}(di=this.router=new Xr).stateProvider=new oi(di.stateRegistry,di.stateService),di.stateRegistry.decorator("views",mt),di.stateRegistry.decorator("onExit",ai("onExit")),di.stateRegistry.decorator("onRetain",ai("onRetain")),di.stateRegistry.decorator("onEnter",ai("onEnter")),di.viewService._pluginapi._viewConfigFactory("ng1",vt());var r=di.locationService=di.locationConfig=new ui(t);return ui.monkeyPatchPathParameterType(di),di.router=di,di.$get=e,e.$inject=["$location","$browser","$sniffer","$rootScope","$http","$templateCache"],di}function wt(t,e,r){ue.$injector=t,ue.$q=e,r.stateRegistry.get().map(function(t){return t.$$state().resolvables}).reduce(Re,[]).filter(function(t){return"deferred"===t.deps}).forEach(function(e){return e.deps=t.annotate(e.resolveFn,t.strictDi)})}function _t(t){t.$watch(function(){Me.approximateDigests++})}function $t(t){var e,r=t.match(/^\s*({[^}]*})\s*$/);if(r&&(t="("+r[1]+")"),!(e=t.replace(/\n/g," ").match(/^\s*([^(]*?)\s*(\((.*)\))?\s*$/))||4!==e.length)throw new Error("Invalid state ref '"+t+"'");return{state:e[1]||null,paramExpr:e[3]||null}}function St(t){var e=t.parent().inheritedData("$uiView"),r=Ht("$cfg.path")(e);return r?P(r).state.name:void 0}function bt(t,e,r){var n=r.uiState||t.current.name,i=he(Ct(e,t),r.uiStateOpts||{}),o=t.href(n,r.uiStateParams,i);return{uiState:n,uiStateParams:r.uiStateParams,uiStateOpts:i,href:o}}function Rt(t){var e="[object SVGAnimatedString]"===Object.prototype.toString.call(t.prop("href")),r="FORM"===t[0].nodeName;return{attr:r?"action":e?"xlink:href":"href",isAnchor:"A"===t.prop("tagName").toUpperCase(),clickable:!r}}function Et(t,e,r,n,i){return function(o){var a=o.which||o.button,u=i();if(!(a>1||o.ctrlKey||o.metaKey||o.shiftKey||t.attr("target"))){var s=r(function(){e.go(u.uiState,u.uiStateParams,u.uiStateOpts)});o.preventDefault();var c=n.isAnchor&&!u.href?1:0;o.preventDefault=function(){c--<=0&&r.cancel(s)}}}}function Ct(t,e){return{relative:St(t)||e.$current,inherit:!0,source:"sref"}}function Tt(t,e,r,n){var i;n&&(i=n.events),ee(i)||(i=["click"]);for(var o=t.on?"on":"bind",a=0,u=i;a<u.length;a++){var s=u[a];t[o](s,r)}e.$on("$destroy",function(){for(var e=t.off?"off":"unbind",n=0,o=i;n<o.length;n++){var a=o[n];t[e](a,r)}})}function Pt(t){var e=function(e,r,n){return t.is(e,r,n)};return e.$stateful=!0,e}function kt(t){var e=function(e,r,n){return t.includes(e,r,n)};return e.$stateful=!0,e}function Ot(t,r,n,i,o,a){var u=Ht("viewDecl.controllerAs"),s=Ht("viewDecl.resolveAs");return{restrict:"ECA",priority:-400,compile:function(i){var a=i.html();return i.empty(),function(i,c){var f=c.data("$uiView");if(!f)return c.html(a),void t(c.contents())(i);var l=f.$cfg||{viewDecl:{},getTemplate:e.noop},h=l.path&&new sr(l.path);c.html(l.getTemplate(c,h)||a),Me.traceUIViewFill(f.$uiView,c.html());var p=t(c.contents()),d=l.controller,v=u(l),m=s(l),y=h&&yi(h);if(i[m]=y,d){var g=r(d,he({},y,{$scope:i,$element:c}));v&&(i[v]=g,i[v][m]=y),c.data("$ngControllerController",g),c.children().data("$ngControllerController",g),xt(o,n,g,i,l)}if(Xt(l.viewDecl.component))var w=l.viewDecl.component,_=G(w),$=new RegExp("^(x-|data-)?"+_+"$","i"),S=i.$watch(function(){var t=[].slice.call(c[0].children).filter(function(t){return t&&t.tagName&&$.exec(t.tagName)});return t&&jt.element(t).data("$"+w+"Controller")},function(t){t&&(xt(o,n,t,i,l),S())});p(i)}}}}function xt(t,e,r,n,i){!Yt(r.$onInit)||i.viewDecl.component&&$i||r.$onInit();var o=P(i.path).state.self,a={bind:r};if(Yt(r.uiOnParamsChanged)){var u=new sr(i.path).getResolvable("$transition$").data;n.$on("$destroy",e.onSuccess({},function(t){if(t!==u&&-1===t.exiting().indexOf(o)){var e=t.params("to"),n=t.params("from"),i=t.treeChanges().to.map(function(t){return t.paramSchema}).reduce(Re,[]),a=t.treeChanges().from.map(function(t){return t.paramSchema}).reduce(Re,[]),s=i.filter(function(t){var r=a.indexOf(t);return-1===r||!a[r].type.equals(e[t.id],n[t.id])});if(s.length){var c=s.map(function(t){return t.id}),f=$(e,function(t,e){return-1!==c.indexOf(e)});r.uiOnParamsChanged(f,t)}}},a))}if(Yt(r.uiCanExit)){var s=Si++,c=function(t){return!!t&&(t._uiCanExitIds&&!0===t._uiCanExitIds[s]||c(t.redirectedFrom()))},f={exiting:o.name};n.$on("$destroy",e.onBefore(f,function(e){var n,i=e._uiCanExitIds=e._uiCanExitIds||{};return c(e)||(n=t.when(r.uiCanExit(e))).then(function(t){return i[s]=!1!==t}),n},a))}}var It=angular,jt=e&&e.module?e:It,Vt=function(t){return function(e){return e&&e[t]}},At=r(function(t,e,r){return r&&r[t]===e}),Ht=function(t){return i.apply(null,t.split(".").map(Vt))},qt=function(t){return function(){for(var e=[],r=0;r<arguments.length;r++)e[r]=arguments[r];return!t.apply(null,e)}},Dt=function(t){return function(e){return e.reduce(function(e,r){return e&&!!t(r)},!0)}},Ft=function(t){return function(e){return e.reduce(function(e,r){return e||!!t(r)},!1)}},Nt=function(t){return function(e){return null!=e&&e.constructor===t||e instanceof t}},Ut=function(t){return function(e){return t===e}},Lt=function(t){return function(){return t}},Mt=function(){function t(t){this.text=t,this.glob=t.split(".");var e=this.text.split(".").map(function(t){return"**"===t?"(?:|(?:\\.[^.]*)*)":"*"===t?"\\.[^.]*":"\\."+t}).join("");this.regexp=new RegExp("^"+e+"$")}return t.prototype.matches=function(t){return this.regexp.test("."+t)},t.is=function(t){return!!/[!,*]+/.exec(t)},t.fromString=function(e){return t.is(e)?new t(e):null},t}(),Bt=function(){function t(e){return t.create(e||{})}return t.create=function(e){e=t.isStateClass(e)?new e:e;var r=de(de(e,t.prototype));return e.$$state=function(){return r},r.self=e,r.__stateObjectCache={nameGlob:Mt.fromString(r.name)},r},t.prototype.is=function(t){return this===t||this.self===t||this.fqn()===t},t.prototype.fqn=function(){if(!(this.parent&&this.parent instanceof this.constructor))return this.name;var t=this.parent.fqn();return t?t+"."+this.name:this.name},t.prototype.root=function(){return this.parent&&this.parent.root()||this},t.prototype.parameters=function(t){return((t=m(t,{inherit:!0,matchingKeys:null})).inherit&&this.parent&&this.parent.parameters()||[]).concat($e(this.params)).filter(function(e){return!t.matchingKeys||t.matchingKeys.hasOwnProperty(e.id)})},t.prototype.parameter=function(t,e){return void 0===e&&(e={}),this.url&&this.url.parameter(t,e)||S($e(this.params),At("id",t))||e.inherit&&this.parent&&this.parent.parameter(t)},t.prototype.toString=function(){return this.fqn()},t.isStateClass=function(t){return Yt(t)&&!0===t.__uiRouterState},t.isState=function(t){return te(t.__stateObjectCache)},t}(),Gt=Object.prototype.toString,Wt=function(t){return function(e){return typeof e===t}},zt=Wt("undefined"),Jt=qt(zt),Qt=function(t){return null===t},Kt=a(Qt,zt),Yt=Wt("function"),Zt=Wt("number"),Xt=Wt("string"),te=function(t){return null!==t&&"object"==typeof t},ee=Array.isArray,re=function(t){return"[object Date]"===Gt.call(t)},ne=function(t){return"[object RegExp]"===Gt.call(t)},ie=Bt.isState,oe=o(te,i(Vt("then"),Yt)),ae=function(t){return function(){throw new Error(t+"(): No coreservices implementation for UI-Router is loaded.")}},ue={$q:void 0,$injector:void 0},se=("undefined"==typeof window?{}:window).angular||{},ce=se.fromJson||JSON.parse.bind(JSON),fe=se.toJson||JSON.stringify.bind(JSON),le=se.forEach||function(t,e,r){if(ee(t))return t.forEach(e,r);Object.keys(t).forEach(function(r){return e(t[r],r)})},he=Object.assign||O,pe=se.equals||x,de=function(t,e){return he(Object.create(t),e)},ve=r(p),me=r(d),ye=r(v),ge=function(t){return t.slice().forEach(function(e){"function"==typeof e&&e(),me(t,e)})},we=function(t,e){return he(t,e)},_e=b,$e=function(t){return Object.keys(t).map(function(e){return t[e]})},Se=function(t,e){return t&&e},be=function(t,e){return t||e},Re=function(t,e){return t.concat(e)},Ee=function(t,e){return ee(e)?t.concat(e.reduce(Ee,[])):R(t,e)},Ce=function(t,e){return ve(t,e)?t:R(t,e)},Te=function(t){return t.reduce(Re,[])},Pe=function(t){return t.reduce(Ee,[])},ke=E,Oe=E,xe=function(t){return Object.keys(t).map(function(e){return[e,t[e]]})},Ie=function(t){return t.catch(function(t){return 0})&&t},je=function(t){return Ie(ue.$q.reject(t))},Ve=function(){function t(t,e){void 0===t&&(t=[]),void 0===e&&(e=null),this._items=t,this._limit=e}return t.prototype.enqueue=function(t){var e=this._items;return e.push(t),this._limit&&e.length>this._limit&&e.shift(),t},t.prototype.dequeue=function(){if(this.size())return this._items.splice(0,1)[0]},t.prototype.clear=function(){var t=this._items;return this._items=[],t},t.prototype.size=function(){return this._items.length},t.prototype.remove=function(t){var e=this._items.indexOf(t);return e>-1&&this._items.splice(e,1)[0]},t.prototype.peekTail=function(){return this._items[this._items.length-1]},t.prototype.peekHead=function(){if(this.size())return this._items[0]},t}();!function(t){t[t.SUPERSEDED=2]="SUPERSEDED",t[t.ABORTED=3]="ABORTED",t[t.INVALID=4]="INVALID",t[t.IGNORED=5]="IGNORED",t[t.ERROR=6]="ERROR"}(t.RejectType||(t.RejectType={}));var Ae=0,He=function(){function e(t,e,r){this.$id=Ae++,this.type=t,this.message=e,this.detail=r}return e.prototype.toString=function(){var t=function(t){return t&&t.toString!==Object.prototype.toString?t.toString():J(t)}(this.detail),e=this;return"Transition Rejection($id: "+e.$id+" type: "+e.type+", message: "+e.message+", detail: "+t+")"},e.prototype.toPromise=function(){return he(je(this),{_transitionRejection:this})},e.isRejectionPromise=function(t){return t&&"function"==typeof t.then&&Nt(e)(t._transitionRejection)},e.superseded=function(r,n){var i=new e(t.RejectType.SUPERSEDED,"The transition has been superseded by a different transition",r);return n&&n.redirected&&(i.redirected=!0),i},e.redirected=function(t){return e.superseded(t,{redirected:!0})},e.invalid=function(r){return new e(t.RejectType.INVALID,"This transition is invalid",r)},e.ignored=function(r){return new e(t.RejectType.IGNORED,"The transition was ignored",r)},e.aborted=function(r){return new e(t.RejectType.ABORTED,"The transition has been aborted",r)},e.errored=function(r){return new e(t.RejectType.ERROR,"The transition errored",r)},e.normalize=function(t){return Nt(e)(t)?t:e.errored(t)},e}(),qe=function(t){var e=t.viewDecl,r=e.$context.name||"(root)";return"[View#"+t.$id+" from '"+r+"' state]: target ui-view: '"+e.$uiViewName+"@"+e.$uiViewContextAnchor+"'"},De=Yt(console.table)?console.table.bind(console):console.log.bind(console);!function(t){t[t.RESOLVE=0]="RESOLVE",t[t.TRANSITION=1]="TRANSITION",t[t.HOOK=2]="HOOK",t[t.UIVIEW=3]="UIVIEW",t[t.VIEWCONFIG=4]="VIEWCONFIG"}(t.Category||(t.Category={}));var Fe=Ht("$id"),Ne=Ht("router.$id"),Ue=function(t){return"Transition #"+Fe(t)+"-"+Ne(t)},Le=function(){function e(){this._enabled={},this.approximateDigests=0}return e.prototype._set=function(e,r){var n=this;r.length||(r=Object.keys(t.Category).map(function(t){return parseInt(t,10)}).filter(function(t){return!isNaN(t)}).map(function(e){return t.Category[e]})),r.map(V).forEach(function(t){return n._enabled[t]=e})},e.prototype.enable=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];this._set(!0,t)},e.prototype.disable=function(){for(var t=[],e=0;e<arguments.length;e++)t[e]=arguments[e];this._set(!1,t)},e.prototype.enabled=function(t){return!!this._enabled[V(t)]},e.prototype.traceTransitionStart=function(e){this.enabled(t.Category.TRANSITION)&&console.log(Ue(e)+": Started  -> "+J(e))},e.prototype.traceTransitionIgnored=function(e){this.enabled(t.Category.TRANSITION)&&console.log(Ue(e)+": Ignored  <> "+J(e))},e.prototype.traceHookInvocation=function(e,r,n){if(this.enabled(t.Category.HOOK)){var i=Ht("traceData.hookType")(n)||"internal",o=Ht("traceData.context.state.name")(n)||Ht("traceData.context")(n)||"unknown",a=W(e.registeredHook.callback);console.log(Ue(r)+":   Hook -> "+i+" context: "+o+", "+M(200,a))}},e.prototype.traceHookResult=function(e,r,n){this.enabled(t.Category.HOOK)&&console.log(Ue(r)+":   <- Hook returned: "+M(200,J(e)))},e.prototype.traceResolvePath=function(e,r,n){this.enabled(t.Category.RESOLVE)&&console.log(Ue(n)+":         Resolving "+e+" ("+r+")")},e.prototype.traceResolvableResolved=function(e,r){this.enabled(t.Category.RESOLVE)&&console.log(Ue(r)+":               <- Resolved  "+e+" to: "+M(200,J(e.data)))},e.prototype.traceError=function(e,r){this.enabled(t.Category.TRANSITION)&&console.log(Ue(r)+": <- Rejected "+J(r)+", reason: "+e)},e.prototype.traceSuccess=function(e,r){this.enabled(t.Category.TRANSITION)&&console.log(Ue(r)+": <- Success  "+J(r)+", final state: "+e.name)},e.prototype.traceUIViewEvent=function(e,r,n){void 0===n&&(n=""),this.enabled(t.Category.UIVIEW)&&console.log("ui-view: "+B(30,e)+" "+j(r)+n)},e.prototype.traceUIViewConfigUpdated=function(e,r){this.enabled(t.Category.UIVIEW)&&this.traceUIViewEvent("Updating",e," with ViewConfig from context='"+r+"'")},e.prototype.traceUIViewFill=function(e,r){this.enabled(t.Category.UIVIEW)&&this.traceUIViewEvent("Fill",e," with: "+M(200,r))},e.prototype.traceViewSync=function(e){if(this.enabled(t.Category.VIEWCONFIG)){var r=e.map(function(t){var e=t[0],r=t[1];return{"ui-view fqn":e.$type+":"+e.fqn,"state: view name":r&&r.viewDecl.$context.name+": "+r.viewDecl.$name+" ("+r.viewDecl.$type+")"}}).sort(function(t,e){return t["ui-view fqn"].localeCompare(e["ui-view fqn"])});De(r)}},e.prototype.traceViewServiceEvent=function(e,r){this.enabled(t.Category.VIEWCONFIG)&&console.log("VIEWCONFIG: "+e+" "+qe(r))},e.prototype.traceViewServiceUIViewEvent=function(e,r){this.enabled(t.Category.VIEWCONFIG)&&console.log("VIEWCONFIG: "+e+" "+j(r))},e}(),Me=new Le;!function(t){t[t.CREATE=0]="CREATE",t[t.BEFORE=1]="BEFORE",t[t.RUN=2]="RUN",t[t.SUCCESS=3]="SUCCESS",t[t.ERROR=4]="ERROR"}(t.TransitionHookPhase||(t.TransitionHookPhase={})),function(t){t[t.TRANSITION=0]="TRANSITION",t[t.STATE=1]="STATE"}(t.TransitionHookScope||(t.TransitionHookScope={}));var Be=function(){function t(t,e,r,n){this._stateRegistry=t,this._identifier=e,this._identifier=e,this._params=he({},r||{}),this._options=he({},n||{}),this._definition=t.matcher.find(e,this._options.relative)}return t.prototype.name=function(){return this._definition&&this._definition.name||this._identifier},t.prototype.identifier=function(){return this._identifier},t.prototype.params=function(){return this._params},t.prototype.$state=function(){return this._definition},t.prototype.state=function(){return this._definition&&this._definition.self},t.prototype.options=function(){return this._options},t.prototype.exists=function(){return!(!this._definition||!this._definition.self)},t.prototype.valid=function(){return!this.error()},t.prototype.error=function(){var t=this.options().relative;if(!this._definition&&t){var e=t.name?t.name:t;return"Could not resolve '"+this.name()+"' from state '"+e+"'"}return this._definition?this._definition.self?void 0:"State '"+this.name()+"' has an invalid definition":"No such state '"+this.name()+"'"},t.prototype.toString=function(){return"'"+this.name()+"'"+J(this.params())},t.prototype.withState=function(e){return new t(this._stateRegistry,e,this._params,this._options)},t.prototype.withParams=function(e,r){void 0===r&&(r=!1);var n=r?e:he({},this._params,e);return new t(this._stateRegistry,this._identifier,n,this._options)},t.prototype.withOptions=function(e,r){void 0===r&&(r=!1);var n=r?e:he({},this._options,e);return new t(this._stateRegistry,this._identifier,this._params,n)},t.isDef=function(t){return t&&t.state&&(Xt(t.state)||Xt(t.state.name))},t}(),Ge={current:l,transition:null,traceData:{},bind:null},We=function(){function e(e,r,n,i){var o=this;this.transition=e,this.stateContext=r,this.registeredHook=n,this.options=i,this.isSuperseded=function(){return o.type.hookPhase===t.TransitionHookPhase.RUN&&!o.options.transition.isActive()},this.options=m(i,Ge),this.type=n.eventType}return e.prototype.logError=function(t){this.transition.router.stateService.defaultErrorHandler()(t)},e.prototype.invokeHook=function(){var t=this,e=this.registeredHook;if(!e._deregistered){var r=this.getNotCurrentRejection();if(r)return r;var n=this.options;Me.traceHookInvocation(this,this.transition,n);var i=function(r){return e.eventType.getErrorHandler(t)(r)},o=function(r){return e.eventType.getResultHandler(t)(r)};try{var a=e.callback.call(n.bind,t.transition,t.stateContext);return!this.type.synchronous&&oe(a)?a.catch(function(t){return He.normalize(t).toPromise()}).then(o,i):o(a)}catch(t){return i(He.normalize(t))}}},e.prototype.handleHookResult=function(t){var e=this,r=this.getNotCurrentRejection();return r||(oe(t)?t.then(function(t){return e.handleHookResult(t)}):(Me.traceHookResult(t,this.transition,this.options),!1===t?He.aborted("Hook aborted transition").toPromise():Nt(Be)(t)?He.redirected(t).toPromise():void 0))},e.prototype.getNotCurrentRejection=function(){var t=this.transition.router;return t._disposed?He.aborted("UIRouter instance #"+t.$id+" has been stopped (disposed)").toPromise():this.transition._aborted?He.aborted().toPromise():this.isSuperseded()?He.superseded(this.options.current()).toPromise():void 0},e.prototype.toString=function(){var t=this,e=t.options,r=t.registeredHook;return(Ht("traceData.hookType")(e)||"internal")+" context: "+(Ht("traceData.context.state.name")(e)||Ht("traceData.context")(e)||"unknown")+", "+M(200,z(r.callback))},e.chain=function(t,e){return t.reduce(function(t,e){return t.then(function(){return e.invokeHook()})},e||ue.$q.when())},e.invokeHooks=function(t,r){for(var n=0;n<t.length;n++){var i=t[n].invokeHook();if(oe(i)){var o=t.slice(n+1);return e.chain(o,i).then(r)}}return r()},e.runAllHooks=function(t){t.forEach(function(t){return t.invokeHook()})},e.HANDLE_RESULT=function(t){return function(e){return t.handleHookResult(e)}},e.LOG_REJECTED_RESULT=function(t){return function(e){oe(e)&&e.catch(function(e){return t.logError(He.normalize(e))})}},e.LOG_ERROR=function(t){return function(e){return t.logError(e)}},e.REJECT_ERROR=function(t){return function(t){return je(t)}},e.THROW_ERROR=function(t){return function(t){throw t}},e}(),ze=function(){function e(t,e,r,n,i){void 0===i&&(i={}),this.tranSvc=t,this.eventType=e,this.callback=r,this.matchCriteria=n,this.priority=i.priority||0,this.bind=i.bind||null,this._deregistered=!1}return e.prototype._matchingNodes=function(t,e){if(!0===e)return t;var r=t.filter(function(t){return A(t.state,e)});return r.length?r:null},e.prototype._getDefaultMatchCriteria=function(){return b(this.tranSvc._pluginapi._getPathTypes(),function(){return!0})},e.prototype._getMatchingNodes=function(e){var r=this,n=he(this._getDefaultMatchCriteria(),this.matchCriteria);return $e(this.tranSvc._pluginapi._getPathTypes()).reduce(function(i,o){var a=o.scope===t.TransitionHookScope.STATE,u=e[o.name]||[],s=a?u:[P(u)];return i[o.name]=r._matchingNodes(s,n[o.name]),i},{})},e.prototype.matches=function(t){var e=this._getMatchingNodes(t);return $e(e).every(f)?e:null},e}(),Je=function(){function e(t){this.transition=t}return e.prototype.buildHooksForPhase=function(t){var e=this;return this.transition.router.transitionService._pluginapi._getEvents(t).map(function(t){return e.buildHooks(t)}).reduce(Re,[]).filter(f)},e.prototype.buildHooks=function(e){var r=this.transition,n=r.treeChanges(),i=this.getMatchingHooks(e,n);if(!i)return[];var o={transition:r,current:r.options().current};return i.map(function(i){return i.matches(n)[e.criteriaMatchPath.name].map(function(n){var a=he({bind:i.bind,traceData:{hookType:e.name,context:n}},o),u=e.criteriaMatchPath.scope===t.TransitionHookScope.STATE?n.state.self:null,s=new We(r,u,i,a);return{hook:i,node:n,transitionHook:s}})}).reduce(Re,[]).sort(q(e.reverseSort)).map(function(t){return t.transitionHook})},e.prototype.getMatchingHooks=function(e,r){var n=e.hookPhase===t.TransitionHookPhase.CREATE,i=this.transition.router.transitionService;return(n?[i]:[this.transition,i]).map(function(t){return t.getHooks(e.name)}).filter(ke(ee,"broken event named: "+e.name)).reduce(Re,[]).filter(function(t){return t.matches(r)})},e}(),Qe=function(){function t(t){this.pattern=/.*/,this.inherit=!0,he(this,t)}return t.prototype.is=function(t,e){return!0},t.prototype.encode=function(t,e){return t},t.prototype.decode=function(t,e){return t},t.prototype.equals=function(t,e){return t==e},t.prototype.$subPattern=function(){var t=this.pattern.toString();return t.substr(1,t.length-2)},t.prototype.toString=function(){return"{ParamType:"+this.name+"}"},t.prototype.$normalize=function(t){return this.is(t)?t:this.decode(t)},t.prototype.$asArray=function(t,e){if(!t)return this;if("auto"===t&&!e)throw new Error("'auto' array mode is for query parameters only");return new D(this,t)},t}(),Ke=Object.prototype.hasOwnProperty,Ye=function(t){return 0===["value","type","squash","array","dynamic"].filter(Ke.bind(t||{})).length};!function(t){t[t.PATH=0]="PATH",t[t.SEARCH=1]="SEARCH",t[t.CONFIG=2]="CONFIG"}(t.DefType||(t.DefType={}));var Ze=function(){function e(e,r,n,i,o){r=N(n=F(n),r,i,e,o.paramTypes);var a=function(){var r={array:i===t.DefType.SEARCH&&"auto"},o=e.match(/\[\]$/)?{array:!0}:{};return he(r,o,n).array}();r=a?r.$asArray(a,i===t.DefType.SEARCH):r;var u=void 0!==n.value||i===t.DefType.SEARCH,s=Jt(n.dynamic)?!!n.dynamic:!!r.dynamic,c=Jt(n.raw)?!!n.raw:!!r.raw,f=U(n,u,o.defaultSquashPolicy()),l=L(n,a,u,f),h=Jt(n.inherit)?!!n.inherit:!!r.inherit;he(this,{id:e,type:r,location:i,isOptional:u,dynamic:s,raw:c,squash:f,replace:l,inherit:h,array:a,config:n})}return e.prototype.isDefaultValue=function(t){return this.isOptional&&this.type.equals(this.value(),t)},e.prototype.value=function(t){var e=this;return t=function(t){for(var r=0,n=e.replace;r<n.length;r++){var i=n[r];if(i.from===t)return i.to}return t}(t),zt(t)?function(){if(e._defaultValueCache)return e._defaultValueCache.defaultValue;if(!ue.$injector)throw new Error("Injectable functions cannot be called at configuration time");var t=ue.$injector.invoke(e.config.$$fn);if(null!==t&&void 0!==t&&!e.type.is(t))throw new Error("Default value ("+t+") for parameter '"+e.id+"' is not an instance of ParamType ("+e.type.name+")");return e.config.$$fn.__cacheable&&(e._defaultValueCache={defaultValue:t}),t}():this.type.$normalize(t)},e.prototype.isSearch=function(){return this.location===t.DefType.SEARCH},e.prototype.validates=function(t){if((zt(t)||null===t)&&this.isOptional)return!0;var e=this.type.$normalize(t);if(!this.type.is(e))return!1;var r=this.type.encode(e);return!(Xt(r)&&!this.type.pattern.exec(r))},e.prototype.toString=function(){return"{Param:"+this.id+" "+this.type+" squash: '"+this.squash+"' optional: "+this.isOptional+"}"},e.values=function(t,e){void 0===e&&(e={});for(var r={},n=0,i=t;n<i.length;n++){var o=i[n];r[o.id]=o.value(e[o.id])}return r},e.changed=function(t,e,r){return void 0===e&&(e={}),void 0===r&&(r={}),t.filter(function(t){return!t.type.equals(e[t.id],r[t.id])})},e.equals=function(t,r,n){return void 0===r&&(r={}),void 0===n&&(n={}),0===e.changed(t,r,n).length},e.validates=function(t,e){return void 0===e&&(e={}),t.map(function(t){return t.validates(e[t.id])}).reduce(Se,!0)},e}(),Xe=function(){function t(e){if(e instanceof t){var r=e;this.state=r.state,this.paramSchema=r.paramSchema.slice(),this.paramValues=he({},r.paramValues),this.resolvables=r.resolvables.slice(),this.views=r.views&&r.views.slice()}else{var n=e;this.state=n,this.paramSchema=n.parameters({inherit:!1}),this.paramValues={},this.resolvables=n.resolvables.map(function(t){return t.clone()})}}return t.prototype.applyRawParams=function(t){var e=function(e){return[e.id,e.value(t[e.id])]};return this.paramValues=this.paramSchema.reduce(function(t,r){return T(t,e(r))},{}),this},t.prototype.parameter=function(t){return S(this.paramSchema,At("id",t))},t.prototype.equals=function(t,e){var r=this.diff(t,e);return r&&0===r.length},t.prototype.diff=function(t,e){if(this.state!==t.state)return!1;var r=e?e(this):this.paramSchema;return Ze.changed(r,this.paramValues,t.paramValues)},t.clone=function(e){return new t(e)},t}(),tr=function(){function t(){}return t.makeTargetState=function(t,e){var r=P(e).state;return new Be(t,r,e.map(Vt("paramValues")).reduce(we,{}),{})},t.buildPath=function(t){var e=t.params();return t.$state().path.map(function(t){return new Xe(t).applyRawParams(e)})},t.buildToPath=function(e,r){var n=t.buildPath(r);return r.options().inherit?t.inheritParams(e,n,Object.keys(r.params())):n},t.applyViewConfigs=function(e,r,n){r.filter(function(t){return ve(n,t.state)}).forEach(function(n){var i=$e(n.state.views||{}),o=t.subPath(r,function(t){return t===n}),a=i.map(function(t){return e.createViewConfig(o,t)});n.views=a.reduce(Re,[])})},t.inheritParams=function(t,e,r){function n(t,e){var r=S(t,At("state",e));return he({},r&&r.paramValues)}void 0===r&&(r=[]);var i=t.map(function(t){return t.paramSchema}).reduce(Re,[]).filter(function(t){return!t.inherit}).map(Vt("id"));return e.map(function(e){var o=he({},e&&e.paramValues),a=g(o,r);o=w(o,r);var u=w(n(t,e.state)||{},i),s=he(o,u,a);return new Xe(e.state).applyRawParams(s)})},t.treeChanges=function(e,r,n){for(var i=0,o=Math.min(e.length,r.length);i<o&&e[i].state!==n&&function(e,r){return e.equals(r,t.nonDynamicParams)}(e[i],r[i]);)i++;var a,u,s,c,f;u=(a=e).slice(0,i),s=a.slice(i);var l=u.map(function(t,e){var n=Xe.clone(t);return n.paramValues=r[e].paramValues,n});return c=r.slice(i),f=l.concat(c),{from:a,to:f,retained:u,exiting:s,entering:c}},t.matching=function(t,e,r){var n=!1;return C(t,e).reduce(function(t,e){var i=e[0],o=e[1];return(n=n||!i.equals(o,r))?t:t.concat(i)},[])},t.equals=function(e,r,n){return e.length===r.length&&t.matching(e,r,n).length===e.length},t.subPath=function(t,e){var r=S(t,e),n=t.indexOf(r);return-1===n?void 0:t.slice(0,n+1)},t.nonDynamicParams=function(t){return t.state.parameters({inherit:!1}).filter(function(t){return!t.dynamic})},t.paramValues=function(t){return t.reduce(function(t,e){return he(t,e.paramValues)},{})},t}(),er={when:"LAZY",async:"WAIT"},rr=function(){function t(e,r,n,i,o){if(this.resolved=!1,this.promise=void 0,e instanceof t)he(this,e);else if(Yt(r)){if(Kt(e))throw new Error("new Resolvable(): token argument is required");if(!Yt(r))throw new Error("new Resolvable(): resolveFn argument must be a function");this.token=e,this.policy=i,this.resolveFn=r,this.deps=n||[],this.data=o,this.resolved=void 0!==o,this.promise=this.resolved?ue.$q.when(this.data):void 0}else if(te(e)&&e.token&&Yt(e.resolveFn)){var a=e;return new t(a.token,a.resolveFn,a.deps,a.policy,a.data)}}return t.prototype.getPolicy=function(t){var e=this.policy||{},r=t&&t.resolvePolicy||{};return{when:e.when||r.when||er.when,async:e.async||r.async||er.async}},t.prototype.resolve=function(t,e){var r=this,n=ue.$q,i=t.findNode(this),o=i&&i.state,a="RXWAIT"===this.getPolicy(o).async?function(t){var e=t.cache(1);return e.take(1).toPromise().then(function(){return e})}:f;return this.promise=n.when().then(function(){return n.all(t.getDependencies(r).map(function(r){return r.get(t,e)}))}).then(function(t){return r.resolveFn.apply(null,t)}).then(a).then(function(t){return r.data=t,r.resolved=!0,Me.traceResolvableResolved(r,e),r.data})},t.prototype.get=function(t,e){return this.promise||this.resolve(t,e)},t.prototype.toString=function(){return"Resolvable(token: "+J(this.token)+", requires: ["+this.deps.map(J)+"])"},t.prototype.clone=function(){return new t(this)},t.fromData=function(e,r){return new t(e,function(){return r},null,null,r)},t}(),nr={when:{LAZY:"LAZY",EAGER:"EAGER"},async:{WAIT:"WAIT",NOWAIT:"NOWAIT",RXWAIT:"RXWAIT"}},ir=nr.when,or=[ir.EAGER,ir.LAZY],ar=[ir.EAGER],ur="Native Injector",sr=function(){function t(t){this._path=t}return t.prototype.getTokens=function(){return this._path.reduce(function(t,e){return t.concat(e.resolvables.map(function(t){return t.token}))},[]).reduce(Ce,[])},t.prototype.getResolvable=function(t){return P(this._path.map(function(t){return t.resolvables}).reduce(Re,[]).filter(function(e){return e.token===t}))},t.prototype.getPolicy=function(t){var e=this.findNode(t);return t.getPolicy(e.state)},t.prototype.subContext=function(e){return new t(tr.subPath(this._path,function(t){return t.state===e}))},t.prototype.addResolvables=function(t,e){var r=S(this._path,At("state",e)),n=t.map(function(t){return t.token});r.resolvables=r.resolvables.filter(function(t){return-1===n.indexOf(t.token)}).concat(t)},t.prototype.resolvePath=function(t,e){var r=this;void 0===t&&(t="LAZY");var n=(ve(or,t)?t:"LAZY")===nr.when.EAGER?ar:or;Me.traceResolvePath(this._path,t,e);var i=function(t,e){return function(n){return ve(t,r.getPolicy(n)[e])}},o=this._path.reduce(function(t,o){var a=o.resolvables.filter(i(n,"when")),u=a.filter(i(["NOWAIT"],"async")),s=a.filter(qt(i(["NOWAIT"],"async"))),c=r.subContext(o.state),f=function(t){return t.get(c,e).then(function(e){return{token:t.token,value:e}})};return u.forEach(f),t.concat(s.map(f))},[]);return ue.$q.all(o)},t.prototype.injector=function(){return this._injector||(this._injector=new cr(this))},t.prototype.findNode=function(t){return S(this._path,function(e){return ve(e.resolvables,t)})},t.prototype.getDependencies=function(t){var e=this,r=this.findNode(t),n=(tr.subPath(this._path,function(t){return t===r})||this._path).reduce(function(t,e){return t.concat(e.resolvables)},[]).filter(function(e){return e!==t});return t.deps.map(function(t){var r=n.filter(function(e){return e.token===t});if(r.length)return P(r);var i=e.injector().getNative(t);if(zt(i))throw new Error("Could not find Dependency Injection token: "+J(t));return new rr(t,function(){return i},[],i)})},t}(),cr=function(){function t(t){this.context=t,this.native=this.get(ur)||ue.$injector}return t.prototype.get=function(t){var e=this.context.getResolvable(t);if(e){if("NOWAIT"===this.context.getPolicy(e).async)return e.get(this.context);if(!e.resolved)throw new Error("Resolvable async .get() not complete:"+J(e.token));return e.data}return this.getNative(t)},t.prototype.getAsync=function(t){var e=this.context.getResolvable(t);return e?e.get(this.context):ue.$q.when(this.native.get(t))},t.prototype.getNative=function(t){return this.native&&this.native.get(t)},t}(),fr=Vt("self"),lr=function(){function e(e,r,n){var i=this;if(this._deferred=ue.$q.defer(),this.promise=this._deferred.promise,this._registeredHooks={},this._hookBuilder=new Je(this),this.isActive=function(){return i.router.globals.transition===i},this.router=n,this._targetState=r,!r.valid())throw new Error(r.error());this._options=he({current:Lt(this)},r.options()),this.$id=n.transitionService._transitionCount++;var o=tr.buildToPath(e,r);this._treeChanges=tr.treeChanges(e,o,this._options.reloadState),this.createTransitionHookRegFns();var a=this._hookBuilder.buildHooksForPhase(t.TransitionHookPhase.CREATE);We.invokeHooks(a,function(){return null}),this.applyViewConfigs(n)}return e.prototype.onBefore=function(t,e,r){},e.prototype.onStart=function(t,e,r){},e.prototype.onExit=function(t,e,r){},e.prototype.onRetain=function(t,e,r){},e.prototype.onEnter=function(t,e,r){},e.prototype.onFinish=function(t,e,r){},e.prototype.onSuccess=function(t,e,r){},e.prototype.onError=function(t,e,r){},e.prototype.createTransitionHookRegFns=function(){var e=this;this.router.transitionService._pluginapi._getEvents().filter(function(e){return e.hookPhase!==t.TransitionHookPhase.CREATE}).forEach(function(t){return H(e,e.router.transitionService,t)})},e.prototype.getHooks=function(t){return this._registeredHooks[t]},e.prototype.applyViewConfigs=function(t){var e=this._treeChanges.entering.map(function(t){return t.state});tr.applyViewConfigs(t.transitionService.$view,this._treeChanges.to,e)},e.prototype.$from=function(){return P(this._treeChanges.from).state},e.prototype.$to=function(){return P(this._treeChanges.to).state},e.prototype.from=function(){return this.$from().self},e.prototype.to=function(){return this.$to().self},e.prototype.targetState=function(){return this._targetState},e.prototype.is=function(t){return t instanceof e?this.is({to:t.$to().name,from:t.$from().name}):!(t.to&&!A(this.$to(),t.to)||t.from&&!A(this.$from(),t.from))},e.prototype.params=function(t){return void 0===t&&(t="to"),Object.freeze(this._treeChanges[t].map(Vt("paramValues")).reduce(we,{}))},e.prototype.injector=function(t,e){void 0===e&&(e="to");var r=this._treeChanges[e];return t&&(r=tr.subPath(r,function(e){return e.state===t||e.state.name===t})),new sr(r).injector()},e.prototype.getResolveTokens=function(t){return void 0===t&&(t="to"),new sr(this._treeChanges[t]).getTokens()},e.prototype.addResolvable=function(t,e){void 0===e&&(e=""),t=Nt(rr)(t)?t:new rr(t);var r="string"==typeof e?e:e.name,n=this._treeChanges.to,i=S(n,function(t){return t.state.name===r});new sr(n).addResolvables([t],i.state)},e.prototype.redirectedFrom=function(){return this._options.redirectedFrom||null},e.prototype.originalTransition=function(){var t=this.redirectedFrom();return t&&t.originalTransition()||this},e.prototype.options=function(){return this._options},e.prototype.entering=function(){return b(this._treeChanges.entering,Vt("state")).map(fr)},e.prototype.exiting=function(){return b(this._treeChanges.exiting,Vt("state")).map(fr).reverse()},e.prototype.retained=function(){return b(this._treeChanges.retained,Vt("state")).map(fr)},e.prototype.views=function(t,e){void 0===t&&(t="entering");var r=this._treeChanges[t];return(r=e?r.filter(At("state",e)):r).map(Vt("views")).filter(f).reduce(Re,[])},e.prototype.treeChanges=function(t){return t?this._treeChanges[t]:this._treeChanges},e.prototype.redirect=function(t){for(var e=1,r=this;null!=(r=r.redirectedFrom());)if(++e>20)throw new Error("Too many consecutive Transition redirects (20+)");var n={redirectedFrom:this,source:"redirect"};"url"===this.options().source&&!1!==t.options().location&&(n.location="replace");var i=he({},this.options(),t.options(),n);t=t.withOptions(i,!0);var o=this.router.transitionService.create(this._treeChanges.from,t),a=this._treeChanges.entering,u=o._treeChanges.entering;return tr.matching(u,a,tr.nonDynamicParams).filter(qt(function(t){return function(e){return t&&e.state.includes[t.name]}}(t.options().reloadState))).forEach(function(t,e){t.resolvables=a[e].resolvables}),o},e.prototype._changedParams=function(){var t=this._treeChanges;if(!(this._options.reload||t.exiting.length||t.entering.length||t.to.length!==t.from.length||C(t.to,t.from).map(function(t){return t[0].state!==t[1].state}).reduce(be,!1))){var e=t.to.map(function(t){return t.paramSchema}),r=[t.to,t.from].map(function(t){return t.map(function(t){return t.paramValues})});return C(e,r[0],r[1]).map(function(t){var e=t[0],r=t[1],n=t[2];return Ze.changed(e,r,n)}).reduce(Re,[])}},e.prototype.dynamic=function(){var t=this._changedParams();return!!t&&t.map(function(t){return t.dynamic}).reduce(be,!1)},e.prototype.ignored=function(){return!!this._ignoredReason()},e.prototype._ignoredReason=function(){var t=this.router.globals.transition,e=this._options.reloadState,r=function(t,r){if(t.length!==r.length)return!1;var n=tr.matching(t,r);return t.length===n.filter(function(t){return!e||!t.state.includes[e.name]}).length},n=this.treeChanges(),i=t&&t.treeChanges();return i&&r(i.to,n.to)&&r(i.exiting,n.exiting)?"SameAsPending":0===n.exiting.length&&0===n.entering.length&&r(n.from,n.to)?"SameAsCurrent":void 0},e.prototype.run=function(){var e=this,r=We.runAllHooks,n=function(t){return e._hookBuilder.buildHooksForPhase(t)},i=n(t.TransitionHookPhase.BEFORE);return We.invokeHooks(i,function(){var t=e.router.globals;return t.lastStartedTransitionId=e.$id,t.transition=e,t.transitionHistory.enqueue(e),Me.traceTransitionStart(e),ue.$q.when(void 0)}).then(function(){var e=n(t.TransitionHookPhase.RUN);return We.invokeHooks(e,function(){return ue.$q.when(void 0)})}).then(function(){Me.traceSuccess(e.$to(),e),e.success=!0,e._deferred.resolve(e.to()),r(n(t.TransitionHookPhase.SUCCESS))},function(i){Me.traceError(i,e),e.success=!1,e._deferred.reject(i),e._error=i,r(n(t.TransitionHookPhase.ERROR))}),this.promise},e.prototype.valid=function(){return!this.error()||void 0!==this.success},e.prototype.abort=function(){zt(this.success)&&(this._aborted=!0)},e.prototype.error=function(){var t=this.$to();if(t.self.abstract)return"Cannot transition to abstract state '"+t.name+"'";var e=t.parameters(),r=this.params(),n=e.filter(function(t){return!t.validates(r[t.id])});return n.length?"Param values not valid for state '"+t.name+"'. Invalid params: [ "+n.map(function(t){return t.id}).join(", ")+" ]":!1===this.success?this._error:void 0},e.prototype.toString=function(){var t=this.from(),e=this.to(),r=function(t){return null!==t["#"]&&void 0!==t["#"]?t:w(t,["#"])};return"Transition#"+this.$id+"( '"+(te(t)?t.name:t)+"'"+J(r(this._treeChanges.from.map(Vt("paramValues")).reduce(we,{})))+" -> "+(this.valid()?"":"(X) ")+"'"+(te(e)?e.name:e)+"'"+J(r(this.params()))+" )"},e.diToken=e,e}(),hr=null,pr=function(t){var e=He.isRejectionPromise;return(hr=hr||s([[qt(Jt),Lt("undefined")],[Qt,Lt("null")],[oe,Lt("[Promise]")],[e,function(t){return t._transitionRejection.toString()}],[Nt(He),u("toString")],[Nt(lr),u("toString")],[Nt(rr),u("toString")],[c,W],[Lt(!0),f]]))(t)},dr=function(t){return function(e){if(!e)return["",""];var r=e.indexOf(t);return-1===r?[e,""]:[e.substr(0,r),e.substr(r+1)]}},vr=new RegExp("^(?:[a-z]+:)?//[^/]+/"),mr=function(t){return t.replace(/\/[^/]*$/,"")},yr=dr("#"),gr=dr("?"),wr=dr("="),_r=function(t){return t?t.replace(/^#/,""):""},$r=function(){function t(){this.enqueue=!0,this.typeQueue=[],this.defaultTypes=g(t.prototype,["hash","string","query","path","int","bool","date","json","any"]);this.types=de(b(this.defaultTypes,function(t,e){return new Qe(he({name:e},t))}),{})}return t.prototype.dispose=function(){this.types={}},t.prototype.type=function(t,e,r){if(!Jt(e))return this.types[t];if(this.types.hasOwnProperty(t))throw new Error("A type named '"+t+"' has already been defined.");return this.types[t]=new Qe(he({name:t},e)),r&&(this.typeQueue.push({name:t,def:r}),this.enqueue||this._flushTypeQueue()),this},t.prototype._flushTypeQueue=function(){for(;this.typeQueue.length;){var t=this.typeQueue.shift();if(t.pattern)throw new Error("You cannot override a type's .pattern at runtime.");he(this.types[t.name],ue.$injector.invoke(t.def))}},t}();!function(){var t=function(t){var e=function(t){return null!=t?t.toString():t},r={encode:e,decode:e,is:Nt(String),pattern:/.*/,equals:function(t,e){return t==e}};return he({},r,t)};he($r.prototype,{string:t({}),path:t({pattern:/[^/]*/}),query:t({}),hash:t({inherit:!1}),int:t({decode:function(t){return parseInt(t,10)},is:function(t){return!Kt(t)&&this.decode(t.toString())===t},pattern:/-?\d+/}),bool:t({encode:function(t){return t&&1||0},decode:function(t){return 0!==parseInt(t,10)},is:Nt(Boolean),pattern:/0|1/}),date:t({encode:function(t){return this.is(t)?[t.getFullYear(),("0"+(t.getMonth()+1)).slice(-2),("0"+t.getDate()).slice(-2)].join("-"):void 0},decode:function(t){if(this.is(t))return t;var e=this.capture.exec(t);return e?new Date(e[1],e[2]-1,e[3]):void 0},is:function(t){return t instanceof Date&&!isNaN(t.valueOf())},equals:function(t,e){return["getFullYear","getMonth","getDate"].reduce(function(r,n){return r&&t[n]()===e[n]()},!0)},pattern:/[0-9]{4}-(?:0[1-9]|1[0-2])-(?:0[1-9]|[1-2][0-9]|3[0-1])/,capture:/([0-9]{4})-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])/}),json:t({encode:fe,decode:ce,is:Nt(Object),equals:pe,pattern:/[^/]*/}),any:t({encode:f,decode:f,is:function(){return!0},equals:pe})})}();var Sr,br=function(){function t(t){void 0===t&&(t={}),he(this,t)}return t.prototype.$inherit=function(t,e,r){var n,i=y(e,r),o={},a=[];for(var u in i)if(i[u]&&i[u].params&&(n=Object.keys(i[u].params)).length)for(var s in n)a.indexOf(n[s])>=0||(a.push(n[s]),o[n[s]]=this[n[s]]);return he({},o,t)},t}(),Rr=function(t){if(!Xt(t))return!1;var e="^"===t.charAt(0);return{val:e?t.substring(1):t,root:e}},Er=function(t,e){return function(r){var n=r;n&&n.url&&n.name&&n.name.match(/\.\*\*$/)&&(n.url+="{remainder:any}");var i=Rr(n.url),o=r.parent,a=i?t.compile(i.val,{params:r.params||{},paramMap:function(t,e){return!1===n.reloadOnSearch&&e&&(t=he(t||{},{dynamic:!0})),t}}):n.url;if(!a)return null;if(!t.isMatcher(a))throw new Error("Invalid url '"+a+"' in state '"+r+"'");return i&&i.root?a:(o&&o.navigable||e()).url.append(a)}},Cr=function(t){return function(e){return!t(e)&&e.url?e:e.parent?e.parent.navigable:null}},Tr=function(t){return function(e){var r=e.url&&e.url.parameters({inherit:!1})||[],n=$e(_e(w(e.params||{},r.map(Vt("id"))),function(e,r){return t.fromConfig(r,null,e)}));return r.concat(n).map(function(t){return[t.id,t]}).reduce(T,{})}},Pr=function(){function t(t,e){this.matcher=t;var r=this,n=function(){return t.find("")},i=function(t){return""===t.name};this.builders={name:[Y],self:[Z],parent:[function(e){return i(e)?null:t.find(r.parentName(e))||n()}],data:[X],url:[Er(e,n)],navigable:[Cr(i)],params:[Tr(e.paramFactory)],views:[],path:[tt],includes:[et],resolvables:[rt]}}return t.prototype.builder=function(t,e){var r=this.builders,n=r[t]||[];return Xt(t)&&!Jt(e)?n.length>1?n:n[0]:Xt(t)&&Yt(e)?(r[t]=n,r[t].push(e),function(){return r[t].splice(r[t].indexOf(e,1))&&null}):void 0},t.prototype.build=function(t){var e=this,r=e.matcher,n=e.builders,i=this.parentName(t);if(i&&!r.find(i,void 0,!1))return null;for(var o in n)if(n.hasOwnProperty(o)){var a=n[o].reduce(function(t,e){return function(r){return e(r,t)}},l);t[o]=a(t)}return t},t.prototype.parentName=function(t){var e=t.name||"",r=e.split(".");if("**"===r.pop()&&r.pop(),r.length){if(t.parent)throw new Error("States that specify the 'parent:' property should not have a '.' in their name ("+e+")");return r.join(".")}return t.parent?Xt(t.parent)?t.parent:t.parent.name:""},t.prototype.name=function(t){var e=t.name;if(-1!==e.indexOf(".")||!t.parent)return e;var r=Xt(t.parent)?t.parent:t.parent.name;return r?r+"."+e:e},t}(),kr=function(){function t(t){this._states=t}return t.prototype.isRelative=function(t){return 0===(t=t||"").indexOf(".")||0===t.indexOf("^")},t.prototype.find=function(t,e,r){if(void 0===r&&(r=!0),t||""===t){var n=Xt(t),i=n?t:t.name;this.isRelative(i)&&(i=this.resolvePath(i,e));var o=this._states[i];if(o&&(n||!(n||o!==t&&o.self!==t)))return o;if(n&&r){var a=$e(this._states).filter(function(t){return t.__stateObjectCache.nameGlob&&t.__stateObjectCache.nameGlob.matches(i)});return a.length>1&&console.log("stateMatcher.find: Found multiple matches for "+i+" using glob: ",a.map(function(t){return t.name})),a[0]}}},t.prototype.resolvePath=function(t,e){if(!e)throw new Error("No reference point given for path '"+t+"'");for(var r=this.find(e),n=t.split("."),i=0,o=n.length,a=r;i<o;i++)if(""!==n[i]||0!==i){if("^"!==n[i])break;if(!a.parent)throw new Error("Path '"+t+"' not valid for state '"+r.name+"'");a=a.parent}else a=r;var u=n.slice(i).join(".");return a.name+(a.name&&u?".":"")+u},t}(),Or=function(){function t(t,e,r,n,i){this.$registry=t,this.$urlRouter=e,this.states=r,this.builder=n,this.listeners=i,this.queue=[],this.matcher=t.matcher}return t.prototype.dispose=function(){this.queue=[]},t.prototype.register=function(t){var e=this.queue,r=Bt.create(t),n=r.name;if(!Xt(n))throw new Error("State must have a valid name");if(this.states.hasOwnProperty(n)||ve(e.map(Vt("name")),n))throw new Error("State '"+n+"' is already defined");return e.push(r),this.flush(),r},t.prototype.flush=function(){for(var t=this,e=this,r=e.queue,n=e.states,i=e.builder,o=[],a=[],u={},s=function(e){return t.states.hasOwnProperty(e)&&t.states[e]};r.length>0;){var c=r.shift(),f=c.name,l=i.build(c),h=a.indexOf(c);if(l){var p=s(f);if(p&&p.name===f)throw new Error("State '"+f+"' is already defined");var d=s(f+".**");d&&this.$registry.deregister(d),n[f]=c,this.attachRoute(c),h>=0&&a.splice(h,1),o.push(c)}else{var v=u[f];if(u[f]=r.length,h>=0&&v===r.length)return r.push(c),n;h<0&&a.push(c),r.push(c)}}return o.length&&this.listeners.forEach(function(t){return t("registered",o.map(function(t){return t.self}))}),n},t.prototype.attachRoute=function(t){!t.abstract&&t.url&&this.$urlRouter.rule(this.$urlRouter.urlRuleFactory.create(t))},t}(),xr=function(){function t(t){this._router=t,this.states={},this.listeners=[],this.matcher=new kr(this.states),this.builder=new Pr(this.matcher,t.urlMatcherFactory),this.stateQueue=new Or(this,t.urlRouter,this.states,this.builder,this.listeners),this._registerRoot()}return t.prototype._registerRoot=function(){var t={name:"",url:"^",views:null,params:{"#":{value:null,type:"hash",dynamic:!0}},abstract:!0};(this._root=this.stateQueue.register(t)).navigable=null},t.prototype.dispose=function(){var t=this;this.stateQueue.dispose(),this.listeners=[],this.get().forEach(function(e){return t.get(e)&&t.deregister(e)})},t.prototype.onStatesChanged=function(t){return this.listeners.push(t),function(){me(this.listeners)(t)}.bind(this)},t.prototype.root=function(){return this._root},t.prototype.register=function(t){return this.stateQueue.register(t)},t.prototype._deregisterTree=function(t){var e=this,r=this.get().map(function(t){return t.$$state()}),n=function(t){var e=r.filter(function(e){return-1!==t.indexOf(e.parent)});return 0===e.length?e:e.concat(n(e))},i=n([t]),o=[t].concat(i).reverse();return o.forEach(function(t){var r=e._router.urlRouter;r.rules().filter(At("state",t)).forEach(r.removeRule.bind(r)),delete e.states[t.name]}),o},t.prototype.deregister=function(t){var e=this.get(t);if(!e)throw new Error("Can't deregister state; not found: "+t);var r=this._deregisterTree(e.$$state());return this.listeners.forEach(function(t){return t("deregistered",r.map(function(t){return t.self}))}),r},t.prototype.get=function(t,e){var r=this;if(0===arguments.length)return Object.keys(this.states).map(function(t){return r.states[t].self});var n=this.matcher.find(t,e);return n&&n.self||null},t.prototype.decorator=function(t,e){return this.builder.builder(t,e)},t}(),Ir=function(t,e,r){return t[e]=t[e]||r()},jr=Q("/"),Vr=function(){function e(t,r,n,i){var o=this;this.config=i,this._cache={path:[this]},this._children=[],this._params=[],this._segments=[],this._compiled=[],this.pattern=t,this.config=m(this.config,{params:{},strict:!0,caseInsensitive:!1,paramMap:f});for(var a,u,s,c=/([:*])([\w\[\]]+)|\{([\w\[\]]+)(?:\:\s*((?:[^{}\\]+|\\.|\{(?:[^{}\\]+|\\.)*\})+))?\}/g,l=/([:]?)([\w\[\].-]+)|\{([\w\[\].-]+)(?:\:\s*((?:[^{}\\]+|\\.|\{(?:[^{}\\]+|\\.)*\})+))?\}/g,h=0,p=[],d=function(r){if(!e.nameValidator.test(r))throw new Error("Invalid parameter name '"+r+"' in pattern '"+t+"'");if(S(o._params,At("id",r)))throw new Error("Duplicate parameter name '"+r+"' in pattern '"+t+"'")},v=function(e,n){var i=e[2]||e[3],a=n?e[4]:e[4]||("*"===e[1]?"[\\s\\S]*":null);return{id:i,regexp:a,cfg:o.config.params[i],segment:t.substring(h,e.index),type:a?r.type(a)||function(t){return de(r.type(n?"query":"path"),{pattern:new RegExp(t,o.config.caseInsensitive?"i":void 0)})}(a):null}};(a=c.exec(t))&&!((u=v(a,!1)).segment.indexOf("?")>=0);)d(u.id),this._params.push(n.fromPath(u.id,u.type,this.config.paramMap(u.cfg,!1))),this._segments.push(u.segment),p.push([u.segment,P(this._params)]),h=c.lastIndex;var y=(s=t.substring(h)).indexOf("?");if(y>=0){var g=s.substring(y);if(s=s.substring(0,y),g.length>0)for(h=0;a=l.exec(g);)d((u=v(a,!0)).id),this._params.push(n.fromSearch(u.id,u.type,this.config.paramMap(u.cfg,!0))),h=c.lastIndex}this._segments.push(s),this._compiled=p.map(function(t){return nt.apply(null,t)}).concat(nt(s))}return e.prototype.append=function(t){return this._children.push(t),t._cache={path:this._cache.path.concat(t),parent:this,pattern:null},t},e.prototype.isRoot=function(){return this._cache.path[0]===this},e.prototype.toString=function(){return this.pattern},e.prototype.exec=function(t,e,r,n){var i=this;void 0===e&&(e={}),void 0===n&&(n={});var o=Ir(this._cache,"pattern",function(){return new RegExp(["^",Te(i._cache.path.map(Vt("_compiled"))).join(""),!1===i.config.strict?"/?":"","$"].join(""),i.config.caseInsensitive?"i":void 0)}).exec(t);if(!o)return null;var a=this.parameters(),u=a.filter(function(t){return!t.isSearch()}),s=a.filter(function(t){return t.isSearch()}),c=this._cache.path.map(function(t){return t._segments.length-1}).reduce(function(t,e){return t+e}),f={};if(c!==o.length-1)throw new Error("Unbalanced capture group in route '"+this.pattern+"'");for(var l=0;l<c;l++){for(var h=u[l],p=o[l+1],d=0;d<h.replace.length;d++)h.replace[d].from===p&&(p=h.replace[d].to);p&&!0===h.array&&(p=function(t){var e=function(t){return t.split("").reverse().join("")};return b(b(e(t).split(/-(?!\\)/),e),function(t){return t.replace(/\\-/g,"-")}).reverse()}(p)),Jt(p)&&(p=h.type.decode(p)),f[h.id]=h.value(p)}return s.forEach(function(t){for(var r=e[t.id],n=0;n<t.replace.length;n++)t.replace[n].from===r&&(r=t.replace[n].to);Jt(r)&&(r=t.type.decode(r)),f[t.id]=t.value(r)}),r&&(f["#"]=r),f},e.prototype.parameters=function(t){return void 0===t&&(t={}),!1===t.inherit?this._params:Te(this._cache.path.map(function(t){return t._params}))},e.prototype.parameter=function(t,e){var r=this;void 0===e&&(e={});var n=this._cache.parent;return function(){for(var e=0,n=r._params;e<n.length;e++){var i=n[e];if(i.id===t)return i}}()||!1!==e.inherit&&n&&n.parameter(t,e)||null},e.prototype.validates=function(t){var e=function(t,e){return!t||t.validates(e)};return t=t||{},this.parameters().filter(function(e){return t.hasOwnProperty(e.id)}).map(function(r){return e(r,t[r.id])}).reduce(Se,!0)},e.prototype.format=function(t){function r(e){var r=e.value(t[e.id]),n=e.validates(r),i=e.isDefaultValue(r);return{param:e,value:r,isValid:n,isDefaultValue:i,squash:!!i&&e.squash,encoded:e.type.encode(r)}}void 0===t&&(t={});var n=this._cache.path,i=n.map(e.pathSegmentsAndParams).reduce(Re,[]).map(function(t){return Xt(t)?t:r(t)}),o=n.map(e.queryParams).reduce(Re,[]).map(r);if(i.concat(o).filter(function(t){return!1===t.isValid}).length)return null;var a=i.reduce(function(t,r){if(Xt(r))return t+r;var n=r.squash,i=r.encoded,o=r.param;return!0===n?t.match(/\/$/)?t.slice(0,-1):t:Xt(n)?t+n:!1!==n?t:null==i?t:ee(i)?t+b(i,e.encodeDashes).join("-"):o.raw?t+i:t+encodeURIComponent(i)},""),u=o.map(function(t){var e=t.param,r=t.squash,n=t.encoded,i=t.isDefaultValue;if(!(null==n||i&&!1!==r)&&(ee(n)||(n=[n]),0!==n.length))return e.raw||(n=b(n,encodeURIComponent)),n.map(function(t){return e.id+"="+t})}).filter(f).reduce(Re,[]).join("&");return a+(u?"?"+u:"")+(t["#"]?"#"+t["#"]:"")},e.encodeDashes=function(t){return encodeURIComponent(t).replace(/-/g,function(t){return"%5C%"+t.charCodeAt(0).toString(16).toUpperCase()})},e.pathSegmentsAndParams=function(e){return C(e._segments,e._params.filter(function(e){return e.location===t.DefType.PATH}).concat(void 0)).reduce(Re,[]).filter(function(t){return""!==t&&Jt(t)})},e.queryParams=function(e){return e._params.filter(function(e){return e.location===t.DefType.SEARCH})},e.compare=function(t,r){var n=function(t){return t._cache.segments=t._cache.segments||t._cache.path.map(e.pathSegmentsAndParams).reduce(Re,[]).reduce(K,[]).map(function(t){return Xt(t)?jr(t):t}).reduce(Re,[])},i=function(t){return t._cache.weights=t._cache.weights||n(t).map(function(t){return"/"===t?1:Xt(t)?2:t instanceof Ze?3:void 0})},o=i(t),a=i(r);!function(t,e,r){for(var n=Math.max(t.length,e.length);t.length<n;)t.push(r);for(;e.length<n;)e.push(r)}(o,a,0);var u,s,c=C(o,a);for(s=0;s<c.length;s++)if(0!=(u=c[s][0]-c[s][1]))return u;return 0},e.nameValidator=/^\w+([-.]+\w+)*(?:\[\])?$/,e}(),Ar=function(){function e(){var e=this;this.paramTypes=new $r,this._isCaseInsensitive=!1,this._isStrictMode=!0,this._defaultSquashPolicy=!1,this._getConfig=function(t){return he({strict:e._isStrictMode,caseInsensitive:e._isCaseInsensitive},t)},this.paramFactory={fromConfig:function(r,n,i){return new Ze(r,n,i,t.DefType.CONFIG,e)},fromPath:function(r,n,i){return new Ze(r,n,i,t.DefType.PATH,e)},fromSearch:function(r,n,i){return new Ze(r,n,i,t.DefType.SEARCH,e)}},he(this,{UrlMatcher:Vr,Param:Ze})}return e.prototype.caseInsensitive=function(t){return this._isCaseInsensitive=Jt(t)?t:this._isCaseInsensitive},e.prototype.strictMode=function(t){return this._isStrictMode=Jt(t)?t:this._isStrictMode},e.prototype.defaultSquashPolicy=function(t){if(Jt(t)&&!0!==t&&!1!==t&&!Xt(t))throw new Error("Invalid squash policy: "+t+". Valid policies: false, true, arbitrary-string");return this._defaultSquashPolicy=Jt(t)?t:this._defaultSquashPolicy},e.prototype.compile=function(t,e){return new Vr(t,this.paramTypes,this.paramFactory,this._getConfig(e))},e.prototype.isMatcher=function(t){if(!te(t))return!1;var e=!0;return le(Vr.prototype,function(r,n){Yt(r)&&(e=e&&Jt(t[n])&&Yt(t[n]))}),e},e.prototype.type=function(t,e,r){var n=this.paramTypes.type(t,e,r);return Jt(e)?this:n},e.prototype.$get=function(){return this.paramTypes.enqueue=!1,this.paramTypes._flushTypeQueue(),this},e.prototype.dispose=function(){this.paramTypes.dispose()},e}(),Hr=function(){function t(t){this.router=t}return t.prototype.compile=function(t){return this.router.urlMatcherFactory.compile(t)},t.prototype.create=function(t,e){var r=this,n=s([[Xt,function(t){return n(r.compile(t))}],[Nt(Vr),function(t){return r.fromUrlMatcher(t,e)}],[ie,function(t){return r.fromState(t,r.router)}],[Nt(RegExp),function(t){return r.fromRegExp(t,e)}],[Yt,function(t){return new qr(t,e)}]]),i=n(t);if(!i)throw new Error("invalid 'what' in when()");return i},t.prototype.fromUrlMatcher=function(t,e){var r=e;Xt(e)&&(e=this.router.urlMatcherFactory.compile(e)),Nt(Vr)(e)&&(r=function(t){return e.format(t)});var n={urlMatcher:t,matchPriority:function(e){var r=t.parameters().filter(function(t){return t.isOptional});return r.length?r.filter(function(t){return e[t.id]}).length/r.length:1e-6},type:"URLMATCHER"};return he(new qr(function(e){var r=t.exec(e.path,e.search,e.hash);return t.validates(r)&&r},r),n)},t.prototype.fromState=function(t,e){var r={state:t,type:"STATE"};return he(this.fromUrlMatcher(t.url,function(r){var n=e.stateService,i=e.globals;n.href(t,r)!==n.href(i.current,i.params)&&n.transitionTo(t,r,{inherit:!0,source:"url"})}),r)},t.prototype.fromRegExp=function(t,e){if(t.global||t.sticky)throw new Error("Rule RegExp must not be global or sticky");var r=Xt(e)?function(t){return e.replace(/\$(\$|\d{1,2})/,function(e,r){return t["$"===r?0:Number(r)]})}:e,n={regexp:t,type:"REGEXP"};return he(new qr(function(e){return t.exec(e.path)},r),n)},t.isUrlRule=function(t){return t&&["type","match","handler"].every(function(e){return Jt(t[e])})},t}(),qr=function(){return function(t,e){var r=this;this.match=t,this.type="RAW",this.matchPriority=function(t){return 0-r.$id},this.handler=e||f}}(),Dr=function(t,e){return(e.priority||0)-(t.priority||0)},Fr=function(t,e){var r={STATE:4,URLMATCHER:4,REGEXP:3,RAW:2,OTHER:1};return(r[t.type]||0)-(r[e.type]||0)},Nr=function(t,e){return t.urlMatcher&&e.urlMatcher?Vr.compare(t.urlMatcher,e.urlMatcher):0},Ur=function(t,e){var r={STATE:!0,URLMATCHER:!0};return r[t.type]&&r[e.type]?0:(t.$id||0)-(e.$id||0)};Sr=function(t,e){var r=Dr(t,e);return 0!==r?r:0!==(r=Fr(t,e))?r:0!==(r=Nr(t,e))?r:Ur(t,e)};var Lr=function(){function t(e){this._sortFn=Sr,this._rules=[],this.interceptDeferred=!1,this._id=0,this._sorted=!1,this._router=e,this.urlRuleFactory=new Hr(e),h(Lt(t.prototype),this,Lt(this))}return t.prototype.dispose=function(){this.listen(!1),this._rules=[],delete this._otherwiseFn},t.prototype.sort=function(t){this._rules=this.stableSort(this._rules,this._sortFn=t||this._sortFn),this._sorted=!0},t.prototype.ensureSorted=function(){this._sorted||this.sort()},t.prototype.stableSort=function(t,e){var r=t.map(function(t,e){return{elem:t,idx:e}});return r.sort(function(t,r){var n=e(t.elem,r.elem);return 0===n?t.idx-r.idx:n}),r.map(function(t){return t.elem})},t.prototype.match=function(t){var e=this;this.ensureSorted(),t=he({path:"",search:{},hash:""},t);var r=this.rules();this._otherwiseFn&&r.push(this._otherwiseFn);for(var n,i=0;i<r.length&&(!n||0===this._sortFn(r[i],n.rule));i++){var o=function(r){var n=r.match(t,e._router);return n&&{match:n,rule:r,weight:r.matchPriority(n)}}(r[i]);n=!n||o&&o.weight>n.weight?o:n}return n},t.prototype.sync=function(t){if(!t||!t.defaultPrevented){var e=this._router,r=e.urlService,n=e.stateService,i={path:r.path(),search:r.search(),hash:r.hash()},o=this.match(i);s([[Xt,function(t){return r.url(t,!0)}],[Be.isDef,function(t){return n.go(t.state,t.params,t.options)}],[Nt(Be),function(t){return n.go(t.state(),t.params(),t.options())}]])(o&&o.rule.handler(o.match,i,e))}},t.prototype.listen=function(t){var e=this;if(!1!==t)return this._stopFn=this._stopFn||this._router.urlService.onChange(function(t){return e.sync(t)});this._stopFn&&this._stopFn(),delete this._stopFn},t.prototype.update=function(t){var e=this._router.locationService;t?this.location=e.path():e.path()!==this.location&&e.url(this.location,!0)},t.prototype.push=function(t,e,r){var n=r&&!!r.replace;this._router.urlService.url(t.format(e||{}),n)},t.prototype.href=function(t,e,r){var n=t.format(e);if(null==n)return null;r=r||{absolute:!1};var i=this._router.urlService.config,o=i.html5Mode();if(o||null===n||(n="#"+i.hashPrefix()+n),n=it(n,o,r.absolute,i.baseHref()),!r.absolute||!n)return n;var a=!o&&n?"/":"",u=i.port();return u=80===u||443===u?"":":"+u,[i.protocol(),"://",i.host(),u,a,n].join("")},t.prototype.rule=function(t){var e=this;if(!Hr.isUrlRule(t))throw new Error("invalid rule");return t.$id=this._id++,t.priority=t.priority||0,this._rules.push(t),this._sorted=!1,function(){return e.removeRule(t)}},t.prototype.removeRule=function(t){me(this._rules,t)},t.prototype.rules=function(){return this.ensureSorted(),this._rules.slice()},t.prototype.otherwise=function(t){var e=ot(t);this._otherwiseFn=this.urlRuleFactory.create(Lt(!0),e),this._sorted=!1},t.prototype.initial=function(t){var e=ot(t);this.rule(this.urlRuleFactory.create(function(t,e){return 0===e.globals.transitionHistory.size()&&!!/^\/?$/.exec(t.path)},e))},t.prototype.when=function(t,e,r){var n=this.urlRuleFactory.create(t,e);return Jt(r&&r.priority)&&(n.priority=r.priority),this.rule(n),n},t.prototype.deferIntercept=function(t){void 0===t&&(t=!0),this.interceptDeferred=t},t}(),Mr=function(){function t(){var t=this;this._uiViews=[],this._viewConfigs=[],this._viewConfigFactories={},this._pluginapi={_rootViewContext:this._rootViewContext.bind(this),_viewConfigFactory:this._viewConfigFactory.bind(this),_registeredUIViews:function(){return t._uiViews},_activeViewConfigs:function(){return t._viewConfigs}}}return t.prototype._rootViewContext=function(t){return this._rootContext=t||this._rootContext},t.prototype._viewConfigFactory=function(t,e){this._viewConfigFactories[t]=e},t.prototype.createViewConfig=function(t,e){var r=this._viewConfigFactories[e.$type];if(!r)throw new Error("ViewService: No view config factory registered for type "+e.$type);var n=r(t,e);return ee(n)?n:[n]},t.prototype.deactivateViewConfig=function(t){Me.traceViewServiceEvent("<- Removing",t),me(this._viewConfigs,t)},t.prototype.activateViewConfig=function(t){Me.traceViewServiceEvent("-> Registering",t),this._viewConfigs.push(t)},t.prototype.sync=function(){function e(t){for(var e=t.viewDecl.$context,r=0;++r&&e.parent;)e=e.parent;return r}var n=this,i=this._uiViews.map(function(t){return[t.fqn,t]}).reduce(T,{}),o=r(function(t,e,r,n){return e*(t(r)-t(n))}),a=this._uiViews.sort(o(function(t){var e=function(t){return t&&t.parent?e(t.parent)+1:1};return 1e4*t.fqn.split(".").length+e(t.creationContext)},1)).map(function(r){var a=n._viewConfigs.filter(t.matches(i,r));return a.length>1&&a.sort(o(e,-1)),[r,a[0]]});Me.traceViewSync(a),a.forEach(function(t){var e=t[0],r=t[1];-1!==n._uiViews.indexOf(e)&&e.configUpdated(r)})},t.prototype.registerUIView=function(t){Me.traceViewServiceUIViewEvent("-> Registering",t);var e=this._uiViews;return e.filter(function(e){return e.fqn===t.fqn&&e.$type===t.$type}).length&&Me.traceViewServiceUIViewEvent("!!!! duplicate uiView named:",t),e.push(t),this.sync(),function(){-1!==e.indexOf(t)?(Me.traceViewServiceUIViewEvent("<- Deregistering",t),me(e)(t)):Me.traceViewServiceUIViewEvent("Tried removing non-registered uiView",t)}},t.prototype.available=function(){return this._uiViews.map(Vt("fqn"))},t.prototype.active=function(){return this._uiViews.filter(Vt("$config")).map(Vt("name"))},t.normalizeUIViewTarget=function(t,e){void 0===e&&(e="");var r=e.split("@"),n=r[0]||"$default",i=Xt(r[1])?r[1]:"^",o=/^(\^(?:\.\^)*)\.(.*$)/.exec(n);return o&&(i=o[1],n=o[2]),"!"===n.charAt(0)&&(n=n.substr(1),i=""),/^(\^(?:\.\^)*)$/.exec(i)?i=i.split(".").reduce(function(t,e){return t.parent},t).name:"."===i&&(i=t.name),{uiViewName:n,uiViewContextAnchor:i}},t.matches=function(t,e){return function(r){if(e.$type!==r.viewDecl.$type)return!1;var n=r.viewDecl,i=n.$uiViewName.split("."),o=e.fqn.split(".");if(!pe(i,o.slice(0-i.length)))return!1;var a=1-i.length||void 0,u=o.slice(0,a).join("."),s=t[u].creationContext;return n.$uiViewContextAnchor===(s&&s.name)}},t}(),Br=function(){function t(){this.params=new br,this.lastStartedTransitionId=-1,this.transitionHistory=new Ve([],1),this.successfulTransitions=new Ve([],1)}return t.prototype.dispose=function(){this.transitionHistory.clear(),this.successfulTransitions.clear(),this.transition=null},t}(),Gr=function(t){return t.reduce(function(t,e){return t[e]=ae(e),t},{dispose:l})},Wr=["url","path","search","hash","onChange"],zr=["port","protocol","host","baseHref","html5Mode","hashPrefix"],Jr=["type","caseInsensitive","strictMode","defaultSquashPolicy"],Qr=["sort","when","initial","otherwise","rules","rule","removeRule"],Kr=["deferIntercept","listen","sync","match"],Yr=function(){function t(t,e){void 0===e&&(e=!0),this.router=t,this.rules={},this.config={};var r=function(){return t.locationService};h(r,this,r,Wr,e);var n=function(){return t.locationConfig};h(n,this.config,n,zr,e);var i=function(){return t.urlMatcherFactory};h(i,this.config,i,Jr);var o=function(){return t.urlRouter};h(o,this.rules,o,Qr),h(o,this,o,Kr)}return t.prototype.url=function(t,e,r){},t.prototype.path=function(){},t.prototype.search=function(){},t.prototype.hash=function(){},t.prototype.onChange=function(t){},t.prototype.parts=function(){return{path:this.path(),search:this.search(),hash:this.hash()}},t.prototype.dispose=function(){},t.prototype.sync=function(t){},t.prototype.listen=function(t){},t.prototype.deferIntercept=function(t){},t.prototype.match=function(t){},t.locationServiceStub=Gr(Wr),t.locationConfigStub=Gr(zr),t}(),Zr=0,Xr=function(){function t(t,e){void 0===t&&(t=Yr.locationServiceStub),void 0===e&&(e=Yr.locationConfigStub),this.locationService=t,this.locationConfig=e,this.$id=Zr++,this._disposed=!1,this._disposables=[],this.trace=Me,this.viewService=new Mr,this.transitionService=new Pn(this),this.globals=new Br,this.urlMatcherFactory=new Ar,this.urlRouter=new Lr(this),this.stateRegistry=new xr(this),this.stateService=new kn(this),this.urlService=new Yr(this),this._plugins={},this.viewService._pluginapi._rootViewContext(this.stateRegistry.root()),this.globals.$current=this.stateRegistry.root(),this.globals.current=this.globals.$current.self,this.disposable(this.globals),this.disposable(this.stateService),this.disposable(this.stateRegistry),this.disposable(this.transitionService),this.disposable(this.urlRouter),this.disposable(t),this.disposable(e)}return t.prototype.disposable=function(t){this._disposables.push(t)},t.prototype.dispose=function(t){var e=this;t&&Yt(t.dispose)?t.dispose(this):(this._disposed=!0,this._disposables.slice().forEach(function(t){try{"function"==typeof t.dispose&&t.dispose(e),me(e._disposables,t)}catch(t){}}))},t.prototype.plugin=function(t,e){void 0===e&&(e={});var r=new t(this,e);if(!r.name)throw new Error("Required property `name` missing on plugin: "+r);return this._disposables.push(r),this._plugins[r.name]=r},t.prototype.getPlugin=function(t){return t?this._plugins[t]:$e(this._plugins)},t}(),tn=function(t){return t.onCreate({},at)},en=function(t){function e(e){if(e)return e instanceof Be?e:Xt(e)?n.target(e,t.params(),t.options()):e.state||e.params?n.target(e.state||t.to(),e.params||t.params(),t.options()):void 0}var r=t.to().redirectTo;if(r){var n=t.router.stateService;return Yt(r)?ue.$q.when(r(t)).then(e):e(r)}},rn=function(t){return t.onStart({to:function(t){return!!t.redirectTo}},en)},nn=ut("onExit"),on=function(t){return t.onExit({exiting:function(t){return!!t.onExit}},nn)},an=ut("onRetain"),un=function(t){return t.onRetain({retained:function(t){return!!t.onRetain}},an)},sn=ut("onEnter"),cn=function(t){return t.onEnter({entering:function(t){return!!t.onEnter}},sn)},fn=function(t){return new sr(t.treeChanges().to).resolvePath("EAGER",t).then(l)},ln=function(t){return t.onStart({},fn,{priority:1e3})},hn=function(t,e){return new sr(t.treeChanges().to).subContext(e.$$state()).resolvePath("LAZY",t).then(l)},pn=function(t){return t.onEnter({entering:Lt(!0)},hn,{priority:1e3})},dn=function(t){var e=ue.$q,r=t.views("entering");if(r.length)return e.all(r.map(function(t){return e.when(t.load())})).then(l)},vn=function(t){return t.onFinish({},dn)},mn=function(t){var e=t.views("entering"),r=t.views("exiting");if(e.length||r.length){var n=t.router.viewService;r.forEach(function(t){return n.deactivateViewConfig(t)}),e.forEach(function(t){return n.activateViewConfig(t)}),n.sync()}},yn=function(t){return t.onSuccess({},mn)},gn=function(t){var e=t.router.globals,r=function(){e.transition===t&&(e.transition=null)};t.onSuccess({},function(){e.successfulTransitions.enqueue(t),e.$current=t.$to(),e.current=e.$current.self,k(t.params(),e.params)},{priority:1e4}),t.promise.then(r,r)},wn=function(t){return t.onCreate({},gn)},_n=function(t){var e=t.options(),r=t.router.stateService,n=t.router.urlRouter;if("url"!==e.source&&e.location&&r.$current.navigable){var i={replace:"replace"===e.location};n.push(r.$current.navigable.url,r.params,i)}n.update(!0)},$n=function(t){return t.onSuccess({},_n,{priority:9999})},Sn=function(t){var e=t.router,r=t.entering().filter(function(t){return!!t.$$state().lazyLoad}).map(function(e){return st(t,e)});return ue.$q.all(r).then(function(){if("url"!==t.originalTransition().options().source){var r=t.targetState();return e.stateService.target(r.identifier(),r.params(),r.options())}var n=e.urlService,i=n.match(n.parts()),o=i&&i.rule;if(o&&"STATE"===o.type){var a=o.state,u=i.match;return e.stateService.target(a,u,t.options())}e.urlService.sync()})},bn=function(t){return t.onBefore({entering:function(t){return!!t.lazyLoad}},Sn)},Rn=function(){return function(t,e,r,n,i,o,a,u){void 0===i&&(i=!1),void 0===o&&(o=We.HANDLE_RESULT),void 0===a&&(a=We.REJECT_ERROR),void 0===u&&(u=!1),this.name=t,this.hookPhase=e,this.hookOrder=r,this.criteriaMatchPath=n,this.reverseSort=i,this.getResultHandler=o,this.getErrorHandler=a,this.synchronous=u}}(),En=function(t){return t.onBefore({},ct,{priority:-9999})},Cn=function(t){return t.onBefore({},ft,{priority:-1e4})},Tn={location:!0,relative:null,inherit:!1,notify:!0,reload:!1,custom:{},current:function(){return null},source:"unknown"},Pn=function(){function e(t){this._transitionCount=0,this._eventTypes=[],this._registeredHooks={},this._criteriaPaths={},this._router=t,this.$view=t.viewService,this._deregisterHookFns={},this._pluginapi=h(Lt(this),{},Lt(this),["_definePathType","_defineEvent","_getPathTypes","_getEvents","getHooks"]),this._defineCorePaths(),this._defineCoreEvents(),this._registerCoreTransitionHooks()}return e.prototype.onCreate=function(t,e,r){},e.prototype.onBefore=function(t,e,r){},e.prototype.onStart=function(t,e,r){},e.prototype.onExit=function(t,e,r){},e.prototype.onRetain=function(t,e,r){},e.prototype.onEnter=function(t,e,r){},e.prototype.onFinish=function(t,e,r){},e.prototype.onSuccess=function(t,e,r){},e.prototype.onError=function(t,e,r){},e.prototype.dispose=function(t){$e(this._registeredHooks).forEach(function(t){return t.forEach(function(e){e._deregistered=!0,me(t,e)})})},e.prototype.create=function(t,e){return new lr(t,e,this._router)},e.prototype._defineCoreEvents=function(){var e=t.TransitionHookPhase,r=We,n=this._criteriaPaths;this._defineEvent("onCreate",e.CREATE,0,n.to,!1,r.LOG_REJECTED_RESULT,r.THROW_ERROR,!0),this._defineEvent("onBefore",e.BEFORE,0,n.to),this._defineEvent("onStart",e.RUN,0,n.to),this._defineEvent("onExit",e.RUN,100,n.exiting,!0),this._defineEvent("onRetain",e.RUN,200,n.retained),this._defineEvent("onEnter",e.RUN,300,n.entering),this._defineEvent("onFinish",e.RUN,400,n.to),this._defineEvent("onSuccess",e.SUCCESS,0,n.to,!1,r.LOG_REJECTED_RESULT,r.LOG_ERROR,!0),this._defineEvent("onError",e.ERROR,0,n.to,!1,r.LOG_REJECTED_RESULT,r.LOG_ERROR,!0)},e.prototype._defineCorePaths=function(){var e=t.TransitionHookScope.STATE,r=t.TransitionHookScope.TRANSITION;this._definePathType("to",r),this._definePathType("from",r),this._definePathType("exiting",e),this._definePathType("retained",e),this._definePathType("entering",e)},e.prototype._defineEvent=function(t,e,r,n,i,o,a,u){void 0===i&&(i=!1),void 0===o&&(o=We.HANDLE_RESULT),void 0===a&&(a=We.REJECT_ERROR),void 0===u&&(u=!1);var s=new Rn(t,e,r,n,i,o,a,u);this._eventTypes.push(s),H(this,this,s)},e.prototype._getEvents=function(t){return(Jt(t)?this._eventTypes.filter(function(e){return e.hookPhase===t}):this._eventTypes.slice()).sort(function(t,e){var r=t.hookPhase-e.hookPhase;return 0===r?t.hookOrder-e.hookOrder:r})},e.prototype._definePathType=function(t,e){this._criteriaPaths[t]={name:t,scope:e}},e.prototype._getPathTypes=function(){return this._criteriaPaths},e.prototype.getHooks=function(t){return this._registeredHooks[t]},e.prototype._registerCoreTransitionHooks=function(){var t=this._deregisterHookFns;t.addCoreResolves=tn(this),t.ignored=En(this),t.invalid=Cn(this),t.redirectTo=rn(this),t.onExit=on(this),t.onRetain=un(this),t.onEnter=cn(this),t.eagerResolve=ln(this),t.lazyResolve=pn(this),t.loadViews=vn(this),t.activateViews=yn(this),t.updateGlobals=wn(this),t.updateUrl=$n(this),t.lazyLoad=bn(this)},e}(),kn=function(){function e(t){this.router=t,this.invalidCallbacks=[],this._defaultErrorHandler=function(t){t instanceof Error&&t.stack?(console.error(t),console.error(t.stack)):t instanceof He?(console.error(t.toString()),t.detail&&t.detail.stack&&console.error(t.detail.stack)):console.error(t)};var r=["current","$current","params","transition"],n=Object.keys(e.prototype).filter(qt(ve(r)));h(Lt(e.prototype),this,Lt(this),n)}return Object.defineProperty(e.prototype,"transition",{get:function(){return this.router.globals.transition},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"params",{get:function(){return this.router.globals.params},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"current",{get:function(){return this.router.globals.current},enumerable:!0,configurable:!0}),Object.defineProperty(e.prototype,"$current",{get:function(){return this.router.globals.$current},enumerable:!0,configurable:!0}),e.prototype.dispose=function(){this.defaultErrorHandler(l),this.invalidCallbacks=[]},e.prototype._handleInvalidTargetState=function(t,e){function r(){var t=s.dequeue();return void 0===t?He.invalid(e.error()).toPromise():ue.$q.when(t(e,i,c)).then(f).then(function(t){return t||r()})}var n=this,i=tr.makeTargetState(this.router.stateRegistry,t),o=this.router.globals,a=function(){return o.transitionHistory.peekTail()},u=a(),s=new Ve(this.invalidCallbacks.slice()),c=new sr(t).injector(),f=function(t){if(t instanceof Be){var e=t;return(e=n.target(e.identifier(),e.params(),e.options())).valid()?a()!==u?He.superseded().toPromise():n.transitionTo(e.identifier(),e.params(),e.options()):He.invalid(e.error()).toPromise()}};return r()},e.prototype.onInvalid=function(t){return this.invalidCallbacks.push(t),function(){me(this.invalidCallbacks)(t)}.bind(this)},e.prototype.reload=function(t){return this.transitionTo(this.current,this.params,{reload:!Jt(t)||t,inherit:!1,notify:!1})},e.prototype.go=function(t,e,r){var n=m(r,{relative:this.$current,inherit:!0},Tn);return this.transitionTo(t,e,n)},e.prototype.target=function(t,e,r){if(void 0===r&&(r={}),te(r.reload)&&!r.reload.name)throw new Error("Invalid reload state object");var n=this.router.stateRegistry;if(r.reloadState=!0===r.reload?n.root():n.matcher.find(r.reload,r.relative),r.reload&&!r.reloadState)throw new Error("No such reload state '"+(Xt(r.reload)?r.reload:r.reload.name)+"'");return new Be(this.router.stateRegistry,t,e,r)},e.prototype.getCurrentPath=function(){var t=this,e=this.router.globals.successfulTransitions.peekTail();return e?e.treeChanges().to:[new Xe(t.router.stateRegistry.root())]},e.prototype.transitionTo=function(e,r,n){var i=this;void 0===r&&(r={}),void 0===n&&(n={});var o=this.router,a=o.globals;n=m(n,Tn);n=he(n,{current:function(){return a.transition}});var u=this.target(e,r,n),s=this.getCurrentPath();if(!u.exists())return this._handleInvalidTargetState(s,u);if(!u.valid())return je(u.error());var c=function(e){return function(r){if(r instanceof He){var n=o.globals.lastStartedTransitionId===e.$id;if(r.type===t.RejectType.IGNORED)return n&&o.urlRouter.update(),ue.$q.when(a.current);var u=r.detail;if(r.type===t.RejectType.SUPERSEDED&&r.redirected&&u instanceof Be){var s=e.redirect(u);return s.run().catch(c(s))}if(r.type===t.RejectType.ABORTED)return n&&o.urlRouter.update(),ue.$q.reject(r)}return i.defaultErrorHandler()(r),ue.$q.reject(r)}},f=this.router.transitionService.create(s,u),l=f.run().catch(c(f));return Ie(l),he(l,{transition:f})},e.prototype.is=function(t,e,r){r=m(r,{relative:this.$current});var n=this.router.stateRegistry.matcher.find(t,r.relative);if(Jt(n)){if(this.$current!==n)return!1;if(!e)return!0;var i=n.parameters({inherit:!0,matchingKeys:e});return Ze.equals(i,Ze.values(i,e),this.params)}},e.prototype.includes=function(t,e,r){r=m(r,{relative:this.$current});var n=Xt(t)&&Mt.fromString(t);if(n){if(!n.matches(this.$current.name))return!1;t=this.$current.name}var i=this.router.stateRegistry.matcher.find(t,r.relative),o=this.$current.includes;if(Jt(i)){if(!Jt(o[i.name]))return!1;if(!e)return!0;var a=i.parameters({inherit:!0,matchingKeys:e});return Ze.equals(a,Ze.values(a,e),this.params)}},e.prototype.href=function(t,e,r){r=m(r,{lossy:!0,inherit:!0,absolute:!1,relative:this.$current}),e=e||{};var n=this.router.stateRegistry.matcher.find(t,r.relative);if(!Jt(n))return null;r.inherit&&(e=this.params.$inherit(e,this.$current,n));var i=n&&r.lossy?n.navigable:n;return i&&void 0!==i.url&&null!==i.url?this.router.urlRouter.href(i.url,e,{absolute:r.absolute}):null},e.prototype.defaultErrorHandler=function(t){return this._defaultErrorHandler=t||this._defaultErrorHandler},e.prototype.get=function(t,e){var r=this.router.stateRegistry;return 0===arguments.length?r.get():r.get(t,e||this.$current)},e.prototype.lazyLoad=function(t,e){var r=this.get(t);if(!r||!r.lazyLoad)throw new Error("Can not lazy load "+t);var n=this.getCurrentPath(),i=tr.makeTargetState(this.router.stateRegistry,n);return e=e||this.router.transitionService.create(n,i),st(e,r)},e}(),On={when:function(t){return new Promise(function(e,r){return e(t)})},reject:function(t){return new Promise(function(e,r){r(t)})},defer:function(){var t={};return t.promise=new Promise(function(e,r){t.resolve=e,t.reject=r}),t},all:function(t){if(ee(t))return Promise.all(t);if(te(t)){var e=Object.keys(t).map(function(e){return t[e].then(function(t){return{key:e,val:t}})});return On.all(e).then(function(t){return t.reduce(function(t,e){return t[e.key]=e.val,t},{})})}}},xn={},In=/((\/\/.*$)|(\/\*[\s\S]*?\*\/))/gm,jn=/([^\s,]+)/g,Vn={get:function(t){return xn[t]},has:function(t){return null!=Vn.get(t)},invoke:function(t,e,r){var n=he({},xn,r||{}),i=Vn.annotate(t),o=ke(function(t){return n.hasOwnProperty(t)},function(t){return"DI can't find injectable: '"+t+"'"}),a=i.filter(o).map(function(t){return n[t]});return Yt(t)?t.apply(e,a):t.slice(-1)[0].apply(e,a)},annotate:function(t){if(!c(t))throw new Error("Not an injectable function: "+t);if(t&&t.$inject)return t.$inject;if(ee(t))return t.slice(0,-1);var e=t.toString().replace(In,"");return e.slice(e.indexOf("(")+1,e.indexOf(")")).match(jn)||[]}},An=function(t,e){var r=e[0],n=e[1];return t.hasOwnProperty(r)?ee(t[r])?t[r].push(n):t[r]=[t[r],n]:t[r]=n,t},Hn=function(t){return t.split("&").filter(f).map(wr).reduce(An,{})},qn=function(t){var e=t.path(),r=t.search(),n=t.hash(),i=Object.keys(r).map(function(t){var e=r[t];return(ee(e)?e:[e]).map(function(e){return t+"="+e})}).reduce(Re,[]).join("&");return e+(i?"?"+i:"")+(n?"#"+n:"")},Dn=pt(),Fn=function(){function t(t,e){var r=this;this.fireAfterUpdate=e,this._listener=function(t){return r._listeners.forEach(function(e){return e(t)})},this._listeners=[],this.hash=function(){return lt(r._get()).hash},this.path=function(){return lt(r._get()).path},this.search=function(){return Hn(lt(r._get()).search)},this._location=self&&self.location,this._history=self&&self.history}return t.prototype.url=function(t,e){if(void 0===e&&(e=!0),Jt(t)&&t!==this._get()&&(this._set(null,null,t,e),this.fireAfterUpdate)){var r=he(new Dn("locationchange"),{url:t});this._listeners.forEach(function(t){return t(r)})}return qn(this)},t.prototype.onChange=function(t){var e=this;return this._listeners.push(t),function(){return me(e._listeners,t)}},t.prototype.dispose=function(t){ge(this._listeners)},t}(),Nn=function(){var t=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var r in e)e.hasOwnProperty(r)&&(t[r]=e[r])};return function(e,r){function n(){this.constructor=e}t(e,r),e.prototype=null===r?Object.create(r):(n.prototype=r.prototype,new n)}}(),Un=function(t){function e(e){var r=t.call(this,e,!1)||this;return self.addEventListener("hashchange",r._listener,!1),r}return Nn(e,t),e.prototype._get=function(){return _r(this._location.hash)},e.prototype._set=function(t,e,r,n){this._location.hash=r},e.prototype.dispose=function(e){t.prototype.dispose.call(this,e),self.removeEventListener("hashchange",this._listener)},e}(Fn),Ln=function(){var t=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var r in e)e.hasOwnProperty(r)&&(t[r]=e[r])};return function(e,r){function n(){this.constructor=e}t(e,r),e.prototype=null===r?Object.create(r):(n.prototype=r.prototype,new n)}}(),Mn=function(t){function e(e){return t.call(this,e,!0)||this}return Ln(e,t),e.prototype._get=function(){return this._url},e.prototype._set=function(t,e,r,n){this._url=r},e}(Fn),Bn=function(){var t=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(t,e){t.__proto__=e}||function(t,e){for(var r in e)e.hasOwnProperty(r)&&(t[r]=e[r])};return function(e,r){function n(){this.constructor=e}t(e,r),e.prototype=null===r?Object.create(r):(n.prototype=r.prototype,new n)}}(),Gn=function(t){function e(e){var r=t.call(this,e,!0)||this;return r._config=e.urlService.config,self.addEventListener("popstate",r._listener,!1),r}return Bn(e,t),e.prototype._getBasePrefix=function(){return mr(this._config.baseHref())},e.prototype._get=function(){var t=this._location,e=t.pathname,r=t.hash,n=t.search;n=gr(n)[1],r=yr(r)[1];var i=this._getBasePrefix(),o=e===this._config.baseHref(),a=e.startsWith(i);return(e=o?"/":a?e.substring(i.length):e)+(n?"?"+n:"")+(r?"#"+r:"")},e.prototype._set=function(t,e,r,n){var i=this._getBasePrefix()+r;n?this._history.replaceState(t,e,i):this._history.pushState(t,e,i)},e.prototype.dispose=function(e){t.prototype.dispose.call(this,e),self.removeEventListener("popstate",this._listener)},e}(Fn),Wn=function(){return function(){var t=this;this._baseHref="",this._port=80,this._protocol="http",this._host="localhost",this._hashPrefix="",this.port=function(){return t._port},this.protocol=function(){return t._protocol},this.host=function(){return t._host},this.baseHref=function(){return t._baseHref},this.html5Mode=function(){return!1},this.hashPrefix=function(e){return Jt(e)?t._hashPrefix=e:t._hashPrefix},this.dispose=l}}(),zn=function(){function t(t,e){void 0===e&&(e=!1),this._isHtml5=e,this._baseHref=void 0,this._hashPrefix=""}return t.prototype.port=function(){return location.port?Number(location.port):"https"===this.protocol()?443:80},t.prototype.protocol=function(){return location.protocol.replace(/:/g,"")},t.prototype.host=function(){return location.hostname},t.prototype.html5Mode=function(){return this._isHtml5},t.prototype.hashPrefix=function(t){return Jt(t)?this._hashPrefix=t:this._hashPrefix},t.prototype.baseHref=function(t){return Jt(t)?this._baseHref=t:Jt(this._baseHref)?this._baseHref:this.applyDocumentBaseHref()},t.prototype.applyDocumentBaseHref=function(){var t=document.getElementsByTagName("base")[0];return this._baseHref=t?t.href.substr(location.origin.length):""},t.prototype.dispose=function(){},t}(),Jn=ht("vanilla.hashBangLocation",!1,Un,zn),Qn=ht("vanilla.pushStateLocation",!0,Gn,zn),Kn=ht("vanilla.memoryLocation",!1,Mn,Wn),Yn=function(){function t(){}return t.prototype.dispose=function(t){},t}(),Zn=Object.freeze({fromJson:ce,toJson:fe,forEach:le,extend:he,equals:pe,identity:f,noop:l,createProxyFunctions:h,inherit:de,inArray:ve,_inArray:p,removeFrom:me,_removeFrom:d,pushTo:ye,_pushTo:v,deregAll:ge,defaults:m,mergeR:we,ancestors:y,pick:g,omit:w,pluck:_,filter:$,find:S,mapObj:_e,map:b,values:$e,allTrueR:Se,anyTrueR:be,unnestR:Re,flattenR:Ee,pushR:R,uniqR:Ce,unnest:Te,flatten:Pe,assertPredicate:ke,assertMap:Oe,assertFn:E,pairs:xe,arrayTuples:C,applyPairs:T,tail:P,copy:k,_extend:O,silenceUncaughtInPromise:Ie,silentRejection:je,notImplemented:ae,services:ue,Glob:Mt,curry:r,compose:n,pipe:i,prop:Vt,propEq:At,parse:Ht,not:qt,and:o,or:a,all:Dt,any:Ft,is:Nt,eq:Ut,val:Lt,invoke:u,pattern:s,isUndefined:zt,isDefined:Jt,isNull:Qt,isNullOrUndefined:Kt,isFunction:Yt,isNumber:Zt,isString:Xt,isObject:te,isArray:ee,isDate:re,isRegExp:ne,isState:ie,isInjectable:c,isPromise:oe,Queue:Ve,maxLength:M,padString:B,kebobString:G,functionToString:W,fnToString:z,stringify:J,beforeAfterSubstr:dr,hostRegex:vr,stripFile:mr,splitHash:yr,splitQuery:gr,splitEqual:wr,trimHashVal:_r,splitOnDelim:Q,joinNeighborsR:K,get Category(){return t.Category},Trace:Le,trace:Me,get DefType(){return t.DefType},Param:Ze,ParamTypes:$r,StateParams:br,ParamType:Qe,PathNode:Xe,PathUtils:tr,resolvePolicies:nr,defaultResolvePolicy:er,Resolvable:rr,NATIVE_INJECTOR_TOKEN:ur,ResolveContext:sr,resolvablesBuilder:rt,StateBuilder:Pr,StateObject:Bt,StateMatcher:kr,StateQueueManager:Or,StateRegistry:xr,StateService:kn,TargetState:Be,get TransitionHookPhase(){return t.TransitionHookPhase},get TransitionHookScope(){return t.TransitionHookScope},HookBuilder:Je,matchState:A,RegisteredHook:ze,makeEvent:H,get RejectType(){return t.RejectType},Rejection:He,Transition:lr,TransitionHook:We,TransitionEventType:Rn,defaultTransOpts:Tn,TransitionService:Pn,UrlMatcher:Vr,UrlMatcherFactory:Ar,UrlRouter:Lr,UrlRuleFactory:Hr,BaseUrlRule:qr,UrlService:Yr,ViewService:Mr,UIRouterGlobals:Br,UIRouter:Xr,$q:On,$injector:Vn,BaseLocationServices:Fn,HashLocationService:Un,MemoryLocationService:Mn,PushStateLocationService:Gn,MemoryLocationConfig:Wn,BrowserLocationConfig:zn,keyValsToObjectR:An,getParams:Hn,parseUrl:lt,buildUrl:qn,locationPluginFactory:ht,getCustomEventCtor:pt,servicesPlugin:dt,hashLocationPlugin:Jn,pushStateLocationPlugin:Qn,memoryLocationPlugin:Kn,UIRouterPluginBase:Yn}),Xn=function(t,e){return t.reduce(function(t,r){return t||Jt(e[r])},!1)},ti=0,ei=function(){function t(t,e,r){var n=this;this.path=t,this.viewDecl=e,this.factory=r,this.$id=ti++,this.loaded=!1,this.getTemplate=function(t,e){return n.component?n.factory.makeComponentTemplate(t,e,n.component,n.viewDecl.bindings):n.template}}return t.prototype.load=function(){var t=this,e=ue.$q,r=new sr(this.path),n=this.path.reduce(function(t,e){return he(t,e.paramValues)},{}),i={template:e.when(this.factory.fromConfig(this.viewDecl,n,r)),controller:e.when(this.getController(r))};return e.all(i).then(function(e){return Me.traceViewServiceEvent("Loaded",t),t.controller=e.controller,he(t,e.template),t})},t.prototype.getController=function(t){var e=this.viewDecl.controllerProvider;if(!c(e))return this.viewDecl.controller;var r=ue.$injector.annotate(e),n=ee(e)?P(e):e;return new rr("",n,r).get(t)},t}(),ri=function(){function t(){var t=this;this._useHttp=jt.version.minor<3,this.$get=["$http","$templateCache","$injector",function(e,r,n){return t.$templateRequest=n.has&&n.has("$templateRequest")&&n.get("$templateRequest"),t.$http=e,t.$templateCache=r,t}]}return t.prototype.useHttpService=function(t){this._useHttp=t},t.prototype.fromConfig=function(t,e,r){var n=function(t){return ue.$q.when(t).then(function(t){return{template:t}})},i=function(t){return ue.$q.when(t).then(function(t){return{component:t}})};return Jt(t.template)?n(this.fromString(t.template,e)):Jt(t.templateUrl)?n(this.fromUrl(t.templateUrl,e)):Jt(t.templateProvider)?n(this.fromProvider(t.templateProvider,e,r)):Jt(t.component)?i(t.component):Jt(t.componentProvider)?i(this.fromComponentProvider(t.componentProvider,e,r)):n("<ui-view></ui-view>")},t.prototype.fromString=function(t,e){return Yt(t)?t(e):t},t.prototype.fromUrl=function(t,e){return Yt(t)&&(t=t(e)),null==t?null:this._useHttp?this.$http.get(t,{cache:this.$templateCache,headers:{Accept:"text/html"}}).then(function(t){return t.data}):this.$templateRequest(t)},t.prototype.fromProvider=function(t,e,r){var n=ue.$injector.annotate(t),i=ee(t)?P(t):t;return new rr("",i,n).get(r)},t.prototype.fromComponentProvider=function(t,e,r){var n=ue.$injector.annotate(t),i=ee(t)?P(t):t;return new rr("",i,n).get(r)},t.prototype.makeComponentTemplate=function(t,e,r,n){n=n||{};var i=jt.version.minor>=3?"::":"",o=function(t){var e=G(t);return/^(x|data)-/.exec(e)?"x-"+e:e},a=yt(r).map(function(r){var a=r.name,u=r.type,s=o(a);if(t.attr(s)&&!n[a])return s+"='"+t.attr(s)+"'";var c=n[a]||a;if("@"===u)return s+"='{{"+i+"$resolve."+c+"}}'";if("&"===u){var f=e.getResolvable(c),l=f&&f.data,h=l&&ue.$injector.annotate(l)||[];return s+"='$resolve."+c+(ee(l)?"["+(l.length-1)+"]":"")+"("+h.join(",")+")'"}return s+"='"+i+"$resolve."+c+"'"}).join(" "),u=o(r);return"<"+u+" "+a+"></"+u+">"},t}(),ni=function(t){return ii(te(t.bindToController)?t.bindToController:t.scope)},ii=function(t){return Object.keys(t||{}).map(function(e){return[e,/^([=<@&])[?]?(.*)/.exec(t[e])]}).filter(function(t){return Jt(t)&&ee(t[1])}).map(function(t){return{name:t[1][2]||t[0],type:t[1][1]}})},oi=function(){function t(e,r){this.stateRegistry=e,this.stateService=r,h(Lt(t.prototype),this,Lt(this))}return t.prototype.decorator=function(t,e){return this.stateRegistry.decorator(t,e)||this},t.prototype.state=function(t,e){return te(t)?e=t:e.name=t,this.stateRegistry.register(e),this},t.prototype.onInvalid=function(t){return this.stateService.onInvalid(t)},t}(),ai=function(t){return function(e,r){var n=e[t],i="onExit"===t?"from":"to";return n?function(t,e){var r=new sr(t.treeChanges(i)),o=he(yi(r),{$state$:e,$transition$:t});return ue.$injector.invoke(n,this,o)}:void 0}},ui=function(){function t(t){this._urlListeners=[],this.$locationProvider=t;var e=Lt(t);h(e,this,e,["hashPrefix"])}return t.prototype.dispose=function(){},t.prototype.onChange=function(t){var e=this;return this._urlListeners.push(t),function(){return me(e._urlListeners)(t)}},t.prototype.html5Mode=function(){var t=this.$locationProvider.html5Mode();return(t=te(t)?t.enabled:t)&&this.$sniffer.history},t.prototype.url=function(t,e,r){return void 0===e&&(e=!1),t&&this.$location.url(t),e&&this.$location.replace(),r&&this.$location.state(r),this.$location.url()},t.prototype._runtimeServices=function(t,e,r,n){var i=this;this.$location=e,this.$sniffer=r,t.$on("$locationChangeSuccess",function(t){return i._urlListeners.forEach(function(e){return e(t)})});var o=Lt(e),a=Lt(n);h(o,this,o,["replace","path","search","hash"]),h(o,this,o,["port","protocol","host"]),h(a,this,a,["baseHref"])},t.monkeyPatchPathParameterType=function(t){var e=t.urlMatcherFactory.type("path");e.encode=function(t){return null!=t?t.toString().replace(/(~|\/)/g,function(t){return{"~":"~~","/":"~2F"}[t]}):t},e.decode=function(t){return null!=t?t.toString().replace(/(~~|~2F)/g,function(t){return{"~~":"~","~2F":"/"}[t]}):t}},t}(),si=function(){function t(t){this._router=t,this._urlRouter=t.urlRouter}return t.prototype.$get=function(){var t=this._urlRouter;return t.update(!0),t.interceptDeferred||t.listen(),t},t.prototype.rule=function(t){var e=this;if(!Yt(t))throw new Error("'rule' must be a function");var r=new qr(function(){return t(ue.$injector,e._router.locationService)},f);return this._urlRouter.rule(r),this},t.prototype.otherwise=function(t){var e=this,r=this._urlRouter;if(Xt(t))r.otherwise(t);else{if(!Yt(t))throw new Error("'rule' must be a string or function");r.otherwise(function(){return t(ue.$injector,e._router.locationService)})}return this},t.prototype.when=function(e,r){return(ee(r)||Yt(r))&&(r=t.injectableHandler(this._router,r)),this._urlRouter.when(e,r),this},t.injectableHandler=function(t,e){return function(r){return ue.$injector.invoke(e,null,{$match:r,$stateParams:t.globals.params})}},t.prototype.deferIntercept=function(t){this._urlRouter.deferIntercept(t)},t}();jt.module("ui.router.angular1",[]);var ci=jt.module("ui.router.init",[]),fi=jt.module("ui.router.util",["ng","ui.router.init"]),li=jt.module("ui.router.router",["ui.router.util"]),hi=jt.module("ui.router.state",["ui.router.router","ui.router.util","ui.router.angular1"]),pi=jt.module("ui.router",["ui.router.init","ui.router.state","ui.router.angular1"]),di=(jt.module("ui.router.compat",["ui.router"]),null);gt.$inject=["$locationProvider"];var vi=function(t){return["$uiRouterProvider",function(e){var r=e.router[t];return r.$get=function(){return r},r}]};wt.$inject=["$injector","$q","$uiRouter"];_t.$inject=["$rootScope"],ci.provider("$uiRouter",gt),li.provider("$urlRouter",["$uiRouterProvider",function(t){return t.urlRouterProvider=new si(t)}]),fi.provider("$urlService",vi("urlService")),fi.provider("$urlMatcherFactory",["$uiRouterProvider",function(){return di.urlMatcherFactory}]),fi.provider("$templateFactory",function(){return new ri}),hi.provider("$stateRegistry",vi("stateRegistry")),hi.provider("$uiRouterGlobals",vi("globals")),hi.provider("$transitions",vi("transitionService")),hi.provider("$state",["$uiRouterProvider",function(){return he(di.stateProvider,{$get:function(){return di.stateService}})}]),hi.factory("$stateParams",["$uiRouter",function(t){return t.globals.params}]),pi.factory("$view",function(){return di.viewService}),pi.service("$trace",function(){return Me}),pi.run(_t),fi.run(["$urlMatcherFactory",function(t){}]),hi.run(["$state",function(t){}]),li.run(["$urlRouter",function(t){}]),ci.run(wt);var mi,yi=function(t){return t.getTokens().filter(Xt).map(function(e){var r=t.getResolvable(e);return[e,"NOWAIT"===t.getPolicy(r).async?r.promise:r.data]}).reduce(T,{})};mi=["$uiRouter","$timeout",function(t,e){var r=t.stateService;return{restrict:"A",require:["?^uiSrefActive","?^uiSrefActiveEq"],link:function(n,i,o,a){function u(){var t=p();l&&l(),f&&(l=f.$$addStateInfo(t.uiState,t.uiStateParams)),null!=t.href&&o.$set(c.attr,t.href)}var s,c=Rt(i),f=a[1]||a[0],l=null,h={},p=function(){return bt(r,i,h)},d=$t(o.uiSref);h.uiState=d.state,h.uiStateOpts=o.uiSrefOpts?n.$eval(o.uiSrefOpts):{},d.paramExpr&&(n.$watch(d.paramExpr,function(t){h.uiStateParams=he({},t),u()},!0),h.uiStateParams=he({},n.$eval(d.paramExpr))),u(),n.$on("$destroy",t.stateRegistry.onStatesChanged(u)),n.$on("$destroy",t.transitionService.onSuccess({},u)),c.clickable&&(s=Et(i,r,e,c,p),Tt(i,n,s,h.uiStateOpts))}}}];var gi;gi=["$uiRouter","$timeout",function(t,e){var r=t.stateService;return{restrict:"A",require:["?^uiSrefActive","?^uiSrefActiveEq"],link:function(n,i,o,a){function u(){var t=d();h&&h(),f&&(h=f.$$addStateInfo(t.uiState,t.uiStateParams)),null!=t.href&&o.$set(c.attr,t.href)}var s,c=Rt(i),f=a[1]||a[0],h=null,p={},d=function(){return bt(r,i,p)},v=["uiState","uiStateParams","uiStateOpts"],m=v.reduce(function(t,e){return t[e]=l,t},{});v.forEach(function(t){p[t]=o[t]?n.$eval(o[t]):null,o.$observe(t,function(e){m[t](),m[t]=n.$watch(e,function(e){p[t]=e,u()},!0)})}),u(),n.$on("$destroy",t.stateRegistry.onStatesChanged(u)),n.$on("$destroy",t.transitionService.onSuccess({},u)),c.clickable&&(s=Et(i,r,e,c,d),Tt(i,n,s,p.uiStateOpts))}}}];var wi;wi=["$state","$stateParams","$interpolate","$uiRouter",function(t,e,r,n){return{restrict:"A",controller:["$scope","$element","$attrs",function(e,i,o){function a(t){t.promise.then(s,l)}function u(e,r,n){var o={state:t.get(e,St(i))||{name:e},params:r,activeClass:n};return p.push(o),function(){me(p)(o)}}function s(){var r=function(t){return t.split(/\s/).filter(f)},n=function(t){return t.map(function(t){return t.activeClass}).map(r).reduce(Re,[])},o=n(p).concat(r(c)).reduce(Ce,[]),a=n(p.filter(function(e){return t.includes(e.state.name,e.params)})),u=!!p.filter(function(e){return t.is(e.state.name,e.params)}).length?r(c):[],s=a.concat(u).reduce(Ce,[]),l=o.filter(function(t){return!ve(s,t)});e.$evalAsync(function(){s.forEach(function(t){return i.addClass(t)}),l.forEach(function(t){return i.removeClass(t)})})}var c,h,p=[];c=r(o.uiSrefActiveEq||"",!1)(e);try{h=e.$eval(o.uiSrefActive)}catch(t){}h=h||r(o.uiSrefActive||"",!1)(e),te(h)&&le(h,function(t,r){if(Xt(t)){var n=$t(t);u(n.state,e.$eval(n.paramExpr),r)}}),this.$$addStateInfo=function(t,e){if(!(te(h)&&p.length>0)){var r=u(t,e,h);return s(),r}},e.$on("$stateChangeSuccess",s),e.$on("$destroy",n.transitionService.onStart({},a)),n.globals.transition&&a(n.globals.transition),s()}]}}],jt.module("ui.router.state").directive("uiSref",mi).directive("uiSrefActive",wi).directive("uiSrefActiveEq",wi).directive("uiState",gi),Pt.$inject=["$state"],kt.$inject=["$state"],jt.module("ui.router.state").filter("isState",Pt).filter("includedByState",kt);var _i;_i=["$view","$animate","$uiViewScroll","$interpolate","$q",function(t,e,r,n,i){function o(t,r){return{enter:function(t,r,n){jt.version.minor>2?e.enter(t,null,r).then(n):e.enter(t,null,r,n)},leave:function(t,r){jt.version.minor>2?e.leave(t).then(r):e.leave(t,r)}}}function a(t,e){return t===e}var u={$cfg:{viewDecl:{$context:t._pluginapi._rootViewContext()}},$uiView:{}},s={count:0,restrict:"ECA",terminal:!0,priority:400,transclude:"element",compile:function(e,c,f){return function(e,c,l){function h(){if(d&&(Me.traceUIViewEvent("Removing (previous) el",d.data("$uiView")),d.remove(),d=null),m&&(Me.traceUIViewEvent("Destroying scope",R),m.$destroy(),m=null),v){var t=v.data("$uiViewAnim");Me.traceUIViewEvent("Animate out",t),_.leave(v,function(){t.$$animLeave.resolve(),d=null}),d=v,v=null}}function p(t){var n=e.$new(),o=i.defer(),a=i.defer(),u={$cfg:t,$uiView:R},s={$animEnter:o.promise,$animLeave:a.promise,$$animLeave:a};n.$emit("$viewContentLoading",b);var l=f(n,function(t){t.data("$uiViewAnim",s),t.data("$uiView",u),_.enter(t,c,function(){o.resolve(),m&&m.$emit("$viewContentAnimationEnded"),(Jt(w)&&!w||e.$eval(w))&&r(t)}),h()});v=l,(m=n).$emit("$viewContentLoaded",t||$),m.$eval(g)}var d,v,m,y,g=l.onload||"",w=l.autoscroll,_=o(),$=void 0,S=c.inheritedData("$uiView")||u,b=n(l.uiView||l.name||"")(e)||"$default",R={$type:"ng1",id:s.count++,name:b,fqn:S.$uiView.fqn?S.$uiView.fqn+"."+b:b,config:null,configUpdated:function(t){(!t||t instanceof ei)&&(a($,t)||(Me.traceUIViewConfigUpdated(R,t&&t.viewDecl&&t.viewDecl.$context),$=t,p(t)))},get creationContext(){var t=Ht("$cfg.viewDecl.$context")(S),e=Ht("$uiView.creationContext")(S);return t||e}};Me.traceUIViewEvent("Linking",R),c.data("$uiView",{$uiView:R}),p(),y=t.registerUIView(R),e.$on("$destroy",function(){Me.traceUIViewEvent("Destroying/Unregistering",R),y()})}}};return s}],Ot.$inject=["$compile","$controller","$transitions","$view","$q","$timeout"];var $i="function"==typeof jt.module("ui.router").component,Si=0;jt.module("ui.router.state").directive("uiView",_i),jt.module("ui.router.state").directive("uiView",Ot),jt.module("ui.router.state").provider("$uiViewScroll",function(){var t=!1;this.useAnchorScroll=function(){t=!0},this.$get=["$anchorScroll","$timeout",function(e,r){return t?e:function(t){return r(function(){t[0].scrollIntoView()},0,!1)}}]});t.default="ui.router",t.core=Zn,t.watchDigests=_t,t.getLocals=yi,t.getNg1ViewConfigFactory=vt,t.ng1ViewsBuilder=mt,t.Ng1ViewConfig=ei,t.StateProvider=oi,t.UrlRouterProvider=si,t.fromJson=ce,t.toJson=fe,t.forEach=le,t.extend=he,t.equals=pe,t.identity=f,t.noop=l,t.createProxyFunctions=h,t.inherit=de,t.inArray=ve,t._inArray=p,t.removeFrom=me,t._removeFrom=d,t.pushTo=ye,t._pushTo=v,t.deregAll=ge,t.defaults=m,t.mergeR=we,t.ancestors=y,t.pick=g,t.omit=w,t.pluck=_,t.filter=$,t.find=S,t.mapObj=_e,t.map=b,t.values=$e,t.allTrueR=Se,t.anyTrueR=be,t.unnestR=Re,t.flattenR=Ee,t.pushR=R,t.uniqR=Ce,t.unnest=Te,t.flatten=Pe,t.assertPredicate=ke,t.assertMap=Oe,t.assertFn=E,t.pairs=xe,t.arrayTuples=C,t.applyPairs=T,t.tail=P,t.copy=k,t._extend=O,t.silenceUncaughtInPromise=Ie,t.silentRejection=je,t.notImplemented=ae,t.services=ue,t.Glob=Mt,t.curry=r,t.compose=n,t.pipe=i,t.prop=Vt,t.propEq=At,t.parse=Ht,t.not=qt,t.and=o,t.or=a,t.all=Dt,t.any=Ft,t.is=Nt,t.eq=Ut,t.val=Lt,t.invoke=u,t.pattern=s,t.isUndefined=zt,t.isDefined=Jt,t.isNull=Qt,t.isNullOrUndefined=Kt,t.isFunction=Yt,t.isNumber=Zt,t.isString=Xt,t.isObject=te,t.isArray=ee,t.isDate=re,t.isRegExp=ne,t.isState=ie,t.isInjectable=c,t.isPromise=oe,t.Queue=Ve,t.maxLength=M,t.padString=B,t.kebobString=G,t.functionToString=W,t.fnToString=z,t.stringify=J,t.beforeAfterSubstr=dr,t.hostRegex=vr,t.stripFile=mr,t.splitHash=yr,t.splitQuery=gr,t.splitEqual=wr,t.trimHashVal=_r,t.splitOnDelim=Q,t.joinNeighborsR=K,t.Trace=Le,t.trace=Me,t.Param=Ze,t.ParamTypes=$r,t.StateParams=br,t.ParamType=Qe,t.PathNode=Xe,t.PathUtils=tr,t.resolvePolicies=nr,t.defaultResolvePolicy=er,t.Resolvable=rr,t.NATIVE_INJECTOR_TOKEN=ur,t.ResolveContext=sr,t.resolvablesBuilder=rt,t.StateBuilder=Pr,t.StateObject=Bt,t.StateMatcher=kr,t.StateQueueManager=Or,t.StateRegistry=xr,t.StateService=kn,t.TargetState=Be,t.HookBuilder=Je,t.matchState=A,t.RegisteredHook=ze,t.makeEvent=H,t.Rejection=He,t.Transition=lr,t.TransitionHook=We,t.TransitionEventType=Rn,t.defaultTransOpts=Tn,t.TransitionService=Pn,t.UrlMatcher=Vr,t.UrlMatcherFactory=Ar,t.UrlRouter=Lr,t.UrlRuleFactory=Hr,t.BaseUrlRule=qr,t.UrlService=Yr,t.ViewService=Mr,t.UIRouterGlobals=Br,t.UIRouter=Xr,t.$q=On,t.$injector=Vn,t.BaseLocationServices=Fn,t.HashLocationService=Un,t.MemoryLocationService=Mn,t.PushStateLocationService=Gn,t.MemoryLocationConfig=Wn,t.BrowserLocationConfig=zn,t.keyValsToObjectR=An,t.getParams=Hn,t.parseUrl=lt,t.buildUrl=qn,t.locationPluginFactory=ht,t.getCustomEventCtor=pt,t.servicesPlugin=dt,t.hashLocationPlugin=Jn,t.pushStateLocationPlugin=Qn,t.memoryLocationPlugin=Kn,t.UIRouterPluginBase=Yn,Object.defineProperty(t,"__esModule",{value:!0})});
//# sourceMappingURL=angular-ui-router.min.js.map


/*! jQuery v1.12.4 | (c) jQuery Foundation | jquery.org/license */
!function (a, b) { "object" == typeof module && "object" == typeof module.exports ? module.exports = a.document ? b(a, !0) : function (a) { if (!a.document) throw new Error("jQuery requires a window with a document"); return b(a) } : b(a) }("undefined" != typeof window ? window : this, function (a, b) {
    var c = [], d = a.document, e = c.slice, f = c.concat, g = c.push, h = c.indexOf, i = {}, j = i.toString, k = i.hasOwnProperty, l = {}, m = "1.12.4", n = function (a, b) { return new n.fn.init(a, b) }, o = /^[\s\uFEFF\xA0]+|[\s\uFEFF\xA0]+$/g, p = /^-ms-/, q = /-([\da-z])/gi, r = function (a, b) { return b.toUpperCase() }; n.fn = n.prototype = { jquery: m, constructor: n, selector: "", length: 0, toArray: function () { return e.call(this) }, get: function (a) { return null != a ? 0 > a ? this[a + this.length] : this[a] : e.call(this) }, pushStack: function (a) { var b = n.merge(this.constructor(), a); return b.prevObject = this, b.context = this.context, b }, each: function (a) { return n.each(this, a) }, map: function (a) { return this.pushStack(n.map(this, function (b, c) { return a.call(b, c, b) })) }, slice: function () { return this.pushStack(e.apply(this, arguments)) }, first: function () { return this.eq(0) }, last: function () { return this.eq(-1) }, eq: function (a) { var b = this.length, c = +a + (0 > a ? b : 0); return this.pushStack(c >= 0 && b > c ? [this[c]] : []) }, end: function () { return this.prevObject || this.constructor() }, push: g, sort: c.sort, splice: c.splice }, n.extend = n.fn.extend = function () { var a, b, c, d, e, f, g = arguments[0] || {}, h = 1, i = arguments.length, j = !1; for ("boolean" == typeof g && (j = g, g = arguments[h] || {}, h++), "object" == typeof g || n.isFunction(g) || (g = {}), h === i && (g = this, h--); i > h; h++)if (null != (e = arguments[h])) for (d in e) a = g[d], c = e[d], g !== c && (j && c && (n.isPlainObject(c) || (b = n.isArray(c))) ? (b ? (b = !1, f = a && n.isArray(a) ? a : []) : f = a && n.isPlainObject(a) ? a : {}, g[d] = n.extend(j, f, c)) : void 0 !== c && (g[d] = c)); return g }, n.extend({ expando: "jQuery" + (m + Math.random()).replace(/\D/g, ""), isReady: !0, error: function (a) { throw new Error(a) }, noop: function () { }, isFunction: function (a) { return "function" === n.type(a) }, isArray: Array.isArray || function (a) { return "array" === n.type(a) }, isWindow: function (a) { return null != a && a == a.window }, isNumeric: function (a) { var b = a && a.toString(); return !n.isArray(a) && b - parseFloat(b) + 1 >= 0 }, isEmptyObject: function (a) { var b; for (b in a) return !1; return !0 }, isPlainObject: function (a) { var b; if (!a || "object" !== n.type(a) || a.nodeType || n.isWindow(a)) return !1; try { if (a.constructor && !k.call(a, "constructor") && !k.call(a.constructor.prototype, "isPrototypeOf")) return !1 } catch (c) { return !1 } if (!l.ownFirst) for (b in a) return k.call(a, b); for (b in a); return void 0 === b || k.call(a, b) }, type: function (a) { return null == a ? a + "" : "object" == typeof a || "function" == typeof a ? i[j.call(a)] || "object" : typeof a }, globalEval: function (b) { b && n.trim(b) && (a.execScript || function (b) { a.eval.call(a, b) })(b) }, camelCase: function (a) { return a.replace(p, "ms-").replace(q, r) }, nodeName: function (a, b) { return a.nodeName && a.nodeName.toLowerCase() === b.toLowerCase() }, each: function (a, b) { var c, d = 0; if (s(a)) { for (c = a.length; c > d; d++)if (b.call(a[d], d, a[d]) === !1) break } else for (d in a) if (b.call(a[d], d, a[d]) === !1) break; return a }, trim: function (a) { return null == a ? "" : (a + "").replace(o, "") }, makeArray: function (a, b) { var c = b || []; return null != a && (s(Object(a)) ? n.merge(c, "string" == typeof a ? [a] : a) : g.call(c, a)), c }, inArray: function (a, b, c) { var d; if (b) { if (h) return h.call(b, a, c); for (d = b.length, c = c ? 0 > c ? Math.max(0, d + c) : c : 0; d > c; c++)if (c in b && b[c] === a) return c } return -1 }, merge: function (a, b) { var c = +b.length, d = 0, e = a.length; while (c > d) a[e++] = b[d++]; if (c !== c) while (void 0 !== b[d]) a[e++] = b[d++]; return a.length = e, a }, grep: function (a, b, c) { for (var d, e = [], f = 0, g = a.length, h = !c; g > f; f++)d = !b(a[f], f), d !== h && e.push(a[f]); return e }, map: function (a, b, c) { var d, e, g = 0, h = []; if (s(a)) for (d = a.length; d > g; g++)e = b(a[g], g, c), null != e && h.push(e); else for (g in a) e = b(a[g], g, c), null != e && h.push(e); return f.apply([], h) }, guid: 1, proxy: function (a, b) { var c, d, f; return "string" == typeof b && (f = a[b], b = a, a = f), n.isFunction(a) ? (c = e.call(arguments, 2), d = function () { return a.apply(b || this, c.concat(e.call(arguments))) }, d.guid = a.guid = a.guid || n.guid++ , d) : void 0 }, now: function () { return +new Date }, support: l }), "function" == typeof Symbol && (n.fn[Symbol.iterator] = c[Symbol.iterator]), n.each("Boolean Number String Function Array Date RegExp Object Error Symbol".split(" "), function (a, b) { i["[object " + b + "]"] = b.toLowerCase() }); function s(a) { var b = !!a && "length" in a && a.length, c = n.type(a); return "function" === c || n.isWindow(a) ? !1 : "array" === c || 0 === b || "number" == typeof b && b > 0 && b - 1 in a } var t = function (a) { var b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u = "sizzle" + 1 * new Date, v = a.document, w = 0, x = 0, y = ga(), z = ga(), A = ga(), B = function (a, b) { return a === b && (l = !0), 0 }, C = 1 << 31, D = {}.hasOwnProperty, E = [], F = E.pop, G = E.push, H = E.push, I = E.slice, J = function (a, b) { for (var c = 0, d = a.length; d > c; c++)if (a[c] === b) return c; return -1 }, K = "checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped", L = "[\\x20\\t\\r\\n\\f]", M = "(?:\\\\.|[\\w-]|[^\\x00-\\xa0])+", N = "\\[" + L + "*(" + M + ")(?:" + L + "*([*^$|!~]?=)" + L + "*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|(" + M + "))|)" + L + "*\\]", O = ":(" + M + ")(?:\\((('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|((?:\\\\.|[^\\\\()[\\]]|" + N + ")*)|.*)\\)|)", P = new RegExp(L + "+", "g"), Q = new RegExp("^" + L + "+|((?:^|[^\\\\])(?:\\\\.)*)" + L + "+$", "g"), R = new RegExp("^" + L + "*," + L + "*"), S = new RegExp("^" + L + "*([>+~]|" + L + ")" + L + "*"), T = new RegExp("=" + L + "*([^\\]'\"]*?)" + L + "*\\]", "g"), U = new RegExp(O), V = new RegExp("^" + M + "$"), W = { ID: new RegExp("^#(" + M + ")"), CLASS: new RegExp("^\\.(" + M + ")"), TAG: new RegExp("^(" + M + "|[*])"), ATTR: new RegExp("^" + N), PSEUDO: new RegExp("^" + O), CHILD: new RegExp("^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\(" + L + "*(even|odd|(([+-]|)(\\d*)n|)" + L + "*(?:([+-]|)" + L + "*(\\d+)|))" + L + "*\\)|)", "i"), bool: new RegExp("^(?:" + K + ")$", "i"), needsContext: new RegExp("^" + L + "*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\(" + L + "*((?:-\\d)?\\d*)" + L + "*\\)|)(?=[^-]|$)", "i") }, X = /^(?:input|select|textarea|button)$/i, Y = /^h\d$/i, Z = /^[^{]+\{\s*\[native \w/, $ = /^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/, _ = /[+~]/, aa = /'|\\/g, ba = new RegExp("\\\\([\\da-f]{1,6}" + L + "?|(" + L + ")|.)", "ig"), ca = function (a, b, c) { var d = "0x" + b - 65536; return d !== d || c ? b : 0 > d ? String.fromCharCode(d + 65536) : String.fromCharCode(d >> 10 | 55296, 1023 & d | 56320) }, da = function () { m() }; try { H.apply(E = I.call(v.childNodes), v.childNodes), E[v.childNodes.length].nodeType } catch (ea) { H = { apply: E.length ? function (a, b) { G.apply(a, I.call(b)) } : function (a, b) { var c = a.length, d = 0; while (a[c++] = b[d++]); a.length = c - 1 } } } function fa(a, b, d, e) { var f, h, j, k, l, o, r, s, w = b && b.ownerDocument, x = b ? b.nodeType : 9; if (d = d || [], "string" != typeof a || !a || 1 !== x && 9 !== x && 11 !== x) return d; if (!e && ((b ? b.ownerDocument || b : v) !== n && m(b), b = b || n, p)) { if (11 !== x && (o = $.exec(a))) if (f = o[1]) { if (9 === x) { if (!(j = b.getElementById(f))) return d; if (j.id === f) return d.push(j), d } else if (w && (j = w.getElementById(f)) && t(b, j) && j.id === f) return d.push(j), d } else { if (o[2]) return H.apply(d, b.getElementsByTagName(a)), d; if ((f = o[3]) && c.getElementsByClassName && b.getElementsByClassName) return H.apply(d, b.getElementsByClassName(f)), d } if (c.qsa && !A[a + " "] && (!q || !q.test(a))) { if (1 !== x) w = b, s = a; else if ("object" !== b.nodeName.toLowerCase()) { (k = b.getAttribute("id")) ? k = k.replace(aa, "\\$&") : b.setAttribute("id", k = u), r = g(a), h = r.length, l = V.test(k) ? "#" + k : "[id='" + k + "']"; while (h--) r[h] = l + " " + qa(r[h]); s = r.join(","), w = _.test(a) && oa(b.parentNode) || b } if (s) try { return H.apply(d, w.querySelectorAll(s)), d } catch (y) { } finally { k === u && b.removeAttribute("id") } } } return i(a.replace(Q, "$1"), b, d, e) } function ga() { var a = []; function b(c, e) { return a.push(c + " ") > d.cacheLength && delete b[a.shift()], b[c + " "] = e } return b } function ha(a) { return a[u] = !0, a } function ia(a) { var b = n.createElement("div"); try { return !!a(b) } catch (c) { return !1 } finally { b.parentNode && b.parentNode.removeChild(b), b = null } } function ja(a, b) { var c = a.split("|"), e = c.length; while (e--) d.attrHandle[c[e]] = b } function ka(a, b) { var c = b && a, d = c && 1 === a.nodeType && 1 === b.nodeType && (~b.sourceIndex || C) - (~a.sourceIndex || C); if (d) return d; if (c) while (c = c.nextSibling) if (c === b) return -1; return a ? 1 : -1 } function la(a) { return function (b) { var c = b.nodeName.toLowerCase(); return "input" === c && b.type === a } } function ma(a) { return function (b) { var c = b.nodeName.toLowerCase(); return ("input" === c || "button" === c) && b.type === a } } function na(a) { return ha(function (b) { return b = +b, ha(function (c, d) { var e, f = a([], c.length, b), g = f.length; while (g--) c[e = f[g]] && (c[e] = !(d[e] = c[e])) }) }) } function oa(a) { return a && "undefined" != typeof a.getElementsByTagName && a } c = fa.support = {}, f = fa.isXML = function (a) { var b = a && (a.ownerDocument || a).documentElement; return b ? "HTML" !== b.nodeName : !1 }, m = fa.setDocument = function (a) { var b, e, g = a ? a.ownerDocument || a : v; return g !== n && 9 === g.nodeType && g.documentElement ? (n = g, o = n.documentElement, p = !f(n), (e = n.defaultView) && e.top !== e && (e.addEventListener ? e.addEventListener("unload", da, !1) : e.attachEvent && e.attachEvent("onunload", da)), c.attributes = ia(function (a) { return a.className = "i", !a.getAttribute("className") }), c.getElementsByTagName = ia(function (a) { return a.appendChild(n.createComment("")), !a.getElementsByTagName("*").length }), c.getElementsByClassName = Z.test(n.getElementsByClassName), c.getById = ia(function (a) { return o.appendChild(a).id = u, !n.getElementsByName || !n.getElementsByName(u).length }), c.getById ? (d.find.ID = function (a, b) { if ("undefined" != typeof b.getElementById && p) { var c = b.getElementById(a); return c ? [c] : [] } }, d.filter.ID = function (a) { var b = a.replace(ba, ca); return function (a) { return a.getAttribute("id") === b } }) : (delete d.find.ID, d.filter.ID = function (a) { var b = a.replace(ba, ca); return function (a) { var c = "undefined" != typeof a.getAttributeNode && a.getAttributeNode("id"); return c && c.value === b } }), d.find.TAG = c.getElementsByTagName ? function (a, b) { return "undefined" != typeof b.getElementsByTagName ? b.getElementsByTagName(a) : c.qsa ? b.querySelectorAll(a) : void 0 } : function (a, b) { var c, d = [], e = 0, f = b.getElementsByTagName(a); if ("*" === a) { while (c = f[e++]) 1 === c.nodeType && d.push(c); return d } return f }, d.find.CLASS = c.getElementsByClassName && function (a, b) { return "undefined" != typeof b.getElementsByClassName && p ? b.getElementsByClassName(a) : void 0 }, r = [], q = [], (c.qsa = Z.test(n.querySelectorAll)) && (ia(function (a) { o.appendChild(a).innerHTML = "<a id='" + u + "'></a><select id='" + u + "-\r\\' msallowcapture=''><option selected=''></option></select>", a.querySelectorAll("[msallowcapture^='']").length && q.push("[*^$]=" + L + "*(?:''|\"\")"), a.querySelectorAll("[selected]").length || q.push("\\[" + L + "*(?:value|" + K + ")"), a.querySelectorAll("[id~=" + u + "-]").length || q.push("~="), a.querySelectorAll(":checked").length || q.push(":checked"), a.querySelectorAll("a#" + u + "+*").length || q.push(".#.+[+~]") }), ia(function (a) { var b = n.createElement("input"); b.setAttribute("type", "hidden"), a.appendChild(b).setAttribute("name", "D"), a.querySelectorAll("[name=d]").length && q.push("name" + L + "*[*^$|!~]?="), a.querySelectorAll(":enabled").length || q.push(":enabled", ":disabled"), a.querySelectorAll("*,:x"), q.push(",.*:") })), (c.matchesSelector = Z.test(s = o.matches || o.webkitMatchesSelector || o.mozMatchesSelector || o.oMatchesSelector || o.msMatchesSelector)) && ia(function (a) { c.disconnectedMatch = s.call(a, "div"), s.call(a, "[s!='']:x"), r.push("!=", O) }), q = q.length && new RegExp(q.join("|")), r = r.length && new RegExp(r.join("|")), b = Z.test(o.compareDocumentPosition), t = b || Z.test(o.contains) ? function (a, b) { var c = 9 === a.nodeType ? a.documentElement : a, d = b && b.parentNode; return a === d || !(!d || 1 !== d.nodeType || !(c.contains ? c.contains(d) : a.compareDocumentPosition && 16 & a.compareDocumentPosition(d))) } : function (a, b) { if (b) while (b = b.parentNode) if (b === a) return !0; return !1 }, B = b ? function (a, b) { if (a === b) return l = !0, 0; var d = !a.compareDocumentPosition - !b.compareDocumentPosition; return d ? d : (d = (a.ownerDocument || a) === (b.ownerDocument || b) ? a.compareDocumentPosition(b) : 1, 1 & d || !c.sortDetached && b.compareDocumentPosition(a) === d ? a === n || a.ownerDocument === v && t(v, a) ? -1 : b === n || b.ownerDocument === v && t(v, b) ? 1 : k ? J(k, a) - J(k, b) : 0 : 4 & d ? -1 : 1) } : function (a, b) { if (a === b) return l = !0, 0; var c, d = 0, e = a.parentNode, f = b.parentNode, g = [a], h = [b]; if (!e || !f) return a === n ? -1 : b === n ? 1 : e ? -1 : f ? 1 : k ? J(k, a) - J(k, b) : 0; if (e === f) return ka(a, b); c = a; while (c = c.parentNode) g.unshift(c); c = b; while (c = c.parentNode) h.unshift(c); while (g[d] === h[d]) d++; return d ? ka(g[d], h[d]) : g[d] === v ? -1 : h[d] === v ? 1 : 0 }, n) : n }, fa.matches = function (a, b) { return fa(a, null, null, b) }, fa.matchesSelector = function (a, b) { if ((a.ownerDocument || a) !== n && m(a), b = b.replace(T, "='$1']"), c.matchesSelector && p && !A[b + " "] && (!r || !r.test(b)) && (!q || !q.test(b))) try { var d = s.call(a, b); if (d || c.disconnectedMatch || a.document && 11 !== a.document.nodeType) return d } catch (e) { } return fa(b, n, null, [a]).length > 0 }, fa.contains = function (a, b) { return (a.ownerDocument || a) !== n && m(a), t(a, b) }, fa.attr = function (a, b) { (a.ownerDocument || a) !== n && m(a); var e = d.attrHandle[b.toLowerCase()], f = e && D.call(d.attrHandle, b.toLowerCase()) ? e(a, b, !p) : void 0; return void 0 !== f ? f : c.attributes || !p ? a.getAttribute(b) : (f = a.getAttributeNode(b)) && f.specified ? f.value : null }, fa.error = function (a) { throw new Error("Syntax error, unrecognized expression: " + a) }, fa.uniqueSort = function (a) { var b, d = [], e = 0, f = 0; if (l = !c.detectDuplicates, k = !c.sortStable && a.slice(0), a.sort(B), l) { while (b = a[f++]) b === a[f] && (e = d.push(f)); while (e--) a.splice(d[e], 1) } return k = null, a }, e = fa.getText = function (a) { var b, c = "", d = 0, f = a.nodeType; if (f) { if (1 === f || 9 === f || 11 === f) { if ("string" == typeof a.textContent) return a.textContent; for (a = a.firstChild; a; a = a.nextSibling)c += e(a) } else if (3 === f || 4 === f) return a.nodeValue } else while (b = a[d++]) c += e(b); return c }, d = fa.selectors = { cacheLength: 50, createPseudo: ha, match: W, attrHandle: {}, find: {}, relative: { ">": { dir: "parentNode", first: !0 }, " ": { dir: "parentNode" }, "+": { dir: "previousSibling", first: !0 }, "~": { dir: "previousSibling" } }, preFilter: { ATTR: function (a) { return a[1] = a[1].replace(ba, ca), a[3] = (a[3] || a[4] || a[5] || "").replace(ba, ca), "~=" === a[2] && (a[3] = " " + a[3] + " "), a.slice(0, 4) }, CHILD: function (a) { return a[1] = a[1].toLowerCase(), "nth" === a[1].slice(0, 3) ? (a[3] || fa.error(a[0]), a[4] = +(a[4] ? a[5] + (a[6] || 1) : 2 * ("even" === a[3] || "odd" === a[3])), a[5] = +(a[7] + a[8] || "odd" === a[3])) : a[3] && fa.error(a[0]), a }, PSEUDO: function (a) { var b, c = !a[6] && a[2]; return W.CHILD.test(a[0]) ? null : (a[3] ? a[2] = a[4] || a[5] || "" : c && U.test(c) && (b = g(c, !0)) && (b = c.indexOf(")", c.length - b) - c.length) && (a[0] = a[0].slice(0, b), a[2] = c.slice(0, b)), a.slice(0, 3)) } }, filter: { TAG: function (a) { var b = a.replace(ba, ca).toLowerCase(); return "*" === a ? function () { return !0 } : function (a) { return a.nodeName && a.nodeName.toLowerCase() === b } }, CLASS: function (a) { var b = y[a + " "]; return b || (b = new RegExp("(^|" + L + ")" + a + "(" + L + "|$)")) && y(a, function (a) { return b.test("string" == typeof a.className && a.className || "undefined" != typeof a.getAttribute && a.getAttribute("class") || "") }) }, ATTR: function (a, b, c) { return function (d) { var e = fa.attr(d, a); return null == e ? "!=" === b : b ? (e += "", "=" === b ? e === c : "!=" === b ? e !== c : "^=" === b ? c && 0 === e.indexOf(c) : "*=" === b ? c && e.indexOf(c) > -1 : "$=" === b ? c && e.slice(-c.length) === c : "~=" === b ? (" " + e.replace(P, " ") + " ").indexOf(c) > -1 : "|=" === b ? e === c || e.slice(0, c.length + 1) === c + "-" : !1) : !0 } }, CHILD: function (a, b, c, d, e) { var f = "nth" !== a.slice(0, 3), g = "last" !== a.slice(-4), h = "of-type" === b; return 1 === d && 0 === e ? function (a) { return !!a.parentNode } : function (b, c, i) { var j, k, l, m, n, o, p = f !== g ? "nextSibling" : "previousSibling", q = b.parentNode, r = h && b.nodeName.toLowerCase(), s = !i && !h, t = !1; if (q) { if (f) { while (p) { m = b; while (m = m[p]) if (h ? m.nodeName.toLowerCase() === r : 1 === m.nodeType) return !1; o = p = "only" === a && !o && "nextSibling" } return !0 } if (o = [g ? q.firstChild : q.lastChild], g && s) { m = q, l = m[u] || (m[u] = {}), k = l[m.uniqueID] || (l[m.uniqueID] = {}), j = k[a] || [], n = j[0] === w && j[1], t = n && j[2], m = n && q.childNodes[n]; while (m = ++n && m && m[p] || (t = n = 0) || o.pop()) if (1 === m.nodeType && ++t && m === b) { k[a] = [w, n, t]; break } } else if (s && (m = b, l = m[u] || (m[u] = {}), k = l[m.uniqueID] || (l[m.uniqueID] = {}), j = k[a] || [], n = j[0] === w && j[1], t = n), t === !1) while (m = ++n && m && m[p] || (t = n = 0) || o.pop()) if ((h ? m.nodeName.toLowerCase() === r : 1 === m.nodeType) && ++t && (s && (l = m[u] || (m[u] = {}), k = l[m.uniqueID] || (l[m.uniqueID] = {}), k[a] = [w, t]), m === b)) break; return t -= e, t === d || t % d === 0 && t / d >= 0 } } }, PSEUDO: function (a, b) { var c, e = d.pseudos[a] || d.setFilters[a.toLowerCase()] || fa.error("unsupported pseudo: " + a); return e[u] ? e(b) : e.length > 1 ? (c = [a, a, "", b], d.setFilters.hasOwnProperty(a.toLowerCase()) ? ha(function (a, c) { var d, f = e(a, b), g = f.length; while (g--) d = J(a, f[g]), a[d] = !(c[d] = f[g]) }) : function (a) { return e(a, 0, c) }) : e } }, pseudos: { not: ha(function (a) { var b = [], c = [], d = h(a.replace(Q, "$1")); return d[u] ? ha(function (a, b, c, e) { var f, g = d(a, null, e, []), h = a.length; while (h--) (f = g[h]) && (a[h] = !(b[h] = f)) }) : function (a, e, f) { return b[0] = a, d(b, null, f, c), b[0] = null, !c.pop() } }), has: ha(function (a) { return function (b) { return fa(a, b).length > 0 } }), contains: ha(function (a) { return a = a.replace(ba, ca), function (b) { return (b.textContent || b.innerText || e(b)).indexOf(a) > -1 } }), lang: ha(function (a) { return V.test(a || "") || fa.error("unsupported lang: " + a), a = a.replace(ba, ca).toLowerCase(), function (b) { var c; do if (c = p ? b.lang : b.getAttribute("xml:lang") || b.getAttribute("lang")) return c = c.toLowerCase(), c === a || 0 === c.indexOf(a + "-"); while ((b = b.parentNode) && 1 === b.nodeType); return !1 } }), target: function (b) { var c = a.location && a.location.hash; return c && c.slice(1) === b.id }, root: function (a) { return a === o }, focus: function (a) { return a === n.activeElement && (!n.hasFocus || n.hasFocus()) && !!(a.type || a.href || ~a.tabIndex) }, enabled: function (a) { return a.disabled === !1 }, disabled: function (a) { return a.disabled === !0 }, checked: function (a) { var b = a.nodeName.toLowerCase(); return "input" === b && !!a.checked || "option" === b && !!a.selected }, selected: function (a) { return a.parentNode && a.parentNode.selectedIndex, a.selected === !0 }, empty: function (a) { for (a = a.firstChild; a; a = a.nextSibling)if (a.nodeType < 6) return !1; return !0 }, parent: function (a) { return !d.pseudos.empty(a) }, header: function (a) { return Y.test(a.nodeName) }, input: function (a) { return X.test(a.nodeName) }, button: function (a) { var b = a.nodeName.toLowerCase(); return "input" === b && "button" === a.type || "button" === b }, text: function (a) { var b; return "input" === a.nodeName.toLowerCase() && "text" === a.type && (null == (b = a.getAttribute("type")) || "text" === b.toLowerCase()) }, first: na(function () { return [0] }), last: na(function (a, b) { return [b - 1] }), eq: na(function (a, b, c) { return [0 > c ? c + b : c] }), even: na(function (a, b) { for (var c = 0; b > c; c += 2)a.push(c); return a }), odd: na(function (a, b) { for (var c = 1; b > c; c += 2)a.push(c); return a }), lt: na(function (a, b, c) { for (var d = 0 > c ? c + b : c; --d >= 0;)a.push(d); return a }), gt: na(function (a, b, c) { for (var d = 0 > c ? c + b : c; ++d < b;)a.push(d); return a }) } }, d.pseudos.nth = d.pseudos.eq; for (b in { radio: !0, checkbox: !0, file: !0, password: !0, image: !0 }) d.pseudos[b] = la(b); for (b in { submit: !0, reset: !0 }) d.pseudos[b] = ma(b); function pa() { } pa.prototype = d.filters = d.pseudos, d.setFilters = new pa, g = fa.tokenize = function (a, b) { var c, e, f, g, h, i, j, k = z[a + " "]; if (k) return b ? 0 : k.slice(0); h = a, i = [], j = d.preFilter; while (h) { c && !(e = R.exec(h)) || (e && (h = h.slice(e[0].length) || h), i.push(f = [])), c = !1, (e = S.exec(h)) && (c = e.shift(), f.push({ value: c, type: e[0].replace(Q, " ") }), h = h.slice(c.length)); for (g in d.filter) !(e = W[g].exec(h)) || j[g] && !(e = j[g](e)) || (c = e.shift(), f.push({ value: c, type: g, matches: e }), h = h.slice(c.length)); if (!c) break } return b ? h.length : h ? fa.error(a) : z(a, i).slice(0) }; function qa(a) { for (var b = 0, c = a.length, d = ""; c > b; b++)d += a[b].value; return d } function ra(a, b, c) { var d = b.dir, e = c && "parentNode" === d, f = x++; return b.first ? function (b, c, f) { while (b = b[d]) if (1 === b.nodeType || e) return a(b, c, f) } : function (b, c, g) { var h, i, j, k = [w, f]; if (g) { while (b = b[d]) if ((1 === b.nodeType || e) && a(b, c, g)) return !0 } else while (b = b[d]) if (1 === b.nodeType || e) { if (j = b[u] || (b[u] = {}), i = j[b.uniqueID] || (j[b.uniqueID] = {}), (h = i[d]) && h[0] === w && h[1] === f) return k[2] = h[2]; if (i[d] = k, k[2] = a(b, c, g)) return !0 } } } function sa(a) { return a.length > 1 ? function (b, c, d) { var e = a.length; while (e--) if (!a[e](b, c, d)) return !1; return !0 } : a[0] } function ta(a, b, c) { for (var d = 0, e = b.length; e > d; d++)fa(a, b[d], c); return c } function ua(a, b, c, d, e) { for (var f, g = [], h = 0, i = a.length, j = null != b; i > h; h++)(f = a[h]) && (c && !c(f, d, e) || (g.push(f), j && b.push(h))); return g } function va(a, b, c, d, e, f) { return d && !d[u] && (d = va(d)), e && !e[u] && (e = va(e, f)), ha(function (f, g, h, i) { var j, k, l, m = [], n = [], o = g.length, p = f || ta(b || "*", h.nodeType ? [h] : h, []), q = !a || !f && b ? p : ua(p, m, a, h, i), r = c ? e || (f ? a : o || d) ? [] : g : q; if (c && c(q, r, h, i), d) { j = ua(r, n), d(j, [], h, i), k = j.length; while (k--) (l = j[k]) && (r[n[k]] = !(q[n[k]] = l)) } if (f) { if (e || a) { if (e) { j = [], k = r.length; while (k--) (l = r[k]) && j.push(q[k] = l); e(null, r = [], j, i) } k = r.length; while (k--) (l = r[k]) && (j = e ? J(f, l) : m[k]) > -1 && (f[j] = !(g[j] = l)) } } else r = ua(r === g ? r.splice(o, r.length) : r), e ? e(null, g, r, i) : H.apply(g, r) }) } function wa(a) { for (var b, c, e, f = a.length, g = d.relative[a[0].type], h = g || d.relative[" "], i = g ? 1 : 0, k = ra(function (a) { return a === b }, h, !0), l = ra(function (a) { return J(b, a) > -1 }, h, !0), m = [function (a, c, d) { var e = !g && (d || c !== j) || ((b = c).nodeType ? k(a, c, d) : l(a, c, d)); return b = null, e }]; f > i; i++)if (c = d.relative[a[i].type]) m = [ra(sa(m), c)]; else { if (c = d.filter[a[i].type].apply(null, a[i].matches), c[u]) { for (e = ++i; f > e; e++)if (d.relative[a[e].type]) break; return va(i > 1 && sa(m), i > 1 && qa(a.slice(0, i - 1).concat({ value: " " === a[i - 2].type ? "*" : "" })).replace(Q, "$1"), c, e > i && wa(a.slice(i, e)), f > e && wa(a = a.slice(e)), f > e && qa(a)) } m.push(c) } return sa(m) } function xa(a, b) { var c = b.length > 0, e = a.length > 0, f = function (f, g, h, i, k) { var l, o, q, r = 0, s = "0", t = f && [], u = [], v = j, x = f || e && d.find.TAG("*", k), y = w += null == v ? 1 : Math.random() || .1, z = x.length; for (k && (j = g === n || g || k); s !== z && null != (l = x[s]); s++) { if (e && l) { o = 0, g || l.ownerDocument === n || (m(l), h = !p); while (q = a[o++]) if (q(l, g || n, h)) { i.push(l); break } k && (w = y) } c && ((l = !q && l) && r-- , f && t.push(l)) } if (r += s, c && s !== r) { o = 0; while (q = b[o++]) q(t, u, g, h); if (f) { if (r > 0) while (s--) t[s] || u[s] || (u[s] = F.call(i)); u = ua(u) } H.apply(i, u), k && !f && u.length > 0 && r + b.length > 1 && fa.uniqueSort(i) } return k && (w = y, j = v), t }; return c ? ha(f) : f } return h = fa.compile = function (a, b) { var c, d = [], e = [], f = A[a + " "]; if (!f) { b || (b = g(a)), c = b.length; while (c--) f = wa(b[c]), f[u] ? d.push(f) : e.push(f); f = A(a, xa(e, d)), f.selector = a } return f }, i = fa.select = function (a, b, e, f) { var i, j, k, l, m, n = "function" == typeof a && a, o = !f && g(a = n.selector || a); if (e = e || [], 1 === o.length) { if (j = o[0] = o[0].slice(0), j.length > 2 && "ID" === (k = j[0]).type && c.getById && 9 === b.nodeType && p && d.relative[j[1].type]) { if (b = (d.find.ID(k.matches[0].replace(ba, ca), b) || [])[0], !b) return e; n && (b = b.parentNode), a = a.slice(j.shift().value.length) } i = W.needsContext.test(a) ? 0 : j.length; while (i--) { if (k = j[i], d.relative[l = k.type]) break; if ((m = d.find[l]) && (f = m(k.matches[0].replace(ba, ca), _.test(j[0].type) && oa(b.parentNode) || b))) { if (j.splice(i, 1), a = f.length && qa(j), !a) return H.apply(e, f), e; break } } } return (n || h(a, o))(f, b, !p, e, !b || _.test(a) && oa(b.parentNode) || b), e }, c.sortStable = u.split("").sort(B).join("") === u, c.detectDuplicates = !!l, m(), c.sortDetached = ia(function (a) { return 1 & a.compareDocumentPosition(n.createElement("div")) }), ia(function (a) { return a.innerHTML = "<a href='#'></a>", "#" === a.firstChild.getAttribute("href") }) || ja("type|href|height|width", function (a, b, c) { return c ? void 0 : a.getAttribute(b, "type" === b.toLowerCase() ? 1 : 2) }), c.attributes && ia(function (a) { return a.innerHTML = "<input/>", a.firstChild.setAttribute("value", ""), "" === a.firstChild.getAttribute("value") }) || ja("value", function (a, b, c) { return c || "input" !== a.nodeName.toLowerCase() ? void 0 : a.defaultValue }), ia(function (a) { return null == a.getAttribute("disabled") }) || ja(K, function (a, b, c) { var d; return c ? void 0 : a[b] === !0 ? b.toLowerCase() : (d = a.getAttributeNode(b)) && d.specified ? d.value : null }), fa }(a); n.find = t, n.expr = t.selectors, n.expr[":"] = n.expr.pseudos, n.uniqueSort = n.unique = t.uniqueSort, n.text = t.getText, n.isXMLDoc = t.isXML, n.contains = t.contains; var u = function (a, b, c) { var d = [], e = void 0 !== c; while ((a = a[b]) && 9 !== a.nodeType) if (1 === a.nodeType) { if (e && n(a).is(c)) break; d.push(a) } return d }, v = function (a, b) { for (var c = []; a; a = a.nextSibling)1 === a.nodeType && a !== b && c.push(a); return c }, w = n.expr.match.needsContext, x = /^<([\w-]+)\s*\/?>(?:<\/\1>|)$/, y = /^.[^:#\[\.,]*$/; function z(a, b, c) { if (n.isFunction(b)) return n.grep(a, function (a, d) { return !!b.call(a, d, a) !== c }); if (b.nodeType) return n.grep(a, function (a) { return a === b !== c }); if ("string" == typeof b) { if (y.test(b)) return n.filter(b, a, c); b = n.filter(b, a) } return n.grep(a, function (a) { return n.inArray(a, b) > -1 !== c }) } n.filter = function (a, b, c) { var d = b[0]; return c && (a = ":not(" + a + ")"), 1 === b.length && 1 === d.nodeType ? n.find.matchesSelector(d, a) ? [d] : [] : n.find.matches(a, n.grep(b, function (a) { return 1 === a.nodeType })) }, n.fn.extend({ find: function (a) { var b, c = [], d = this, e = d.length; if ("string" != typeof a) return this.pushStack(n(a).filter(function () { for (b = 0; e > b; b++)if (n.contains(d[b], this)) return !0 })); for (b = 0; e > b; b++)n.find(a, d[b], c); return c = this.pushStack(e > 1 ? n.unique(c) : c), c.selector = this.selector ? this.selector + " " + a : a, c }, filter: function (a) { return this.pushStack(z(this, a || [], !1)) }, not: function (a) { return this.pushStack(z(this, a || [], !0)) }, is: function (a) { return !!z(this, "string" == typeof a && w.test(a) ? n(a) : a || [], !1).length } }); var A, B = /^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]*))$/, C = n.fn.init = function (a, b, c) { var e, f; if (!a) return this; if (c = c || A, "string" == typeof a) { if (e = "<" === a.charAt(0) && ">" === a.charAt(a.length - 1) && a.length >= 3 ? [null, a, null] : B.exec(a), !e || !e[1] && b) return !b || b.jquery ? (b || c).find(a) : this.constructor(b).find(a); if (e[1]) { if (b = b instanceof n ? b[0] : b, n.merge(this, n.parseHTML(e[1], b && b.nodeType ? b.ownerDocument || b : d, !0)), x.test(e[1]) && n.isPlainObject(b)) for (e in b) n.isFunction(this[e]) ? this[e](b[e]) : this.attr(e, b[e]); return this } if (f = d.getElementById(e[2]), f && f.parentNode) { if (f.id !== e[2]) return A.find(a); this.length = 1, this[0] = f } return this.context = d, this.selector = a, this } return a.nodeType ? (this.context = this[0] = a, this.length = 1, this) : n.isFunction(a) ? "undefined" != typeof c.ready ? c.ready(a) : a(n) : (void 0 !== a.selector && (this.selector = a.selector, this.context = a.context), n.makeArray(a, this)) }; C.prototype = n.fn, A = n(d); var D = /^(?:parents|prev(?:Until|All))/, E = { children: !0, contents: !0, next: !0, prev: !0 }; n.fn.extend({ has: function (a) { var b, c = n(a, this), d = c.length; return this.filter(function () { for (b = 0; d > b; b++)if (n.contains(this, c[b])) return !0 }) }, closest: function (a, b) { for (var c, d = 0, e = this.length, f = [], g = w.test(a) || "string" != typeof a ? n(a, b || this.context) : 0; e > d; d++)for (c = this[d]; c && c !== b; c = c.parentNode)if (c.nodeType < 11 && (g ? g.index(c) > -1 : 1 === c.nodeType && n.find.matchesSelector(c, a))) { f.push(c); break } return this.pushStack(f.length > 1 ? n.uniqueSort(f) : f) }, index: function (a) { return a ? "string" == typeof a ? n.inArray(this[0], n(a)) : n.inArray(a.jquery ? a[0] : a, this) : this[0] && this[0].parentNode ? this.first().prevAll().length : -1 }, add: function (a, b) { return this.pushStack(n.uniqueSort(n.merge(this.get(), n(a, b)))) }, addBack: function (a) { return this.add(null == a ? this.prevObject : this.prevObject.filter(a)) } }); function F(a, b) { do a = a[b]; while (a && 1 !== a.nodeType); return a } n.each({ parent: function (a) { var b = a.parentNode; return b && 11 !== b.nodeType ? b : null }, parents: function (a) { return u(a, "parentNode") }, parentsUntil: function (a, b, c) { return u(a, "parentNode", c) }, next: function (a) { return F(a, "nextSibling") }, prev: function (a) { return F(a, "previousSibling") }, nextAll: function (a) { return u(a, "nextSibling") }, prevAll: function (a) { return u(a, "previousSibling") }, nextUntil: function (a, b, c) { return u(a, "nextSibling", c) }, prevUntil: function (a, b, c) { return u(a, "previousSibling", c) }, siblings: function (a) { return v((a.parentNode || {}).firstChild, a) }, children: function (a) { return v(a.firstChild) }, contents: function (a) { return n.nodeName(a, "iframe") ? a.contentDocument || a.contentWindow.document : n.merge([], a.childNodes) } }, function (a, b) { n.fn[a] = function (c, d) { var e = n.map(this, b, c); return "Until" !== a.slice(-5) && (d = c), d && "string" == typeof d && (e = n.filter(d, e)), this.length > 1 && (E[a] || (e = n.uniqueSort(e)), D.test(a) && (e = e.reverse())), this.pushStack(e) } }); var G = /\S+/g; function H(a) { var b = {}; return n.each(a.match(G) || [], function (a, c) { b[c] = !0 }), b } n.Callbacks = function (a) { a = "string" == typeof a ? H(a) : n.extend({}, a); var b, c, d, e, f = [], g = [], h = -1, i = function () { for (e = a.once, d = b = !0; g.length; h = -1) { c = g.shift(); while (++h < f.length) f[h].apply(c[0], c[1]) === !1 && a.stopOnFalse && (h = f.length, c = !1) } a.memory || (c = !1), b = !1, e && (f = c ? [] : "") }, j = { add: function () { return f && (c && !b && (h = f.length - 1, g.push(c)), function d(b) { n.each(b, function (b, c) { n.isFunction(c) ? a.unique && j.has(c) || f.push(c) : c && c.length && "string" !== n.type(c) && d(c) }) }(arguments), c && !b && i()), this }, remove: function () { return n.each(arguments, function (a, b) { var c; while ((c = n.inArray(b, f, c)) > -1) f.splice(c, 1), h >= c && h-- }), this }, has: function (a) { return a ? n.inArray(a, f) > -1 : f.length > 0 }, empty: function () { return f && (f = []), this }, disable: function () { return e = g = [], f = c = "", this }, disabled: function () { return !f }, lock: function () { return e = !0, c || j.disable(), this }, locked: function () { return !!e }, fireWith: function (a, c) { return e || (c = c || [], c = [a, c.slice ? c.slice() : c], g.push(c), b || i()), this }, fire: function () { return j.fireWith(this, arguments), this }, fired: function () { return !!d } }; return j }, n.extend({ Deferred: function (a) { var b = [["resolve", "done", n.Callbacks("once memory"), "resolved"], ["reject", "fail", n.Callbacks("once memory"), "rejected"], ["notify", "progress", n.Callbacks("memory")]], c = "pending", d = { state: function () { return c }, always: function () { return e.done(arguments).fail(arguments), this }, then: function () { var a = arguments; return n.Deferred(function (c) { n.each(b, function (b, f) { var g = n.isFunction(a[b]) && a[b]; e[f[1]](function () { var a = g && g.apply(this, arguments); a && n.isFunction(a.promise) ? a.promise().progress(c.notify).done(c.resolve).fail(c.reject) : c[f[0] + "With"](this === d ? c.promise() : this, g ? [a] : arguments) }) }), a = null }).promise() }, promise: function (a) { return null != a ? n.extend(a, d) : d } }, e = {}; return d.pipe = d.then, n.each(b, function (a, f) { var g = f[2], h = f[3]; d[f[1]] = g.add, h && g.add(function () { c = h }, b[1 ^ a][2].disable, b[2][2].lock), e[f[0]] = function () { return e[f[0] + "With"](this === e ? d : this, arguments), this }, e[f[0] + "With"] = g.fireWith }), d.promise(e), a && a.call(e, e), e }, when: function (a) { var b = 0, c = e.call(arguments), d = c.length, f = 1 !== d || a && n.isFunction(a.promise) ? d : 0, g = 1 === f ? a : n.Deferred(), h = function (a, b, c) { return function (d) { b[a] = this, c[a] = arguments.length > 1 ? e.call(arguments) : d, c === i ? g.notifyWith(b, c) : --f || g.resolveWith(b, c) } }, i, j, k; if (d > 1) for (i = new Array(d), j = new Array(d), k = new Array(d); d > b; b++)c[b] && n.isFunction(c[b].promise) ? c[b].promise().progress(h(b, j, i)).done(h(b, k, c)).fail(g.reject) : --f; return f || g.resolveWith(k, c), g.promise() } }); var I; n.fn.ready = function (a) { return n.ready.promise().done(a), this }, n.extend({ isReady: !1, readyWait: 1, holdReady: function (a) { a ? n.readyWait++ : n.ready(!0) }, ready: function (a) { (a === !0 ? --n.readyWait : n.isReady) || (n.isReady = !0, a !== !0 && --n.readyWait > 0 || (I.resolveWith(d, [n]), n.fn.triggerHandler && (n(d).triggerHandler("ready"), n(d).off("ready")))) } }); function J() { d.addEventListener ? (d.removeEventListener("DOMContentLoaded", K), a.removeEventListener("load", K)) : (d.detachEvent("onreadystatechange", K), a.detachEvent("onload", K)) } function K() { (d.addEventListener || "load" === a.event.type || "complete" === d.readyState) && (J(), n.ready()) } n.ready.promise = function (b) { if (!I) if (I = n.Deferred(), "complete" === d.readyState || "loading" !== d.readyState && !d.documentElement.doScroll) a.setTimeout(n.ready); else if (d.addEventListener) d.addEventListener("DOMContentLoaded", K), a.addEventListener("load", K); else { d.attachEvent("onreadystatechange", K), a.attachEvent("onload", K); var c = !1; try { c = null == a.frameElement && d.documentElement } catch (e) { } c && c.doScroll && !function f() { if (!n.isReady) { try { c.doScroll("left") } catch (b) { return a.setTimeout(f, 50) } J(), n.ready() } }() } return I.promise(b) }, n.ready.promise(); var L; for (L in n(l)) break; l.ownFirst = "0" === L, l.inlineBlockNeedsLayout = !1, n(function () { var a, b, c, e; c = d.getElementsByTagName("body")[0], c && c.style && (b = d.createElement("div"), e = d.createElement("div"), e.style.cssText = "position:absolute;border:0;width:0;height:0;top:0;left:-9999px", c.appendChild(e).appendChild(b), "undefined" != typeof b.style.zoom && (b.style.cssText = "display:inline;margin:0;border:0;padding:1px;width:1px;zoom:1", l.inlineBlockNeedsLayout = a = 3 === b.offsetWidth, a && (c.style.zoom = 1)), c.removeChild(e)) }), function () { var a = d.createElement("div"); l.deleteExpando = !0; try { delete a.test } catch (b) { l.deleteExpando = !1 } a = null }(); var M = function (a) { var b = n.noData[(a.nodeName + " ").toLowerCase()], c = +a.nodeType || 1; return 1 !== c && 9 !== c ? !1 : !b || b !== !0 && a.getAttribute("classid") === b }, N = /^(?:\{[\w\W]*\}|\[[\w\W]*\])$/, O = /([A-Z])/g; function P(a, b, c) {
        if (void 0 === c && 1 === a.nodeType) {
            var d = "data-" + b.replace(O, "-$1").toLowerCase(); if (c = a.getAttribute(d), "string" == typeof c) { try { c = "true" === c ? !0 : "false" === c ? !1 : "null" === c ? null : +c + "" === c ? +c : N.test(c) ? n.parseJSON(c) : c } catch (e) { } n.data(a, b, c) } else c = void 0;
        } return c
    } function Q(a) { var b; for (b in a) if (("data" !== b || !n.isEmptyObject(a[b])) && "toJSON" !== b) return !1; return !0 } function R(a, b, d, e) { if (M(a)) { var f, g, h = n.expando, i = a.nodeType, j = i ? n.cache : a, k = i ? a[h] : a[h] && h; if (k && j[k] && (e || j[k].data) || void 0 !== d || "string" != typeof b) return k || (k = i ? a[h] = c.pop() || n.guid++ : h), j[k] || (j[k] = i ? {} : { toJSON: n.noop }), "object" != typeof b && "function" != typeof b || (e ? j[k] = n.extend(j[k], b) : j[k].data = n.extend(j[k].data, b)), g = j[k], e || (g.data || (g.data = {}), g = g.data), void 0 !== d && (g[n.camelCase(b)] = d), "string" == typeof b ? (f = g[b], null == f && (f = g[n.camelCase(b)])) : f = g, f } } function S(a, b, c) { if (M(a)) { var d, e, f = a.nodeType, g = f ? n.cache : a, h = f ? a[n.expando] : n.expando; if (g[h]) { if (b && (d = c ? g[h] : g[h].data)) { n.isArray(b) ? b = b.concat(n.map(b, n.camelCase)) : b in d ? b = [b] : (b = n.camelCase(b), b = b in d ? [b] : b.split(" ")), e = b.length; while (e--) delete d[b[e]]; if (c ? !Q(d) : !n.isEmptyObject(d)) return } (c || (delete g[h].data, Q(g[h]))) && (f ? n.cleanData([a], !0) : l.deleteExpando || g != g.window ? delete g[h] : g[h] = void 0) } } } n.extend({ cache: {}, noData: { "applet ": !0, "embed ": !0, "object ": "clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" }, hasData: function (a) { return a = a.nodeType ? n.cache[a[n.expando]] : a[n.expando], !!a && !Q(a) }, data: function (a, b, c) { return R(a, b, c) }, removeData: function (a, b) { return S(a, b) }, _data: function (a, b, c) { return R(a, b, c, !0) }, _removeData: function (a, b) { return S(a, b, !0) } }), n.fn.extend({ data: function (a, b) { var c, d, e, f = this[0], g = f && f.attributes; if (void 0 === a) { if (this.length && (e = n.data(f), 1 === f.nodeType && !n._data(f, "parsedAttrs"))) { c = g.length; while (c--) g[c] && (d = g[c].name, 0 === d.indexOf("data-") && (d = n.camelCase(d.slice(5)), P(f, d, e[d]))); n._data(f, "parsedAttrs", !0) } return e } return "object" == typeof a ? this.each(function () { n.data(this, a) }) : arguments.length > 1 ? this.each(function () { n.data(this, a, b) }) : f ? P(f, a, n.data(f, a)) : void 0 }, removeData: function (a) { return this.each(function () { n.removeData(this, a) }) } }), n.extend({ queue: function (a, b, c) { var d; return a ? (b = (b || "fx") + "queue", d = n._data(a, b), c && (!d || n.isArray(c) ? d = n._data(a, b, n.makeArray(c)) : d.push(c)), d || []) : void 0 }, dequeue: function (a, b) { b = b || "fx"; var c = n.queue(a, b), d = c.length, e = c.shift(), f = n._queueHooks(a, b), g = function () { n.dequeue(a, b) }; "inprogress" === e && (e = c.shift(), d--), e && ("fx" === b && c.unshift("inprogress"), delete f.stop, e.call(a, g, f)), !d && f && f.empty.fire() }, _queueHooks: function (a, b) { var c = b + "queueHooks"; return n._data(a, c) || n._data(a, c, { empty: n.Callbacks("once memory").add(function () { n._removeData(a, b + "queue"), n._removeData(a, c) }) }) } }), n.fn.extend({ queue: function (a, b) { var c = 2; return "string" != typeof a && (b = a, a = "fx", c--), arguments.length < c ? n.queue(this[0], a) : void 0 === b ? this : this.each(function () { var c = n.queue(this, a, b); n._queueHooks(this, a), "fx" === a && "inprogress" !== c[0] && n.dequeue(this, a) }) }, dequeue: function (a) { return this.each(function () { n.dequeue(this, a) }) }, clearQueue: function (a) { return this.queue(a || "fx", []) }, promise: function (a, b) { var c, d = 1, e = n.Deferred(), f = this, g = this.length, h = function () { --d || e.resolveWith(f, [f]) }; "string" != typeof a && (b = a, a = void 0), a = a || "fx"; while (g--) c = n._data(f[g], a + "queueHooks"), c && c.empty && (d++ , c.empty.add(h)); return h(), e.promise(b) } }), function () { var a; l.shrinkWrapBlocks = function () { if (null != a) return a; a = !1; var b, c, e; return c = d.getElementsByTagName("body")[0], c && c.style ? (b = d.createElement("div"), e = d.createElement("div"), e.style.cssText = "position:absolute;border:0;width:0;height:0;top:0;left:-9999px", c.appendChild(e).appendChild(b), "undefined" != typeof b.style.zoom && (b.style.cssText = "-webkit-box-sizing:content-box;-moz-box-sizing:content-box;box-sizing:content-box;display:block;margin:0;border:0;padding:1px;width:1px;zoom:1", b.appendChild(d.createElement("div")).style.width = "5px", a = 3 !== b.offsetWidth), c.removeChild(e), a) : void 0 } }(); var T = /[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/.source, U = new RegExp("^(?:([+-])=|)(" + T + ")([a-z%]*)$", "i"), V = ["Top", "Right", "Bottom", "Left"], W = function (a, b) { return a = b || a, "none" === n.css(a, "display") || !n.contains(a.ownerDocument, a) }; function X(a, b, c, d) { var e, f = 1, g = 20, h = d ? function () { return d.cur() } : function () { return n.css(a, b, "") }, i = h(), j = c && c[3] || (n.cssNumber[b] ? "" : "px"), k = (n.cssNumber[b] || "px" !== j && +i) && U.exec(n.css(a, b)); if (k && k[3] !== j) { j = j || k[3], c = c || [], k = +i || 1; do f = f || ".5", k /= f, n.style(a, b, k + j); while (f !== (f = h() / i) && 1 !== f && --g) } return c && (k = +k || +i || 0, e = c[1] ? k + (c[1] + 1) * c[2] : +c[2], d && (d.unit = j, d.start = k, d.end = e)), e } var Y = function (a, b, c, d, e, f, g) { var h = 0, i = a.length, j = null == c; if ("object" === n.type(c)) { e = !0; for (h in c) Y(a, b, h, c[h], !0, f, g) } else if (void 0 !== d && (e = !0, n.isFunction(d) || (g = !0), j && (g ? (b.call(a, d), b = null) : (j = b, b = function (a, b, c) { return j.call(n(a), c) })), b)) for (; i > h; h++)b(a[h], c, g ? d : d.call(a[h], h, b(a[h], c))); return e ? a : j ? b.call(a) : i ? b(a[0], c) : f }, Z = /^(?:checkbox|radio)$/i, $ = /<([\w:-]+)/, _ = /^$|\/(?:java|ecma)script/i, aa = /^\s+/, ba = "abbr|article|aside|audio|bdi|canvas|data|datalist|details|dialog|figcaption|figure|footer|header|hgroup|main|mark|meter|nav|output|picture|progress|section|summary|template|time|video"; function ca(a) { var b = ba.split("|"), c = a.createDocumentFragment(); if (c.createElement) while (b.length) c.createElement(b.pop()); return c } !function () { var a = d.createElement("div"), b = d.createDocumentFragment(), c = d.createElement("input"); a.innerHTML = "  <link/><table></table><a href='/a'>a</a><input type='checkbox'/>", l.leadingWhitespace = 3 === a.firstChild.nodeType, l.tbody = !a.getElementsByTagName("tbody").length, l.htmlSerialize = !!a.getElementsByTagName("link").length, l.html5Clone = "<:nav></:nav>" !== d.createElement("nav").cloneNode(!0).outerHTML, c.type = "checkbox", c.checked = !0, b.appendChild(c), l.appendChecked = c.checked, a.innerHTML = "<textarea>x</textarea>", l.noCloneChecked = !!a.cloneNode(!0).lastChild.defaultValue, b.appendChild(a), c = d.createElement("input"), c.setAttribute("type", "radio"), c.setAttribute("checked", "checked"), c.setAttribute("name", "t"), a.appendChild(c), l.checkClone = a.cloneNode(!0).cloneNode(!0).lastChild.checked, l.noCloneEvent = !!a.addEventListener, a[n.expando] = 1, l.attributes = !a.getAttribute(n.expando) }(); var da = { option: [1, "<select multiple='multiple'>", "</select>"], legend: [1, "<fieldset>", "</fieldset>"], area: [1, "<map>", "</map>"], param: [1, "<object>", "</object>"], thead: [1, "<table>", "</table>"], tr: [2, "<table><tbody>", "</tbody></table>"], col: [2, "<table><tbody></tbody><colgroup>", "</colgroup></table>"], td: [3, "<table><tbody><tr>", "</tr></tbody></table>"], _default: l.htmlSerialize ? [0, "", ""] : [1, "X<div>", "</div>"] }; da.optgroup = da.option, da.tbody = da.tfoot = da.colgroup = da.caption = da.thead, da.th = da.td; function ea(a, b) { var c, d, e = 0, f = "undefined" != typeof a.getElementsByTagName ? a.getElementsByTagName(b || "*") : "undefined" != typeof a.querySelectorAll ? a.querySelectorAll(b || "*") : void 0; if (!f) for (f = [], c = a.childNodes || a; null != (d = c[e]); e++)!b || n.nodeName(d, b) ? f.push(d) : n.merge(f, ea(d, b)); return void 0 === b || b && n.nodeName(a, b) ? n.merge([a], f) : f } function fa(a, b) { for (var c, d = 0; null != (c = a[d]); d++)n._data(c, "globalEval", !b || n._data(b[d], "globalEval")) } var ga = /<|&#?\w+;/, ha = /<tbody/i; function ia(a) { Z.test(a.type) && (a.defaultChecked = a.checked) } function ja(a, b, c, d, e) { for (var f, g, h, i, j, k, m, o = a.length, p = ca(b), q = [], r = 0; o > r; r++)if (g = a[r], g || 0 === g) if ("object" === n.type(g)) n.merge(q, g.nodeType ? [g] : g); else if (ga.test(g)) { i = i || p.appendChild(b.createElement("div")), j = ($.exec(g) || ["", ""])[1].toLowerCase(), m = da[j] || da._default, i.innerHTML = m[1] + n.htmlPrefilter(g) + m[2], f = m[0]; while (f--) i = i.lastChild; if (!l.leadingWhitespace && aa.test(g) && q.push(b.createTextNode(aa.exec(g)[0])), !l.tbody) { g = "table" !== j || ha.test(g) ? "<table>" !== m[1] || ha.test(g) ? 0 : i : i.firstChild, f = g && g.childNodes.length; while (f--) n.nodeName(k = g.childNodes[f], "tbody") && !k.childNodes.length && g.removeChild(k) } n.merge(q, i.childNodes), i.textContent = ""; while (i.firstChild) i.removeChild(i.firstChild); i = p.lastChild } else q.push(b.createTextNode(g)); i && p.removeChild(i), l.appendChecked || n.grep(ea(q, "input"), ia), r = 0; while (g = q[r++]) if (d && n.inArray(g, d) > -1) e && e.push(g); else if (h = n.contains(g.ownerDocument, g), i = ea(p.appendChild(g), "script"), h && fa(i), c) { f = 0; while (g = i[f++]) _.test(g.type || "") && c.push(g) } return i = null, p } !function () { var b, c, e = d.createElement("div"); for (b in { submit: !0, change: !0, focusin: !0 }) c = "on" + b, (l[b] = c in a) || (e.setAttribute(c, "t"), l[b] = e.attributes[c].expando === !1); e = null }(); var ka = /^(?:input|select|textarea)$/i, la = /^key/, ma = /^(?:mouse|pointer|contextmenu|drag|drop)|click/, na = /^(?:focusinfocus|focusoutblur)$/, oa = /^([^.]*)(?:\.(.+)|)/; function pa() { return !0 } function qa() { return !1 } function ra() { try { return d.activeElement } catch (a) { } } function sa(a, b, c, d, e, f) { var g, h; if ("object" == typeof b) { "string" != typeof c && (d = d || c, c = void 0); for (h in b) sa(a, h, c, d, b[h], f); return a } if (null == d && null == e ? (e = c, d = c = void 0) : null == e && ("string" == typeof c ? (e = d, d = void 0) : (e = d, d = c, c = void 0)), e === !1) e = qa; else if (!e) return a; return 1 === f && (g = e, e = function (a) { return n().off(a), g.apply(this, arguments) }, e.guid = g.guid || (g.guid = n.guid++)), a.each(function () { n.event.add(this, b, e, d, c) }) } n.event = { global: {}, add: function (a, b, c, d, e) { var f, g, h, i, j, k, l, m, o, p, q, r = n._data(a); if (r) { c.handler && (i = c, c = i.handler, e = i.selector), c.guid || (c.guid = n.guid++), (g = r.events) || (g = r.events = {}), (k = r.handle) || (k = r.handle = function (a) { return "undefined" == typeof n || a && n.event.triggered === a.type ? void 0 : n.event.dispatch.apply(k.elem, arguments) }, k.elem = a), b = (b || "").match(G) || [""], h = b.length; while (h--) f = oa.exec(b[h]) || [], o = q = f[1], p = (f[2] || "").split(".").sort(), o && (j = n.event.special[o] || {}, o = (e ? j.delegateType : j.bindType) || o, j = n.event.special[o] || {}, l = n.extend({ type: o, origType: q, data: d, handler: c, guid: c.guid, selector: e, needsContext: e && n.expr.match.needsContext.test(e), namespace: p.join(".") }, i), (m = g[o]) || (m = g[o] = [], m.delegateCount = 0, j.setup && j.setup.call(a, d, p, k) !== !1 || (a.addEventListener ? a.addEventListener(o, k, !1) : a.attachEvent && a.attachEvent("on" + o, k))), j.add && (j.add.call(a, l), l.handler.guid || (l.handler.guid = c.guid)), e ? m.splice(m.delegateCount++, 0, l) : m.push(l), n.event.global[o] = !0); a = null } }, remove: function (a, b, c, d, e) { var f, g, h, i, j, k, l, m, o, p, q, r = n.hasData(a) && n._data(a); if (r && (k = r.events)) { b = (b || "").match(G) || [""], j = b.length; while (j--) if (h = oa.exec(b[j]) || [], o = q = h[1], p = (h[2] || "").split(".").sort(), o) { l = n.event.special[o] || {}, o = (d ? l.delegateType : l.bindType) || o, m = k[o] || [], h = h[2] && new RegExp("(^|\\.)" + p.join("\\.(?:.*\\.|)") + "(\\.|$)"), i = f = m.length; while (f--) g = m[f], !e && q !== g.origType || c && c.guid !== g.guid || h && !h.test(g.namespace) || d && d !== g.selector && ("**" !== d || !g.selector) || (m.splice(f, 1), g.selector && m.delegateCount-- , l.remove && l.remove.call(a, g)); i && !m.length && (l.teardown && l.teardown.call(a, p, r.handle) !== !1 || n.removeEvent(a, o, r.handle), delete k[o]) } else for (o in k) n.event.remove(a, o + b[j], c, d, !0); n.isEmptyObject(k) && (delete r.handle, n._removeData(a, "events")) } }, trigger: function (b, c, e, f) { var g, h, i, j, l, m, o, p = [e || d], q = k.call(b, "type") ? b.type : b, r = k.call(b, "namespace") ? b.namespace.split(".") : []; if (i = m = e = e || d, 3 !== e.nodeType && 8 !== e.nodeType && !na.test(q + n.event.triggered) && (q.indexOf(".") > -1 && (r = q.split("."), q = r.shift(), r.sort()), h = q.indexOf(":") < 0 && "on" + q, b = b[n.expando] ? b : new n.Event(q, "object" == typeof b && b), b.isTrigger = f ? 2 : 3, b.namespace = r.join("."), b.rnamespace = b.namespace ? new RegExp("(^|\\.)" + r.join("\\.(?:.*\\.|)") + "(\\.|$)") : null, b.result = void 0, b.target || (b.target = e), c = null == c ? [b] : n.makeArray(c, [b]), l = n.event.special[q] || {}, f || !l.trigger || l.trigger.apply(e, c) !== !1)) { if (!f && !l.noBubble && !n.isWindow(e)) { for (j = l.delegateType || q, na.test(j + q) || (i = i.parentNode); i; i = i.parentNode)p.push(i), m = i; m === (e.ownerDocument || d) && p.push(m.defaultView || m.parentWindow || a) } o = 0; while ((i = p[o++]) && !b.isPropagationStopped()) b.type = o > 1 ? j : l.bindType || q, g = (n._data(i, "events") || {})[b.type] && n._data(i, "handle"), g && g.apply(i, c), g = h && i[h], g && g.apply && M(i) && (b.result = g.apply(i, c), b.result === !1 && b.preventDefault()); if (b.type = q, !f && !b.isDefaultPrevented() && (!l._default || l._default.apply(p.pop(), c) === !1) && M(e) && h && e[q] && !n.isWindow(e)) { m = e[h], m && (e[h] = null), n.event.triggered = q; try { e[q]() } catch (s) { } n.event.triggered = void 0, m && (e[h] = m) } return b.result } }, dispatch: function (a) { a = n.event.fix(a); var b, c, d, f, g, h = [], i = e.call(arguments), j = (n._data(this, "events") || {})[a.type] || [], k = n.event.special[a.type] || {}; if (i[0] = a, a.delegateTarget = this, !k.preDispatch || k.preDispatch.call(this, a) !== !1) { h = n.event.handlers.call(this, a, j), b = 0; while ((f = h[b++]) && !a.isPropagationStopped()) { a.currentTarget = f.elem, c = 0; while ((g = f.handlers[c++]) && !a.isImmediatePropagationStopped()) a.rnamespace && !a.rnamespace.test(g.namespace) || (a.handleObj = g, a.data = g.data, d = ((n.event.special[g.origType] || {}).handle || g.handler).apply(f.elem, i), void 0 !== d && (a.result = d) === !1 && (a.preventDefault(), a.stopPropagation())) } return k.postDispatch && k.postDispatch.call(this, a), a.result } }, handlers: function (a, b) { var c, d, e, f, g = [], h = b.delegateCount, i = a.target; if (h && i.nodeType && ("click" !== a.type || isNaN(a.button) || a.button < 1)) for (; i != this; i = i.parentNode || this)if (1 === i.nodeType && (i.disabled !== !0 || "click" !== a.type)) { for (d = [], c = 0; h > c; c++)f = b[c], e = f.selector + " ", void 0 === d[e] && (d[e] = f.needsContext ? n(e, this).index(i) > -1 : n.find(e, this, null, [i]).length), d[e] && d.push(f); d.length && g.push({ elem: i, handlers: d }) } return h < b.length && g.push({ elem: this, handlers: b.slice(h) }), g }, fix: function (a) { if (a[n.expando]) return a; var b, c, e, f = a.type, g = a, h = this.fixHooks[f]; h || (this.fixHooks[f] = h = ma.test(f) ? this.mouseHooks : la.test(f) ? this.keyHooks : {}), e = h.props ? this.props.concat(h.props) : this.props, a = new n.Event(g), b = e.length; while (b--) c = e[b], a[c] = g[c]; return a.target || (a.target = g.srcElement || d), 3 === a.target.nodeType && (a.target = a.target.parentNode), a.metaKey = !!a.metaKey, h.filter ? h.filter(a, g) : a }, props: "altKey bubbles cancelable ctrlKey currentTarget detail eventPhase metaKey relatedTarget shiftKey target timeStamp view which".split(" "), fixHooks: {}, keyHooks: { props: "char charCode key keyCode".split(" "), filter: function (a, b) { return null == a.which && (a.which = null != b.charCode ? b.charCode : b.keyCode), a } }, mouseHooks: { props: "button buttons clientX clientY fromElement offsetX offsetY pageX pageY screenX screenY toElement".split(" "), filter: function (a, b) { var c, e, f, g = b.button, h = b.fromElement; return null == a.pageX && null != b.clientX && (e = a.target.ownerDocument || d, f = e.documentElement, c = e.body, a.pageX = b.clientX + (f && f.scrollLeft || c && c.scrollLeft || 0) - (f && f.clientLeft || c && c.clientLeft || 0), a.pageY = b.clientY + (f && f.scrollTop || c && c.scrollTop || 0) - (f && f.clientTop || c && c.clientTop || 0)), !a.relatedTarget && h && (a.relatedTarget = h === a.target ? b.toElement : h), a.which || void 0 === g || (a.which = 1 & g ? 1 : 2 & g ? 3 : 4 & g ? 2 : 0), a } }, special: { load: { noBubble: !0 }, focus: { trigger: function () { if (this !== ra() && this.focus) try { return this.focus(), !1 } catch (a) { } }, delegateType: "focusin" }, blur: { trigger: function () { return this === ra() && this.blur ? (this.blur(), !1) : void 0 }, delegateType: "focusout" }, click: { trigger: function () { return n.nodeName(this, "input") && "checkbox" === this.type && this.click ? (this.click(), !1) : void 0 }, _default: function (a) { return n.nodeName(a.target, "a") } }, beforeunload: { postDispatch: function (a) { void 0 !== a.result && a.originalEvent && (a.originalEvent.returnValue = a.result) } } }, simulate: function (a, b, c) { var d = n.extend(new n.Event, c, { type: a, isSimulated: !0 }); n.event.trigger(d, null, b), d.isDefaultPrevented() && c.preventDefault() } }, n.removeEvent = d.removeEventListener ? function (a, b, c) { a.removeEventListener && a.removeEventListener(b, c) } : function (a, b, c) { var d = "on" + b; a.detachEvent && ("undefined" == typeof a[d] && (a[d] = null), a.detachEvent(d, c)) }, n.Event = function (a, b) { return this instanceof n.Event ? (a && a.type ? (this.originalEvent = a, this.type = a.type, this.isDefaultPrevented = a.defaultPrevented || void 0 === a.defaultPrevented && a.returnValue === !1 ? pa : qa) : this.type = a, b && n.extend(this, b), this.timeStamp = a && a.timeStamp || n.now(), void (this[n.expando] = !0)) : new n.Event(a, b) }, n.Event.prototype = { constructor: n.Event, isDefaultPrevented: qa, isPropagationStopped: qa, isImmediatePropagationStopped: qa, preventDefault: function () { var a = this.originalEvent; this.isDefaultPrevented = pa, a && (a.preventDefault ? a.preventDefault() : a.returnValue = !1) }, stopPropagation: function () { var a = this.originalEvent; this.isPropagationStopped = pa, a && !this.isSimulated && (a.stopPropagation && a.stopPropagation(), a.cancelBubble = !0) }, stopImmediatePropagation: function () { var a = this.originalEvent; this.isImmediatePropagationStopped = pa, a && a.stopImmediatePropagation && a.stopImmediatePropagation(), this.stopPropagation() } }, n.each({ mouseenter: "mouseover", mouseleave: "mouseout", pointerenter: "pointerover", pointerleave: "pointerout" }, function (a, b) { n.event.special[a] = { delegateType: b, bindType: b, handle: function (a) { var c, d = this, e = a.relatedTarget, f = a.handleObj; return e && (e === d || n.contains(d, e)) || (a.type = f.origType, c = f.handler.apply(this, arguments), a.type = b), c } } }), l.submit || (n.event.special.submit = { setup: function () { return n.nodeName(this, "form") ? !1 : void n.event.add(this, "click._submit keypress._submit", function (a) { var b = a.target, c = n.nodeName(b, "input") || n.nodeName(b, "button") ? n.prop(b, "form") : void 0; c && !n._data(c, "submit") && (n.event.add(c, "submit._submit", function (a) { a._submitBubble = !0 }), n._data(c, "submit", !0)) }) }, postDispatch: function (a) { a._submitBubble && (delete a._submitBubble, this.parentNode && !a.isTrigger && n.event.simulate("submit", this.parentNode, a)) }, teardown: function () { return n.nodeName(this, "form") ? !1 : void n.event.remove(this, "._submit") } }), l.change || (n.event.special.change = { setup: function () { return ka.test(this.nodeName) ? ("checkbox" !== this.type && "radio" !== this.type || (n.event.add(this, "propertychange._change", function (a) { "checked" === a.originalEvent.propertyName && (this._justChanged = !0) }), n.event.add(this, "click._change", function (a) { this._justChanged && !a.isTrigger && (this._justChanged = !1), n.event.simulate("change", this, a) })), !1) : void n.event.add(this, "beforeactivate._change", function (a) { var b = a.target; ka.test(b.nodeName) && !n._data(b, "change") && (n.event.add(b, "change._change", function (a) { !this.parentNode || a.isSimulated || a.isTrigger || n.event.simulate("change", this.parentNode, a) }), n._data(b, "change", !0)) }) }, handle: function (a) { var b = a.target; return this !== b || a.isSimulated || a.isTrigger || "radio" !== b.type && "checkbox" !== b.type ? a.handleObj.handler.apply(this, arguments) : void 0 }, teardown: function () { return n.event.remove(this, "._change"), !ka.test(this.nodeName) } }), l.focusin || n.each({ focus: "focusin", blur: "focusout" }, function (a, b) { var c = function (a) { n.event.simulate(b, a.target, n.event.fix(a)) }; n.event.special[b] = { setup: function () { var d = this.ownerDocument || this, e = n._data(d, b); e || d.addEventListener(a, c, !0), n._data(d, b, (e || 0) + 1) }, teardown: function () { var d = this.ownerDocument || this, e = n._data(d, b) - 1; e ? n._data(d, b, e) : (d.removeEventListener(a, c, !0), n._removeData(d, b)) } } }), n.fn.extend({ on: function (a, b, c, d) { return sa(this, a, b, c, d) }, one: function (a, b, c, d) { return sa(this, a, b, c, d, 1) }, off: function (a, b, c) { var d, e; if (a && a.preventDefault && a.handleObj) return d = a.handleObj, n(a.delegateTarget).off(d.namespace ? d.origType + "." + d.namespace : d.origType, d.selector, d.handler), this; if ("object" == typeof a) { for (e in a) this.off(e, b, a[e]); return this } return b !== !1 && "function" != typeof b || (c = b, b = void 0), c === !1 && (c = qa), this.each(function () { n.event.remove(this, a, c, b) }) }, trigger: function (a, b) { return this.each(function () { n.event.trigger(a, b, this) }) }, triggerHandler: function (a, b) { var c = this[0]; return c ? n.event.trigger(a, b, c, !0) : void 0 } }); var ta = / jQuery\d+="(?:null|\d+)"/g, ua = new RegExp("<(?:" + ba + ")[\\s/>]", "i"), va = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\w:-]+)[^>]*)\/>/gi, wa = /<script|<style|<link/i, xa = /checked\s*(?:[^=]|=\s*.checked.)/i, ya = /^true\/(.*)/, za = /^\s*<!(?:\[CDATA\[|--)|(?:\]\]|--)>\s*$/g, Aa = ca(d), Ba = Aa.appendChild(d.createElement("div")); function Ca(a, b) { return n.nodeName(a, "table") && n.nodeName(11 !== b.nodeType ? b : b.firstChild, "tr") ? a.getElementsByTagName("tbody")[0] || a.appendChild(a.ownerDocument.createElement("tbody")) : a } function Da(a) { return a.type = (null !== n.find.attr(a, "type")) + "/" + a.type, a } function Ea(a) { var b = ya.exec(a.type); return b ? a.type = b[1] : a.removeAttribute("type"), a } function Fa(a, b) { if (1 === b.nodeType && n.hasData(a)) { var c, d, e, f = n._data(a), g = n._data(b, f), h = f.events; if (h) { delete g.handle, g.events = {}; for (c in h) for (d = 0, e = h[c].length; e > d; d++)n.event.add(b, c, h[c][d]) } g.data && (g.data = n.extend({}, g.data)) } } function Ga(a, b) { var c, d, e; if (1 === b.nodeType) { if (c = b.nodeName.toLowerCase(), !l.noCloneEvent && b[n.expando]) { e = n._data(b); for (d in e.events) n.removeEvent(b, d, e.handle); b.removeAttribute(n.expando) } "script" === c && b.text !== a.text ? (Da(b).text = a.text, Ea(b)) : "object" === c ? (b.parentNode && (b.outerHTML = a.outerHTML), l.html5Clone && a.innerHTML && !n.trim(b.innerHTML) && (b.innerHTML = a.innerHTML)) : "input" === c && Z.test(a.type) ? (b.defaultChecked = b.checked = a.checked, b.value !== a.value && (b.value = a.value)) : "option" === c ? b.defaultSelected = b.selected = a.defaultSelected : "input" !== c && "textarea" !== c || (b.defaultValue = a.defaultValue) } } function Ha(a, b, c, d) { b = f.apply([], b); var e, g, h, i, j, k, m = 0, o = a.length, p = o - 1, q = b[0], r = n.isFunction(q); if (r || o > 1 && "string" == typeof q && !l.checkClone && xa.test(q)) return a.each(function (e) { var f = a.eq(e); r && (b[0] = q.call(this, e, f.html())), Ha(f, b, c, d) }); if (o && (k = ja(b, a[0].ownerDocument, !1, a, d), e = k.firstChild, 1 === k.childNodes.length && (k = e), e || d)) { for (i = n.map(ea(k, "script"), Da), h = i.length; o > m; m++)g = k, m !== p && (g = n.clone(g, !0, !0), h && n.merge(i, ea(g, "script"))), c.call(a[m], g, m); if (h) for (j = i[i.length - 1].ownerDocument, n.map(i, Ea), m = 0; h > m; m++)g = i[m], _.test(g.type || "") && !n._data(g, "globalEval") && n.contains(j, g) && (g.src ? n._evalUrl && n._evalUrl(g.src) : n.globalEval((g.text || g.textContent || g.innerHTML || "").replace(za, ""))); k = e = null } return a } function Ia(a, b, c) { for (var d, e = b ? n.filter(b, a) : a, f = 0; null != (d = e[f]); f++)c || 1 !== d.nodeType || n.cleanData(ea(d)), d.parentNode && (c && n.contains(d.ownerDocument, d) && fa(ea(d, "script")), d.parentNode.removeChild(d)); return a } n.extend({ htmlPrefilter: function (a) { return a.replace(va, "<$1></$2>") }, clone: function (a, b, c) { var d, e, f, g, h, i = n.contains(a.ownerDocument, a); if (l.html5Clone || n.isXMLDoc(a) || !ua.test("<" + a.nodeName + ">") ? f = a.cloneNode(!0) : (Ba.innerHTML = a.outerHTML, Ba.removeChild(f = Ba.firstChild)), !(l.noCloneEvent && l.noCloneChecked || 1 !== a.nodeType && 11 !== a.nodeType || n.isXMLDoc(a))) for (d = ea(f), h = ea(a), g = 0; null != (e = h[g]); ++g)d[g] && Ga(e, d[g]); if (b) if (c) for (h = h || ea(a), d = d || ea(f), g = 0; null != (e = h[g]); g++)Fa(e, d[g]); else Fa(a, f); return d = ea(f, "script"), d.length > 0 && fa(d, !i && ea(a, "script")), d = h = e = null, f }, cleanData: function (a, b) { for (var d, e, f, g, h = 0, i = n.expando, j = n.cache, k = l.attributes, m = n.event.special; null != (d = a[h]); h++)if ((b || M(d)) && (f = d[i], g = f && j[f])) { if (g.events) for (e in g.events) m[e] ? n.event.remove(d, e) : n.removeEvent(d, e, g.handle); j[f] && (delete j[f], k || "undefined" == typeof d.removeAttribute ? d[i] = void 0 : d.removeAttribute(i), c.push(f)) } } }), n.fn.extend({ domManip: Ha, detach: function (a) { return Ia(this, a, !0) }, remove: function (a) { return Ia(this, a) }, text: function (a) { return Y(this, function (a) { return void 0 === a ? n.text(this) : this.empty().append((this[0] && this[0].ownerDocument || d).createTextNode(a)) }, null, a, arguments.length) }, append: function () { return Ha(this, arguments, function (a) { if (1 === this.nodeType || 11 === this.nodeType || 9 === this.nodeType) { var b = Ca(this, a); b.appendChild(a) } }) }, prepend: function () { return Ha(this, arguments, function (a) { if (1 === this.nodeType || 11 === this.nodeType || 9 === this.nodeType) { var b = Ca(this, a); b.insertBefore(a, b.firstChild) } }) }, before: function () { return Ha(this, arguments, function (a) { this.parentNode && this.parentNode.insertBefore(a, this) }) }, after: function () { return Ha(this, arguments, function (a) { this.parentNode && this.parentNode.insertBefore(a, this.nextSibling) }) }, empty: function () { for (var a, b = 0; null != (a = this[b]); b++) { 1 === a.nodeType && n.cleanData(ea(a, !1)); while (a.firstChild) a.removeChild(a.firstChild); a.options && n.nodeName(a, "select") && (a.options.length = 0) } return this }, clone: function (a, b) { return a = null == a ? !1 : a, b = null == b ? a : b, this.map(function () { return n.clone(this, a, b) }) }, html: function (a) { return Y(this, function (a) { var b = this[0] || {}, c = 0, d = this.length; if (void 0 === a) return 1 === b.nodeType ? b.innerHTML.replace(ta, "") : void 0; if ("string" == typeof a && !wa.test(a) && (l.htmlSerialize || !ua.test(a)) && (l.leadingWhitespace || !aa.test(a)) && !da[($.exec(a) || ["", ""])[1].toLowerCase()]) { a = n.htmlPrefilter(a); try { for (; d > c; c++)b = this[c] || {}, 1 === b.nodeType && (n.cleanData(ea(b, !1)), b.innerHTML = a); b = 0 } catch (e) { } } b && this.empty().append(a) }, null, a, arguments.length) }, replaceWith: function () { var a = []; return Ha(this, arguments, function (b) { var c = this.parentNode; n.inArray(this, a) < 0 && (n.cleanData(ea(this)), c && c.replaceChild(b, this)) }, a) } }), n.each({ appendTo: "append", prependTo: "prepend", insertBefore: "before", insertAfter: "after", replaceAll: "replaceWith" }, function (a, b) { n.fn[a] = function (a) { for (var c, d = 0, e = [], f = n(a), h = f.length - 1; h >= d; d++)c = d === h ? this : this.clone(!0), n(f[d])[b](c), g.apply(e, c.get()); return this.pushStack(e) } }); var Ja, Ka = { HTML: "block", BODY: "block" }; function La(a, b) { var c = n(b.createElement(a)).appendTo(b.body), d = n.css(c[0], "display"); return c.detach(), d } function Ma(a) { var b = d, c = Ka[a]; return c || (c = La(a, b), "none" !== c && c || (Ja = (Ja || n("<iframe frameborder='0' width='0' height='0'/>")).appendTo(b.documentElement), b = (Ja[0].contentWindow || Ja[0].contentDocument).document, b.write(), b.close(), c = La(a, b), Ja.detach()), Ka[a] = c), c } var Na = /^margin/, Oa = new RegExp("^(" + T + ")(?!px)[a-z%]+$", "i"), Pa = function (a, b, c, d) { var e, f, g = {}; for (f in b) g[f] = a.style[f], a.style[f] = b[f]; e = c.apply(a, d || []); for (f in b) a.style[f] = g[f]; return e }, Qa = d.documentElement; !function () { var b, c, e, f, g, h, i = d.createElement("div"), j = d.createElement("div"); if (j.style) { j.style.cssText = "float:left;opacity:.5", l.opacity = "0.5" === j.style.opacity, l.cssFloat = !!j.style.cssFloat, j.style.backgroundClip = "content-box", j.cloneNode(!0).style.backgroundClip = "", l.clearCloneStyle = "content-box" === j.style.backgroundClip, i = d.createElement("div"), i.style.cssText = "border:0;width:8px;height:0;top:0;left:-9999px;padding:0;margin-top:1px;position:absolute", j.innerHTML = "", i.appendChild(j), l.boxSizing = "" === j.style.boxSizing || "" === j.style.MozBoxSizing || "" === j.style.WebkitBoxSizing, n.extend(l, { reliableHiddenOffsets: function () { return null == b && k(), f }, boxSizingReliable: function () { return null == b && k(), e }, pixelMarginRight: function () { return null == b && k(), c }, pixelPosition: function () { return null == b && k(), b }, reliableMarginRight: function () { return null == b && k(), g }, reliableMarginLeft: function () { return null == b && k(), h } }); function k() { var k, l, m = d.documentElement; m.appendChild(i), j.style.cssText = "-webkit-box-sizing:border-box;box-sizing:border-box;position:relative;display:block;margin:auto;border:1px;padding:1px;top:1%;width:50%", b = e = h = !1, c = g = !0, a.getComputedStyle && (l = a.getComputedStyle(j), b = "1%" !== (l || {}).top, h = "2px" === (l || {}).marginLeft, e = "4px" === (l || { width: "4px" }).width, j.style.marginRight = "50%", c = "4px" === (l || { marginRight: "4px" }).marginRight, k = j.appendChild(d.createElement("div")), k.style.cssText = j.style.cssText = "-webkit-box-sizing:content-box;-moz-box-sizing:content-box;box-sizing:content-box;display:block;margin:0;border:0;padding:0", k.style.marginRight = k.style.width = "0", j.style.width = "1px", g = !parseFloat((a.getComputedStyle(k) || {}).marginRight), j.removeChild(k)), j.style.display = "none", f = 0 === j.getClientRects().length, f && (j.style.display = "", j.innerHTML = "<table><tr><td></td><td>t</td></tr></table>", j.childNodes[0].style.borderCollapse = "separate", k = j.getElementsByTagName("td"), k[0].style.cssText = "margin:0;border:0;padding:0;display:none", f = 0 === k[0].offsetHeight, f && (k[0].style.display = "", k[1].style.display = "none", f = 0 === k[0].offsetHeight)), m.removeChild(i) } } }(); var Ra, Sa, Ta = /^(top|right|bottom|left)$/; a.getComputedStyle ? (Ra = function (b) { var c = b.ownerDocument.defaultView; return c && c.opener || (c = a), c.getComputedStyle(b) }, Sa = function (a, b, c) { var d, e, f, g, h = a.style; return c = c || Ra(a), g = c ? c.getPropertyValue(b) || c[b] : void 0, "" !== g && void 0 !== g || n.contains(a.ownerDocument, a) || (g = n.style(a, b)), c && !l.pixelMarginRight() && Oa.test(g) && Na.test(b) && (d = h.width, e = h.minWidth, f = h.maxWidth, h.minWidth = h.maxWidth = h.width = g, g = c.width, h.width = d, h.minWidth = e, h.maxWidth = f), void 0 === g ? g : g + "" }) : Qa.currentStyle && (Ra = function (a) { return a.currentStyle }, Sa = function (a, b, c) { var d, e, f, g, h = a.style; return c = c || Ra(a), g = c ? c[b] : void 0, null == g && h && h[b] && (g = h[b]), Oa.test(g) && !Ta.test(b) && (d = h.left, e = a.runtimeStyle, f = e && e.left, f && (e.left = a.currentStyle.left), h.left = "fontSize" === b ? "1em" : g, g = h.pixelLeft + "px", h.left = d, f && (e.left = f)), void 0 === g ? g : g + "" || "auto" }); function Ua(a, b) { return { get: function () { return a() ? void delete this.get : (this.get = b).apply(this, arguments) } } } var Va = /alpha\([^)]*\)/i, Wa = /opacity\s*=\s*([^)]*)/i, Xa = /^(none|table(?!-c[ea]).+)/, Ya = new RegExp("^(" + T + ")(.*)$", "i"), Za = { position: "absolute", visibility: "hidden", display: "block" }, $a = { letterSpacing: "0", fontWeight: "400" }, _a = ["Webkit", "O", "Moz", "ms"], ab = d.createElement("div").style; function bb(a) { if (a in ab) return a; var b = a.charAt(0).toUpperCase() + a.slice(1), c = _a.length; while (c--) if (a = _a[c] + b, a in ab) return a } function cb(a, b) { for (var c, d, e, f = [], g = 0, h = a.length; h > g; g++)d = a[g], d.style && (f[g] = n._data(d, "olddisplay"), c = d.style.display, b ? (f[g] || "none" !== c || (d.style.display = ""), "" === d.style.display && W(d) && (f[g] = n._data(d, "olddisplay", Ma(d.nodeName)))) : (e = W(d), (c && "none" !== c || !e) && n._data(d, "olddisplay", e ? c : n.css(d, "display")))); for (g = 0; h > g; g++)d = a[g], d.style && (b && "none" !== d.style.display && "" !== d.style.display || (d.style.display = b ? f[g] || "" : "none")); return a } function db(a, b, c) { var d = Ya.exec(b); return d ? Math.max(0, d[1] - (c || 0)) + (d[2] || "px") : b } function eb(a, b, c, d, e) { for (var f = c === (d ? "border" : "content") ? 4 : "width" === b ? 1 : 0, g = 0; 4 > f; f += 2)"margin" === c && (g += n.css(a, c + V[f], !0, e)), d ? ("content" === c && (g -= n.css(a, "padding" + V[f], !0, e)), "margin" !== c && (g -= n.css(a, "border" + V[f] + "Width", !0, e))) : (g += n.css(a, "padding" + V[f], !0, e), "padding" !== c && (g += n.css(a, "border" + V[f] + "Width", !0, e))); return g } function fb(a, b, c) { var d = !0, e = "width" === b ? a.offsetWidth : a.offsetHeight, f = Ra(a), g = l.boxSizing && "border-box" === n.css(a, "boxSizing", !1, f); if (0 >= e || null == e) { if (e = Sa(a, b, f), (0 > e || null == e) && (e = a.style[b]), Oa.test(e)) return e; d = g && (l.boxSizingReliable() || e === a.style[b]), e = parseFloat(e) || 0 } return e + eb(a, b, c || (g ? "border" : "content"), d, f) + "px" } n.extend({ cssHooks: { opacity: { get: function (a, b) { if (b) { var c = Sa(a, "opacity"); return "" === c ? "1" : c } } } }, cssNumber: { animationIterationCount: !0, columnCount: !0, fillOpacity: !0, flexGrow: !0, flexShrink: !0, fontWeight: !0, lineHeight: !0, opacity: !0, order: !0, orphans: !0, widows: !0, zIndex: !0, zoom: !0 }, cssProps: { "float": l.cssFloat ? "cssFloat" : "styleFloat" }, style: function (a, b, c, d) { if (a && 3 !== a.nodeType && 8 !== a.nodeType && a.style) { var e, f, g, h = n.camelCase(b), i = a.style; if (b = n.cssProps[h] || (n.cssProps[h] = bb(h) || h), g = n.cssHooks[b] || n.cssHooks[h], void 0 === c) return g && "get" in g && void 0 !== (e = g.get(a, !1, d)) ? e : i[b]; if (f = typeof c, "string" === f && (e = U.exec(c)) && e[1] && (c = X(a, b, e), f = "number"), null != c && c === c && ("number" === f && (c += e && e[3] || (n.cssNumber[h] ? "" : "px")), l.clearCloneStyle || "" !== c || 0 !== b.indexOf("background") || (i[b] = "inherit"), !(g && "set" in g && void 0 === (c = g.set(a, c, d))))) try { i[b] = c } catch (j) { } } }, css: function (a, b, c, d) { var e, f, g, h = n.camelCase(b); return b = n.cssProps[h] || (n.cssProps[h] = bb(h) || h), g = n.cssHooks[b] || n.cssHooks[h], g && "get" in g && (f = g.get(a, !0, c)), void 0 === f && (f = Sa(a, b, d)), "normal" === f && b in $a && (f = $a[b]), "" === c || c ? (e = parseFloat(f), c === !0 || isFinite(e) ? e || 0 : f) : f } }), n.each(["height", "width"], function (a, b) { n.cssHooks[b] = { get: function (a, c, d) { return c ? Xa.test(n.css(a, "display")) && 0 === a.offsetWidth ? Pa(a, Za, function () { return fb(a, b, d) }) : fb(a, b, d) : void 0 }, set: function (a, c, d) { var e = d && Ra(a); return db(a, c, d ? eb(a, b, d, l.boxSizing && "border-box" === n.css(a, "boxSizing", !1, e), e) : 0) } } }), l.opacity || (n.cssHooks.opacity = { get: function (a, b) { return Wa.test((b && a.currentStyle ? a.currentStyle.filter : a.style.filter) || "") ? .01 * parseFloat(RegExp.$1) + "" : b ? "1" : "" }, set: function (a, b) { var c = a.style, d = a.currentStyle, e = n.isNumeric(b) ? "alpha(opacity=" + 100 * b + ")" : "", f = d && d.filter || c.filter || ""; c.zoom = 1, (b >= 1 || "" === b) && "" === n.trim(f.replace(Va, "")) && c.removeAttribute && (c.removeAttribute("filter"), "" === b || d && !d.filter) || (c.filter = Va.test(f) ? f.replace(Va, e) : f + " " + e) } }), n.cssHooks.marginRight = Ua(l.reliableMarginRight, function (a, b) { return b ? Pa(a, { display: "inline-block" }, Sa, [a, "marginRight"]) : void 0 }), n.cssHooks.marginLeft = Ua(l.reliableMarginLeft, function (a, b) {
        return b ? (parseFloat(Sa(a, "marginLeft")) || (n.contains(a.ownerDocument, a) ? a.getBoundingClientRect().left - Pa(a, {
            marginLeft: 0
        }, function () { return a.getBoundingClientRect().left }) : 0)) + "px" : void 0
    }), n.each({ margin: "", padding: "", border: "Width" }, function (a, b) { n.cssHooks[a + b] = { expand: function (c) { for (var d = 0, e = {}, f = "string" == typeof c ? c.split(" ") : [c]; 4 > d; d++)e[a + V[d] + b] = f[d] || f[d - 2] || f[0]; return e } }, Na.test(a) || (n.cssHooks[a + b].set = db) }), n.fn.extend({ css: function (a, b) { return Y(this, function (a, b, c) { var d, e, f = {}, g = 0; if (n.isArray(b)) { for (d = Ra(a), e = b.length; e > g; g++)f[b[g]] = n.css(a, b[g], !1, d); return f } return void 0 !== c ? n.style(a, b, c) : n.css(a, b) }, a, b, arguments.length > 1) }, show: function () { return cb(this, !0) }, hide: function () { return cb(this) }, toggle: function (a) { return "boolean" == typeof a ? a ? this.show() : this.hide() : this.each(function () { W(this) ? n(this).show() : n(this).hide() }) } }); function gb(a, b, c, d, e) { return new gb.prototype.init(a, b, c, d, e) } n.Tween = gb, gb.prototype = { constructor: gb, init: function (a, b, c, d, e, f) { this.elem = a, this.prop = c, this.easing = e || n.easing._default, this.options = b, this.start = this.now = this.cur(), this.end = d, this.unit = f || (n.cssNumber[c] ? "" : "px") }, cur: function () { var a = gb.propHooks[this.prop]; return a && a.get ? a.get(this) : gb.propHooks._default.get(this) }, run: function (a) { var b, c = gb.propHooks[this.prop]; return this.options.duration ? this.pos = b = n.easing[this.easing](a, this.options.duration * a, 0, 1, this.options.duration) : this.pos = b = a, this.now = (this.end - this.start) * b + this.start, this.options.step && this.options.step.call(this.elem, this.now, this), c && c.set ? c.set(this) : gb.propHooks._default.set(this), this } }, gb.prototype.init.prototype = gb.prototype, gb.propHooks = { _default: { get: function (a) { var b; return 1 !== a.elem.nodeType || null != a.elem[a.prop] && null == a.elem.style[a.prop] ? a.elem[a.prop] : (b = n.css(a.elem, a.prop, ""), b && "auto" !== b ? b : 0) }, set: function (a) { n.fx.step[a.prop] ? n.fx.step[a.prop](a) : 1 !== a.elem.nodeType || null == a.elem.style[n.cssProps[a.prop]] && !n.cssHooks[a.prop] ? a.elem[a.prop] = a.now : n.style(a.elem, a.prop, a.now + a.unit) } } }, gb.propHooks.scrollTop = gb.propHooks.scrollLeft = { set: function (a) { a.elem.nodeType && a.elem.parentNode && (a.elem[a.prop] = a.now) } }, n.easing = { linear: function (a) { return a }, swing: function (a) { return .5 - Math.cos(a * Math.PI) / 2 }, _default: "swing" }, n.fx = gb.prototype.init, n.fx.step = {}; var hb, ib, jb = /^(?:toggle|show|hide)$/, kb = /queueHooks$/; function lb() { return a.setTimeout(function () { hb = void 0 }), hb = n.now() } function mb(a, b) { var c, d = { height: a }, e = 0; for (b = b ? 1 : 0; 4 > e; e += 2 - b)c = V[e], d["margin" + c] = d["padding" + c] = a; return b && (d.opacity = d.width = a), d } function nb(a, b, c) { for (var d, e = (qb.tweeners[b] || []).concat(qb.tweeners["*"]), f = 0, g = e.length; g > f; f++)if (d = e[f].call(c, b, a)) return d } function ob(a, b, c) { var d, e, f, g, h, i, j, k, m = this, o = {}, p = a.style, q = a.nodeType && W(a), r = n._data(a, "fxshow"); c.queue || (h = n._queueHooks(a, "fx"), null == h.unqueued && (h.unqueued = 0, i = h.empty.fire, h.empty.fire = function () { h.unqueued || i() }), h.unqueued++ , m.always(function () { m.always(function () { h.unqueued-- , n.queue(a, "fx").length || h.empty.fire() }) })), 1 === a.nodeType && ("height" in b || "width" in b) && (c.overflow = [p.overflow, p.overflowX, p.overflowY], j = n.css(a, "display"), k = "none" === j ? n._data(a, "olddisplay") || Ma(a.nodeName) : j, "inline" === k && "none" === n.css(a, "float") && (l.inlineBlockNeedsLayout && "inline" !== Ma(a.nodeName) ? p.zoom = 1 : p.display = "inline-block")), c.overflow && (p.overflow = "hidden", l.shrinkWrapBlocks() || m.always(function () { p.overflow = c.overflow[0], p.overflowX = c.overflow[1], p.overflowY = c.overflow[2] })); for (d in b) if (e = b[d], jb.exec(e)) { if (delete b[d], f = f || "toggle" === e, e === (q ? "hide" : "show")) { if ("show" !== e || !r || void 0 === r[d]) continue; q = !0 } o[d] = r && r[d] || n.style(a, d) } else j = void 0; if (n.isEmptyObject(o)) "inline" === ("none" === j ? Ma(a.nodeName) : j) && (p.display = j); else { r ? "hidden" in r && (q = r.hidden) : r = n._data(a, "fxshow", {}), f && (r.hidden = !q), q ? n(a).show() : m.done(function () { n(a).hide() }), m.done(function () { var b; n._removeData(a, "fxshow"); for (b in o) n.style(a, b, o[b]) }); for (d in o) g = nb(q ? r[d] : 0, d, m), d in r || (r[d] = g.start, q && (g.end = g.start, g.start = "width" === d || "height" === d ? 1 : 0)) } } function pb(a, b) { var c, d, e, f, g; for (c in a) if (d = n.camelCase(c), e = b[d], f = a[c], n.isArray(f) && (e = f[1], f = a[c] = f[0]), c !== d && (a[d] = f, delete a[c]), g = n.cssHooks[d], g && "expand" in g) { f = g.expand(f), delete a[d]; for (c in f) c in a || (a[c] = f[c], b[c] = e) } else b[d] = e } function qb(a, b, c) { var d, e, f = 0, g = qb.prefilters.length, h = n.Deferred().always(function () { delete i.elem }), i = function () { if (e) return !1; for (var b = hb || lb(), c = Math.max(0, j.startTime + j.duration - b), d = c / j.duration || 0, f = 1 - d, g = 0, i = j.tweens.length; i > g; g++)j.tweens[g].run(f); return h.notifyWith(a, [j, f, c]), 1 > f && i ? c : (h.resolveWith(a, [j]), !1) }, j = h.promise({ elem: a, props: n.extend({}, b), opts: n.extend(!0, { specialEasing: {}, easing: n.easing._default }, c), originalProperties: b, originalOptions: c, startTime: hb || lb(), duration: c.duration, tweens: [], createTween: function (b, c) { var d = n.Tween(a, j.opts, b, c, j.opts.specialEasing[b] || j.opts.easing); return j.tweens.push(d), d }, stop: function (b) { var c = 0, d = b ? j.tweens.length : 0; if (e) return this; for (e = !0; d > c; c++)j.tweens[c].run(1); return b ? (h.notifyWith(a, [j, 1, 0]), h.resolveWith(a, [j, b])) : h.rejectWith(a, [j, b]), this } }), k = j.props; for (pb(k, j.opts.specialEasing); g > f; f++)if (d = qb.prefilters[f].call(j, a, k, j.opts)) return n.isFunction(d.stop) && (n._queueHooks(j.elem, j.opts.queue).stop = n.proxy(d.stop, d)), d; return n.map(k, nb, j), n.isFunction(j.opts.start) && j.opts.start.call(a, j), n.fx.timer(n.extend(i, { elem: a, anim: j, queue: j.opts.queue })), j.progress(j.opts.progress).done(j.opts.done, j.opts.complete).fail(j.opts.fail).always(j.opts.always) } n.Animation = n.extend(qb, { tweeners: { "*": [function (a, b) { var c = this.createTween(a, b); return X(c.elem, a, U.exec(b), c), c }] }, tweener: function (a, b) { n.isFunction(a) ? (b = a, a = ["*"]) : a = a.match(G); for (var c, d = 0, e = a.length; e > d; d++)c = a[d], qb.tweeners[c] = qb.tweeners[c] || [], qb.tweeners[c].unshift(b) }, prefilters: [ob], prefilter: function (a, b) { b ? qb.prefilters.unshift(a) : qb.prefilters.push(a) } }), n.speed = function (a, b, c) { var d = a && "object" == typeof a ? n.extend({}, a) : { complete: c || !c && b || n.isFunction(a) && a, duration: a, easing: c && b || b && !n.isFunction(b) && b }; return d.duration = n.fx.off ? 0 : "number" == typeof d.duration ? d.duration : d.duration in n.fx.speeds ? n.fx.speeds[d.duration] : n.fx.speeds._default, null != d.queue && d.queue !== !0 || (d.queue = "fx"), d.old = d.complete, d.complete = function () { n.isFunction(d.old) && d.old.call(this), d.queue && n.dequeue(this, d.queue) }, d }, n.fn.extend({ fadeTo: function (a, b, c, d) { return this.filter(W).css("opacity", 0).show().end().animate({ opacity: b }, a, c, d) }, animate: function (a, b, c, d) { var e = n.isEmptyObject(a), f = n.speed(b, c, d), g = function () { var b = qb(this, n.extend({}, a), f); (e || n._data(this, "finish")) && b.stop(!0) }; return g.finish = g, e || f.queue === !1 ? this.each(g) : this.queue(f.queue, g) }, stop: function (a, b, c) { var d = function (a) { var b = a.stop; delete a.stop, b(c) }; return "string" != typeof a && (c = b, b = a, a = void 0), b && a !== !1 && this.queue(a || "fx", []), this.each(function () { var b = !0, e = null != a && a + "queueHooks", f = n.timers, g = n._data(this); if (e) g[e] && g[e].stop && d(g[e]); else for (e in g) g[e] && g[e].stop && kb.test(e) && d(g[e]); for (e = f.length; e--;)f[e].elem !== this || null != a && f[e].queue !== a || (f[e].anim.stop(c), b = !1, f.splice(e, 1)); !b && c || n.dequeue(this, a) }) }, finish: function (a) { return a !== !1 && (a = a || "fx"), this.each(function () { var b, c = n._data(this), d = c[a + "queue"], e = c[a + "queueHooks"], f = n.timers, g = d ? d.length : 0; for (c.finish = !0, n.queue(this, a, []), e && e.stop && e.stop.call(this, !0), b = f.length; b--;)f[b].elem === this && f[b].queue === a && (f[b].anim.stop(!0), f.splice(b, 1)); for (b = 0; g > b; b++)d[b] && d[b].finish && d[b].finish.call(this); delete c.finish }) } }), n.each(["toggle", "show", "hide"], function (a, b) { var c = n.fn[b]; n.fn[b] = function (a, d, e) { return null == a || "boolean" == typeof a ? c.apply(this, arguments) : this.animate(mb(b, !0), a, d, e) } }), n.each({ slideDown: mb("show"), slideUp: mb("hide"), slideToggle: mb("toggle"), fadeIn: { opacity: "show" }, fadeOut: { opacity: "hide" }, fadeToggle: { opacity: "toggle" } }, function (a, b) { n.fn[a] = function (a, c, d) { return this.animate(b, a, c, d) } }), n.timers = [], n.fx.tick = function () { var a, b = n.timers, c = 0; for (hb = n.now(); c < b.length; c++)a = b[c], a() || b[c] !== a || b.splice(c--, 1); b.length || n.fx.stop(), hb = void 0 }, n.fx.timer = function (a) { n.timers.push(a), a() ? n.fx.start() : n.timers.pop() }, n.fx.interval = 13, n.fx.start = function () { ib || (ib = a.setInterval(n.fx.tick, n.fx.interval)) }, n.fx.stop = function () { a.clearInterval(ib), ib = null }, n.fx.speeds = { slow: 600, fast: 200, _default: 400 }, n.fn.delay = function (b, c) { return b = n.fx ? n.fx.speeds[b] || b : b, c = c || "fx", this.queue(c, function (c, d) { var e = a.setTimeout(c, b); d.stop = function () { a.clearTimeout(e) } }) }, function () { var a, b = d.createElement("input"), c = d.createElement("div"), e = d.createElement("select"), f = e.appendChild(d.createElement("option")); c = d.createElement("div"), c.setAttribute("className", "t"), c.innerHTML = "  <link/><table></table><a href='/a'>a</a><input type='checkbox'/>", a = c.getElementsByTagName("a")[0], b.setAttribute("type", "checkbox"), c.appendChild(b), a = c.getElementsByTagName("a")[0], a.style.cssText = "top:1px", l.getSetAttribute = "t" !== c.className, l.style = /top/.test(a.getAttribute("style")), l.hrefNormalized = "/a" === a.getAttribute("href"), l.checkOn = !!b.value, l.optSelected = f.selected, l.enctype = !!d.createElement("form").enctype, e.disabled = !0, l.optDisabled = !f.disabled, b = d.createElement("input"), b.setAttribute("value", ""), l.input = "" === b.getAttribute("value"), b.value = "t", b.setAttribute("type", "radio"), l.radioValue = "t" === b.value }(); var rb = /\r/g, sb = /[\x20\t\r\n\f]+/g; n.fn.extend({ val: function (a) { var b, c, d, e = this[0]; { if (arguments.length) return d = n.isFunction(a), this.each(function (c) { var e; 1 === this.nodeType && (e = d ? a.call(this, c, n(this).val()) : a, null == e ? e = "" : "number" == typeof e ? e += "" : n.isArray(e) && (e = n.map(e, function (a) { return null == a ? "" : a + "" })), b = n.valHooks[this.type] || n.valHooks[this.nodeName.toLowerCase()], b && "set" in b && void 0 !== b.set(this, e, "value") || (this.value = e)) }); if (e) return b = n.valHooks[e.type] || n.valHooks[e.nodeName.toLowerCase()], b && "get" in b && void 0 !== (c = b.get(e, "value")) ? c : (c = e.value, "string" == typeof c ? c.replace(rb, "") : null == c ? "" : c) } } }), n.extend({ valHooks: { option: { get: function (a) { var b = n.find.attr(a, "value"); return null != b ? b : n.trim(n.text(a)).replace(sb, " ") } }, select: { get: function (a) { for (var b, c, d = a.options, e = a.selectedIndex, f = "select-one" === a.type || 0 > e, g = f ? null : [], h = f ? e + 1 : d.length, i = 0 > e ? h : f ? e : 0; h > i; i++)if (c = d[i], (c.selected || i === e) && (l.optDisabled ? !c.disabled : null === c.getAttribute("disabled")) && (!c.parentNode.disabled || !n.nodeName(c.parentNode, "optgroup"))) { if (b = n(c).val(), f) return b; g.push(b) } return g }, set: function (a, b) { var c, d, e = a.options, f = n.makeArray(b), g = e.length; while (g--) if (d = e[g], n.inArray(n.valHooks.option.get(d), f) > -1) try { d.selected = c = !0 } catch (h) { d.scrollHeight } else d.selected = !1; return c || (a.selectedIndex = -1), e } } } }), n.each(["radio", "checkbox"], function () { n.valHooks[this] = { set: function (a, b) { return n.isArray(b) ? a.checked = n.inArray(n(a).val(), b) > -1 : void 0 } }, l.checkOn || (n.valHooks[this].get = function (a) { return null === a.getAttribute("value") ? "on" : a.value }) }); var tb, ub, vb = n.expr.attrHandle, wb = /^(?:checked|selected)$/i, xb = l.getSetAttribute, yb = l.input; n.fn.extend({ attr: function (a, b) { return Y(this, n.attr, a, b, arguments.length > 1) }, removeAttr: function (a) { return this.each(function () { n.removeAttr(this, a) }) } }), n.extend({ attr: function (a, b, c) { var d, e, f = a.nodeType; if (3 !== f && 8 !== f && 2 !== f) return "undefined" == typeof a.getAttribute ? n.prop(a, b, c) : (1 === f && n.isXMLDoc(a) || (b = b.toLowerCase(), e = n.attrHooks[b] || (n.expr.match.bool.test(b) ? ub : tb)), void 0 !== c ? null === c ? void n.removeAttr(a, b) : e && "set" in e && void 0 !== (d = e.set(a, c, b)) ? d : (a.setAttribute(b, c + ""), c) : e && "get" in e && null !== (d = e.get(a, b)) ? d : (d = n.find.attr(a, b), null == d ? void 0 : d)) }, attrHooks: { type: { set: function (a, b) { if (!l.radioValue && "radio" === b && n.nodeName(a, "input")) { var c = a.value; return a.setAttribute("type", b), c && (a.value = c), b } } } }, removeAttr: function (a, b) { var c, d, e = 0, f = b && b.match(G); if (f && 1 === a.nodeType) while (c = f[e++]) d = n.propFix[c] || c, n.expr.match.bool.test(c) ? yb && xb || !wb.test(c) ? a[d] = !1 : a[n.camelCase("default-" + c)] = a[d] = !1 : n.attr(a, c, ""), a.removeAttribute(xb ? c : d) } }), ub = { set: function (a, b, c) { return b === !1 ? n.removeAttr(a, c) : yb && xb || !wb.test(c) ? a.setAttribute(!xb && n.propFix[c] || c, c) : a[n.camelCase("default-" + c)] = a[c] = !0, c } }, n.each(n.expr.match.bool.source.match(/\w+/g), function (a, b) { var c = vb[b] || n.find.attr; yb && xb || !wb.test(b) ? vb[b] = function (a, b, d) { var e, f; return d || (f = vb[b], vb[b] = e, e = null != c(a, b, d) ? b.toLowerCase() : null, vb[b] = f), e } : vb[b] = function (a, b, c) { return c ? void 0 : a[n.camelCase("default-" + b)] ? b.toLowerCase() : null } }), yb && xb || (n.attrHooks.value = { set: function (a, b, c) { return n.nodeName(a, "input") ? void (a.defaultValue = b) : tb && tb.set(a, b, c) } }), xb || (tb = { set: function (a, b, c) { var d = a.getAttributeNode(c); return d || a.setAttributeNode(d = a.ownerDocument.createAttribute(c)), d.value = b += "", "value" === c || b === a.getAttribute(c) ? b : void 0 } }, vb.id = vb.name = vb.coords = function (a, b, c) { var d; return c ? void 0 : (d = a.getAttributeNode(b)) && "" !== d.value ? d.value : null }, n.valHooks.button = { get: function (a, b) { var c = a.getAttributeNode(b); return c && c.specified ? c.value : void 0 }, set: tb.set }, n.attrHooks.contenteditable = { set: function (a, b, c) { tb.set(a, "" === b ? !1 : b, c) } }, n.each(["width", "height"], function (a, b) { n.attrHooks[b] = { set: function (a, c) { return "" === c ? (a.setAttribute(b, "auto"), c) : void 0 } } })), l.style || (n.attrHooks.style = { get: function (a) { return a.style.cssText || void 0 }, set: function (a, b) { return a.style.cssText = b + "" } }); var zb = /^(?:input|select|textarea|button|object)$/i, Ab = /^(?:a|area)$/i; n.fn.extend({ prop: function (a, b) { return Y(this, n.prop, a, b, arguments.length > 1) }, removeProp: function (a) { return a = n.propFix[a] || a, this.each(function () { try { this[a] = void 0, delete this[a] } catch (b) { } }) } }), n.extend({ prop: function (a, b, c) { var d, e, f = a.nodeType; if (3 !== f && 8 !== f && 2 !== f) return 1 === f && n.isXMLDoc(a) || (b = n.propFix[b] || b, e = n.propHooks[b]), void 0 !== c ? e && "set" in e && void 0 !== (d = e.set(a, c, b)) ? d : a[b] = c : e && "get" in e && null !== (d = e.get(a, b)) ? d : a[b] }, propHooks: { tabIndex: { get: function (a) { var b = n.find.attr(a, "tabindex"); return b ? parseInt(b, 10) : zb.test(a.nodeName) || Ab.test(a.nodeName) && a.href ? 0 : -1 } } }, propFix: { "for": "htmlFor", "class": "className" } }), l.hrefNormalized || n.each(["href", "src"], function (a, b) { n.propHooks[b] = { get: function (a) { return a.getAttribute(b, 4) } } }), l.optSelected || (n.propHooks.selected = { get: function (a) { var b = a.parentNode; return b && (b.selectedIndex, b.parentNode && b.parentNode.selectedIndex), null }, set: function (a) { var b = a.parentNode; b && (b.selectedIndex, b.parentNode && b.parentNode.selectedIndex) } }), n.each(["tabIndex", "readOnly", "maxLength", "cellSpacing", "cellPadding", "rowSpan", "colSpan", "useMap", "frameBorder", "contentEditable"], function () { n.propFix[this.toLowerCase()] = this }), l.enctype || (n.propFix.enctype = "encoding"); var Bb = /[\t\r\n\f]/g; function Cb(a) { return n.attr(a, "class") || "" } n.fn.extend({ addClass: function (a) { var b, c, d, e, f, g, h, i = 0; if (n.isFunction(a)) return this.each(function (b) { n(this).addClass(a.call(this, b, Cb(this))) }); if ("string" == typeof a && a) { b = a.match(G) || []; while (c = this[i++]) if (e = Cb(c), d = 1 === c.nodeType && (" " + e + " ").replace(Bb, " ")) { g = 0; while (f = b[g++]) d.indexOf(" " + f + " ") < 0 && (d += f + " "); h = n.trim(d), e !== h && n.attr(c, "class", h) } } return this }, removeClass: function (a) { var b, c, d, e, f, g, h, i = 0; if (n.isFunction(a)) return this.each(function (b) { n(this).removeClass(a.call(this, b, Cb(this))) }); if (!arguments.length) return this.attr("class", ""); if ("string" == typeof a && a) { b = a.match(G) || []; while (c = this[i++]) if (e = Cb(c), d = 1 === c.nodeType && (" " + e + " ").replace(Bb, " ")) { g = 0; while (f = b[g++]) while (d.indexOf(" " + f + " ") > -1) d = d.replace(" " + f + " ", " "); h = n.trim(d), e !== h && n.attr(c, "class", h) } } return this }, toggleClass: function (a, b) { var c = typeof a; return "boolean" == typeof b && "string" === c ? b ? this.addClass(a) : this.removeClass(a) : n.isFunction(a) ? this.each(function (c) { n(this).toggleClass(a.call(this, c, Cb(this), b), b) }) : this.each(function () { var b, d, e, f; if ("string" === c) { d = 0, e = n(this), f = a.match(G) || []; while (b = f[d++]) e.hasClass(b) ? e.removeClass(b) : e.addClass(b) } else void 0 !== a && "boolean" !== c || (b = Cb(this), b && n._data(this, "__className__", b), n.attr(this, "class", b || a === !1 ? "" : n._data(this, "__className__") || "")) }) }, hasClass: function (a) { var b, c, d = 0; b = " " + a + " "; while (c = this[d++]) if (1 === c.nodeType && (" " + Cb(c) + " ").replace(Bb, " ").indexOf(b) > -1) return !0; return !1 } }), n.each("blur focus focusin focusout load resize scroll unload click dblclick mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave change select submit keydown keypress keyup error contextmenu".split(" "), function (a, b) { n.fn[b] = function (a, c) { return arguments.length > 0 ? this.on(b, null, a, c) : this.trigger(b) } }), n.fn.extend({ hover: function (a, b) { return this.mouseenter(a).mouseleave(b || a) } }); var Db = a.location, Eb = n.now(), Fb = /\?/, Gb = /(,)|(\[|{)|(}|])|"(?:[^"\\\r\n]|\\["\\\/bfnrt]|\\u[\da-fA-F]{4})*"\s*:?|true|false|null|-?(?!0\d)\d+(?:\.\d+|)(?:[eE][+-]?\d+|)/g; n.parseJSON = function (b) { if (a.JSON && a.JSON.parse) return a.JSON.parse(b + ""); var c, d = null, e = n.trim(b + ""); return e && !n.trim(e.replace(Gb, function (a, b, e, f) { return c && b && (d = 0), 0 === d ? a : (c = e || b, d += !f - !e, "") })) ? Function("return " + e)() : n.error("Invalid JSON: " + b) }, n.parseXML = function (b) { var c, d; if (!b || "string" != typeof b) return null; try { a.DOMParser ? (d = new a.DOMParser, c = d.parseFromString(b, "text/xml")) : (c = new a.ActiveXObject("Microsoft.XMLDOM"), c.async = "false", c.loadXML(b)) } catch (e) { c = void 0 } return c && c.documentElement && !c.getElementsByTagName("parsererror").length || n.error("Invalid XML: " + b), c }; var Hb = /#.*$/, Ib = /([?&])_=[^&]*/, Jb = /^(.*?):[ \t]*([^\r\n]*)\r?$/gm, Kb = /^(?:about|app|app-storage|.+-extension|file|res|widget):$/, Lb = /^(?:GET|HEAD)$/, Mb = /^\/\//, Nb = /^([\w.+-]+:)(?:\/\/(?:[^\/?#]*@|)([^\/?#:]*)(?::(\d+)|)|)/, Ob = {}, Pb = {}, Qb = "*/".concat("*"), Rb = Db.href, Sb = Nb.exec(Rb.toLowerCase()) || []; function Tb(a) { return function (b, c) { "string" != typeof b && (c = b, b = "*"); var d, e = 0, f = b.toLowerCase().match(G) || []; if (n.isFunction(c)) while (d = f[e++]) "+" === d.charAt(0) ? (d = d.slice(1) || "*", (a[d] = a[d] || []).unshift(c)) : (a[d] = a[d] || []).push(c) } } function Ub(a, b, c, d) { var e = {}, f = a === Pb; function g(h) { var i; return e[h] = !0, n.each(a[h] || [], function (a, h) { var j = h(b, c, d); return "string" != typeof j || f || e[j] ? f ? !(i = j) : void 0 : (b.dataTypes.unshift(j), g(j), !1) }), i } return g(b.dataTypes[0]) || !e["*"] && g("*") } function Vb(a, b) { var c, d, e = n.ajaxSettings.flatOptions || {}; for (d in b) void 0 !== b[d] && ((e[d] ? a : c || (c = {}))[d] = b[d]); return c && n.extend(!0, a, c), a } function Wb(a, b, c) { var d, e, f, g, h = a.contents, i = a.dataTypes; while ("*" === i[0]) i.shift(), void 0 === e && (e = a.mimeType || b.getResponseHeader("Content-Type")); if (e) for (g in h) if (h[g] && h[g].test(e)) { i.unshift(g); break } if (i[0] in c) f = i[0]; else { for (g in c) { if (!i[0] || a.converters[g + " " + i[0]]) { f = g; break } d || (d = g) } f = f || d } return f ? (f !== i[0] && i.unshift(f), c[f]) : void 0 } function Xb(a, b, c, d) { var e, f, g, h, i, j = {}, k = a.dataTypes.slice(); if (k[1]) for (g in a.converters) j[g.toLowerCase()] = a.converters[g]; f = k.shift(); while (f) if (a.responseFields[f] && (c[a.responseFields[f]] = b), !i && d && a.dataFilter && (b = a.dataFilter(b, a.dataType)), i = f, f = k.shift()) if ("*" === f) f = i; else if ("*" !== i && i !== f) { if (g = j[i + " " + f] || j["* " + f], !g) for (e in j) if (h = e.split(" "), h[1] === f && (g = j[i + " " + h[0]] || j["* " + h[0]])) { g === !0 ? g = j[e] : j[e] !== !0 && (f = h[0], k.unshift(h[1])); break } if (g !== !0) if (g && a["throws"]) b = g(b); else try { b = g(b) } catch (l) { return { state: "parsererror", error: g ? l : "No conversion from " + i + " to " + f } } } return { state: "success", data: b } } n.extend({ active: 0, lastModified: {}, etag: {}, ajaxSettings: { url: Rb, type: "GET", isLocal: Kb.test(Sb[1]), global: !0, processData: !0, async: !0, contentType: "application/x-www-form-urlencoded; charset=UTF-8", accepts: { "*": Qb, text: "text/plain", html: "text/html", xml: "application/xml, text/xml", json: "application/json, text/javascript" }, contents: { xml: /\bxml\b/, html: /\bhtml/, json: /\bjson\b/ }, responseFields: { xml: "responseXML", text: "responseText", json: "responseJSON" }, converters: { "* text": String, "text html": !0, "text json": n.parseJSON, "text xml": n.parseXML }, flatOptions: { url: !0, context: !0 } }, ajaxSetup: function (a, b) { return b ? Vb(Vb(a, n.ajaxSettings), b) : Vb(n.ajaxSettings, a) }, ajaxPrefilter: Tb(Ob), ajaxTransport: Tb(Pb), ajax: function (b, c) { "object" == typeof b && (c = b, b = void 0), c = c || {}; var d, e, f, g, h, i, j, k, l = n.ajaxSetup({}, c), m = l.context || l, o = l.context && (m.nodeType || m.jquery) ? n(m) : n.event, p = n.Deferred(), q = n.Callbacks("once memory"), r = l.statusCode || {}, s = {}, t = {}, u = 0, v = "canceled", w = { readyState: 0, getResponseHeader: function (a) { var b; if (2 === u) { if (!k) { k = {}; while (b = Jb.exec(g)) k[b[1].toLowerCase()] = b[2] } b = k[a.toLowerCase()] } return null == b ? null : b }, getAllResponseHeaders: function () { return 2 === u ? g : null }, setRequestHeader: function (a, b) { var c = a.toLowerCase(); return u || (a = t[c] = t[c] || a, s[a] = b), this }, overrideMimeType: function (a) { return u || (l.mimeType = a), this }, statusCode: function (a) { var b; if (a) if (2 > u) for (b in a) r[b] = [r[b], a[b]]; else w.always(a[w.status]); return this }, abort: function (a) { var b = a || v; return j && j.abort(b), y(0, b), this } }; if (p.promise(w).complete = q.add, w.success = w.done, w.error = w.fail, l.url = ((b || l.url || Rb) + "").replace(Hb, "").replace(Mb, Sb[1] + "//"), l.type = c.method || c.type || l.method || l.type, l.dataTypes = n.trim(l.dataType || "*").toLowerCase().match(G) || [""], null == l.crossDomain && (d = Nb.exec(l.url.toLowerCase()), l.crossDomain = !(!d || d[1] === Sb[1] && d[2] === Sb[2] && (d[3] || ("http:" === d[1] ? "80" : "443")) === (Sb[3] || ("http:" === Sb[1] ? "80" : "443")))), l.data && l.processData && "string" != typeof l.data && (l.data = n.param(l.data, l.traditional)), Ub(Ob, l, c, w), 2 === u) return w; i = n.event && l.global, i && 0 === n.active++ && n.event.trigger("ajaxStart"), l.type = l.type.toUpperCase(), l.hasContent = !Lb.test(l.type), f = l.url, l.hasContent || (l.data && (f = l.url += (Fb.test(f) ? "&" : "?") + l.data, delete l.data), l.cache === !1 && (l.url = Ib.test(f) ? f.replace(Ib, "$1_=" + Eb++) : f + (Fb.test(f) ? "&" : "?") + "_=" + Eb++)), l.ifModified && (n.lastModified[f] && w.setRequestHeader("If-Modified-Since", n.lastModified[f]), n.etag[f] && w.setRequestHeader("If-None-Match", n.etag[f])), (l.data && l.hasContent && l.contentType !== !1 || c.contentType) && w.setRequestHeader("Content-Type", l.contentType), w.setRequestHeader("Accept", l.dataTypes[0] && l.accepts[l.dataTypes[0]] ? l.accepts[l.dataTypes[0]] + ("*" !== l.dataTypes[0] ? ", " + Qb + "; q=0.01" : "") : l.accepts["*"]); for (e in l.headers) w.setRequestHeader(e, l.headers[e]); if (l.beforeSend && (l.beforeSend.call(m, w, l) === !1 || 2 === u)) return w.abort(); v = "abort"; for (e in { success: 1, error: 1, complete: 1 }) w[e](l[e]); if (j = Ub(Pb, l, c, w)) { if (w.readyState = 1, i && o.trigger("ajaxSend", [w, l]), 2 === u) return w; l.async && l.timeout > 0 && (h = a.setTimeout(function () { w.abort("timeout") }, l.timeout)); try { u = 1, j.send(s, y) } catch (x) { if (!(2 > u)) throw x; y(-1, x) } } else y(-1, "No Transport"); function y(b, c, d, e) { var k, s, t, v, x, y = c; 2 !== u && (u = 2, h && a.clearTimeout(h), j = void 0, g = e || "", w.readyState = b > 0 ? 4 : 0, k = b >= 200 && 300 > b || 304 === b, d && (v = Wb(l, w, d)), v = Xb(l, v, w, k), k ? (l.ifModified && (x = w.getResponseHeader("Last-Modified"), x && (n.lastModified[f] = x), x = w.getResponseHeader("etag"), x && (n.etag[f] = x)), 204 === b || "HEAD" === l.type ? y = "nocontent" : 304 === b ? y = "notmodified" : (y = v.state, s = v.data, t = v.error, k = !t)) : (t = y, !b && y || (y = "error", 0 > b && (b = 0))), w.status = b, w.statusText = (c || y) + "", k ? p.resolveWith(m, [s, y, w]) : p.rejectWith(m, [w, y, t]), w.statusCode(r), r = void 0, i && o.trigger(k ? "ajaxSuccess" : "ajaxError", [w, l, k ? s : t]), q.fireWith(m, [w, y]), i && (o.trigger("ajaxComplete", [w, l]), --n.active || n.event.trigger("ajaxStop"))) } return w }, getJSON: function (a, b, c) { return n.get(a, b, c, "json") }, getScript: function (a, b) { return n.get(a, void 0, b, "script") } }), n.each(["get", "post"], function (a, b) { n[b] = function (a, c, d, e) { return n.isFunction(c) && (e = e || d, d = c, c = void 0), n.ajax(n.extend({ url: a, type: b, dataType: e, data: c, success: d }, n.isPlainObject(a) && a)) } }), n._evalUrl = function (a) { return n.ajax({ url: a, type: "GET", dataType: "script", cache: !0, async: !1, global: !1, "throws": !0 }) }, n.fn.extend({ wrapAll: function (a) { if (n.isFunction(a)) return this.each(function (b) { n(this).wrapAll(a.call(this, b)) }); if (this[0]) { var b = n(a, this[0].ownerDocument).eq(0).clone(!0); this[0].parentNode && b.insertBefore(this[0]), b.map(function () { var a = this; while (a.firstChild && 1 === a.firstChild.nodeType) a = a.firstChild; return a }).append(this) } return this }, wrapInner: function (a) { return n.isFunction(a) ? this.each(function (b) { n(this).wrapInner(a.call(this, b)) }) : this.each(function () { var b = n(this), c = b.contents(); c.length ? c.wrapAll(a) : b.append(a) }) }, wrap: function (a) { var b = n.isFunction(a); return this.each(function (c) { n(this).wrapAll(b ? a.call(this, c) : a) }) }, unwrap: function () { return this.parent().each(function () { n.nodeName(this, "body") || n(this).replaceWith(this.childNodes) }).end() } }); function Yb(a) { return a.style && a.style.display || n.css(a, "display") } function Zb(a) { if (!n.contains(a.ownerDocument || d, a)) return !0; while (a && 1 === a.nodeType) { if ("none" === Yb(a) || "hidden" === a.type) return !0; a = a.parentNode } return !1 } n.expr.filters.hidden = function (a) { return l.reliableHiddenOffsets() ? a.offsetWidth <= 0 && a.offsetHeight <= 0 && !a.getClientRects().length : Zb(a) }, n.expr.filters.visible = function (a) { return !n.expr.filters.hidden(a) }; var $b = /%20/g, _b = /\[\]$/, ac = /\r?\n/g, bc = /^(?:submit|button|image|reset|file)$/i, cc = /^(?:input|select|textarea|keygen)/i; function dc(a, b, c, d) { var e; if (n.isArray(b)) n.each(b, function (b, e) { c || _b.test(a) ? d(a, e) : dc(a + "[" + ("object" == typeof e && null != e ? b : "") + "]", e, c, d) }); else if (c || "object" !== n.type(b)) d(a, b); else for (e in b) dc(a + "[" + e + "]", b[e], c, d) } n.param = function (a, b) { var c, d = [], e = function (a, b) { b = n.isFunction(b) ? b() : null == b ? "" : b, d[d.length] = encodeURIComponent(a) + "=" + encodeURIComponent(b) }; if (void 0 === b && (b = n.ajaxSettings && n.ajaxSettings.traditional), n.isArray(a) || a.jquery && !n.isPlainObject(a)) n.each(a, function () { e(this.name, this.value) }); else for (c in a) dc(c, a[c], b, e); return d.join("&").replace($b, "+") }, n.fn.extend({ serialize: function () { return n.param(this.serializeArray()) }, serializeArray: function () { return this.map(function () { var a = n.prop(this, "elements"); return a ? n.makeArray(a) : this }).filter(function () { var a = this.type; return this.name && !n(this).is(":disabled") && cc.test(this.nodeName) && !bc.test(a) && (this.checked || !Z.test(a)) }).map(function (a, b) { var c = n(this).val(); return null == c ? null : n.isArray(c) ? n.map(c, function (a) { return { name: b.name, value: a.replace(ac, "\r\n") } }) : { name: b.name, value: c.replace(ac, "\r\n") } }).get() } }), n.ajaxSettings.xhr = void 0 !== a.ActiveXObject ? function () { return this.isLocal ? ic() : d.documentMode > 8 ? hc() : /^(get|post|head|put|delete|options)$/i.test(this.type) && hc() || ic() } : hc; var ec = 0, fc = {}, gc = n.ajaxSettings.xhr(); a.attachEvent && a.attachEvent("onunload", function () { for (var a in fc) fc[a](void 0, !0) }), l.cors = !!gc && "withCredentials" in gc, gc = l.ajax = !!gc, gc && n.ajaxTransport(function (b) { if (!b.crossDomain || l.cors) { var c; return { send: function (d, e) { var f, g = b.xhr(), h = ++ec; if (g.open(b.type, b.url, b.async, b.username, b.password), b.xhrFields) for (f in b.xhrFields) g[f] = b.xhrFields[f]; b.mimeType && g.overrideMimeType && g.overrideMimeType(b.mimeType), b.crossDomain || d["X-Requested-With"] || (d["X-Requested-With"] = "XMLHttpRequest"); for (f in d) void 0 !== d[f] && g.setRequestHeader(f, d[f] + ""); g.send(b.hasContent && b.data || null), c = function (a, d) { var f, i, j; if (c && (d || 4 === g.readyState)) if (delete fc[h], c = void 0, g.onreadystatechange = n.noop, d) 4 !== g.readyState && g.abort(); else { j = {}, f = g.status, "string" == typeof g.responseText && (j.text = g.responseText); try { i = g.statusText } catch (k) { i = "" } f || !b.isLocal || b.crossDomain ? 1223 === f && (f = 204) : f = j.text ? 200 : 404 } j && e(f, i, j, g.getAllResponseHeaders()) }, b.async ? 4 === g.readyState ? a.setTimeout(c) : g.onreadystatechange = fc[h] = c : c() }, abort: function () { c && c(void 0, !0) } } } }); function hc() { try { return new a.XMLHttpRequest } catch (b) { } } function ic() { try { return new a.ActiveXObject("Microsoft.XMLHTTP") } catch (b) { } } n.ajaxSetup({ accepts: { script: "text/javascript, application/javascript, application/ecmascript, application/x-ecmascript" }, contents: { script: /\b(?:java|ecma)script\b/ }, converters: { "text script": function (a) { return n.globalEval(a), a } } }), n.ajaxPrefilter("script", function (a) { void 0 === a.cache && (a.cache = !1), a.crossDomain && (a.type = "GET", a.global = !1) }), n.ajaxTransport("script", function (a) { if (a.crossDomain) { var b, c = d.head || n("head")[0] || d.documentElement; return { send: function (e, f) { b = d.createElement("script"), b.async = !0, a.scriptCharset && (b.charset = a.scriptCharset), b.src = a.url, b.onload = b.onreadystatechange = function (a, c) { (c || !b.readyState || /loaded|complete/.test(b.readyState)) && (b.onload = b.onreadystatechange = null, b.parentNode && b.parentNode.removeChild(b), b = null, c || f(200, "success")) }, c.insertBefore(b, c.firstChild) }, abort: function () { b && b.onload(void 0, !0) } } } }); var jc = [], kc = /(=)\?(?=&|$)|\?\?/; n.ajaxSetup({ jsonp: "callback", jsonpCallback: function () { var a = jc.pop() || n.expando + "_" + Eb++; return this[a] = !0, a } }), n.ajaxPrefilter("json jsonp", function (b, c, d) { var e, f, g, h = b.jsonp !== !1 && (kc.test(b.url) ? "url" : "string" == typeof b.data && 0 === (b.contentType || "").indexOf("application/x-www-form-urlencoded") && kc.test(b.data) && "data"); return h || "jsonp" === b.dataTypes[0] ? (e = b.jsonpCallback = n.isFunction(b.jsonpCallback) ? b.jsonpCallback() : b.jsonpCallback, h ? b[h] = b[h].replace(kc, "$1" + e) : b.jsonp !== !1 && (b.url += (Fb.test(b.url) ? "&" : "?") + b.jsonp + "=" + e), b.converters["script json"] = function () { return g || n.error(e + " was not called"), g[0] }, b.dataTypes[0] = "json", f = a[e], a[e] = function () { g = arguments }, d.always(function () { void 0 === f ? n(a).removeProp(e) : a[e] = f, b[e] && (b.jsonpCallback = c.jsonpCallback, jc.push(e)), g && n.isFunction(f) && f(g[0]), g = f = void 0 }), "script") : void 0 }), n.parseHTML = function (a, b, c) { if (!a || "string" != typeof a) return null; "boolean" == typeof b && (c = b, b = !1), b = b || d; var e = x.exec(a), f = !c && []; return e ? [b.createElement(e[1])] : (e = ja([a], b, f), f && f.length && n(f).remove(), n.merge([], e.childNodes)) }; var lc = n.fn.load; n.fn.load = function (a, b, c) { if ("string" != typeof a && lc) return lc.apply(this, arguments); var d, e, f, g = this, h = a.indexOf(" "); return h > -1 && (d = n.trim(a.slice(h, a.length)), a = a.slice(0, h)), n.isFunction(b) ? (c = b, b = void 0) : b && "object" == typeof b && (e = "POST"), g.length > 0 && n.ajax({ url: a, type: e || "GET", dataType: "html", data: b }).done(function (a) { f = arguments, g.html(d ? n("<div>").append(n.parseHTML(a)).find(d) : a) }).always(c && function (a, b) { g.each(function () { c.apply(this, f || [a.responseText, b, a]) }) }), this }, n.each(["ajaxStart", "ajaxStop", "ajaxComplete", "ajaxError", "ajaxSuccess", "ajaxSend"], function (a, b) { n.fn[b] = function (a) { return this.on(b, a) } }), n.expr.filters.animated = function (a) { return n.grep(n.timers, function (b) { return a === b.elem }).length }; function mc(a) { return n.isWindow(a) ? a : 9 === a.nodeType ? a.defaultView || a.parentWindow : !1 } n.offset = { setOffset: function (a, b, c) { var d, e, f, g, h, i, j, k = n.css(a, "position"), l = n(a), m = {}; "static" === k && (a.style.position = "relative"), h = l.offset(), f = n.css(a, "top"), i = n.css(a, "left"), j = ("absolute" === k || "fixed" === k) && n.inArray("auto", [f, i]) > -1, j ? (d = l.position(), g = d.top, e = d.left) : (g = parseFloat(f) || 0, e = parseFloat(i) || 0), n.isFunction(b) && (b = b.call(a, c, n.extend({}, h))), null != b.top && (m.top = b.top - h.top + g), null != b.left && (m.left = b.left - h.left + e), "using" in b ? b.using.call(a, m) : l.css(m) } }, n.fn.extend({ offset: function (a) { if (arguments.length) return void 0 === a ? this : this.each(function (b) { n.offset.setOffset(this, a, b) }); var b, c, d = { top: 0, left: 0 }, e = this[0], f = e && e.ownerDocument; if (f) return b = f.documentElement, n.contains(b, e) ? ("undefined" != typeof e.getBoundingClientRect && (d = e.getBoundingClientRect()), c = mc(f), { top: d.top + (c.pageYOffset || b.scrollTop) - (b.clientTop || 0), left: d.left + (c.pageXOffset || b.scrollLeft) - (b.clientLeft || 0) }) : d }, position: function () { if (this[0]) { var a, b, c = { top: 0, left: 0 }, d = this[0]; return "fixed" === n.css(d, "position") ? b = d.getBoundingClientRect() : (a = this.offsetParent(), b = this.offset(), n.nodeName(a[0], "html") || (c = a.offset()), c.top += n.css(a[0], "borderTopWidth", !0), c.left += n.css(a[0], "borderLeftWidth", !0)), { top: b.top - c.top - n.css(d, "marginTop", !0), left: b.left - c.left - n.css(d, "marginLeft", !0) } } }, offsetParent: function () { return this.map(function () { var a = this.offsetParent; while (a && !n.nodeName(a, "html") && "static" === n.css(a, "position")) a = a.offsetParent; return a || Qa }) } }), n.each({ scrollLeft: "pageXOffset", scrollTop: "pageYOffset" }, function (a, b) { var c = /Y/.test(b); n.fn[a] = function (d) { return Y(this, function (a, d, e) { var f = mc(a); return void 0 === e ? f ? b in f ? f[b] : f.document.documentElement[d] : a[d] : void (f ? f.scrollTo(c ? n(f).scrollLeft() : e, c ? e : n(f).scrollTop()) : a[d] = e) }, a, d, arguments.length, null) } }), n.each(["top", "left"], function (a, b) { n.cssHooks[b] = Ua(l.pixelPosition, function (a, c) { return c ? (c = Sa(a, b), Oa.test(c) ? n(a).position()[b] + "px" : c) : void 0 }) }), n.each({ Height: "height", Width: "width" }, function (a, b) {
        n.each({
            padding: "inner" + a, content: b, "": "outer" + a
        }, function (c, d) { n.fn[d] = function (d, e) { var f = arguments.length && (c || "boolean" != typeof d), g = c || (d === !0 || e === !0 ? "margin" : "border"); return Y(this, function (b, c, d) { var e; return n.isWindow(b) ? b.document.documentElement["client" + a] : 9 === b.nodeType ? (e = b.documentElement, Math.max(b.body["scroll" + a], e["scroll" + a], b.body["offset" + a], e["offset" + a], e["client" + a])) : void 0 === d ? n.css(b, c, g) : n.style(b, c, d, g) }, b, f ? d : void 0, f, null) } })
    }), n.fn.extend({ bind: function (a, b, c) { return this.on(a, null, b, c) }, unbind: function (a, b) { return this.off(a, null, b) }, delegate: function (a, b, c, d) { return this.on(b, a, c, d) }, undelegate: function (a, b, c) { return 1 === arguments.length ? this.off(a, "**") : this.off(b, a || "**", c) } }), n.fn.size = function () { return this.length }, n.fn.andSelf = n.fn.addBack, "function" == typeof define && define.amd && define("jquery", [], function () { return n }); var nc = a.jQuery, oc = a.$; return n.noConflict = function (b) { return a.$ === n && (a.$ = oc), b && a.jQuery === n && (a.jQuery = nc), n }, b || (a.jQuery = a.$ = n), n
});


/*! jQuery UI - v1.10.4 - 2014-01-17
* http://jqueryui.com
* Copyright 2014 jQuery Foundation and other contributors; Licensed MIT */
(function (e, t) { function i(t, i) { var a, n, r, o = t.nodeName.toLowerCase(); return "area" === o ? (a = t.parentNode, n = a.name, t.href && n && "map" === a.nodeName.toLowerCase() ? (r = e("img[usemap=#" + n + "]")[0], !!r && s(r)) : !1) : (/input|select|textarea|button|object/.test(o) ? !t.disabled : "a" === o ? t.href || i : i) && s(t) } function s(t) { return e.expr.filters.visible(t) && !e(t).parents().addBack().filter(function () { return "hidden" === e.css(this, "visibility") }).length } var a = 0, n = /^ui-id-\d+$/; e.ui = e.ui || {}, e.extend(e.ui, { version: "1.10.4", keyCode: { BACKSPACE: 8, COMMA: 188, DELETE: 46, DOWN: 40, END: 35, ENTER: 13, ESCAPE: 27, HOME: 36, LEFT: 37, NUMPAD_ADD: 107, NUMPAD_DECIMAL: 110, NUMPAD_DIVIDE: 111, NUMPAD_ENTER: 108, NUMPAD_MULTIPLY: 106, NUMPAD_SUBTRACT: 109, PAGE_DOWN: 34, PAGE_UP: 33, PERIOD: 190, RIGHT: 39, SPACE: 32, TAB: 9, UP: 38 } }), e.fn.extend({ focus: function (t) { return function (i, s) { return "number" == typeof i ? this.each(function () { var t = this; setTimeout(function () { e(t).focus(), s && s.call(t) }, i) }) : t.apply(this, arguments) } }(e.fn.focus), scrollParent: function () { var t; return t = e.ui.ie && /(static|relative)/.test(this.css("position")) || /absolute/.test(this.css("position")) ? this.parents().filter(function () { return /(relative|absolute|fixed)/.test(e.css(this, "position")) && /(auto|scroll)/.test(e.css(this, "overflow") + e.css(this, "overflow-y") + e.css(this, "overflow-x")) }).eq(0) : this.parents().filter(function () { return /(auto|scroll)/.test(e.css(this, "overflow") + e.css(this, "overflow-y") + e.css(this, "overflow-x")) }).eq(0), /fixed/.test(this.css("position")) || !t.length ? e(document) : t }, zIndex: function (i) { if (i !== t) return this.css("zIndex", i); if (this.length) for (var s, a, n = e(this[0]); n.length && n[0] !== document;) { if (s = n.css("position"), ("absolute" === s || "relative" === s || "fixed" === s) && (a = parseInt(n.css("zIndex"), 10), !isNaN(a) && 0 !== a)) return a; n = n.parent() } return 0 }, uniqueId: function () { return this.each(function () { this.id || (this.id = "ui-id-" + ++a) }) }, removeUniqueId: function () { return this.each(function () { n.test(this.id) && e(this).removeAttr("id") }) } }), e.extend(e.expr[":"], { data: e.expr.createPseudo ? e.expr.createPseudo(function (t) { return function (i) { return !!e.data(i, t) } }) : function (t, i, s) { return !!e.data(t, s[3]) }, focusable: function (t) { return i(t, !isNaN(e.attr(t, "tabindex"))) }, tabbable: function (t) { var s = e.attr(t, "tabindex"), a = isNaN(s); return (a || s >= 0) && i(t, !a) } }), e("<a>").outerWidth(1).jquery || e.each(["Width", "Height"], function (i, s) { function a(t, i, s, a) { return e.each(n, function () { i -= parseFloat(e.css(t, "padding" + this)) || 0, s && (i -= parseFloat(e.css(t, "border" + this + "Width")) || 0), a && (i -= parseFloat(e.css(t, "margin" + this)) || 0) }), i } var n = "Width" === s ? ["Left", "Right"] : ["Top", "Bottom"], r = s.toLowerCase(), o = { innerWidth: e.fn.innerWidth, innerHeight: e.fn.innerHeight, outerWidth: e.fn.outerWidth, outerHeight: e.fn.outerHeight }; e.fn["inner" + s] = function (i) { return i === t ? o["inner" + s].call(this) : this.each(function () { e(this).css(r, a(this, i) + "px") }) }, e.fn["outer" + s] = function (t, i) { return "number" != typeof t ? o["outer" + s].call(this, t) : this.each(function () { e(this).css(r, a(this, t, !0, i) + "px") }) } }), e.fn.addBack || (e.fn.addBack = function (e) { return this.add(null == e ? this.prevObject : this.prevObject.filter(e)) }), e("<a>").data("a-b", "a").removeData("a-b").data("a-b") && (e.fn.removeData = function (t) { return function (i) { return arguments.length ? t.call(this, e.camelCase(i)) : t.call(this) } }(e.fn.removeData)), e.ui.ie = !!/msie [\w.]+/.exec(navigator.userAgent.toLowerCase()), e.support.selectstart = "onselectstart" in document.createElement("div"), e.fn.extend({ disableSelection: function () { return this.bind((e.support.selectstart ? "selectstart" : "mousedown") + ".ui-disableSelection", function (e) { e.preventDefault() }) }, enableSelection: function () { return this.unbind(".ui-disableSelection") } }), e.extend(e.ui, { plugin: { add: function (t, i, s) { var a, n = e.ui[t].prototype; for (a in s) n.plugins[a] = n.plugins[a] || [], n.plugins[a].push([i, s[a]]) }, call: function (e, t, i) { var s, a = e.plugins[t]; if (a && e.element[0].parentNode && 11 !== e.element[0].parentNode.nodeType) for (s = 0; a.length > s; s++)e.options[a[s][0]] && a[s][1].apply(e.element, i) } }, hasScroll: function (t, i) { if ("hidden" === e(t).css("overflow")) return !1; var s = i && "left" === i ? "scrollLeft" : "scrollTop", a = !1; return t[s] > 0 ? !0 : (t[s] = 1, a = t[s] > 0, t[s] = 0, a) } }) })(jQuery);

/*! jQuery UI - v1.10.4 - 2014-01-17
* http://jqueryui.com
* Copyright 2014 jQuery Foundation and other contributors; Licensed MIT */
(function (e, t) { var i = 0, s = Array.prototype.slice, n = e.cleanData; e.cleanData = function (t) { for (var i, s = 0; null != (i = t[s]); s++)try { e(i).triggerHandler("remove") } catch (a) { } n(t) }, e.widget = function (i, s, n) { var a, r, o, h, l = {}, u = i.split(".")[0]; i = i.split(".")[1], a = u + "-" + i, n || (n = s, s = e.Widget), e.expr[":"][a.toLowerCase()] = function (t) { return !!e.data(t, a) }, e[u] = e[u] || {}, r = e[u][i], o = e[u][i] = function (e, i) { return this._createWidget ? (arguments.length && this._createWidget(e, i), t) : new o(e, i) }, e.extend(o, r, { version: n.version, _proto: e.extend({}, n), _childConstructors: [] }), h = new s, h.options = e.widget.extend({}, h.options), e.each(n, function (i, n) { return e.isFunction(n) ? (l[i] = function () { var e = function () { return s.prototype[i].apply(this, arguments) }, t = function (e) { return s.prototype[i].apply(this, e) }; return function () { var i, s = this._super, a = this._superApply; return this._super = e, this._superApply = t, i = n.apply(this, arguments), this._super = s, this._superApply = a, i } }(), t) : (l[i] = n, t) }), o.prototype = e.widget.extend(h, { widgetEventPrefix: r ? h.widgetEventPrefix || i : i }, l, { constructor: o, namespace: u, widgetName: i, widgetFullName: a }), r ? (e.each(r._childConstructors, function (t, i) { var s = i.prototype; e.widget(s.namespace + "." + s.widgetName, o, i._proto) }), delete r._childConstructors) : s._childConstructors.push(o), e.widget.bridge(i, o) }, e.widget.extend = function (i) { for (var n, a, r = s.call(arguments, 1), o = 0, h = r.length; h > o; o++)for (n in r[o]) a = r[o][n], r[o].hasOwnProperty(n) && a !== t && (i[n] = e.isPlainObject(a) ? e.isPlainObject(i[n]) ? e.widget.extend({}, i[n], a) : e.widget.extend({}, a) : a); return i }, e.widget.bridge = function (i, n) { var a = n.prototype.widgetFullName || i; e.fn[i] = function (r) { var o = "string" == typeof r, h = s.call(arguments, 1), l = this; return r = !o && h.length ? e.widget.extend.apply(null, [r].concat(h)) : r, o ? this.each(function () { var s, n = e.data(this, a); return n ? e.isFunction(n[r]) && "_" !== r.charAt(0) ? (s = n[r].apply(n, h), s !== n && s !== t ? (l = s && s.jquery ? l.pushStack(s.get()) : s, !1) : t) : e.error("no such method '" + r + "' for " + i + " widget instance") : e.error("cannot call methods on " + i + " prior to initialization; " + "attempted to call method '" + r + "'") }) : this.each(function () { var t = e.data(this, a); t ? t.option(r || {})._init() : e.data(this, a, new n(r, this)) }), l } }, e.Widget = function () { }, e.Widget._childConstructors = [], e.Widget.prototype = { widgetName: "widget", widgetEventPrefix: "", defaultElement: "<div>", options: { disabled: !1, create: null }, _createWidget: function (t, s) { s = e(s || this.defaultElement || this)[0], this.element = e(s), this.uuid = i++ , this.eventNamespace = "." + this.widgetName + this.uuid, this.options = e.widget.extend({}, this.options, this._getCreateOptions(), t), this.bindings = e(), this.hoverable = e(), this.focusable = e(), s !== this && (e.data(s, this.widgetFullName, this), this._on(!0, this.element, { remove: function (e) { e.target === s && this.destroy() } }), this.document = e(s.style ? s.ownerDocument : s.document || s), this.window = e(this.document[0].defaultView || this.document[0].parentWindow)), this._create(), this._trigger("create", null, this._getCreateEventData()), this._init() }, _getCreateOptions: e.noop, _getCreateEventData: e.noop, _create: e.noop, _init: e.noop, destroy: function () { this._destroy(), this.element.unbind(this.eventNamespace).removeData(this.widgetName).removeData(this.widgetFullName).removeData(e.camelCase(this.widgetFullName)), this.widget().unbind(this.eventNamespace).removeAttr("aria-disabled").removeClass(this.widgetFullName + "-disabled " + "ui-state-disabled"), this.bindings.unbind(this.eventNamespace), this.hoverable.removeClass("ui-state-hover"), this.focusable.removeClass("ui-state-focus") }, _destroy: e.noop, widget: function () { return this.element }, option: function (i, s) { var n, a, r, o = i; if (0 === arguments.length) return e.widget.extend({}, this.options); if ("string" == typeof i) if (o = {}, n = i.split("."), i = n.shift(), n.length) { for (a = o[i] = e.widget.extend({}, this.options[i]), r = 0; n.length - 1 > r; r++)a[n[r]] = a[n[r]] || {}, a = a[n[r]]; if (i = n.pop(), 1 === arguments.length) return a[i] === t ? null : a[i]; a[i] = s } else { if (1 === arguments.length) return this.options[i] === t ? null : this.options[i]; o[i] = s } return this._setOptions(o), this }, _setOptions: function (e) { var t; for (t in e) this._setOption(t, e[t]); return this }, _setOption: function (e, t) { return this.options[e] = t, "disabled" === e && (this.widget().toggleClass(this.widgetFullName + "-disabled ui-state-disabled", !!t).attr("aria-disabled", t), this.hoverable.removeClass("ui-state-hover"), this.focusable.removeClass("ui-state-focus")), this }, enable: function () { return this._setOption("disabled", !1) }, disable: function () { return this._setOption("disabled", !0) }, _on: function (i, s, n) { var a, r = this; "boolean" != typeof i && (n = s, s = i, i = !1), n ? (s = a = e(s), this.bindings = this.bindings.add(s)) : (n = s, s = this.element, a = this.widget()), e.each(n, function (n, o) { function h() { return i || r.options.disabled !== !0 && !e(this).hasClass("ui-state-disabled") ? ("string" == typeof o ? r[o] : o).apply(r, arguments) : t } "string" != typeof o && (h.guid = o.guid = o.guid || h.guid || e.guid++); var l = n.match(/^(\w+)\s*(.*)$/), u = l[1] + r.eventNamespace, c = l[2]; c ? a.delegate(c, u, h) : s.bind(u, h) }) }, _off: function (e, t) { t = (t || "").split(" ").join(this.eventNamespace + " ") + this.eventNamespace, e.unbind(t).undelegate(t) }, _delay: function (e, t) { function i() { return ("string" == typeof e ? s[e] : e).apply(s, arguments) } var s = this; return setTimeout(i, t || 0) }, _hoverable: function (t) { this.hoverable = this.hoverable.add(t), this._on(t, { mouseenter: function (t) { e(t.currentTarget).addClass("ui-state-hover") }, mouseleave: function (t) { e(t.currentTarget).removeClass("ui-state-hover") } }) }, _focusable: function (t) { this.focusable = this.focusable.add(t), this._on(t, { focusin: function (t) { e(t.currentTarget).addClass("ui-state-focus") }, focusout: function (t) { e(t.currentTarget).removeClass("ui-state-focus") } }) }, _trigger: function (t, i, s) { var n, a, r = this.options[t]; if (s = s || {}, i = e.Event(i), i.type = (t === this.widgetEventPrefix ? t : this.widgetEventPrefix + t).toLowerCase(), i.target = this.element[0], a = i.originalEvent) for (n in a) n in i || (i[n] = a[n]); return this.element.trigger(i, s), !(e.isFunction(r) && r.apply(this.element[0], [i].concat(s)) === !1 || i.isDefaultPrevented()) } }, e.each({ show: "fadeIn", hide: "fadeOut" }, function (t, i) { e.Widget.prototype["_" + t] = function (s, n, a) { "string" == typeof n && (n = { effect: n }); var r, o = n ? n === !0 || "number" == typeof n ? i : n.effect || i : t; n = n || {}, "number" == typeof n && (n = { duration: n }), r = !e.isEmptyObject(n), n.complete = a, n.delay && s.delay(n.delay), r && e.effects && e.effects.effect[o] ? s[t](n) : o !== t && s[o] ? s[o](n.duration, n.easing, a) : s.queue(function (i) { e(this)[t](), a && a.call(s[0]), i() }) } }) })(jQuery);

/*! jQuery UI - v1.10.4 - 2014-01-17
* http://jqueryui.com
* Copyright 2014 jQuery Foundation and other contributors; Licensed MIT */
(function (e) { var t = !1; e(document).mouseup(function () { t = !1 }), e.widget("ui.mouse", { version: "1.10.4", options: { cancel: "input,textarea,button,select,option", distance: 1, delay: 0 }, _mouseInit: function () { var t = this; this.element.bind("mousedown." + this.widgetName, function (e) { return t._mouseDown(e) }).bind("click." + this.widgetName, function (i) { return !0 === e.data(i.target, t.widgetName + ".preventClickEvent") ? (e.removeData(i.target, t.widgetName + ".preventClickEvent"), i.stopImmediatePropagation(), !1) : undefined }), this.started = !1 }, _mouseDestroy: function () { this.element.unbind("." + this.widgetName), this._mouseMoveDelegate && e(document).unbind("mousemove." + this.widgetName, this._mouseMoveDelegate).unbind("mouseup." + this.widgetName, this._mouseUpDelegate) }, _mouseDown: function (i) { if (!t) { this._mouseStarted && this._mouseUp(i), this._mouseDownEvent = i; var s = this, n = 1 === i.which, a = "string" == typeof this.options.cancel && i.target.nodeName ? e(i.target).closest(this.options.cancel).length : !1; return n && !a && this._mouseCapture(i) ? (this.mouseDelayMet = !this.options.delay, this.mouseDelayMet || (this._mouseDelayTimer = setTimeout(function () { s.mouseDelayMet = !0 }, this.options.delay)), this._mouseDistanceMet(i) && this._mouseDelayMet(i) && (this._mouseStarted = this._mouseStart(i) !== !1, !this._mouseStarted) ? (i.preventDefault(), !0) : (!0 === e.data(i.target, this.widgetName + ".preventClickEvent") && e.removeData(i.target, this.widgetName + ".preventClickEvent"), this._mouseMoveDelegate = function (e) { return s._mouseMove(e) }, this._mouseUpDelegate = function (e) { return s._mouseUp(e) }, e(document).bind("mousemove." + this.widgetName, this._mouseMoveDelegate).bind("mouseup." + this.widgetName, this._mouseUpDelegate), i.preventDefault(), t = !0, !0)) : !0 } }, _mouseMove: function (t) { return e.ui.ie && (!document.documentMode || 9 > document.documentMode) && !t.button ? this._mouseUp(t) : this._mouseStarted ? (this._mouseDrag(t), t.preventDefault()) : (this._mouseDistanceMet(t) && this._mouseDelayMet(t) && (this._mouseStarted = this._mouseStart(this._mouseDownEvent, t) !== !1, this._mouseStarted ? this._mouseDrag(t) : this._mouseUp(t)), !this._mouseStarted) }, _mouseUp: function (t) { return e(document).unbind("mousemove." + this.widgetName, this._mouseMoveDelegate).unbind("mouseup." + this.widgetName, this._mouseUpDelegate), this._mouseStarted && (this._mouseStarted = !1, t.target === this._mouseDownEvent.target && e.data(t.target, this.widgetName + ".preventClickEvent", !0), this._mouseStop(t)), !1 }, _mouseDistanceMet: function (e) { return Math.max(Math.abs(this._mouseDownEvent.pageX - e.pageX), Math.abs(this._mouseDownEvent.pageY - e.pageY)) >= this.options.distance }, _mouseDelayMet: function () { return this.mouseDelayMet }, _mouseStart: function () { }, _mouseDrag: function () { }, _mouseStop: function () { }, _mouseCapture: function () { return !0 } }) })(jQuery);

/*! jQuery UI - v1.10.4 - 2014-01-17
* http://jqueryui.com
* Copyright 2014 jQuery Foundation and other contributors; Licensed MIT */
(function (t) { function e(t, e, i) { return t > e && e + i > t } function i(t) { return /left|right/.test(t.css("float")) || /inline|table-cell/.test(t.css("display")) } t.widget("ui.sortable", t.ui.mouse, { version: "1.10.4", widgetEventPrefix: "sort", ready: !1, options: { appendTo: "parent", axis: !1, connectWith: !1, containment: !1, cursor: "auto", cursorAt: !1, dropOnEmpty: !0, forcePlaceholderSize: !1, forceHelperSize: !1, grid: !1, handle: !1, helper: "original", items: "> *", opacity: !1, placeholder: !1, revert: !1, scroll: !0, scrollSensitivity: 20, scrollSpeed: 20, scope: "default", tolerance: "intersect", zIndex: 1e3, activate: null, beforeStop: null, change: null, deactivate: null, out: null, over: null, receive: null, remove: null, sort: null, start: null, stop: null, update: null }, _create: function () { var t = this.options; this.containerCache = {}, this.element.addClass("ui-sortable"), this.refresh(), this.floating = this.items.length ? "x" === t.axis || i(this.items[0].item) : !1, this.offset = this.element.offset(), this._mouseInit(), this.ready = !0 }, _destroy: function () { this.element.removeClass("ui-sortable ui-sortable-disabled"), this._mouseDestroy(); for (var t = this.items.length - 1; t >= 0; t--)this.items[t].item.removeData(this.widgetName + "-item"); return this }, _setOption: function (e, i) { "disabled" === e ? (this.options[e] = i, this.widget().toggleClass("ui-sortable-disabled", !!i)) : t.Widget.prototype._setOption.apply(this, arguments) }, _mouseCapture: function (e, i) { var s = null, n = !1, a = this; return this.reverting ? !1 : this.options.disabled || "static" === this.options.type ? !1 : (this._refreshItems(e), t(e.target).parents().each(function () { return t.data(this, a.widgetName + "-item") === a ? (s = t(this), !1) : undefined }), t.data(e.target, a.widgetName + "-item") === a && (s = t(e.target)), s ? !this.options.handle || i || (t(this.options.handle, s).find("*").addBack().each(function () { this === e.target && (n = !0) }), n) ? (this.currentItem = s, this._removeCurrentsFromItems(), !0) : !1 : !1) }, _mouseStart: function (e, i, s) { var n, a, o = this.options; if (this.currentContainer = this, this.refreshPositions(), this.helper = this._createHelper(e), this._cacheHelperProportions(), this._cacheMargins(), this.scrollParent = this.helper.scrollParent(), this.offset = this.currentItem.offset(), this.offset = { top: this.offset.top - this.margins.top, left: this.offset.left - this.margins.left }, t.extend(this.offset, { click: { left: e.pageX - this.offset.left, top: e.pageY - this.offset.top }, parent: this._getParentOffset(), relative: this._getRelativeOffset() }), this.helper.css("position", "absolute"), this.cssPosition = this.helper.css("position"), this.originalPosition = this._generatePosition(e), this.originalPageX = e.pageX, this.originalPageY = e.pageY, o.cursorAt && this._adjustOffsetFromHelper(o.cursorAt), this.domPosition = { prev: this.currentItem.prev()[0], parent: this.currentItem.parent()[0] }, this.helper[0] !== this.currentItem[0] && this.currentItem.hide(), this._createPlaceholder(), o.containment && this._setContainment(), o.cursor && "auto" !== o.cursor && (a = this.document.find("body"), this.storedCursor = a.css("cursor"), a.css("cursor", o.cursor), this.storedStylesheet = t("<style>*{ cursor: " + o.cursor + " !important; }</style>").appendTo(a)), o.opacity && (this.helper.css("opacity") && (this._storedOpacity = this.helper.css("opacity")), this.helper.css("opacity", o.opacity)), o.zIndex && (this.helper.css("zIndex") && (this._storedZIndex = this.helper.css("zIndex")), this.helper.css("zIndex", o.zIndex)), this.scrollParent[0] !== document && "HTML" !== this.scrollParent[0].tagName && (this.overflowOffset = this.scrollParent.offset()), this._trigger("start", e, this._uiHash()), this._preserveHelperProportions || this._cacheHelperProportions(), !s) for (n = this.containers.length - 1; n >= 0; n--)this.containers[n]._trigger("activate", e, this._uiHash(this)); return t.ui.ddmanager && (t.ui.ddmanager.current = this), t.ui.ddmanager && !o.dropBehaviour && t.ui.ddmanager.prepareOffsets(this, e), this.dragging = !0, this.helper.addClass("ui-sortable-helper"), this._mouseDrag(e), !0 }, _mouseDrag: function (e) { var i, s, n, a, o = this.options, r = !1; for (this.position = this._generatePosition(e), this.positionAbs = this._convertPositionTo("absolute"), this.lastPositionAbs || (this.lastPositionAbs = this.positionAbs), this.options.scroll && (this.scrollParent[0] !== document && "HTML" !== this.scrollParent[0].tagName ? (this.overflowOffset.top + this.scrollParent[0].offsetHeight - e.pageY < o.scrollSensitivity ? this.scrollParent[0].scrollTop = r = this.scrollParent[0].scrollTop + o.scrollSpeed : e.pageY - this.overflowOffset.top < o.scrollSensitivity && (this.scrollParent[0].scrollTop = r = this.scrollParent[0].scrollTop - o.scrollSpeed), this.overflowOffset.left + this.scrollParent[0].offsetWidth - e.pageX < o.scrollSensitivity ? this.scrollParent[0].scrollLeft = r = this.scrollParent[0].scrollLeft + o.scrollSpeed : e.pageX - this.overflowOffset.left < o.scrollSensitivity && (this.scrollParent[0].scrollLeft = r = this.scrollParent[0].scrollLeft - o.scrollSpeed)) : (e.pageY - t(document).scrollTop() < o.scrollSensitivity ? r = t(document).scrollTop(t(document).scrollTop() - o.scrollSpeed) : t(window).height() - (e.pageY - t(document).scrollTop()) < o.scrollSensitivity && (r = t(document).scrollTop(t(document).scrollTop() + o.scrollSpeed)), e.pageX - t(document).scrollLeft() < o.scrollSensitivity ? r = t(document).scrollLeft(t(document).scrollLeft() - o.scrollSpeed) : t(window).width() - (e.pageX - t(document).scrollLeft()) < o.scrollSensitivity && (r = t(document).scrollLeft(t(document).scrollLeft() + o.scrollSpeed))), r !== !1 && t.ui.ddmanager && !o.dropBehaviour && t.ui.ddmanager.prepareOffsets(this, e)), this.positionAbs = this._convertPositionTo("absolute"), this.options.axis && "y" === this.options.axis || (this.helper[0].style.left = this.position.left + "px"), this.options.axis && "x" === this.options.axis || (this.helper[0].style.top = this.position.top + "px"), i = this.items.length - 1; i >= 0; i--)if (s = this.items[i], n = s.item[0], a = this._intersectsWithPointer(s), a && s.instance === this.currentContainer && n !== this.currentItem[0] && this.placeholder[1 === a ? "next" : "prev"]()[0] !== n && !t.contains(this.placeholder[0], n) && ("semi-dynamic" === this.options.type ? !t.contains(this.element[0], n) : !0)) { if (this.direction = 1 === a ? "down" : "up", "pointer" !== this.options.tolerance && !this._intersectsWithSides(s)) break; this._rearrange(e, s), this._trigger("change", e, this._uiHash()); break } return this._contactContainers(e), t.ui.ddmanager && t.ui.ddmanager.drag(this, e), this._trigger("sort", e, this._uiHash()), this.lastPositionAbs = this.positionAbs, !1 }, _mouseStop: function (e, i) { if (e) { if (t.ui.ddmanager && !this.options.dropBehaviour && t.ui.ddmanager.drop(this, e), this.options.revert) { var s = this, n = this.placeholder.offset(), a = this.options.axis, o = {}; a && "x" !== a || (o.left = n.left - this.offset.parent.left - this.margins.left + (this.offsetParent[0] === document.body ? 0 : this.offsetParent[0].scrollLeft)), a && "y" !== a || (o.top = n.top - this.offset.parent.top - this.margins.top + (this.offsetParent[0] === document.body ? 0 : this.offsetParent[0].scrollTop)), this.reverting = !0, t(this.helper).animate(o, parseInt(this.options.revert, 10) || 500, function () { s._clear(e) }) } else this._clear(e, i); return !1 } }, cancel: function () { if (this.dragging) { this._mouseUp({ target: null }), "original" === this.options.helper ? this.currentItem.css(this._storedCSS).removeClass("ui-sortable-helper") : this.currentItem.show(); for (var e = this.containers.length - 1; e >= 0; e--)this.containers[e]._trigger("deactivate", null, this._uiHash(this)), this.containers[e].containerCache.over && (this.containers[e]._trigger("out", null, this._uiHash(this)), this.containers[e].containerCache.over = 0) } return this.placeholder && (this.placeholder[0].parentNode && this.placeholder[0].parentNode.removeChild(this.placeholder[0]), "original" !== this.options.helper && this.helper && this.helper[0].parentNode && this.helper.remove(), t.extend(this, { helper: null, dragging: !1, reverting: !1, _noFinalSort: null }), this.domPosition.prev ? t(this.domPosition.prev).after(this.currentItem) : t(this.domPosition.parent).prepend(this.currentItem)), this }, serialize: function (e) { var i = this._getItemsAsjQuery(e && e.connected), s = []; return e = e || {}, t(i).each(function () { var i = (t(e.item || this).attr(e.attribute || "id") || "").match(e.expression || /(.+)[\-=_](.+)/); i && s.push((e.key || i[1] + "[]") + "=" + (e.key && e.expression ? i[1] : i[2])) }), !s.length && e.key && s.push(e.key + "="), s.join("&") }, toArray: function (e) { var i = this._getItemsAsjQuery(e && e.connected), s = []; return e = e || {}, i.each(function () { s.push(t(e.item || this).attr(e.attribute || "id") || "") }), s }, _intersectsWith: function (t) { var e = this.positionAbs.left, i = e + this.helperProportions.width, s = this.positionAbs.top, n = s + this.helperProportions.height, a = t.left, o = a + t.width, r = t.top, h = r + t.height, l = this.offset.click.top, c = this.offset.click.left, u = "x" === this.options.axis || s + l > r && h > s + l, d = "y" === this.options.axis || e + c > a && o > e + c, p = u && d; return "pointer" === this.options.tolerance || this.options.forcePointerForContainers || "pointer" !== this.options.tolerance && this.helperProportions[this.floating ? "width" : "height"] > t[this.floating ? "width" : "height"] ? p : e + this.helperProportions.width / 2 > a && o > i - this.helperProportions.width / 2 && s + this.helperProportions.height / 2 > r && h > n - this.helperProportions.height / 2 }, _intersectsWithPointer: function (t) { var i = "x" === this.options.axis || e(this.positionAbs.top + this.offset.click.top, t.top, t.height), s = "y" === this.options.axis || e(this.positionAbs.left + this.offset.click.left, t.left, t.width), n = i && s, a = this._getDragVerticalDirection(), o = this._getDragHorizontalDirection(); return n ? this.floating ? o && "right" === o || "down" === a ? 2 : 1 : a && ("down" === a ? 2 : 1) : !1 }, _intersectsWithSides: function (t) { var i = e(this.positionAbs.top + this.offset.click.top, t.top + t.height / 2, t.height), s = e(this.positionAbs.left + this.offset.click.left, t.left + t.width / 2, t.width), n = this._getDragVerticalDirection(), a = this._getDragHorizontalDirection(); return this.floating && a ? "right" === a && s || "left" === a && !s : n && ("down" === n && i || "up" === n && !i) }, _getDragVerticalDirection: function () { var t = this.positionAbs.top - this.lastPositionAbs.top; return 0 !== t && (t > 0 ? "down" : "up") }, _getDragHorizontalDirection: function () { var t = this.positionAbs.left - this.lastPositionAbs.left; return 0 !== t && (t > 0 ? "right" : "left") }, refresh: function (t) { return this._refreshItems(t), this.refreshPositions(), this }, _connectWith: function () { var t = this.options; return t.connectWith.constructor === String ? [t.connectWith] : t.connectWith }, _getItemsAsjQuery: function (e) { function i() { r.push(this) } var s, n, a, o, r = [], h = [], l = this._connectWith(); if (l && e) for (s = l.length - 1; s >= 0; s--)for (a = t(l[s]), n = a.length - 1; n >= 0; n--)o = t.data(a[n], this.widgetFullName), o && o !== this && !o.options.disabled && h.push([t.isFunction(o.options.items) ? o.options.items.call(o.element) : t(o.options.items, o.element).not(".ui-sortable-helper").not(".ui-sortable-placeholder"), o]); for (h.push([t.isFunction(this.options.items) ? this.options.items.call(this.element, null, { options: this.options, item: this.currentItem }) : t(this.options.items, this.element).not(".ui-sortable-helper").not(".ui-sortable-placeholder"), this]), s = h.length - 1; s >= 0; s--)h[s][0].each(i); return t(r) }, _removeCurrentsFromItems: function () { var e = this.currentItem.find(":data(" + this.widgetName + "-item)"); this.items = t.grep(this.items, function (t) { for (var i = 0; e.length > i; i++)if (e[i] === t.item[0]) return !1; return !0 }) }, _refreshItems: function (e) { this.items = [], this.containers = [this]; var i, s, n, a, o, r, h, l, c = this.items, u = [[t.isFunction(this.options.items) ? this.options.items.call(this.element[0], e, { item: this.currentItem }) : t(this.options.items, this.element), this]], d = this._connectWith(); if (d && this.ready) for (i = d.length - 1; i >= 0; i--)for (n = t(d[i]), s = n.length - 1; s >= 0; s--)a = t.data(n[s], this.widgetFullName), a && a !== this && !a.options.disabled && (u.push([t.isFunction(a.options.items) ? a.options.items.call(a.element[0], e, { item: this.currentItem }) : t(a.options.items, a.element), a]), this.containers.push(a)); for (i = u.length - 1; i >= 0; i--)for (o = u[i][1], r = u[i][0], s = 0, l = r.length; l > s; s++)h = t(r[s]), h.data(this.widgetName + "-item", o), c.push({ item: h, instance: o, width: 0, height: 0, left: 0, top: 0 }) }, refreshPositions: function (e) { this.offsetParent && this.helper && (this.offset.parent = this._getParentOffset()); var i, s, n, a; for (i = this.items.length - 1; i >= 0; i--)s = this.items[i], s.instance !== this.currentContainer && this.currentContainer && s.item[0] !== this.currentItem[0] || (n = this.options.toleranceElement ? t(this.options.toleranceElement, s.item) : s.item, e || (s.width = n.outerWidth(), s.height = n.outerHeight()), a = n.offset(), s.left = a.left, s.top = a.top); if (this.options.custom && this.options.custom.refreshContainers) this.options.custom.refreshContainers.call(this); else for (i = this.containers.length - 1; i >= 0; i--)a = this.containers[i].element.offset(), this.containers[i].containerCache.left = a.left, this.containers[i].containerCache.top = a.top, this.containers[i].containerCache.width = this.containers[i].element.outerWidth(), this.containers[i].containerCache.height = this.containers[i].element.outerHeight(); return this }, _createPlaceholder: function (e) { e = e || this; var i, s = e.options; s.placeholder && s.placeholder.constructor !== String || (i = s.placeholder, s.placeholder = { element: function () { var s = e.currentItem[0].nodeName.toLowerCase(), n = t("<" + s + ">", e.document[0]).addClass(i || e.currentItem[0].className + " ui-sortable-placeholder").removeClass("ui-sortable-helper"); return "tr" === s ? e.currentItem.children().each(function () { t("<td>&#160;</td>", e.document[0]).attr("colspan", t(this).attr("colspan") || 1).appendTo(n) }) : "img" === s && n.attr("src", e.currentItem.attr("src")), i || n.css("visibility", "hidden"), n }, update: function (t, n) { (!i || s.forcePlaceholderSize) && (n.height() || n.height(e.currentItem.innerHeight() - parseInt(e.currentItem.css("paddingTop") || 0, 10) - parseInt(e.currentItem.css("paddingBottom") || 0, 10)), n.width() || n.width(e.currentItem.innerWidth() - parseInt(e.currentItem.css("paddingLeft") || 0, 10) - parseInt(e.currentItem.css("paddingRight") || 0, 10))) } }), e.placeholder = t(s.placeholder.element.call(e.element, e.currentItem)), e.currentItem.after(e.placeholder), s.placeholder.update(e, e.placeholder) }, _contactContainers: function (s) { var n, a, o, r, h, l, c, u, d, p, f = null, m = null; for (n = this.containers.length - 1; n >= 0; n--)if (!t.contains(this.currentItem[0], this.containers[n].element[0])) if (this._intersectsWith(this.containers[n].containerCache)) { if (f && t.contains(this.containers[n].element[0], f.element[0])) continue; f = this.containers[n], m = n } else this.containers[n].containerCache.over && (this.containers[n]._trigger("out", s, this._uiHash(this)), this.containers[n].containerCache.over = 0); if (f) if (1 === this.containers.length) this.containers[m].containerCache.over || (this.containers[m]._trigger("over", s, this._uiHash(this)), this.containers[m].containerCache.over = 1); else { for (o = 1e4, r = null, p = f.floating || i(this.currentItem), h = p ? "left" : "top", l = p ? "width" : "height", c = this.positionAbs[h] + this.offset.click[h], a = this.items.length - 1; a >= 0; a--)t.contains(this.containers[m].element[0], this.items[a].item[0]) && this.items[a].item[0] !== this.currentItem[0] && (!p || e(this.positionAbs.top + this.offset.click.top, this.items[a].top, this.items[a].height)) && (u = this.items[a].item.offset()[h], d = !1, Math.abs(u - c) > Math.abs(u + this.items[a][l] - c) && (d = !0, u += this.items[a][l]), o > Math.abs(u - c) && (o = Math.abs(u - c), r = this.items[a], this.direction = d ? "up" : "down")); if (!r && !this.options.dropOnEmpty) return; if (this.currentContainer === this.containers[m]) return; r ? this._rearrange(s, r, null, !0) : this._rearrange(s, null, this.containers[m].element, !0), this._trigger("change", s, this._uiHash()), this.containers[m]._trigger("change", s, this._uiHash(this)), this.currentContainer = this.containers[m], this.options.placeholder.update(this.currentContainer, this.placeholder), this.containers[m]._trigger("over", s, this._uiHash(this)), this.containers[m].containerCache.over = 1 } }, _createHelper: function (e) { var i = this.options, s = t.isFunction(i.helper) ? t(i.helper.apply(this.element[0], [e, this.currentItem])) : "clone" === i.helper ? this.currentItem.clone() : this.currentItem; return s.parents("body").length || t("parent" !== i.appendTo ? i.appendTo : this.currentItem[0].parentNode)[0].appendChild(s[0]), s[0] === this.currentItem[0] && (this._storedCSS = { width: this.currentItem[0].style.width, height: this.currentItem[0].style.height, position: this.currentItem.css("position"), top: this.currentItem.css("top"), left: this.currentItem.css("left") }), (!s[0].style.width || i.forceHelperSize) && s.width(this.currentItem.width()), (!s[0].style.height || i.forceHelperSize) && s.height(this.currentItem.height()), s }, _adjustOffsetFromHelper: function (e) { "string" == typeof e && (e = e.split(" ")), t.isArray(e) && (e = { left: +e[0], top: +e[1] || 0 }), "left" in e && (this.offset.click.left = e.left + this.margins.left), "right" in e && (this.offset.click.left = this.helperProportions.width - e.right + this.margins.left), "top" in e && (this.offset.click.top = e.top + this.margins.top), "bottom" in e && (this.offset.click.top = this.helperProportions.height - e.bottom + this.margins.top) }, _getParentOffset: function () { this.offsetParent = this.helper.offsetParent(); var e = this.offsetParent.offset(); return "absolute" === this.cssPosition && this.scrollParent[0] !== document && t.contains(this.scrollParent[0], this.offsetParent[0]) && (e.left += this.scrollParent.scrollLeft(), e.top += this.scrollParent.scrollTop()), (this.offsetParent[0] === document.body || this.offsetParent[0].tagName && "html" === this.offsetParent[0].tagName.toLowerCase() && t.ui.ie) && (e = { top: 0, left: 0 }), { top: e.top + (parseInt(this.offsetParent.css("borderTopWidth"), 10) || 0), left: e.left + (parseInt(this.offsetParent.css("borderLeftWidth"), 10) || 0) } }, _getRelativeOffset: function () { if ("relative" === this.cssPosition) { var t = this.currentItem.position(); return { top: t.top - (parseInt(this.helper.css("top"), 10) || 0) + this.scrollParent.scrollTop(), left: t.left - (parseInt(this.helper.css("left"), 10) || 0) + this.scrollParent.scrollLeft() } } return { top: 0, left: 0 } }, _cacheMargins: function () { this.margins = { left: parseInt(this.currentItem.css("marginLeft"), 10) || 0, top: parseInt(this.currentItem.css("marginTop"), 10) || 0 } }, _cacheHelperProportions: function () { this.helperProportions = { width: this.helper.outerWidth(), height: this.helper.outerHeight() } }, _setContainment: function () { var e, i, s, n = this.options; "parent" === n.containment && (n.containment = this.helper[0].parentNode), ("document" === n.containment || "window" === n.containment) && (this.containment = [0 - this.offset.relative.left - this.offset.parent.left, 0 - this.offset.relative.top - this.offset.parent.top, t("document" === n.containment ? document : window).width() - this.helperProportions.width - this.margins.left, (t("document" === n.containment ? document : window).height() || document.body.parentNode.scrollHeight) - this.helperProportions.height - this.margins.top]), /^(document|window|parent)$/.test(n.containment) || (e = t(n.containment)[0], i = t(n.containment).offset(), s = "hidden" !== t(e).css("overflow"), this.containment = [i.left + (parseInt(t(e).css("borderLeftWidth"), 10) || 0) + (parseInt(t(e).css("paddingLeft"), 10) || 0) - this.margins.left, i.top + (parseInt(t(e).css("borderTopWidth"), 10) || 0) + (parseInt(t(e).css("paddingTop"), 10) || 0) - this.margins.top, i.left + (s ? Math.max(e.scrollWidth, e.offsetWidth) : e.offsetWidth) - (parseInt(t(e).css("borderLeftWidth"), 10) || 0) - (parseInt(t(e).css("paddingRight"), 10) || 0) - this.helperProportions.width - this.margins.left, i.top + (s ? Math.max(e.scrollHeight, e.offsetHeight) : e.offsetHeight) - (parseInt(t(e).css("borderTopWidth"), 10) || 0) - (parseInt(t(e).css("paddingBottom"), 10) || 0) - this.helperProportions.height - this.margins.top]) }, _convertPositionTo: function (e, i) { i || (i = this.position); var s = "absolute" === e ? 1 : -1, n = "absolute" !== this.cssPosition || this.scrollParent[0] !== document && t.contains(this.scrollParent[0], this.offsetParent[0]) ? this.scrollParent : this.offsetParent, a = /(html|body)/i.test(n[0].tagName); return { top: i.top + this.offset.relative.top * s + this.offset.parent.top * s - ("fixed" === this.cssPosition ? -this.scrollParent.scrollTop() : a ? 0 : n.scrollTop()) * s, left: i.left + this.offset.relative.left * s + this.offset.parent.left * s - ("fixed" === this.cssPosition ? -this.scrollParent.scrollLeft() : a ? 0 : n.scrollLeft()) * s } }, _generatePosition: function (e) { var i, s, n = this.options, a = e.pageX, o = e.pageY, r = "absolute" !== this.cssPosition || this.scrollParent[0] !== document && t.contains(this.scrollParent[0], this.offsetParent[0]) ? this.scrollParent : this.offsetParent, h = /(html|body)/i.test(r[0].tagName); return "relative" !== this.cssPosition || this.scrollParent[0] !== document && this.scrollParent[0] !== this.offsetParent[0] || (this.offset.relative = this._getRelativeOffset()), this.originalPosition && (this.containment && (e.pageX - this.offset.click.left < this.containment[0] && (a = this.containment[0] + this.offset.click.left), e.pageY - this.offset.click.top < this.containment[1] && (o = this.containment[1] + this.offset.click.top), e.pageX - this.offset.click.left > this.containment[2] && (a = this.containment[2] + this.offset.click.left), e.pageY - this.offset.click.top > this.containment[3] && (o = this.containment[3] + this.offset.click.top)), n.grid && (i = this.originalPageY + Math.round((o - this.originalPageY) / n.grid[1]) * n.grid[1], o = this.containment ? i - this.offset.click.top >= this.containment[1] && i - this.offset.click.top <= this.containment[3] ? i : i - this.offset.click.top >= this.containment[1] ? i - n.grid[1] : i + n.grid[1] : i, s = this.originalPageX + Math.round((a - this.originalPageX) / n.grid[0]) * n.grid[0], a = this.containment ? s - this.offset.click.left >= this.containment[0] && s - this.offset.click.left <= this.containment[2] ? s : s - this.offset.click.left >= this.containment[0] ? s - n.grid[0] : s + n.grid[0] : s)), { top: o - this.offset.click.top - this.offset.relative.top - this.offset.parent.top + ("fixed" === this.cssPosition ? -this.scrollParent.scrollTop() : h ? 0 : r.scrollTop()), left: a - this.offset.click.left - this.offset.relative.left - this.offset.parent.left + ("fixed" === this.cssPosition ? -this.scrollParent.scrollLeft() : h ? 0 : r.scrollLeft()) } }, _rearrange: function (t, e, i, s) { i ? i[0].appendChild(this.placeholder[0]) : e.item[0].parentNode.insertBefore(this.placeholder[0], "down" === this.direction ? e.item[0] : e.item[0].nextSibling), this.counter = this.counter ? ++this.counter : 1; var n = this.counter; this._delay(function () { n === this.counter && this.refreshPositions(!s) }) }, _clear: function (t, e) { function i(t, e, i) { return function (s) { i._trigger(t, s, e._uiHash(e)) } } this.reverting = !1; var s, n = []; if (!this._noFinalSort && this.currentItem.parent().length && this.placeholder.before(this.currentItem), this._noFinalSort = null, this.helper[0] === this.currentItem[0]) { for (s in this._storedCSS) ("auto" === this._storedCSS[s] || "static" === this._storedCSS[s]) && (this._storedCSS[s] = ""); this.currentItem.css(this._storedCSS).removeClass("ui-sortable-helper") } else this.currentItem.show(); for (this.fromOutside && !e && n.push(function (t) { this._trigger("receive", t, this._uiHash(this.fromOutside)) }), !this.fromOutside && this.domPosition.prev === this.currentItem.prev().not(".ui-sortable-helper")[0] && this.domPosition.parent === this.currentItem.parent()[0] || e || n.push(function (t) { this._trigger("update", t, this._uiHash()) }), this !== this.currentContainer && (e || (n.push(function (t) { this._trigger("remove", t, this._uiHash()) }), n.push(function (t) { return function (e) { t._trigger("receive", e, this._uiHash(this)) } }.call(this, this.currentContainer)), n.push(function (t) { return function (e) { t._trigger("update", e, this._uiHash(this)) } }.call(this, this.currentContainer)))), s = this.containers.length - 1; s >= 0; s--)e || n.push(i("deactivate", this, this.containers[s])), this.containers[s].containerCache.over && (n.push(i("out", this, this.containers[s])), this.containers[s].containerCache.over = 0); if (this.storedCursor && (this.document.find("body").css("cursor", this.storedCursor), this.storedStylesheet.remove()), this._storedOpacity && this.helper.css("opacity", this._storedOpacity), this._storedZIndex && this.helper.css("zIndex", "auto" === this._storedZIndex ? "" : this._storedZIndex), this.dragging = !1, this.cancelHelperRemoval) { if (!e) { for (this._trigger("beforeStop", t, this._uiHash()), s = 0; n.length > s; s++)n[s].call(this, t); this._trigger("stop", t, this._uiHash()) } return this.fromOutside = !1, !1 } if (e || this._trigger("beforeStop", t, this._uiHash()), this.placeholder[0].parentNode.removeChild(this.placeholder[0]), this.helper[0] !== this.currentItem[0] && this.helper.remove(), this.helper = null, !e) { for (s = 0; n.length > s; s++)n[s].call(this, t); this._trigger("stop", t, this._uiHash()) } return this.fromOutside = !1, !0 }, _trigger: function () { t.Widget.prototype._trigger.apply(this, arguments) === !1 && this.cancel() }, _uiHash: function (e) { var i = e || this; return { helper: i.helper, placeholder: i.placeholder || t([]), position: i.position, originalPosition: i.originalPosition, offset: i.positionAbs, item: i.currentItem, sender: e ? e.element : null } } }) })(jQuery);

/*
 AngularJS v1.2.28
 (c) 2010-2014 Google, Inc. http://angularjs.org
 License: MIT
*/
(function (W, X, u) {
    'use strict'; function z(b) { return function () { var a = arguments[0], c, a = "[" + (b ? b + ":" : "") + a + "] http://errors.angularjs.org/1.2.28/" + (b ? b + "/" : "") + a; for (c = 1; c < arguments.length; c++)a = a + (1 == c ? "?" : "&") + "p" + (c - 1) + "=" + encodeURIComponent("function" == typeof arguments[c] ? arguments[c].toString().replace(/ \{[\s\S]*$/, "") : "undefined" == typeof arguments[c] ? "undefined" : "string" != typeof arguments[c] ? JSON.stringify(arguments[c]) : arguments[c]); return Error(a) } } function Sa(b) {
        if (null == b || Ja(b)) return !1;
        var a = b.length; return 1 === b.nodeType && a ? !0 : G(b) || L(b) || 0 === a || "number" === typeof a && 0 < a && a - 1 in b
    } function r(b, a, c) { var d; if (b) if (N(b)) for (d in b) "prototype" == d || ("length" == d || "name" == d || b.hasOwnProperty && !b.hasOwnProperty(d)) || a.call(c, b[d], d); else if (L(b) || Sa(b)) for (d = 0; d < b.length; d++)a.call(c, b[d], d); else if (b.forEach && b.forEach !== r) b.forEach(a, c); else for (d in b) b.hasOwnProperty(d) && a.call(c, b[d], d); return b } function Xb(b) { var a = [], c; for (c in b) b.hasOwnProperty(c) && a.push(c); return a.sort() } function Sc(b,
        a, c) { for (var d = Xb(b), e = 0; e < d.length; e++)a.call(c, b[d[e]], d[e]); return d } function Yb(b) { return function (a, c) { b(c, a) } } function ib() { for (var b = na.length, a; b;) { b--; a = na[b].charCodeAt(0); if (57 == a) return na[b] = "A", na.join(""); if (90 == a) na[b] = "0"; else return na[b] = String.fromCharCode(a + 1), na.join("") } na.unshift("0"); return na.join("") } function Zb(b, a) { a ? b.$$hashKey = a : delete b.$$hashKey } function E(b) { var a = b.$$hashKey; r(arguments, function (a) { a !== b && r(a, function (a, c) { b[c] = a }) }); Zb(b, a); return b } function U(b) {
            return parseInt(b,
                10)
        } function $b(b, a) { return E(new (E(function () { }, { prototype: b })), a) } function v() { } function ga(b) { return b } function aa(b) { return function () { return b } } function F(b) { return "undefined" === typeof b } function D(b) { return "undefined" !== typeof b } function T(b) { return null != b && "object" === typeof b } function G(b) { return "string" === typeof b } function jb(b) { return "number" === typeof b } function va(b) { return "[object Date]" === Ba.call(b) } function N(b) { return "function" === typeof b } function kb(b) { return "[object RegExp]" === Ba.call(b) }
    function Ja(b) { return b && b.document && b.location && b.alert && b.setInterval } function Tc(b) { return !(!b || !(b.nodeName || b.prop && b.attr && b.find)) } function Uc(b, a, c) { var d = []; r(b, function (b, f, g) { d.push(a.call(c, b, f, g)) }); return d } function Ta(b, a) { if (b.indexOf) return b.indexOf(a); for (var c = 0; c < b.length; c++)if (a === b[c]) return c; return -1 } function Ua(b, a) { var c = Ta(b, a); 0 <= c && b.splice(c, 1); return a } function Ka(b, a, c, d) {
        if (Ja(b) || b && b.$evalAsync && b.$watch) throw Va("cpws"); if (a) {
            if (b === a) throw Va("cpi"); c = c || [];
            d = d || []; if (T(b)) { var e = Ta(c, b); if (-1 !== e) return d[e]; c.push(b); d.push(a) } if (L(b)) for (var f = a.length = 0; f < b.length; f++)e = Ka(b[f], null, c, d), T(b[f]) && (c.push(b[f]), d.push(e)), a.push(e); else { var g = a.$$hashKey; L(a) ? a.length = 0 : r(a, function (b, c) { delete a[c] }); for (f in b) e = Ka(b[f], null, c, d), T(b[f]) && (c.push(b[f]), d.push(e)), a[f] = e; Zb(a, g) }
        } else if (a = b) L(b) ? a = Ka(b, [], c, d) : va(b) ? a = new Date(b.getTime()) : kb(b) ? (a = RegExp(b.source, b.toString().match(/[^\/]*$/)[0]), a.lastIndex = b.lastIndex) : T(b) && (a = Ka(b, {}, c, d));
        return a
    } function ha(b, a) { if (L(b)) { a = a || []; for (var c = 0; c < b.length; c++)a[c] = b[c] } else if (T(b)) for (c in a = a || {}, b) !lb.call(b, c) || "$" === c.charAt(0) && "$" === c.charAt(1) || (a[c] = b[c]); return a || b } function Ca(b, a) {
        if (b === a) return !0; if (null === b || null === a) return !1; if (b !== b && a !== a) return !0; var c = typeof b, d; if (c == typeof a && "object" == c) if (L(b)) { if (!L(a)) return !1; if ((c = b.length) == a.length) { for (d = 0; d < c; d++)if (!Ca(b[d], a[d])) return !1; return !0 } } else {
            if (va(b)) return va(a) ? isNaN(b.getTime()) && isNaN(a.getTime()) || b.getTime() ===
                a.getTime() : !1; if (kb(b) && kb(a)) return b.toString() == a.toString(); if (b && b.$evalAsync && b.$watch || a && a.$evalAsync && a.$watch || Ja(b) || Ja(a) || L(a)) return !1; c = {}; for (d in b) if ("$" !== d.charAt(0) && !N(b[d])) { if (!Ca(b[d], a[d])) return !1; c[d] = !0 } for (d in a) if (!c.hasOwnProperty(d) && "$" !== d.charAt(0) && a[d] !== u && !N(a[d])) return !1; return !0
        } return !1
    } function Bb(b, a) {
        var c = 2 < arguments.length ? wa.call(arguments, 2) : []; return !N(a) || a instanceof RegExp ? a : c.length ? function () {
            return arguments.length ? a.apply(b, c.concat(wa.call(arguments,
                0))) : a.apply(b, c)
        } : function () { return arguments.length ? a.apply(b, arguments) : a.call(b) }
    } function Vc(b, a) { var c = a; "string" === typeof b && "$" === b.charAt(0) ? c = u : Ja(a) ? c = "$WINDOW" : a && X === a ? c = "$DOCUMENT" : a && (a.$evalAsync && a.$watch) && (c = "$SCOPE"); return c } function oa(b, a) { return "undefined" === typeof b ? u : JSON.stringify(b, Vc, a ? "  " : null) } function ac(b) { return G(b) ? JSON.parse(b) : b } function Wa(b) {
        "function" === typeof b ? b = !0 : b && 0 !== b.length ? (b = x("" + b), b = !("f" == b || "0" == b || "false" == b || "no" == b || "n" == b || "[]" == b)) : b = !1;
        return b
    } function ia(b) { b = A(b).clone(); try { b.empty() } catch (a) { } var c = A("<div>").append(b).html(); try { return 3 === b[0].nodeType ? x(c) : c.match(/^(<[^>]+>)/)[1].replace(/^<([\w\-]+)/, function (a, b) { return "<" + x(b) }) } catch (d) { return x(c) } } function bc(b) { try { return decodeURIComponent(b) } catch (a) { } } function cc(b) { var a = {}, c, d; r((b || "").split("&"), function (b) { b && (c = b.replace(/\+/g, "%20").split("="), d = bc(c[0]), D(d) && (b = D(c[1]) ? bc(c[1]) : !0, lb.call(a, d) ? L(a[d]) ? a[d].push(b) : a[d] = [a[d], b] : a[d] = b)) }); return a } function Cb(b) {
        var a =
            []; r(b, function (b, d) { L(b) ? r(b, function (b) { a.push(Da(d, !0) + (!0 === b ? "" : "=" + Da(b, !0))) }) : a.push(Da(d, !0) + (!0 === b ? "" : "=" + Da(b, !0))) }); return a.length ? a.join("&") : ""
    } function mb(b) { return Da(b, !0).replace(/%26/gi, "&").replace(/%3D/gi, "=").replace(/%2B/gi, "+") } function Da(b, a) { return encodeURIComponent(b).replace(/%40/gi, "@").replace(/%3A/gi, ":").replace(/%24/g, "$").replace(/%2C/gi, ",").replace(/%20/g, a ? "%20" : "+") } function Wc(b, a) {
        function c(a) { a && d.push(a) } var d = [b], e, f, g = ["ng:app", "ng-app", "x-ng-app",
            "data-ng-app"], h = /\sng[:\-]app(:\s*([\w\d_]+);?)?\s/; r(g, function (a) { g[a] = !0; c(X.getElementById(a)); a = a.replace(":", "\\:"); b.querySelectorAll && (r(b.querySelectorAll("." + a), c), r(b.querySelectorAll("." + a + "\\:"), c), r(b.querySelectorAll("[" + a + "]"), c)) }); r(d, function (a) { if (!e) { var b = h.exec(" " + a.className + " "); b ? (e = a, f = (b[2] || "").replace(/\s+/g, ",")) : r(a.attributes, function (b) { !e && g[b.name] && (e = a, f = b.value) }) } }); e && a(e, f ? [f] : [])
    } function dc(b, a) {
        var c = function () {
            b = A(b); if (b.injector()) {
                var c = b[0] === X ?
                    "document" : ia(b); throw Va("btstrpd", c.replace(/</, "&lt;").replace(/>/, "&gt;"));
            } a = a || []; a.unshift(["$provide", function (a) { a.value("$rootElement", b) }]); a.unshift("ng"); c = ec(a); c.invoke(["$rootScope", "$rootElement", "$compile", "$injector", "$animate", function (a, b, c, d, e) { a.$apply(function () { b.data("$injector", d); c(b)(a) }) }]); return c
        }, d = /^NG_DEFER_BOOTSTRAP!/; if (W && !d.test(W.name)) return c(); W.name = W.name.replace(d, ""); Xa.resumeBootstrap = function (b) { r(b, function (b) { a.push(b) }); c() }
    } function nb(b, a) {
        a =
        a || "_"; return b.replace(Xc, function (b, d) { return (d ? a : "") + b.toLowerCase() })
    } function Db(b, a, c) { if (!b) throw Va("areq", a || "?", c || "required"); return b } function Ya(b, a, c) { c && L(b) && (b = b[b.length - 1]); Db(N(b), a, "not a function, got " + (b && "object" === typeof b ? b.constructor.name || "Object" : typeof b)); return b } function Ea(b, a) { if ("hasOwnProperty" === b) throw Va("badname", a); } function fc(b, a, c) { if (!a) return b; a = a.split("."); for (var d, e = b, f = a.length, g = 0; g < f; g++)d = a[g], b && (b = (e = b)[d]); return !c && N(b) ? Bb(e, b) : b } function Eb(b) {
        var a =
            b[0]; b = b[b.length - 1]; if (a === b) return A(a); var c = [a]; do { a = a.nextSibling; if (!a) break; c.push(a) } while (a !== b); return A(c)
    } function Yc(b) {
        var a = z("$injector"), c = z("ng"); b = b.angular || (b.angular = {}); b.$$minErr = b.$$minErr || z; return b.module || (b.module = function () {
            var b = {}; return function (e, f, g) {
                if ("hasOwnProperty" === e) throw c("badname", "module"); f && b.hasOwnProperty(e) && (b[e] = null); return b[e] || (b[e] = function () {
                    function b(a, d, e) { return function () { c[e || "push"]([a, d, arguments]); return n } } if (!f) throw a("nomod",
                        e); var c = [], d = [], l = b("$injector", "invoke"), n = { _invokeQueue: c, _runBlocks: d, requires: f, name: e, provider: b("$provide", "provider"), factory: b("$provide", "factory"), service: b("$provide", "service"), value: b("$provide", "value"), constant: b("$provide", "constant", "unshift"), animation: b("$animateProvider", "register"), filter: b("$filterProvider", "register"), controller: b("$controllerProvider", "register"), directive: b("$compileProvider", "directive"), config: l, run: function (a) { d.push(a); return this } }; g && l(g); return n
                }())
            }
        }())
    }
    function Zc(b) {
        E(b, { bootstrap: dc, copy: Ka, extend: E, equals: Ca, element: A, forEach: r, injector: ec, noop: v, bind: Bb, toJson: oa, fromJson: ac, identity: ga, isUndefined: F, isDefined: D, isString: G, isFunction: N, isObject: T, isNumber: jb, isElement: Tc, isArray: L, version: $c, isDate: va, lowercase: x, uppercase: La, callbacks: { counter: 0 }, $$minErr: z, $$csp: Za }); $a = Yc(W); try { $a("ngLocale") } catch (a) { $a("ngLocale", []).provider("$locale", ad) } $a("ng", ["ngLocale"], ["$provide", function (a) {
            a.provider({ $$sanitizeUri: bd }); a.provider("$compile",
                gc).directive({ a: cd, input: hc, textarea: hc, form: dd, script: ed, select: fd, style: gd, option: hd, ngBind: id, ngBindHtml: jd, ngBindTemplate: kd, ngClass: ld, ngClassEven: md, ngClassOdd: nd, ngCloak: od, ngController: pd, ngForm: qd, ngHide: rd, ngIf: sd, ngInclude: td, ngInit: ud, ngNonBindable: vd, ngPluralize: wd, ngRepeat: xd, ngShow: yd, ngStyle: zd, ngSwitch: Ad, ngSwitchWhen: Bd, ngSwitchDefault: Cd, ngOptions: Dd, ngTransclude: Ed, ngModel: Fd, ngList: Gd, ngChange: Hd, required: ic, ngRequired: ic, ngValue: Id }).directive({ ngInclude: Jd }).directive(Fb).directive(jc);
            a.provider({ $anchorScroll: Kd, $animate: Ld, $browser: Md, $cacheFactory: Nd, $controller: Od, $document: Pd, $exceptionHandler: Qd, $filter: kc, $interpolate: Rd, $interval: Sd, $http: Td, $httpBackend: Ud, $location: Vd, $log: Wd, $parse: Xd, $rootScope: Yd, $q: Zd, $sce: $d, $sceDelegate: ae, $sniffer: be, $templateCache: ce, $timeout: de, $window: ee, $$rAF: fe, $$asyncCallback: ge })
        }])
    } function ab(b) { return b.replace(he, function (a, b, d, e) { return e ? d.toUpperCase() : d }).replace(ie, "Moz$1") } function Gb(b, a, c, d) {
        function e(b) {
            var e = c && b ? [this.filter(b)] :
                [this], k = a, m, l, n, q, p, s; if (!d || null != b) for (; e.length;)for (m = e.shift(), l = 0, n = m.length; l < n; l++)for (q = A(m[l]), k ? q.triggerHandler("$destroy") : k = !k, p = 0, q = (s = q.children()).length; p < q; p++)e.push(Fa(s[p])); return f.apply(this, arguments)
        } var f = Fa.fn[b], f = f.$original || f; e.$original = f; Fa.fn[b] = e
    } function S(b) {
        if (b instanceof S) return b; G(b) && (b = $(b)); if (!(this instanceof S)) { if (G(b) && "<" != b.charAt(0)) throw Hb("nosel"); return new S(b) } if (G(b)) {
            var a = b; b = X; var c; if (c = je.exec(a)) b = [b.createElement(c[1])]; else {
                var d =
                    b, e; b = d.createDocumentFragment(); c = []; if (Ib.test(a)) { d = b.appendChild(d.createElement("div")); e = (ke.exec(a) || ["", ""])[1].toLowerCase(); e = da[e] || da._default; d.innerHTML = "<div>&#160;</div>" + e[1] + a.replace(le, "<$1></$2>") + e[2]; d.removeChild(d.firstChild); for (a = e[0]; a--;)d = d.lastChild; a = 0; for (e = d.childNodes.length; a < e; ++a)c.push(d.childNodes[a]); d = b.firstChild; d.textContent = "" } else c.push(d.createTextNode(a)); b.textContent = ""; b.innerHTML = ""; b = c
            } Jb(this, b); A(X.createDocumentFragment()).append(this)
        } else Jb(this,
            b)
    } function Kb(b) { return b.cloneNode(!0) } function Ma(b) { Lb(b); var a = 0; for (b = b.childNodes || []; a < b.length; a++)Ma(b[a]) } function lc(b, a, c, d) { if (D(d)) throw Hb("offargs"); var e = pa(b, "events"); pa(b, "handle") && (F(a) ? r(e, function (a, c) { bb(b, c, a); delete e[c] }) : r(a.split(" "), function (a) { F(c) ? (bb(b, a, e[a]), delete e[a]) : Ua(e[a] || [], c) })) } function Lb(b, a) { var c = b.ng339, d = cb[c]; d && (a ? delete cb[c].data[a] : (d.handle && (d.events.$destroy && d.handle({}, "$destroy"), lc(b)), delete cb[c], b.ng339 = u)) } function pa(b, a, c) {
        var d =
            b.ng339, d = cb[d || -1]; if (D(c)) d || (b.ng339 = d = ++me, d = cb[d] = {}), d[a] = c; else return d && d[a]
    } function Mb(b, a, c) { var d = pa(b, "data"), e = D(c), f = !e && D(a), g = f && !T(a); d || g || pa(b, "data", d = {}); if (e) d[a] = c; else if (f) { if (g) return d && d[a]; E(d, a) } else return d } function Nb(b, a) { return b.getAttribute ? -1 < (" " + (b.getAttribute("class") || "") + " ").replace(/[\n\t]/g, " ").indexOf(" " + a + " ") : !1 } function ob(b, a) {
    a && b.setAttribute && r(a.split(" "), function (a) {
        b.setAttribute("class", $((" " + (b.getAttribute("class") || "") + " ").replace(/[\n\t]/g,
            " ").replace(" " + $(a) + " ", " ")))
    })
    } function pb(b, a) { if (a && b.setAttribute) { var c = (" " + (b.getAttribute("class") || "") + " ").replace(/[\n\t]/g, " "); r(a.split(" "), function (a) { a = $(a); -1 === c.indexOf(" " + a + " ") && (c += a + " ") }); b.setAttribute("class", $(c)) } } function Jb(b, a) { if (a) { a = a.nodeName || !D(a.length) || Ja(a) ? [a] : a; for (var c = 0; c < a.length; c++)b.push(a[c]) } } function mc(b, a) { return qb(b, "$" + (a || "ngController") + "Controller") } function qb(b, a, c) {
    9 == b.nodeType && (b = b.documentElement); for (a = L(a) ? a : [a]; b;) {
        for (var d =
            0, e = a.length; d < e; d++)if ((c = A.data(b, a[d])) !== u) return c; b = b.parentNode || 11 === b.nodeType && b.host
    }
    } function nc(b) { for (var a = 0, c = b.childNodes; a < c.length; a++)Ma(c[a]); for (; b.firstChild;)b.removeChild(b.firstChild) } function oc(b, a) { var c = rb[a.toLowerCase()]; return c && pc[b.nodeName] && c } function ne(b, a) {
        var c = function (c, e) {
        c.preventDefault || (c.preventDefault = function () { c.returnValue = !1 }); c.stopPropagation || (c.stopPropagation = function () { c.cancelBubble = !0 }); c.target || (c.target = c.srcElement || X); if (F(c.defaultPrevented)) {
            var f =
                c.preventDefault; c.preventDefault = function () { c.defaultPrevented = !0; f.call(c) }; c.defaultPrevented = !1
        } c.isDefaultPrevented = function () { return c.defaultPrevented || !1 === c.returnValue }; var g = ha(a[e || c.type] || []); r(g, function (a) { a.call(b, c) }); 8 >= R ? (c.preventDefault = null, c.stopPropagation = null, c.isDefaultPrevented = null) : (delete c.preventDefault, delete c.stopPropagation, delete c.isDefaultPrevented)
        }; c.elem = b; return c
    } function Na(b, a) {
        var c = typeof b, d; "function" == c || "object" == c && null !== b ? "function" == typeof (d =
            b.$$hashKey) ? d = b.$$hashKey() : d === u && (d = b.$$hashKey = (a || ib)()) : d = b; return c + ":" + d
    } function db(b, a) { if (a) { var c = 0; this.nextUid = function () { return ++c } } r(b, this.put, this) } function qc(b) { var a, c; "function" === typeof b ? (a = b.$inject) || (a = [], b.length && (c = b.toString().replace(oe, ""), c = c.match(pe), r(c[1].split(qe), function (b) { b.replace(re, function (b, c, d) { a.push(d) }) })), b.$inject = a) : L(b) ? (c = b.length - 1, Ya(b[c], "fn"), a = b.slice(0, c)) : Ya(b, "fn", !0); return a } function ec(b) {
        function a(a) {
            return function (b, c) {
                if (T(b)) r(b,
                    Yb(a)); else return a(b, c)
            }
        } function c(a, b) { Ea(a, "service"); if (N(b) || L(b)) b = n.instantiate(b); if (!b.$get) throw eb("pget", a); return l[a + h] = b } function d(a, b) { return c(a, { $get: b }) } function e(a) {
            var b = [], c, d, f, h; r(a, function (a) {
                if (!m.get(a)) {
                    m.put(a, !0); try { if (G(a)) for (c = $a(a), b = b.concat(e(c.requires)).concat(c._runBlocks), d = c._invokeQueue, f = 0, h = d.length; f < h; f++) { var g = d[f], k = n.get(g[0]); k[g[1]].apply(k, g[2]) } else N(a) ? b.push(n.invoke(a)) : L(a) ? b.push(n.invoke(a)) : Ya(a, "module") } catch (p) {
                        throw L(a) && (a =
                            a[a.length - 1]), p.message && (p.stack && -1 == p.stack.indexOf(p.message)) && (p = p.message + "\n" + p.stack), eb("modulerr", a, p.stack || p.message || p);
                    }
                }
            }); return b
        } function f(a, b) {
            function c(d) { if (a.hasOwnProperty(d)) { if (a[d] === g) throw eb("cdep", d + " <- " + k.join(" <- ")); return a[d] } try { return k.unshift(d), a[d] = g, a[d] = b(d) } catch (e) { throw a[d] === g && delete a[d], e; } finally { k.shift() } } function d(a, b, e) {
                var f = [], h = qc(a), g, k, p; k = 0; for (g = h.length; k < g; k++) {
                    p = h[k]; if ("string" !== typeof p) throw eb("itkn", p); f.push(e && e.hasOwnProperty(p) ?
                        e[p] : c(p))
                } L(a) && (a = a[g]); return a.apply(b, f)
            } return { invoke: d, instantiate: function (a, b) { var c = function () { }, e; c.prototype = (L(a) ? a[a.length - 1] : a).prototype; c = new c; e = d(a, c, b); return T(e) || N(e) ? e : c }, get: c, annotate: qc, has: function (b) { return l.hasOwnProperty(b + h) || a.hasOwnProperty(b) } }
        } var g = {}, h = "Provider", k = [], m = new db([], !0), l = {
            $provide: {
                provider: a(c), factory: a(d), service: a(function (a, b) { return d(a, ["$injector", function (a) { return a.instantiate(b) }]) }), value: a(function (a, b) { return d(a, aa(b)) }), constant: a(function (a,
                    b) { Ea(a, "constant"); l[a] = b; q[a] = b }), decorator: function (a, b) { var c = n.get(a + h), d = c.$get; c.$get = function () { var a = p.invoke(d, c); return p.invoke(b, null, { $delegate: a }) } }
            }
        }, n = l.$injector = f(l, function () { throw eb("unpr", k.join(" <- ")); }), q = {}, p = q.$injector = f(q, function (a) { a = n.get(a + h); return p.invoke(a.$get, a) }); r(e(b), function (a) { p.invoke(a || v) }); return p
    } function Kd() {
        var b = !0; this.disableAutoScrolling = function () { b = !1 }; this.$get = ["$window", "$location", "$rootScope", function (a, c, d) {
            function e(a) {
                var b = null;
                r(a, function (a) { b || "a" !== x(a.nodeName) || (b = a) }); return b
            } function f() { var b = c.hash(), d; b ? (d = g.getElementById(b)) ? d.scrollIntoView() : (d = e(g.getElementsByName(b))) ? d.scrollIntoView() : "top" === b && a.scrollTo(0, 0) : a.scrollTo(0, 0) } var g = a.document; b && d.$watch(function () { return c.hash() }, function () { d.$evalAsync(f) }); return f
        }]
    } function ge() { this.$get = ["$$rAF", "$timeout", function (b, a) { return b.supported ? function (a) { return b(a) } : function (b) { return a(b, 0, !1) } }] } function se(b, a, c, d) {
        function e(a) {
            try {
                a.apply(null,
                    wa.call(arguments, 1))
            } finally { if (s-- , 0 === s) for (; J.length;)try { J.pop()() } catch (b) { c.error(b) } }
        } function f(a, b) { (function ea() { r(w, function (a) { a() }); t = b(ea, a) })() } function g() { y != h.url() && (y = h.url(), r(ba, function (a) { a(h.url()) })) } var h = this, k = a[0], m = b.location, l = b.history, n = b.setTimeout, q = b.clearTimeout, p = {}; h.isMock = !1; var s = 0, J = []; h.$$completeOutstandingRequest = e; h.$$incOutstandingRequestCount = function () { s++ }; h.notifyWhenNoOutstandingRequests = function (a) { r(w, function (a) { a() }); 0 === s ? a() : J.push(a) };
        var w = [], t; h.addPollFn = function (a) { F(t) && f(100, n); w.push(a); return a }; var y = m.href, K = a.find("base"), B = null; h.url = function (a, c) { m !== b.location && (m = b.location); l !== b.history && (l = b.history); if (a) { if (y != a) { var e = y && Ga(y) === Ga(a); y = a; !e && d.history ? c ? l.replaceState(null, "", a) : (l.pushState(null, "", a), K.attr("href", K.attr("href"))) : (e || (B = a), c ? m.replace(a) : m.href = a); return h } } else return B || m.href.replace(/%27/g, "'") }; var ba = [], O = !1; h.onUrlChange = function (a) {
            if (!O) {
                if (d.history) A(b).on("popstate", g); if (d.hashchange) A(b).on("hashchange",
                    g); else h.addPollFn(g); O = !0
            } ba.push(a); return a
        }; h.$$checkUrlChange = g; h.baseHref = function () { var a = K.attr("href"); return a ? a.replace(/^(https?\:)?\/\/[^\/]*/, "") : "" }; var M = {}, ca = "", P = h.baseHref(); h.cookies = function (a, b) {
            var d, e, f, h; if (a) b === u ? k.cookie = escape(a) + "=;path=" + P + ";expires=Thu, 01 Jan 1970 00:00:00 GMT" : G(b) && (d = (k.cookie = escape(a) + "=" + escape(b) + ";path=" + P).length + 1, 4096 < d && c.warn("Cookie '" + a + "' possibly not set or overflowed because it was too large (" + d + " > 4096 bytes)!")); else {
                if (k.cookie !==
                    ca) for (ca = k.cookie, d = ca.split("; "), M = {}, f = 0; f < d.length; f++)e = d[f], h = e.indexOf("="), 0 < h && (a = unescape(e.substring(0, h)), M[a] === u && (M[a] = unescape(e.substring(h + 1)))); return M
            }
        }; h.defer = function (a, b) { var c; s++; c = n(function () { delete p[c]; e(a) }, b || 0); p[c] = !0; return c }; h.defer.cancel = function (a) { return p[a] ? (delete p[a], q(a), e(v), !0) : !1 }
    } function Md() { this.$get = ["$window", "$log", "$sniffer", "$document", function (b, a, c, d) { return new se(b, d, a, c) }] } function Nd() {
    this.$get = function () {
        function b(b, d) {
            function e(a) {
            a !=
                n && (q ? q == a && (q = a.n) : q = a, f(a.n, a.p), f(a, n), n = a, n.n = null)
            } function f(a, b) { a != b && (a && (a.p = b), b && (b.n = a)) } if (b in a) throw z("$cacheFactory")("iid", b); var g = 0, h = E({}, d, { id: b }), k = {}, m = d && d.capacity || Number.MAX_VALUE, l = {}, n = null, q = null; return a[b] = {
                put: function (a, b) { if (m < Number.MAX_VALUE) { var c = l[a] || (l[a] = { key: a }); e(c) } if (!F(b)) return a in k || g++ , k[a] = b, g > m && this.remove(q.key), b }, get: function (a) { if (m < Number.MAX_VALUE) { var b = l[a]; if (!b) return; e(b) } return k[a] }, remove: function (a) {
                    if (m < Number.MAX_VALUE) {
                        var b =
                            l[a]; if (!b) return; b == n && (n = b.p); b == q && (q = b.n); f(b.n, b.p); delete l[a]
                    } delete k[a]; g--
                }, removeAll: function () { k = {}; g = 0; l = {}; n = q = null }, destroy: function () { l = h = k = null; delete a[b] }, info: function () { return E({}, h, { size: g }) }
            }
        } var a = {}; b.info = function () { var b = {}; r(a, function (a, e) { b[e] = a.info() }); return b }; b.get = function (b) { return a[b] }; return b
    }
    } function ce() { this.$get = ["$cacheFactory", function (b) { return b("templates") }] } function gc(b, a) {
        var c = {}, d = "Directive", e = /^\s*directive\:\s*([\d\w_\-]+)\s+(.*)$/, f = /(([\d\w_\-]+)(?:\:([^;]+))?;?)/,
        g = /^(on[a-z]+|formaction)$/; this.directive = function k(a, e) {
            Ea(a, "directive"); G(a) ? (Db(e, "directiveFactory"), c.hasOwnProperty(a) || (c[a] = [], b.factory(a + d, ["$injector", "$exceptionHandler", function (b, d) { var e = []; r(c[a], function (c, f) { try { var g = b.invoke(c); N(g) ? g = { compile: aa(g) } : !g.compile && g.link && (g.compile = aa(g.link)); g.priority = g.priority || 0; g.index = f; g.name = g.name || a; g.require = g.require || g.controller && g.name; g.restrict = g.restrict || "A"; e.push(g) } catch (k) { d(k) } }); return e }])), c[a].push(e)) : r(a, Yb(k));
            return this
        }; this.aHrefSanitizationWhitelist = function (b) { return D(b) ? (a.aHrefSanitizationWhitelist(b), this) : a.aHrefSanitizationWhitelist() }; this.imgSrcSanitizationWhitelist = function (b) { return D(b) ? (a.imgSrcSanitizationWhitelist(b), this) : a.imgSrcSanitizationWhitelist() }; this.$get = ["$injector", "$interpolate", "$exceptionHandler", "$http", "$templateCache", "$parse", "$controller", "$rootScope", "$document", "$sce", "$animate", "$$sanitizeUri", function (a, b, l, n, q, p, s, J, w, t, y, K) {
            function B(a, b, c, d, e) {
            a instanceof
                A || (a = A(a)); r(a, function (b, c) { 3 == b.nodeType && b.nodeValue.match(/\S+/) && (a[c] = A(b).wrap("<span></span>").parent()[0]) }); var f = O(a, b, a, c, d, e); ba(a, "ng-scope"); return function (b, c, d, e) { Db(b, "scope"); var g = c ? Oa.clone.call(a) : a; r(d, function (a, b) { g.data("$" + b + "Controller", a) }); d = 0; for (var k = g.length; d < k; d++) { var p = g[d].nodeType; 1 !== p && 9 !== p || g.eq(d).data("$scope", b) } c && c(g, b); f && f(b, g, g, e); return g }
            } function ba(a, b) { try { a.addClass(b) } catch (c) { } } function O(a, b, c, d, e, f) {
                function g(a, c, d, e) {
                    var f, p, l, m, q,
                    n, w; f = c.length; var s = Array(f); for (m = 0; m < f; m++)s[m] = c[m]; n = m = 0; for (q = k.length; m < q; n++)p = s[n], c = k[m++], f = k[m++], c ? (c.scope ? (l = a.$new(), A.data(p, "$scope", l)) : l = a, w = c.transcludeOnThisElement ? M(a, c.transclude, e) : !c.templateOnThisElement && e ? e : !e && b ? M(a, b) : null, c(f, l, p, d, w)) : f && f(a, p.childNodes, u, e)
                } for (var k = [], p, l, m, q, n = 0; n < a.length; n++)p = new Ob, l = ca(a[n], [], p, 0 === n ? d : u, e), (f = l.length ? I(l, a[n], p, b, c, null, [], [], f) : null) && f.scope && ba(p.$$element, "ng-scope"), p = f && f.terminal || !(m = a[n].childNodes) || !m.length ?
                    null : O(m, f ? (f.transcludeOnThisElement || !f.templateOnThisElement) && f.transclude : b), k.push(f, p), q = q || f || p, f = null; return q ? g : null
            } function M(a, b, c) { return function (d, e, f) { var g = !1; d || (d = a.$new(), g = d.$$transcluded = !0); e = b(d, e, f, c); if (g) e.on("$destroy", function () { d.$destroy() }); return e } } function ca(a, b, c, d, g) {
                var k = c.$attr, p; switch (a.nodeType) {
                    case 1: ea(b, qa(Pa(a).toLowerCase()), "E", d, g); for (var l, m, q, n = a.attributes, w = 0, s = n && n.length; w < s; w++) {
                        var t = !1, J = !1; l = n[w]; if (!R || 8 <= R || l.specified) {
                            p = l.name; m =
                                $(l.value); l = qa(p); if (q = U.test(l)) p = nb(l.substr(6), "-"); var y = l.replace(/(Start|End)$/, ""); l === y + "Start" && (t = p, J = p.substr(0, p.length - 5) + "end", p = p.substr(0, p.length - 6)); l = qa(p.toLowerCase()); k[l] = p; if (q || !c.hasOwnProperty(l)) c[l] = m, oc(a, l) && (c[l] = !0); S(a, b, m, l); ea(b, l, "A", d, g, t, J)
                        }
                    } a = a.className; if (G(a) && "" !== a) for (; p = f.exec(a);)l = qa(p[2]), ea(b, l, "C", d, g) && (c[l] = $(p[3])), a = a.substr(p.index + p[0].length); break; case 3: x(b, a.nodeValue); break; case 8: try {
                        if (p = e.exec(a.nodeValue)) l = qa(p[1]), ea(b, l, "M", d,
                            g) && (c[l] = $(p[2]))
                    } catch (B) { }
                }b.sort(F); return b
            } function P(a, b, c) { var d = [], e = 0; if (b && a.hasAttribute && a.hasAttribute(b)) { do { if (!a) throw ja("uterdir", b, c); 1 == a.nodeType && (a.hasAttribute(b) && e++ , a.hasAttribute(c) && e--); d.push(a); a = a.nextSibling } while (0 < e) } else d.push(a); return A(d) } function C(a, b, c) { return function (d, e, f, g, k) { e = P(e[0], b, c); return a(d, e, f, g, k) } } function I(a, c, d, e, f, g, k, q, n) {
                function w(a, b, c, d) {
                    if (a) {
                        c && (a = C(a, c, d)); a.require = H.require; a.directiveName = z; if (K === H || H.$$isolateScope) a = rc(a,
                            { isolateScope: !0 }); k.push(a)
                    } if (b) { c && (b = C(b, c, d)); b.require = H.require; b.directiveName = z; if (K === H || H.$$isolateScope) b = rc(b, { isolateScope: !0 }); q.push(b) }
                } function t(a, b, c, d) { var e, f = "data", g = !1; if (G(b)) { for (; "^" == (e = b.charAt(0)) || "?" == e;)b = b.substr(1), "^" == e && (f = "inheritedData"), g = g || "?" == e; e = null; d && "data" === f && (e = d[b]); e = e || c[f]("$" + b + "Controller"); if (!e && !g) throw ja("ctreq", b, a); } else L(b) && (e = [], r(b, function (b) { e.push(t(a, b, c, d)) })); return e } function J(a, e, f, g, n) {
                    function w(a, b) {
                        var c; 2 > arguments.length &&
                            (b = a, a = u); Ia && (c = ca); return n(a, b, c)
                    } var y, Q, B, M, C, P, ca = {}, ra; y = c === f ? d : ha(d, new Ob(A(f), d.$attr)); Q = y.$$element; if (K) {
                        var ue = /^\s*([@=&])(\??)\s*(\w*)\s*$/; P = e.$new(!0); !I || I !== K && I !== K.$$originalDirective ? Q.data("$isolateScopeNoTemplate", P) : Q.data("$isolateScope", P); ba(Q, "ng-isolate-scope"); r(K.scope, function (a, c) {
                            var d = a.match(ue) || [], f = d[3] || c, g = "?" == d[2], d = d[1], k, l, n, q; P.$$isolateBindings[c] = d + f; switch (d) {
                                case "@": y.$observe(f, function (a) { P[c] = a }); y.$$observers[f].$$scope = e; y[f] && (P[c] = b(y[f])(e));
                                    break; case "=": if (g && !y[f]) break; l = p(y[f]); q = l.literal ? Ca : function (a, b) { return a === b || a !== a && b !== b }; n = l.assign || function () { k = P[c] = l(e); throw ja("nonassign", y[f], K.name); }; k = P[c] = l(e); P.$watch(function () { var a = l(e); q(a, P[c]) || (q(a, k) ? n(e, a = P[c]) : P[c] = a); return k = a }, null, l.literal); break; case "&": l = p(y[f]); P[c] = function (a) { return l(e, a) }; break; default: throw ja("iscp", K.name, c, a);
                            }
                        })
                    } ra = n && w; O && r(O, function (a) {
                        var b = { $scope: a === K || a.$$isolateScope ? P : e, $element: Q, $attrs: y, $transclude: ra }, c; C = a.controller;
                        "@" == C && (C = y[a.name]); c = s(C, b); ca[a.name] = c; Ia || Q.data("$" + a.name + "Controller", c); a.controllerAs && (b.$scope[a.controllerAs] = c)
                    }); g = 0; for (B = k.length; g < B; g++)try { M = k[g], M(M.isolateScope ? P : e, Q, y, M.require && t(M.directiveName, M.require, Q, ca), ra) } catch (H) { l(H, ia(Q)) } g = e; K && (K.template || null === K.templateUrl) && (g = P); a && a(g, f.childNodes, u, n); for (g = q.length - 1; 0 <= g; g--)try { M = q[g], M(M.isolateScope ? P : e, Q, y, M.require && t(M.directiveName, M.require, Q, ca), ra) } catch (D) { l(D, ia(Q)) }
                } n = n || {}; for (var y = -Number.MAX_VALUE,
                    M, O = n.controllerDirectives, K = n.newIsolateScopeDirective, I = n.templateDirective, ea = n.nonTlbTranscludeDirective, F = !1, E = !1, Ia = n.hasElementTranscludeDirective, x = d.$$element = A(c), H, z, V, S = e, R, Ha = 0, sa = a.length; Ha < sa; Ha++) {
                        H = a[Ha]; var U = H.$$start, Y = H.$$end; U && (x = P(c, U, Y)); V = u; if (y > H.priority) break; if (V = H.scope) M = M || H, H.templateUrl || (fb("new/isolated scope", K, H, x), T(V) && (K = H)); z = H.name; !H.templateUrl && H.controller && (V = H.controller, O = O || {}, fb("'" + z + "' controller", O[z], H, x), O[z] = H); if (V = H.transclude) F = !0, H.$$tlb ||
                            (fb("transclusion", ea, H, x), ea = H), "element" == V ? (Ia = !0, y = H.priority, V = x, x = d.$$element = A(X.createComment(" " + z + ": " + d[z] + " ")), c = x[0], ra(f, wa.call(V, 0), c), S = B(V, e, y, g && g.name, { nonTlbTranscludeDirective: ea })) : (V = A(Kb(c)).contents(), x.empty(), S = B(V, e)); if (H.template) if (E = !0, fb("template", I, H, x), I = H, V = N(H.template) ? H.template(x, d) : H.template, V = W(V), H.replace) {
                                g = H; V = Ib.test(V) ? A($(V)) : []; c = V[0]; if (1 != V.length || 1 !== c.nodeType) throw ja("tplrt", z, ""); ra(f, x, c); sa = { $attr: {} }; V = ca(c, [], sa); var Z = a.splice(Ha +
                                    1, a.length - (Ha + 1)); K && D(V); a = a.concat(V).concat(Z); v(d, sa); sa = a.length
                            } else x.html(V); if (H.templateUrl) E = !0, fb("template", I, H, x), I = H, H.replace && (g = H), J = te(a.splice(Ha, a.length - Ha), x, d, f, F && S, k, q, { controllerDirectives: O, newIsolateScopeDirective: K, templateDirective: I, nonTlbTranscludeDirective: ea }), sa = a.length; else if (H.compile) try { R = H.compile(x, d, S), N(R) ? w(null, R, U, Y) : R && w(R.pre, R.post, U, Y) } catch (ve) { l(ve, ia(x)) } H.terminal && (J.terminal = !0, y = Math.max(y, H.priority))
                } J.scope = M && !0 === M.scope; J.transcludeOnThisElement =
                    F; J.templateOnThisElement = E; J.transclude = S; n.hasElementTranscludeDirective = Ia; return J
            } function D(a) { for (var b = 0, c = a.length; b < c; b++)a[b] = $b(a[b], { $$isolateScope: !0 }) } function ea(b, e, f, g, p, m, n) { if (e === p) return null; p = null; if (c.hasOwnProperty(e)) { var q; e = a.get(e + d); for (var w = 0, s = e.length; w < s; w++)try { q = e[w], (g === u || g > q.priority) && -1 != q.restrict.indexOf(f) && (m && (q = $b(q, { $$start: m, $$end: n })), b.push(q), p = q) } catch (y) { l(y) } } return p } function v(a, b) {
                var c = b.$attr, d = a.$attr, e = a.$$element; r(a, function (d, e) {
                "$" !=
                    e.charAt(0) && (b[e] && b[e] !== d && (d += ("style" === e ? ";" : " ") + b[e]), a.$set(e, d, !0, c[e]))
                }); r(b, function (b, f) { "class" == f ? (ba(e, b), a["class"] = (a["class"] ? a["class"] + " " : "") + b) : "style" == f ? (e.attr("style", e.attr("style") + ";" + b), a.style = (a.style ? a.style + ";" : "") + b) : "$" == f.charAt(0) || a.hasOwnProperty(f) || (a[f] = b, d[f] = c[f]) })
            } function te(a, b, c, d, e, f, g, k) {
                var p = [], l, m, w = b[0], s = a.shift(), y = E({}, s, { templateUrl: null, transclude: null, replace: null, $$originalDirective: s }), J = N(s.templateUrl) ? s.templateUrl(b, c) : s.templateUrl;
                b.empty(); n.get(t.getTrustedResourceUrl(J), { cache: q }).success(function (q) {
                    var n, t; q = W(q); if (s.replace) { q = Ib.test(q) ? A($(q)) : []; n = q[0]; if (1 != q.length || 1 !== n.nodeType) throw ja("tplrt", s.name, J); q = { $attr: {} }; ra(d, b, n); var B = ca(n, [], q); T(s.scope) && D(B); a = B.concat(a); v(c, q) } else n = w, b.html(q); a.unshift(y); l = I(a, n, c, e, b, s, f, g, k); r(d, function (a, c) { a == n && (d[c] = b[0]) }); for (m = O(b[0].childNodes, e); p.length;) {
                        q = p.shift(); t = p.shift(); var K = p.shift(), C = p.shift(), B = b[0]; if (t !== w) {
                            var P = t.className; k.hasElementTranscludeDirective &&
                                s.replace || (B = Kb(n)); ra(K, A(t), B); ba(A(B), P)
                        } t = l.transcludeOnThisElement ? M(q, l.transclude, C) : C; l(m, q, B, d, t)
                    } p = null
                }).error(function (a, b, c, d) { throw ja("tpload", d.url); }); return function (a, b, c, d, e) { a = e; p ? (p.push(b), p.push(c), p.push(d), p.push(a)) : (l.transcludeOnThisElement && (a = M(b, l.transclude, e)), l(m, b, c, d, a)) }
            } function F(a, b) { var c = b.priority - a.priority; return 0 !== c ? c : a.name !== b.name ? a.name < b.name ? -1 : 1 : a.index - b.index } function fb(a, b, c, d) { if (b) throw ja("multidir", b.name, c.name, a, ia(d)); } function x(a,
                c) { var d = b(c, !0); d && a.push({ priority: 0, compile: function (a) { var b = a.parent().length; b && ba(a.parent(), "ng-binding"); return function (a, c) { var e = c.parent(), f = e.data("$binding") || []; f.push(d); e.data("$binding", f); b || ba(e, "ng-binding"); a.$watch(d, function (a) { c[0].nodeValue = a }) } } }) } function z(a, b) { if ("srcdoc" == b) return t.HTML; var c = Pa(a); if ("xlinkHref" == b || "FORM" == c && "action" == b || "IMG" != c && ("src" == b || "ngSrc" == b)) return t.RESOURCE_URL } function S(a, c, d, e) {
                    var f = b(d, !0); if (f) {
                        if ("multiple" === e && "SELECT" ===
                            Pa(a)) throw ja("selmulti", ia(a)); c.push({ priority: 100, compile: function () { return { pre: function (c, d, k) { d = k.$$observers || (k.$$observers = {}); if (g.test(e)) throw ja("nodomevents"); if (f = b(k[e], !0, z(a, e))) k[e] = f(c), (d[e] || (d[e] = [])).$$inter = !0, (k.$$observers && k.$$observers[e].$$scope || c).$watch(f, function (a, b) { "class" === e && a != b ? k.$updateClass(a, b) : k.$set(e, a) }) } } } })
                    }
                } function ra(a, b, c) {
                    var d = b[0], e = b.length, f = d.parentNode, g, k; if (a) for (g = 0, k = a.length; g < k; g++)if (a[g] == d) {
                    a[g++] = c; k = g + e - 1; for (var p = a.length; g <
                        p; g++ , k++)k < p ? a[g] = a[k] : delete a[g]; a.length -= e - 1; break
                    } f && f.replaceChild(c, d); a = X.createDocumentFragment(); a.appendChild(d); c[A.expando] = d[A.expando]; d = 1; for (e = b.length; d < e; d++)f = b[d], A(f).remove(), a.appendChild(f), delete b[d]; b[0] = c; b.length = 1
                } function rc(a, b) { return E(function () { return a.apply(null, arguments) }, a, b) } var Ob = function (a, b) { this.$$element = a; this.$attr = b || {} }; Ob.prototype = {
                    $normalize: qa, $addClass: function (a) { a && 0 < a.length && y.addClass(this.$$element, a) }, $removeClass: function (a) {
                    a && 0 <
                        a.length && y.removeClass(this.$$element, a)
                    }, $updateClass: function (a, b) { var c = sc(a, b), d = sc(b, a); 0 === c.length ? y.removeClass(this.$$element, d) : 0 === d.length ? y.addClass(this.$$element, c) : y.setClass(this.$$element, c, d) }, $set: function (a, b, c, d) {
                        var e = oc(this.$$element[0], a); e && (this.$$element.prop(a, b), d = e); this[a] = b; d ? this.$attr[a] = d : (d = this.$attr[a]) || (this.$attr[a] = d = nb(a, "-")); e = Pa(this.$$element); if ("A" === e && "href" === a || "IMG" === e && "src" === a) this[a] = b = K(b, "src" === a); !1 !== c && (null === b || b === u ? this.$$element.removeAttr(d) :
                            this.$$element.attr(d, b)); (c = this.$$observers) && r(c[a], function (a) { try { a(b) } catch (c) { l(c) } })
                    }, $observe: function (a, b) { var c = this, d = c.$$observers || (c.$$observers = {}), e = d[a] || (d[a] = []); e.push(b); J.$evalAsync(function () { e.$$inter || b(c[a]) }); return b }
                }; var sa = b.startSymbol(), Ia = b.endSymbol(), W = "{{" == sa || "}}" == Ia ? ga : function (a) { return a.replace(/\{\{/g, sa).replace(/}}/g, Ia) }, U = /^ngAttr[A-Z]/; return B
        }]
    } function qa(b) { return ab(b.replace(we, "")) } function sc(b, a) {
        var c = "", d = b.split(/\s+/), e = a.split(/\s+/),
        f = 0; a: for (; f < d.length; f++) { for (var g = d[f], h = 0; h < e.length; h++)if (g == e[h]) continue a; c += (0 < c.length ? " " : "") + g } return c
    } function Od() {
        var b = {}, a = /^(\S+)(\s+as\s+(\w+))?$/; this.register = function (a, d) { Ea(a, "controller"); T(a) ? E(b, a) : b[a] = d }; this.$get = ["$injector", "$window", function (c, d) {
            return function (e, f) {
                var g, h, k; G(e) && (g = e.match(a), h = g[1], k = g[3], e = b.hasOwnProperty(h) ? b[h] : fc(f.$scope, h, !0) || fc(d, h, !0), Ya(e, h, !0)); g = c.instantiate(e, f); if (k) {
                    if (!f || "object" !== typeof f.$scope) throw z("$controller")("noscp",
                        h || e.name, k); f.$scope[k] = g
                } return g
            }
        }]
    } function Pd() { this.$get = ["$window", function (b) { return A(b.document) }] } function Qd() { this.$get = ["$log", function (b) { return function (a, c) { b.error.apply(b, arguments) } }] } function tc(b) { var a = {}, c, d, e; if (!b) return a; r(b.split("\n"), function (b) { e = b.indexOf(":"); c = x($(b.substr(0, e))); d = $(b.substr(e + 1)); c && (a[c] = a[c] ? a[c] + ", " + d : d) }); return a } function uc(b) { var a = T(b) ? b : u; return function (c) { a || (a = tc(b)); return c ? a[x(c)] || null : a } } function vc(b, a, c) {
        if (N(c)) return c(b,
            a); r(c, function (c) { b = c(b, a) }); return b
    } function Td() {
        var b = /^\s*(\[|\{[^\{])/, a = /[\}\]]\s*$/, c = /^\)\]\}',?\n/, d = { "Content-Type": "application/json;charset=utf-8" }, e = this.defaults = {
            transformResponse: [function (d) { G(d) && (d = d.replace(c, ""), b.test(d) && a.test(d) && (d = ac(d))); return d }], transformRequest: [function (a) { return T(a) && "[object File]" !== Ba.call(a) && "[object Blob]" !== Ba.call(a) ? oa(a) : a }], headers: { common: { Accept: "application/json, text/plain, */*" }, post: ha(d), put: ha(d), patch: ha(d) }, xsrfCookieName: "XSRF-TOKEN",
            xsrfHeaderName: "X-XSRF-TOKEN"
        }, f = this.interceptors = [], g = this.responseInterceptors = []; this.$get = ["$httpBackend", "$browser", "$cacheFactory", "$rootScope", "$q", "$injector", function (a, b, c, d, n, q) {
            function p(a) {
                function b(a) { var d = E({}, a, { data: vc(a.data, a.headers, c.transformResponse) }); return 200 <= a.status && 300 > a.status ? d : n.reject(d) } var c = { method: "get", transformRequest: e.transformRequest, transformResponse: e.transformResponse }, d = function (a) {
                    var b = e.headers, c = E({}, a.headers), d, f, b = E({}, b.common, b[x(a.method)]);
                    a: for (d in b) { a = x(d); for (f in c) if (x(f) === a) continue a; c[d] = b[d] } (function (a) { var b; r(a, function (c, d) { N(c) && (b = c(), null != b ? a[d] = b : delete a[d]) }) })(c); return c
                }(a); E(c, a); c.headers = d; c.method = La(c.method); var f = [function (a) { d = a.headers; var c = vc(a.data, uc(d), a.transformRequest); F(c) && r(d, function (a, b) { "content-type" === x(b) && delete d[b] }); F(a.withCredentials) && !F(e.withCredentials) && (a.withCredentials = e.withCredentials); return s(a, c, d).then(b, b) }, u], g = n.when(c); for (r(t, function (a) {
                (a.request || a.requestError) &&
                    f.unshift(a.request, a.requestError); (a.response || a.responseError) && f.push(a.response, a.responseError)
                }); f.length;) { a = f.shift(); var h = f.shift(), g = g.then(a, h) } g.success = function (a) { g.then(function (b) { a(b.data, b.status, b.headers, c) }); return g }; g.error = function (a) { g.then(null, function (b) { a(b.data, b.status, b.headers, c) }); return g }; return g
            } function s(c, f, g) {
                function m(a, b, c, e) { C && (200 <= a && 300 > a ? C.put(A, [a, b, tc(c), e]) : C.remove(A)); q(b, a, c, e); d.$$phase || d.$apply() } function q(a, b, d, e) {
                    b = Math.max(b, 0); (200 <=
                        b && 300 > b ? t.resolve : t.reject)({ data: a, status: b, headers: uc(d), config: c, statusText: e })
                } function s() { var a = Ta(p.pendingRequests, c); -1 !== a && p.pendingRequests.splice(a, 1) } var t = n.defer(), r = t.promise, C, I, A = J(c.url, c.params); p.pendingRequests.push(c); r.then(s, s); !c.cache && !e.cache || (!1 === c.cache || "GET" !== c.method && "JSONP" !== c.method) || (C = T(c.cache) ? c.cache : T(e.cache) ? e.cache : w); if (C) if (I = C.get(A), D(I)) { if (I && N(I.then)) return I.then(s, s), I; L(I) ? q(I[1], I[0], ha(I[2]), I[3]) : q(I, 200, {}, "OK") } else C.put(A, r); F(I) &&
                    ((I = Pb(c.url) ? b.cookies()[c.xsrfCookieName || e.xsrfCookieName] : u) && (g[c.xsrfHeaderName || e.xsrfHeaderName] = I), a(c.method, A, f, m, g, c.timeout, c.withCredentials, c.responseType)); return r
            } function J(a, b) { if (!b) return a; var c = []; Sc(b, function (a, b) { null === a || F(a) || (L(a) || (a = [a]), r(a, function (a) { T(a) && (a = va(a) ? a.toISOString() : oa(a)); c.push(Da(b) + "=" + Da(a)) })) }); 0 < c.length && (a += (-1 == a.indexOf("?") ? "?" : "&") + c.join("&")); return a } var w = c("$http"), t = []; r(f, function (a) { t.unshift(G(a) ? q.get(a) : q.invoke(a)) }); r(g,
                function (a, b) { var c = G(a) ? q.get(a) : q.invoke(a); t.splice(b, 0, { response: function (a) { return c(n.when(a)) }, responseError: function (a) { return c(n.reject(a)) } }) }); p.pendingRequests = []; (function (a) { r(arguments, function (a) { p[a] = function (b, c) { return p(E(c || {}, { method: a, url: b })) } }) })("get", "delete", "head", "jsonp"); (function (a) { r(arguments, function (a) { p[a] = function (b, c, d) { return p(E(d || {}, { method: a, url: b, data: c })) } }) })("post", "put", "patch"); p.defaults = e; return p
        }]
    } function xe(b) {
        if (8 >= R && (!b.match(/^(get|post|head|put|delete|options)$/i) ||
            !W.XMLHttpRequest)) return new W.ActiveXObject("Microsoft.XMLHTTP"); if (W.XMLHttpRequest) return new W.XMLHttpRequest; throw z("$httpBackend")("noxhr");
    } function Ud() { this.$get = ["$browser", "$window", "$document", function (b, a, c) { return ye(b, xe, b.defer, a.angular.callbacks, c[0]) }] } function ye(b, a, c, d, e) {
        function f(a, b, c) {
            var f = e.createElement("script"), g = null; f.type = "text/javascript"; f.src = a; f.async = !0; g = function (a) {
                bb(f, "load", g); bb(f, "error", g); e.body.removeChild(f); f = null; var h = -1, s = "unknown"; a && ("load" !==
                    a.type || d[b].called || (a = { type: "error" }), s = a.type, h = "error" === a.type ? 404 : 200); c && c(h, s)
            }; sb(f, "load", g); sb(f, "error", g); 8 >= R && (f.onreadystatechange = function () { G(f.readyState) && /loaded|complete/.test(f.readyState) && (f.onreadystatechange = null, g({ type: "load" })) }); e.body.appendChild(f); return g
        } var g = -1; return function (e, k, m, l, n, q, p, s) {
            function J() { t = g; K && K(); B && B.abort() } function w(a, d, e, f, g) { O && c.cancel(O); K = B = null; 0 === d && (d = e ? 200 : "file" == xa(k).protocol ? 404 : 0); a(1223 === d ? 204 : d, e, f, g || ""); b.$$completeOutstandingRequest(v) }
            var t; b.$$incOutstandingRequestCount(); k = k || b.url(); if ("jsonp" == x(e)) { var y = "_" + (d.counter++).toString(36); d[y] = function (a) { d[y].data = a; d[y].called = !0 }; var K = f(k.replace("JSON_CALLBACK", "angular.callbacks." + y), y, function (a, b) { w(l, a, d[y].data, "", b); d[y] = v }) } else {
                var B = a(e); B.open(e, k, !0); r(n, function (a, b) { D(a) && B.setRequestHeader(b, a) }); B.onreadystatechange = function () {
                    if (B && 4 == B.readyState) {
                        var a = null, b = null, c = ""; t !== g && (a = B.getAllResponseHeaders(), b = "response" in B ? B.response : B.responseText); t === g &&
                            10 > R || (c = B.statusText); w(l, t || B.status, b, a, c)
                    }
                }; p && (B.withCredentials = !0); if (s) try { B.responseType = s } catch (ba) { if ("json" !== s) throw ba; } B.send(m || null)
            } if (0 < q) var O = c(J, q); else q && N(q.then) && q.then(J)
        }
    } function Rd() {
        var b = "{{", a = "}}"; this.startSymbol = function (a) { return a ? (b = a, this) : b }; this.endSymbol = function (b) { return b ? (a = b, this) : a }; this.$get = ["$parse", "$exceptionHandler", "$sce", function (c, d, e) {
            function f(f, m, l) {
                for (var n, q, p = 0, s = [], J = f.length, w = !1, t = []; p < J;)-1 != (n = f.indexOf(b, p)) && -1 != (q = f.indexOf(a,
                    n + g)) ? (p != n && s.push(f.substring(p, n)), s.push(p = c(w = f.substring(n + g, q))), p.exp = w, p = q + h, w = !0) : (p != J && s.push(f.substring(p)), p = J); (J = s.length) || (s.push(""), J = 1); if (l && 1 < s.length) throw wc("noconcat", f); if (!m || w) return t.length = J, p = function (a) {
                        try { for (var b = 0, c = J, g; b < c; b++) { if ("function" == typeof (g = s[b])) if (g = g(a), g = l ? e.getTrusted(l, g) : e.valueOf(g), null == g) g = ""; else switch (typeof g) { case "string": break; case "number": g = "" + g; break; default: g = oa(g) }t[b] = g } return t.join("") } catch (h) {
                        a = wc("interr", f, h.toString()),
                            d(a)
                        }
                    }, p.exp = f, p.parts = s, p
            } var g = b.length, h = a.length; f.startSymbol = function () { return b }; f.endSymbol = function () { return a }; return f
        }]
    } function Sd() {
    this.$get = ["$rootScope", "$window", "$q", function (b, a, c) {
        function d(d, g, h, k) { var m = a.setInterval, l = a.clearInterval, n = c.defer(), q = n.promise, p = 0, s = D(k) && !k; h = D(h) ? h : 0; q.then(null, null, d); q.$$intervalId = m(function () { n.notify(p++); 0 < h && p >= h && (n.resolve(p), l(q.$$intervalId), delete e[q.$$intervalId]); s || b.$apply() }, g); e[q.$$intervalId] = n; return q } var e = {}; d.cancel =
            function (b) { return b && b.$$intervalId in e ? (e[b.$$intervalId].reject("canceled"), a.clearInterval(b.$$intervalId), delete e[b.$$intervalId], !0) : !1 }; return d
    }]
    } function ad() {
    this.$get = function () {
        return {
            id: "en-us", NUMBER_FORMATS: { DECIMAL_SEP: ".", GROUP_SEP: ",", PATTERNS: [{ minInt: 1, minFrac: 0, maxFrac: 3, posPre: "", posSuf: "", negPre: "-", negSuf: "", gSize: 3, lgSize: 3 }, { minInt: 1, minFrac: 2, maxFrac: 2, posPre: "\u00a4", posSuf: "", negPre: "(\u00a4", negSuf: ")", gSize: 3, lgSize: 3 }], CURRENCY_SYM: "$" }, DATETIME_FORMATS: {
                MONTH: "January February March April May June July August September October November December".split(" "),
                SHORTMONTH: "Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec".split(" "), DAY: "Sunday Monday Tuesday Wednesday Thursday Friday Saturday".split(" "), SHORTDAY: "Sun Mon Tue Wed Thu Fri Sat".split(" "), AMPMS: ["AM", "PM"], medium: "MMM d, y h:mm:ss a", "short": "M/d/yy h:mm a", fullDate: "EEEE, MMMM d, y", longDate: "MMMM d, y", mediumDate: "MMM d, y", shortDate: "M/d/yy", mediumTime: "h:mm:ss a", shortTime: "h:mm a"
            }, pluralCat: function (b) { return 1 === b ? "one" : "other" }
        }
    }
    } function Qb(b) {
        b = b.split("/"); for (var a = b.length; a--;)b[a] =
            mb(b[a]); return b.join("/")
    } function xc(b, a, c) { b = xa(b, c); a.$$protocol = b.protocol; a.$$host = b.hostname; a.$$port = U(b.port) || ze[b.protocol] || null } function yc(b, a, c) { var d = "/" !== b.charAt(0); d && (b = "/" + b); b = xa(b, c); a.$$path = decodeURIComponent(d && "/" === b.pathname.charAt(0) ? b.pathname.substring(1) : b.pathname); a.$$search = cc(b.search); a.$$hash = decodeURIComponent(b.hash); a.$$path && "/" != a.$$path.charAt(0) && (a.$$path = "/" + a.$$path) } function ta(b, a) { if (0 === a.indexOf(b)) return a.substr(b.length) } function Ga(b) {
        var a =
            b.indexOf("#"); return -1 == a ? b : b.substr(0, a)
    } function Rb(b) { return b.substr(0, Ga(b).lastIndexOf("/") + 1) } function zc(b, a) {
    this.$$html5 = !0; a = a || ""; var c = Rb(b); xc(b, this, b); this.$$parse = function (a) { var e = ta(c, a); if (!G(e)) throw Sb("ipthprfx", a, c); yc(e, this, b); this.$$path || (this.$$path = "/"); this.$$compose() }; this.$$compose = function () { var a = Cb(this.$$search), b = this.$$hash ? "#" + mb(this.$$hash) : ""; this.$$url = Qb(this.$$path) + (a ? "?" + a : "") + b; this.$$absUrl = c + this.$$url.substr(1) }; this.$$parseLinkUrl = function (d,
        e) { var f, g; (f = ta(b, d)) !== u ? (g = f, g = (f = ta(a, f)) !== u ? c + (ta("/", f) || f) : b + g) : (f = ta(c, d)) !== u ? g = c + f : c == d + "/" && (g = c); g && this.$$parse(g); return !!g }
    } function Tb(b, a) {
        var c = Rb(b); xc(b, this, b); this.$$parse = function (d) { var e = ta(b, d) || ta(c, d), e = "#" == e.charAt(0) ? ta(a, e) : this.$$html5 ? e : ""; if (!G(e)) throw Sb("ihshprfx", d, a); yc(e, this, b); d = this.$$path; var f = /^\/[A-Z]:(\/.*)/; 0 === e.indexOf(b) && (e = e.replace(b, "")); f.exec(e) || (d = (e = f.exec(d)) ? e[1] : d); this.$$path = d; this.$$compose() }; this.$$compose = function () {
            var c = Cb(this.$$search),
            e = this.$$hash ? "#" + mb(this.$$hash) : ""; this.$$url = Qb(this.$$path) + (c ? "?" + c : "") + e; this.$$absUrl = b + (this.$$url ? a + this.$$url : "")
        }; this.$$parseLinkUrl = function (a, c) { return Ga(b) == Ga(a) ? (this.$$parse(a), !0) : !1 }
    } function Ac(b, a) {
    this.$$html5 = !0; Tb.apply(this, arguments); var c = Rb(b); this.$$parseLinkUrl = function (d, e) { var f, g; b == Ga(d) ? f = d : (g = ta(c, d)) ? f = b + a + g : c === d + "/" && (f = c); f && this.$$parse(f); return !!f }; this.$$compose = function () {
        var c = Cb(this.$$search), e = this.$$hash ? "#" + mb(this.$$hash) : ""; this.$$url = Qb(this.$$path) +
            (c ? "?" + c : "") + e; this.$$absUrl = b + a + this.$$url
    }
    } function tb(b) { return function () { return this[b] } } function Bc(b, a) { return function (c) { if (F(c)) return this[b]; this[b] = a(c); this.$$compose(); return this } } function Vd() {
        var b = "", a = !1; this.hashPrefix = function (a) { return D(a) ? (b = a, this) : b }; this.html5Mode = function (b) { return D(b) ? (a = b, this) : a }; this.$get = ["$rootScope", "$browser", "$sniffer", "$rootElement", function (c, d, e, f) {
            function g(a) { c.$broadcast("$locationChangeSuccess", h.absUrl(), a) } var h, k = d.baseHref(), m = d.url();
            a ? (k = m.substring(0, m.indexOf("/", m.indexOf("//") + 2)) + (k || "/"), e = e.history ? zc : Ac) : (k = Ga(m), e = Tb); h = new e(k, "#" + b); h.$$parseLinkUrl(m, m); var l = /^\s*(javascript|mailto):/i; f.on("click", function (a) {
                if (!a.ctrlKey && !a.metaKey && 2 != a.which) {
                    for (var b = A(a.target); "a" !== x(b[0].nodeName);)if (b[0] === f[0] || !(b = b.parent())[0]) return; var e = b.prop("href"), g = b.attr("href") || b.attr("xlink:href"); T(e) && "[object SVGAnimatedString]" === e.toString() && (e = xa(e.animVal).href); l.test(e) || (!e || (b.attr("target") || a.isDefaultPrevented()) ||
                        !h.$$parseLinkUrl(e, g)) || (a.preventDefault(), h.absUrl() != d.url() && (c.$apply(), W.angular["ff-684208-preventDefault"] = !0))
                }
            }); h.absUrl() != m && d.url(h.absUrl(), !0); d.onUrlChange(function (a) { h.absUrl() != a && (c.$evalAsync(function () { var b = h.absUrl(); h.$$parse(a); c.$broadcast("$locationChangeStart", a, b).defaultPrevented ? (h.$$parse(b), d.url(b)) : g(b) }), c.$$phase || c.$digest()) }); var n = 0; c.$watch(function () {
                var a = d.url(), b = h.$$replace; n && a == h.absUrl() || (n++ , c.$evalAsync(function () {
                    c.$broadcast("$locationChangeStart",
                        h.absUrl(), a).defaultPrevented ? h.$$parse(a) : (d.url(h.absUrl(), b), g(a))
                })); h.$$replace = !1; return n
            }); return h
        }]
    } function Wd() {
        var b = !0, a = this; this.debugEnabled = function (a) { return D(a) ? (b = a, this) : b }; this.$get = ["$window", function (c) {
            function d(a) { a instanceof Error && (a.stack ? a = a.message && -1 === a.stack.indexOf(a.message) ? "Error: " + a.message + "\n" + a.stack : a.stack : a.sourceURL && (a = a.message + "\n" + a.sourceURL + ":" + a.line)); return a } function e(a) {
                var b = c.console || {}, e = b[a] || b.log || v; a = !1; try { a = !!e.apply } catch (k) { } return a ?
                    function () { var a = []; r(arguments, function (b) { a.push(d(b)) }); return e.apply(b, a) } : function (a, b) { e(a, null == b ? "" : b) }
            } return { log: e("log"), info: e("info"), warn: e("warn"), error: e("error"), debug: function () { var c = e("debug"); return function () { b && c.apply(a, arguments) } }() }
        }]
    } function ka(b, a) { if ("__defineGetter__" === b || "__defineSetter__" === b || "__lookupGetter__" === b || "__lookupSetter__" === b || "__proto__" === b) throw la("isecfld", a); return b } function ma(b, a) {
        if (b) {
            if (b.constructor === b) throw la("isecfn", a); if (b.document &&
                b.location && b.alert && b.setInterval) throw la("isecwindow", a); if (b.children && (b.nodeName || b.prop && b.attr && b.find)) throw la("isecdom", a); if (b === Object) throw la("isecobj", a);
        } return b
    } function ub(b, a, c, d, e) { ma(b, d); e = e || {}; a = a.split("."); for (var f, g = 0; 1 < a.length; g++) { f = ka(a.shift(), d); var h = ma(b[f], d); h || (h = {}, b[f] = h); b = h; b.then && e.unwrapPromises && (ya(d), "$$v" in b || function (a) { a.then(function (b) { a.$$v = b }) }(b), b.$$v === u && (b.$$v = {}), b = b.$$v) } f = ka(a.shift(), d); ma(b[f], d); return b[f] = c } function Qa(b) {
        return "constructor" ==
            b
    } function Cc(b, a, c, d, e, f, g) {
        ka(b, f); ka(a, f); ka(c, f); ka(d, f); ka(e, f); var h = function (a) { return ma(a, f) }, k = g.expensiveChecks, m = k || Qa(b) ? h : ga, l = k || Qa(a) ? h : ga, n = k || Qa(c) ? h : ga, q = k || Qa(d) ? h : ga, p = k || Qa(e) ? h : ga; return g.unwrapPromises ? function (g, h) {
            var k = h && h.hasOwnProperty(b) ? h : g, t; if (null == k) return k; (k = m(k[b])) && k.then && (ya(f), "$$v" in k || (t = k, t.$$v = u, t.then(function (a) { t.$$v = m(a) })), k = m(k.$$v)); if (!a) return k; if (null == k) return u; (k = l(k[a])) && k.then && (ya(f), "$$v" in k || (t = k, t.$$v = u, t.then(function (a) {
            t.$$v =
                l(a)
            })), k = l(k.$$v)); if (!c) return k; if (null == k) return u; (k = n(k[c])) && k.then && (ya(f), "$$v" in k || (t = k, t.$$v = u, t.then(function (a) { t.$$v = n(a) })), k = n(k.$$v)); if (!d) return k; if (null == k) return u; (k = q(k[d])) && k.then && (ya(f), "$$v" in k || (t = k, t.$$v = u, t.then(function (a) { t.$$v = q(a) })), k = q(k.$$v)); if (!e) return k; if (null == k) return u; (k = p(k[e])) && k.then && (ya(f), "$$v" in k || (t = k, t.$$v = u, t.then(function (a) { t.$$v = p(a) })), k = p(k.$$v)); return k
        } : function (f, g) {
            var h = g && g.hasOwnProperty(b) ? g : f; if (null == h) return h; h = m(h[b]);
            if (!a) return h; if (null == h) return u; h = l(h[a]); if (!c) return h; if (null == h) return u; h = n(h[c]); if (!d) return h; if (null == h) return u; h = q(h[d]); return e ? null == h ? u : h = p(h[e]) : h
        }
    } function Ae(b, a) { return function (c, d) { return b(c, d, ya, ma, a) } } function Dc(b, a, c) {
        var d = a.expensiveChecks, e = d ? Be : Ce; if (e.hasOwnProperty(b)) return e[b]; var f = b.split("."), g = f.length, h; if (a.csp) h = 6 > g ? Cc(f[0], f[1], f[2], f[3], f[4], c, a) : function (b, d) { var e = 0, h; do h = Cc(f[e++], f[e++], f[e++], f[e++], f[e++], c, a)(b, d), d = u, b = h; while (e < g); return h };
        else {
            var k = "var p;\n"; d && (k += "s = eso(s, fe);\nl = eso(l, fe);\n"); var m = d; r(f, function (b, e) { ka(b, c); var f = (e ? "s" : '((l&&l.hasOwnProperty("' + b + '"))?l:s)') + '["' + b + '"]', g = d || Qa(b); g && (f = "eso(" + f + ", fe)", m = !0); k += "if(s == null) return undefined;\ns=" + f + ";\n"; a.unwrapPromises && (k += 'if (s && s.then) {\n pw("' + c.replace(/(["\r\n])/g, "\\$1") + '");\n if (!("$$v" in s)) {\n p=s;\n p.$$v = undefined;\n p.then(function(v) {p.$$v=' + (g ? "eso(v)" : "v") + ";});\n}\n s=" + (g ? "eso(s.$$v)" : "s.$$v") + "\n}\n") }); k += "return s;";
            h = new Function("s", "l", "pw", "eso", "fe", k); h.toString = aa(k); if (m || a.unwrapPromises) h = Ae(h, c)
        } "hasOwnProperty" !== b && (e[b] = h); return h
    } function Xd() {
        var b = {}, a = {}, c = { csp: !1, unwrapPromises: !1, logPromiseWarnings: !0, expensiveChecks: !1 }; this.unwrapPromises = function (a) { return D(a) ? (c.unwrapPromises = !!a, this) : c.unwrapPromises }; this.logPromiseWarnings = function (a) { return D(a) ? (c.logPromiseWarnings = a, this) : c.logPromiseWarnings }; this.$get = ["$filter", "$sniffer", "$log", function (d, e, f) {
        c.csp = e.csp; var g = {
            csp: c.csp,
            unwrapPromises: c.unwrapPromises, logPromiseWarnings: c.logPromiseWarnings, expensiveChecks: !0
        }; ya = function (a) { c.logPromiseWarnings && !Ec.hasOwnProperty(a) && (Ec[a] = !0, f.warn("[$parse] Promise found in the expression `" + a + "`. Automatic unwrapping of promises in Angular expressions is deprecated.")) }; return function (e, f) {
            var m; switch (typeof e) {
                case "string": var l = f ? a : b; if (l.hasOwnProperty(e)) return l[e]; m = f ? g : c; var n = new Ub(m); m = (new gb(n, d, m)).parse(e); "hasOwnProperty" !== e && (l[e] = m); return m; case "function": return e;
                default: return v
            }
        }
        }]
    } function Zd() { this.$get = ["$rootScope", "$exceptionHandler", function (b, a) { return De(function (a) { b.$evalAsync(a) }, a) }] } function De(b, a) {
        function c(a) { return a } function d(a) { return g(a) } var e = function () {
            var g = [], m, l; return l = {
                resolve: function (a) { if (g) { var c = g; g = u; m = f(a); c.length && b(function () { for (var a, b = 0, d = c.length; b < d; b++)a = c[b], m.then(a[0], a[1], a[2]) }) } }, reject: function (a) { l.resolve(h(a)) }, notify: function (a) {
                    if (g) {
                        var c = g; g.length && b(function () {
                            for (var b, d = 0, e = c.length; d < e; d++)b =
                                c[d], b[2](a)
                        })
                    }
                }, promise: {
                    then: function (b, f, h) { var l = e(), J = function (d) { try { l.resolve((N(b) ? b : c)(d)) } catch (e) { l.reject(e), a(e) } }, w = function (b) { try { l.resolve((N(f) ? f : d)(b)) } catch (c) { l.reject(c), a(c) } }, t = function (b) { try { l.notify((N(h) ? h : c)(b)) } catch (d) { a(d) } }; g ? g.push([J, w, t]) : m.then(J, w, t); return l.promise }, "catch": function (a) { return this.then(null, a) }, "finally": function (a) {
                        function b(a, c) { var d = e(); c ? d.resolve(a) : d.reject(a); return d.promise } function d(e, f) {
                            var g = null; try { g = (a || c)() } catch (h) {
                                return b(h,
                                    !1)
                            } return g && N(g.then) ? g.then(function () { return b(e, f) }, function (a) { return b(a, !1) }) : b(e, f)
                        } return this.then(function (a) { return d(a, !0) }, function (a) { return d(a, !1) })
                    }
                }
            }
        }, f = function (a) { return a && N(a.then) ? a : { then: function (c) { var d = e(); b(function () { d.resolve(c(a)) }); return d.promise } } }, g = function (a) { var b = e(); b.reject(a); return b.promise }, h = function (c) { return { then: function (f, g) { var h = e(); b(function () { try { h.resolve((N(g) ? g : d)(c)) } catch (b) { h.reject(b), a(b) } }); return h.promise } } }; return {
            defer: e, reject: g,
            when: function (h, m, l, n) { var q = e(), p, s = function (b) { try { return (N(m) ? m : c)(b) } catch (d) { return a(d), g(d) } }, J = function (b) { try { return (N(l) ? l : d)(b) } catch (c) { return a(c), g(c) } }, w = function (b) { try { return (N(n) ? n : c)(b) } catch (d) { a(d) } }; b(function () { f(h).then(function (a) { p || (p = !0, q.resolve(f(a).then(s, J, w))) }, function (a) { p || (p = !0, q.resolve(J(a))) }, function (a) { p || q.notify(w(a)) }) }); return q.promise }, all: function (a) {
                var b = e(), c = 0, d = L(a) ? [] : {}; r(a, function (a, e) {
                    c++; f(a).then(function (a) {
                        d.hasOwnProperty(e) || (d[e] = a,
                            --c || b.resolve(d))
                    }, function (a) { d.hasOwnProperty(e) || b.reject(a) })
                }); 0 === c && b.resolve(d); return b.promise
            }
        }
    } function fe() {
    this.$get = ["$window", "$timeout", function (b, a) {
        var c = b.requestAnimationFrame || b.webkitRequestAnimationFrame || b.mozRequestAnimationFrame, d = b.cancelAnimationFrame || b.webkitCancelAnimationFrame || b.mozCancelAnimationFrame || b.webkitCancelRequestAnimationFrame, e = !!c, f = e ? function (a) { var b = c(a); return function () { d(b) } } : function (b) { var c = a(b, 16.66, !1); return function () { a.cancel(c) } }; f.supported =
            e; return f
    }]
    } function Yd() {
        var b = 10, a = z("$rootScope"), c = null; this.digestTtl = function (a) { arguments.length && (b = a); return b }; this.$get = ["$injector", "$exceptionHandler", "$parse", "$browser", function (d, e, f, g) {
            function h() {
            this.$id = ib(); this.$$phase = this.$parent = this.$$watchers = this.$$nextSibling = this.$$prevSibling = this.$$childHead = this.$$childTail = null; this["this"] = this.$root = this; this.$$destroyed = !1; this.$$asyncQueue = []; this.$$postDigestQueue = []; this.$$listeners = {}; this.$$listenerCount = {}; this.$$isolateBindings =
                {}
            } function k(b) { if (q.$$phase) throw a("inprog", q.$$phase); q.$$phase = b } function m(a, b) { var c = f(a); Ya(c, b); return c } function l(a, b, c) { do a.$$listenerCount[c] -= b, 0 === a.$$listenerCount[c] && delete a.$$listenerCount[c]; while (a = a.$parent) } function n() { } h.prototype = {
                constructor: h, $new: function (a) {
                    a ? (a = new h, a.$root = this.$root, a.$$asyncQueue = this.$$asyncQueue, a.$$postDigestQueue = this.$$postDigestQueue) : (this.$$childScopeClass || (this.$$childScopeClass = function () {
                    this.$$watchers = this.$$nextSibling = this.$$childHead =
                        this.$$childTail = null; this.$$listeners = {}; this.$$listenerCount = {}; this.$id = ib(); this.$$childScopeClass = null
                    }, this.$$childScopeClass.prototype = this), a = new this.$$childScopeClass); a["this"] = a; a.$parent = this; a.$$prevSibling = this.$$childTail; this.$$childHead ? this.$$childTail = this.$$childTail.$$nextSibling = a : this.$$childHead = this.$$childTail = a; return a
                }, $watch: function (a, b, d) {
                    var e = m(a, "watch"), f = this.$$watchers, g = { fn: b, last: n, get: e, exp: a, eq: !!d }; c = null; if (!N(b)) {
                        var h = m(b || v, "listener"); g.fn = function (a,
                            b, c) { h(c) }
                    } if ("string" == typeof a && e.constant) { var k = g.fn; g.fn = function (a, b, c) { k.call(this, a, b, c); Ua(f, g) } } f || (f = this.$$watchers = []); f.unshift(g); return function () { Ua(f, g); c = null }
                }, $watchCollection: function (a, b) {
                    var c = this, d, e, g, h = 1 < b.length, k = 0, l = f(a), m = [], n = {}, q = !0, r = 0; return this.$watch(function () {
                        d = l(c); var a, b, f; if (T(d)) if (Sa(d)) for (e !== m && (e = m, r = e.length = 0, k++), a = d.length, r !== a && (k++ , e.length = r = a), b = 0; b < a; b++)f = e[b] !== e[b] && d[b] !== d[b], f || e[b] === d[b] || (k++ , e[b] = d[b]); else {
                        e !== n && (e = n = {}, r = 0,
                            k++); a = 0; for (b in d) d.hasOwnProperty(b) && (a++ , e.hasOwnProperty(b) ? (f = e[b] !== e[b] && d[b] !== d[b], f || e[b] === d[b] || (k++ , e[b] = d[b])) : (r++ , e[b] = d[b], k++)); if (r > a) for (b in k++ , e) e.hasOwnProperty(b) && !d.hasOwnProperty(b) && (r-- , delete e[b])
                        } else e !== d && (e = d, k++); return k
                    }, function () { q ? (q = !1, b(d, d, c)) : b(d, g, c); if (h) if (T(d)) if (Sa(d)) { g = Array(d.length); for (var a = 0; a < d.length; a++)g[a] = d[a] } else for (a in g = {}, d) lb.call(d, a) && (g[a] = d[a]); else g = d })
                }, $digest: function () {
                    var d, f, h, l, m = this.$$asyncQueue, r = this.$$postDigestQueue,
                    K, B, u = b, O, M = [], A, P, C; k("$digest"); g.$$checkUrlChange(); c = null; do {
                        B = !1; for (O = this; m.length;) { try { C = m.shift(), C.scope.$eval(C.expression) } catch (I) { q.$$phase = null, e(I) } c = null } a: do {
                            if (l = O.$$watchers) for (K = l.length; K--;)try {
                                if (d = l[K]) if ((f = d.get(O)) !== (h = d.last) && !(d.eq ? Ca(f, h) : "number" === typeof f && "number" === typeof h && isNaN(f) && isNaN(h))) B = !0, c = d, d.last = d.eq ? Ka(f, null) : f, d.fn(f, h === n ? f : h, O), 5 > u && (A = 4 - u, M[A] || (M[A] = []), P = N(d.exp) ? "fn: " + (d.exp.name || d.exp.toString()) : d.exp, P += "; newVal: " + oa(f) + "; oldVal: " +
                                    oa(h), M[A].push(P)); else if (d === c) { B = !1; break a }
                            } catch (D) { q.$$phase = null, e(D) } if (!(l = O.$$childHead || O !== this && O.$$nextSibling)) for (; O !== this && !(l = O.$$nextSibling);)O = O.$parent
                        } while (O = l); if ((B || m.length) && !u--) throw q.$$phase = null, a("infdig", b, oa(M));
                    } while (B || m.length); for (q.$$phase = null; r.length;)try { r.shift()() } catch (x) { e(x) }
                }, $destroy: function () {
                    if (!this.$$destroyed) {
                        var a = this.$parent; this.$broadcast("$destroy"); this.$$destroyed = !0; this !== q && (r(this.$$listenerCount, Bb(null, l, this)), a.$$childHead ==
                            this && (a.$$childHead = this.$$nextSibling), a.$$childTail == this && (a.$$childTail = this.$$prevSibling), this.$$prevSibling && (this.$$prevSibling.$$nextSibling = this.$$nextSibling), this.$$nextSibling && (this.$$nextSibling.$$prevSibling = this.$$prevSibling), this.$parent = this.$$nextSibling = this.$$prevSibling = this.$$childHead = this.$$childTail = this.$root = null, this.$$listeners = {}, this.$$watchers = this.$$asyncQueue = this.$$postDigestQueue = [], this.$destroy = this.$digest = this.$apply = v, this.$on = this.$watch = function () { return v })
                    }
                },
                $eval: function (a, b) { return f(a)(this, b) }, $evalAsync: function (a) { q.$$phase || q.$$asyncQueue.length || g.defer(function () { q.$$asyncQueue.length && q.$digest() }); this.$$asyncQueue.push({ scope: this, expression: a }) }, $$postDigest: function (a) { this.$$postDigestQueue.push(a) }, $apply: function (a) { try { return k("$apply"), this.$eval(a) } catch (b) { e(b) } finally { q.$$phase = null; try { q.$digest() } catch (c) { throw e(c), c; } } }, $on: function (a, b) {
                    var c = this.$$listeners[a]; c || (this.$$listeners[a] = c = []); c.push(b); var d = this; do d.$$listenerCount[a] ||
                        (d.$$listenerCount[a] = 0), d.$$listenerCount[a]++; while (d = d.$parent); var e = this; return function () { var d = Ta(c, b); -1 !== d && (c[d] = null, l(e, 1, a)) }
                }, $emit: function (a, b) {
                    var c = [], d, f = this, g = !1, h = { name: a, targetScope: f, stopPropagation: function () { g = !0 }, preventDefault: function () { h.defaultPrevented = !0 }, defaultPrevented: !1 }, k = [h].concat(wa.call(arguments, 1)), l, m; do {
                        d = f.$$listeners[a] || c; h.currentScope = f; l = 0; for (m = d.length; l < m; l++)if (d[l]) try { d[l].apply(null, k) } catch (n) { e(n) } else d.splice(l, 1), l-- , m--; if (g) break;
                        f = f.$parent
                    } while (f); return h
                }, $broadcast: function (a, b) { for (var c = this, d = this, f = { name: a, targetScope: this, preventDefault: function () { f.defaultPrevented = !0 }, defaultPrevented: !1 }, g = [f].concat(wa.call(arguments, 1)), h, k; c = d;) { f.currentScope = c; d = c.$$listeners[a] || []; h = 0; for (k = d.length; h < k; h++)if (d[h]) try { d[h].apply(null, g) } catch (l) { e(l) } else d.splice(h, 1), h-- , k--; if (!(d = c.$$listenerCount[a] && c.$$childHead || c !== this && c.$$nextSibling)) for (; c !== this && !(d = c.$$nextSibling);)c = c.$parent } return f }
            }; var q = new h;
            return q
        }]
    } function bd() { var b = /^\s*(https?|ftp|mailto|tel|file):/, a = /^\s*((https?|ftp|file):|data:image\/)/; this.aHrefSanitizationWhitelist = function (a) { return D(a) ? (b = a, this) : b }; this.imgSrcSanitizationWhitelist = function (b) { return D(b) ? (a = b, this) : a }; this.$get = function () { return function (c, d) { var e = d ? a : b, f; if (!R || 8 <= R) if (f = xa(c).href, "" !== f && !f.match(e)) return "unsafe:" + f; return c } } } function Ee(b) {
        if ("self" === b) return b; if (G(b)) {
            if (-1 < b.indexOf("***")) throw za("iwcard", b); b = b.replace(/([-()\[\]{}+?*.$\^|,:#<!\\])/g,
                "\\$1").replace(/\x08/g, "\\x08").replace("\\*\\*", ".*").replace("\\*", "[^:/.?&;]*"); return RegExp("^" + b + "$")
        } if (kb(b)) return RegExp("^" + b.source + "$"); throw za("imatcher");
    } function Fc(b) { var a = []; D(b) && r(b, function (b) { a.push(Ee(b)) }); return a } function ae() {
    this.SCE_CONTEXTS = fa; var b = ["self"], a = []; this.resourceUrlWhitelist = function (a) { arguments.length && (b = Fc(a)); return b }; this.resourceUrlBlacklist = function (b) { arguments.length && (a = Fc(b)); return a }; this.$get = ["$injector", function (c) {
        function d(a) {
            var b =
                function (a) { this.$$unwrapTrustedValue = function () { return a } }; a && (b.prototype = new a); b.prototype.valueOf = function () { return this.$$unwrapTrustedValue() }; b.prototype.toString = function () { return this.$$unwrapTrustedValue().toString() }; return b
        } var e = function (a) { throw za("unsafe"); }; c.has("$sanitize") && (e = c.get("$sanitize")); var f = d(), g = {}; g[fa.HTML] = d(f); g[fa.CSS] = d(f); g[fa.URL] = d(f); g[fa.JS] = d(f); g[fa.RESOURCE_URL] = d(g[fa.URL]); return {
            trustAs: function (a, b) {
                var c = g.hasOwnProperty(a) ? g[a] : null; if (!c) throw za("icontext",
                    a, b); if (null === b || b === u || "" === b) return b; if ("string" !== typeof b) throw za("itype", a); return new c(b)
            }, getTrusted: function (c, d) {
                if (null === d || d === u || "" === d) return d; var f = g.hasOwnProperty(c) ? g[c] : null; if (f && d instanceof f) return d.$$unwrapTrustedValue(); if (c === fa.RESOURCE_URL) {
                    var f = xa(d.toString()), l, n, q = !1; l = 0; for (n = b.length; l < n; l++)if ("self" === b[l] ? Pb(f) : b[l].exec(f.href)) { q = !0; break } if (q) for (l = 0, n = a.length; l < n; l++)if ("self" === a[l] ? Pb(f) : a[l].exec(f.href)) { q = !1; break } if (q) return d; throw za("insecurl",
                        d.toString());
                } if (c === fa.HTML) return e(d); throw za("unsafe");
            }, valueOf: function (a) { return a instanceof f ? a.$$unwrapTrustedValue() : a }
        }
    }]
    } function $d() {
        var b = !0; this.enabled = function (a) { arguments.length && (b = !!a); return b }; this.$get = ["$parse", "$sniffer", "$sceDelegate", function (a, c, d) {
            if (b && c.msie && 8 > c.msieDocumentMode) throw za("iequirks"); var e = ha(fa); e.isEnabled = function () { return b }; e.trustAs = d.trustAs; e.getTrusted = d.getTrusted; e.valueOf = d.valueOf; b || (e.trustAs = e.getTrusted = function (a, b) { return b },
                e.valueOf = ga); e.parseAs = function (b, c) { var d = a(c); return d.literal && d.constant ? d : function (a, c) { return e.getTrusted(b, d(a, c)) } }; var f = e.parseAs, g = e.getTrusted, h = e.trustAs; r(fa, function (a, b) { var c = x(b); e[ab("parse_as_" + c)] = function (b) { return f(a, b) }; e[ab("get_trusted_" + c)] = function (b) { return g(a, b) }; e[ab("trust_as_" + c)] = function (b) { return h(a, b) } }); return e
        }]
    } function be() {
    this.$get = ["$window", "$document", function (b, a) {
        var c = {}, d = U((/android (\d+)/.exec(x((b.navigator || {}).userAgent)) || [])[1]), e = /Boxee/i.test((b.navigator ||
            {}).userAgent), f = a[0] || {}, g = f.documentMode, h, k = /^(Moz|webkit|O|ms)(?=[A-Z])/, m = f.body && f.body.style, l = !1, n = !1; if (m) { for (var q in m) if (l = k.exec(q)) { h = l[0]; h = h.substr(0, 1).toUpperCase() + h.substr(1); break } h || (h = "WebkitOpacity" in m && "webkit"); l = !!("transition" in m || h + "Transition" in m); n = !!("animation" in m || h + "Animation" in m); !d || l && n || (l = G(f.body.style.webkitTransition), n = G(f.body.style.webkitAnimation)) } return {
                history: !(!b.history || !b.history.pushState || 4 > d || e), hashchange: "onhashchange" in b && (!g || 7 <
                    g), hasEvent: function (a) { if ("input" == a && 9 == R) return !1; if (F(c[a])) { var b = f.createElement("div"); c[a] = "on" + a in b } return c[a] }, csp: Za(), vendorPrefix: h, transitions: l, animations: n, android: d, msie: R, msieDocumentMode: g
            }
    }]
    } function de() {
    this.$get = ["$rootScope", "$browser", "$q", "$exceptionHandler", function (b, a, c, d) {
        function e(e, h, k) {
            var m = c.defer(), l = m.promise, n = D(k) && !k; h = a.defer(function () { try { m.resolve(e()) } catch (a) { m.reject(a), d(a) } finally { delete f[l.$$timeoutId] } n || b.$apply() }, h); l.$$timeoutId = h; f[h] = m;
            return l
        } var f = {}; e.cancel = function (b) { return b && b.$$timeoutId in f ? (f[b.$$timeoutId].reject("canceled"), delete f[b.$$timeoutId], a.defer.cancel(b.$$timeoutId)) : !1 }; return e
    }]
    } function xa(b, a) {
        var c = b; R && (Y.setAttribute("href", c), c = Y.href); Y.setAttribute("href", c); return {
            href: Y.href, protocol: Y.protocol ? Y.protocol.replace(/:$/, "") : "", host: Y.host, search: Y.search ? Y.search.replace(/^\?/, "") : "", hash: Y.hash ? Y.hash.replace(/^#/, "") : "", hostname: Y.hostname, port: Y.port, pathname: "/" === Y.pathname.charAt(0) ? Y.pathname :
                "/" + Y.pathname
        }
    } function Pb(b) { b = G(b) ? xa(b) : b; return b.protocol === Gc.protocol && b.host === Gc.host } function ee() { this.$get = aa(W) } function kc(b) { function a(d, e) { if (T(d)) { var f = {}; r(d, function (b, c) { f[c] = a(c, b) }); return f } return b.factory(d + c, e) } var c = "Filter"; this.register = a; this.$get = ["$injector", function (a) { return function (b) { return a.get(b + c) } }]; a("currency", Hc); a("date", Ic); a("filter", Fe); a("json", Ge); a("limitTo", He); a("lowercase", Ie); a("number", Jc); a("orderBy", Kc); a("uppercase", Je) } function Fe() {
        return function (b,
            a, c) {
                if (!L(b)) return b; var d = typeof c, e = []; e.check = function (a) { for (var b = 0; b < e.length; b++)if (!e[b](a)) return !1; return !0 }; "function" !== d && (c = "boolean" === d && c ? function (a, b) { return Xa.equals(a, b) } : function (a, b) { if (a && b && "object" === typeof a && "object" === typeof b) { for (var d in a) if ("$" !== d.charAt(0) && lb.call(a, d) && c(a[d], b[d])) return !0; return !1 } b = ("" + b).toLowerCase(); return -1 < ("" + a).toLowerCase().indexOf(b) }); var f = function (a, b) {
                    if ("string" === typeof b && "!" === b.charAt(0)) return !f(a, b.substr(1)); switch (typeof a) {
                        case "boolean": case "number": case "string": return c(a,
                            b); case "object": switch (typeof b) { case "object": return c(a, b); default: for (var d in a) if ("$" !== d.charAt(0) && f(a[d], b)) return !0 }return !1; case "array": for (d = 0; d < a.length; d++)if (f(a[d], b)) return !0; return !1; default: return !1
                    }
                }; switch (typeof a) { case "boolean": case "number": case "string": a = { $: a }; case "object": for (var g in a) (function (b) { "undefined" !== typeof a[b] && e.push(function (c) { return f("$" == b ? c : c && c[b], a[b]) }) })(g); break; case "function": e.push(a); break; default: return b }d = []; for (g = 0; g < b.length; g++) {
                    var h =
                        b[g]; e.check(h) && d.push(h)
                } return d
        }
    } function Hc(b) { var a = b.NUMBER_FORMATS; return function (b, d) { F(d) && (d = a.CURRENCY_SYM); return Lc(b, a.PATTERNS[1], a.GROUP_SEP, a.DECIMAL_SEP, 2).replace(/\u00A4/g, d) } } function Jc(b) { var a = b.NUMBER_FORMATS; return function (b, d) { return Lc(b, a.PATTERNS[0], a.GROUP_SEP, a.DECIMAL_SEP, d) } } function Lc(b, a, c, d, e) {
        if (null == b || !isFinite(b) || T(b)) return ""; var f = 0 > b; b = Math.abs(b); var g = b + "", h = "", k = [], m = !1; if (-1 !== g.indexOf("e")) {
            var l = g.match(/([\d\.]+)e(-?)(\d+)/); l && "-" == l[2] &&
                l[3] > e + 1 ? (g = "0", b = 0) : (h = g, m = !0)
        } if (m) 0 < e && (-1 < b && 1 > b) && (h = b.toFixed(e)); else {
            g = (g.split(Mc)[1] || "").length; F(e) && (e = Math.min(Math.max(a.minFrac, g), a.maxFrac)); b = +(Math.round(+(b.toString() + "e" + e)).toString() + "e" + -e); 0 === b && (f = !1); b = ("" + b).split(Mc); g = b[0]; b = b[1] || ""; var l = 0, n = a.lgSize, q = a.gSize; if (g.length >= n + q) for (l = g.length - n, m = 0; m < l; m++)0 === (l - m) % q && 0 !== m && (h += c), h += g.charAt(m); for (m = l; m < g.length; m++)0 === (g.length - m) % n && 0 !== m && (h += c), h += g.charAt(m); for (; b.length < e;)b += "0"; e && "0" !== e && (h += d + b.substr(0,
                e))
        } k.push(f ? a.negPre : a.posPre); k.push(h); k.push(f ? a.negSuf : a.posSuf); return k.join("")
    } function Vb(b, a, c) { var d = ""; 0 > b && (d = "-", b = -b); for (b = "" + b; b.length < a;)b = "0" + b; c && (b = b.substr(b.length - a)); return d + b } function Z(b, a, c, d) { c = c || 0; return function (e) { e = e["get" + b](); if (0 < c || e > -c) e += c; 0 === e && -12 == c && (e = 12); return Vb(e, a, d) } } function vb(b, a) { return function (c, d) { var e = c["get" + b](), f = La(a ? "SHORT" + b : b); return d[f][e] } } function Ic(b) {
        function a(a) {
            var b; if (b = a.match(c)) {
                a = new Date(0); var f = 0, g = 0, h = b[8] ?
                    a.setUTCFullYear : a.setFullYear, k = b[8] ? a.setUTCHours : a.setHours; b[9] && (f = U(b[9] + b[10]), g = U(b[9] + b[11])); h.call(a, U(b[1]), U(b[2]) - 1, U(b[3])); f = U(b[4] || 0) - f; g = U(b[5] || 0) - g; h = U(b[6] || 0); b = Math.round(1E3 * parseFloat("0." + (b[7] || 0))); k.call(a, f, g, h, b)
            } return a
        } var c = /^(\d{4})-?(\d\d)-?(\d\d)(?:T(\d\d)(?::?(\d\d)(?::?(\d\d)(?:\.(\d+))?)?)?(Z|([+-])(\d\d):?(\d\d))?)?$/; return function (c, e) {
            var f = "", g = [], h, k; e = e || "mediumDate"; e = b.DATETIME_FORMATS[e] || e; G(c) && (c = Ke.test(c) ? U(c) : a(c)); jb(c) && (c = new Date(c));
            if (!va(c)) return c; for (; e;)(k = Le.exec(e)) ? (g = g.concat(wa.call(k, 1)), e = g.pop()) : (g.push(e), e = null); r(g, function (a) { h = Me[a]; f += h ? h(c, b.DATETIME_FORMATS) : a.replace(/(^'|'$)/g, "").replace(/''/g, "'") }); return f
        }
    } function Ge() { return function (b) { return oa(b, !0) } } function He() {
        return function (b, a) {
            if (!L(b) && !G(b)) return b; a = Infinity === Math.abs(Number(a)) ? Number(a) : U(a); if (G(b)) return a ? 0 <= a ? b.slice(0, a) : b.slice(a, b.length) : ""; var c = [], d, e; a > b.length ? a = b.length : a < -b.length && (a = -b.length); 0 < a ? (d = 0, e = a) : (d =
                b.length + a, e = b.length); for (; d < e; d++)c.push(b[d]); return c
        }
    } function Kc(b) {
        return function (a, c, d) {
            function e(a, b) { return Wa(b) ? function (b, c) { return a(c, b) } : a } function f(a, b) { var c = typeof a, d = typeof b; return c == d ? (va(a) && va(b) && (a = a.valueOf(), b = b.valueOf()), "string" == c && (a = a.toLowerCase(), b = b.toLowerCase()), a === b ? 0 : a < b ? -1 : 1) : c < d ? -1 : 1 } if (!Sa(a)) return a; c = L(c) ? c : [c]; 0 === c.length && (c = ["+"]); c = Uc(c, function (a) {
                var c = !1, d = a || ga; if (G(a)) {
                    if ("+" == a.charAt(0) || "-" == a.charAt(0)) c = "-" == a.charAt(0), a = a.substring(1);
                    if ("" === a) return e(function (a, b) { return f(a, b) }, c); d = b(a); if (d.constant) { var m = d(); return e(function (a, b) { return f(a[m], b[m]) }, c) }
                } return e(function (a, b) { return f(d(a), d(b)) }, c)
            }); return wa.call(a).sort(e(function (a, b) { for (var d = 0; d < c.length; d++) { var e = c[d](a, b); if (0 !== e) return e } return 0 }, d))
        }
    } function Aa(b) { N(b) && (b = { link: b }); b.restrict = b.restrict || "AC"; return aa(b) } function Nc(b, a, c, d) {
        function e(a, c) { c = c ? "-" + nb(c, "-") : ""; d.setClass(b, (a ? wb : xb) + c, (a ? xb : wb) + c) } var f = this, g = b.parent().controller("form") ||
            yb, h = 0, k = f.$error = {}, m = []; f.$name = a.name || a.ngForm; f.$dirty = !1; f.$pristine = !0; f.$valid = !0; f.$invalid = !1; g.$addControl(f); b.addClass(Ra); e(!0); f.$addControl = function (a) { Ea(a.$name, "input"); m.push(a); a.$name && (f[a.$name] = a) }; f.$removeControl = function (a) { a.$name && f[a.$name] === a && delete f[a.$name]; r(k, function (b, c) { f.$setValidity(c, !0, a) }); Ua(m, a) }; f.$setValidity = function (a, b, c) {
                var d = k[a]; if (b) d && (Ua(d, c), d.length || (h-- , h || (e(b), f.$valid = !0, f.$invalid = !1), k[a] = !1, e(!0, a), g.$setValidity(a, !0, f))); else {
                    h ||
                    e(b); if (d) { if (-1 != Ta(d, c)) return } else k[a] = d = [], h++ , e(!1, a), g.$setValidity(a, !1, f); d.push(c); f.$valid = !1; f.$invalid = !0
                }
            }; f.$setDirty = function () { d.removeClass(b, Ra); d.addClass(b, zb); f.$dirty = !0; f.$pristine = !1; g.$setDirty() }; f.$setPristine = function () { d.removeClass(b, zb); d.addClass(b, Ra); f.$dirty = !1; f.$pristine = !0; r(m, function (a) { a.$setPristine() }) }
    } function ua(b, a, c, d) { b.$setValidity(a, c); return c ? d : u } function Oc(b, a) { var c, d; if (a) for (c = 0; c < a.length; ++c)if (d = a[c], b[d]) return !0; return !1 } function Ne(b,
        a, c, d, e) { T(e) && (b.$$hasNativeValidators = !0, b.$parsers.push(function (f) { if (b.$error[a] || Oc(e, d) || !Oc(e, c)) return f; b.$setValidity(a, !1) })) } function Ab(b, a, c, d, e, f) {
            var g = a.prop(Oe), h = a[0].placeholder, k = {}, m = x(a[0].type); d.$$validityState = g; if (!e.android) { var l = !1; a.on("compositionstart", function (a) { l = !0 }); a.on("compositionend", function () { l = !1; n() }) } var n = function (e) {
                if (!l) {
                    var f = a.val(); if (R && "input" === (e || k).type && a[0].placeholder !== h) h = a[0].placeholder; else if ("password" !== m && Wa(c.ngTrim || "T") &&
                        (f = $(f)), e = g && d.$$hasNativeValidators, d.$viewValue !== f || "" === f && e) b.$root.$$phase ? d.$setViewValue(f) : b.$apply(function () { d.$setViewValue(f) })
                }
            }; if (e.hasEvent("input")) a.on("input", n); else { var q, p = function () { q || (q = f.defer(function () { n(); q = null })) }; a.on("keydown", function (a) { a = a.keyCode; 91 === a || (15 < a && 19 > a || 37 <= a && 40 >= a) || p() }); if (e.hasEvent("paste")) a.on("paste cut", p) } a.on("change", n); d.$render = function () { a.val(d.$isEmpty(d.$viewValue) ? "" : d.$viewValue) }; var s = c.ngPattern; s && ((e = s.match(/^\/(.*)\/([gim]*)$/)) ?
                (s = RegExp(e[1], e[2]), e = function (a) { return ua(d, "pattern", d.$isEmpty(a) || s.test(a), a) }) : e = function (c) { var e = b.$eval(s); if (!e || !e.test) throw z("ngPattern")("noregexp", s, e, ia(a)); return ua(d, "pattern", d.$isEmpty(c) || e.test(c), c) }, d.$formatters.push(e), d.$parsers.push(e)); if (c.ngMinlength) { var r = U(c.ngMinlength); e = function (a) { return ua(d, "minlength", d.$isEmpty(a) || a.length >= r, a) }; d.$parsers.push(e); d.$formatters.push(e) } if (c.ngMaxlength) {
                    var w = U(c.ngMaxlength); e = function (a) {
                        return ua(d, "maxlength", d.$isEmpty(a) ||
                            a.length <= w, a)
                    }; d.$parsers.push(e); d.$formatters.push(e)
                }
        } function Wb(b, a) {
            b = "ngClass" + b; return ["$animate", function (c) {
                function d(a, b) { var c = [], d = 0; a: for (; d < a.length; d++) { for (var e = a[d], l = 0; l < b.length; l++)if (e == b[l]) continue a; c.push(e) } return c } function e(a) { if (!L(a)) { if (G(a)) return a.split(" "); if (T(a)) { var b = []; r(a, function (a, c) { a && (b = b.concat(c.split(" "))) }); return b } } return a } return {
                    restrict: "AC", link: function (f, g, h) {
                        function k(a, b) {
                            var c = g.data("$classCounts") || {}, d = []; r(a, function (a) {
                                if (0 <
                                    b || c[a]) c[a] = (c[a] || 0) + b, c[a] === +(0 < b) && d.push(a)
                            }); g.data("$classCounts", c); return d.join(" ")
                        } function m(b) { if (!0 === a || f.$index % 2 === a) { var m = e(b || []); if (!l) { var p = k(m, 1); h.$addClass(p) } else if (!Ca(b, l)) { var s = e(l), p = d(m, s), m = d(s, m), m = k(m, -1), p = k(p, 1); 0 === p.length ? c.removeClass(g, m) : 0 === m.length ? c.addClass(g, p) : c.setClass(g, p, m) } } l = ha(b) } var l; f.$watch(h[b], m, !0); h.$observe("class", function (a) { m(f.$eval(h[b])) }); "ngClass" !== b && f.$watch("$index", function (c, d) {
                            var g = c & 1; if (g !== (d & 1)) {
                                var l = e(f.$eval(h[b]));
                                g === a ? (g = k(l, 1), h.$addClass(g)) : (g = k(l, -1), h.$removeClass(g))
                            }
                        })
                    }
                }
            }]
        } var Oe = "validity", x = function (b) { return G(b) ? b.toLowerCase() : b }, lb = Object.prototype.hasOwnProperty, La = function (b) { return G(b) ? b.toUpperCase() : b }, R, A, Fa, wa = [].slice, Pe = [].push, Ba = Object.prototype.toString, Va = z("ng"), Xa = W.angular || (W.angular = {}), $a, Pa, na = ["0", "0", "0"]; R = U((/msie (\d+)/.exec(x(navigator.userAgent)) || [])[1]); isNaN(R) && (R = U((/trident\/.*; rv:(\d+)/.exec(x(navigator.userAgent)) || [])[1])); v.$inject = []; ga.$inject = []; var L =
            function () { return N(Array.isArray) ? Array.isArray : function (b) { return "[object Array]" === Ba.call(b) } }(), $ = function () { return String.prototype.trim ? function (b) { return G(b) ? b.trim() : b } : function (b) { return G(b) ? b.replace(/^\s\s*/, "").replace(/\s\s*$/, "") : b } }(); Pa = 9 > R ? function (b) { b = b.nodeName ? b : b[0]; return b.scopeName && "HTML" != b.scopeName ? La(b.scopeName + ":" + b.nodeName) : b.nodeName } : function (b) { return b.nodeName ? b.nodeName : b[0].nodeName }; var Za = function () {
                if (D(Za.isActive_)) return Za.isActive_; var b = !(!X.querySelector("[ng-csp]") &&
                    !X.querySelector("[data-ng-csp]")); if (!b) try { new Function("") } catch (a) { b = !0 } return Za.isActive_ = b
            }, Xc = /[A-Z]/g, $c = { full: "1.2.28", major: 1, minor: 2, dot: 28, codeName: "finnish-disembarkation" }; S.expando = "ng339"; var cb = S.cache = {}, me = 1, sb = W.document.addEventListener ? function (b, a, c) { b.addEventListener(a, c, !1) } : function (b, a, c) { b.attachEvent("on" + a, c) }, bb = W.document.removeEventListener ? function (b, a, c) { b.removeEventListener(a, c, !1) } : function (b, a, c) { b.detachEvent("on" + a, c) }; S._data = function (b) {
                return this.cache[b[this.expando]] ||
                    {}
            }; var he = /([\:\-\_]+(.))/g, ie = /^moz([A-Z])/, Hb = z("jqLite"), je = /^<(\w+)\s*\/?>(?:<\/\1>|)$/, Ib = /<|&#?\w+;/, ke = /<([\w:]+)/, le = /<(?!area|br|col|embed|hr|img|input|link|meta|param)(([\w:]+)[^>]*)\/>/gi, da = { option: [1, '<select multiple="multiple">', "</select>"], thead: [1, "<table>", "</table>"], col: [2, "<table><colgroup>", "</colgroup></table>"], tr: [2, "<table><tbody>", "</tbody></table>"], td: [3, "<table><tbody><tr>", "</tr></tbody></table>"], _default: [0, "", ""] }; da.optgroup = da.option; da.tbody = da.tfoot = da.colgroup =
                da.caption = da.thead; da.th = da.td; var Oa = S.prototype = { ready: function (b) { function a() { c || (c = !0, b()) } var c = !1; "complete" === X.readyState ? setTimeout(a) : (this.on("DOMContentLoaded", a), S(W).on("load", a)) }, toString: function () { var b = []; r(this, function (a) { b.push("" + a) }); return "[" + b.join(", ") + "]" }, eq: function (b) { return 0 <= b ? A(this[b]) : A(this[this.length + b]) }, length: 0, push: Pe, sort: [].sort, splice: [].splice }, rb = {}; r("multiple selected checked disabled readOnly required open".split(" "), function (b) { rb[x(b)] = b });
    var pc = {}; r("input select option textarea button form details".split(" "), function (b) { pc[La(b)] = !0 }); r({ data: Mb, removeData: Lb }, function (b, a) { S[a] = b }); r({
        data: Mb, inheritedData: qb, scope: function (b) { return A.data(b, "$scope") || qb(b.parentNode || b, ["$isolateScope", "$scope"]) }, isolateScope: function (b) { return A.data(b, "$isolateScope") || A.data(b, "$isolateScopeNoTemplate") }, controller: mc, injector: function (b) { return qb(b, "$injector") }, removeAttr: function (b, a) { b.removeAttribute(a) }, hasClass: Nb, css: function (b,
            a, c) { a = ab(a); if (D(c)) b.style[a] = c; else { var d; 8 >= R && (d = b.currentStyle && b.currentStyle[a], "" === d && (d = "auto")); d = d || b.style[a]; 8 >= R && (d = "" === d ? u : d); return d } }, attr: function (b, a, c) { var d = x(a); if (rb[d]) if (D(c)) c ? (b[a] = !0, b.setAttribute(a, d)) : (b[a] = !1, b.removeAttribute(d)); else return b[a] || (b.attributes.getNamedItem(a) || v).specified ? d : u; else if (D(c)) b.setAttribute(a, c); else if (b.getAttribute) return b = b.getAttribute(a, 2), null === b ? u : b }, prop: function (b, a, c) { if (D(c)) b[a] = c; else return b[a] }, text: function () {
                function b(b,
                    d) { var e = a[b.nodeType]; if (F(d)) return e ? b[e] : ""; b[e] = d } var a = []; 9 > R ? (a[1] = "innerText", a[3] = "nodeValue") : a[1] = a[3] = "textContent"; b.$dv = ""; return b
            }(), val: function (b, a) { if (F(a)) { if ("SELECT" === Pa(b) && b.multiple) { var c = []; r(b.options, function (a) { a.selected && c.push(a.value || a.text) }); return 0 === c.length ? null : c } return b.value } b.value = a }, html: function (b, a) { if (F(a)) return b.innerHTML; for (var c = 0, d = b.childNodes; c < d.length; c++)Ma(d[c]); b.innerHTML = a }, empty: nc
    }, function (b, a) {
    S.prototype[a] = function (a, d) {
        var e,
        f, g = this.length; if (b !== nc && (2 == b.length && b !== Nb && b !== mc ? a : d) === u) { if (T(a)) { for (e = 0; e < g; e++)if (b === Mb) b(this[e], a); else for (f in a) b(this[e], f, a[f]); return this } e = b.$dv; g = e === u ? Math.min(g, 1) : g; for (f = 0; f < g; f++) { var h = b(this[f], a, d); e = e ? e + h : h } return e } for (e = 0; e < g; e++)b(this[e], a, d); return this
    }
    }); r({
        removeData: Lb, dealoc: Ma, on: function a(c, d, e, f) {
            if (D(f)) throw Hb("onargs"); var g = pa(c, "events"), h = pa(c, "handle"); g || pa(c, "events", g = {}); h || pa(c, "handle", h = ne(c, g)); r(d.split(" "), function (d) {
                var f = g[d]; if (!f) {
                    if ("mouseenter" ==
                        d || "mouseleave" == d) { var l = X.body.contains || X.body.compareDocumentPosition ? function (a, c) { var d = 9 === a.nodeType ? a.documentElement : a, e = c && c.parentNode; return a === e || !!(e && 1 === e.nodeType && (d.contains ? d.contains(e) : a.compareDocumentPosition && a.compareDocumentPosition(e) & 16)) } : function (a, c) { if (c) for (; c = c.parentNode;)if (c === a) return !0; return !1 }; g[d] = []; a(c, { mouseleave: "mouseout", mouseenter: "mouseover" }[d], function (a) { var c = a.relatedTarget; c && (c === this || l(this, c)) || h(a, d) }) } else sb(c, d, h), g[d] = []; f = g[d]
                } f.push(e)
            })
        },
        off: lc, one: function (a, c, d) { a = A(a); a.on(c, function f() { a.off(c, d); a.off(c, f) }); a.on(c, d) }, replaceWith: function (a, c) { var d, e = a.parentNode; Ma(a); r(new S(c), function (c) { d ? e.insertBefore(c, d.nextSibling) : e.replaceChild(c, a); d = c }) }, children: function (a) { var c = []; r(a.childNodes, function (a) { 1 === a.nodeType && c.push(a) }); return c }, contents: function (a) { return a.contentDocument || a.childNodes || [] }, append: function (a, c) { r(new S(c), function (c) { 1 !== a.nodeType && 11 !== a.nodeType || a.appendChild(c) }) }, prepend: function (a,
            c) { if (1 === a.nodeType) { var d = a.firstChild; r(new S(c), function (c) { a.insertBefore(c, d) }) } }, wrap: function (a, c) { c = A(c)[0]; var d = a.parentNode; d && d.replaceChild(c, a); c.appendChild(a) }, remove: function (a) { Ma(a); var c = a.parentNode; c && c.removeChild(a) }, after: function (a, c) { var d = a, e = a.parentNode; r(new S(c), function (a) { e.insertBefore(a, d.nextSibling); d = a }) }, addClass: pb, removeClass: ob, toggleClass: function (a, c, d) { c && r(c.split(" "), function (c) { var f = d; F(f) && (f = !Nb(a, c)); (f ? pb : ob)(a, c) }) }, parent: function (a) {
                return (a =
                    a.parentNode) && 11 !== a.nodeType ? a : null
            }, next: function (a) { if (a.nextElementSibling) return a.nextElementSibling; for (a = a.nextSibling; null != a && 1 !== a.nodeType;)a = a.nextSibling; return a }, find: function (a, c) { return a.getElementsByTagName ? a.getElementsByTagName(c) : [] }, clone: Kb, triggerHandler: function (a, c, d) {
                var e, f; e = c.type || c; var g = (pa(a, "events") || {})[e]; g && (e = { preventDefault: function () { this.defaultPrevented = !0 }, isDefaultPrevented: function () { return !0 === this.defaultPrevented }, stopPropagation: v, type: e, target: a },
                    c.type && (e = E(e, c)), c = ha(g), f = d ? [e].concat(d) : [e], r(c, function (c) { c.apply(a, f) }))
            }
    }, function (a, c) { S.prototype[c] = function (c, e, f) { for (var g, h = 0; h < this.length; h++)F(g) ? (g = a(this[h], c, e, f), D(g) && (g = A(g))) : Jb(g, a(this[h], c, e, f)); return D(g) ? g : this }; S.prototype.bind = S.prototype.on; S.prototype.unbind = S.prototype.off }); db.prototype = { put: function (a, c) { this[Na(a, this.nextUid)] = c }, get: function (a) { return this[Na(a, this.nextUid)] }, remove: function (a) { var c = this[a = Na(a, this.nextUid)]; delete this[a]; return c } }; var pe =
        /^function\s*[^\(]*\(\s*([^\)]*)\)/m, qe = /,/, re = /^\s*(_?)(\S+?)\1\s*$/, oe = /((\/\/.*$)|(\/\*[\s\S]*?\*\/))/mg, eb = z("$injector"), Qe = z("$animate"), Ld = ["$provide", function (a) {
        this.$$selectors = {}; this.register = function (c, d) { var e = c + "-animation"; if (c && "." != c.charAt(0)) throw Qe("notcsel", c); this.$$selectors[c.substr(1)] = e; a.factory(e, d) }; this.classNameFilter = function (a) { 1 === arguments.length && (this.$$classNameFilter = a instanceof RegExp ? a : null); return this.$$classNameFilter }; this.$get = ["$timeout", "$$asyncCallback",
            function (a, d) { return { enter: function (a, c, g, h) { g ? g.after(a) : (c && c[0] || (c = g.parent()), c.append(a)); h && d(h) }, leave: function (a, c) { a.remove(); c && d(c) }, move: function (a, c, d, h) { this.enter(a, c, d, h) }, addClass: function (a, c, g) { c = G(c) ? c : L(c) ? c.join(" ") : ""; r(a, function (a) { pb(a, c) }); g && d(g) }, removeClass: function (a, c, g) { c = G(c) ? c : L(c) ? c.join(" ") : ""; r(a, function (a) { ob(a, c) }); g && d(g) }, setClass: function (a, c, g, h) { r(a, function (a) { pb(a, c); ob(a, g) }); h && d(h) }, enabled: v } }]
        }], ja = z("$compile"); gc.$inject = ["$provide", "$$sanitizeUriProvider"];
    var we = /^(x[\:\-_]|data[\:\-_])/i, wc = z("$interpolate"), Re = /^([^\?#]*)(\?([^#]*))?(#(.*))?$/, ze = { http: 80, https: 443, ftp: 21 }, Sb = z("$location"); Ac.prototype = Tb.prototype = zc.prototype = {
        $$html5: !1, $$replace: !1, absUrl: tb("$$absUrl"), url: function (a) { if (F(a)) return this.$$url; a = Re.exec(a); a[1] && this.path(decodeURIComponent(a[1])); (a[2] || a[1]) && this.search(a[3] || ""); this.hash(a[5] || ""); return this }, protocol: tb("$$protocol"), host: tb("$$host"), port: tb("$$port"), path: Bc("$$path", function (a) {
            a = null !== a ? a.toString() :
                ""; return "/" == a.charAt(0) ? a : "/" + a
        }), search: function (a, c) { switch (arguments.length) { case 0: return this.$$search; case 1: if (G(a) || jb(a)) a = a.toString(), this.$$search = cc(a); else if (T(a)) r(a, function (c, e) { null == c && delete a[e] }), this.$$search = a; else throw Sb("isrcharg"); break; default: F(c) || null === c ? delete this.$$search[a] : this.$$search[a] = c }this.$$compose(); return this }, hash: Bc("$$hash", function (a) { return null !== a ? a.toString() : "" }), replace: function () { this.$$replace = !0; return this }
    }; var la = z("$parse"), Ec =
        {}, ya, Se = Function.prototype.call, Te = Function.prototype.apply, Pc = Function.prototype.bind, hb = {
            "null": function () { return null }, "true": function () { return !0 }, "false": function () { return !1 }, undefined: v, "+": function (a, c, d, e) { d = d(a, c); e = e(a, c); return D(d) ? D(e) ? d + e : d : D(e) ? e : u }, "-": function (a, c, d, e) { d = d(a, c); e = e(a, c); return (D(d) ? d : 0) - (D(e) ? e : 0) }, "*": function (a, c, d, e) { return d(a, c) * e(a, c) }, "/": function (a, c, d, e) { return d(a, c) / e(a, c) }, "%": function (a, c, d, e) { return d(a, c) % e(a, c) }, "^": function (a, c, d, e) {
                return d(a, c) ^
                    e(a, c)
            }, "=": v, "===": function (a, c, d, e) { return d(a, c) === e(a, c) }, "!==": function (a, c, d, e) { return d(a, c) !== e(a, c) }, "==": function (a, c, d, e) { return d(a, c) == e(a, c) }, "!=": function (a, c, d, e) { return d(a, c) != e(a, c) }, "<": function (a, c, d, e) { return d(a, c) < e(a, c) }, ">": function (a, c, d, e) { return d(a, c) > e(a, c) }, "<=": function (a, c, d, e) { return d(a, c) <= e(a, c) }, ">=": function (a, c, d, e) { return d(a, c) >= e(a, c) }, "&&": function (a, c, d, e) { return d(a, c) && e(a, c) }, "||": function (a, c, d, e) { return d(a, c) || e(a, c) }, "&": function (a, c, d, e) {
                return d(a,
                    c) & e(a, c)
            }, "|": function (a, c, d, e) { return e(a, c)(a, c, d(a, c)) }, "!": function (a, c, d) { return !d(a, c) }
        }, Ue = { n: "\n", f: "\f", r: "\r", t: "\t", v: "\v", "'": "'", '"': '"' }, Ub = function (a) { this.options = a }; Ub.prototype = {
            constructor: Ub, lex: function (a) {
            this.text = a; this.index = 0; this.ch = u; this.lastCh = ":"; for (this.tokens = []; this.index < this.text.length;) {
            this.ch = this.text.charAt(this.index); if (this.is("\"'")) this.readString(this.ch); else if (this.isNumber(this.ch) || this.is(".") && this.isNumber(this.peek())) this.readNumber(); else if (this.isIdent(this.ch)) this.readIdent();
            else if (this.is("(){}[].,;:?")) this.tokens.push({ index: this.index, text: this.ch }), this.index++; else if (this.isWhitespace(this.ch)) { this.index++; continue } else {
                a = this.ch + this.peek(); var c = a + this.peek(2), d = hb[this.ch], e = hb[a], f = hb[c]; f ? (this.tokens.push({ index: this.index, text: c, fn: f }), this.index += 3) : e ? (this.tokens.push({ index: this.index, text: a, fn: e }), this.index += 2) : d ? (this.tokens.push({ index: this.index, text: this.ch, fn: d }), this.index += 1) : this.throwError("Unexpected next character ", this.index, this.index +
                    1)
            } this.lastCh = this.ch
            } return this.tokens
            }, is: function (a) { return -1 !== a.indexOf(this.ch) }, was: function (a) { return -1 !== a.indexOf(this.lastCh) }, peek: function (a) { a = a || 1; return this.index + a < this.text.length ? this.text.charAt(this.index + a) : !1 }, isNumber: function (a) { return "0" <= a && "9" >= a }, isWhitespace: function (a) { return " " === a || "\r" === a || "\t" === a || "\n" === a || "\v" === a || "\u00a0" === a }, isIdent: function (a) { return "a" <= a && "z" >= a || "A" <= a && "Z" >= a || "_" === a || "$" === a }, isExpOperator: function (a) { return "-" === a || "+" === a || this.isNumber(a) },
            throwError: function (a, c, d) { d = d || this.index; c = D(c) ? "s " + c + "-" + this.index + " [" + this.text.substring(c, d) + "]" : " " + d; throw la("lexerr", a, c, this.text); }, readNumber: function () {
                for (var a = "", c = this.index; this.index < this.text.length;) {
                    var d = x(this.text.charAt(this.index)); if ("." == d || this.isNumber(d)) a += d; else {
                        var e = this.peek(); if ("e" == d && this.isExpOperator(e)) a += d; else if (this.isExpOperator(d) && e && this.isNumber(e) && "e" == a.charAt(a.length - 1)) a += d; else if (!this.isExpOperator(d) || e && this.isNumber(e) || "e" != a.charAt(a.length -
                            1)) break; else this.throwError("Invalid exponent")
                    } this.index++
                } a *= 1; this.tokens.push({ index: c, text: a, literal: !0, constant: !0, fn: function () { return a } })
            }, readIdent: function () {
                for (var a = this, c = "", d = this.index, e, f, g, h; this.index < this.text.length;) { h = this.text.charAt(this.index); if ("." === h || this.isIdent(h) || this.isNumber(h)) "." === h && (e = this.index), c += h; else break; this.index++ } if (e) for (f = this.index; f < this.text.length;) {
                    h = this.text.charAt(f); if ("(" === h) { g = c.substr(e - d + 1); c = c.substr(0, e - d); this.index = f; break } if (this.isWhitespace(h)) f++;
                    else break
                } d = { index: d, text: c }; if (hb.hasOwnProperty(c)) d.fn = hb[c], d.literal = !0, d.constant = !0; else { var k = Dc(c, this.options, this.text); d.fn = E(function (a, c) { return k(a, c) }, { assign: function (d, e) { return ub(d, c, e, a.text, a.options) } }) } this.tokens.push(d); g && (this.tokens.push({ index: e, text: "." }), this.tokens.push({ index: e + 1, text: g }))
            }, readString: function (a) {
                var c = this.index; this.index++; for (var d = "", e = a, f = !1; this.index < this.text.length;) {
                    var g = this.text.charAt(this.index), e = e + g; if (f) "u" === g ? (f = this.text.substring(this.index +
                        1, this.index + 5), f.match(/[\da-f]{4}/i) || this.throwError("Invalid unicode escape [\\u" + f + "]"), this.index += 4, d += String.fromCharCode(parseInt(f, 16))) : d += Ue[g] || g, f = !1; else if ("\\" === g) f = !0; else { if (g === a) { this.index++; this.tokens.push({ index: c, text: e, string: d, literal: !0, constant: !0, fn: function () { return d } }); return } d += g } this.index++
                } this.throwError("Unterminated quote", c)
            }
        }; var gb = function (a, c, d) { this.lexer = a; this.$filter = c; this.options = d }; gb.ZERO = E(function () { return 0 }, { constant: !0 }); gb.prototype = {
            constructor: gb,
            parse: function (a) { this.text = a; this.tokens = this.lexer.lex(a); a = this.statements(); 0 !== this.tokens.length && this.throwError("is an unexpected token", this.tokens[0]); a.literal = !!a.literal; a.constant = !!a.constant; return a }, primary: function () {
                var a; if (this.expect("(")) a = this.filterChain(), this.consume(")"); else if (this.expect("[")) a = this.arrayDeclaration(); else if (this.expect("{")) a = this.object(); else {
                    var c = this.expect(); (a = c.fn) || this.throwError("not a primary expression", c); a.literal = !!c.literal; a.constant =
                        !!c.constant
                } for (var d; c = this.expect("(", "[", ".");)"(" === c.text ? (a = this.functionCall(a, d), d = null) : "[" === c.text ? (d = a, a = this.objectIndex(a)) : "." === c.text ? (d = a, a = this.fieldAccess(a)) : this.throwError("IMPOSSIBLE"); return a
            }, throwError: function (a, c) { throw la("syntax", c.text, a, c.index + 1, this.text, this.text.substring(c.index)); }, peekToken: function () { if (0 === this.tokens.length) throw la("ueoe", this.text); return this.tokens[0] }, peek: function (a, c, d, e) {
                if (0 < this.tokens.length) {
                    var f = this.tokens[0], g = f.text; if (g ===
                        a || g === c || g === d || g === e || !(a || c || d || e)) return f
                } return !1
            }, expect: function (a, c, d, e) { return (a = this.peek(a, c, d, e)) ? (this.tokens.shift(), a) : !1 }, consume: function (a) { this.expect(a) || this.throwError("is unexpected, expecting [" + a + "]", this.peek()) }, unaryFn: function (a, c) { return E(function (d, e) { return a(d, e, c) }, { constant: c.constant }) }, ternaryFn: function (a, c, d) { return E(function (e, f) { return a(e, f) ? c(e, f) : d(e, f) }, { constant: a.constant && c.constant && d.constant }) }, binaryFn: function (a, c, d) {
                return E(function (e, f) {
                    return c(e,
                        f, a, d)
                }, { constant: a.constant && d.constant })
            }, statements: function () { for (var a = []; ;)if (0 < this.tokens.length && !this.peek("}", ")", ";", "]") && a.push(this.filterChain()), !this.expect(";")) return 1 === a.length ? a[0] : function (c, d) { for (var e, f = 0; f < a.length; f++) { var g = a[f]; g && (e = g(c, d)) } return e } }, filterChain: function () { for (var a = this.expression(), c; ;)if (c = this.expect("|")) a = this.binaryFn(a, c.fn, this.filter()); else return a }, filter: function () {
                for (var a = this.expect(), c = this.$filter(a.text), d = []; ;)if (a = this.expect(":")) d.push(this.expression());
                else { var e = function (a, e, h) { h = [h]; for (var k = 0; k < d.length; k++)h.push(d[k](a, e)); return c.apply(a, h) }; return function () { return e } }
            }, expression: function () { return this.assignment() }, assignment: function () { var a = this.ternary(), c, d; return (d = this.expect("=")) ? (a.assign || this.throwError("implies assignment but [" + this.text.substring(0, d.index) + "] can not be assigned to", d), c = this.ternary(), function (d, f) { return a.assign(d, c(d, f), f) }) : a }, ternary: function () {
                var a = this.logicalOR(), c, d; if (this.expect("?")) {
                    c = this.assignment();
                    if (d = this.expect(":")) return this.ternaryFn(a, c, this.assignment()); this.throwError("expected :", d)
                } else return a
            }, logicalOR: function () { for (var a = this.logicalAND(), c; ;)if (c = this.expect("||")) a = this.binaryFn(a, c.fn, this.logicalAND()); else return a }, logicalAND: function () { var a = this.equality(), c; if (c = this.expect("&&")) a = this.binaryFn(a, c.fn, this.logicalAND()); return a }, equality: function () { var a = this.relational(), c; if (c = this.expect("==", "!=", "===", "!==")) a = this.binaryFn(a, c.fn, this.equality()); return a },
            relational: function () { var a = this.additive(), c; if (c = this.expect("<", ">", "<=", ">=")) a = this.binaryFn(a, c.fn, this.relational()); return a }, additive: function () { for (var a = this.multiplicative(), c; c = this.expect("+", "-");)a = this.binaryFn(a, c.fn, this.multiplicative()); return a }, multiplicative: function () { for (var a = this.unary(), c; c = this.expect("*", "/", "%");)a = this.binaryFn(a, c.fn, this.unary()); return a }, unary: function () {
                var a; return this.expect("+") ? this.primary() : (a = this.expect("-")) ? this.binaryFn(gb.ZERO, a.fn,
                    this.unary()) : (a = this.expect("!")) ? this.unaryFn(a.fn, this.unary()) : this.primary()
            }, fieldAccess: function (a) { var c = this, d = this.expect().text, e = Dc(d, this.options, this.text); return E(function (c, d, h) { return e(h || a(c, d)) }, { assign: function (e, g, h) { (h = a(e, h)) || a.assign(e, h = {}); return ub(h, d, g, c.text, c.options) } }) }, objectIndex: function (a) {
                var c = this, d = this.expression(); this.consume("]"); return E(function (e, f) {
                    var g = a(e, f), h = d(e, f), k; ka(h, c.text); if (!g) return u; (g = ma(g[h], c.text)) && (g.then && c.options.unwrapPromises) &&
                        (k = g, "$$v" in g || (k.$$v = u, k.then(function (a) { k.$$v = a })), g = g.$$v); return g
                }, { assign: function (e, f, g) { var h = ka(d(e, g), c.text); (g = ma(a(e, g), c.text)) || a.assign(e, g = {}); return g[h] = f } })
            }, functionCall: function (a, c) {
                var d = []; if (")" !== this.peekToken().text) { do d.push(this.expression()); while (this.expect(",")) } this.consume(")"); var e = this; return function (f, g) {
                    for (var h = [], k = c ? c(f, g) : f, m = 0; m < d.length; m++)h.push(ma(d[m](f, g), e.text)); m = a(f, g, k) || v; ma(k, e.text); var l = e.text; if (m) {
                        if (m.constructor === m) throw la("isecfn",
                            l); if (m === Se || m === Te || Pc && m === Pc) throw la("isecff", l);
                    } h = m.apply ? m.apply(k, h) : m(h[0], h[1], h[2], h[3], h[4]); return ma(h, e.text)
                }
            }, arrayDeclaration: function () { var a = [], c = !0; if ("]" !== this.peekToken().text) { do { if (this.peek("]")) break; var d = this.expression(); a.push(d); d.constant || (c = !1) } while (this.expect(",")) } this.consume("]"); return E(function (c, d) { for (var g = [], h = 0; h < a.length; h++)g.push(a[h](c, d)); return g }, { literal: !0, constant: c }) }, object: function () {
                var a = [], c = !0; if ("}" !== this.peekToken().text) {
                    do {
                        if (this.peek("}")) break;
                        var d = this.expect(), d = d.string || d.text; this.consume(":"); var e = this.expression(); a.push({ key: d, value: e }); e.constant || (c = !1)
                    } while (this.expect(","))
                } this.consume("}"); return E(function (c, d) { for (var e = {}, k = 0; k < a.length; k++) { var m = a[k]; e[m.key] = m.value(c, d) } return e }, { literal: !0, constant: c })
            }
        }; var Ce = {}, Be = {}, za = z("$sce"), fa = { HTML: "html", CSS: "css", URL: "url", RESOURCE_URL: "resourceUrl", JS: "js" }, Y = X.createElement("a"), Gc = xa(W.location.href, !0); kc.$inject = ["$provide"]; Hc.$inject = ["$locale"]; Jc.$inject = ["$locale"];
    var Mc = ".", Me = {
        yyyy: Z("FullYear", 4), yy: Z("FullYear", 2, 0, !0), y: Z("FullYear", 1), MMMM: vb("Month"), MMM: vb("Month", !0), MM: Z("Month", 2, 1), M: Z("Month", 1, 1), dd: Z("Date", 2), d: Z("Date", 1), HH: Z("Hours", 2), H: Z("Hours", 1), hh: Z("Hours", 2, -12), h: Z("Hours", 1, -12), mm: Z("Minutes", 2), m: Z("Minutes", 1), ss: Z("Seconds", 2), s: Z("Seconds", 1), sss: Z("Milliseconds", 3), EEEE: vb("Day"), EEE: vb("Day", !0), a: function (a, c) { return 12 > a.getHours() ? c.AMPMS[0] : c.AMPMS[1] }, Z: function (a) {
            a = -1 * a.getTimezoneOffset(); return a = (0 <= a ? "+" : "") + (Vb(Math[0 <
                a ? "floor" : "ceil"](a / 60), 2) + Vb(Math.abs(a % 60), 2))
        }
    }, Le = /((?:[^yMdHhmsaZE']+)|(?:'(?:[^']|'')*')|(?:E+|y+|M+|d+|H+|h+|m+|s+|a|Z))(.*)/, Ke = /^\-?\d+$/; Ic.$inject = ["$locale"]; var Ie = aa(x), Je = aa(La); Kc.$inject = ["$parse"]; var cd = aa({
        restrict: "E", compile: function (a, c) {
        8 >= R && (c.href || c.name || c.$set("href", ""), a.append(X.createComment("IE fix"))); if (!c.href && !c.xlinkHref && !c.name) return function (a, c) {
            var f = "[object SVGAnimatedString]" === Ba.call(c.prop("href")) ? "xlink:href" : "href"; c.on("click", function (a) {
                c.attr(f) ||
                a.preventDefault()
            })
        }
        }
    }), Fb = {}; r(rb, function (a, c) { if ("multiple" != a) { var d = qa("ng-" + c); Fb[d] = function () { return { priority: 100, link: function (a, f, g) { a.$watch(g[d], function (a) { g.$set(c, !!a) }) } } } } }); r(["src", "srcset", "href"], function (a) {
        var c = qa("ng-" + a); Fb[c] = function () {
            return {
                priority: 99, link: function (d, e, f) {
                    var g = a, h = a; "href" === a && "[object SVGAnimatedString]" === Ba.call(e.prop("href")) && (h = "xlinkHref", f.$attr[h] = "xlink:href", g = null); f.$observe(c, function (c) {
                        c ? (f.$set(h, c), R && g && e.prop(g, f[h])) : "href" ===
                            a && f.$set(h, null)
                    })
                }
            }
        }
    }); var yb = { $addControl: v, $removeControl: v, $setValidity: v, $setDirty: v, $setPristine: v }; Nc.$inject = ["$element", "$attrs", "$scope", "$animate"]; var Qc = function (a) {
        return ["$timeout", function (c) {
            return {
                name: "form", restrict: a ? "EAC" : "E", controller: Nc, compile: function () {
                    return {
                        pre: function (a, e, f, g) {
                            if (!f.action) { var h = function (a) { a.preventDefault ? a.preventDefault() : a.returnValue = !1 }; sb(e[0], "submit", h); e.on("$destroy", function () { c(function () { bb(e[0], "submit", h) }, 0, !1) }) } var k = e.parent().controller("form"),
                                m = f.name || f.ngForm; m && ub(a, m, g, m); if (k) e.on("$destroy", function () { k.$removeControl(g); m && ub(a, m, u, m); E(g, yb) })
                        }
                    }
                }
            }
        }]
    }, dd = Qc(), qd = Qc(!0), Ve = /^(ftp|http|https):\/\/(\w+:{0,1}\w*@)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%@!\-\/]))?$/, We = /^[a-z0-9!#$%&'*+\/=?^_`{|}~.-]+@[a-z0-9]([a-z0-9-]*[a-z0-9])?(\.[a-z0-9]([a-z0-9-]*[a-z0-9])?)*$/i, Xe = /^\s*(\-|\+)?(\d+|(\d*(\.\d*)))\s*$/, Rc = {
        text: Ab, number: function (a, c, d, e, f, g) {
            Ab(a, c, d, e, f, g); e.$parsers.push(function (a) {
                var c = e.$isEmpty(a); if (c || Xe.test(a)) return e.$setValidity("number",
                    !0), "" === a ? null : c ? a : parseFloat(a); e.$setValidity("number", !1); return u
            }); Ne(e, "number", Ye, null, e.$$validityState); e.$formatters.push(function (a) { return e.$isEmpty(a) ? "" : "" + a }); d.min && (a = function (a) { var c = parseFloat(d.min); return ua(e, "min", e.$isEmpty(a) || a >= c, a) }, e.$parsers.push(a), e.$formatters.push(a)); d.max && (a = function (a) { var c = parseFloat(d.max); return ua(e, "max", e.$isEmpty(a) || a <= c, a) }, e.$parsers.push(a), e.$formatters.push(a)); e.$formatters.push(function (a) {
                return ua(e, "number", e.$isEmpty(a) ||
                    jb(a), a)
            })
        }, url: function (a, c, d, e, f, g) { Ab(a, c, d, e, f, g); a = function (a) { return ua(e, "url", e.$isEmpty(a) || Ve.test(a), a) }; e.$formatters.push(a); e.$parsers.push(a) }, email: function (a, c, d, e, f, g) { Ab(a, c, d, e, f, g); a = function (a) { return ua(e, "email", e.$isEmpty(a) || We.test(a), a) }; e.$formatters.push(a); e.$parsers.push(a) }, radio: function (a, c, d, e) {
        F(d.name) && c.attr("name", ib()); c.on("click", function () { c[0].checked && a.$apply(function () { e.$setViewValue(d.value) }) }); e.$render = function () { c[0].checked = d.value == e.$viewValue };
            d.$observe("value", e.$render)
        }, checkbox: function (a, c, d, e) { var f = d.ngTrueValue, g = d.ngFalseValue; G(f) || (f = !0); G(g) || (g = !1); c.on("click", function () { a.$apply(function () { e.$setViewValue(c[0].checked) }) }); e.$render = function () { c[0].checked = e.$viewValue }; e.$isEmpty = function (a) { return a !== f }; e.$formatters.push(function (a) { return a === f }); e.$parsers.push(function (a) { return a ? f : g }) }, hidden: v, button: v, submit: v, reset: v, file: v
    }, Ye = ["badInput"], hc = ["$browser", "$sniffer", function (a, c) {
        return {
            restrict: "E", require: "?ngModel",
            link: function (d, e, f, g) { g && (Rc[x(f.type)] || Rc.text)(d, e, f, g, c, a) }
        }
    }], wb = "ng-valid", xb = "ng-invalid", Ra = "ng-pristine", zb = "ng-dirty", Ze = ["$scope", "$exceptionHandler", "$attrs", "$element", "$parse", "$animate", function (a, c, d, e, f, g) {
        function h(a, c) { c = c ? "-" + nb(c, "-") : ""; g.removeClass(e, (a ? xb : wb) + c); g.addClass(e, (a ? wb : xb) + c) } this.$modelValue = this.$viewValue = Number.NaN; this.$parsers = []; this.$formatters = []; this.$viewChangeListeners = []; this.$pristine = !0; this.$dirty = !1; this.$valid = !0; this.$invalid = !1; this.$name =
            d.name; var k = f(d.ngModel), m = k.assign; if (!m) throw z("ngModel")("nonassign", d.ngModel, ia(e)); this.$render = v; this.$isEmpty = function (a) { return F(a) || "" === a || null === a || a !== a }; var l = e.inheritedData("$formController") || yb, n = 0, q = this.$error = {}; e.addClass(Ra); h(!0); this.$setValidity = function (a, c) { q[a] !== !c && (c ? (q[a] && n-- , n || (h(!0), this.$valid = !0, this.$invalid = !1)) : (h(!1), this.$invalid = !0, this.$valid = !1, n++), q[a] = !c, h(c, a), l.$setValidity(a, c, this)) }; this.$setPristine = function () {
            this.$dirty = !1; this.$pristine =
                !0; g.removeClass(e, zb); g.addClass(e, Ra)
            }; this.$setViewValue = function (d) { this.$viewValue = d; this.$pristine && (this.$dirty = !0, this.$pristine = !1, g.removeClass(e, Ra), g.addClass(e, zb), l.$setDirty()); r(this.$parsers, function (a) { d = a(d) }); this.$modelValue !== d && (this.$modelValue = d, m(a, d), r(this.$viewChangeListeners, function (a) { try { a() } catch (d) { c(d) } })) }; var p = this; a.$watch(function () {
                var c = k(a); if (p.$modelValue !== c) {
                    var d = p.$formatters, e = d.length; for (p.$modelValue = c; e--;)c = d[e](c); p.$viewValue !== c && (p.$viewValue =
                        c, p.$render())
                } return c
            })
    }], Fd = function () { return { require: ["ngModel", "^?form"], controller: Ze, link: function (a, c, d, e) { var f = e[0], g = e[1] || yb; g.$addControl(f); a.$on("$destroy", function () { g.$removeControl(f) }) } } }, Hd = aa({ require: "ngModel", link: function (a, c, d, e) { e.$viewChangeListeners.push(function () { a.$eval(d.ngChange) }) } }), ic = function () {
        return {
            require: "?ngModel", link: function (a, c, d, e) {
                if (e) {
                d.required = !0; var f = function (a) {
                    if (d.required && e.$isEmpty(a)) e.$setValidity("required", !1); else return e.$setValidity("required",
                        !0), a
                }; e.$formatters.push(f); e.$parsers.unshift(f); d.$observe("required", function () { f(e.$viewValue) })
                }
            }
        }
    }, Gd = function () { return { require: "ngModel", link: function (a, c, d, e) { var f = (a = /\/(.*)\//.exec(d.ngList)) && RegExp(a[1]) || d.ngList || ","; e.$parsers.push(function (a) { if (!F(a)) { var c = []; a && r(a.split(f), function (a) { a && c.push($(a)) }); return c } }); e.$formatters.push(function (a) { return L(a) ? a.join(", ") : u }); e.$isEmpty = function (a) { return !a || !a.length } } } }, $e = /^(true|false|\d+)$/, Id = function () {
        return {
            priority: 100,
            compile: function (a, c) { return $e.test(c.ngValue) ? function (a, c, f) { f.$set("value", a.$eval(f.ngValue)) } : function (a, c, f) { a.$watch(f.ngValue, function (a) { f.$set("value", a) }) } }
        }
    }, id = Aa({ compile: function (a) { a.addClass("ng-binding"); return function (a, d, e) { d.data("$binding", e.ngBind); a.$watch(e.ngBind, function (a) { d.text(a == u ? "" : a) }) } } }), kd = ["$interpolate", function (a) { return function (c, d, e) { c = a(d.attr(e.$attr.ngBindTemplate)); d.addClass("ng-binding").data("$binding", c); e.$observe("ngBindTemplate", function (a) { d.text(a) }) } }],
        jd = ["$sce", "$parse", function (a, c) { return { compile: function (d) { d.addClass("ng-binding"); return function (d, f, g) { f.data("$binding", g.ngBindHtml); var h = c(g.ngBindHtml); d.$watch(function () { return (h(d) || "").toString() }, function (c) { f.html(a.getTrustedHtml(h(d)) || "") }) } } } }], ld = Wb("", !0), nd = Wb("Odd", 0), md = Wb("Even", 1), od = Aa({ compile: function (a, c) { c.$set("ngCloak", u); a.removeClass("ng-cloak") } }), pd = [function () { return { scope: !0, controller: "@", priority: 500 } }], jc = {}, af = { blur: !0, focus: !0 }; r("click dblclick mousedown mouseup mouseover mouseout mousemove mouseenter mouseleave keydown keyup keypress submit focus blur copy cut paste".split(" "),
            function (a) { var c = qa("ng-" + a); jc[c] = ["$parse", "$rootScope", function (d, e) { return { compile: function (f, g) { var h = d(g[c], !0); return function (c, d) { d.on(a, function (d) { var f = function () { h(c, { $event: d }) }; af[a] && e.$$phase ? c.$evalAsync(f) : c.$apply(f) }) } } } }] }); var sd = ["$animate", function (a) {
                return {
                    transclude: "element", priority: 600, terminal: !0, restrict: "A", $$tlb: !0, link: function (c, d, e, f, g) {
                        var h, k, m; c.$watch(e.ngIf, function (f) {
                            Wa(f) ? k || (k = c.$new(), g(k, function (c) {
                            c[c.length++] = X.createComment(" end ngIf: " + e.ngIf +
                                " "); h = { clone: c }; a.enter(c, d.parent(), d)
                            })) : (m && (m.remove(), m = null), k && (k.$destroy(), k = null), h && (m = Eb(h.clone), a.leave(m, function () { m = null }), h = null))
                        })
                    }
                }
            }], td = ["$http", "$templateCache", "$anchorScroll", "$animate", "$sce", function (a, c, d, e, f) {
                return {
                    restrict: "ECA", priority: 400, terminal: !0, transclude: "element", controller: Xa.noop, compile: function (g, h) {
                        var k = h.ngInclude || h.src, m = h.onload || "", l = h.autoscroll; return function (g, h, p, r, J) {
                            var w = 0, t, y, u, B = function () {
                                y && (y.remove(), y = null); t && (t.$destroy(), t = null);
                                u && (e.leave(u, function () { y = null }), y = u, u = null)
                            }; g.$watch(f.parseAsResourceUrl(k), function (f) { var k = function () { !D(l) || l && !g.$eval(l) || d() }, p = ++w; f ? (a.get(f, { cache: c }).success(function (a) { if (p === w) { var c = g.$new(); r.template = a; a = J(c, function (a) { B(); e.enter(a, null, h, k) }); t = c; u = a; t.$emit("$includeContentLoaded"); g.$eval(m) } }).error(function () { p === w && B() }), g.$emit("$includeContentRequested")) : (B(), r.template = null) })
                        }
                    }
                }
            }], Jd = ["$compile", function (a) {
                return {
                    restrict: "ECA", priority: -400, require: "ngInclude",
                    link: function (c, d, e, f) { d.html(f.template); a(d.contents())(c) }
                }
            }], ud = Aa({ priority: 450, compile: function () { return { pre: function (a, c, d) { a.$eval(d.ngInit) } } } }), vd = Aa({ terminal: !0, priority: 1E3 }), wd = ["$locale", "$interpolate", function (a, c) {
                var d = /{}/g; return {
                    restrict: "EA", link: function (e, f, g) {
                        var h = g.count, k = g.$attr.when && f.attr(g.$attr.when), m = g.offset || 0, l = e.$eval(k) || {}, n = {}, q = c.startSymbol(), p = c.endSymbol(), s = /^when(Minus)?(.+)$/; r(g, function (a, c) {
                            s.test(c) && (l[x(c.replace("when", "").replace("Minus", "-"))] =
                                f.attr(g.$attr[c]))
                        }); r(l, function (a, e) { n[e] = c(a.replace(d, q + h + "-" + m + p)) }); e.$watch(function () { var c = parseFloat(e.$eval(h)); if (isNaN(c)) return ""; c in l || (c = a.pluralCat(c - m)); return n[c](e, f, !0) }, function (a) { f.text(a) })
                    }
                }
            }], xd = ["$parse", "$animate", function (a, c) {
                var d = z("ngRepeat"); return {
                    transclude: "element", priority: 1E3, terminal: !0, $$tlb: !0, link: function (e, f, g, h, k) {
                        var m = g.ngRepeat, l = m.match(/^\s*([\s\S]+?)\s+in\s+([\s\S]+?)(?:\s+track\s+by\s+([\s\S]+?))?\s*$/), n, q, p, s, u, w, t = { $id: Na }; if (!l) throw d("iexp",
                            m); g = l[1]; h = l[2]; (l = l[3]) ? (n = a(l), q = function (a, c, d) { w && (t[w] = a); t[u] = c; t.$index = d; return n(e, t) }) : (p = function (a, c) { return Na(c) }, s = function (a) { return a }); l = g.match(/^(?:([\$\w]+)|\(([\$\w]+)\s*,\s*([\$\w]+)\))$/); if (!l) throw d("iidexp", g); u = l[3] || l[1]; w = l[2]; var y = {}; e.$watchCollection(h, function (a) {
                                var g, h, l = f[0], n, t = {}, D, C, I, x, G, v, z, F = []; if (Sa(a)) v = a, G = q || p; else { G = q || s; v = []; for (I in a) a.hasOwnProperty(I) && "$" != I.charAt(0) && v.push(I); v.sort() } D = v.length; h = F.length = v.length; for (g = 0; g < h; g++)if (I = a ===
                                    v ? g : v[g], x = a[I], n = G(I, x, g), Ea(n, "`track by` id"), y.hasOwnProperty(n)) z = y[n], delete y[n], t[n] = z, F[g] = z; else { if (t.hasOwnProperty(n)) throw r(F, function (a) { a && a.scope && (y[a.id] = a) }), d("dupes", m, n, oa(x)); F[g] = { id: n }; t[n] = !1 } for (I in y) y.hasOwnProperty(I) && (z = y[I], g = Eb(z.clone), c.leave(g), r(g, function (a) { a.$$NG_REMOVED = !0 }), z.scope.$destroy()); g = 0; for (h = v.length; g < h; g++) {
                                        I = a === v ? g : v[g]; x = a[I]; z = F[g]; F[g - 1] && (l = F[g - 1].clone[F[g - 1].clone.length - 1]); if (z.scope) {
                                            C = z.scope; n = l; do n = n.nextSibling; while (n && n.$$NG_REMOVED);
                                            z.clone[0] != n && c.move(Eb(z.clone), null, A(l)); l = z.clone[z.clone.length - 1]
                                        } else C = e.$new(); C[u] = x; w && (C[w] = I); C.$index = g; C.$first = 0 === g; C.$last = g === D - 1; C.$middle = !(C.$first || C.$last); C.$odd = !(C.$even = 0 === (g & 1)); z.scope || k(C, function (a) { a[a.length++] = X.createComment(" end ngRepeat: " + m + " "); c.enter(a, null, A(l)); l = a; z.scope = C; z.clone = a; t[z.id] = z })
                                    } y = t
                            })
                    }
                }
            }], yd = ["$animate", function (a) { return function (c, d, e) { c.$watch(e.ngShow, function (c) { a[Wa(c) ? "removeClass" : "addClass"](d, "ng-hide") }) } }], rd = ["$animate",
                function (a) { return function (c, d, e) { c.$watch(e.ngHide, function (c) { a[Wa(c) ? "addClass" : "removeClass"](d, "ng-hide") }) } }], zd = Aa(function (a, c, d) { a.$watch(d.ngStyle, function (a, d) { d && a !== d && r(d, function (a, d) { c.css(d, "") }); a && c.css(a) }, !0) }), Ad = ["$animate", function (a) {
                    return {
                        restrict: "EA", require: "ngSwitch", controller: ["$scope", function () { this.cases = {} }], link: function (c, d, e, f) {
                            var g = [], h = [], k = [], m = []; c.$watch(e.ngSwitch || e.on, function (d) {
                                var n, q; n = 0; for (q = k.length; n < q; ++n)k[n].remove(); n = k.length = 0; for (q =
                                    m.length; n < q; ++n) { var p = h[n]; m[n].$destroy(); k[n] = p; a.leave(p, function () { k.splice(n, 1) }) } h.length = 0; m.length = 0; if (g = f.cases["!" + d] || f.cases["?"]) c.$eval(e.change), r(g, function (d) { var e = c.$new(); m.push(e); d.transclude(e, function (c) { var e = d.element; h.push(c); a.enter(c, e.parent(), e) }) })
                            })
                        }
                    }
                }], Bd = Aa({ transclude: "element", priority: 800, require: "^ngSwitch", link: function (a, c, d, e, f) { e.cases["!" + d.ngSwitchWhen] = e.cases["!" + d.ngSwitchWhen] || []; e.cases["!" + d.ngSwitchWhen].push({ transclude: f, element: c }) } }), Cd =
                    Aa({ transclude: "element", priority: 800, require: "^ngSwitch", link: function (a, c, d, e, f) { e.cases["?"] = e.cases["?"] || []; e.cases["?"].push({ transclude: f, element: c }) } }), Ed = Aa({ link: function (a, c, d, e, f) { if (!f) throw z("ngTransclude")("orphan", ia(c)); f(function (a) { c.empty(); c.append(a) }) } }), ed = ["$templateCache", function (a) { return { restrict: "E", terminal: !0, compile: function (c, d) { "text/ng-template" == d.type && a.put(d.id, c[0].text) } } }], bf = z("ngOptions"), Dd = aa({ terminal: !0 }), fd = ["$compile", "$parse", function (a, c) {
                        var d =
                            /^\s*([\s\S]+?)(?:\s+as\s+([\s\S]+?))?(?:\s+group\s+by\s+([\s\S]+?))?\s+for\s+(?:([\$\w][\$\w]*)|(?:\(\s*([\$\w][\$\w]*)\s*,\s*([\$\w][\$\w]*)\s*\)))\s+in\s+([\s\S]+?)(?:\s+track\s+by\s+([\s\S]+?))?$/, e = { $setViewValue: v }; return {
                                restrict: "E", require: ["select", "?ngModel"], controller: ["$element", "$scope", "$attrs", function (a, c, d) {
                                    var k = this, m = {}, l = e, n; k.databound = d.ngModel; k.init = function (a, c, d) { l = a; n = d }; k.addOption = function (c) { Ea(c, '"option value"'); m[c] = !0; l.$viewValue == c && (a.val(c), n.parent() && n.remove()) };
                                    k.removeOption = function (a) { this.hasOption(a) && (delete m[a], l.$viewValue == a && this.renderUnknownOption(a)) }; k.renderUnknownOption = function (c) { c = "? " + Na(c) + " ?"; n.val(c); a.prepend(n); a.val(c); n.prop("selected", !0) }; k.hasOption = function (a) { return m.hasOwnProperty(a) }; c.$on("$destroy", function () { k.renderUnknownOption = v })
                                }], link: function (e, g, h, k) {
                                    function m(a, c, d, e) {
                                    d.$render = function () { var a = d.$viewValue; e.hasOption(a) ? (x.parent() && x.remove(), c.val(a), "" === a && w.prop("selected", !0)) : F(a) && w ? c.val("") : e.renderUnknownOption(a) };
                                        c.on("change", function () { a.$apply(function () { x.parent() && x.remove(); d.$setViewValue(c.val()) }) })
                                    } function l(a, c, d) { var e; d.$render = function () { var a = new db(d.$viewValue); r(c.find("option"), function (c) { c.selected = D(a.get(c.value)) }) }; a.$watch(function () { Ca(e, d.$viewValue) || (e = ha(d.$viewValue), d.$render()) }); c.on("change", function () { a.$apply(function () { var a = []; r(c.find("option"), function (c) { c.selected && a.push(c.value) }); d.$setViewValue(a) }) }) } function n(e, f, g) {
                                        function h() {
                                            var a = { "": [] }, c = [""], d, k,
                                            s, u, v; s = g.$modelValue; u = A(e) || []; var F = n ? Xb(u) : u, G, Q, C; Q = {}; C = !1; if (p) if (k = g.$modelValue, w && L(k)) for (C = new db([]), d = {}, v = 0; v < k.length; v++)d[m] = k[v], C.put(w(e, d), k[v]); else C = new db(k); v = C; var E, K; for (C = 0; G = F.length, C < G; C++) { k = C; if (n) { k = F[C]; if ("$" === k.charAt(0)) continue; Q[n] = k } Q[m] = u[k]; d = r(e, Q) || ""; (k = a[d]) || (k = a[d] = [], c.push(d)); p ? d = D(v.remove(w ? w(e, Q) : x(e, Q))) : (w ? (d = {}, d[m] = s, d = w(e, d) === w(e, Q)) : d = s === x(e, Q), v = v || d); E = l(e, Q); E = D(E) ? E : ""; k.push({ id: w ? w(e, Q) : n ? F[C] : C, label: E, selected: d }) } p || (z || null ===
                                                s ? a[""].unshift({ id: "", label: "", selected: !v }) : v || a[""].unshift({ id: "?", label: "", selected: !0 })); Q = 0; for (F = c.length; Q < F; Q++) {
                                                    d = c[Q]; k = a[d]; B.length <= Q ? (s = { element: y.clone().attr("label", d), label: k.label }, u = [s], B.push(u), f.append(s.element)) : (u = B[Q], s = u[0], s.label != d && s.element.attr("label", s.label = d)); E = null; C = 0; for (G = k.length; C < G; C++)d = k[C], (v = u[C + 1]) ? (E = v.element, v.label !== d.label && (E.text(v.label = d.label), E.prop("label", v.label)), v.id !== d.id && E.val(v.id = d.id), E[0].selected !== d.selected && (E.prop("selected",
                                                        v.selected = d.selected), R && E.prop("selected", v.selected))) : ("" === d.id && z ? K = z : (K = t.clone()).val(d.id).prop("selected", d.selected).attr("selected", d.selected).prop("label", d.label).text(d.label), u.push({ element: K, label: d.label, id: d.id, selected: d.selected }), q.addOption(d.label, K), E ? E.after(K) : s.element.append(K), E = K); for (C++; u.length > C;)d = u.pop(), q.removeOption(d.label), d.element.remove()
                                                } for (; B.length > Q;)B.pop()[0].element.remove()
                                        } var k; if (!(k = s.match(d))) throw bf("iexp", s, ia(f)); var l = c(k[2] || k[1]),
                                            m = k[4] || k[6], n = k[5], r = c(k[3] || ""), x = c(k[2] ? k[1] : m), A = c(k[7]), w = k[8] ? c(k[8]) : null, B = [[{ element: f, label: "" }]]; z && (a(z)(e), z.removeClass("ng-scope"), z.remove()); f.empty(); f.on("change", function () {
                                                e.$apply(function () {
                                                    var a, c = A(e) || [], d = {}, k, l, q, r, s, t, v; if (p) for (l = [], r = 0, t = B.length; r < t; r++)for (a = B[r], q = 1, s = a.length; q < s; q++) { if ((k = a[q].element)[0].selected) { k = k.val(); n && (d[n] = k); if (w) for (v = 0; v < c.length && (d[m] = c[v], w(e, d) != k); v++); else d[m] = c[k]; l.push(x(e, d)) } } else if (k = f.val(), "?" == k) l = u; else if ("" ===
                                                        k) l = null; else if (w) for (v = 0; v < c.length; v++) { if (d[m] = c[v], w(e, d) == k) { l = x(e, d); break } } else d[m] = c[k], n && (d[n] = k), l = x(e, d); g.$setViewValue(l); h()
                                                })
                                            }); g.$render = h; e.$watchCollection(A, h); e.$watchCollection(function () { var a = {}, c = A(e); if (c) { for (var d = Array(c.length), f = 0, g = c.length; f < g; f++)a[m] = c[f], d[f] = l(e, a); return d } }, h); p && e.$watchCollection(function () { return g.$modelValue }, h)
                                    } if (k[1]) {
                                        var q = k[0]; k = k[1]; var p = h.multiple, s = h.ngOptions, z = !1, w, t = A(X.createElement("option")), y = A(X.createElement("optgroup")),
                                            x = t.clone(); h = 0; for (var B = g.children(), v = B.length; h < v; h++)if ("" === B[h].value) { w = z = B.eq(h); break } q.init(k, z, x); p && (k.$isEmpty = function (a) { return !a || 0 === a.length }); s ? n(e, g, k) : p ? l(e, g, k) : m(e, g, k, q)
                                    }
                                }
                            }
                    }], hd = ["$interpolate", function (a) {
                        var c = { addOption: v, removeOption: v }; return {
                            restrict: "E", priority: 100, compile: function (d, e) {
                                if (F(e.value)) { var f = a(d.text(), !0); f || e.$set("value", d.text()) } return function (a, d, e) {
                                    var m = d.parent(), l = m.data("$selectController") || m.parent().data("$selectController"); l && l.databound ?
                                        d.prop("selected", !1) : l = c; f ? a.$watch(f, function (a, c) { e.$set("value", a); a !== c && l.removeOption(c); l.addOption(a) }) : l.addOption(e.value); d.on("$destroy", function () { l.removeOption(e.value) })
                                }
                            }
                        }
                    }], gd = aa({ restrict: "E", terminal: !0 }); W.angular.bootstrap ? console.log("WARNING: Tried to load angular more than once.") : ((Fa = W.jQuery) && Fa.fn.on ? (A = Fa, E(Fa.fn, { scope: Oa.scope, isolateScope: Oa.isolateScope, controller: Oa.controller, injector: Oa.injector, inheritedData: Oa.inheritedData }), Gb("remove", !0, !0, !1), Gb("empty",
                        !1, !1, !1), Gb("html", !1, !1, !0)) : A = S, Xa.element = A, Zc(Xa), A(X).ready(function () { Wc(X, dc) }))
})(window, document); !window.angular.$$csp() && window.angular.element(document).find("head").prepend('<style type="text/css">@charset "UTF-8";[ng\\:cloak],[ng-cloak],[data-ng-cloak],[x-ng-cloak],.ng-cloak,.x-ng-cloak,.ng-hide{display:none !important;}ng\\:form{display:block;}.ng-animate-block-transitions{transition:0s all!important;-webkit-transition:0s all!important;}.ng-hide-add-active,.ng-hide-remove{display:block!important;}</style>');
//# sourceMappingURL=angular.min.js.map


/**
 * angular-ui-sortable - This directive allows you to jQueryUI Sortable.
 * @version v0.17.1 - 2017-04-15
 * @link http://angular-ui.github.com
 * @license MIT
 */

!function (a, b, c) { "use strict"; b.module("ui.sortable", []).value("uiSortableConfig", { items: "> [ng-repeat],> [data-ng-repeat],> [x-ng-repeat]" }).directive("uiSortable", ["uiSortableConfig", "$timeout", "$log", function (a, d, e) { return { require: "?ngModel", scope: { ngModel: "=", uiSortable: "=", create: "&uiSortableCreate", start: "&uiSortableStart", activate: "&uiSortableActivate", beforeStop: "&uiSortableBeforeStop", update: "&uiSortableUpdate", remove: "&uiSortableRemove", receive: "&uiSortableReceive", deactivate: "&uiSortableDeactivate", stop: "&uiSortableStop" }, link: function (f, g, h, i) { function j(a, b) { var c = "function" == typeof a, d = "function" == typeof b; return c && d ? function () { a.apply(this, arguments), b.apply(this, arguments) } : d ? b : a } function k(a) { var b = a.data("ui-sortable"); return b && "object" == typeof b && "ui-sortable" === b.widgetFullName ? b : null } function l(b, c) { return C[b] ? ("stop" === b && (c = j(c, function () { f.$apply() }), c = j(c, t)), c = j(C[b], c)) : D[b] && (c = D[b](c)), c || "items" !== b && "ui-model-items" !== b || (c = a.items), c } function m(a, d, e) { function f(a, b) { b in A || (A[b] = null) } b.forEach(C, f); var g = null; if (d) { var h; b.forEach(d, function (d, e) { if (!(a && e in a)) { if (e in B) return void ("ui-floating" === e ? A[e] = "auto" : A[e] = l(e, c)); h || (h = b.element.ui.sortable().options); var f = h[e]; f = l(e, f), g || (g = {}), g[e] = f, A[e] = f } }) } return b.forEach(a, function (a, b) { return b in B ? ("ui-floating" !== b || a !== !1 && a !== !0 || !e || (e.floating = a), void (A[b] = l(b, a))) : (a = l(b, a), g || (g = {}), g[b] = a, void (A[b] = a)) }), g } function n(a) { var c = a.sortable("option", "placeholder"); if (c && c.element && "function" == typeof c.element) { var d = c.element(); return d = b.element(d) } return null } function o(a, b) { var c = A["ui-model-items"].replace(/[^,]*>/g, ""), d = a.find('[class="' + b.attr("class") + '"]:not(' + c + ")"); return d } function p(a, b) { var c = a.sortable("option", "helper"); return "clone" === c || "function" == typeof c && b.item.sortable.isCustomHelperUsed() } function q(a, b) { var c = null; return p(a, b) && "parent" === a.sortable("option", "appendTo") && (c = z), c } function r(a) { return /left|right/.test(a.css("float")) || /inline|table-cell/.test(a.css("display")) } function s(a, b) { for (var c = 0; c < a.length; c++) { var d = a[c]; if (d.element[0] === b[0]) return d } } function t(a, b) { b.item.sortable._destroy() } function u(a) { return a.parent().find(A["ui-model-items"]).index(a) } function v() { f.$watchCollection("ngModel", function () { d(function () { k(g) && g.sortable("refresh") }, 0, !1) }), C.start = function (a, d) { if ("auto" === A["ui-floating"]) { var e = d.item.siblings(), f = k(b.element(a.target)); f.floating = r(e) } var h = u(d.item); d.item.sortable = { model: i.$modelValue[h], index: h, source: g, sourceList: d.item.parent(), sourceModel: i.$modelValue, cancel: function () { d.item.sortable._isCanceled = !0 }, isCanceled: function () { return d.item.sortable._isCanceled }, isCustomHelperUsed: function () { return !!d.item.sortable._isCustomHelperUsed }, _isCanceled: !1, _isCustomHelperUsed: d.item.sortable._isCustomHelperUsed, _destroy: function () { b.forEach(d.item.sortable, function (a, b) { d.item.sortable[b] = c }) }, _connectedSortables: [], _getElementContext: function (a) { return s(this._connectedSortables, a) } } }, C.activate = function (a, b) { var c = b.item.sortable.source === g, d = c ? b.item.sortable.sourceList : g, e = { element: g, scope: f, isSourceContext: c, savedNodesOrigin: d }; b.item.sortable._connectedSortables.push(e), y = d.contents(), z = b.helper; var h = n(g); if (h && h.length) { var i = o(g, h); y = y.not(i) } }, C.update = function (a, b) { if (!b.item.sortable.received) { b.item.sortable.dropindex = u(b.item); var c = b.item.closest("[ui-sortable], [data-ui-sortable], [x-ui-sortable]"); b.item.sortable.droptarget = c, b.item.sortable.droptargetList = b.item.parent(); var d = b.item.sortable._getElementContext(c); b.item.sortable.droptargetModel = d.scope.ngModel, g.sortable("cancel") } var e = !b.item.sortable.received && q(g, b, y); e && e.length && (y = y.not(e)); var h = b.item.sortable._getElementContext(g); y.appendTo(h.savedNodesOrigin), b.item.sortable.received && (y = null), b.item.sortable.received && !b.item.sortable.isCanceled() && (f.$apply(function () { i.$modelValue.splice(b.item.sortable.dropindex, 0, b.item.sortable.moved) }), f.$emit("ui-sortable:moved", b)) }, C.stop = function (a, c) { var d = "dropindex" in c.item.sortable && !c.item.sortable.isCanceled(); if (d && !c.item.sortable.received) f.$apply(function () { i.$modelValue.splice(c.item.sortable.dropindex, 0, i.$modelValue.splice(c.item.sortable.index, 1)[0]) }), f.$emit("ui-sortable:moved", c); else if (!d && !b.equals(g.contents().toArray(), y.toArray())) { var e = q(g, c, y); e && e.length && (y = y.not(e)); var h = c.item.sortable._getElementContext(g); y.appendTo(h.savedNodesOrigin) } y = null, z = null }, C.receive = function (a, b) { b.item.sortable.received = !0 }, C.remove = function (a, b) { "dropindex" in b.item.sortable || (g.sortable("cancel"), b.item.sortable.cancel()), b.item.sortable.isCanceled() || f.$apply(function () { b.item.sortable.moved = i.$modelValue.splice(b.item.sortable.index, 1)[0] }) }, b.forEach(C, function (a, b) { C[b] = j(C[b], function () { var a, c = f[b]; "function" == typeof c && ("uiSortable" + b.substring(0, 1).toUpperCase() + b.substring(1)).length && "function" == typeof (a = c()) && a.apply(this, arguments) }) }), D.helper = function (a) { return a && "function" == typeof a ? function (d, e) { var f = e.sortable, h = u(e); e.sortable = { model: i.$modelValue[h], index: h, source: g, sourceList: e.parent(), sourceModel: i.$modelValue, _restore: function () { b.forEach(e.sortable, function (a, b) { e.sortable[b] = c }), e.sortable = f } }; var j = a.apply(this, arguments); return e.sortable._restore(), e.sortable._isCustomHelperUsed = e !== j, j } : a }, f.$watchCollection("uiSortable", function (a, b) { var c = k(g); if (c) { var d = m(a, b, c); d && g.sortable("option", d) } }, !0), m(A) } function w() { i ? v() : e.info("ui.sortable: ngModel not provided!", g), g.sortable(A) } function x() { return f.uiSortable && f.uiSortable.disabled ? !1 : (w(), x.cancelWatcher(), x.cancelWatcher = b.noop, !0) } var y, z, A = {}, B = { "ui-floating": c, "ui-model-items": a.items }, C = { create: null, start: null, activate: null, beforeStop: null, update: null, remove: null, receive: null, deactivate: null, stop: null }, D = { helper: null }; return b.extend(A, B, a, f.uiSortable), b.element.fn && b.element.fn.jquery ? (x.cancelWatcher = b.noop, void (x() || (x.cancelWatcher = f.$watch("uiSortable.disabled", x)))) : void e.error("ui.sortable: jQuery should be included before AngularJS!") } } }]) }(window, window.angular);


(function () {
    angular.module("WizdomMobileModule")
        .directive("wizdom365Taxonomypicker", wizdom365Taxonomypicker);

    function wizdom365Taxonomypicker() {

        return {
            scope: {
                selectedTerms: '=',
                termSetId: '@?',
                fieldName: '@?',
                allowOnlyOneTerm: '@?',
                ngRequired: '=ngRequired',
                placeholder: '@?'
            },
            templateUrl: "WizdomMobileModule/App_Admin/Directives/TaxonomyPicker/TaxonomyPicker.html",
            controller: wizdom365TaxonomypickerController
        };
    }

    wizdom365TaxonomypickerController.$inject = [
        "$filter", "$scope", "webApiProxy", "$modal"
    ];

    function wizdom365TaxonomypickerController(
        $filter, $scope, webApiProxy, $modal) {

        function initialize() {
            if ($scope.ngRequired == null || $scope.ngRequired == undefined)
                $scope.required = false;
            else
                $scope.required = $scope.ngRequired;
            $scope.selectedTerms = angular.copy($scope.selectedTerms || []);
            $scope.termSetList = [];

            if ($scope.fieldName) {
                webApiProxy.terms.getAllTermsWithIDsByFieldName($scope.fieldName).then(function (data) {
                    $scope.termSetList = data;
                });
            }
            else {
                if ($scope.termSetId == null || $scope.termSetId === "")
                    return;

                webApiProxy.terms.getAllTermsWithIDsById($scope.termSetId).then(function (data) {
                    $scope.termSetList = data;
                });
            }

        }

        $scope.filterSelected = function ($item, $model, $label) {
            //Check if selected term is already selected (no need to add term twice)
            var blnTermAlreadySelected = false;
            for (var i = 0; i < $scope.selectedTerms.length; ++i) {
                var term = $scope.selectedTerms[i];
                if (term.label == $label) {
                    blnTermAlreadySelected = true;
                    break;
                }
            }

            if (!blnTermAlreadySelected) {
                $scope.selectedTerms.push({ label: $label, filter: $item.name + "|" + $item.id });
            }

        };

        $scope.removeFilter = function (filter) {
            var index = $scope.selectedTerms.indexOf(filter);
            $scope.selectedTerms.splice(index, 1);
        };

        $scope.pickTermSet = function () {
            $modal.open({
                templateUrl: "WizdomMobileModule/App_Admin/Directives/TaxonomyPicker/TaxonomyPickerTree.html",
                controller: "Wizdom365TaxonomyPickerTreeController",
                windowClass: "bootstrap-wrapper",
                resolve: {
                    "termsetId": function () { return $scope.termSetId; },
                    "multiSelect": function () { return !($scope.allowOnlyOneTerm === 'true'); },
                    "preSelectedTerms": function () { return $scope.selectedTerms; },
                    "fieldName": function () { return $scope.fieldName }
                }
            }).result.then(
                function (data) {
                    if (!data) return;
                    $scope.selectedTerms = [];
                    angular.forEach(data, function (term) {
                        $scope.selectedTerms.push({ label: term.name, filter: term.name + "|" + term.id });
                    });
                });
        };


        initialize();
    }
})(); 
(function () {
    angular.module("WizdomMobileModule")
        .controller("Wizdom365TaxonomyPickerTreeController", Wizdom365TaxonomyPickerTreeController);

    Wizdom365TaxonomyPickerTreeController.$inject = ["$scope", "webApiProxy", "termsetId", "$modalInstance", "multiSelect", "preSelectedTerms", "fieldName"];

    function Wizdom365TaxonomyPickerTreeController($scope, webApiProxy, termsetId, $modalInstance, multiSelect, preSelectedTerms, fieldName) {
        $scope.selectedTerms = [];
        $scope.selectedTerm = {};
        $scope.expandedNodes = [];
        $scope.treeOptions = {
            nodeChildren: "children",
            dirSelectable: true,
            multiSelection: multiSelect,
            isSelectable: function (node) { return node.isAvailableForTagging; }
        }
        $scope.loading = true;
        $scope.errorState = false;

        if (fieldName) {
            webApiProxy.terms.getAllTermsWithChildrenByFieldName(fieldName).then(function (data) {
                processreturnedData(data);
                expandNodes();
                $scope.loading = false;
            }, function (error) {
                $scope.loading = false;
                $scope.errorState = true;
            });
        }
        else {
            webApiProxy.terms.getAllTermsWithChildrenById(termsetId).then(function (data) {
                processreturnedData(data);
                expandNodes();
                $scope.loading = false;
            }, function (error) {
                $scope.loading = false;
                $scope.errorState = true;
            });
        }
        function processreturnedData(data) {
            $scope.termsTreeData = data;
            angular.forEach(preSelectedTerms, function (term) {
                var reformattedTerm = {
                    'name': term.label,
                    'isAvailableForTagging': (angular.isDefined(term.isAvailableForTagging) ? term.isAvailabeForTagging : true),
                    'id': angular.isDefined(term.filter) ? term.filter.substring(term.filter.indexOf('|') + 1) : (angular.isDefined(term.id) ? term.id : "undefined")
                };
                multiSelect ? $scope.selectedTerms.push(reformattedTerm) : $scope.selectedTerm = reformattedTerm;
            });
        }

        function expandNodes() {
            var i,
                selectedElms = [],
                tree = $scope.termsTreeData;

            if (!multiSelect && angular.isDefined($scope.selectedTerm.id)) {
                selectedElms.push($scope.selectedTerm);
            } else {
                selectedElms = $scope.selectedTerms;
            }

            var flattenedTree = findParents(tree, [], "");
            for (i = 0; i < selectedElms.length; i++) {
                var node = flattenedTree.find(ft => ft.id == selectedElms[i].id);
                //var node = _.find(flattenedTree, { 'id': selectedElms[i].id });
                if (angular.isDefined(node) && angular.isDefined(node["id"]))
                    expandNodesRecursively(node, flattenedTree);
            }

        }
        function expandNodesRecursively(node, flattenedTree) {
            addExpandedNode(node);
            if (node["parent"] !== "") {
                var parent = flattenedTree.find(ft => ft.id == node["parentId"]);
                //var parent = _.find(flattenedTree, { 'id': node["parentId"] });
                if (angular.isDefined(parent))
                    expandNodesRecursively(parent, flattenedTree);
            }

        }

        function addExpandedNode(node) {

            //if (!_.find($scope.expandedNodes, { 'id': node.id })) {
            if (!$scope.expandedNodes.find(en => en.id == node.id)) {
                $scope.expandedNodes.push({ 'id': node.id, 'name': node.name, 'isAvailableForTagging': node.isAvailableForTagging });
            }
        }
        function findParents(tree, flattenedTree, parent) {
            var y;
            for (y = 0; y < tree.length; y++) {
                var elm = { 'id': tree[y].id, 'name': tree[y].name, 'parentId': parent, 'isAvailableForTagging': tree[y].isAvailableForTagging };
                flattenedTree.push(elm);
                if (tree[y].children.length > 0)
                    findParents(tree[y].children, flattenedTree, elm.id);
            }
            return flattenedTree;
        }
        $scope.nodeSelected = function (node, selected, parent) {

        }
        $scope.cancel = function () {
            $modalInstance.dismiss('cancel');
        }

        $scope.save = function () {
            if (!multiSelect)
                $scope.selectedTerms.push($scope.selectedTerm);
            $modalInstance.close($scope.selectedTerms);
        }
    }
})();
(function () {

    angular.module("WizdomMobileModule").controller("contentPagesAddController", contentPagesAddController);

    contentPagesAddController.$inject = ["$scope", "$window", "guidGenerator", "$modalInstance", "editContentPageObjMaster"];

    function contentPagesAddController($scope, $window, guidGenerator, $modalInstance, editContentPageObjMaster) {
        var vm = this;
       
        // Properties
        vm.newContentPageObj = {
            guid: guidGenerator.newGuid(),
            title: '',
            summary: '',
            imagePath: '',
            content: '',
            links: []
        };
        vm.link = '';
        if (editContentPageObjMaster != null) vm.editContentPageObj = angular.copy(editContentPageObjMaster);

        // Public methods
        vm.createContent = createContent;
        vm.cancel = cancel;
        vm.pushLink = pushLink;
        vm.removeLink = removeLink;

        // Private Methods

        function pushLink(link) {
            link.guid = guidGenerator.newGuid();
            $scope.$watch(vm.newContentPageObj.links, function () {

                vm.newContentPageObj.links.push(link);
                vm.link = '';
            });
        }
        function removeLink(index) {
            $scope.$watch(vm.newContentPageObj.links, function () {
                vm.newContentPageObj.links.splice(index, 1);
            });
        }   

        function createContent() {
            if (vm.newContentPageObj.title) {
                vm.newContentPageObj.visible = vm.newContentPageObj.visible || false;

                $modalInstance.close(vm.newContentPageObj);
            }
        }

        function cancel() {
            $modalInstance.dismiss('cancel');
        };

        //Helper functions
        function guid() {
            function s4() {
                return Math.floor((1 + Math.random()) * 0x10000)
                    .toString(16)
                    .substring(1);
            }
            return s4() + s4() + s4() + s4() + '-' + s4() + s4() + s4() + '-' + s4() + '-' + s4() + s4() + '-' + s4() + s4();
        }
    }
})();
(function () {

    angular.module("WizdomMobileModule").controller("contentPagesAdminController", contentPagesAdminController);

    contentPagesAdminController.$inject = ["$scope", "$window", "$modal", "settingsApi","contextInfo", "$timeout"];

    function contentPagesAdminController($scope, $window, $modal, settingsApi, contextInfo, $timeout) {
        var vm = this;

        // Properties
        vm.rowLimit = 10;
        vm.newLinkobj = {};
        vm.showEditMode = false;
        vm.spHostUrl = contextInfo.spHostUrl;

        // Load settings
        settingsApi.getSettings('ContentPages').then(function (response) {
            vm.settings = response;
            vm.settings.contentPagesCollection = vm.settings.contentPagesCollection || [];
        });

        // Public methods
        vm.addContentPage = addContentPage;
        vm.editContentPage = editContentPage;
        vm.deleteContentPage = deleteContentPage;
        vm.copyLink = copyLink;

        function addContentPage() {
            $modal.open({
                templateUrl: 'WizdomMobileModule/App_Admin/Administration/Modules/ContentPages/Templates/ContentPagesAddTemplate.html',
                controller: 'contentPagesAddController as contentPagesAddCtrl',
                windowClass: 'bootstrap-wrapper',
                resolve: {
                    editContentPageObjMaster: function () { return null; }
                }
            }).result.then(function (data) {
                vm.settings.contentPagesCollection.push(data);
                vm.saveSettings();
            });
        }

        function editContentPage(contentPage) {
            $modal.open({
                templateUrl: 'WizdomMobileModule/App_Admin/Administration/Modules/ContentPages/Templates/ContentPagesEditTemplate.html',
                controller: 'contentPagesEditController as contentPagesEditCtrl',
                windowClass: 'bootstrap-wrapper',
                resolve: {
                    editContentPageObjMaster: function () { return contentPage; }
                }
            }).result.then(function (data) {
                var index = vm.settings.contentPagesCollection.indexOf(data.editContentPageObjMaster);
                angular.copy(data.editContentPageObj, vm.settings.contentPagesCollection[index]);
                vm.saveSettings();
            });
        }

        function deleteContentPage(contentPage) {
            var confirm = $window.confirm("Are you absolutely sure you want to delete?");

            if (confirm) {
                var index = vm.settings.contentPagesCollection.indexOf(contentPage);
                vm.settings.contentPagesCollection.splice(index, 1);
                vm.saveSettings();
            }
        }

        function copyLink($event) {                

            var currentElement = $($event.currentTarget);
            var input = currentElement.closest($(".btn-group-xs")).next();
            var popup = currentElement.prev();
            if (input.css("display") === "none") {
                activehelper(input);
                togglehelper(input);
                input.select();

                // Copy its contents
                document.execCommand("copy");

                //show "link copied" popup
                togglehelper(popup);
                var timeout = $timeout(function () {
                    togglehelper(popup);
                },1500);
                
            } else {
                togglehelper(input);
            }

            function togglehelper(e) {
                e.toggleClass("show");
            }

            function activehelper(e) {
                $(".copy-link-input").each(function (i, el) {                    
                    $(el).removeClass("show");
                });
                
            }
            
        }

        

        vm.saveSettings = function () {
            settingsApi.saveSettings('ContentPages', vm.settings).then(function (response) {
            });
        }
    }
})();

(function () {

    angular.module("WizdomMobileModule").controller("contentPagesEditController", contentPagesEditController);

    contentPagesEditController.$inject = ["$scope", "$window","guidGenerator", "$modalInstance", "editContentPageObjMaster"];

    function contentPagesEditController($scope, $window, guidGenerator, $modalInstance, editContentPageObjMaster) {
        var vm = this;

        // Properties
        vm.editedLinkItem = {};
        if (editContentPageObjMaster != null) vm.editContentPageObj = angular.copy(editContentPageObjMaster);

        // Public methods
        vm.updateContentPage = updateContentPage;
        vm.cancel = cancel;
        vm.pushLink = pushLink;
        vm.removeLink = removeLink;
        vm.editLink = editLink;
        vm.saveEditedLink = saveEditedLink;


        // Private Methods
        function saveEditedLink(index) {
            vm.editContentPageObj.links[index] = vm.editedLinkItem;
            vm.editedLinkItem = {};
        }
        function editLink(item) {
            vm.editedLinkItem = angular.copy(item);            

        }
        function pushLink(link) {
            link.guid = guidGenerator.newGuid();
            $scope.$watch(vm.editContentPageObj.links, function () {
                vm.editContentPageObj.links.push(link);
                vm.link = '';
            });
        }
        function removeLink(index) {
            $scope.$watch(vm.editContentPageObj.links, function () {
                vm.editContentPageObj.links.splice(index, 1);
            });
        }   

        function updateContentPage() {
            $modalInstance.close({
                editContentPageObjMaster: editContentPageObjMaster,
                editContentPageObj: vm.editContentPageObj
            });
        }

        function cancel() {
            $modalInstance.dismiss('cancel');
        };
    }
})();
(function () {

    angular.module("WizdomMobileModule").controller("exploreLinksAddController", exploreLinksAddController);

    exploreLinksAddController.$inject = ["$scope", "$window", "$modalInstance", "editLinkObjMaster"];

    function exploreLinksAddController($scope, $window, $modalInstance, editLinkObjMaster) {
        var vm = this;

        // Properties
        vm.newLinkObj = {};
        if (editLinkObjMaster != null) vm.editLinkObj = angular.copy(editLinkObjMaster);

        // Public methods
        vm.createLink = createLink;
        vm.cancel = cancel;

        function createLink() {
            if (vm.newLinkObj.title && vm.newLinkObj.summary && vm.newLinkObj.imagePath && vm.newLinkObj.url) {
                vm.newLinkObj.visible = vm.newLinkObj.visible || false;

                $modalInstance.close(vm.newLinkObj);
            }
        }

        function cancel() {
            $modalInstance.dismiss('cancel');
        };
    }
})();
(function () {

    angular.module("WizdomMobileModule").controller("exploreLinksAdminController", exploreLinksAdminController);

    exploreLinksAdminController.$inject = ["$scope", "$window", "$modal", "$timeout", "settingsApi"];

    function exploreLinksAdminController($scope, $window, $modal, $timeout, settingsApi) {
        var vm = this;

        // Properties
        vm.rowLimit = 10;
        vm.newLinkobj = {};
        vm.showEditMode = false;

        // Load settings
        settingsApi.getSettings('ExploreLinks').then(function (response) {
            vm.settings = response;
            vm.settings.linkCollection = vm.settings.linkCollection || [];
        });

        // Public methods
        vm.addLink = addLink;
        vm.editLink = editLink;
        vm.deleteLink = deleteLink;

        function addLink() {
            $modal.open({
                templateUrl: 'WizdomMobileModule/App_Admin/Administration/Modules/ExploreLinks/Templates/ExploreLinksAddTemplate.html',
                controller: 'exploreLinksAddController as exploreLinksAddCtrl',
                windowClass: 'bootstrap-wrapper',
                resolve: {
                    editLinkObjMaster: function () { return null; }
                }
            }).result.then(function (data) {
                vm.settings.linkCollection.push(data);
                vm.saveSettings();
            });
        };

        function editLink(link) {
            $modal.open({
                templateUrl: 'WizdomMobileModule/App_Admin/Administration/Modules/ExploreLinks/Templates/ExploreLinksEditTemplate.html',
                controller: 'exploreLinksEditController as exploreLinksEditCtrl',
                windowClass: 'bootstrap-wrapper',
                resolve: {
                    editLinkObjMaster: function () { return link; }
                }
            }).result.then(function (data) {
                var index = vm.settings.linkCollection.indexOf(data.editLinkObjMaster);
                angular.copy(data.editLinkObj, vm.settings.linkCollection[index]);
                vm.saveSettings();
            });
        };

        function deleteLink(link) {
            var confirm = $window.confirm("Are you absolutely sure you want to delete?");

            if (confirm) {
                var index = vm.settings.linkCollection.indexOf(link);
                vm.settings.linkCollection.splice(index, 1);
                vm.saveSettings();
            }
        };

        vm.saveSettings = function (componentName, settings) {
            vm.saving = true;
            settingsApi.saveSettings(componentName, settings).then(function () {
                // Timeouts for UX actually see the saving messaged
                $timeout(function () {
                    vm.saving = false;
                }, 1000);
            }, function () {
                // handle errors?
            });
        };
    }
})();
(function () {

    angular.module("WizdomMobileModule").controller("exploreLinksEditController", exploreLinksEditController);

    exploreLinksEditController.$inject = ["$scope", "$window", "$modalInstance", "editLinkObjMaster"];

    function exploreLinksEditController($scope, $window, $modalInstance, editLinkObjMaster) {
        var vm = this;

        // Properties
        vm.newLinkObj = {};
        if (editLinkObjMaster != null) vm.editLinkObj = angular.copy(editLinkObjMaster);

        // Public methods
        vm.updateLink = updateLink;
        vm.cancel = cancel;

        function updateLink() {
            $modalInstance.close({
                editLinkObjMaster: editLinkObjMaster,
                editLinkObj: vm.editLinkObj
            });
        }

        function cancel() {
            $modalInstance.dismiss('cancel');
        };
    }
})();
(function () {

    angular.module("WizdomMobileModule").controller("focusArticleAdminController", focusArticleAdminController);

    focusArticleAdminController.$inject = ["$scope", "$window", "$modal", "newsService", "settingsApi", "contextInfo", "$timeout", "$http"];

    function focusArticleAdminController($scope, $window, $modal, newsService, settingsApi, contextInfo, $timeout, $http) {
        var vm = this;

        // Properties
        vm.newsRowLimit = 10;
        vm.contentPageRowLimit = 5;
        vm.spHostUrl = contextInfo.spHostUrl;
        vm.settings = {}
        vm.focusTypeOptions = ["News article", "Content page", "URL"];
        
        init();

        // Public methods        
        vm.focusArticleEnabled = focusArticleEnabled;
        vm.chosenType = chosenType;
        vm.setFocus = setFocus;
        vm.newsFocus = newsFocus;
        vm.contentPageFocus = contentPageFocus;

        // Private methods
        function init() {

            // Load settings
            settingsApi.getSettings('FocusArticle').then(function (response) {
                if (jQuery.isEmptyObject(response)) {
                    vm.settings.newsArticle = {};
                    vm.settings.url = {};
                    vm.settings.contentPage = {};
                    vm.settings.enabledComponent = false;
                    vm.settings.focusSetTo = null;
                    vm.saveSettings();
                } else {
                    vm.settings = response;
                }

                if (vm.settings.focusSetTo)
                    vm.selectedType = vm.settings.focusSetTo;

            });

            articles();
            contentPages();
        }

        function contentPageFocus(item) {

            if (item.marked) {
                angular.forEach(vm.contentPages.contentPagesCollection, function (e, i) {
                    if (e.guid !== item.guid) {
                        e.marked = false;
                    }
                });

                vm.settings.contentPage.link = "internal://contentpageviewer({contentpageguid:'" + item.guid + "'})";
                vm.settings.contentPage.isFocus = item.marked;
            }

            setFocus("Content page", vm.settings.contentPage, item);
        }

        function newsFocus(item) {
            if (item.marked) {

                angular.forEach(vm.news, function (e, i) {
                    if (e.guid !== item.guid) {
                        e.marked = false;
                    }
                });
                
                vm.settings.newsArticle.guid = item.guid;
                vm.settings.newsArticle.isFocus = item.marked;


            }
            setFocus("News article", vm.settings.newsArticle, item);
           
        }
        //Set scope variable to which type is in focus
        function setFocus(type, settingTypeObject, item) {

            if (vm.settings.focusSetTo === null || vm.settings.focusSetTo === undefined) {
                vm.settings.focusSetTo = type; 
            } else {
                //isFocus value is set on ng-model before the ng-change function is called
                if (vm.settings.focusSetTo !== type && settingTypeObject.isFocus) {
                    var confirm = $window.confirm("A focus page is already set. Are you sure you want to change it?");

                    if (confirm) {
                        vm.settings.focusSetTo = type;
                        isFocusHelper(type);
                        markedHelper();
                    } else if (type === "News article" || type === "Content page") {
                        item.marked = false;
                        settingTypeObject.isFocus = false;

                    } else {
                        settingTypeObject.isFocus = false;
                    }
                }
                else {
                    
                    settingTypeObject.isFocus = false;
                }
            }
            
            
        }       

        function contentPages() {
            settingsApi.getSettings('ContentPages').then(function (data) {
                vm.contentPages = data;
                vm.contentPages.contentPagesCollection = vm.contentPages.contentPagesCollection || [];
            });
        }

        function articles() {
            newsService.getLatest(10, 0).then(function (data) {
                vm.news = data;
                markedHelper();                
                
            }, function (error) {});
        }

        function chosenType() {

            switch (vm.selectedType) {
                case "News article":
                    
                    break;

                case "Content page":

                    break;

                case "URL":

                    break;

                default:
                    break;
            }
        }

        function focusArticleEnabled() {
            vm.saveSettings();
        };

        vm.saveSettings = function (componentName, settings) {
            vm.saving = true;
            settingsApi.saveSettings(componentName, settings).then(function () {
                // Timeouts for UX actually see the saving messaged
                $timeout(function () {
                    vm.saving = false;
                }, 1000);
            }, function () {
                // handle errors?
            });
        }

        // Helper functions

        function markedHelper() {

            switch (vm.settings.focusSetTo) {
                case "News article":
                    loopHelperNews(true);
                    loopHelperContentPages(false);
                    break;

                case "Content page":
                    loopHelperContentPages(true);
                    loopHelperNews(false);
                    break;
                default:
                    loopHelperContentPages(false);
                    loopHelperNews(false);
                    break;

            };         

            function loopHelperNews(bool) {

                angular.forEach(vm.news, function (e, i) {
                    if (e.guid === vm.settings.newsArticle.guid) {
                        e.marked = bool;
                    }
                });
            }

            function loopHelperContentPages(bool) {
                angular.forEach(vm.contentPages.contentPagesCollection, function (e, i) {
                    if ("internal://contentpageviewer({contentpageguid:'" + e.guid + "'})" === vm.settings.contentPage.link) {
                        e.marked = bool;
                    }
                });
            }
        }

        function isFocusHelper(type) {
            switch (type) {
                case "News article":
                    vm.settings.url.isFocus = false;
                    vm.settings.contentPage.isFocus = false;
                    break;

                case "Content page":
                    vm.settings.newsArticle.isFocus = false;
                    vm.settings.url.isFocus = false;
                    break;

                case "URL":
                    vm.settings.newsArticle.isFocus = false;
                    vm.settings.contentPage.isFocus = false;
                    break;

                default:
                    break;
            }
        }
    }
})();

(function () {

    angular.module("WizdomMobileModule").controller("customPageAddController", customPageAddController);

    customPageAddController.$inject = ["$scope", "$window", "$modalInstance", "editPageObjMaster"];

    function customPageAddController($scope, $window, $modalInstance, editPageObjMaster) {
        var vm = this;

        // Properties
        vm.newPageObj = {};
        if (editPageObjMaster != null) vm.editPageObj = angular.copy(editPageObjMaster);

        // Public methods
        vm.createPage = createPage;
        vm.cancel = cancel;

        function createPage() {
            if (vm.newPageObj.pageTitle && vm.newPageObj.pageUrl) {
                vm.newPageObj.visible = vm.newPageObj.visible || false;

                $modalInstance.close(vm.newPageObj);
            }
        }

        function cancel() {
            $modalInstance.dismiss('cancel');
        };
    }
})();
(function () {

    angular.module("WizdomMobileModule").controller("customPageEditController", customPageEditController);

    customPageEditController.$inject = ["$scope", "$window", "$modalInstance", "editPageObjMaster"];

    function customPageEditController($scope, $window, $modalInstance, editPageObjMaster) {
        var vm = this;

        // Properties
        vm.newPageObj = {};
        if (editPageObjMaster != null) vm.editPageObj = angular.copy(editPageObjMaster);

        // Public methods
        vm.updatePage = updatePage;
        vm.cancel = cancel;

        function updatePage() {
            $modalInstance.close({
                editPageObjMaster: editPageObjMaster,
                editPageObj: vm.editPageObj
            });
        }

        function cancel() {
            $modalInstance.dismiss('cancel');
        };
    }
})();
(function () {

    angular.module("WizdomMobileModule").controller("linksAddController", linksAddController);

    linksAddController.$inject = ["$scope", "$window", "$modalInstance", "editLinkObjMaster"];

    function linksAddController($scope, $window, $modalInstance, editLinkObjMaster) {
        var vm = this;

        // Properties
        vm.newLinkObj = {};
        if (editLinkObjMaster != null) vm.editLinkObj = angular.copy(editLinkObjMaster);

        // Public methods
        vm.createLink = createLink;
        vm.cancel = cancel;

        function createLink() {
            if (vm.newLinkObj.title && vm.newLinkObj.url) {

                $modalInstance.close(vm.newLinkObj);
            }
        }

        function cancel() {
            $modalInstance.dismiss('cancel');
        };
    }
})();
(function () {

    angular.module("WizdomMobileModule").controller("linksAdminController", linksAdminController);

    linksAdminController.$inject = ["$scope", "$window", "$modal", "$timeout", "settingsApi"];

    function linksAdminController($scope, $window, $modal, $timeout, settingsApi) {
        var vm = this;

        // Properties
        vm.rowLimit = 10;
        vm.newLinkobj = {};
        vm.showEditMode = false;

        // Load settings
        settingsApi.getSettings('Links').then(function (settings) {
            vm.settings = settings;
            vm.settings.linkCollection = vm.settings.linkCollection || [];
        });

        // Public methods
        vm.addLink = addLink;
        vm.editLink = editLink;
        vm.deleteLink = deleteLink;

        function addLink() {
            $modal.open({
                templateUrl: 'WizdomMobileModule/App_Admin/Administration/Modules/Links/Templates/LinksAddTemplate.html',
                controller: 'linksAddController as linksAddCtrl',
                windowClass: 'bootstrap-wrapper',
                resolve: {
                    editLinkObjMaster: function () { return null; }
                }
            }).result.then(function (data) {
                vm.settings.linkCollection.push(data);
                vm.saveSettings();
            });
        }

        function editLink(link) {
            $modal.open({
                templateUrl: 'WizdomMobileModule/App_Admin/Administration/Modules/Links/Templates/LinksEditTemplate.html',
                controller: 'linksEditController as linksEditCtrl',
                windowClass: 'bootstrap-wrapper',
                resolve: {
                    editLinkObjMaster: function () { return link; }
                }
            }).result.then(function (data) {
                var index = vm.settings.linkCollection.indexOf(data.editLinkObjMaster);
                angular.copy(data.editLinkObj, vm.settings.linkCollection[index]);
                vm.saveSettings();
            });
        }

        function deleteLink(link) {
            var confirm = $window.confirm("Are you absolutely sure you want to delete?");

            if (confirm) {
                var index = vm.settings.linkCollection.indexOf(link);
                vm.settings.linkCollection.splice(index, 1);
                vm.saveSettings();
            }
        }

        vm.saveSettings = function (componentName, settings) {
            vm.saving = true;
            settingsApi.saveSettings(componentName, settings).then(function () {
                // Timeouts for UX actually see the saving messaged
                $timeout(function () {
                    vm.saving = false;
                }, 1000);
            }, function () {
                // handle errors?
            });
        };
    }
})();
(function () {

    angular.module("WizdomMobileModule").controller("linksEditController", linksEditController);

    linksEditController.$inject = ["$scope", "$window", "$modalInstance", "editLinkObjMaster"];

    function linksEditController($scope, $window, $modalInstance, editLinkObjMaster) {
        var vm = this;

        // Properties
        vm.newLinkObj = {};
        if (editLinkObjMaster != null) vm.editLinkObj = angular.copy(editLinkObjMaster);

        // Public methods
        vm.updateLink = updateLink;
        vm.cancel = cancel;


        function updateLink() {
            $modalInstance.close({
                editLinkObjMaster: editLinkObjMaster,
                editLinkObj: vm.editLinkObj
            });
        }

        function cancel() {
            $modalInstance.dismiss('cancel');
        };
    }
})();
(function () {
    angular.module("WizdomMobileModule").controller("navigationAdminController", navigationAdminController);

    navigationAdminController.$inject = ["$scope", "$timeout", "settingsApi", "$modal", "defaultNavigation"];

    function navigationAdminController($scope, $timeout, settingsApi, $modal, defaultNavigation) {

        // Properties

        // Load settings
        settingsApi.getSettings('navigation').then(function (response) {

            $scope.settings = response;
            $scope.tabs = $scope.settings.tabs;

            if (!Array.isArray($scope.tabs)) {
                $scope.tabs = $scope.settings.tabs = angular.copy(defaultNavigation);
            }
        });

        // Public methods
        $scope.editTab = function (tab) {
            $modal.open({
                templateUrl: 'WizdomMobileModule/App_Admin/Administration/Modules/Navigation/Templates/NavigationEditTemplate.html',
                controller: 'navigationEditController as navigationEditCtrl',
                windowClass: 'bootstrap-wrapper',
                resolve: {
                    editTabObjMaster: function () { return tab; }
                }
            }).result.then(function (data) {
                var index = $scope.tabs.indexOf(data.editTabObjMaster);
                angular.copy(data.editTabObj, $scope.tabs[index]);
                $scope.saveSettings('navigation', $scope.settings);
            });
        };

        $scope.saveSettings = function (componentName, settings) {
            $scope.saving = true;
            settingsApi.saveSettings(componentName, settings).then(function () {
                // Timeouts for UX actually see the saving messaged
                $timeout(function () {
                    $scope.saving = false;
                }, 1000);
            }, function () {
                // handle errors?
            });
        };       
    }

})();
(function () {

    angular.module("WizdomMobileModule").controller("navigationEditController", navigationEditController);

    navigationEditController.$inject = ["$scope", "$window", "$modalInstance", "editTabObjMaster"];

    function navigationEditController($scope, $window, $modalInstance, editTabObjMaster) {
        var vm = this;

        // Properties
        vm.newLinkObj = {};
        if (editTabObjMaster !== null) vm.editTabObj = angular.copy(editTabObjMaster);

        // Public methods
        vm.updateTab = updateTab;
        vm.cancel = cancel;


        function updateTab() {
            $modalInstance.close({
                editTabObjMaster: editTabObjMaster,
                editTabObj: vm.editTabObj
            });
        }

        function cancel() {
            $modalInstance.dismiss('cancel');
        }
    }
})();
(function () {
    angular.module('WizdomMobileModule').controller('ModalNewItemController', function ($scope, $modalInstance, tier, settingsApi) {
        var vm = this;
        vm.itemOptions = ["Link", "Header"];
        vm.newItem = {
            "guid": guid(),            
            "tier": tier,
            "nextTierItems": [],
            "type": "Link",
            "iconClass": "ms-Icon ms-Icon--TriangleSolidRight12",
            "toggleOpen": false
        };

        vm.ok = function () {
            if(vm.newItem.item)
                $modalInstance.close(vm.newItem);
        };

        vm.cancel = function () {
            $modalInstance.dismiss('cancel');
        };

        //Helper functions
        function guid() {
            function s4() {
                return Math.floor((1 + Math.random()) * 0x10000)
                    .toString(16)
                    .substring(1);
            }
            return s4() + s4() + s4() + s4() + '-' + s4() + s4() + s4() + '-' + s4() + '-' + s4() + s4() + s4() +
                s4() + '-' + s4() + s4();
        }
    });
})();

(function () {
    angular.module("WizdomMobileModule").controller("menuBuilderController", menuBuilderController);

    menuBuilderController.$inject = ["$scope", "administrationApi", "$timeout", "settingsApi", "$modal"];

    function menuBuilderController($scope, administrationApi, $timeout, settingsApi, $modal) {

        //initial data load
        settingsApi.getSettings("AppMenuBuilder").then(function (response) {
            $scope.menutree = response.length > 0 ? response : [];

        }, function (error) { console.log(error); });

        $scope.tempParent = {};      

        $scope.openNextTier = function (item) {
            item.open = !item.open;
        }

        $scope.saveConfig = function () {
            settingsApi.saveSettings("AppMenuBuilder",$scope.menutree).then(
                function () {
                    console.log("settings saved");
                }, function (error) {
                    console.log(error);
                }
            )
        };

        //Delete and remove functions
        $scope.deleteItem = function (guid) {
            if (confirm("Delete menu item")) {
                //Check if entry to delete is a tier 1 item
                var removeIndex = $scope.menutree.map(function (item) { return item.guid; })
                    .indexOf(guid);

                if (removeIndex !== -1) {
                    //remove tier 1 item
                    $scope.menutree.splice(removeIndex, 1);
                    var last = 0;
                    $scope.menutree
                        .sort(function (a, b) {
                            return a.order - b.order;
                        })
                        .forEach(function (l) {
                            if (l.order > (last + 1)) {
                                l.order--;
                            }

                            last++;
                        });
                } else {
                    //else loop through each tree from tier 1 items
                    for (var i = 0; i < $scope.menutree.length; i++) {
                        removeFromTree($scope.menutree[i], guid);
                    }

                }
                $scope.saveConfig();
            }
        };

        function removeFromTree(parent, childGuidToRemove) {
            //Recursive looping through three. remove the child which has the guid which we want to delete.
            parent.nextTierItems = parent.nextTierItems
                .filter(function (child) { return child.guid !== childGuidToRemove })
                .map(function (child) { return removeFromTree(child, childGuidToRemove) });
            return parent;
        }

        //Modal functions
        $scope.openNewItemModal = function (obj, tier, size) {
            $scope.tempParent = obj;

            var modalInstance = $modal.open({
                templateUrl: 'WizdomMobileModule/App_Admin/Administration/Modules/MenuBuilder/Templates/MenuBuilderAddTemplate.html',
                controller: 'ModalNewItemController as ModalNewItemCtrl',
                windowClass: 'bootstrap-wrapper',
                size: size,
                resolve: {
                    tier: function () {
                        return tier;
                    },                  
                }
            });

            modalInstance.result.then(function (newItem) {
                console.log(newItem);
                addNewItem(newItem);
            }, function (error) {
                console.log(error);
                });


            function addNewItem(newItem) {
                if (newItem.tier > 1) {
                    $scope.tempParent.nextTierItems.push(newItem);
                    $scope.tempParent = {};
                    $scope.saveConfig();
                } else {
                    var order = $scope.menutree.length + 1;
                    newItem.order = order;
                    $scope.menutree.push(newItem);
                    $scope.saveConfig();
                }

            };
        };

        $scope.openEditItemModal = function (obj, size) {
            
            var modalInstance = $modal.open({
                templateUrl: 'WizdomMobileModule/App_Admin/Administration/Modules/MenuBuilder/Templates/MenuBuilderEditTemplate.html',
                controller: 'ModalEditItemController as ModalEditItemCtrl',
                size: size,
                resolve: {
                    editItemObjMaster: function () {
                        return obj;
                    },
                }
            });

            modalInstance.result.then(function (data) {       
                console.log(data);
                var level2, level3;
                var found = false;

                //travel through arrays (including nested) and find item.
                for (i = 0; i < $scope.menutree.length; i++) {
                    level2 = $scope.menutree[i];
                    for (j = 0; j < level2.nextTierItems.length; j++) {
                        level3 = level2.nextTierItems[j];
                        for (h = 0; h < level3.nextTierItems.length; h++) {
                            if (level3.nextTierItems[h].guid === data.editItemObjMaster.guid) {
                                found = true;
                                angular.copy(data.editItem, level3.nextTierItems[h]);
                                break;
                            }
                        }

                        if (found)
                            break;

                        if (level2.nextTierItems[j].guid === data.editItemObjMaster.guid) {
                            found = true;
                            angular.copy(data.editItem, level2.nextTierItems[j]);
                            break;
                        }
                        
                    }

                    if (found)
                        break;

                    if ($scope.menutree[i].guid === data.editItemObjMaster.guid) {
                        found = true;
                        angular.copy(data.editItem, $scope.menutree[i]);
                        break;
                    }
                    
                }
                $scope.saveConfig();
            }, function (error) {
                console.log(error);
            });
        };


        //Order functions
        // Return array of options 1 to length of links array (5 links -> returns [1, 2, 3, 4, 5])
        $scope.getOrderOptions = function () {
            var options = [];
            for (var i = 0; i < $scope.menutree.length; i++) {
                options.push(i + 1);
            }
            return options;
        };

        // Change order value of other links depending on selection
        $scope.onOrderChange = function (link, prevStr) {
            var prev = parseInt(prevStr, 10);

            if (link.order > prev) { // If order was increased, decrease the order value of links between the previous and new position
                $scope.menutree.forEach(function (l) {
                    if (l !== link && l.order > prev && l.order <= link.order) {
                        l.order--;
                    }
                });
            } else if (link.order < prev) { // If order was decreased, increase the order value of links between the previous and new position
                $scope.menutree.forEach(function (l) {
                    if (l !== link && l.order < prev && l.order >= link.order) {
                        l.order++;
                    }
                });
            }
            $scope.saveConfig();
            
        };
    }

})();
(function () {
    angular.module('WizdomMobileModule').controller('ModalEditItemController', function ($scope, $modalInstance, editItemObjMaster) {

        var vm = this;

        vm.editItem = angular.copy(editItemObjMaster);

        vm.itemOptions = ["Header", "Link"];

        vm.ok = function () {
            $modalInstance.close({
                editItemObjMaster: editItemObjMaster,
                editItem: vm.editItem
            });
        };

        vm.cancel = function () {
            $modalInstance.dismiss('cancel');
        };
    });
})();
(function () {

    angular.module("WizdomMobileModule").controller("welcomeAdminController", welcomeAdminController);

    welcomeAdminController.$inject = ['settingsApi', '$timeout', '$window'];

    function welcomeAdminController(settingsApi, $timeout, $window) {
        var vm = this;

        // Properties 
        vm.welcomeTypeOptions = ["Personal banner", "Custom banner"];

        // Public methods
        vm.welcomeBannerEnabled = welcomeBannerEnabled;
        vm.chosenType = chosenType;

        // Get settings 
        settingsApi.getSettings('Welcome').then(function (response) {
            vm.settings = response;
            vm.settings.customEnabled = false;
            vm.settings.imageStyle = vm.settings.imageStyle || {
                height: '150',
                width: '150',
                objectFitArr: ['fill', 'contain', 'cover', 'scale-down', 'none']
            };
        });

        vm.saveSettings = function (componentName, settings) {
            vm.saving = true;
            settingsApi.saveSettings(componentName, settings).then(function () {
                $timeout(function () {
                    vm.saving = false;
                }, 1000);
            }, function () {
            });
        };

        function welcomeBannerEnabled() {
            vm.saveSettings();
        }

        function chosenType(selectedType) {
            vm.settings.selectedType = selectedType;
        }
    }
})();
(function () {

    angular.module("WizdomMobileModule").controller("pushCorporateNewsController", pushCorporateNewsController);
    pushCorporateNewsController.$inject = ["$scope", "$window", "$q", "settingsApi", "wcmStarterHttpApi"];
    function pushCorporateNewsController($scope, $window, $q, settingsApi, httpApi ) {
        var vm = this;

        // Properties
        vm.corporateNewsSettings;
        vm.news;

        // Load settings
        settingsApi.getSettings('CorporateNews').then(function (response) {
            vm.corporateNewsSettings = response;

            // Init app
            initialize();
        });
        

        // Public methods
        vm.sendPushNotification = sendPushNotification;

        // Private methods
        function initialize() {
            // Check if settings are available
            if (Object.keys(vm.corporateNewsSettings).length !== 0 && vm.corporateNewsSettings.constructor === Object) {
                // Load latest corporate news
                getWizdomCorporateNews(null, null, null);
            }
        }

        // Retrieve Wizdom corporate news based on news settings configured in the mobile app
        function getWizdomCorporateNews() {
            var selectPropertiesUrl = "";
            if (typeof vm.corporateNewsSettings.selectProperties !== "undefined") {
                angular.forEach(vm.corporateNewsSettings.selectProperties, function (property) {
                    selectPropertiesUrl += "&selectProperties=" + property;
                });
            }

            httpApi.get("wizdom://api/wizdom/corporateNews" +
                "/news?path=" + encodeURIComponent(vm.corporateNewsSettings.path ? vm.corporateNewsSettings.path : "") +
                "&numberOfNews=" + vm.corporateNewsSettings.numberOfNews +
                "&typeNews=" + vm.corporateNewsSettings.typeNews +
                "&orderBy=" + vm.corporateNewsSettings.orderBy +
                "&ascending=" + vm.corporateNewsSettings.ascending +
                "&cachingType=" + vm.corporateNewsSettings.cachingType +
                "&resultSource=" + vm.corporateNewsSettings.resultSource +
                "&languageFilter=" + encodeURIComponent(vm.corporateNewsSettings.languageFilterUseDynamic ? vm.corporateNewsSettings.languageFilterDynamic : vm.corporateNewsSettings.languageFilter.map(e => e.label).join(';')) +
                "&departmentFilter=" + encodeURIComponent(vm.corporateNewsSettings.departmentFilterUseDynamic ? vm.corporateNewsSettings.departmentFilterDynamic : vm.corporateNewsSettings.departmentFilter.map(e => e.label).join(';')) +
                "&locationFilter=" + encodeURIComponent(vm.corporateNewsSettings.locationFilterUseDynamic ? vm.corporateNewsSettings.locationFilterDynamic : vm.corporateNewsSettings.locationFilter.map(e => e.label).join(';')) +
                "&languageFilterUseDynamic=" + encodeURIComponent(vm.corporateNewsSettings.languageFilterUseDynamic) +
                "&departmentFilterUseDynamic=" + encodeURIComponent(vm.corporateNewsSettings.departmentFilterUseDynamic) +
                "&locationFilterUseDynamic=" + encodeURIComponent(vm.corporateNewsSettings.locationFilterUseDynamic) +
                "&includeModernNews=" + encodeURIComponent(vm.corporateNewsSettings.includeModernNews) +
                "&modernPath=" + encodeURIComponent(vm.corporateNewsSettings.pathModern ? vm.corporateNewsSettings.pathModern : "") +// + vm.corporateNewsSettings.pathModern + //
                "&includeClassicNews=" + encodeURIComponent(vm.corporateNewsSettings.includeClassicNews) +
                selectPropertiesUrl).then(function (response) {
                    vm.news = response;
                });
        }

        function sendPushNotification(itemUrl) {
            var confirm = $window.confirm(`Are you sure you want to push this message? Remember, there is no security trimming and this will impact every user with the mobile app installed and notifications enabled.`);
            if (confirm) {
                httpApi.post(`wizdom://api/wizdom/corporateNews/news/SendPush`, itemUrl).then(function (response) {
                    console.log(`Corporate news push notification send:` + response);
                });
            }
        }
    }

})();
(function () {

    angular.module("WizdomMobileModule").controller("pushController", pushController);
    pushController.$inject = ["$scope", "pushRegistrationsService"];
    function pushController($scope, pushRegistrationsService) {
        var vm = this;

        // Properties
        vm.globalPushEvents = [];

        // Public methods
        vm.eventTypeChecked = eventTypeChecked;
        vm.toggleEventState = toggleEventState;

        /**
         * Initializes the application
         * */
        function initialize() {
            // Get default event settings
            pushRegistrationsService.getGlobalPushEventDefaults().then(function (response) {
                vm.globalPushEvents = response || [];
            });
        }
        initialize();

        function eventTypeChecked(eventTypeArr) {
            exists = false;
            for (var i = 0; i < eventTypeArr.length; i++) {
                if (typeof vm.globalPushEvents[eventTypeArr[i]] !== 'undefined') {
                    if (vm.globalPushEvents[eventTypeArr[i]] === true) exists = true;
                }
            }
            return exists;
        }

        function toggleEventState(event, removeEventsArr) {

            // Check to ad