﻿(function () {

    angular.module("WizdomMobileModule").factory("webApiProxy", webApiProxy);

    webApiProxy.$inject = ["$q", "wcmStarterHttpApi", "contextInfo"];

    function webApiProxy($q, httpApi, contextInfo) {
        var service = {
            cache: {
                baseUrl: "wizdom://api/wizdom/365/cache/",
                getCache: function () {
                    return httpApi.get(this.baseUrl);
                },
                clearCache: function () {
                    return httpApi.get(this.baseUrl + "clear").then((timestamp) => window["Wizdom365Config"]["@timestamp"] = timestamp);
                },
                clearModuleCache: function (module) {
                    return httpApi.get(this.baseUrl + "clear/" + module);
                },
                clearBrowserCache: function () {
                    return httpApi.get(this.baseUrl + "clearBrowserCache");
                }
            },
            sitecollections: {
                baseUrl: "wizdom://api/wizdom/365/sitecollections",
                getSitecollections: function () {
                    return httpApi.get(this.baseUrl);
                },
                getSingleSitecollection: function () {
                    return httpApi.get(this.baseUrl);
                }
            },
            searchPerson: {
                baseUrl: "wizdom://api/wizdom/searchPerson/search",
                search: function (searchTerm, index, numberOfUsers, selectProperties, resultSource, pageIndex, orderProperties) {
                    var url = this.baseUrl + "?queryText=" + encodeURIComponent(searchTerm) + "&index=" + index;
                    //var url = this.baseUrl + "?queryText=" + searchTerm + "&index=" + index;
                    if (numberOfUsers) {
                        url += "&numberOfUsersPerPage=" + numberOfUsers;
                    }
                    if (selectProperties) {
                        angular.forEach(selectProperties, function (property) {
                            url += "&selectProperties=" + property;
                        });
                    }
                    if (orderProperties) {
                        angular.forEach(orderProperties, function (property) {
                            url += "&orderProperties=" + property.property + "|" + property.orderDirection;
                        });
                    }
                    if (resultSource) {
                        url += "&resultSource=" + resultSource;
                    }
                    if (pageIndex) {
                        url += "&pageindex=" + pageIndex;
                    }
                    return httpApi.get(url);
                }
            },
            terms: {
                baseUrl: "wizdom://api/wizdom/365/terms",
                batchGroup: "terms",
                getAllTermsById: function (termId) {
                    return httpApi.get(this.baseUrl + "?termId=" + termId);
                },
                getAllTermsWithIDsById: function (termId) {
                    return httpApi.get(this.baseUrl + "/withids?termId=" + termId);
                },
                getAllTermsWithIDsByFieldName: function (fieldName) {
                    return httpApi.get(this.baseUrl + "/withFieldName?fieldName=" + fieldName);
                },
                getAllTermsWithChildrenById: function (termId) {
                    return httpApi.get(this.baseUrl + "/nested?termId=" + termId);
                },
                getAllTermsWithChildrenByFieldName: function (fieldName) {
                    return httpApi.get(this.baseUrl + "/nested?fieldName=" + fieldName);
                },
                getAllTermSets: function (sourceurl) {
                    return httpApi.get(this.baseUrl + "/AllTermSets" + (angular.isDefined(sourceurl) ? "?sourceurl=" + sourceurl : ""));
                },
                getAllTermsWithPagingById: function (termId, pageSize, pageNo) {
                    return httpApi.get(this.baseUrl + "/withpaging?termId=" + termId + "&pageSize=" + pageSize + "&pageNo=" + pageNo);
                },
                searchTerms: function (termId, searchText) {
                    return httpApi.get(this.baseUrl + "/search?termId=" + termId + "&searchText=" + searchText);
                },
                getTermsCount: function (termId) {
                    return httpApi.get(this.baseUrl + "/count?termId=" + termId);
                }
            },
            principals: {
                baseUrl: "wizdom://api/wizdom/365/principals",
                ensure: function (principal) {
                    return httpApi.post(this.baseUrl + "/ensure", principal);
                },
                searchGroups: function (searchTerm, includeWizdomGroups) {
                    includeWizdomGroups = includeWizdomGroups || false;
                    return httpApi.get(this.baseUrl + "/searchGroups?searchTerm=" + encodeURIComponent(searchTerm) + "&includeWizdomGroups=" + includeWizdomGroups);
                },
                searchUsers: function (searchTerm) {
                    return httpApi.get(this.baseUrl + "/searchUsers('" + searchTerm + "')/"); // Traling '/' added to allow "." in searchTerm parameter
                },
                searchUsersAndGroups: function (searchTerm, includeWizdomGroups) {
                    includeWizdomGroups = includeWizdomGroups || false;
                    return httpApi.get(this.baseUrl + "/searchUsersAndGroups('" + searchTerm + "'," + includeWizdomGroups + ")/"); // Traling '/' added to allow "." in searchTerm parameter
                },
                current: function () {
                    return httpApi.get(this.baseUrl + "/me");
                },
                currentUserGroups: function () {
                    return httpApi.get(this.baseUrl + "/me/groups");
                },
                forgetUser: function (userToForget) {
                    return httpApi.post(this.baseUrl + "/forgetUser", userToForget);
                },
                forgetUsers: function (usersToForget) {
                    return httpApi.post(this.baseUrl + "/forgetUsers", usersToForget);
                }
            },
            social: {
                baseUrl: "wizdom://api/wizdom/365/social/",
                addMentio: function (mentioList) {
                    return httpApi.post(this.baseUrl + "mentio", mentioList);
                },
                getFullComments: function (ids) {
                    return httpApi.get(this.baseUrl + "comments/" + ids);
                },
                deleteComment: function (id) {
                    return httpApi.delete(this.baseUrl + "comments/" + id);
                },
                likeItem: function (likeDto) {
                    return httpApi.post(this.baseUrl + "like", likeDto);
                },
                saveComment: function (comment) {
                    return httpApi.post(this.baseUrl + "comments", comment);
                },
                getSocialOverview: function (id, type) {
                    return httpApi.get(this.baseUrl + "overview/" + id + "/" + type);
                },
                getCommentsTree: function (itemId, targetId, targetType, targetLastCommentId, allowedlevel) {
                    return httpApi.get(this.baseUrl + "commentstree?itemId=" + itemId + "&targetId=" + targetId + "&type=" + targetType + "&lastId=" + targetLastCommentId + "&allowedlevel=" + allowedlevel);
                }
            },
            translations: {
                baseUrl: "wizdom://api/wizdom/365/translations",
                get: function () {
                    return httpApi.get(this.baseUrl);
                },
                setTranslationValue: function (languageCode, key, value) {
                    var translation = {
                        key: key,
                        value: value
                    };
                    return httpApi.put(this.baseUrl + "/" + languageCode, translation);
                },
                uploadTranslationFile: function (languageCode, file) {
                    return httpApi.post(this.baseUrl + "/" + languageCode + "/file", file);
                },
                getTranslation: function (key) {
                    return httpApi.get(this.baseUrl + "/translate/" + key);
                },
                getMyLocale: function () {
                    return httpApi.get(this.baseUrl + "/getmylocale");
                }
            }
        };

        return service;
    }
})();