﻿(function () {
    angular.module("WizdomMobileModule").factory("principalsApi", principalsApi);

    principalsApi.$inject = ["wcmStarterHttpApi"];

    function principalsApi(webApi) {
        var wizdomCall = "wizdom://";
        var service = {
            principals: {
                baseUrl: wizdomCall + "api/wizdom/365/principals",
                ensure: function (principal) {
                    return httpApi.post(this.baseUrl + "/ensure", principal);
                },
                searchForPrincipal: function (searchTerm) {
                    return httpApi.get(this.baseUrl + "/searchUsers('" + searchTerm + "')");
                },
                ensure: function (principal) {
                    return httpApi.post(this.baseUrl + "/ensure", principal);
                },
                searchGroups: function (searchTerm) {
                    return httpApi.get(this.baseUrl + "/searchGroups('" + searchTerm + "')");
                },
                searchUsers: function (searchTerm) {
                    return httpApi.get(this.baseUrl + "/searchUsers('" + searchTerm + "')");
                },
                searchUsersAndGroups: function (searchTerm) {
                    return httpApi.get(this.baseUrl + "/searchUsersAndGroups('" + searchTerm + "')");
                },
                current: function () {
                    return httpApi.get(this.baseUrl + "/me");
                }
            },

        };

        return service;
    }
   
})();