﻿(function () {
    angular.module('WizdomMobileModule').factory('noticeboardService', noticeboardService);
    noticeboardService.$inject = ['$window', 'wcmStarterHttpApi', 'contextInfo'];

    function noticeboardService($window, httpApi, contextInfo) {

        var baseUrl = new URL($window.document.referrer).origin; // Necessary to get WizdomAppUrl from document refererrer, since admin settings lives inside iframe

        // CHANNEL SETS
        // Get
        function getChannelSets() {
            return httpApi.get(baseUrl + '/api/wizdom/noticeboard/1.0/channelsets').then(function (response) {
                return response.channelSets.results;
            });
        }

        function getChannelsetChannels(channelsetId) {
            return httpApi.get(baseUrl + '/api/wizdom/noticeboard/1.0/channelsets/' + channelsetId + '/channels').then(function (response) {
                return response.channels.results;
            });
        }

        // VIEWS

        function getViewById(viewId) {
            return httpApi.get(baseUrl + '/api/wizdom/noticeboard/1.0/views/' + viewId);
        }

        function postViewById(viewId, data) {
            return httpApi.post(baseUrl + '/api/wizdom/noticeboard/1.0/views/', data);
        }

        function putViewById(viewId, data) {
            return httpApi.put(baseUrl + '/api/wizdom/noticeboard/1.0/views/' + viewId, data);
        }

        var service = {
            getChannelSets: getChannelSets,
            getChannelsetChannels: getChannelsetChannels,
            getViewById: getViewById,
            postViewById: postViewById,
            putViewById: putViewById
        };

        return service;
    }
})();