﻿(function () {
    angular.module("WizdomMobileModule")
        .controller("Wizdom365TaxonomyPickerTreeController", Wizdom365TaxonomyPickerTreeController);

    Wizdom365TaxonomyPickerTreeController.$inject = ["$scope", "webApiProxy", "termsetId", "$modalInstance", "multiSelect", "preSelectedTerms", "fieldName"];

    function Wizdom365TaxonomyPickerTreeController($scope, webApiProxy, termsetId, $modalInstance, multiSelect, preSelectedTerms, fieldName) {
        $scope.selectedTerms = [];
        $scope.selectedTerm = {};
        $scope.expandedNodes = [];
        $scope.treeOptions = {
            nodeChildren: "children",
            dirSelectable: true,
            multiSelection: multiSelect,
            isSelectable: function (node) { return node.isAvailableForTagging; }
        }
        $scope.loading = true;
        $scope.errorState = false;

        if (fieldName) {
            webApiProxy.terms.getAllTermsWithChildrenByFieldName(fieldName).then(function (data) {
                processreturnedData(data);
                expandNodes();
                $scope.loading = false;
            }, function (error) {
                $scope.loading = false;
                $scope.errorState = true;
            });
        }
        else {
            webApiProxy.terms.getAllTermsWithChildrenById(termsetId).then(function (data) {
                processreturnedData(data);
                expandNodes();
                $scope.loading = false;
            }, function (error) {
                $scope.loading = false;
                $scope.errorState = true;
            });
        }
        function processreturnedData(data) {
            $scope.termsTreeData = data;
            angular.forEach(preSelectedTerms, function (term) {
                var reformattedTerm = {
                    'name': term.label,
                    'isAvailableForTagging': (angular.isDefined(term.isAvailableForTagging) ? term.isAvailabeForTagging : true),
                    'id': angular.isDefined(term.filter) ? term.filter.substring(term.filter.indexOf('|') + 1) : (angular.isDefined(term.id) ? term.id : "undefined")
                };
                multiSelect ? $scope.selectedTerms.push(reformattedTerm) : $scope.selectedTerm = reformattedTerm;
            });
        }

        function expandNodes() {
            var i,
                selectedElms = [],
                tree = $scope.termsTreeData;

            if (!multiSelect && angular.isDefined($scope.selectedTerm.id)) {
                selectedElms.push($scope.selectedTerm);
            } else {
                selectedElms = $scope.selectedTerms;
            }

            var flattenedTree = findParents(tree, [], "");
            for (i = 0; i < selectedElms.length; i++) {
                var node = flattenedTree.find(ft => ft.id == selectedElms[i].id);
                //var node = _.find(flattenedTree, { 'id': selectedElms[i].id });
                if (angular.isDefined(node) && angular.isDefined(node["id"]))
                    expandNodesRecursively(node, flattenedTree);
            }

        }
        function expandNodesRecursively(node, flattenedTree) {
            addExpandedNode(node);
            if (node["parent"] !== "") {
                var parent = flattenedTree.find(ft => ft.id == node["parentId"]);
                //var parent = _.find(flattenedTree, { 'id': node["parentId"] });
                if (angular.isDefined(parent))
                    expandNodesRecursively(parent, flattenedTree);
            }

        }

        function addExpandedNode(node) {

            //if (!_.find($scope.expandedNodes, { 'id': node.id })) {
            if (!$scope.expandedNodes.find(en => en.id == node.id)) {
                $scope.expandedNodes.push({ 'id': node.id, 'name': node.name, 'isAvailableForTagging': node.isAvailableForTagging });
            }
        }
        function findParents(tree, flattenedTree, parent) {
            var y;
            for (y = 0; y < tree.length; y++) {
                var elm = { 'id': tree[y].id, 'name': tree[y].name, 'parentId': parent, 'isAvailableForTagging': tree[y].isAvailableForTagging };
                flattenedTree.push(elm);
                if (tree[y].children.length > 0)
                    findParents(tree[y].children, flattenedTree, elm.id);
            }
            return flattenedTree;
        }
        $scope.nodeSelected = function (node, selected, parent) {

        }
        $scope.cancel = function () {
            $modalInstance.dismiss('cancel');
        }

        $scope.save = function () {
            if (!multiSelect)
                $scope.selectedTerms.push($scope.selectedTerm);
            $modalInstance.close($scope.selectedTerms);
        }
    }
})();