﻿(function () {
    angular.module("WizdomMobileModule")
        .directive("wizdom365Taxonomypicker", wizdom365Taxonomypicker);

    function wizdom365Taxonomypicker() {

        return {
            scope: {
                selectedTerms: '=',
                termSetId: '@?',
                fieldName: '@?',
                allowOnlyOneTerm: '@?',
                ngRequired: '=ngRequired',
                placeholder: '@?'
            },
            templateUrl: "WizdomMobileModule/App_Admin/Directives/TaxonomyPicker/TaxonomyPicker.html",
            controller: wizdom365TaxonomypickerController
        };
    }

    wizdom365TaxonomypickerController.$inject = [
        "$filter", "$scope", "webApiProxy", "$modal"
    ];

    function wizdom365TaxonomypickerController(
        $filter, $scope, webApiProxy, $modal) {

        function initialize() {
            if ($scope.ngRequired == null || $scope.ngRequired == undefined)
                $scope.required = false;
            else
                $scope.required = $scope.ngRequired;
            $scope.selectedTerms = angular.copy($scope.selectedTerms || []);
            $scope.termSetList = [];

            if ($scope.fieldName) {
                webApiProxy.terms.getAllTermsWithIDsByFieldName($scope.fieldName).then(function (data) {
                    $scope.termSetList = data;
                });
            }
            else {
                if ($scope.termSetId == null || $scope.termSetId === "")
                    return;

                webApiProxy.terms.getAllTermsWithIDsById($scope.termSetId).then(function (data) {
                    $scope.termSetList = data;
                });
            }

        }

        $scope.filterSelected = function ($item, $model, $label) {
            //Check if selected term is already selected (no need to add term twice)
            var blnTermAlreadySelected = false;
            for (var i = 0; i < $scope.selectedTerms.length; ++i) {
                var term = $scope.selectedTerms[i];
                if (term.label == $label) {
                    blnTermAlreadySelected = true;
                    break;
                }
            }

            if (!blnTermAlreadySelected) {
                $scope.selectedTerms.push({ label: $label, filter: $item.name + "|" + $item.id });
            }

        };

        $scope.removeFilter = function (filter) {
            var index = $scope.selectedTerms.indexOf(filter);
            $scope.selectedTerms.splice(index, 1);
        };

        $scope.pickTermSet = function () {
            $modal.open({
                templateUrl: "WizdomMobileModule/App_Admin/Directives/TaxonomyPicker/TaxonomyPickerTree.html",
                controller: "Wizdom365TaxonomyPickerTreeController",
                windowClass: "bootstrap-wrapper",
                resolve: {
                    "termsetId": function () { return $scope.termSetId; },
                    "multiSelect": function () { return !($scope.allowOnlyOneTerm === 'true'); },
                    "preSelectedTerms": function () { return $scope.selectedTerms; },
                    "fieldName": function () { return $scope.fieldName }
                }
            }).result.then(
                function (data) {
                    if (!data) return;
                    $scope.selectedTerms = [];
                    angular.forEach(data, function (term) {
                        $scope.selectedTerms.push({ label: term.name, filter: term.name + "|" + term.id });
                    });
                });
        };


        initialize();
    }
})(); 