﻿(function () {
    angular.module("WizdomMobileModule").directive("wcmStarterPrincipalpicker", wcmStarterPrincipalpicker);

    function wcmStarterPrincipalpicker() {

        return {
            scope: {
                principals: '=',
                useUserImg: '@?',
                mode: '@?', //users,groups,all
                placeholder: '@?',
                addFn: '&?',
                removeFn: '&?',
                allowmultiple: '@?',
                alloweveryone: '@?'
            },
            templateUrl: "WizdomMobileModule/App/Templates/PrincipalPicker.html",
            controller: wcmStarterPrincipalpickerController
        };
    }

    wcmStarterPrincipalpickerController.$inject = ["$scope", "principalsApi", "$timeout"];

    function wcmStarterPrincipalpickerController($scope, principalsApi, $timeout) {

        function initialize() {
            if ($scope.mode == null || $scope.mode == "")
                $scope.mode = "all";

            if ($scope.useUserImg == null)
                $scope.useUserImg = true;

            if ($scope.allowmultiple == null || $scope.allowmultiple == "")
                $scope.allowmultiple = true;
            else
                $scope.allowmultiple = JSON.parse($scope.allowmultiple);            

            if ($scope.principals == null)
                $scope.principals = [];

            if ($scope.placeholder == null) {
                var translateString = "Select ";
                if ($scope.mode == "all") {
                    if ($scope.allowmultiple)
                        translateString += "users or groups";
                    else
                        translateString += "user or group";
                }
                else {
                    if ($scope.mode == "users")
                        translateString += "user";
                    if ($scope.mode == "groups")
                        translateString += "group";
                    if ($scope.allowmultiple)
                        translateString += "s";
                }
                //$scope.placeholder = $filter("translate")(translateString);
                $scope.placeholder = translateString;
            }
        }

        $scope.searchForPrincipal = function (searchTerm) {
            if (!searchTerm || searchTerm.length < 2)
                return [];
            
            if ($scope.mode == "all")
                return principalsApi.principals.searchUsersAndGroups(searchTerm)
                    .then(function (results) {
                        appendEveryone(searchTerm, results);
                        return limitResult(results, 5);
                    });
            if ($scope.mode == "users")
                return principalsApi.principals.searchUsers(searchTerm)
                    .then(function (results) {
                        appendEveryone(searchTerm, results);
                        return limitResult(results, 5);
                    });
            if ($scope.mode == "groups")
                return principalsApi.principals.searchGroups(searchTerm)
                    .then(function (results) {
                        appendEveryone(searchTerm, results);
                        return limitResult(results, 5);
                    });

            function appendEveryone(searchTerm, results) {
                if ($scope.alloweveryone) {
                    //displayName: $filter('translate')("Everybody"),
                    var everyone = {
                        id: "WizdomEverybody",
                        displayName: "Everybody",
                        loginName: "Everybody"
                    };
                    if (everyone.displayName.toLowerCase().indexOf(searchTerm.toLowerCase()) > -1 ||
                        everyone.loginName.toLowerCase().indexOf(searchTerm.toLowerCase()) > -1)
                        results.push(everyone);
                }                
            }

            function limitResult(results, limit) {
                $scope.showingMax = false;
                if (results.length > limit) {
                    results.slice(0, limit);
                    $scope.showingMax = true;
                    results[0].resultSetLimitedTo = limit; 
                }
                return results;
            }
        };

        $scope.addPrincipal = function (principal) {            
            if (!$scope.allowmultiple) {
                if ($scope.removeFn != null) {
                    var principals = angular.copy($scope.principals), len = principals.length;
                    for (var i = 0; i < len; i++) {
                        $scope.removePrincipal(principals[i]);
                    }
                }
            }

            if (collectionContains($scope.principals, principal))
                return;
            
            principalsApi.principals.ensure(principal)
                .then(function (result) {                    
                    $scope.principals.push(principal);
                    $scope.principals.sort(function (a, b) {
                        if (a.displayName < b.displayName) return -1;
                        else return 1;
                    });

                    $scope.asyncSelected = '';
                    if ($scope.addFn != null)
                        $scope.addFn({ principal: principal });                    
                });                     
        }
        


        $scope.removePrincipal = function (principal) {
            if (!collectionContains($scope.principals, principal))
                return;
            var newCollection = [];
            var len = $scope.principals.length;
            for (var i = 0; i < len; i++) {
                var user = $scope.principals[i];
                if (user.id != principal.id && user.groupId != principal.groupId) {
                    newCollection.push(user);
                }
            }
            $scope.principals = newCollection;

            if ($scope.removeFn != null)
                $scope.removeFn({ principal: principal });
        }

        function collectionContains(collection, principal) {
            var len = collection.length;
            for (var i = 0; i < len; i++) {
                existingPrincipal = collection[i];
                if (existingPrincipal.id == principal.id ||
                    (existingPrincipal.loginName && existingPrincipal.loginName == principal.loginName) ||
                    (principal.groupId && existingPrincipal.groupId == principal.groupId)) {
                    return true;
                }
            }
            return false;
            }

        $timeout(initialize, 100);
        }
    })();