﻿(function () {

    angular.module("WizdomMobileModule").controller("themeAdminController", themeAdminController);
    themeAdminController.$inject = ["$scope", "$timeout", "settingsApi", "colorShadeService"];
    function themeAdminController($scope, $timeout, settingsApi, colorShadeService) {
        var vm = this;

        var defaultThemes = [
            {
                name: 'Grey',
                primaryColor: '#515151',
                primaryFontColor: '#ffffff',
                secondaryColor: '#a4a4a4',
                secondaryFontColor: '#ffffff'
            },
            {
                name: 'Blue',
                primaryColor: '#003748',
                primaryFontColor: '#ffffff',
                secondaryColor: '#205683',
                secondaryFontColor: '#ffffff'
            },
            {
                name: 'Green',
                primaryColor: '#5a782d',
                primaryFontColor: '#ffffff',
                secondaryColor: '#88b04b',
                secondaryFontColor: '#ffffff'
            },
            {
                name: 'Red',
                primaryColor: '#ac1310',
                primaryFontColor: '#ffffff',
                secondaryColor: '#f44142',
                secondaryFontColor: '#ffffff'
            }

        ];
        var defaultFonts = [
            {
                name: 'Segoe',
                fontFamily: 'Segoe UI, Arial'
            },
            {
                name: 'Arial',
                fontFamily: 'Arial, Sans'
            }
        ];

        vm.defaultThemes = defaultThemes;
        vm.defaultFonts = defaultFonts;
        vm.colorShadeService = colorShadeService;

        vm.status = {
            isFirstOpen: true
        };


        //function setProperties(theme) {
        //    //primary
        //    document.documentElement.style.setProperty('--PrimaryColor', theme.primaryColor);
        //    document.documentElement.style.setProperty('--PrimaryShade', vm.colorShadeService.shadeColor(theme.primaryColor, 0.2));
        //    document.documentElement.style.setProperty('--PrimaryFontColor', theme.primaryFontColor);

        //    //secondary
        //    document.documentElement.style.setProperty('--SecondaryColor', theme.secondaryColor);
        //    document.documentElement.style.setProperty('--SecondaryShade', vm.colorShadeService.shadeColor(theme.secondaryColor, 0.2));
        //    document.documentElement.style.setProperty('--SecondaryFontColor', theme.secondaryFontColor);
        //}

        // private methods

        function getSettings() {
            settingsApi.getSettings('Theme').then(function (response) {
                vm.themeSettings = response;
                
                vm.themeSettings.themes = vm.themeSettings.themes || [];
                vm.themeSettings.fonts = vm.themeSettings.fonts || [];

                var respTheme = vm.selectedTheme || response.selectedTheme;
                var respFont = vm.selectedFont || response.selectedFont;

                var selTheme = {};
                var selFont = {};

                if (respTheme) {
                    selTheme = vm.defaultThemes.filter(function (ele) { return ele.name == respTheme.name })[0] ||
                        vm.themeSettings.themes.filter(function (ele) { return ele.name == respTheme.name })[0];
                }
                if (respFont) {
                    selFont = vm.defaultFonts.filter(function (ele) { return ele.name == respFont.name })[0] ||
                        vm.themeSettings.fonts.filter(function (ele) { return ele.name == respFont.name })[0];
                }

                vm.selectedTheme = selTheme || {};
                vm.selectedFont = selFont || {};
            });
        }

        function init() {
            getSettings();
        }
        init();

        // public methods

        vm.addSetting = function (type, obj) {
            if (!vm.themeSettings[type].filter(function (ele) { return ele.name === obj.name }).length) {
                vm.themeSettings[type].push(angular.copy(obj));
            }
        };

        vm.removeTheme = function (type, index) {
            // find a way to test for both theme and font selected
            if (vm.themeSettings[type][index] != vm.themeSettings.selectedTheme) {
                vm.themeSettings[type].splice(index, 1);
            } else {
                alert('Not possible to remove ' + vm.themeSettings[type].themes[index].name + ' because its the one in use')
            }
        };

        vm.saveSettings = function (componentName, settings) {
            vm.saving = true;
            settings.selectedTheme = vm.selectedTheme;
            settings.selectedFont = vm.selectedFont;

            settingsApi.saveSettings(componentName, settings).then(function () {
                // Timeouts for UX actually see the saving messaged
                $timeout(function () {
                    vm.saving = false;
                }, 1000);
            }, function () {
                // handle errors?
            });
        };
    }

})();