﻿(function () {

    angular.module("WizdomMobileModule").controller("PeopleAdminController", PeopleAdminController);
    PeopleAdminController.$inject = ["$scope", "$window", "$timeout", "settingsApi"];
    function PeopleAdminController($scope, $window, $timeout, settingsApi) {
        var vm = this;

        // Properties
        vm.peopleSettings;
        vm.newManagedPropertyTitle;
        
        vm.saving = false;

        // Load settings
        settingsApi.getSettings('People').then(function (response) {
            vm.peopleSettings = response;
            vm.peopleSettings.managedProperties = response.managedProperties || [];
            vm.peopleSettings.enableSuggestedPeople = response.enableSuggestedPeople || false;
            vm.peopleSettings.resultSourceId = response.resultSourceId || null;
        });

        // Public methods
        vm.saveSettings = saveSettings;
        vm.addManagedProperty = addManagedProperty;
        vm.deleteManagedProperty = deleteManagedProperty;

        // Private methods
        function saveSettings(componentName, settings) {
            vm.saving = true;
            settingsApi.saveSettings(componentName, settings).then(function () {
                // Timeouts for UX actually see the saving messaged
                $timeout(function () {
                    vm.saving = false;
                }, 1000);
            }, function () {
                // handle errors?
            });
        }

        function addManagedProperty(title) {
            if (vm.peopleSettings.managedProperties.indexOf(title) == -1) {
                vm.peopleSettings.managedProperties.push(title);
                vm.newManagedPropertyTitle = '';
                saveSettings('People', vm.peopleSettings);
            }
        }

        function deleteManagedProperty(title) {
            var confirm = $window.confirm("Are you absolutely sure you want to delete?");
            if (confirm) {
                var index = vm.peopleSettings.managedProperties.indexOf(title);
                vm.peopleSettings.managedProperties.splice(index, 1);
                vm.saveSettings('People', vm.peopleSettings);
            }
        }
    }

})();