﻿(function () {

    angular.module("WizdomMobileModule").controller("HomeAdminController", HomeAdminController);
    HomeAdminController.$inject = ["$scope", "$timeout", "settingsApi"];
    function HomeAdminController($scope, $timeout, settingsApi) {
        var vm = this;

        settingsApi.getSettings('NewsLatest').then(function (response) {
            vm.latestNewsSettings = response;
        });

        vm.saveSettings = function(componentName, settings) {
            vm.saving = true;
            settingsApi.saveSettings(componentName, settings).then(function () {
                // Timeouts for UX actually see the saving messaged
                $timeout(function () {
                    vm.saving = false;
                }, 1000);
            }, function () {
                // handle errors?
            });
        }
    }

})();