﻿(function () {
    
    angular.module("WizdomMobileModule").controller("administrationController", administrationController);

    administrationController.$inject = ["$scope", "administrationApi", "wcmStarterSettingsApi", "log"];

    function administrationController($scope, administrationApi, wcmStarterSettingsApi, log) {
        var vm = this;

        vm.menuItemClick = menuItemClick;

        vm.selectedPage = '';
        vm.menuReady = false;

        administrationApi.pagesTree().then(function (data) {
            vm.tree = data;
            if (data && data.length > 0) {
                vm.selectedPage = data[0].Path;
            }
            vm.menuReady = true;
        });

        //wcmStarterSettingsApi.getSettings().then(function (stg) {
        //    log("settings loaded!");
        //});

        vm.resetcache = function () {
            administrationApi.pagesTree().then(function (data) {
                vm.tree = data;
            });

        }

        function menuItemClick(node, $event) {
            $event.stopPropagation();
            $event.preventDefault();
            if (node.IsDir) {
                node.expanded = !node.expanded;
                return;
            }
            vm.selectedPage = node.Path;
        }
    }
    
})();