﻿(function () {

    angular.module("WizdomMobileModule").controller("exploreLinksAdminController", exploreLinksAdminController);

    exploreLinksAdminController.$inject = ["$scope", "$window", "$modal", "$timeout", "settingsApi"];

    function exploreLinksAdminController($scope, $window, $modal, $timeout, settingsApi) {
        var vm = this;

        // Properties
        vm.rowLimit = 10;
        vm.newLinkobj = {};
        vm.showEditMode = false;

        // Load settings
        settingsApi.getSettings('ExploreLinks').then(function (response) {
            vm.settings = response;
            vm.settings.linkCollection = vm.settings.linkCollection || [];
        });

        // Public methods
        vm.addLink = addLink;
        vm.editLink = editLink;
        vm.deleteLink = deleteLink;

        function addLink() {
            $modal.open({
                templateUrl: 'WizdomMobileModule/App_Admin/Administration/Modules/ExploreLinks/Templates/ExploreLinksAddTemplate.html',
                controller: 'exploreLinksAddController as exploreLinksAddCtrl',
                windowClass: 'bootstrap-wrapper',
                resolve: {
                    editLinkObjMaster: function () { return null; }
                }
            }).result.then(function (data) {
                vm.settings.linkCollection.push(data);
                vm.saveSettings();
            });
        };

        function editLink(link) {
            $modal.open({
                templateUrl: 'WizdomMobileModule/App_Admin/Administration/Modules/ExploreLinks/Templates/ExploreLinksEditTemplate.html',
                controller: 'exploreLinksEditController as exploreLinksEditCtrl',
                windowClass: 'bootstrap-wrapper',
                resolve: {
                    editLinkObjMaster: function () { return link; }
                }
            }).result.then(function (data) {
                var index = vm.settings.linkCollection.indexOf(data.editLinkObjMaster);
                angular.copy(data.editLinkObj, vm.settings.linkCollection[index]);
                vm.saveSettings();
            });
        };

        function deleteLink(link) {
            var confirm = $window.confirm("Are you absolutely sure you want to delete?");

            if (confirm) {
                var index = vm.settings.linkCollection.indexOf(link);
                vm.settings.linkCollection.splice(index, 1);
                vm.saveSettings();
            }
        };

        vm.saveSettings = function (componentName, settings) {
            vm.saving = true;
            settingsApi.saveSettings(componentName, settings).then(function () {
                // Timeouts for UX actually see the saving messaged
                $timeout(function () {
                    vm.saving = false;
                }, 1000);
            }, function () {
                // handle errors?
            });
        };
    }
})();