﻿(function () {

    angular.module("WizdomMobileModule").controller("contentPagesAddController", contentPagesAddController);

    contentPagesAddController.$inject = ["$scope", "$window", "guidGenerator", "$modalInstance", "editContentPageObjMaster"];

    function contentPagesAddController($scope, $window, guidGenerator, $modalInstance, editContentPageObjMaster) {
        var vm = this;
       
        // Properties
        vm.newContentPageObj = {
            guid: guidGenerator.newGuid(),
            title: '',
            summary: '',
            imagePath: '',
            content: '',
            links: []
        };
        vm.link = '';
        if (editContentPageObjMaster != null) vm.editContentPageObj = angular.copy(editContentPageObjMaster);

        // Public methods
        vm.createContent = createContent;
        vm.cancel = cancel;
        vm.pushLink = pushLink;
        vm.removeLink = removeLink;

        // Private Methods

        function pushLink(link) {
            link.guid = guidGenerator.newGuid();
            $scope.$watch(vm.newContentPageObj.links, function () {

                vm.newContentPageObj.links.push(link);
                vm.link = '';
            });
        }
        function removeLink(index) {
            $scope.$watch(vm.newContentPageObj.links, function () {
                vm.newContentPageObj.links.splice(index, 1);
            });
        }   

        function createContent() {
            if (vm.newContentPageObj.title) {
                vm.newContentPageObj.visible = vm.newContentPageObj.visible || false;

                $modalInstance.close(vm.newContentPageObj);
            }
        }

        function cancel() {
            $modalInstance.dismiss('cancel');
        };

        //Helper functions
        function guid() {
            function s4() {
                return Math.floor((1 + Math.random()) * 0x10000)
                    .toString(16)
                    .substring(1);
            }
            return s4() + s4() + s4() + s4() + '-' + s4() + s4() + s4() + '-' + s4() + '-' + s4() + s4() + '-' + s4() + s4();
        }
    }
})();