﻿(function () {
    angular.module('WizdomMobileModule').controller('peopleModalController', ['$scope', '$state', '$stateParams', '$modal', 'peopleSettings',
        function ($scope, $state, $stateParams, $modal, peopleSettings) {
            // Go to parent state if no user was sent
            if ($stateParams.user === null) {
                $state.go('^', {}, { location: 'replace' });
                return;
            }

            // Open modal
            var modalInstance = $modal.open({
                controller: ['$scope', '$window', 'user', function ($scope, $window, user) {
                    $scope.user = user;
                    $scope.enableLinkToDelve = peopleSettings.enableLinkToDelve || false;

                    $scope.back = function () {
                        $window.history.back();
                    };
                }],
                templateUrl: 'WizdomMobileModule/App/Views/People/Templates/People_Modal.html',
                resolve: {
                    user: function () {
                        return $stateParams.user;
                    }
                },
                backdrop: false,
                windowClass: 'mobile-modal phonebook-modal'
            });

            // Make sure modal is closed when scope is destroyed
            $scope.$on('$destroy', function () {
                modalInstance.dismiss();
            });
        }]
    );
})();