﻿(function () {
    angular.module('WizdomMobileModule').controller('articleViewerController', ['$scope', '$window', '$state', '$stateParams','$sce', 'wizdomSocialService', 'noticeboardService',
        function ($scope, $window, $state, $stateParams, $sce, wizdomSocialService, noticeboardService) {

            // Properties
            $scope.itemId = $stateParams.id;
            $scope.title = $stateParams.title;
            $scope.item = $stateParams.item;
            $scope.type = $stateParams.type;
            $scope.activeSlidePanel = function () { return true; };
            $scope.socialItemId;
            $scope.socialItem;

            // Methods
            $scope.setRead = setRead;
            $scope.setUnread = setUnread;

            // Private methods
            function initialize() {
                switch ($state.current.name.toLowerCase()) {
                    case 'home.article':
                    case 'news.article':
                        if ($scope.item.extendedProperties.promotedState === '2') {
                            initializeModernNewsArticle();
                        }
                        else {
                            initializeClassicNewsArticle();
                            logSPAnalyticsEvent();
                        }
                        
                        break;
                    case 'noticeboard.article':
                        if ($scope.item) {
                            initializeNoticeboardArticle();
                        }
                        else {
                            retrieveNoticeboardItem();
                        }
                        break;
                    default:
                        break;
                }
            }
            initialize();

            function initializeNoticeboardArticle() {
                // Init social
                $scope.socialItemId = $scope.itemId;
                //initializeWizdomSocial(1);

                // Set read on initial load
                $scope.setRead();
            }

            function setRead() {
                noticeboardService.putReadStatus($scope.item.id, true).then(function (response) {
                    $scope.item.isRead = true;
                });
            }

            function setUnread() {
                noticeboardService.putReadStatus($scope.item.id, false).then(function (response) {
                    $scope.item.isRead = false;
                });
            }

            function initializeModernNewsArticle() {
                
            }

            function initializeClassicNewsArticle() {
                // Init social
                $scope.socialItemId = $scope.itemId + '{' + $stateParams.item.extendedProperties.listID + '}';
                //initializeWizdomSocial(3);
            }

            //function initializeWizdomSocial(itemType) {
            //    wizdomSocialService.getSocialOverview($scope.socialItemId, itemType).then(function (response) {
            //        $scope.socialItem = response;
            //    });
            //}

            function retrieveNoticeboardItem() {
                noticeboardService.getItemById($scope.itemId).then(function (response) {
                    $scope.item = response.newsItem;
                    initializeNoticeboardArticle();
                });
            }

            function logSPAnalyticsEvent() {
                SP.SOD.executeOrDelayUntilScriptLoaded(function () {

                    var ctx = new SP.ClientContext($scope.item.extendedProperties.spSiteUrl);
                    var user = ctx.get_web().get_currentUser();
                    var scope = "{00000000-0000-0000-0000-000000000000}";
                    var site = ctx.get_site();
                    var list = ctx.get_web().get_lists().getById($scope.item.extendedProperties.listID);

                    ctx.load(user);
                    ctx.load(site);
                    ctx.load(list);

                    ctx.executeQueryAsync(function () {
                        var siteId = site.get_id();
                        var listTitle = list.get_title();
                        var itemUrl = $scope.item.extendedProperties.spSiteUrl + "/" + listTitle + "/Forms/DispForm.aspx?ID=" + $scope.item.extendedProperties.listItemId;
                        console.log(itemUrl);

                        SP.Analytics.AnalyticsUsageEntry.logAnalyticsEvent2(ctx, 1, itemUrl, scope, siteId, user);

                        ctx.executeQueryAsync(
                            function () {
                                console.log('Logged ' + itemUrl);
                            },
                            function (s, a) {
                                console.log(a.get_message());
                            });

                    }, function (s, a) {
                        console.log(a.get_message());
                    });
                }, 'SP.js');
            }
        }]
    );
})();