﻿(function () {
    angular.module("WizdomMobileModule").run(["$rootScope", "settingsApi", "colorShadeService",
        function ($rootScope, settingsApi, colorShadeService) {

            // Set theme
            settingsApi.getSettings('Theme').then(function (response) {

                var defaultTheme = {
                    name: 'Charcoal',
                    primaryColor: '#515151',
                    primaryFontColor: '#ffffff',
                    secondaryColor: '#a4a4a4',
                    secondaryFontColor: '#ffffff'
                };
                var defaultFont = {
                    name: 'Segoe',
                    primaryFont: 'Segoe UI, Sans-serif'
                };

                $rootScope.customization = {
                    theme: response.selectedTheme || defaultTheme,
                    font: response.selectedFont || defaultFont
                };

                function setTheme() {

                    for (key in $rootScope.customization) {
                        for (i in $rootScope.customization[key]) {
                            if (i === 'primaryColor') {
                                document.documentElement.style.setProperty('--' + i, $rootScope.customization[key][i]);
                                document.documentElement.style.setProperty('--primaryShade', colorShadeService.shadeColor($rootScope.customization[key][i], 0.2));
                                if (window.invokeCSharpAction) {
                                    window.invokeCSharpAction('setPrimaryColor:' + $rootScope.customization[key][i]);
                                }
                            } else {
                                document.documentElement.style.setProperty('--' + i, $rootScope.customization[key][i]);
                            }
                        }
                    }
                }
                setTheme();
            });
        }
    ]);
})();